import {
  __commonJS
} from "./chunk-6TJCVOLN.js";

// ../node_modules/tinymce/themes/silver/theme.js
var require_theme = __commonJS({
  "../node_modules/tinymce/themes/silver/theme.js"() {
    (function() {
      "use strict";
      const getPrototypeOf$2 = Object.getPrototypeOf;
      const hasProto = (v, constructor, predicate) => {
        var _a;
        if (predicate(v, constructor.prototype)) {
          return true;
        } else {
          return ((_a = v.constructor) === null || _a === void 0 ? void 0 : _a.name) === constructor.name;
        }
      };
      const typeOf = (x) => {
        const t2 = typeof x;
        if (x === null) {
          return "null";
        } else if (t2 === "object" && Array.isArray(x)) {
          return "array";
        } else if (t2 === "object" && hasProto(x, String, (o, proto) => proto.isPrototypeOf(o))) {
          return "string";
        } else {
          return t2;
        }
      };
      const isType$1 = (type2) => (value2) => typeOf(value2) === type2;
      const isSimpleType = (type2) => (value2) => typeof value2 === type2;
      const eq$1 = (t2) => (a) => t2 === a;
      const is$2 = (value2, constructor) => isObject(value2) && hasProto(value2, constructor, (o, proto) => getPrototypeOf$2(o) === proto);
      const isString = isType$1("string");
      const isObject = isType$1("object");
      const isPlainObject = (value2) => is$2(value2, Object);
      const isArray = isType$1("array");
      const isNull = eq$1(null);
      const isBoolean = isSimpleType("boolean");
      const isUndefined = eq$1(void 0);
      const isNullable = (a) => a === null || a === void 0;
      const isNonNullable = (a) => !isNullable(a);
      const isFunction = isSimpleType("function");
      const isNumber = isSimpleType("number");
      const isArrayOf = (value2, pred) => {
        if (isArray(value2)) {
          for (let i = 0, len = value2.length; i < len; ++i) {
            if (!pred(value2[i])) {
              return false;
            }
          }
          return true;
        }
        return false;
      };
      const noop = () => {
      };
      const noarg = (f2) => () => f2();
      const compose = (fa, fb) => {
        return (...args) => {
          return fa(fb.apply(null, args));
        };
      };
      const compose1 = (fbc, fab) => (a) => fbc(fab(a));
      const constant$1 = (value2) => {
        return () => {
          return value2;
        };
      };
      const identity = (x) => {
        return x;
      };
      const tripleEquals = (a, b2) => {
        return a === b2;
      };
      function curry(fn, ...initialArgs) {
        return (...restArgs) => {
          const all2 = initialArgs.concat(restArgs);
          return fn.apply(null, all2);
        };
      }
      const not = (f2) => (t2) => !f2(t2);
      const die = (msg) => {
        return () => {
          throw new Error(msg);
        };
      };
      const apply$1 = (f2) => {
        return f2();
      };
      const never = constant$1(false);
      const always = constant$1(true);
      class Optional {
        // The internal representation has a `tag` and a `value`, but both are
        // private: able to be console.logged, but not able to be accessed by code
        constructor(tag, value2) {
          this.tag = tag;
          this.value = value2;
        }
        // --- Identities ---
        /**
         * Creates a new `Optional<T>` that **does** contain a value.
         */
        static some(value2) {
          return new Optional(true, value2);
        }
        /**
         * Create a new `Optional<T>` that **does not** contain a value. `T` can be
         * any type because we don't actually have a `T`.
         */
        static none() {
          return Optional.singletonNone;
        }
        /**
         * Perform a transform on an `Optional` type. Regardless of whether this
         * `Optional` contains a value or not, `fold` will return a value of type `U`.
         * If this `Optional` does not contain a value, the `U` will be created by
         * calling `onNone`. If this `Optional` does contain a value, the `U` will be
         * created by calling `onSome`.
         *
         * For the FP enthusiasts in the room, this function:
         * 1. Could be used to implement all of the functions below
         * 2. Forms a catamorphism
         */
        fold(onNone, onSome) {
          if (this.tag) {
            return onSome(this.value);
          } else {
            return onNone();
          }
        }
        /**
         * Determine if this `Optional` object contains a value.
         */
        isSome() {
          return this.tag;
        }
        /**
         * Determine if this `Optional` object **does not** contain a value.
         */
        isNone() {
          return !this.tag;
        }
        // --- Functor (name stolen from Haskell / maths) ---
        /**
         * Perform a transform on an `Optional` object, **if** there is a value. If
         * you provide a function to turn a T into a U, this is the function you use
         * to turn an `Optional<T>` into an `Optional<U>`. If this **does** contain
         * a value then the output will also contain a value (that value being the
         * output of `mapper(this.value)`), and if this **does not** contain a value
         * then neither will the output.
         */
        map(mapper) {
          if (this.tag) {
            return Optional.some(mapper(this.value));
          } else {
            return Optional.none();
          }
        }
        // --- Monad (name stolen from Haskell / maths) ---
        /**
         * Perform a transform on an `Optional` object, **if** there is a value.
         * Unlike `map`, here the transform itself also returns an `Optional`.
         */
        bind(binder2) {
          if (this.tag) {
            return binder2(this.value);
          } else {
            return Optional.none();
          }
        }
        // --- Traversable (name stolen from Haskell / maths) ---
        /**
         * For a given predicate, this function finds out if there **exists** a value
         * inside this `Optional` object that meets the predicate. In practice, this
         * means that for `Optional`s that do not contain a value it returns false (as
         * no predicate-meeting value exists).
         */
        exists(predicate) {
          return this.tag && predicate(this.value);
        }
        /**
         * For a given predicate, this function finds out if **all** the values inside
         * this `Optional` object meet the predicate. In practice, this means that
         * for `Optional`s that do not contain a value it returns true (as all 0
         * objects do meet the predicate).
         */
        forall(predicate) {
          return !this.tag || predicate(this.value);
        }
        filter(predicate) {
          if (!this.tag || predicate(this.value)) {
            return this;
          } else {
            return Optional.none();
          }
        }
        // --- Getters ---
        /**
         * Get the value out of the inside of the `Optional` object, using a default
         * `replacement` value if the provided `Optional` object does not contain a
         * value.
         */
        getOr(replacement) {
          return this.tag ? this.value : replacement;
        }
        /**
         * Get the value out of the inside of the `Optional` object, using a default
         * `replacement` value if the provided `Optional` object does not contain a
         * value.  Unlike `getOr`, in this method the `replacement` object is also
         * `Optional` - meaning that this method will always return an `Optional`.
         */
        or(replacement) {
          return this.tag ? this : replacement;
        }
        /**
         * Get the value out of the inside of the `Optional` object, using a default
         * `replacement` value if the provided `Optional` object does not contain a
         * value. Unlike `getOr`, in this method the `replacement` value is
         * "thunked" - that is to say that you don't pass a value to `getOrThunk`, you
         * pass a function which (if called) will **return** the `value` you want to
         * use.
         */
        getOrThunk(thunk2) {
          return this.tag ? this.value : thunk2();
        }
        /**
         * Get the value out of the inside of the `Optional` object, using a default
         * `replacement` value if the provided Optional object does not contain a
         * value.
         *
         * Unlike `or`, in this method the `replacement` value is "thunked" - that is
         * to say that you don't pass a value to `orThunk`, you pass a function which
         * (if called) will **return** the `value` you want to use.
         *
         * Unlike `getOrThunk`, in this method the `replacement` value is also
         * `Optional`, meaning that this method will always return an `Optional`.
         */
        orThunk(thunk2) {
          return this.tag ? this : thunk2();
        }
        /**
         * Get the value out of the inside of the `Optional` object, throwing an
         * exception if the provided `Optional` object does not contain a value.
         *
         * WARNING:
         * You should only be using this function if you know that the `Optional`
         * object **is not** empty (otherwise you're throwing exceptions in production
         * code, which is bad).
         *
         * In tests this is more acceptable.
         *
         * Prefer other methods to this, such as `.each`.
         */
        getOrDie(message) {
          if (!this.tag) {
            throw new Error(message !== null && message !== void 0 ? message : "Called getOrDie on None");
          } else {
            return this.value;
          }
        }
        // --- Interop with null and undefined ---
        /**
         * Creates an `Optional` value from a nullable (or undefined-able) input.
         * Null, or undefined, is converted to `None`, and anything else is converted
         * to `Some`.
         */
        static from(value2) {
          return isNonNullable(value2) ? Optional.some(value2) : Optional.none();
        }
        /**
         * Converts an `Optional` to a nullable type, by getting the value if it
         * exists, or returning `null` if it does not.
         */
        getOrNull() {
          return this.tag ? this.value : null;
        }
        /**
         * Converts an `Optional` to an undefined-able type, by getting the value if
         * it exists, or returning `undefined` if it does not.
         */
        getOrUndefined() {
          return this.value;
        }
        // --- Utilities ---
        /**
         * If the `Optional` contains a value, perform an action on that value.
         * Unlike the rest of the methods on this type, `.each` has side-effects. If
         * you want to transform an `Optional<T>` **into** something, then this is not
         * the method for you. If you want to use an `Optional<T>` to **do**
         * something, then this is the method for you - provided you're okay with not
         * doing anything in the case where the `Optional` doesn't have a value inside
         * it. If you're not sure whether your use-case fits into transforming
         * **into** something or **doing** something, check whether it has a return
         * value. If it does, you should be performing a transform.
         */
        each(worker) {
          if (this.tag) {
            worker(this.value);
          }
        }
        /**
         * Turn the `Optional` object into an array that contains all of the values
         * stored inside the `Optional`. In practice, this means the output will have
         * either 0 or 1 elements.
         */
        toArray() {
          return this.tag ? [this.value] : [];
        }
        /**
         * Turn the `Optional` object into a string for debugging or printing. Not
         * recommended for production code, but good for debugging. Also note that
         * these days an `Optional` object can be logged to the console directly, and
         * its inner value (if it exists) will be visible.
         */
        toString() {
          return this.tag ? `some(${this.value})` : "none()";
        }
      }
      Optional.singletonNone = new Optional(false);
      const nativeSlice = Array.prototype.slice;
      const nativeIndexOf = Array.prototype.indexOf;
      const nativePush = Array.prototype.push;
      const rawIndexOf = (ts, t2) => nativeIndexOf.call(ts, t2);
      const indexOf = (xs, x) => {
        const r2 = rawIndexOf(xs, x);
        return r2 === -1 ? Optional.none() : Optional.some(r2);
      };
      const contains$2 = (xs, x) => rawIndexOf(xs, x) > -1;
      const exists = (xs, pred) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            return true;
          }
        }
        return false;
      };
      const range$2 = (num, f2) => {
        const r2 = [];
        for (let i = 0; i < num; i++) {
          r2.push(f2(i));
        }
        return r2;
      };
      const chunk$1 = (array, size) => {
        const r2 = [];
        for (let i = 0; i < array.length; i += size) {
          const s = nativeSlice.call(array, i, i + size);
          r2.push(s);
        }
        return r2;
      };
      const map$2 = (xs, f2) => {
        const len = xs.length;
        const r2 = new Array(len);
        for (let i = 0; i < len; i++) {
          const x = xs[i];
          r2[i] = f2(x, i);
        }
        return r2;
      };
      const each$1 = (xs, f2) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          f2(x, i);
        }
      };
      const eachr = (xs, f2) => {
        for (let i = xs.length - 1; i >= 0; i--) {
          const x = xs[i];
          f2(x, i);
        }
      };
      const partition$3 = (xs, pred) => {
        const pass = [];
        const fail = [];
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          const arr = pred(x, i) ? pass : fail;
          arr.push(x);
        }
        return { pass, fail };
      };
      const filter$2 = (xs, pred) => {
        const r2 = [];
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            r2.push(x);
          }
        }
        return r2;
      };
      const foldr = (xs, f2, acc) => {
        eachr(xs, (x, i) => {
          acc = f2(acc, x, i);
        });
        return acc;
      };
      const foldl = (xs, f2, acc) => {
        each$1(xs, (x, i) => {
          acc = f2(acc, x, i);
        });
        return acc;
      };
      const findUntil = (xs, pred, until) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            return Optional.some(x);
          } else if (until(x, i)) {
            break;
          }
        }
        return Optional.none();
      };
      const find$5 = (xs, pred) => {
        return findUntil(xs, pred, never);
      };
      const findIndex$1 = (xs, pred) => {
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          if (pred(x, i)) {
            return Optional.some(i);
          }
        }
        return Optional.none();
      };
      const flatten = (xs) => {
        const r2 = [];
        for (let i = 0, len = xs.length; i < len; ++i) {
          if (!isArray(xs[i])) {
            throw new Error("Arr.flatten item " + i + " was not an array, input: " + xs);
          }
          nativePush.apply(r2, xs[i]);
        }
        return r2;
      };
      const bind$3 = (xs, f2) => flatten(map$2(xs, f2));
      const forall = (xs, pred) => {
        for (let i = 0, len = xs.length; i < len; ++i) {
          const x = xs[i];
          if (pred(x, i) !== true) {
            return false;
          }
        }
        return true;
      };
      const reverse = (xs) => {
        const r2 = nativeSlice.call(xs, 0);
        r2.reverse();
        return r2;
      };
      const difference = (a1, a2) => filter$2(a1, (x) => !contains$2(a2, x));
      const mapToObject = (xs, f2) => {
        const r2 = {};
        for (let i = 0, len = xs.length; i < len; i++) {
          const x = xs[i];
          r2[String(x)] = f2(x, i);
        }
        return r2;
      };
      const pure$2 = (x) => [x];
      const sort = (xs, comparator) => {
        const copy = nativeSlice.call(xs, 0);
        copy.sort(comparator);
        return copy;
      };
      const get$i = (xs, i) => i >= 0 && i < xs.length ? Optional.some(xs[i]) : Optional.none();
      const head = (xs) => get$i(xs, 0);
      const last$1 = (xs) => get$i(xs, xs.length - 1);
      const from = isFunction(Array.from) ? Array.from : (x) => nativeSlice.call(x);
      const findMap = (arr, f2) => {
        for (let i = 0; i < arr.length; i++) {
          const r2 = f2(arr[i], i);
          if (r2.isSome()) {
            return r2;
          }
        }
        return Optional.none();
      };
      const keys = Object.keys;
      const hasOwnProperty = Object.hasOwnProperty;
      const each = (obj, f2) => {
        const props = keys(obj);
        for (let k = 0, len = props.length; k < len; k++) {
          const i = props[k];
          const x = obj[i];
          f2(x, i);
        }
      };
      const map$1 = (obj, f2) => {
        return tupleMap(obj, (x, i) => ({
          k: i,
          v: f2(x, i)
        }));
      };
      const tupleMap = (obj, f2) => {
        const r2 = {};
        each(obj, (x, i) => {
          const tuple = f2(x, i);
          r2[tuple.k] = tuple.v;
        });
        return r2;
      };
      const objAcc = (r2) => (x, i) => {
        r2[i] = x;
      };
      const internalFilter = (obj, pred, onTrue, onFalse) => {
        each(obj, (x, i) => {
          (pred(x, i) ? onTrue : onFalse)(x, i);
        });
      };
      const bifilter = (obj, pred) => {
        const t2 = {};
        const f2 = {};
        internalFilter(obj, pred, objAcc(t2), objAcc(f2));
        return { t: t2, f: f2 };
      };
      const filter$1 = (obj, pred) => {
        const t2 = {};
        internalFilter(obj, pred, objAcc(t2), noop);
        return t2;
      };
      const mapToArray = (obj, f2) => {
        const r2 = [];
        each(obj, (value2, name2) => {
          r2.push(f2(value2, name2));
        });
        return r2;
      };
      const find$4 = (obj, pred) => {
        const props = keys(obj);
        for (let k = 0, len = props.length; k < len; k++) {
          const i = props[k];
          const x = obj[i];
          if (pred(x, i, obj)) {
            return Optional.some(x);
          }
        }
        return Optional.none();
      };
      const values = (obj) => {
        return mapToArray(obj, identity);
      };
      const get$h = (obj, key) => {
        return has$2(obj, key) ? Optional.from(obj[key]) : Optional.none();
      };
      const has$2 = (obj, key) => hasOwnProperty.call(obj, key);
      const hasNonNullableKey = (obj, key) => has$2(obj, key) && obj[key] !== void 0 && obj[key] !== null;
      const generate$7 = (cases) => {
        if (!isArray(cases)) {
          throw new Error("cases must be an array");
        }
        if (cases.length === 0) {
          throw new Error("there must be at least one case");
        }
        const constructors = [];
        const adt2 = {};
        each$1(cases, (acase, count) => {
          const keys$1 = keys(acase);
          if (keys$1.length !== 1) {
            throw new Error("one and only one name per case");
          }
          const key = keys$1[0];
          const value2 = acase[key];
          if (adt2[key] !== void 0) {
            throw new Error("duplicate key detected:" + key);
          } else if (key === "cata") {
            throw new Error("cannot have a case named cata (sorry)");
          } else if (!isArray(value2)) {
            throw new Error("case arguments must be an array");
          }
          constructors.push(key);
          adt2[key] = (...args) => {
            const argLength = args.length;
            if (argLength !== value2.length) {
              throw new Error("Wrong number of arguments to case " + key + ". Expected " + value2.length + " (" + value2 + "), got " + argLength);
            }
            const match = (branches) => {
              const branchKeys = keys(branches);
              if (constructors.length !== branchKeys.length) {
                throw new Error("Wrong number of arguments to match. Expected: " + constructors.join(",") + "\nActual: " + branchKeys.join(","));
              }
              const allReqd = forall(constructors, (reqKey) => {
                return contains$2(branchKeys, reqKey);
              });
              if (!allReqd) {
                throw new Error("Not all branches were specified when using match. Specified: " + branchKeys.join(", ") + "\nRequired: " + constructors.join(", "));
              }
              return branches[key].apply(null, args);
            };
            return {
              fold: (...foldArgs) => {
                if (foldArgs.length !== cases.length) {
                  throw new Error("Wrong number of arguments to fold. Expected " + cases.length + ", got " + foldArgs.length);
                }
                const target = foldArgs[count];
                return target.apply(null, args);
              },
              match,
              // NOTE: Only for debugging.
              log: (label2) => {
                console.log(label2, {
                  constructors,
                  constructor: key,
                  params: args
                });
              }
            };
          };
        });
        return adt2;
      };
      const Adt = {
        generate: generate$7
      };
      const Cell = (initial) => {
        let value2 = initial;
        const get2 = () => {
          return value2;
        };
        const set2 = (v) => {
          value2 = v;
        };
        return {
          get: get2,
          set: set2
        };
      };
      const nu$d = (baseFn) => {
        let data = Optional.none();
        let callbacks = [];
        const map2 = (f2) => nu$d((nCallback) => {
          get2((data2) => {
            nCallback(f2(data2));
          });
        });
        const get2 = (nCallback) => {
          if (isReady()) {
            call(nCallback);
          } else {
            callbacks.push(nCallback);
          }
        };
        const set2 = (x) => {
          if (!isReady()) {
            data = Optional.some(x);
            run2(callbacks);
            callbacks = [];
          }
        };
        const isReady = () => data.isSome();
        const run2 = (cbs) => {
          each$1(cbs, call);
        };
        const call = (cb) => {
          data.each((x) => {
            setTimeout(() => {
              cb(x);
            }, 0);
          });
        };
        baseFn(set2);
        return {
          get: get2,
          map: map2,
          isReady
        };
      };
      const pure$1 = (a) => nu$d((callback) => {
        callback(a);
      });
      const LazyValue = {
        nu: nu$d,
        pure: pure$1
      };
      const errorReporter = (err) => {
        setTimeout(() => {
          throw err;
        }, 0);
      };
      const make$8 = (run2) => {
        const get2 = (callback) => {
          run2().then(callback, errorReporter);
        };
        const map2 = (fab) => {
          return make$8(() => run2().then(fab));
        };
        const bind2 = (aFutureB) => {
          return make$8(() => run2().then((v) => aFutureB(v).toPromise()));
        };
        const anonBind = (futureB) => {
          return make$8(() => run2().then(() => futureB.toPromise()));
        };
        const toLazy = () => {
          return LazyValue.nu(get2);
        };
        const toCached = () => {
          let cache = null;
          return make$8(() => {
            if (cache === null) {
              cache = run2();
            }
            return cache;
          });
        };
        const toPromise = run2;
        return {
          map: map2,
          bind: bind2,
          anonBind,
          toLazy,
          toCached,
          toPromise,
          get: get2
        };
      };
      const nu$c = (baseFn) => {
        return make$8(() => new Promise(baseFn));
      };
      const pure = (a) => {
        return make$8(() => Promise.resolve(a));
      };
      const Future = {
        nu: nu$c,
        pure
      };
      const value$4 = (value2) => {
        const applyHelper = (fn) => fn(value2);
        const constHelper = constant$1(value2);
        const outputHelper = () => output2;
        const output2 = {
          // Debug info
          tag: true,
          inner: value2,
          // Actual Result methods
          fold: (_onError, onValue) => onValue(value2),
          isValue: always,
          isError: never,
          map: (mapper) => Result.value(mapper(value2)),
          mapError: outputHelper,
          bind: applyHelper,
          exists: applyHelper,
          forall: applyHelper,
          getOr: constHelper,
          or: outputHelper,
          getOrThunk: constHelper,
          orThunk: outputHelper,
          getOrDie: constHelper,
          each: (fn) => {
            fn(value2);
          },
          toOptional: () => Optional.some(value2)
        };
        return output2;
      };
      const error$1 = (error2) => {
        const outputHelper = () => output2;
        const output2 = {
          // Debug info
          tag: false,
          inner: error2,
          // Actual Result methods
          fold: (onError, _onValue) => onError(error2),
          isValue: never,
          isError: always,
          map: outputHelper,
          mapError: (mapper) => Result.error(mapper(error2)),
          bind: outputHelper,
          exists: never,
          forall: always,
          getOr: identity,
          or: identity,
          getOrThunk: apply$1,
          orThunk: apply$1,
          getOrDie: die(String(error2)),
          each: noop,
          toOptional: Optional.none
        };
        return output2;
      };
      const fromOption = (optional2, err) => optional2.fold(() => error$1(err), value$4);
      const Result = {
        value: value$4,
        error: error$1,
        fromOption
      };
      const wrap$2 = (delegate) => {
        const toCached = () => {
          return wrap$2(delegate.toCached());
        };
        const bindFuture = (f2) => {
          return wrap$2(delegate.bind((resA) => resA.fold((err) => Future.pure(Result.error(err)), (a) => f2(a))));
        };
        const bindResult = (f2) => {
          return wrap$2(delegate.map((resA) => resA.bind(f2)));
        };
        const mapResult = (f2) => {
          return wrap$2(delegate.map((resA) => resA.map(f2)));
        };
        const mapError2 = (f2) => {
          return wrap$2(delegate.map((resA) => resA.mapError(f2)));
        };
        const foldResult = (whenError, whenValue) => {
          return delegate.map((res) => res.fold(whenError, whenValue));
        };
        const withTimeout = (timeout, errorThunk) => {
          return wrap$2(Future.nu((callback) => {
            let timedOut = false;
            const timer = setTimeout(() => {
              timedOut = true;
              callback(Result.error(errorThunk()));
            }, timeout);
            delegate.get((result) => {
              if (!timedOut) {
                clearTimeout(timer);
                callback(result);
              }
            });
          }));
        };
        return {
          ...delegate,
          toCached,
          bindFuture,
          bindResult,
          mapResult,
          mapError: mapError2,
          foldResult,
          withTimeout
        };
      };
      const nu$b = (worker) => {
        return wrap$2(Future.nu(worker));
      };
      const value$3 = (value2) => {
        return wrap$2(Future.pure(Result.value(value2)));
      };
      const error = (error2) => {
        return wrap$2(Future.pure(Result.error(error2)));
      };
      const fromResult$1 = (result) => {
        return wrap$2(Future.pure(result));
      };
      const fromFuture = (future) => {
        return wrap$2(future.map(Result.value));
      };
      const fromPromise = (promise) => {
        return nu$b((completer) => {
          promise.then((value2) => {
            completer(Result.value(value2));
          }, (error2) => {
            completer(Result.error(error2));
          });
        });
      };
      const FutureResult = {
        nu: nu$b,
        wrap: wrap$2,
        pure: value$3,
        value: value$3,
        error,
        fromResult: fromResult$1,
        fromFuture,
        fromPromise
      };
      const Global = typeof window !== "undefined" ? window : Function("return this;")();
      const cycleBy = (value2, delta, min2, max2) => {
        const r2 = value2 + delta;
        if (r2 > max2) {
          return min2;
        } else if (r2 < min2) {
          return max2;
        } else {
          return r2;
        }
      };
      const clamp = (value2, min2, max2) => Math.min(Math.max(value2, min2), max2);
      const random = () => window.crypto.getRandomValues(new Uint32Array(1))[0] / 4294967295;
      let unique = 0;
      const generate$6 = (prefix2) => {
        const date = /* @__PURE__ */ new Date();
        const time = date.getTime();
        const random$1 = Math.floor(random() * 1e9);
        unique++;
        return prefix2 + "_" + random$1 + unique + String(time);
      };
      const shallow$1 = (old, nu2) => {
        return nu2;
      };
      const deep$1 = (old, nu2) => {
        const bothObjects = isPlainObject(old) && isPlainObject(nu2);
        return bothObjects ? deepMerge(old, nu2) : nu2;
      };
      const baseMerge = (merger) => {
        return (...objects) => {
          if (objects.length === 0) {
            throw new Error(`Can't merge zero objects`);
          }
          const ret = {};
          for (let j = 0; j < objects.length; j++) {
            const curObject = objects[j];
            for (const key in curObject) {
              if (has$2(curObject, key)) {
                ret[key] = merger(ret[key], curObject[key]);
              }
            }
          }
          return ret;
        };
      };
      const deepMerge = baseMerge(deep$1);
      const merge$1 = baseMerge(shallow$1);
      const is$1 = (lhs, rhs, comparator = tripleEquals) => lhs.exists((left2) => comparator(left2, rhs));
      const equals = (lhs, rhs, comparator = tripleEquals) => lift2(lhs, rhs, comparator).getOr(lhs.isNone() && rhs.isNone());
      const cat = (arr) => {
        const r2 = [];
        const push = (x) => {
          r2.push(x);
        };
        for (let i = 0; i < arr.length; i++) {
          arr[i].each(push);
        }
        return r2;
      };
      const sequence = (arr) => {
        const r2 = [];
        for (let i = 0; i < arr.length; i++) {
          const x = arr[i];
          if (x.isSome()) {
            r2.push(x.getOrDie());
          } else {
            return Optional.none();
          }
        }
        return Optional.some(r2);
      };
      const lift2 = (oa, ob, f2) => oa.isSome() && ob.isSome() ? Optional.some(f2(oa.getOrDie(), ob.getOrDie())) : Optional.none();
      const lift3 = (oa, ob, oc, f2) => oa.isSome() && ob.isSome() && oc.isSome() ? Optional.some(f2(oa.getOrDie(), ob.getOrDie(), oc.getOrDie())) : Optional.none();
      const mapFrom = (a, f2) => a !== void 0 && a !== null ? Optional.some(f2(a)) : Optional.none();
      const someIf = (b2, a) => b2 ? Optional.some(a) : Optional.none();
      const escape = (text2) => text2.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
      const path$1 = (parts2, scope) => {
        let o = scope !== void 0 && scope !== null ? scope : Global;
        for (let i = 0; i < parts2.length && o !== void 0 && o !== null; ++i) {
          o = o[parts2[i]];
        }
        return o;
      };
      const resolve = (p, scope) => {
        const parts2 = p.split(".");
        return path$1(parts2, scope);
      };
      Adt.generate([
        { bothErrors: ["error1", "error2"] },
        { firstError: ["error1", "value2"] },
        { secondError: ["value1", "error2"] },
        { bothValues: ["value1", "value2"] }
      ]);
      const partition$2 = (results) => {
        const errors = [];
        const values2 = [];
        each$1(results, (result) => {
          result.fold((err) => {
            errors.push(err);
          }, (value2) => {
            values2.push(value2);
          });
        });
        return { errors, values: values2 };
      };
      const singleton$1 = (doRevoke) => {
        const subject = Cell(Optional.none());
        const revoke2 = () => subject.get().each(doRevoke);
        const clear2 = () => {
          revoke2();
          subject.set(Optional.none());
        };
        const isSet = () => subject.get().isSome();
        const get2 = () => subject.get();
        const set2 = (s) => {
          revoke2();
          subject.set(Optional.some(s));
        };
        return {
          clear: clear2,
          isSet,
          get: get2,
          set: set2
        };
      };
      const destroyable = () => singleton$1((s) => s.destroy());
      const unbindable = () => singleton$1((s) => s.unbind());
      const value$2 = () => {
        const subject = singleton$1(noop);
        const on2 = (f2) => subject.get().each(f2);
        return {
          ...subject,
          on: on2
        };
      };
      const addToEnd = (str, suffix2) => {
        return str + suffix2;
      };
      const removeFromStart = (str, numChars) => {
        return str.substring(numChars);
      };
      const checkRange = (str, substr, start) => substr === "" || str.length >= substr.length && str.substr(start, start + substr.length) === substr;
      const removeLeading = (str, prefix2) => {
        return startsWith(str, prefix2) ? removeFromStart(str, prefix2.length) : str;
      };
      const ensureTrailing = (str, suffix2) => {
        return endsWith(str, suffix2) ? str : addToEnd(str, suffix2);
      };
      const contains$1 = (str, substr, start = 0, end) => {
        const idx = str.indexOf(substr, start);
        if (idx !== -1) {
          return isUndefined(end) ? true : idx + substr.length <= end;
        } else {
          return false;
        }
      };
      const startsWith = (str, prefix2) => {
        return checkRange(str, prefix2, 0);
      };
      const endsWith = (str, suffix2) => {
        return checkRange(str, suffix2, str.length - suffix2.length);
      };
      const blank = (r2) => (s) => s.replace(r2, "");
      const trim$1 = blank(/^\s+|\s+$/g);
      const isNotEmpty = (s) => s.length > 0;
      const isEmpty = (s) => !isNotEmpty(s);
      const toFloat = (value2) => {
        const num = parseFloat(value2);
        return isNaN(num) ? Optional.none() : Optional.some(num);
      };
      const adaptable = (fn, rate) => {
        let timer = null;
        let args = null;
        const cancel = () => {
          if (!isNull(timer)) {
            clearTimeout(timer);
            timer = null;
            args = null;
          }
        };
        const throttle2 = (...newArgs) => {
          args = newArgs;
          if (isNull(timer)) {
            timer = setTimeout(() => {
              const tempArgs = args;
              timer = null;
              args = null;
              fn.apply(null, tempArgs);
            }, rate);
          }
        };
        return {
          cancel,
          throttle: throttle2
        };
      };
      const first$1 = (fn, rate) => {
        let timer = null;
        const cancel = () => {
          if (!isNull(timer)) {
            clearTimeout(timer);
            timer = null;
          }
        };
        const throttle2 = (...args) => {
          if (isNull(timer)) {
            timer = setTimeout(() => {
              timer = null;
              fn.apply(null, args);
            }, rate);
          }
        };
        return {
          cancel,
          throttle: throttle2
        };
      };
      const last = (fn, rate) => {
        let timer = null;
        const cancel = () => {
          if (!isNull(timer)) {
            clearTimeout(timer);
            timer = null;
          }
        };
        const throttle2 = (...args) => {
          cancel();
          timer = setTimeout(() => {
            timer = null;
            fn.apply(null, args);
          }, rate);
        };
        return {
          cancel,
          throttle: throttle2
        };
      };
      const cached = (f2) => {
        let called = false;
        let r2;
        return (...args) => {
          if (!called) {
            called = true;
            r2 = f2.apply(null, args);
          }
          return r2;
        };
      };
      const zeroWidth = "\uFEFF";
      const nbsp = " ";
      const fromHtml$2 = (html2, scope) => {
        const doc = scope || document;
        const div = doc.createElement("div");
        div.innerHTML = html2;
        if (!div.hasChildNodes() || div.childNodes.length > 1) {
          const message = "HTML does not have a single root node";
          console.error(message, html2);
          throw new Error(message);
        }
        return fromDom(div.childNodes[0]);
      };
      const fromTag = (tag, scope) => {
        const doc = scope || document;
        const node = doc.createElement(tag);
        return fromDom(node);
      };
      const fromText = (text2, scope) => {
        const doc = scope || document;
        const node = doc.createTextNode(text2);
        return fromDom(node);
      };
      const fromDom = (node) => {
        if (node === null || node === void 0) {
          throw new Error("Node cannot be null or undefined");
        }
        return {
          dom: node
        };
      };
      const fromPoint = (docElm, x, y) => Optional.from(docElm.dom.elementFromPoint(x, y)).map(fromDom);
      const SugarElement = {
        fromHtml: fromHtml$2,
        fromTag,
        fromText,
        fromDom,
        fromPoint
      };
      const setStart = (rng, situ) => {
        situ.fold((e) => {
          rng.setStartBefore(e.dom);
        }, (e, o) => {
          rng.setStart(e.dom, o);
        }, (e) => {
          rng.setStartAfter(e.dom);
        });
      };
      const setFinish = (rng, situ) => {
        situ.fold((e) => {
          rng.setEndBefore(e.dom);
        }, (e, o) => {
          rng.setEnd(e.dom, o);
        }, (e) => {
          rng.setEndAfter(e.dom);
        });
      };
      const relativeToNative = (win2, startSitu, finishSitu) => {
        const range2 = win2.document.createRange();
        setStart(range2, startSitu);
        setFinish(range2, finishSitu);
        return range2;
      };
      const exactToNative = (win2, start, soffset, finish, foffset) => {
        const rng = win2.document.createRange();
        rng.setStart(start.dom, soffset);
        rng.setEnd(finish.dom, foffset);
        return rng;
      };
      const toRect = (rect2) => ({
        left: rect2.left,
        top: rect2.top,
        right: rect2.right,
        bottom: rect2.bottom,
        width: rect2.width,
        height: rect2.height
      });
      const getFirstRect$1 = (rng) => {
        const rects = rng.getClientRects();
        const rect2 = rects.length > 0 ? rects[0] : rng.getBoundingClientRect();
        return rect2.width > 0 || rect2.height > 0 ? Optional.some(rect2).map(toRect) : Optional.none();
      };
      const getBounds$3 = (rng) => {
        const rect2 = rng.getBoundingClientRect();
        return rect2.width > 0 || rect2.height > 0 ? Optional.some(rect2).map(toRect) : Optional.none();
      };
      const adt$a = Adt.generate([
        { ltr: ["start", "soffset", "finish", "foffset"] },
        { rtl: ["start", "soffset", "finish", "foffset"] }
      ]);
      const fromRange = (win2, type2, range2) => type2(SugarElement.fromDom(range2.startContainer), range2.startOffset, SugarElement.fromDom(range2.endContainer), range2.endOffset);
      const getRanges = (win2, selection) => selection.match({
        domRange: (rng) => {
          return {
            ltr: constant$1(rng),
            rtl: Optional.none
          };
        },
        relative: (startSitu, finishSitu) => {
          return {
            ltr: cached(() => relativeToNative(win2, startSitu, finishSitu)),
            rtl: cached(() => Optional.some(relativeToNative(win2, finishSitu, startSitu)))
          };
        },
        exact: (start, soffset, finish, foffset) => {
          return {
            ltr: cached(() => exactToNative(win2, start, soffset, finish, foffset)),
            rtl: cached(() => Optional.some(exactToNative(win2, finish, foffset, start, soffset)))
          };
        }
      });
      const doDiagnose = (win2, ranges) => {
        const rng = ranges.ltr();
        if (rng.collapsed) {
          const reversed = ranges.rtl().filter((rev) => rev.collapsed === false);
          return reversed.map((rev) => (
            // We need to use "reversed" here, because the original only has one point (collapsed)
            adt$a.rtl(SugarElement.fromDom(rev.endContainer), rev.endOffset, SugarElement.fromDom(rev.startContainer), rev.startOffset)
          )).getOrThunk(() => fromRange(win2, adt$a.ltr, rng));
        } else {
          return fromRange(win2, adt$a.ltr, rng);
        }
      };
      const diagnose = (win2, selection) => {
        const ranges = getRanges(win2, selection);
        return doDiagnose(win2, ranges);
      };
      const asLtrRange = (win2, selection) => {
        const diagnosis = diagnose(win2, selection);
        return diagnosis.match({
          ltr: (start, soffset, finish, foffset) => {
            const rng = win2.document.createRange();
            rng.setStart(start.dom, soffset);
            rng.setEnd(finish.dom, foffset);
            return rng;
          },
          rtl: (start, soffset, finish, foffset) => {
            const rng = win2.document.createRange();
            rng.setStart(finish.dom, foffset);
            rng.setEnd(start.dom, soffset);
            return rng;
          }
        });
      };
      adt$a.ltr;
      adt$a.rtl;
      const DOCUMENT = 9;
      const DOCUMENT_FRAGMENT = 11;
      const ELEMENT = 1;
      const TEXT = 3;
      const is = (element2, selector) => {
        const dom2 = element2.dom;
        if (dom2.nodeType !== ELEMENT) {
          return false;
        } else {
          const elem = dom2;
          if (elem.matches !== void 0) {
            return elem.matches(selector);
          } else if (elem.msMatchesSelector !== void 0) {
            return elem.msMatchesSelector(selector);
          } else if (elem.webkitMatchesSelector !== void 0) {
            return elem.webkitMatchesSelector(selector);
          } else if (elem.mozMatchesSelector !== void 0) {
            return elem.mozMatchesSelector(selector);
          } else {
            throw new Error("Browser lacks native selectors");
          }
        }
      };
      const bypassSelector = (dom2) => (
        // Only elements, documents and shadow roots support querySelector
        // shadow root element type is DOCUMENT_FRAGMENT
        dom2.nodeType !== ELEMENT && dom2.nodeType !== DOCUMENT && dom2.nodeType !== DOCUMENT_FRAGMENT || // IE fix for complex queries on empty nodes: http://jsfiddle.net/spyder/fv9ptr5L/
        dom2.childElementCount === 0
      );
      const all$3 = (selector, scope) => {
        const base2 = scope === void 0 ? document : scope.dom;
        return bypassSelector(base2) ? [] : map$2(base2.querySelectorAll(selector), SugarElement.fromDom);
      };
      const one = (selector, scope) => {
        const base2 = scope === void 0 ? document : scope.dom;
        return bypassSelector(base2) ? Optional.none() : Optional.from(base2.querySelector(selector)).map(SugarElement.fromDom);
      };
      const eq = (e1, e2) => e1.dom === e2.dom;
      const contains = (e1, e2) => {
        const d1 = e1.dom;
        const d2 = e2.dom;
        return d1 === d2 ? false : d1.contains(d2);
      };
      const DeviceType = (os, browser2, userAgent, mediaMatch2) => {
        const isiPad = os.isiOS() && /ipad/i.test(userAgent) === true;
        const isiPhone = os.isiOS() && !isiPad;
        const isMobile = os.isiOS() || os.isAndroid();
        const isTouch2 = isMobile || mediaMatch2("(pointer:coarse)");
        const isTablet2 = isiPad || !isiPhone && isMobile && mediaMatch2("(min-device-width:768px)");
        const isPhone2 = isiPhone || isMobile && !isTablet2;
        const iOSwebview = browser2.isSafari() && os.isiOS() && /safari/i.test(userAgent) === false;
        const isDesktop = !isPhone2 && !isTablet2 && !iOSwebview;
        return {
          isiPad: constant$1(isiPad),
          isiPhone: constant$1(isiPhone),
          isTablet: constant$1(isTablet2),
          isPhone: constant$1(isPhone2),
          isTouch: constant$1(isTouch2),
          isAndroid: os.isAndroid,
          isiOS: os.isiOS,
          isWebView: constant$1(iOSwebview),
          isDesktop: constant$1(isDesktop)
        };
      };
      const firstMatch = (regexes, s) => {
        for (let i = 0; i < regexes.length; i++) {
          const x = regexes[i];
          if (x.test(s)) {
            return x;
          }
        }
        return void 0;
      };
      const find$3 = (regexes, agent) => {
        const r2 = firstMatch(regexes, agent);
        if (!r2) {
          return { major: 0, minor: 0 };
        }
        const group2 = (i) => {
          return Number(agent.replace(r2, "$" + i));
        };
        return nu$a(group2(1), group2(2));
      };
      const detect$4 = (versionRegexes, agent) => {
        const cleanedAgent = String(agent).toLowerCase();
        if (versionRegexes.length === 0) {
          return unknown$3();
        }
        return find$3(versionRegexes, cleanedAgent);
      };
      const unknown$3 = () => {
        return nu$a(0, 0);
      };
      const nu$a = (major, minor) => {
        return { major, minor };
      };
      const Version = {
        nu: nu$a,
        detect: detect$4,
        unknown: unknown$3
      };
      const detectBrowser$1 = (browsers2, userAgentData) => {
        return findMap(userAgentData.brands, (uaBrand) => {
          const lcBrand = uaBrand.brand.toLowerCase();
          return find$5(browsers2, (browser2) => {
            var _a;
            return lcBrand === ((_a = browser2.brand) === null || _a === void 0 ? void 0 : _a.toLowerCase());
          }).map((info) => ({
            current: info.name,
            version: Version.nu(parseInt(uaBrand.version, 10), 0)
          }));
        });
      };
      const detect$3 = (candidates, userAgent) => {
        const agent = String(userAgent).toLowerCase();
        return find$5(candidates, (candidate) => {
          return candidate.search(agent);
        });
      };
      const detectBrowser = (browsers2, userAgent) => {
        return detect$3(browsers2, userAgent).map((browser2) => {
          const version = Version.detect(browser2.versionRegexes, userAgent);
          return {
            current: browser2.name,
            version
          };
        });
      };
      const detectOs = (oses2, userAgent) => {
        return detect$3(oses2, userAgent).map((os) => {
          const version = Version.detect(os.versionRegexes, userAgent);
          return {
            current: os.name,
            version
          };
        });
      };
      const normalVersionRegex = /.*?version\/\ ?([0-9]+)\.([0-9]+).*/;
      const checkContains = (target) => {
        return (uastring) => {
          return contains$1(uastring, target);
        };
      };
      const browsers = [
        // This is legacy Edge
        {
          name: "Edge",
          versionRegexes: [/.*?edge\/ ?([0-9]+)\.([0-9]+)$/],
          search: (uastring) => {
            return contains$1(uastring, "edge/") && contains$1(uastring, "chrome") && contains$1(uastring, "safari") && contains$1(uastring, "applewebkit");
          }
        },
        // This is Google Chrome and Chromium Edge
        {
          name: "Chromium",
          brand: "Chromium",
          versionRegexes: [/.*?chrome\/([0-9]+)\.([0-9]+).*/, normalVersionRegex],
          search: (uastring) => {
            return contains$1(uastring, "chrome") && !contains$1(uastring, "chromeframe");
          }
        },
        {
          name: "IE",
          versionRegexes: [/.*?msie\ ?([0-9]+)\.([0-9]+).*/, /.*?rv:([0-9]+)\.([0-9]+).*/],
          search: (uastring) => {
            return contains$1(uastring, "msie") || contains$1(uastring, "trident");
          }
        },
        // INVESTIGATE: Is this still the Opera user agent?
        {
          name: "Opera",
          versionRegexes: [normalVersionRegex, /.*?opera\/([0-9]+)\.([0-9]+).*/],
          search: checkContains("opera")
        },
        {
          name: "Firefox",
          versionRegexes: [/.*?firefox\/\ ?([0-9]+)\.([0-9]+).*/],
          search: checkContains("firefox")
        },
        {
          name: "Safari",
          versionRegexes: [normalVersionRegex, /.*?cpu os ([0-9]+)_([0-9]+).*/],
          search: (uastring) => {
            return (contains$1(uastring, "safari") || contains$1(uastring, "mobile/")) && contains$1(uastring, "applewebkit");
          }
        }
      ];
      const oses = [
        {
          name: "Windows",
          search: checkContains("win"),
          versionRegexes: [/.*?windows\ nt\ ?([0-9]+)\.([0-9]+).*/]
        },
        {
          name: "iOS",
          search: (uastring) => {
            return contains$1(uastring, "iphone") || contains$1(uastring, "ipad");
          },
          versionRegexes: [/.*?version\/\ ?([0-9]+)\.([0-9]+).*/, /.*cpu os ([0-9]+)_([0-9]+).*/, /.*cpu iphone os ([0-9]+)_([0-9]+).*/]
        },
        {
          name: "Android",
          search: checkContains("android"),
          versionRegexes: [/.*?android\ ?([0-9]+)\.([0-9]+).*/]
        },
        {
          name: "macOS",
          search: checkContains("mac os x"),
          versionRegexes: [/.*?mac\ os\ x\ ?([0-9]+)_([0-9]+).*/]
        },
        {
          name: "Linux",
          search: checkContains("linux"),
          versionRegexes: []
        },
        {
          name: "Solaris",
          search: checkContains("sunos"),
          versionRegexes: []
        },
        {
          name: "FreeBSD",
          search: checkContains("freebsd"),
          versionRegexes: []
        },
        {
          name: "ChromeOS",
          search: checkContains("cros"),
          versionRegexes: [/.*?chrome\/([0-9]+)\.([0-9]+).*/]
        }
      ];
      const PlatformInfo = {
        browsers: constant$1(browsers),
        oses: constant$1(oses)
      };
      const edge = "Edge";
      const chromium = "Chromium";
      const ie = "IE";
      const opera = "Opera";
      const firefox = "Firefox";
      const safari = "Safari";
      const unknown$2 = () => {
        return nu$9({
          current: void 0,
          version: Version.unknown()
        });
      };
      const nu$9 = (info) => {
        const current = info.current;
        const version = info.version;
        const isBrowser = (name2) => () => current === name2;
        return {
          current,
          version,
          isEdge: isBrowser(edge),
          isChromium: isBrowser(chromium),
          // NOTE: isIe just looks too weird
          isIE: isBrowser(ie),
          isOpera: isBrowser(opera),
          isFirefox: isBrowser(firefox),
          isSafari: isBrowser(safari)
        };
      };
      const Browser = {
        unknown: unknown$2,
        nu: nu$9,
        edge: constant$1(edge),
        chromium: constant$1(chromium),
        ie: constant$1(ie),
        opera: constant$1(opera),
        firefox: constant$1(firefox),
        safari: constant$1(safari)
      };
      const windows = "Windows";
      const ios = "iOS";
      const android = "Android";
      const linux = "Linux";
      const macos = "macOS";
      const solaris = "Solaris";
      const freebsd = "FreeBSD";
      const chromeos = "ChromeOS";
      const unknown$1 = () => {
        return nu$8({
          current: void 0,
          version: Version.unknown()
        });
      };
      const nu$8 = (info) => {
        const current = info.current;
        const version = info.version;
        const isOS = (name2) => () => current === name2;
        return {
          current,
          version,
          isWindows: isOS(windows),
          // TODO: Fix capitalisation
          isiOS: isOS(ios),
          isAndroid: isOS(android),
          isMacOS: isOS(macos),
          isLinux: isOS(linux),
          isSolaris: isOS(solaris),
          isFreeBSD: isOS(freebsd),
          isChromeOS: isOS(chromeos)
        };
      };
      const OperatingSystem = {
        unknown: unknown$1,
        nu: nu$8,
        windows: constant$1(windows),
        ios: constant$1(ios),
        android: constant$1(android),
        linux: constant$1(linux),
        macos: constant$1(macos),
        solaris: constant$1(solaris),
        freebsd: constant$1(freebsd),
        chromeos: constant$1(chromeos)
      };
      const detect$2 = (userAgent, userAgentDataOpt, mediaMatch2) => {
        const browsers2 = PlatformInfo.browsers();
        const oses2 = PlatformInfo.oses();
        const browser2 = userAgentDataOpt.bind((userAgentData) => detectBrowser$1(browsers2, userAgentData)).orThunk(() => detectBrowser(browsers2, userAgent)).fold(Browser.unknown, Browser.nu);
        const os = detectOs(oses2, userAgent).fold(OperatingSystem.unknown, OperatingSystem.nu);
        const deviceType = DeviceType(os, browser2, userAgent, mediaMatch2);
        return {
          browser: browser2,
          os,
          deviceType
        };
      };
      const PlatformDetection = {
        detect: detect$2
      };
      const mediaMatch = (query2) => window.matchMedia(query2).matches;
      let platform = cached(() => PlatformDetection.detect(window.navigator.userAgent, Optional.from(window.navigator.userAgentData), mediaMatch));
      const detect$1 = () => platform();
      const unsafe = (name2, scope) => {
        return resolve(name2, scope);
      };
      const getOrDie$1 = (name2, scope) => {
        const actual = unsafe(name2, scope);
        if (actual === void 0 || actual === null) {
          throw new Error(name2 + " not available on this browser");
        }
        return actual;
      };
      const getPrototypeOf$1 = Object.getPrototypeOf;
      const sandHTMLElement = (scope) => {
        return getOrDie$1("HTMLElement", scope);
      };
      const isPrototypeOf = (x) => {
        const scope = resolve("ownerDocument.defaultView", x);
        return isObject(x) && (sandHTMLElement(scope).prototype.isPrototypeOf(x) || /^HTML\w*Element$/.test(getPrototypeOf$1(x).constructor.name));
      };
      const name$3 = (element2) => {
        const r2 = element2.dom.nodeName;
        return r2.toLowerCase();
      };
      const type$1 = (element2) => element2.dom.nodeType;
      const isType = (t2) => (element2) => type$1(element2) === t2;
      const isHTMLElement = (element2) => isElement$1(element2) && isPrototypeOf(element2.dom);
      const isElement$1 = isType(ELEMENT);
      const isText = isType(TEXT);
      const isDocument = isType(DOCUMENT);
      const isDocumentFragment = isType(DOCUMENT_FRAGMENT);
      const isTag = (tag) => (e) => isElement$1(e) && name$3(e) === tag;
      const owner$4 = (element2) => SugarElement.fromDom(element2.dom.ownerDocument);
      const documentOrOwner = (dos) => isDocument(dos) ? dos : owner$4(dos);
      const documentElement = (element2) => SugarElement.fromDom(documentOrOwner(element2).dom.documentElement);
      const defaultView = (element2) => SugarElement.fromDom(documentOrOwner(element2).dom.defaultView);
      const parent = (element2) => Optional.from(element2.dom.parentNode).map(SugarElement.fromDom);
      const parentNode = (element2) => parent(element2);
      const parentElement = (element2) => Optional.from(element2.dom.parentElement).map(SugarElement.fromDom);
      const parents = (element2, isRoot) => {
        const stop2 = isFunction(isRoot) ? isRoot : never;
        let dom2 = element2.dom;
        const ret = [];
        while (dom2.parentNode !== null && dom2.parentNode !== void 0) {
          const rawParent = dom2.parentNode;
          const p = SugarElement.fromDom(rawParent);
          ret.push(p);
          if (stop2(p) === true) {
            break;
          } else {
            dom2 = rawParent;
          }
        }
        return ret;
      };
      const offsetParent = (element2) => Optional.from(element2.dom.offsetParent).map(SugarElement.fromDom);
      const nextSibling = (element2) => Optional.from(element2.dom.nextSibling).map(SugarElement.fromDom);
      const children = (element2) => map$2(element2.dom.childNodes, SugarElement.fromDom);
      const child$2 = (element2, index) => {
        const cs = element2.dom.childNodes;
        return Optional.from(cs[index]).map(SugarElement.fromDom);
      };
      const firstChild = (element2) => child$2(element2, 0);
      const spot = (element2, offset2) => ({
        element: element2,
        offset: offset2
      });
      const leaf = (element2, offset2) => {
        const cs = children(element2);
        return cs.length > 0 && offset2 < cs.length ? spot(cs[offset2], 0) : spot(element2, offset2);
      };
      const makeRange = (start, soffset, finish, foffset) => {
        const doc = owner$4(start);
        const rng = doc.dom.createRange();
        rng.setStart(start.dom, soffset);
        rng.setEnd(finish.dom, foffset);
        return rng;
      };
      const after$2 = (start, soffset, finish, foffset) => {
        const r2 = makeRange(start, soffset, finish, foffset);
        const same = eq(start, finish) && soffset === foffset;
        return r2.collapsed && !same;
      };
      const isShadowRoot = (dos) => isDocumentFragment(dos) && isNonNullable(dos.dom.host);
      const getRootNode = (e) => SugarElement.fromDom(e.dom.getRootNode());
      const getContentContainer = (dos) => (
        // Can't use SugarBody.body without causing a circular module reference (since SugarBody.inBody uses SugarShadowDom)
        isShadowRoot(dos) ? dos : SugarElement.fromDom(documentOrOwner(dos).dom.body)
      );
      const isInShadowRoot = (e) => getShadowRoot(e).isSome();
      const getShadowRoot = (e) => {
        const r2 = getRootNode(e);
        return isShadowRoot(r2) ? Optional.some(r2) : Optional.none();
      };
      const getShadowHost = (e) => SugarElement.fromDom(e.dom.host);
      const getOriginalEventTarget = (event) => {
        if (isNonNullable(event.target)) {
          const el = SugarElement.fromDom(event.target);
          if (isElement$1(el) && isOpenShadowHost(el)) {
            if (event.composed && event.composedPath) {
              const composedPath = event.composedPath();
              if (composedPath) {
                return head(composedPath);
              }
            }
          }
        }
        return Optional.from(event.target);
      };
      const isOpenShadowHost = (element2) => isNonNullable(element2.dom.shadowRoot);
      const mkEvent = (target, x, y, stop2, prevent, kill, raw) => ({
        target,
        x,
        y,
        stop: stop2,
        prevent,
        kill,
        raw
      });
      const fromRawEvent$1 = (rawEvent) => {
        const target = SugarElement.fromDom(getOriginalEventTarget(rawEvent).getOr(rawEvent.target));
        const stop2 = () => rawEvent.stopPropagation();
        const prevent = () => rawEvent.preventDefault();
        const kill = compose(prevent, stop2);
        return mkEvent(target, rawEvent.clientX, rawEvent.clientY, stop2, prevent, kill, rawEvent);
      };
      const handle = (filter2, handler) => (rawEvent) => {
        if (filter2(rawEvent)) {
          handler(fromRawEvent$1(rawEvent));
        }
      };
      const binder = (element2, event, filter2, handler, useCapture) => {
        const wrapped = handle(filter2, handler);
        element2.dom.addEventListener(event, wrapped, useCapture);
        return {
          unbind: curry(unbind, element2, event, wrapped, useCapture)
        };
      };
      const bind$2 = (element2, event, filter2, handler) => binder(element2, event, filter2, handler, false);
      const capture$1 = (element2, event, filter2, handler) => binder(element2, event, filter2, handler, true);
      const unbind = (element2, event, handler, useCapture) => {
        element2.dom.removeEventListener(event, handler, useCapture);
      };
      const filter = always;
      const bind$1 = (element2, event, handler) => bind$2(element2, event, filter, handler);
      const capture = (element2, event, handler) => capture$1(element2, event, filter, handler);
      const fromRawEvent = fromRawEvent$1;
      const getDocument = () => SugarElement.fromDom(document);
      const focus$4 = (element2, preventScroll = false) => element2.dom.focus({ preventScroll });
      const blur$1 = (element2) => element2.dom.blur();
      const hasFocus = (element2) => {
        const root = getRootNode(element2).dom;
        return element2.dom === root.activeElement;
      };
      const active$1 = (root = getDocument()) => Optional.from(root.dom.activeElement).map(SugarElement.fromDom);
      const search = (element2) => active$1(getRootNode(element2)).filter((e) => element2.dom.contains(e.dom));
      const before$1 = (marker, element2) => {
        const parent$1 = parent(marker);
        parent$1.each((v) => {
          v.dom.insertBefore(element2.dom, marker.dom);
        });
      };
      const after$1 = (marker, element2) => {
        const sibling2 = nextSibling(marker);
        sibling2.fold(() => {
          const parent$1 = parent(marker);
          parent$1.each((v) => {
            append$2(v, element2);
          });
        }, (v) => {
          before$1(v, element2);
        });
      };
      const prepend$1 = (parent2, element2) => {
        const firstChild$1 = firstChild(parent2);
        firstChild$1.fold(() => {
          append$2(parent2, element2);
        }, (v) => {
          parent2.dom.insertBefore(element2.dom, v.dom);
        });
      };
      const append$2 = (parent2, element2) => {
        parent2.dom.appendChild(element2.dom);
      };
      const appendAt = (parent2, element2, index) => {
        child$2(parent2, index).fold(() => {
          append$2(parent2, element2);
        }, (v) => {
          before$1(v, element2);
        });
      };
      const append$1 = (parent2, elements) => {
        each$1(elements, (x) => {
          append$2(parent2, x);
        });
      };
      const rawSet = (dom2, key, value2) => {
        if (isString(value2) || isBoolean(value2) || isNumber(value2)) {
          dom2.setAttribute(key, value2 + "");
        } else {
          console.error("Invalid call to Attribute.set. Key ", key, ":: Value ", value2, ":: Element ", dom2);
          throw new Error("Attribute value was not simple");
        }
      };
      const set$9 = (element2, key, value2) => {
        rawSet(element2.dom, key, value2);
      };
      const setAll$1 = (element2, attrs) => {
        const dom2 = element2.dom;
        each(attrs, (v, k) => {
          rawSet(dom2, k, v);
        });
      };
      const get$g = (element2, key) => {
        const v = element2.dom.getAttribute(key);
        return v === null ? void 0 : v;
      };
      const getOpt = (element2, key) => Optional.from(get$g(element2, key));
      const has$1 = (element2, key) => {
        const dom2 = element2.dom;
        return dom2 && dom2.hasAttribute ? dom2.hasAttribute(key) : false;
      };
      const remove$8 = (element2, key) => {
        element2.dom.removeAttribute(key);
      };
      const clone$2 = (element2) => foldl(element2.dom.attributes, (acc, attr) => {
        acc[attr.name] = attr.value;
        return acc;
      }, {});
      const empty = (element2) => {
        element2.dom.textContent = "";
        each$1(children(element2), (rogue) => {
          remove$7(rogue);
        });
      };
      const remove$7 = (element2) => {
        const dom2 = element2.dom;
        if (dom2.parentNode !== null) {
          dom2.parentNode.removeChild(dom2);
        }
      };
      const clone$1 = (original2, isDeep) => SugarElement.fromDom(original2.dom.cloneNode(isDeep));
      const shallow = (original2) => clone$1(original2, false);
      const deep = (original2) => clone$1(original2, true);
      const fromHtml$1 = (html2, scope) => {
        const doc = scope || document;
        const div = doc.createElement("div");
        div.innerHTML = html2;
        return children(SugarElement.fromDom(div));
      };
      const get$f = (element2) => element2.dom.innerHTML;
      const set$8 = (element2, content) => {
        const owner2 = owner$4(element2);
        const docDom = owner2.dom;
        const fragment = SugarElement.fromDom(docDom.createDocumentFragment());
        const contentElements = fromHtml$1(content, docDom);
        append$1(fragment, contentElements);
        empty(element2);
        append$2(element2, fragment);
      };
      const getOuter$2 = (element2) => {
        const container = SugarElement.fromTag("div");
        const clone2 = SugarElement.fromDom(element2.dom.cloneNode(true));
        append$2(container, clone2);
        return get$f(container);
      };
      const getHtml = (element2) => {
        if (isShadowRoot(element2)) {
          return "#shadow-root";
        } else {
          const clone2 = shallow(element2);
          return getOuter$2(clone2);
        }
      };
      const image = (image2) => new Promise((resolve2, reject) => {
        const loaded = () => {
          destroy();
          resolve2(image2);
        };
        const listeners = [
          bind$1(image2, "load", loaded),
          bind$1(image2, "error", () => {
            destroy();
            reject("Unable to load data from image: " + image2.dom.src);
          })
        ];
        const destroy = () => each$1(listeners, (l2) => l2.unbind());
        if (image2.dom.complete) {
          loaded();
        }
      });
      const isSupported = (dom2) => (
        // eslint-disable-next-line @typescript-eslint/unbound-method
        dom2.style !== void 0 && isFunction(dom2.style.getPropertyValue)
      );
      const inBody = (element2) => {
        const dom2 = isText(element2) ? element2.dom.parentNode : element2.dom;
        if (dom2 === void 0 || dom2 === null || dom2.ownerDocument === null) {
          return false;
        }
        const doc = dom2.ownerDocument;
        return getShadowRoot(SugarElement.fromDom(dom2)).fold(() => doc.body.contains(dom2), compose1(inBody, getShadowHost));
      };
      const body = () => getBody(SugarElement.fromDom(document));
      const getBody = (doc) => {
        const b2 = doc.dom.body;
        if (b2 === null || b2 === void 0) {
          throw new Error("Body is not available yet");
        }
        return SugarElement.fromDom(b2);
      };
      const internalSet = (dom2, property, value2) => {
        if (!isString(value2)) {
          console.error("Invalid call to CSS.set. Property ", property, ":: Value ", value2, ":: Element ", dom2);
          throw new Error("CSS value must be a string: " + value2);
        }
        if (isSupported(dom2)) {
          dom2.style.setProperty(property, value2);
        }
      };
      const internalRemove = (dom2, property) => {
        if (isSupported(dom2)) {
          dom2.style.removeProperty(property);
        }
      };
      const set$7 = (element2, property, value2) => {
        const dom2 = element2.dom;
        internalSet(dom2, property, value2);
      };
      const setAll = (element2, css) => {
        const dom2 = element2.dom;
        each(css, (v, k) => {
          internalSet(dom2, k, v);
        });
      };
      const setOptions = (element2, css) => {
        const dom2 = element2.dom;
        each(css, (v, k) => {
          v.fold(() => {
            internalRemove(dom2, k);
          }, (value2) => {
            internalSet(dom2, k, value2);
          });
        });
      };
      const get$e = (element2, property) => {
        const dom2 = element2.dom;
        const styles = window.getComputedStyle(dom2);
        const r2 = styles.getPropertyValue(property);
        return r2 === "" && !inBody(element2) ? getUnsafeProperty(dom2, property) : r2;
      };
      const getUnsafeProperty = (dom2, property) => isSupported(dom2) ? dom2.style.getPropertyValue(property) : "";
      const getRaw = (element2, property) => {
        const dom2 = element2.dom;
        const raw = getUnsafeProperty(dom2, property);
        return Optional.from(raw).filter((r2) => r2.length > 0);
      };
      const getAllRaw = (element2) => {
        const css = {};
        const dom2 = element2.dom;
        if (isSupported(dom2)) {
          for (let i = 0; i < dom2.style.length; i++) {
            const ruleName = dom2.style.item(i);
            css[ruleName] = dom2.style[ruleName];
          }
        }
        return css;
      };
      const isValidValue$1 = (tag, property, value2) => {
        const element2 = SugarElement.fromTag(tag);
        set$7(element2, property, value2);
        const style = getRaw(element2, property);
        return style.isSome();
      };
      const remove$6 = (element2, property) => {
        const dom2 = element2.dom;
        internalRemove(dom2, property);
        if (is$1(getOpt(element2, "style").map(trim$1), "")) {
          remove$8(element2, "style");
        }
      };
      const reflow = (e) => e.dom.offsetWidth;
      const Dimension = (name2, getOffset2) => {
        const set2 = (element2, h) => {
          if (!isNumber(h) && !h.match(/^[0-9]+$/)) {
            throw new Error(name2 + ".set accepts only positive integer values. Value was " + h);
          }
          const dom2 = element2.dom;
          if (isSupported(dom2)) {
            dom2.style[name2] = h + "px";
          }
        };
        const get2 = (element2) => {
          const r2 = getOffset2(element2);
          if (r2 <= 0 || r2 === null) {
            const css = get$e(element2, name2);
            return parseFloat(css) || 0;
          }
          return r2;
        };
        const getOuter2 = get2;
        const aggregate = (element2, properties2) => foldl(properties2, (acc, property) => {
          const val = get$e(element2, property);
          const value2 = val === void 0 ? 0 : parseInt(val, 10);
          return isNaN(value2) ? acc : acc + value2;
        }, 0);
        const max2 = (element2, value2, properties2) => {
          const cumulativeInclusions = aggregate(element2, properties2);
          const absoluteMax = value2 > cumulativeInclusions ? value2 - cumulativeInclusions : 0;
          return absoluteMax;
        };
        return {
          set: set2,
          get: get2,
          getOuter: getOuter2,
          aggregate,
          max: max2
        };
      };
      const api$2 = Dimension("height", (element2) => {
        const dom2 = element2.dom;
        return inBody(element2) ? dom2.getBoundingClientRect().height : dom2.offsetHeight;
      });
      const get$d = (element2) => api$2.get(element2);
      const getOuter$1 = (element2) => api$2.getOuter(element2);
      const setMax$1 = (element2, value2) => {
        const inclusions = ["margin-top", "border-top-width", "padding-top", "padding-bottom", "border-bottom-width", "margin-bottom"];
        const absMax = api$2.max(element2, value2, inclusions);
        set$7(element2, "max-height", absMax + "px");
      };
      const isHidden$1 = (dom2) => dom2.offsetWidth <= 0 && dom2.offsetHeight <= 0;
      const isVisible = (element2) => !isHidden$1(element2.dom);
      const api$1 = Dimension("width", (element2) => (
        // IMO passing this function is better than using dom['offset' + 'width']
        element2.dom.offsetWidth
      ));
      const apiExact = Dimension("width", (element2) => {
        const dom2 = element2.dom;
        return inBody(element2) ? dom2.getBoundingClientRect().width : dom2.offsetWidth;
      });
      const set$6 = (element2, h) => api$1.set(element2, h);
      const get$c = (element2) => api$1.get(element2);
      const getOuter = (element2) => api$1.getOuter(element2);
      const getOuterExact = (element2) => apiExact.getOuter(element2);
      const setMax = (element2, value2) => {
        const inclusions = ["margin-left", "border-left-width", "padding-left", "padding-right", "border-right-width", "margin-right"];
        const absMax = api$1.max(element2, value2, inclusions);
        set$7(element2, "max-width", absMax + "px");
      };
      const r$1 = (left2, top2) => {
        const translate2 = (x, y) => r$1(left2 + x, top2 + y);
        return {
          left: left2,
          top: top2,
          translate: translate2
        };
      };
      const SugarPosition = r$1;
      const boxPosition = (dom2) => {
        const box2 = dom2.getBoundingClientRect();
        return SugarPosition(box2.left, box2.top);
      };
      const firstDefinedOrZero = (a, b2) => {
        if (a !== void 0) {
          return a;
        } else {
          return b2 !== void 0 ? b2 : 0;
        }
      };
      const absolute$3 = (element2) => {
        const doc = element2.dom.ownerDocument;
        const body2 = doc.body;
        const win2 = doc.defaultView;
        const html2 = doc.documentElement;
        if (body2 === element2.dom) {
          return SugarPosition(body2.offsetLeft, body2.offsetTop);
        }
        const scrollTop = firstDefinedOrZero(win2 === null || win2 === void 0 ? void 0 : win2.pageYOffset, html2.scrollTop);
        const scrollLeft = firstDefinedOrZero(win2 === null || win2 === void 0 ? void 0 : win2.pageXOffset, html2.scrollLeft);
        const clientTop = firstDefinedOrZero(html2.clientTop, body2.clientTop);
        const clientLeft = firstDefinedOrZero(html2.clientLeft, body2.clientLeft);
        return viewport$1(element2).translate(scrollLeft - clientLeft, scrollTop - clientTop);
      };
      const viewport$1 = (element2) => {
        const dom2 = element2.dom;
        const doc = dom2.ownerDocument;
        const body2 = doc.body;
        if (body2 === dom2) {
          return SugarPosition(body2.offsetLeft, body2.offsetTop);
        }
        if (!inBody(element2)) {
          return SugarPosition(0, 0);
        }
        return boxPosition(dom2);
      };
      const get$b = (_DOC) => {
        const doc = _DOC !== void 0 ? _DOC.dom : document;
        const x = doc.body.scrollLeft || doc.documentElement.scrollLeft;
        const y = doc.body.scrollTop || doc.documentElement.scrollTop;
        return SugarPosition(x, y);
      };
      const to = (x, y, _DOC) => {
        const doc = _DOC !== void 0 ? _DOC.dom : document;
        const win2 = doc.defaultView;
        if (win2) {
          win2.scrollTo(x, y);
        }
      };
      const NodeValue = (is2, name2) => {
        const get2 = (element2) => {
          if (!is2(element2)) {
            throw new Error("Can only get " + name2 + " value of a " + name2 + " node");
          }
          return getOption(element2).getOr("");
        };
        const getOption = (element2) => is2(element2) ? Optional.from(element2.dom.nodeValue) : Optional.none();
        const set2 = (element2, value2) => {
          if (!is2(element2)) {
            throw new Error("Can only set raw " + name2 + " value of a " + name2 + " node");
          }
          element2.dom.nodeValue = value2;
        };
        return {
          get: get2,
          getOption,
          set: set2
        };
      };
      const api = NodeValue(isText, "text");
      const get$a = (element2) => api.get(element2);
      const onDirection = (isLtr, isRtl) => (element2) => getDirection(element2) === "rtl" ? isRtl : isLtr;
      const getDirection = (element2) => get$e(element2, "direction") === "rtl" ? "rtl" : "ltr";
      const read$2 = (element2, attr) => {
        const value2 = get$g(element2, attr);
        return value2 === void 0 || value2 === "" ? [] : value2.split(" ");
      };
      const add$4 = (element2, attr, id) => {
        const old = read$2(element2, attr);
        const nu2 = old.concat([id]);
        set$9(element2, attr, nu2.join(" "));
        return true;
      };
      const remove$5 = (element2, attr, id) => {
        const nu2 = filter$2(read$2(element2, attr), (v) => v !== id);
        if (nu2.length > 0) {
          set$9(element2, attr, nu2.join(" "));
        } else {
          remove$8(element2, attr);
        }
        return false;
      };
      var ClosestOrAncestor = (is2, ancestor2, scope, a, isRoot) => {
        if (is2(scope, a)) {
          return Optional.some(scope);
        } else if (isFunction(isRoot) && isRoot(scope)) {
          return Optional.none();
        } else {
          return ancestor2(scope, a, isRoot);
        }
      };
      const ancestor$2 = (scope, predicate, isRoot) => {
        let element2 = scope.dom;
        const stop2 = isFunction(isRoot) ? isRoot : never;
        while (element2.parentNode) {
          element2 = element2.parentNode;
          const el = SugarElement.fromDom(element2);
          if (predicate(el)) {
            return Optional.some(el);
          } else if (stop2(el)) {
            break;
          }
        }
        return Optional.none();
      };
      const closest$4 = (scope, predicate, isRoot) => {
        const is2 = (s, test) => test(s);
        return ClosestOrAncestor(is2, ancestor$2, scope, predicate, isRoot);
      };
      const sibling$1 = (scope, predicate) => {
        const element2 = scope.dom;
        if (!element2.parentNode) {
          return Optional.none();
        }
        return child$1(SugarElement.fromDom(element2.parentNode), (x) => !eq(scope, x) && predicate(x));
      };
      const child$1 = (scope, predicate) => {
        const pred = (node) => predicate(SugarElement.fromDom(node));
        const result = find$5(scope.dom.childNodes, pred);
        return result.map(SugarElement.fromDom);
      };
      const descendant$1 = (scope, predicate) => {
        const descend = (node) => {
          for (let i = 0; i < node.childNodes.length; i++) {
            const child2 = SugarElement.fromDom(node.childNodes[i]);
            if (predicate(child2)) {
              return Optional.some(child2);
            }
            const res = descend(node.childNodes[i]);
            if (res.isSome()) {
              return res;
            }
          }
          return Optional.none();
        };
        return descend(scope.dom);
      };
      const first = (selector) => one(selector);
      const ancestor$1 = (scope, selector, isRoot) => ancestor$2(scope, (e) => is(e, selector), isRoot);
      const sibling = (scope, selector) => sibling$1(scope, (e) => is(e, selector));
      const child = (scope, selector) => child$1(scope, (e) => is(e, selector));
      const descendant = (scope, selector) => one(selector, scope);
      const closest$3 = (scope, selector, isRoot) => {
        const is$12 = (element2, selector2) => is(element2, selector2);
        return ClosestOrAncestor(is$12, ancestor$1, scope, selector, isRoot);
      };
      const set$5 = (element2, status) => {
        element2.dom.checked = status;
      };
      const get$9 = (element2) => element2.dom.checked;
      const supports = (element2) => element2.dom.classList !== void 0;
      const get$8 = (element2) => read$2(element2, "class");
      const add$3 = (element2, clazz) => add$4(element2, "class", clazz);
      const remove$4 = (element2, clazz) => remove$5(element2, "class", clazz);
      const toggle$5 = (element2, clazz) => {
        if (contains$2(get$8(element2), clazz)) {
          return remove$4(element2, clazz);
        } else {
          return add$3(element2, clazz);
        }
      };
      const add$2 = (element2, clazz) => {
        if (supports(element2)) {
          element2.dom.classList.add(clazz);
        } else {
          add$3(element2, clazz);
        }
      };
      const cleanClass = (element2) => {
        const classList = supports(element2) ? element2.dom.classList : get$8(element2);
        if (classList.length === 0) {
          remove$8(element2, "class");
        }
      };
      const remove$3 = (element2, clazz) => {
        if (supports(element2)) {
          const classList = element2.dom.classList;
          classList.remove(clazz);
        } else {
          remove$4(element2, clazz);
        }
        cleanClass(element2);
      };
      const toggle$4 = (element2, clazz) => {
        const result = supports(element2) ? element2.dom.classList.toggle(clazz) : toggle$5(element2, clazz);
        cleanClass(element2);
        return result;
      };
      const has = (element2, clazz) => supports(element2) && element2.dom.classList.contains(clazz);
      const add$1 = (element2, classes2) => {
        each$1(classes2, (x) => {
          add$2(element2, x);
        });
      };
      const remove$2 = (element2, classes2) => {
        each$1(classes2, (x) => {
          remove$3(element2, x);
        });
      };
      const toggle$3 = (element2, classes2) => {
        each$1(classes2, (x) => {
          toggle$4(element2, x);
        });
      };
      const hasAll = (element2, classes2) => forall(classes2, (clazz) => has(element2, clazz));
      const getNative = (element2) => {
        const classList = element2.dom.classList;
        const r2 = new Array(classList.length);
        for (let i = 0; i < classList.length; i++) {
          const item2 = classList.item(i);
          if (item2 !== null) {
            r2[i] = item2;
          }
        }
        return r2;
      };
      const get$7 = (element2) => supports(element2) ? getNative(element2) : get$8(element2);
      const get$6 = (element2) => element2.dom.textContent;
      const get$5 = (element2) => element2.dom.value;
      const set$4 = (element2, value2) => {
        if (value2 === void 0) {
          throw new Error("Value.set was undefined");
        }
        element2.dom.value = value2;
      };
      const ancestors = (scope, predicate, isRoot) => filter$2(parents(scope, isRoot), predicate);
      const descendants = (scope, selector) => all$3(selector, scope);
      const closest$2 = (scope, predicate, isRoot) => closest$4(scope, predicate, isRoot).isSome();
      const closest$1 = (scope, selector, isRoot) => closest$3(scope, selector, isRoot).isSome();
      const ensureIsRoot = (isRoot) => isFunction(isRoot) ? isRoot : never;
      const ancestor = (scope, transform2, isRoot) => {
        let element2 = scope.dom;
        const stop2 = ensureIsRoot(isRoot);
        while (element2.parentNode) {
          element2 = element2.parentNode;
          const el = SugarElement.fromDom(element2);
          const transformed = transform2(el);
          if (transformed.isSome()) {
            return transformed;
          } else if (stop2(el)) {
            break;
          }
        }
        return Optional.none();
      };
      const closest = (scope, transform2, isRoot) => {
        const current = transform2(scope);
        const stop2 = ensureIsRoot(isRoot);
        return current.orThunk(() => stop2(scope) ? Optional.none() : ancestor(scope, transform2, stop2));
      };
      const create$5 = (start, soffset, finish, foffset) => ({
        start,
        soffset,
        finish,
        foffset
      });
      const SimRange = {
        create: create$5
      };
      const adt$9 = Adt.generate([
        { before: ["element"] },
        { on: ["element", "offset"] },
        { after: ["element"] }
      ]);
      const cata$2 = (subject, onBefore, onOn, onAfter) => subject.fold(onBefore, onOn, onAfter);
      const getStart$1 = (situ) => situ.fold(identity, identity, identity);
      const before = adt$9.before;
      const on$1 = adt$9.on;
      const after = adt$9.after;
      const Situ = {
        before,
        on: on$1,
        after,
        cata: cata$2,
        getStart: getStart$1
      };
      const adt$8 = Adt.generate([
        { domRange: ["rng"] },
        { relative: ["startSitu", "finishSitu"] },
        { exact: ["start", "soffset", "finish", "foffset"] }
      ]);
      const exactFromRange = (simRange) => adt$8.exact(simRange.start, simRange.soffset, simRange.finish, simRange.foffset);
      const getStart = (selection) => selection.match({
        domRange: (rng) => SugarElement.fromDom(rng.startContainer),
        relative: (startSitu, _finishSitu) => Situ.getStart(startSitu),
        exact: (start, _soffset, _finish, _foffset) => start
      });
      const domRange = adt$8.domRange;
      const relative$1 = adt$8.relative;
      const exact = adt$8.exact;
      const getWin = (selection) => {
        const start = getStart(selection);
        return defaultView(start);
      };
      const range$1 = SimRange.create;
      const SimSelection = {
        domRange,
        relative: relative$1,
        exact,
        exactFromRange,
        getWin,
        range: range$1
      };
      const getNativeSelection = (win2) => Optional.from(win2.getSelection());
      const readRange = (selection) => {
        if (selection.rangeCount > 0) {
          const firstRng = selection.getRangeAt(0);
          const lastRng = selection.getRangeAt(selection.rangeCount - 1);
          return Optional.some(SimRange.create(SugarElement.fromDom(firstRng.startContainer), firstRng.startOffset, SugarElement.fromDom(lastRng.endContainer), lastRng.endOffset));
        } else {
          return Optional.none();
        }
      };
      const doGetExact = (selection) => {
        if (selection.anchorNode === null || selection.focusNode === null) {
          return readRange(selection);
        } else {
          const anchor2 = SugarElement.fromDom(selection.anchorNode);
          const focus2 = SugarElement.fromDom(selection.focusNode);
          return after$2(anchor2, selection.anchorOffset, focus2, selection.focusOffset) ? Optional.some(SimRange.create(anchor2, selection.anchorOffset, focus2, selection.focusOffset)) : readRange(selection);
        }
      };
      const getExact = (win2) => (
        // We want to retrieve the selection as it is.
        getNativeSelection(win2).filter((sel) => sel.rangeCount > 0).bind(doGetExact)
      );
      const getFirstRect = (win2, selection) => {
        const rng = asLtrRange(win2, selection);
        return getFirstRect$1(rng);
      };
      const getBounds$2 = (win2, selection) => {
        const rng = asLtrRange(win2, selection);
        return getBounds$3(rng);
      };
      const units = {
        // we don't really support all of these different ways to express a length
        unsupportedLength: [
          "em",
          "ex",
          "cap",
          "ch",
          "ic",
          "rem",
          "lh",
          "rlh",
          "vw",
          "vh",
          "vi",
          "vb",
          "vmin",
          "vmax",
          "cm",
          "mm",
          "Q",
          "in",
          "pc",
          "pt",
          "px"
        ],
        // these are the length values we do support
        fixed: ["px", "pt"],
        relative: ["%"],
        empty: [""]
      };
      const pattern = (() => {
        const decimalDigits = "[0-9]+";
        const signedInteger = "[+-]?" + decimalDigits;
        const exponentPart = "[eE]" + signedInteger;
        const dot = "\\.";
        const opt = (input2) => `(?:${input2})?`;
        const unsignedDecimalLiteral = [
          "Infinity",
          decimalDigits + dot + opt(decimalDigits) + opt(exponentPart),
          dot + decimalDigits + opt(exponentPart),
          decimalDigits + opt(exponentPart)
        ].join("|");
        const float = `[+-]?(?:${unsignedDecimalLiteral})`;
        return new RegExp(`^(${float})(.*)$`);
      })();
      const isUnit = (unit, accepted) => exists(accepted, (acc) => exists(units[acc], (check) => unit === check));
      const parse = (input2, accepted) => {
        const match = Optional.from(pattern.exec(input2));
        return match.bind((array) => {
          const value2 = Number(array[1]);
          const unitRaw = array[2];
          if (isUnit(unitRaw, accepted)) {
            return Optional.some({
              value: value2,
              unit: unitRaw
            });
          } else {
            return Optional.none();
          }
        });
      };
      const normalise = (input2, accepted) => parse(input2, accepted).map(({ value: value2, unit }) => value2 + unit);
      const get$4 = (_win) => {
        const win2 = _win === void 0 ? window : _win;
        if (detect$1().browser.isFirefox()) {
          return Optional.none();
        } else {
          return Optional.from(win2.visualViewport);
        }
      };
      const bounds$1 = (x, y, width2, height2) => ({
        x,
        y,
        width: width2,
        height: height2,
        right: x + width2,
        bottom: y + height2
      });
      const getBounds$1 = (_win) => {
        const win2 = _win === void 0 ? window : _win;
        const doc = win2.document;
        const scroll = get$b(SugarElement.fromDom(doc));
        return get$4(win2).fold(() => {
          const html2 = win2.document.documentElement;
          const width2 = html2.clientWidth;
          const height2 = html2.clientHeight;
          return bounds$1(scroll.left, scroll.top, width2, height2);
        }, (visualViewport) => (
          // iOS doesn't update the pageTop/pageLeft when element.scrollIntoView() is called, so we need to fallback to the
          // scroll position which will always be less than the page top/left values when page top/left are accurate/correct.
          bounds$1(Math.max(visualViewport.pageLeft, scroll.left), Math.max(visualViewport.pageTop, scroll.top), visualViewport.width, visualViewport.height)
        ));
      };
      const walkUp = (navigation, doc) => {
        const frame = navigation.view(doc);
        return frame.fold(constant$1([]), (f2) => {
          const parent2 = navigation.owner(f2);
          const rest = walkUp(navigation, parent2);
          return [f2].concat(rest);
        });
      };
      const pathTo = (element2, navigation) => {
        const d = navigation.owner(element2);
        const paths = walkUp(navigation, d);
        return Optional.some(paths);
      };
      const view = (doc) => {
        var _a;
        const element2 = doc.dom === document ? Optional.none() : Optional.from((_a = doc.dom.defaultView) === null || _a === void 0 ? void 0 : _a.frameElement);
        return element2.map(SugarElement.fromDom);
      };
      const owner$3 = (element2) => owner$4(element2);
      var Navigation = Object.freeze({
        __proto__: null,
        view,
        owner: owner$3
      });
      const find$2 = (element2) => {
        const doc = getDocument();
        const scroll = get$b(doc);
        const path2 = pathTo(element2, Navigation);
        return path2.fold(curry(absolute$3, element2), (frames) => {
          const offset2 = viewport$1(element2);
          const r2 = foldr(frames, (b2, a) => {
            const loc = viewport$1(a);
            return {
              left: b2.left + loc.left,
              top: b2.top + loc.top
            };
          }, { left: 0, top: 0 });
          return SugarPosition(r2.left + offset2.left + scroll.left, r2.top + offset2.top + scroll.top);
        });
      };
      const pointed = (point2, width2, height2) => ({
        point: point2,
        width: width2,
        height: height2
      });
      const rect = (x, y, width2, height2) => ({
        x,
        y,
        width: width2,
        height: height2
      });
      const bounds = (x, y, width2, height2) => ({
        x,
        y,
        width: width2,
        height: height2,
        right: x + width2,
        bottom: y + height2
      });
      const box$1 = (element2) => {
        const xy = absolute$3(element2);
        const w = getOuter(element2);
        const h = getOuter$1(element2);
        return bounds(xy.left, xy.top, w, h);
      };
      const absolute$2 = (element2) => {
        const position2 = find$2(element2);
        const width2 = getOuter(element2);
        const height2 = getOuter$1(element2);
        return bounds(position2.left, position2.top, width2, height2);
      };
      const constrain = (original2, constraint) => {
        const left2 = Math.max(original2.x, constraint.x);
        const top2 = Math.max(original2.y, constraint.y);
        const right2 = Math.min(original2.right, constraint.right);
        const bottom2 = Math.min(original2.bottom, constraint.bottom);
        const width2 = right2 - left2;
        const height2 = bottom2 - top2;
        return bounds(left2, top2, width2, height2);
      };
      const constrainByMany = (original2, constraints) => {
        return foldl(constraints, (acc, c) => constrain(acc, c), original2);
      };
      const win = () => getBounds$1(window);
      const isSource = (component, simulatedEvent) => eq(component.element, simulatedEvent.event.target);
      const getOffsetParent = (element2) => {
        const isFixed = is$1(getRaw(element2, "position"), "fixed");
        const offsetParent$1 = isFixed ? Optional.none() : offsetParent(element2);
        return offsetParent$1.orThunk(() => {
          const marker = SugarElement.fromTag("span");
          return parent(element2).bind((parent2) => {
            append$2(parent2, marker);
            const offsetParent$12 = offsetParent(marker);
            remove$7(marker);
            return offsetParent$12;
          });
        });
      };
      const getOrigin = (element2) => getOffsetParent(element2).map(absolute$3).getOrThunk(() => SugarPosition(0, 0));
      const describedBy = (describedElement, describeElement) => {
        const describeId = Optional.from(get$g(describedElement, "id")).getOrThunk(() => {
          const id = generate$6("aria");
          set$9(describeElement, "id", id);
          return id;
        });
        set$9(describedElement, "aria-describedby", describeId);
      };
      const remove$1 = (describedElement) => {
        remove$8(describedElement, "aria-describedby");
      };
      var SimpleResultType;
      (function(SimpleResultType2) {
        SimpleResultType2[SimpleResultType2["Error"] = 0] = "Error";
        SimpleResultType2[SimpleResultType2["Value"] = 1] = "Value";
      })(SimpleResultType || (SimpleResultType = {}));
      const fold$1 = (res, onError, onValue) => res.stype === SimpleResultType.Error ? onError(res.serror) : onValue(res.svalue);
      const partition$1 = (results) => {
        const values2 = [];
        const errors = [];
        each$1(results, (obj) => {
          fold$1(obj, (err) => errors.push(err), (val) => values2.push(val));
        });
        return { values: values2, errors };
      };
      const mapError = (res, f2) => {
        if (res.stype === SimpleResultType.Error) {
          return { stype: SimpleResultType.Error, serror: f2(res.serror) };
        } else {
          return res;
        }
      };
      const map = (res, f2) => {
        if (res.stype === SimpleResultType.Value) {
          return { stype: SimpleResultType.Value, svalue: f2(res.svalue) };
        } else {
          return res;
        }
      };
      const bind = (res, f2) => {
        if (res.stype === SimpleResultType.Value) {
          return f2(res.svalue);
        } else {
          return res;
        }
      };
      const bindError = (res, f2) => {
        if (res.stype === SimpleResultType.Error) {
          return f2(res.serror);
        } else {
          return res;
        }
      };
      const svalue = (v) => ({ stype: SimpleResultType.Value, svalue: v });
      const serror = (e) => ({ stype: SimpleResultType.Error, serror: e });
      const toResult$1 = (res) => fold$1(res, Result.error, Result.value);
      const fromResult = (res) => res.fold(serror, svalue);
      const SimpleResult = {
        fromResult,
        toResult: toResult$1,
        svalue,
        partition: partition$1,
        serror,
        bind,
        bindError,
        map,
        mapError,
        fold: fold$1
      };
      const formatObj = (input2) => {
        return isObject(input2) && keys(input2).length > 100 ? " removed due to size" : JSON.stringify(input2, null, 2);
      };
      const formatErrors = (errors) => {
        const es = errors.length > 10 ? errors.slice(0, 10).concat([
          {
            path: [],
            getErrorInfo: constant$1("... (only showing first ten failures)")
          }
        ]) : errors;
        return map$2(es, (e) => {
          return "Failed path: (" + e.path.join(" > ") + ")\n" + e.getErrorInfo();
        });
      };
      const nu$7 = (path2, getErrorInfo) => {
        return SimpleResult.serror([{
          path: path2,
          // This is lazy so that it isn't calculated unnecessarily
          getErrorInfo
        }]);
      };
      const missingRequired = (path2, key, obj) => nu$7(path2, () => 'Could not find valid *required* value for "' + key + '" in ' + formatObj(obj));
      const missingKey = (path2, key) => nu$7(path2, () => 'Choice schema did not contain choice key: "' + key + '"');
      const missingBranch = (path2, branches, branch) => nu$7(path2, () => 'The chosen schema: "' + branch + '" did not exist in branches: ' + formatObj(branches));
      const unsupportedFields = (path2, unsupported) => nu$7(path2, () => "There are unsupported fields: [" + unsupported.join(", ") + "] specified");
      const custom = (path2, err) => nu$7(path2, constant$1(err));
      const value$1 = (validator) => {
        const extract2 = (path2, val) => {
          return SimpleResult.bindError(validator(val), (err) => custom(path2, err));
        };
        const toString2 = constant$1("val");
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const anyValue$1 = value$1(SimpleResult.svalue);
      const anyValue = constant$1(anyValue$1);
      const typedValue = (validator, expectedType) => value$1((a) => {
        const actualType = typeof a;
        return validator(a) ? SimpleResult.svalue(a) : SimpleResult.serror(`Expected type: ${expectedType} but got: ${actualType}`);
      });
      const number = typedValue(isNumber, "number");
      const string = typedValue(isString, "string");
      const boolean = typedValue(isBoolean, "boolean");
      const functionProcessor = typedValue(isFunction, "function");
      const isPostMessageable = (val) => {
        if (Object(val) !== val) {
          return true;
        }
        switch ({}.toString.call(val).slice(8, -1)) {
          case "Boolean":
          case "Number":
          case "String":
          case "Date":
          case "RegExp":
          case "Blob":
          case "FileList":
          case "ImageData":
          case "ImageBitmap":
          case "ArrayBuffer":
            return true;
          case "Array":
          case "Object":
            return Object.keys(val).every((prop) => isPostMessageable(val[prop]));
          default:
            return false;
        }
      };
      const postMessageable = value$1((a) => {
        if (isPostMessageable(a)) {
          return SimpleResult.svalue(a);
        } else {
          return SimpleResult.serror("Expected value to be acceptable for sending via postMessage");
        }
      });
      const required$2 = () => ({ tag: "required", process: {} });
      const defaultedThunk = (fallbackThunk) => ({ tag: "defaultedThunk", process: fallbackThunk });
      const defaulted$1 = (fallback2) => defaultedThunk(constant$1(fallback2));
      const asOption = () => ({ tag: "option", process: {} });
      const mergeWithThunk = (baseThunk) => ({ tag: "mergeWithThunk", process: baseThunk });
      const mergeWith = (base2) => mergeWithThunk(constant$1(base2));
      const field$2 = (key, newKey, presence, prop) => ({ tag: "field", key, newKey, presence, prop });
      const customField$1 = (newKey, instantiator) => ({ tag: "custom", newKey, instantiator });
      const fold = (value2, ifField, ifCustom) => {
        switch (value2.tag) {
          case "field":
            return ifField(value2.key, value2.newKey, value2.presence, value2.prop);
          case "custom":
            return ifCustom(value2.newKey, value2.instantiator);
        }
      };
      const mergeValues$1 = (values2, base2) => values2.length > 0 ? SimpleResult.svalue(deepMerge(base2, merge$1.apply(void 0, values2))) : SimpleResult.svalue(base2);
      const mergeErrors$1 = (errors) => compose(SimpleResult.serror, flatten)(errors);
      const consolidateObj = (objects, base2) => {
        const partition2 = SimpleResult.partition(objects);
        return partition2.errors.length > 0 ? mergeErrors$1(partition2.errors) : mergeValues$1(partition2.values, base2);
      };
      const consolidateArr = (objects) => {
        const partitions = SimpleResult.partition(objects);
        return partitions.errors.length > 0 ? mergeErrors$1(partitions.errors) : SimpleResult.svalue(partitions.values);
      };
      const ResultCombine = {
        consolidateObj,
        consolidateArr
      };
      const requiredAccess = (path2, obj, key, bundle) => (
        // In required mode, if it is undefined, it is an error.
        get$h(obj, key).fold(() => missingRequired(path2, key, obj), bundle)
      );
      const fallbackAccess = (obj, key, fallback2, bundle) => {
        const v = get$h(obj, key).getOrThunk(() => fallback2(obj));
        return bundle(v);
      };
      const optionAccess = (obj, key, bundle) => bundle(get$h(obj, key));
      const optionDefaultedAccess = (obj, key, fallback2, bundle) => {
        const opt = get$h(obj, key).map((val) => val === true ? fallback2(obj) : val);
        return bundle(opt);
      };
      const extractField = (field2, path2, obj, key, prop) => {
        const bundle = (av) => prop.extract(path2.concat([key]), av);
        const bundleAsOption = (optValue) => optValue.fold(() => SimpleResult.svalue(Optional.none()), (ov) => {
          const result = prop.extract(path2.concat([key]), ov);
          return SimpleResult.map(result, Optional.some);
        });
        switch (field2.tag) {
          case "required":
            return requiredAccess(path2, obj, key, bundle);
          case "defaultedThunk":
            return fallbackAccess(obj, key, field2.process, bundle);
          case "option":
            return optionAccess(obj, key, bundleAsOption);
          case "defaultedOptionThunk":
            return optionDefaultedAccess(obj, key, field2.process, bundleAsOption);
          case "mergeWithThunk": {
            return fallbackAccess(obj, key, constant$1({}), (v) => {
              const result = deepMerge(field2.process(obj), v);
              return bundle(result);
            });
          }
        }
      };
      const extractFields = (path2, obj, fields) => {
        const success = {};
        const errors = [];
        for (const field2 of fields) {
          fold(field2, (key, newKey, presence, prop) => {
            const result = extractField(presence, path2, obj, key, prop);
            SimpleResult.fold(result, (err) => {
              errors.push(...err);
            }, (res) => {
              success[newKey] = res;
            });
          }, (newKey, instantiator) => {
            success[newKey] = instantiator(obj);
          });
        }
        return errors.length > 0 ? SimpleResult.serror(errors) : SimpleResult.svalue(success);
      };
      const valueThunk = (getDelegate) => {
        const extract2 = (path2, val) => getDelegate().extract(path2, val);
        const toString2 = () => getDelegate().toString();
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const getSetKeys = (obj) => keys(filter$1(obj, isNonNullable));
      const objOfOnly = (fields) => {
        const delegate = objOf(fields);
        const fieldNames = foldr(fields, (acc, value2) => {
          return fold(value2, (key) => deepMerge(acc, { [key]: true }), constant$1(acc));
        }, {});
        const extract2 = (path2, o) => {
          const keys2 = isBoolean(o) ? [] : getSetKeys(o);
          const extra = filter$2(keys2, (k) => !hasNonNullableKey(fieldNames, k));
          return extra.length === 0 ? delegate.extract(path2, o) : unsupportedFields(path2, extra);
        };
        return {
          extract: extract2,
          toString: delegate.toString
        };
      };
      const objOf = (values2) => {
        const extract2 = (path2, o) => extractFields(path2, o, values2);
        const toString2 = () => {
          const fieldStrings = map$2(values2, (value2) => fold(value2, (key, _okey, _presence, prop) => key + " -> " + prop.toString(), (newKey, _instantiator) => "state(" + newKey + ")"));
          return "obj{\n" + fieldStrings.join("\n") + "}";
        };
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const arrOf = (prop) => {
        const extract2 = (path2, array) => {
          const results = map$2(array, (a, i) => prop.extract(path2.concat(["[" + i + "]"]), a));
          return ResultCombine.consolidateArr(results);
        };
        const toString2 = () => "array(" + prop.toString() + ")";
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const oneOf = (props, rawF) => {
        const f2 = rawF !== void 0 ? rawF : identity;
        const extract2 = (path2, val) => {
          const errors = [];
          for (const prop of props) {
            const res = prop.extract(path2, val);
            if (res.stype === SimpleResultType.Value) {
              return {
                stype: SimpleResultType.Value,
                svalue: f2(res.svalue)
              };
            }
            errors.push(res);
          }
          return ResultCombine.consolidateArr(errors);
        };
        const toString2 = () => "oneOf(" + map$2(props, (prop) => prop.toString()).join(", ") + ")";
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const setOf$1 = (validator, prop) => {
        const validateKeys = (path2, keys2) => arrOf(value$1(validator)).extract(path2, keys2);
        const extract2 = (path2, o) => {
          const keys$1 = keys(o);
          const validatedKeys = validateKeys(path2, keys$1);
          return SimpleResult.bind(validatedKeys, (validKeys) => {
            const schema2 = map$2(validKeys, (vk) => {
              return field$2(vk, vk, required$2(), prop);
            });
            return objOf(schema2).extract(path2, o);
          });
        };
        const toString2 = () => "setOf(" + prop.toString() + ")";
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const thunk = (_desc, processor) => {
        const getP = cached(processor);
        const extract2 = (path2, val) => getP().extract(path2, val);
        const toString2 = () => getP().toString();
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const arrOfObj = compose(arrOf, objOf);
      const chooseFrom = (path2, input2, branches, ch) => {
        const fields = get$h(branches, ch);
        return fields.fold(() => missingBranch(path2, branches, ch), (vp) => vp.extract(path2.concat(["branch: " + ch]), input2));
      };
      const choose$2 = (key, branches) => {
        const extract2 = (path2, input2) => {
          const choice = get$h(input2, key);
          return choice.fold(() => missingKey(path2, key), (chosen) => chooseFrom(path2, input2, branches, chosen));
        };
        const toString2 = () => "chooseOn(" + key + "). Possible values: " + keys(branches);
        return {
          extract: extract2,
          toString: toString2
        };
      };
      const arrOfVal = () => arrOf(anyValue$1);
      const valueOf = (validator) => value$1((v) => validator(v).fold(SimpleResult.serror, SimpleResult.svalue));
      const setOf = (validator, prop) => setOf$1((v) => SimpleResult.fromResult(validator(v)), prop);
      const extractValue = (label2, prop, obj) => {
        const res = prop.extract([label2], obj);
        return SimpleResult.mapError(res, (errs) => ({ input: obj, errors: errs }));
      };
      const asRaw = (label2, prop, obj) => SimpleResult.toResult(extractValue(label2, prop, obj));
      const getOrDie = (extraction) => {
        return extraction.fold((errInfo) => {
          throw new Error(formatError(errInfo));
        }, identity);
      };
      const asRawOrDie$1 = (label2, prop, obj) => getOrDie(asRaw(label2, prop, obj));
      const formatError = (errInfo) => {
        return "Errors: \n" + formatErrors(errInfo.errors).join("\n") + "\n\nInput object: " + formatObj(errInfo.input);
      };
      const choose$1 = (key, branches) => choose$2(key, map$1(branches, objOf));
      const thunkOf = (desc, schema2) => thunk(desc, schema2);
      const field$1 = field$2;
      const customField = customField$1;
      const validateEnum = (values2) => valueOf((value2) => contains$2(values2, value2) ? Result.value(value2) : Result.error(`Unsupported value: "${value2}", choose one of "${values2.join(", ")}".`));
      const required$1 = (key) => field$1(key, key, required$2(), anyValue());
      const requiredOf = (key, schema2) => field$1(key, key, required$2(), schema2);
      const requiredNumber = (key) => requiredOf(key, number);
      const requiredString = (key) => requiredOf(key, string);
      const requiredStringEnum = (key, values2) => field$1(key, key, required$2(), validateEnum(values2));
      const requiredFunction = (key) => requiredOf(key, functionProcessor);
      const forbid = (key, message) => field$1(key, key, asOption(), value$1((_v) => SimpleResult.serror("The field: " + key + " is forbidden. " + message)));
      const requiredObjOf = (key, objSchema) => field$1(key, key, required$2(), objOf(objSchema));
      const requiredArrayOfObj = (key, objFields) => field$1(key, key, required$2(), arrOfObj(objFields));
      const requiredArrayOf = (key, schema2) => field$1(key, key, required$2(), arrOf(schema2));
      const option$3 = (key) => field$1(key, key, asOption(), anyValue());
      const optionOf = (key, schema2) => field$1(key, key, asOption(), schema2);
      const optionNumber = (key) => optionOf(key, number);
      const optionString = (key) => optionOf(key, string);
      const optionStringEnum = (key, values2) => optionOf(key, validateEnum(values2));
      const optionFunction = (key) => optionOf(key, functionProcessor);
      const optionArrayOf = (key, schema2) => optionOf(key, arrOf(schema2));
      const optionObjOf = (key, objSchema) => optionOf(key, objOf(objSchema));
      const optionObjOfOnly = (key, objSchema) => optionOf(key, objOfOnly(objSchema));
      const defaulted = (key, fallback2) => field$1(key, key, defaulted$1(fallback2), anyValue());
      const defaultedOf = (key, fallback2, schema2) => field$1(key, key, defaulted$1(fallback2), schema2);
      const defaultedNumber = (key, fallback2) => defaultedOf(key, fallback2, number);
      const defaultedString = (key, fallback2) => defaultedOf(key, fallback2, string);
      const defaultedStringEnum = (key, fallback2, values2) => defaultedOf(key, fallback2, validateEnum(values2));
      const defaultedBoolean = (key, fallback2) => defaultedOf(key, fallback2, boolean);
      const defaultedFunction = (key, fallback2) => defaultedOf(key, fallback2, functionProcessor);
      const defaultedPostMsg = (key, fallback2) => defaultedOf(key, fallback2, postMessageable);
      const defaultedArrayOf = (key, fallback2, schema2) => defaultedOf(key, fallback2, arrOf(schema2));
      const defaultedObjOf = (key, fallback2, objSchema) => defaultedOf(key, fallback2, objOf(objSchema));
      const exclude$1 = (obj, fields) => {
        const r2 = {};
        each(obj, (v, k) => {
          if (!contains$2(fields, k)) {
            r2[k] = v;
          }
        });
        return r2;
      };
      const wrap$1 = (key, value2) => ({ [key]: value2 });
      const wrapAll$1 = (keyvalues) => {
        const r2 = {};
        each$1(keyvalues, (kv) => {
          r2[kv.key] = kv.value;
        });
        return r2;
      };
      const exclude = (obj, fields) => exclude$1(obj, fields);
      const wrap = (key, value2) => wrap$1(key, value2);
      const wrapAll = (keyvalues) => wrapAll$1(keyvalues);
      const mergeValues = (values2, base2) => {
        return values2.length === 0 ? Result.value(base2) : Result.value(
          deepMerge(base2, merge$1.apply(void 0, values2))
          // Merger.deepMerge.apply(undefined, [ base ].concat(values))
        );
      };
      const mergeErrors = (errors) => Result.error(flatten(errors));
      const consolidate = (objs, base2) => {
        const partitions = partition$2(objs);
        return partitions.errors.length > 0 ? mergeErrors(partitions.errors) : mergeValues(partitions.values, base2);
      };
      const constant = constant$1;
      const touchstart = constant("touchstart");
      const touchmove = constant("touchmove");
      const touchend = constant("touchend");
      const touchcancel = constant("touchcancel");
      const mousedown = constant("mousedown");
      const mousemove = constant("mousemove");
      const mouseout = constant("mouseout");
      const mouseup = constant("mouseup");
      const mouseover = constant("mouseover");
      const focusin = constant("focusin");
      const focusout = constant("focusout");
      const keydown = constant("keydown");
      const keyup = constant("keyup");
      const input = constant("input");
      const change = constant("change");
      const click = constant("click");
      const transitioncancel = constant("transitioncancel");
      const transitionend = constant("transitionend");
      const transitionstart = constant("transitionstart");
      const selectstart = constant("selectstart");
      const prefixName = (name2) => constant$1("alloy." + name2);
      const alloy = { tap: prefixName("tap") };
      const focus$3 = prefixName("focus");
      const postBlur = prefixName("blur.post");
      const postPaste = prefixName("paste.post");
      const receive = prefixName("receive");
      const execute$5 = prefixName("execute");
      const focusItem = prefixName("focus.item");
      const tap = alloy.tap;
      const longpress = prefixName("longpress");
      const sandboxClose = prefixName("sandbox.close");
      const typeaheadCancel = prefixName("typeahead.cancel");
      const systemInit = prefixName("system.init");
      const documentTouchmove = prefixName("system.touchmove");
      const documentTouchend = prefixName("system.touchend");
      const windowScroll = prefixName("system.scroll");
      const windowResize = prefixName("system.resize");
      const attachedToDom = prefixName("system.attached");
      const detachedFromDom = prefixName("system.detached");
      const dismissRequested = prefixName("system.dismissRequested");
      const repositionRequested = prefixName("system.repositionRequested");
      const focusShifted = prefixName("focusmanager.shifted");
      const slotVisibility = prefixName("slotcontainer.visibility");
      const externalElementScroll = prefixName("system.external.element.scroll");
      const changeTab = prefixName("change.tab");
      const dismissTab = prefixName("dismiss.tab");
      const highlight$1 = prefixName("highlight");
      const dehighlight$1 = prefixName("dehighlight");
      const element = (elem) => getHtml(elem);
      const unknown = "unknown";
      const debugging = true;
      var EventConfiguration;
      (function(EventConfiguration2) {
        EventConfiguration2[EventConfiguration2["STOP"] = 0] = "STOP";
        EventConfiguration2[EventConfiguration2["NORMAL"] = 1] = "NORMAL";
        EventConfiguration2[EventConfiguration2["LOGGING"] = 2] = "LOGGING";
      })(EventConfiguration || (EventConfiguration = {}));
      const eventConfig = Cell({});
      const makeEventLogger = (eventName, initialTarget) => {
        const sequence2 = [];
        const startTime = (/* @__PURE__ */ new Date()).getTime();
        return {
          logEventCut: (_name, target, purpose) => {
            sequence2.push({ outcome: "cut", target, purpose });
          },
          logEventStopped: (_name, target, purpose) => {
            sequence2.push({ outcome: "stopped", target, purpose });
          },
          logNoParent: (_name, target, purpose) => {
            sequence2.push({ outcome: "no-parent", target, purpose });
          },
          logEventNoHandlers: (_name, target) => {
            sequence2.push({ outcome: "no-handlers-left", target });
          },
          logEventResponse: (_name, target, purpose) => {
            sequence2.push({ outcome: "response", purpose, target });
          },
          write: () => {
            const finishTime = (/* @__PURE__ */ new Date()).getTime();
            if (contains$2(["mousemove", "mouseover", "mouseout", systemInit()], eventName)) {
              return;
            }
            console.log(eventName, {
              event: eventName,
              time: finishTime - startTime,
              target: initialTarget.dom,
              sequence: map$2(sequence2, (s) => {
                if (!contains$2(["cut", "stopped", "response"], s.outcome)) {
                  return s.outcome;
                } else {
                  return "{" + s.purpose + "} " + s.outcome + " at (" + element(s.target) + ")";
                }
              })
            });
          }
        };
      };
      const processEvent = (eventName, initialTarget, f2) => {
        const status = get$h(eventConfig.get(), eventName).orThunk(() => {
          const patterns = keys(eventConfig.get());
          return findMap(patterns, (p) => eventName.indexOf(p) > -1 ? Optional.some(eventConfig.get()[p]) : Optional.none());
        }).getOr(EventConfiguration.NORMAL);
        switch (status) {
          case EventConfiguration.NORMAL:
            return f2(noLogger());
          case EventConfiguration.LOGGING: {
            const logger = makeEventLogger(eventName, initialTarget);
            const output2 = f2(logger);
            logger.write();
            return output2;
          }
          case EventConfiguration.STOP:
            return true;
        }
      };
      const path = [
        "alloy/data/Fields",
        "alloy/debugging/Debugging"
      ];
      const getTrace = () => {
        if (debugging === false) {
          return unknown;
        }
        const err = new Error();
        if (err.stack !== void 0) {
          const lines = err.stack.split("\n");
          return find$5(lines, (line) => line.indexOf("alloy") > 0 && !exists(path, (p) => line.indexOf(p) > -1)).getOr(unknown);
        } else {
          return unknown;
        }
      };
      const ignoreEvent = {
        logEventCut: noop,
        logEventStopped: noop,
        logNoParent: noop,
        logEventNoHandlers: noop,
        logEventResponse: noop,
        write: noop
      };
      const monitorEvent = (eventName, initialTarget, f2) => processEvent(eventName, initialTarget, f2);
      const noLogger = constant$1(ignoreEvent);
      const menuFields = constant$1([
        required$1("menu"),
        required$1("selectedMenu")
      ]);
      const itemFields = constant$1([
        required$1("item"),
        required$1("selectedItem")
      ]);
      constant$1(objOf(itemFields().concat(menuFields())));
      const itemSchema$3 = constant$1(objOf(itemFields()));
      const _initSize = requiredObjOf("initSize", [
        required$1("numColumns"),
        required$1("numRows")
      ]);
      const itemMarkers = () => requiredOf("markers", itemSchema$3());
      const tieredMenuMarkers = () => requiredObjOf("markers", [
        required$1("backgroundMenu")
      ].concat(menuFields()).concat(itemFields()));
      const markers$1 = (required2) => requiredObjOf("markers", map$2(required2, required$1));
      const onPresenceHandler = (label2, fieldName, presence) => {
        getTrace();
        return field$1(
          fieldName,
          fieldName,
          presence,
          // Apply some wrapping to their supplied function
          valueOf((f2) => Result.value((...args) => {
            return f2.apply(void 0, args);
          }))
        );
      };
      const onHandler = (fieldName) => onPresenceHandler("onHandler", fieldName, defaulted$1(noop));
      const onKeyboardHandler = (fieldName) => onPresenceHandler("onKeyboardHandler", fieldName, defaulted$1(Optional.none));
      const onStrictHandler = (fieldName) => onPresenceHandler("onHandler", fieldName, required$2());
      const onStrictKeyboardHandler = (fieldName) => onPresenceHandler("onKeyboardHandler", fieldName, required$2());
      const output$1 = (name2, value2) => customField(name2, constant$1(value2));
      const snapshot = (name2) => customField(name2, identity);
      const initSize = constant$1(_initSize);
      const markAsBehaviourApi = (f2, apiName, apiFunction) => {
        const delegate = apiFunction.toString();
        const endIndex = delegate.indexOf(")") + 1;
        const openBracketIndex = delegate.indexOf("(");
        const parameters = delegate.substring(openBracketIndex + 1, endIndex - 1).split(/,\s*/);
        f2.toFunctionAnnotation = () => ({
          name: apiName,
          parameters: cleanParameters(parameters.slice(0, 1).concat(parameters.slice(3)))
        });
        return f2;
      };
      const cleanParameters = (parameters) => map$2(parameters, (p) => endsWith(p, "/*") ? p.substring(0, p.length - "/*".length) : p);
      const markAsExtraApi = (f2, extraName) => {
        const delegate = f2.toString();
        const endIndex = delegate.indexOf(")") + 1;
        const openBracketIndex = delegate.indexOf("(");
        const parameters = delegate.substring(openBracketIndex + 1, endIndex - 1).split(/,\s*/);
        f2.toFunctionAnnotation = () => ({
          name: extraName,
          parameters: cleanParameters(parameters)
        });
        return f2;
      };
      const markAsSketchApi = (f2, apiFunction) => {
        const delegate = apiFunction.toString();
        const endIndex = delegate.indexOf(")") + 1;
        const openBracketIndex = delegate.indexOf("(");
        const parameters = delegate.substring(openBracketIndex + 1, endIndex - 1).split(/,\s*/);
        f2.toFunctionAnnotation = () => ({
          name: "OVERRIDE",
          parameters: cleanParameters(parameters.slice(1))
        });
        return f2;
      };
      const DelayedFunction = (fun, delay) => {
        let ref = null;
        const schedule = (...args) => {
          ref = setTimeout(() => {
            fun.apply(null, args);
            ref = null;
          }, delay);
        };
        const cancel = () => {
          if (ref !== null) {
            clearTimeout(ref);
            ref = null;
          }
        };
        return {
          cancel,
          schedule
        };
      };
      const SIGNIFICANT_MOVE = 5;
      const LONGPRESS_DELAY = 400;
      const getTouch = (event) => {
        const raw = event.raw;
        if (raw.touches === void 0 || raw.touches.length !== 1) {
          return Optional.none();
        }
        return Optional.some(raw.touches[0]);
      };
      const isFarEnough = (touch2, data) => {
        const distX = Math.abs(touch2.clientX - data.x);
        const distY = Math.abs(touch2.clientY - data.y);
        return distX > SIGNIFICANT_MOVE || distY > SIGNIFICANT_MOVE;
      };
      const monitor = (settings) => {
        const startData = value$2();
        const longpressFired = Cell(false);
        const longpress$1 = DelayedFunction((event) => {
          settings.triggerEvent(longpress(), event);
          longpressFired.set(true);
        }, LONGPRESS_DELAY);
        const handleTouchstart = (event) => {
          getTouch(event).each((touch2) => {
            longpress$1.cancel();
            const data = {
              x: touch2.clientX,
              y: touch2.clientY,
              target: event.target
            };
            longpress$1.schedule(event);
            longpressFired.set(false);
            startData.set(data);
          });
          return Optional.none();
        };
        const handleTouchmove = (event) => {
          longpress$1.cancel();
          getTouch(event).each((touch2) => {
            startData.on((data) => {
              if (isFarEnough(touch2, data)) {
                startData.clear();
              }
            });
          });
          return Optional.none();
        };
        const handleTouchend = (event) => {
          longpress$1.cancel();
          const isSame = (data) => eq(data.target, event.target);
          return startData.get().filter(isSame).map((_data) => {
            if (longpressFired.get()) {
              event.prevent();
              return false;
            } else {
              return settings.triggerEvent(tap(), event);
            }
          });
        };
        const handlers2 = wrapAll([
          { key: touchstart(), value: handleTouchstart },
          { key: touchmove(), value: handleTouchmove },
          { key: touchend(), value: handleTouchend }
        ]);
        const fireIfReady = (event, type2) => get$h(handlers2, type2).bind((handler) => handler(event));
        return {
          fireIfReady
        };
      };
      var FocusInsideModes;
      (function(FocusInsideModes2) {
        FocusInsideModes2["OnFocusMode"] = "onFocus";
        FocusInsideModes2["OnEnterOrSpaceMode"] = "onEnterOrSpace";
        FocusInsideModes2["OnApiMode"] = "onApi";
      })(FocusInsideModes || (FocusInsideModes = {}));
      const _placeholder = "placeholder";
      const adt$7 = Adt.generate([
        { single: ["required", "valueThunk"] },
        { multiple: ["required", "valueThunks"] }
      ]);
      const isSubstituted = (spec) => has$2(spec, "uiType");
      const subPlaceholder = (owner2, detail, compSpec, placeholders) => {
        if (owner2.exists((o) => o !== compSpec.owner)) {
          return adt$7.single(true, constant$1(compSpec));
        }
        return get$h(placeholders, compSpec.name).fold(() => {
          throw new Error("Unknown placeholder component: " + compSpec.name + "\nKnown: [" + keys(placeholders) + "]\nNamespace: " + owner2.getOr("none") + "\nSpec: " + JSON.stringify(compSpec, null, 2));
        }, (newSpec) => (
          // Must return a single/multiple type
          newSpec.replace()
        ));
      };
      const scan = (owner2, detail, compSpec, placeholders) => {
        if (isSubstituted(compSpec) && compSpec.uiType === _placeholder) {
          return subPlaceholder(owner2, detail, compSpec, placeholders);
        } else {
          return adt$7.single(false, constant$1(compSpec));
        }
      };
      const substitute = (owner2, detail, compSpec, placeholders) => {
        const base2 = scan(owner2, detail, compSpec, placeholders);
        return base2.fold((req, valueThunk2) => {
          const value2 = isSubstituted(compSpec) ? valueThunk2(detail, compSpec.config, compSpec.validated) : valueThunk2(detail);
          const childSpecs = get$h(value2, "components").getOr([]);
          const substituted = bind$3(childSpecs, (c) => substitute(owner2, detail, c, placeholders));
          return [
            {
              ...value2,
              components: substituted
            }
          ];
        }, (req, valuesThunk) => {
          if (isSubstituted(compSpec)) {
            const values2 = valuesThunk(detail, compSpec.config, compSpec.validated);
            const preprocessor = compSpec.validated.preprocess.getOr(identity);
            return preprocessor(values2);
          } else {
            return valuesThunk(detail);
          }
        });
      };
      const substituteAll = (owner2, detail, components2, placeholders) => bind$3(components2, (c) => substitute(owner2, detail, c, placeholders));
      const oneReplace = (label2, replacements) => {
        let called = false;
        const used = () => called;
        const replace2 = () => {
          if (called) {
            throw new Error("Trying to use the same placeholder more than once: " + label2);
          }
          called = true;
          return replacements;
        };
        const required2 = () => replacements.fold((req, _) => req, (req, _) => req);
        return {
          name: constant$1(label2),
          required: required2,
          used,
          replace: replace2
        };
      };
      const substitutePlaces = (owner2, detail, components2, placeholders) => {
        const ps = map$1(placeholders, (ph, name2) => oneReplace(name2, ph));
        const outcome = substituteAll(owner2, detail, components2, ps);
        each(ps, (p) => {
          if (p.used() === false && p.required()) {
            throw new Error("Placeholder: " + p.name() + " was not found in components list\nNamespace: " + owner2.getOr("none") + "\nComponents: " + JSON.stringify(detail.components, null, 2));
          }
        });
        return outcome;
      };
      const single$2 = adt$7.single;
      const multiple = adt$7.multiple;
      const placeholder = constant$1(_placeholder);
      const adt$6 = Adt.generate([
        { required: ["data"] },
        { external: ["data"] },
        { optional: ["data"] },
        { group: ["data"] }
      ]);
      const fFactory = defaulted("factory", { sketch: identity });
      const fSchema = defaulted("schema", []);
      const fName = required$1("name");
      const fPname = field$1("pname", "pname", defaultedThunk((typeSpec) => "<alloy." + generate$6(typeSpec.name) + ">"), anyValue());
      const fGroupSchema = customField("schema", () => [
        option$3("preprocess")
      ]);
      const fDefaults = defaulted("defaults", constant$1({}));
      const fOverrides = defaulted("overrides", constant$1({}));
      const requiredSpec = objOf([
        fFactory,
        fSchema,
        fName,
        fPname,
        fDefaults,
        fOverrides
      ]);
      const externalSpec = objOf([
        fFactory,
        fSchema,
        fName,
        fDefaults,
        fOverrides
      ]);
      const optionalSpec = objOf([
        fFactory,
        fSchema,
        fName,
        fPname,
        fDefaults,
        fOverrides
      ]);
      const groupSpec = objOf([
        fFactory,
        fGroupSchema,
        fName,
        required$1("unit"),
        fPname,
        fDefaults,
        fOverrides
      ]);
      const asNamedPart = (part2) => {
        return part2.fold(Optional.some, Optional.none, Optional.some, Optional.some);
      };
      const name$2 = (part2) => {
        const get2 = (data) => data.name;
        return part2.fold(get2, get2, get2, get2);
      };
      const asCommon = (part2) => {
        return part2.fold(identity, identity, identity, identity);
      };
      const convert = (adtConstructor, partSchema) => (spec) => {
        const data = asRawOrDie$1("Converting part type", partSchema, spec);
        return adtConstructor(data);
      };
      const required = convert(adt$6.required, requiredSpec);
      const external$1 = convert(adt$6.external, externalSpec);
      const optional = convert(adt$6.optional, optionalSpec);
      const group = convert(adt$6.group, groupSpec);
      const original = constant$1("entirety");
      var PartType = Object.freeze({
        __proto__: null,
        required,
        external: external$1,
        optional,
        group,
        asNamedPart,
        name: name$2,
        asCommon,
        original
      });
      const combine$2 = (detail, data, partSpec, partValidated) => (
        // Extremely confusing names and types :(
        deepMerge(data.defaults(detail, partSpec, partValidated), partSpec, { uid: detail.partUids[data.name] }, data.overrides(detail, partSpec, partValidated))
      );
      const subs = (owner2, detail, parts2) => {
        const internals = {};
        const externals = {};
        each$1(parts2, (part2) => {
          part2.fold(
            // Internal
            (data) => {
              internals[data.pname] = single$2(true, (detail2, partSpec, partValidated) => data.factory.sketch(combine$2(detail2, data, partSpec, partValidated)));
            },
            // External
            (data) => {
              const partSpec = detail.parts[data.name];
              externals[data.name] = constant$1(
                data.factory.sketch(combine$2(detail, data, partSpec[original()]), partSpec)
                // This is missing partValidated
              );
            },
            // Optional
            (data) => {
              internals[data.pname] = single$2(false, (detail2, partSpec, partValidated) => data.factory.sketch(combine$2(detail2, data, partSpec, partValidated)));
            },
            // Group
            (data) => {
              internals[data.pname] = multiple(true, (detail2, _partSpec, _partValidated) => {
                const units2 = detail2[data.name];
                return map$2(units2, (u) => (
                  // Group multiples do not take the uid because there is more than one.
                  data.factory.sketch(deepMerge(data.defaults(detail2, u, _partValidated), u, data.overrides(detail2, u)))
                ));
              });
            }
          );
        });
        return {
          internals: constant$1(internals),
          externals: constant$1(externals)
        };
      };
      const generate$5 = (owner2, parts2) => {
        const r2 = {};
        each$1(parts2, (part2) => {
          asNamedPart(part2).each((np) => {
            const g = doGenerateOne(owner2, np.pname);
            r2[np.name] = (config2) => {
              const validated = asRawOrDie$1("Part: " + np.name + " in " + owner2, objOf(np.schema), config2);
              return {
                ...g,
                config: config2,
                validated
              };
            };
          });
        });
        return r2;
      };
      const doGenerateOne = (owner2, pname) => ({
        uiType: placeholder(),
        owner: owner2,
        name: pname
      });
      const generateOne$1 = (owner2, pname, config2) => ({
        uiType: placeholder(),
        owner: owner2,
        name: pname,
        config: config2,
        validated: {}
      });
      const schemas = (parts2) => (
        // This actually has to change. It needs to return the schemas for things that will
        // not appear in the components list, which is only externals
        bind$3(parts2, (part2) => part2.fold(Optional.none, Optional.some, Optional.none, Optional.none).map((data) => requiredObjOf(data.name, data.schema.concat([
          snapshot(original())
        ]))).toArray())
      );
      const names = (parts2) => map$2(parts2, name$2);
      const substitutes = (owner2, detail, parts2) => subs(owner2, detail, parts2);
      const components$1 = (owner2, detail, internals) => substitutePlaces(Optional.some(owner2), detail, detail.components, internals);
      const getPart = (component, detail, partKey) => {
        const uid = detail.partUids[partKey];
        return component.getSystem().getByUid(uid).toOptional();
      };
      const getPartOrDie = (component, detail, partKey) => getPart(component, detail, partKey).getOrDie("Could not find part: " + partKey);
      const getParts = (component, detail, partKeys) => {
        const r2 = {};
        const uids2 = detail.partUids;
        const system = component.getSystem();
        each$1(partKeys, (pk) => {
          r2[pk] = constant$1(system.getByUid(uids2[pk]));
        });
        return r2;
      };
      const getAllParts = (component, detail) => {
        const system = component.getSystem();
        return map$1(detail.partUids, (pUid, _k) => constant$1(system.getByUid(pUid)));
      };
      const getAllPartNames = (detail) => keys(detail.partUids);
      const getPartsOrDie = (component, detail, partKeys) => {
        const r2 = {};
        const uids2 = detail.partUids;
        const system = component.getSystem();
        each$1(partKeys, (pk) => {
          r2[pk] = constant$1(system.getByUid(uids2[pk]).getOrDie());
        });
        return r2;
      };
      const defaultUids = (baseUid, partTypes) => {
        const partNames = names(partTypes);
        return wrapAll(map$2(partNames, (pn) => ({ key: pn, value: baseUid + "-" + pn })));
      };
      const defaultUidsSchema = (partTypes) => field$1("partUids", "partUids", mergeWithThunk((spec) => defaultUids(spec.uid, partTypes)), anyValue());
      var AlloyParts = Object.freeze({
        __proto__: null,
        generate: generate$5,
        generateOne: generateOne$1,
        schemas,
        names,
        substitutes,
        components: components$1,
        defaultUids,
        defaultUidsSchema,
        getAllParts,
        getAllPartNames,
        getPart,
        getPartOrDie,
        getParts,
        getPartsOrDie
      });
      const allAlignments = [
        "valignCentre",
        "alignLeft",
        "alignRight",
        "alignCentre",
        "top",
        "bottom",
        "left",
        "right",
        "inset"
      ];
      const nu$6 = (xOffset, yOffset, classes2, insetModifier = 1) => {
        const insetXOffset = xOffset * insetModifier;
        const insetYOffset = yOffset * insetModifier;
        const getClasses2 = (prop) => get$h(classes2, prop).getOr([]);
        const make2 = (xDelta, yDelta, alignmentsOn) => {
          const alignmentsOff = difference(allAlignments, alignmentsOn);
          return {
            offset: SugarPosition(xDelta, yDelta),
            classesOn: bind$3(alignmentsOn, getClasses2),
            classesOff: bind$3(alignmentsOff, getClasses2)
          };
        };
        return {
          southeast: () => make2(-xOffset, yOffset, ["top", "alignLeft"]),
          southwest: () => make2(xOffset, yOffset, ["top", "alignRight"]),
          south: () => make2(-xOffset / 2, yOffset, ["top", "alignCentre"]),
          northeast: () => make2(-xOffset, -yOffset, ["bottom", "alignLeft"]),
          northwest: () => make2(xOffset, -yOffset, ["bottom", "alignRight"]),
          north: () => make2(-xOffset / 2, -yOffset, ["bottom", "alignCentre"]),
          east: () => make2(xOffset, -yOffset / 2, ["valignCentre", "left"]),
          west: () => make2(-xOffset, -yOffset / 2, ["valignCentre", "right"]),
          insetNortheast: () => make2(insetXOffset, insetYOffset, ["top", "alignLeft", "inset"]),
          insetNorthwest: () => make2(-insetXOffset, insetYOffset, ["top", "alignRight", "inset"]),
          insetNorth: () => make2(-insetXOffset / 2, insetYOffset, ["top", "alignCentre", "inset"]),
          insetSoutheast: () => make2(insetXOffset, -insetYOffset, ["bottom", "alignLeft", "inset"]),
          insetSouthwest: () => make2(-insetXOffset, -insetYOffset, ["bottom", "alignRight", "inset"]),
          insetSouth: () => make2(-insetXOffset / 2, -insetYOffset, ["bottom", "alignCentre", "inset"]),
          insetEast: () => make2(-insetXOffset, -insetYOffset / 2, ["valignCentre", "right", "inset"]),
          insetWest: () => make2(insetXOffset, -insetYOffset / 2, ["valignCentre", "left", "inset"])
        };
      };
      const fallback = () => nu$6(0, 0, {});
      const nu$5 = (x, y, bubble, direction, placement2, boundsRestriction2, labelPrefix2, alwaysFit = false) => ({
        x,
        y,
        bubble,
        direction,
        placement: placement2,
        restriction: boundsRestriction2,
        label: `${labelPrefix2}-${placement2}`,
        alwaysFit
      });
      const adt$5 = Adt.generate([
        { southeast: [] },
        { southwest: [] },
        { northeast: [] },
        { northwest: [] },
        { south: [] },
        { north: [] },
        { east: [] },
        { west: [] }
      ]);
      const cata$1 = (subject, southeast2, southwest2, northeast2, northwest2, south2, north2, east2, west2) => subject.fold(southeast2, southwest2, northeast2, northwest2, south2, north2, east2, west2);
      const cataVertical = (subject, south2, middle, north2) => subject.fold(south2, south2, north2, north2, south2, north2, middle, middle);
      const cataHorizontal = (subject, east2, middle, west2) => subject.fold(east2, west2, east2, west2, middle, middle, east2, west2);
      const southeast$3 = adt$5.southeast;
      const southwest$3 = adt$5.southwest;
      const northeast$3 = adt$5.northeast;
      const northwest$3 = adt$5.northwest;
      const south$3 = adt$5.south;
      const north$3 = adt$5.north;
      const east$3 = adt$5.east;
      const west$3 = adt$5.west;
      const getRestriction = (anchor2, restriction) => {
        switch (restriction) {
          case 1:
            return anchor2.x;
          case 0:
            return anchor2.x + anchor2.width;
          case 2:
            return anchor2.y;
          case 3:
            return anchor2.y + anchor2.height;
        }
      };
      const boundsRestriction = (anchor2, restrictions) => mapToObject(["left", "right", "top", "bottom"], (dir) => get$h(restrictions, dir).map((restriction) => getRestriction(anchor2, restriction)));
      const adjustBounds = (bounds$12, restriction, bubbleOffset) => {
        const applyRestriction = (dir, current) => restriction[dir].map((pos) => {
          const isVerticalAxis = dir === "top" || dir === "bottom";
          const offset2 = isVerticalAxis ? bubbleOffset.top : bubbleOffset.left;
          const comparator = dir === "left" || dir === "top" ? Math.max : Math.min;
          const newPos = comparator(pos, current) + offset2;
          return isVerticalAxis ? clamp(newPos, bounds$12.y, bounds$12.bottom) : clamp(newPos, bounds$12.x, bounds$12.right);
        }).getOr(current);
        const adjustedLeft = applyRestriction("left", bounds$12.x);
        const adjustedTop = applyRestriction("top", bounds$12.y);
        const adjustedRight = applyRestriction("right", bounds$12.right);
        const adjustedBottom = applyRestriction("bottom", bounds$12.bottom);
        return bounds(adjustedLeft, adjustedTop, adjustedRight - adjustedLeft, adjustedBottom - adjustedTop);
      };
      const labelPrefix$2 = "layout";
      const eastX$1 = (anchor2) => anchor2.x;
      const middleX$1 = (anchor2, element2) => anchor2.x + anchor2.width / 2 - element2.width / 2;
      const westX$1 = (anchor2, element2) => anchor2.x + anchor2.width - element2.width;
      const northY$2 = (anchor2, element2) => anchor2.y - element2.height;
      const southY$2 = (anchor2) => anchor2.y + anchor2.height;
      const centreY$1 = (anchor2, element2) => anchor2.y + anchor2.height / 2 - element2.height / 2;
      const eastEdgeX$1 = (anchor2) => anchor2.x + anchor2.width;
      const westEdgeX$1 = (anchor2, element2) => anchor2.x - element2.width;
      const southeast$2 = (anchor2, element2, bubbles) => nu$5(eastX$1(anchor2), southY$2(anchor2), bubbles.southeast(), southeast$3(), "southeast", boundsRestriction(anchor2, {
        left: 1,
        top: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix$2);
      const southwest$2 = (anchor2, element2, bubbles) => nu$5(westX$1(anchor2, element2), southY$2(anchor2), bubbles.southwest(), southwest$3(), "southwest", boundsRestriction(anchor2, {
        right: 0,
        top: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix$2);
      const northeast$2 = (anchor2, element2, bubbles) => nu$5(eastX$1(anchor2), northY$2(anchor2, element2), bubbles.northeast(), northeast$3(), "northeast", boundsRestriction(anchor2, {
        left: 1,
        bottom: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix$2);
      const northwest$2 = (anchor2, element2, bubbles) => nu$5(westX$1(anchor2, element2), northY$2(anchor2, element2), bubbles.northwest(), northwest$3(), "northwest", boundsRestriction(anchor2, {
        right: 0,
        bottom: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix$2);
      const north$2 = (anchor2, element2, bubbles) => nu$5(middleX$1(anchor2, element2), northY$2(anchor2, element2), bubbles.north(), north$3(), "north", boundsRestriction(anchor2, {
        bottom: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix$2);
      const south$2 = (anchor2, element2, bubbles) => nu$5(middleX$1(anchor2, element2), southY$2(anchor2), bubbles.south(), south$3(), "south", boundsRestriction(anchor2, {
        top: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix$2);
      const east$2 = (anchor2, element2, bubbles) => nu$5(eastEdgeX$1(anchor2), centreY$1(anchor2, element2), bubbles.east(), east$3(), "east", boundsRestriction(anchor2, {
        left: 0
        /* AnchorBoxBounds.RightEdge */
      }), labelPrefix$2);
      const west$2 = (anchor2, element2, bubbles) => nu$5(westEdgeX$1(anchor2, element2), centreY$1(anchor2, element2), bubbles.west(), west$3(), "west", boundsRestriction(anchor2, {
        right: 1
        /* AnchorBoxBounds.LeftEdge */
      }), labelPrefix$2);
      const all$2 = () => [southeast$2, southwest$2, northeast$2, northwest$2, south$2, north$2, east$2, west$2];
      const allRtl$1 = () => [southwest$2, southeast$2, northwest$2, northeast$2, south$2, north$2, east$2, west$2];
      const aboveOrBelow = () => [northeast$2, northwest$2, southeast$2, southwest$2, north$2, south$2];
      const aboveOrBelowRtl = () => [northwest$2, northeast$2, southwest$2, southeast$2, north$2, south$2];
      const belowOrAbove = () => [southeast$2, southwest$2, northeast$2, northwest$2, south$2, north$2];
      const belowOrAboveRtl = () => [southwest$2, southeast$2, northwest$2, northeast$2, south$2, north$2];
      const placementAttribute = "data-alloy-placement";
      const setPlacement$1 = (element2, placement2) => {
        set$9(element2, placementAttribute, placement2);
      };
      const getPlacement = (element2) => getOpt(element2, placementAttribute);
      const reset$2 = (element2) => remove$8(element2, placementAttribute);
      const labelPrefix$1 = "layout-inset";
      const westEdgeX = (anchor2) => anchor2.x;
      const middleX = (anchor2, element2) => anchor2.x + anchor2.width / 2 - element2.width / 2;
      const eastEdgeX = (anchor2, element2) => anchor2.x + anchor2.width - element2.width;
      const northY$1 = (anchor2) => anchor2.y;
      const southY$1 = (anchor2, element2) => anchor2.y + anchor2.height - element2.height;
      const centreY = (anchor2, element2) => anchor2.y + anchor2.height / 2 - element2.height / 2;
      const southwest$1 = (anchor2, element2, bubbles) => nu$5(eastEdgeX(anchor2, element2), southY$1(anchor2, element2), bubbles.insetSouthwest(), northwest$3(), "southwest", boundsRestriction(anchor2, {
        right: 0,
        bottom: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix$1);
      const southeast$1 = (anchor2, element2, bubbles) => nu$5(westEdgeX(anchor2), southY$1(anchor2, element2), bubbles.insetSoutheast(), northeast$3(), "southeast", boundsRestriction(anchor2, {
        left: 1,
        bottom: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix$1);
      const northwest$1 = (anchor2, element2, bubbles) => nu$5(eastEdgeX(anchor2, element2), northY$1(anchor2), bubbles.insetNorthwest(), southwest$3(), "northwest", boundsRestriction(anchor2, {
        right: 0,
        top: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix$1);
      const northeast$1 = (anchor2, element2, bubbles) => nu$5(westEdgeX(anchor2), northY$1(anchor2), bubbles.insetNortheast(), southeast$3(), "northeast", boundsRestriction(anchor2, {
        left: 1,
        top: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix$1);
      const north$1 = (anchor2, element2, bubbles) => nu$5(middleX(anchor2, element2), northY$1(anchor2), bubbles.insetNorth(), south$3(), "north", boundsRestriction(anchor2, {
        top: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix$1);
      const south$1 = (anchor2, element2, bubbles) => nu$5(middleX(anchor2, element2), southY$1(anchor2, element2), bubbles.insetSouth(), north$3(), "south", boundsRestriction(anchor2, {
        bottom: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix$1);
      const east$1 = (anchor2, element2, bubbles) => nu$5(eastEdgeX(anchor2, element2), centreY(anchor2, element2), bubbles.insetEast(), west$3(), "east", boundsRestriction(anchor2, {
        right: 0
        /* AnchorBoxBounds.RightEdge */
      }), labelPrefix$1);
      const west$1 = (anchor2, element2, bubbles) => nu$5(westEdgeX(anchor2), centreY(anchor2, element2), bubbles.insetWest(), east$3(), "west", boundsRestriction(anchor2, {
        left: 1
        /* AnchorBoxBounds.LeftEdge */
      }), labelPrefix$1);
      const lookupPreserveLayout = (lastPlacement) => {
        switch (lastPlacement) {
          case "north":
            return north$1;
          case "northeast":
            return northeast$1;
          case "northwest":
            return northwest$1;
          case "south":
            return south$1;
          case "southeast":
            return southeast$1;
          case "southwest":
            return southwest$1;
          case "east":
            return east$1;
          case "west":
            return west$1;
        }
      };
      const preserve$1 = (anchor2, element2, bubbles, placee, bounds2) => {
        const layout2 = getPlacement(placee).map(lookupPreserveLayout).getOr(north$1);
        return layout2(anchor2, element2, bubbles, placee, bounds2);
      };
      const lookupFlippedLayout = (lastPlacement) => {
        switch (lastPlacement) {
          case "north":
            return south$1;
          case "northeast":
            return southeast$1;
          case "northwest":
            return southwest$1;
          case "south":
            return north$1;
          case "southeast":
            return northeast$1;
          case "southwest":
            return northwest$1;
          case "east":
            return west$1;
          case "west":
            return east$1;
        }
      };
      const flip = (anchor2, element2, bubbles, placee, bounds2) => {
        const layout2 = getPlacement(placee).map(lookupFlippedLayout).getOr(north$1);
        return layout2(anchor2, element2, bubbles, placee, bounds2);
      };
      const setMaxHeight = (element2, maxHeight) => {
        setMax$1(element2, Math.floor(maxHeight));
      };
      const anchored = constant$1((element2, available) => {
        setMaxHeight(element2, available);
        setAll(element2, {
          "overflow-x": "hidden",
          "overflow-y": "auto"
        });
      });
      const expandable$1 = constant$1((element2, available) => {
        setMaxHeight(element2, available);
      });
      const expandable = constant$1((element2, available) => {
        setMax(element2, Math.floor(available));
      });
      var AttributeValue;
      (function(AttributeValue2) {
        AttributeValue2["TopToBottom"] = "toptobottom";
        AttributeValue2["BottomToTop"] = "bottomtotop";
      })(AttributeValue || (AttributeValue = {}));
      const Attribute = "data-alloy-vertical-dir";
      const isBottomToTopDir = (el) => closest$2(el, (current) => isElement$1(current) && get$g(current, "data-alloy-vertical-dir") === AttributeValue.BottomToTop);
      var HighlightOnOpen;
      (function(HighlightOnOpen2) {
        HighlightOnOpen2[HighlightOnOpen2["HighlightMenuAndItem"] = 0] = "HighlightMenuAndItem";
        HighlightOnOpen2[HighlightOnOpen2["HighlightJustMenu"] = 1] = "HighlightJustMenu";
        HighlightOnOpen2[HighlightOnOpen2["HighlightNone"] = 2] = "HighlightNone";
      })(HighlightOnOpen || (HighlightOnOpen = {}));
      const NoState = {
        init: () => nu$4({
          readState: constant$1("No State required")
        })
      };
      const nu$4 = (spec) => spec;
      const defaultEventHandler = {
        can: always,
        abort: never,
        run: noop
      };
      const nu$3 = (parts2) => {
        if (!hasNonNullableKey(parts2, "can") && !hasNonNullableKey(parts2, "abort") && !hasNonNullableKey(parts2, "run")) {
          throw new Error("EventHandler defined by: " + JSON.stringify(parts2, null, 2) + " does not have can, abort, or run!");
        }
        return {
          ...defaultEventHandler,
          ...parts2
        };
      };
      const all$1 = (handlers2, f2) => (...args) => foldl(handlers2, (acc, handler) => acc && f2(handler).apply(void 0, args), true);
      const any = (handlers2, f2) => (...args) => foldl(handlers2, (acc, handler) => acc || f2(handler).apply(void 0, args), false);
      const read$1 = (handler) => isFunction(handler) ? {
        can: always,
        abort: never,
        run: handler
      } : handler;
      const fuse$1 = (handlers2) => {
        const can2 = all$1(handlers2, (handler) => handler.can);
        const abort2 = any(handlers2, (handler) => handler.abort);
        const run2 = (...args) => {
          each$1(handlers2, (handler) => {
            handler.run.apply(void 0, args);
          });
        };
        return {
          can: can2,
          abort: abort2,
          run: run2
        };
      };
      const emit = (component, event) => {
        dispatchWith(component, component.element, event, {});
      };
      const emitWith = (component, event, properties2) => {
        dispatchWith(component, component.element, event, properties2);
      };
      const emitExecute = (component) => {
        emit(component, execute$5());
      };
      const dispatch = (component, target, event) => {
        dispatchWith(component, target, event, {});
      };
      const dispatchWith = (component, target, event, properties2) => {
        const data = {
          target,
          ...properties2
        };
        component.getSystem().triggerEvent(event, target, data);
      };
      const retargetAndDispatchWith = (component, target, eventName, properties2) => {
        const data = {
          ...properties2,
          target
        };
        component.getSystem().triggerEvent(eventName, target, data);
      };
      const dispatchEvent = (component, target, event, simulatedEvent) => {
        component.getSystem().triggerEvent(event, target, simulatedEvent.event);
      };
      const derive$2 = (configs) => wrapAll(configs);
      const abort = (name2, predicate) => {
        return {
          key: name2,
          value: nu$3({
            abort: predicate
          })
        };
      };
      const can = (name2, predicate) => {
        return {
          key: name2,
          value: nu$3({
            can: predicate
          })
        };
      };
      const preventDefault = (name2) => {
        return {
          key: name2,
          value: nu$3({
            run: (component, simulatedEvent) => {
              simulatedEvent.event.prevent();
            }
          })
        };
      };
      const run$1 = (name2, handler) => {
        return {
          key: name2,
          value: nu$3({
            run: handler
          })
        };
      };
      const runActionExtra = (name2, action, extra) => {
        return {
          key: name2,
          value: nu$3({
            run: (component, simulatedEvent) => {
              action.apply(void 0, [component, simulatedEvent].concat(extra));
            }
          })
        };
      };
      const runOnName = (name2) => {
        return (handler) => run$1(name2, handler);
      };
      const runOnSourceName = (name2) => {
        return (handler) => ({
          key: name2,
          value: nu$3({
            run: (component, simulatedEvent) => {
              if (isSource(component, simulatedEvent)) {
                handler(component, simulatedEvent);
              }
            }
          })
        });
      };
      const redirectToUid = (name2, uid) => {
        return run$1(name2, (component, simulatedEvent) => {
          component.getSystem().getByUid(uid).each((redirectee) => {
            dispatchEvent(redirectee, redirectee.element, name2, simulatedEvent);
          });
        });
      };
      const redirectToPart = (name2, detail, partName) => {
        const uid = detail.partUids[partName];
        return redirectToUid(name2, uid);
      };
      const runWithTarget = (name2, f2) => {
        return run$1(name2, (component, simulatedEvent) => {
          const ev = simulatedEvent.event;
          const target = component.getSystem().getByDom(ev.target).getOrThunk(
            // If we don't find an alloy component for the target, I guess we go up the tree
            // until we find an alloy component? Performance concern?
            // TODO: Write tests for this.
            () => {
              const closest$12 = closest(ev.target, (el) => component.getSystem().getByDom(el).toOptional(), never);
              return closest$12.getOr(component);
            }
          );
          f2(component, target, simulatedEvent);
        });
      };
      const cutter = (name2) => {
        return run$1(name2, (component, simulatedEvent) => {
          simulatedEvent.cut();
        });
      };
      const stopper = (name2) => {
        return run$1(name2, (component, simulatedEvent) => {
          simulatedEvent.stop();
        });
      };
      const runOnSource = (name2, f2) => {
        return runOnSourceName(name2)(f2);
      };
      const runOnAttached = runOnSourceName(attachedToDom());
      const runOnDetached = runOnSourceName(detachedFromDom());
      const runOnInit = runOnSourceName(systemInit());
      const runOnExecute$1 = runOnName(execute$5());
      const nu$2 = (s) => ({
        classes: isUndefined(s.classes) ? [] : s.classes,
        attributes: isUndefined(s.attributes) ? {} : s.attributes,
        styles: isUndefined(s.styles) ? {} : s.styles
      });
      const merge = (defnA, mod) => ({
        ...defnA,
        attributes: { ...defnA.attributes, ...mod.attributes },
        styles: { ...defnA.styles, ...mod.styles },
        classes: defnA.classes.concat(mod.classes)
      });
      const executeEvent = (bConfig, bState, executor) => runOnExecute$1((component) => {
        executor(component, bConfig, bState);
      });
      const loadEvent = (bConfig, bState, f2) => runOnInit((component, _simulatedEvent) => {
        f2(component, bConfig, bState);
      });
      const create$4 = (schema2, name2, active2, apis, extra, state) => {
        const configSchema = objOfOnly(schema2);
        const schemaSchema = optionObjOf(name2, [
          optionObjOfOnly("config", schema2)
        ]);
        return doCreate(configSchema, schemaSchema, name2, active2, apis, extra, state);
      };
      const createModes$1 = (modes, name2, active2, apis, extra, state) => {
        const configSchema = modes;
        const schemaSchema = optionObjOf(name2, [
          optionOf("config", modes)
        ]);
        return doCreate(configSchema, schemaSchema, name2, active2, apis, extra, state);
      };
      const wrapApi = (bName, apiFunction, apiName) => {
        const f2 = (component, ...rest) => {
          const args = [component].concat(rest);
          return component.config({
            name: constant$1(bName)
          }).fold(() => {
            throw new Error("We could not find any behaviour configuration for: " + bName + ". Using API: " + apiName);
          }, (info) => {
            const rest2 = Array.prototype.slice.call(args, 1);
            return apiFunction.apply(void 0, [component, info.config, info.state].concat(rest2));
          });
        };
        return markAsBehaviourApi(f2, apiName, apiFunction);
      };
      const revokeBehaviour = (name2) => ({
        key: name2,
        value: void 0
      });
      const doCreate = (configSchema, schemaSchema, name2, active2, apis, extra, state) => {
        const getConfig = (info) => hasNonNullableKey(info, name2) ? info[name2]() : Optional.none();
        const wrappedApis = map$1(apis, (apiF, apiName) => wrapApi(name2, apiF, apiName));
        const wrappedExtra = map$1(extra, (extraF, extraName) => markAsExtraApi(extraF, extraName));
        const me = {
          ...wrappedExtra,
          ...wrappedApis,
          revoke: curry(revokeBehaviour, name2),
          config: (spec) => {
            const prepared = asRawOrDie$1(name2 + "-config", configSchema, spec);
            return {
              key: name2,
              value: {
                config: prepared,
                me,
                configAsRaw: cached(() => asRawOrDie$1(name2 + "-config", configSchema, spec)),
                initialConfig: spec,
                state
              }
            };
          },
          schema: constant$1(schemaSchema),
          exhibit: (info, base2) => {
            return lift2(getConfig(info), get$h(active2, "exhibit"), (behaviourInfo, exhibitor) => {
              return exhibitor(base2, behaviourInfo.config, behaviourInfo.state);
            }).getOrThunk(() => nu$2({}));
          },
          name: constant$1(name2),
          handlers: (info) => {
            return getConfig(info).map((behaviourInfo) => {
              const getEvents2 = get$h(active2, "events").getOr(() => ({}));
              return getEvents2(behaviourInfo.config, behaviourInfo.state);
            }).getOr({});
          }
        };
        return me;
      };
      const derive$1 = (capabilities) => wrapAll(capabilities);
      const simpleSchema = objOfOnly([
        required$1("fields"),
        required$1("name"),
        defaulted("active", {}),
        defaulted("apis", {}),
        defaulted("state", NoState),
        defaulted("extra", {})
      ]);
      const create$3 = (data) => {
        const value2 = asRawOrDie$1("Creating behaviour: " + data.name, simpleSchema, data);
        return create$4(value2.fields, value2.name, value2.active, value2.apis, value2.extra, value2.state);
      };
      const modeSchema = objOfOnly([
        required$1("branchKey"),
        required$1("branches"),
        required$1("name"),
        defaulted("active", {}),
        defaulted("apis", {}),
        defaulted("state", NoState),
        defaulted("extra", {})
      ]);
      const createModes = (data) => {
        const value2 = asRawOrDie$1("Creating behaviour: " + data.name, modeSchema, data);
        return createModes$1(choose$1(value2.branchKey, value2.branches), value2.name, value2.active, value2.apis, value2.extra, value2.state);
      };
      const revoke = constant$1(void 0);
      const events$i = (name2, eventHandlers) => {
        const events2 = derive$2(eventHandlers);
        return create$3({
          fields: [
            required$1("enabled")
          ],
          name: name2,
          active: {
            events: constant$1(events2)
          }
        });
      };
      const config = (name2, eventHandlers) => {
        const me = events$i(name2, eventHandlers);
        return {
          key: name2,
          value: {
            config: {},
            me,
            configAsRaw: constant$1({}),
            initialConfig: {},
            state: NoState
          }
        };
      };
      const SetupBehaviourCellState = (initialState) => {
        const init2 = () => {
          const cell = Cell(initialState);
          const get2 = () => cell.get();
          const set2 = (newState) => cell.set(newState);
          const clear2 = () => cell.set(initialState);
          const readState = () => cell.get();
          return {
            get: get2,
            set: set2,
            clear: clear2,
            readState
          };
        };
        return {
          init: init2
        };
      };
      const focus$2 = (component, focusConfig) => {
        if (!focusConfig.ignore) {
          focus$4(component.element);
          focusConfig.onFocus(component);
        }
      };
      const blur = (component, focusConfig) => {
        if (!focusConfig.ignore) {
          blur$1(component.element);
        }
      };
      const isFocused = (component) => hasFocus(component.element);
      var FocusApis = Object.freeze({
        __proto__: null,
        focus: focus$2,
        blur,
        isFocused
      });
      const exhibit$6 = (base2, focusConfig) => {
        const mod = focusConfig.ignore ? {} : {
          attributes: {
            tabindex: "-1"
          }
        };
        return nu$2(mod);
      };
      const events$h = (focusConfig) => derive$2([
        run$1(focus$3(), (component, simulatedEvent) => {
          focus$2(component, focusConfig);
          simulatedEvent.stop();
        })
      ].concat(focusConfig.stopMousedown ? [
        run$1(mousedown(), (_, simulatedEvent) => {
          simulatedEvent.event.prevent();
        })
      ] : []));
      var ActiveFocus = Object.freeze({
        __proto__: null,
        exhibit: exhibit$6,
        events: events$h
      });
      var FocusSchema = [
        // TODO: Work out when we want to  call this. Only when it is has changed?
        onHandler("onFocus"),
        defaulted("stopMousedown", false),
        defaulted("ignore", false)
      ];
      const Focusing = create$3({
        fields: FocusSchema,
        name: "focusing",
        active: ActiveFocus,
        apis: FocusApis
        // Consider adding isFocused an an extra
      });
      const BACKSPACE = [8];
      const TAB = [9];
      const ENTER = [13];
      const ESCAPE = [27];
      const SPACE = [32];
      const LEFT = [37];
      const UP = [38];
      const RIGHT = [39];
      const DOWN = [40];
      const cyclePrev = (values2, index, predicate) => {
        const before2 = reverse(values2.slice(0, index));
        const after2 = reverse(values2.slice(index + 1));
        return find$5(before2.concat(after2), predicate);
      };
      const tryPrev = (values2, index, predicate) => {
        const before2 = reverse(values2.slice(0, index));
        return find$5(before2, predicate);
      };
      const cycleNext = (values2, index, predicate) => {
        const before2 = values2.slice(0, index);
        const after2 = values2.slice(index + 1);
        return find$5(after2.concat(before2), predicate);
      };
      const tryNext = (values2, index, predicate) => {
        const after2 = values2.slice(index + 1);
        return find$5(after2, predicate);
      };
      const inSet = (keys2) => (event) => {
        const raw = event.raw;
        return contains$2(keys2, raw.which);
      };
      const and = (preds) => (event) => forall(preds, (pred) => pred(event));
      const isShift$1 = (event) => {
        const raw = event.raw;
        return raw.shiftKey === true;
      };
      const isControl = (event) => {
        const raw = event.raw;
        return raw.ctrlKey === true;
      };
      const isNotShift = not(isShift$1);
      const rule = (matches, action) => ({
        matches,
        classification: action
      });
      const choose = (transitions, event) => {
        const transition = find$5(transitions, (t2) => t2.matches(event));
        return transition.map((t2) => t2.classification);
      };
      const dehighlightAllExcept = (component, hConfig, hState, skip) => {
        const highlighted = descendants(component.element, "." + hConfig.highlightClass);
        each$1(highlighted, (h) => {
          const shouldSkip = exists(skip, (skipComp) => eq(skipComp.element, h));
          if (!shouldSkip) {
            remove$3(h, hConfig.highlightClass);
            component.getSystem().getByDom(h).each((target) => {
              hConfig.onDehighlight(component, target);
              emit(target, dehighlight$1());
            });
          }
        });
      };
      const dehighlightAll = (component, hConfig, hState) => dehighlightAllExcept(component, hConfig, hState, []);
      const dehighlight = (component, hConfig, hState, target) => {
        if (isHighlighted(component, hConfig, hState, target)) {
          remove$3(target.element, hConfig.highlightClass);
          hConfig.onDehighlight(component, target);
          emit(target, dehighlight$1());
        }
      };
      const highlight = (component, hConfig, hState, target) => {
        dehighlightAllExcept(component, hConfig, hState, [target]);
        if (!isHighlighted(component, hConfig, hState, target)) {
          add$2(target.element, hConfig.highlightClass);
          hConfig.onHighlight(component, target);
          emit(target, highlight$1());
        }
      };
      const highlightFirst = (component, hConfig, hState) => {
        getFirst(component, hConfig).each((firstComp) => {
          highlight(component, hConfig, hState, firstComp);
        });
      };
      const highlightLast = (component, hConfig, hState) => {
        getLast(component, hConfig).each((lastComp) => {
          highlight(component, hConfig, hState, lastComp);
        });
      };
      const highlightAt = (component, hConfig, hState, index) => {
        getByIndex(component, hConfig, hState, index).fold((err) => {
          throw err;
        }, (firstComp) => {
          highlight(component, hConfig, hState, firstComp);
        });
      };
      const highlightBy = (component, hConfig, hState, predicate) => {
        const candidates = getCandidates(component, hConfig);
        const targetComp = find$5(candidates, predicate);
        targetComp.each((c) => {
          highlight(component, hConfig, hState, c);
        });
      };
      const isHighlighted = (component, hConfig, hState, queryTarget) => has(queryTarget.element, hConfig.highlightClass);
      const getHighlighted = (component, hConfig, _hState) => descendant(component.element, "." + hConfig.highlightClass).bind((e) => component.getSystem().getByDom(e).toOptional());
      const getByIndex = (component, hConfig, hState, index) => {
        const items = descendants(component.element, "." + hConfig.itemClass);
        return Optional.from(items[index]).fold(() => Result.error(new Error("No element found with index " + index)), component.getSystem().getByDom);
      };
      const getFirst = (component, hConfig, _hState) => descendant(component.element, "." + hConfig.itemClass).bind((e) => component.getSystem().getByDom(e).toOptional());
      const getLast = (component, hConfig, _hState) => {
        const items = descendants(component.element, "." + hConfig.itemClass);
        const last2 = items.length > 0 ? Optional.some(items[items.length - 1]) : Optional.none();
        return last2.bind((c) => component.getSystem().getByDom(c).toOptional());
      };
      const getDelta$2 = (component, hConfig, hState, delta) => {
        const items = descendants(component.element, "." + hConfig.itemClass);
        const current = findIndex$1(items, (item2) => has(item2, hConfig.highlightClass));
        return current.bind((selected) => {
          const dest = cycleBy(selected, delta, 0, items.length - 1);
          return component.getSystem().getByDom(items[dest]).toOptional();
        });
      };
      const getPrevious = (component, hConfig, hState) => getDelta$2(component, hConfig, hState, -1);
      const getNext = (component, hConfig, hState) => getDelta$2(component, hConfig, hState, 1);
      const getCandidates = (component, hConfig, _hState) => {
        const items = descendants(component.element, "." + hConfig.itemClass);
        return cat(map$2(items, (i) => component.getSystem().getByDom(i).toOptional()));
      };
      var HighlightApis = Object.freeze({
        __proto__: null,
        dehighlightAll,
        dehighlight,
        highlight,
        highlightFirst,
        highlightLast,
        highlightAt,
        highlightBy,
        isHighlighted,
        getHighlighted,
        getFirst,
        getLast,
        getPrevious,
        getNext,
        getCandidates
      });
      var HighlightSchema = [
        required$1("highlightClass"),
        required$1("itemClass"),
        onHandler("onHighlight"),
        onHandler("onDehighlight")
      ];
      const Highlighting = create$3({
        fields: HighlightSchema,
        name: "highlighting",
        apis: HighlightApis
      });
      const reportFocusShifting = (component, prevFocus, newFocus) => {
        const noChange = prevFocus.exists((p) => newFocus.exists((n) => eq(n, p)));
        if (!noChange) {
          emitWith(component, focusShifted(), {
            prevFocus,
            newFocus
          });
        }
      };
      const dom$2 = () => {
        const get2 = (component) => search(component.element);
        const set2 = (component, focusee) => {
          const prevFocus = get2(component);
          component.getSystem().triggerFocus(focusee, component.element);
          const newFocus = get2(component);
          reportFocusShifting(component, prevFocus, newFocus);
        };
        return {
          get: get2,
          set: set2
        };
      };
      const highlights = () => {
        const get2 = (component) => Highlighting.getHighlighted(component).map((item2) => item2.element);
        const set2 = (component, element2) => {
          const prevFocus = get2(component);
          component.getSystem().getByDom(element2).fold(noop, (item2) => {
            Highlighting.highlight(component, item2);
          });
          const newFocus = get2(component);
          reportFocusShifting(component, prevFocus, newFocus);
        };
        return {
          get: get2,
          set: set2
        };
      };
      const typical = (infoSchema, stateInit, getKeydownRules2, getKeyupRules2, optFocusIn) => {
        const schema2 = () => infoSchema.concat([
          defaulted("focusManager", dom$2()),
          defaultedOf("focusInside", "onFocus", valueOf((val) => contains$2(["onFocus", "onEnterOrSpace", "onApi"], val) ? Result.value(val) : Result.error("Invalid value for focusInside"))),
          output$1("handler", me),
          output$1("state", stateInit),
          output$1("sendFocusIn", optFocusIn)
        ]);
        const processKey = (component, simulatedEvent, getRules, keyingConfig, keyingState) => {
          const rules = getRules(component, simulatedEvent, keyingConfig, keyingState);
          return choose(rules, simulatedEvent.event).bind((rule2) => rule2(component, simulatedEvent, keyingConfig, keyingState));
        };
        const toEvents2 = (keyingConfig, keyingState) => {
          const onFocusHandler = keyingConfig.focusInside !== FocusInsideModes.OnFocusMode ? Optional.none() : optFocusIn(keyingConfig).map((focusIn2) => run$1(focus$3(), (component, simulatedEvent) => {
            focusIn2(component, keyingConfig, keyingState);
            simulatedEvent.stop();
          }));
          const tryGoInsideComponent = (component, simulatedEvent) => {
            const isEnterOrSpace = inSet(SPACE.concat(ENTER))(simulatedEvent.event);
            if (keyingConfig.focusInside === FocusInsideModes.OnEnterOrSpaceMode && isEnterOrSpace && isSource(component, simulatedEvent)) {
              optFocusIn(keyingConfig).each((focusIn2) => {
                focusIn2(component, keyingConfig, keyingState);
                simulatedEvent.stop();
              });
            }
          };
          const keyboardEvents = [
            run$1(keydown(), (component, simulatedEvent) => {
              processKey(component, simulatedEvent, getKeydownRules2, keyingConfig, keyingState).fold(() => {
                tryGoInsideComponent(component, simulatedEvent);
              }, (_) => {
                simulatedEvent.stop();
              });
            }),
            run$1(keyup(), (component, simulatedEvent) => {
              processKey(component, simulatedEvent, getKeyupRules2, keyingConfig, keyingState).each((_) => {
                simulatedEvent.stop();
              });
            })
          ];
          return derive$2(onFocusHandler.toArray().concat(keyboardEvents));
        };
        const me = {
          schema: schema2,
          processKey,
          toEvents: toEvents2
        };
        return me;
      };
      const create$2 = (cyclicField) => {
        const schema2 = [
          option$3("onEscape"),
          option$3("onEnter"),
          defaulted("selector", '[data-alloy-tabstop="true"]:not(:disabled)'),
          defaulted("firstTabstop", 0),
          defaulted("useTabstopAt", always),
          // Maybe later we should just expose isVisible
          option$3("visibilitySelector")
        ].concat([
          cyclicField
        ]);
        const isVisible2 = (tabbingConfig, element2) => {
          const target = tabbingConfig.visibilitySelector.bind((sel) => closest$3(element2, sel)).getOr(element2);
          return get$d(target) > 0;
        };
        const findInitial = (component, tabbingConfig) => {
          const tabstops = descendants(component.element, tabbingConfig.selector);
          const visibles = filter$2(tabstops, (elem) => isVisible2(tabbingConfig, elem));
          return Optional.from(visibles[tabbingConfig.firstTabstop]);
        };
        const findCurrent2 = (component, tabbingConfig) => tabbingConfig.focusManager.get(component).bind((elem) => closest$3(elem, tabbingConfig.selector));
        const isTabstop = (tabbingConfig, element2) => isVisible2(tabbingConfig, element2) && tabbingConfig.useTabstopAt(element2);
        const focusIn2 = (component, tabbingConfig, _tabbingState) => {
          findInitial(component, tabbingConfig).each((target) => {
            tabbingConfig.focusManager.set(component, target);
          });
        };
        const goFromTabstop = (component, tabstops, stopIndex, tabbingConfig, cycle) => cycle(tabstops, stopIndex, (elem) => isTabstop(tabbingConfig, elem)).fold(
          // Even if there is only one, still capture the event if cycling
          () => tabbingConfig.cyclic ? Optional.some(true) : Optional.none(),
          (target) => {
            tabbingConfig.focusManager.set(component, target);
            return Optional.some(true);
          }
        );
        const go2 = (component, _simulatedEvent, tabbingConfig, cycle) => {
          const tabstops = filter$2(descendants(component.element, tabbingConfig.selector), (element2) => isVisible2(tabbingConfig, element2));
          return findCurrent2(component, tabbingConfig).bind((tabstop) => {
            const optStopIndex = findIndex$1(tabstops, curry(eq, tabstop));
            return optStopIndex.bind((stopIndex) => goFromTabstop(component, tabstops, stopIndex, tabbingConfig, cycle));
          });
        };
        const goBackwards = (component, simulatedEvent, tabbingConfig) => {
          const navigate = tabbingConfig.cyclic ? cyclePrev : tryPrev;
          return go2(component, simulatedEvent, tabbingConfig, navigate);
        };
        const goForwards = (component, simulatedEvent, tabbingConfig) => {
          const navigate = tabbingConfig.cyclic ? cycleNext : tryNext;
          return go2(component, simulatedEvent, tabbingConfig, navigate);
        };
        const isFirstChild = (elem) => parentNode(elem).bind(firstChild).exists((child2) => eq(child2, elem));
        const goFromPseudoTabstop = (component, simulatedEvent, tabbingConfig) => findCurrent2(component, tabbingConfig).filter((elem) => !tabbingConfig.useTabstopAt(elem)).bind((elem) => (isFirstChild(elem) ? goBackwards : goForwards)(component, simulatedEvent, tabbingConfig));
        const execute2 = (component, simulatedEvent, tabbingConfig) => tabbingConfig.onEnter.bind((f2) => f2(component, simulatedEvent));
        const exit = (component, simulatedEvent, tabbingConfig) => tabbingConfig.onEscape.bind((f2) => f2(component, simulatedEvent));
        const getKeydownRules2 = constant$1([
          rule(and([isShift$1, inSet(TAB)]), goBackwards),
          rule(inSet(TAB), goForwards),
          rule(and([isNotShift, inSet(ENTER)]), execute2)
        ]);
        const getKeyupRules2 = constant$1([
          rule(inSet(ESCAPE), exit),
          rule(inSet(TAB), goFromPseudoTabstop)
        ]);
        return typical(schema2, NoState.init, getKeydownRules2, getKeyupRules2, () => Optional.some(focusIn2));
      };
      var AcyclicType = create$2(customField("cyclic", never));
      var CyclicType = create$2(customField("cyclic", always));
      const inside = (target) => isTag("input")(target) && get$g(target, "type") !== "radio" || isTag("textarea")(target);
      const doDefaultExecute = (component, _simulatedEvent, focused) => {
        dispatch(component, focused, execute$5());
        return Optional.some(true);
      };
      const defaultExecute = (component, simulatedEvent, focused) => {
        const isComplex = inside(focused) && inSet(SPACE)(simulatedEvent.event);
        return isComplex ? Optional.none() : doDefaultExecute(component, simulatedEvent, focused);
      };
      const stopEventForFirefox = (_component, _simulatedEvent) => Optional.some(true);
      const schema$z = [
        defaulted("execute", defaultExecute),
        defaulted("useSpace", false),
        defaulted("useEnter", true),
        defaulted("useControlEnter", false),
        defaulted("useDown", false)
      ];
      const execute$4 = (component, simulatedEvent, executeConfig) => executeConfig.execute(component, simulatedEvent, component.element);
      const getKeydownRules$5 = (component, _simulatedEvent, executeConfig, _executeState) => {
        const spaceExec = executeConfig.useSpace && !inside(component.element) ? SPACE : [];
        const enterExec = executeConfig.useEnter ? ENTER : [];
        const downExec = executeConfig.useDown ? DOWN : [];
        const execKeys = spaceExec.concat(enterExec).concat(downExec);
        return [
          rule(inSet(execKeys), execute$4)
        ].concat(executeConfig.useControlEnter ? [
          rule(and([isControl, inSet(ENTER)]), execute$4)
        ] : []);
      };
      const getKeyupRules$5 = (component, _simulatedEvent, executeConfig, _executeState) => executeConfig.useSpace && !inside(component.element) ? [rule(inSet(SPACE), stopEventForFirefox)] : [];
      var ExecutionType = typical(schema$z, NoState.init, getKeydownRules$5, getKeyupRules$5, () => Optional.none());
      const flatgrid$1 = () => {
        const dimensions = value$2();
        const setGridSize = (numRows, numColumns) => {
          dimensions.set({ numRows, numColumns });
        };
        const getNumRows = () => dimensions.get().map((d) => d.numRows);
        const getNumColumns = () => dimensions.get().map((d) => d.numColumns);
        return nu$4({
          readState: () => dimensions.get().map((d) => ({
            numRows: String(d.numRows),
            numColumns: String(d.numColumns)
          })).getOr({
            numRows: "?",
            numColumns: "?"
          }),
          setGridSize,
          getNumRows,
          getNumColumns
        });
      };
      const init$g = (spec) => spec.state(spec);
      var KeyingState = Object.freeze({
        __proto__: null,
        flatgrid: flatgrid$1,
        init: init$g
      });
      const useH = (movement) => (component, simulatedEvent, config2, state) => {
        const move2 = movement(component.element);
        return use(move2, component, simulatedEvent, config2, state);
      };
      const west = (moveLeft2, moveRight2) => {
        const movement = onDirection(moveLeft2, moveRight2);
        return useH(movement);
      };
      const east = (moveLeft2, moveRight2) => {
        const movement = onDirection(moveRight2, moveLeft2);
        return useH(movement);
      };
      const useV = (move2) => (component, simulatedEvent, config2, state) => use(move2, component, simulatedEvent, config2, state);
      const use = (move2, component, simulatedEvent, config2, state) => {
        const outcome = config2.focusManager.get(component).bind((focused) => move2(component.element, focused, config2, state));
        return outcome.map((newFocus) => {
          config2.focusManager.set(component, newFocus);
          return true;
        });
      };
      const north = useV;
      const south = useV;
      const move$1 = useV;
      const locate = (candidates, predicate) => findIndex$1(candidates, predicate).map((index) => ({
        index,
        candidates
      }));
      const locateVisible = (container, current, selector) => {
        const predicate = (x) => eq(x, current);
        const candidates = descendants(container, selector);
        const visible = filter$2(candidates, isVisible);
        return locate(visible, predicate);
      };
      const findIndex = (elements, target) => findIndex$1(elements, (elem) => eq(target, elem));
      const withGrid = (values2, index, numCols, f2) => {
        const oldRow = Math.floor(index / numCols);
        const oldColumn = index % numCols;
        return f2(oldRow, oldColumn).bind((address) => {
          const newIndex = address.row * numCols + address.column;
          return newIndex >= 0 && newIndex < values2.length ? Optional.some(values2[newIndex]) : Optional.none();
        });
      };
      const cycleHorizontal$1 = (values2, index, numRows, numCols, delta) => withGrid(values2, index, numCols, (oldRow, oldColumn) => {
        const onLastRow = oldRow === numRows - 1;
        const colsInRow = onLastRow ? values2.length - oldRow * numCols : numCols;
        const newColumn = cycleBy(oldColumn, delta, 0, colsInRow - 1);
        return Optional.some({
          row: oldRow,
          column: newColumn
        });
      });
      const cycleVertical$1 = (values2, index, numRows, numCols, delta) => withGrid(values2, index, numCols, (oldRow, oldColumn) => {
        const newRow = cycleBy(oldRow, delta, 0, numRows - 1);
        const onLastRow = newRow === numRows - 1;
        const colsInRow = onLastRow ? values2.length - newRow * numCols : numCols;
        const newCol = clamp(oldColumn, 0, colsInRow - 1);
        return Optional.some({
          row: newRow,
          column: newCol
        });
      });
      const cycleRight$1 = (values2, index, numRows, numCols) => cycleHorizontal$1(values2, index, numRows, numCols, 1);
      const cycleLeft$1 = (values2, index, numRows, numCols) => cycleHorizontal$1(values2, index, numRows, numCols, -1);
      const cycleUp$1 = (values2, index, numRows, numCols) => cycleVertical$1(values2, index, numRows, numCols, -1);
      const cycleDown$1 = (values2, index, numRows, numCols) => cycleVertical$1(values2, index, numRows, numCols, 1);
      const schema$y = [
        required$1("selector"),
        defaulted("execute", defaultExecute),
        onKeyboardHandler("onEscape"),
        defaulted("captureTab", false),
        initSize()
      ];
      const focusIn$4 = (component, gridConfig, _gridState) => {
        descendant(component.element, gridConfig.selector).each((first2) => {
          gridConfig.focusManager.set(component, first2);
        });
      };
      const findCurrent$1 = (component, gridConfig) => gridConfig.focusManager.get(component).bind((elem) => closest$3(elem, gridConfig.selector));
      const execute$3 = (component, simulatedEvent, gridConfig, _gridState) => findCurrent$1(component, gridConfig).bind((focused) => gridConfig.execute(component, simulatedEvent, focused));
      const doMove$2 = (cycle) => (element2, focused, gridConfig, gridState) => locateVisible(element2, focused, gridConfig.selector).bind((identified) => cycle(identified.candidates, identified.index, gridState.getNumRows().getOr(gridConfig.initSize.numRows), gridState.getNumColumns().getOr(gridConfig.initSize.numColumns)));
      const handleTab = (_component, _simulatedEvent, gridConfig) => gridConfig.captureTab ? Optional.some(true) : Optional.none();
      const doEscape$1 = (component, simulatedEvent, gridConfig) => gridConfig.onEscape(component, simulatedEvent);
      const moveLeft$3 = doMove$2(cycleLeft$1);
      const moveRight$3 = doMove$2(cycleRight$1);
      const moveNorth$1 = doMove$2(cycleUp$1);
      const moveSouth$1 = doMove$2(cycleDown$1);
      const getKeydownRules$4 = constant$1([
        rule(inSet(LEFT), west(moveLeft$3, moveRight$3)),
        rule(inSet(RIGHT), east(moveLeft$3, moveRight$3)),
        rule(inSet(UP), north(moveNorth$1)),
        rule(inSet(DOWN), south(moveSouth$1)),
        rule(and([isShift$1, inSet(TAB)]), handleTab),
        rule(and([isNotShift, inSet(TAB)]), handleTab),
        // Probably should make whether space is used configurable
        rule(inSet(SPACE.concat(ENTER)), execute$3)
      ]);
      const getKeyupRules$4 = constant$1([
        rule(inSet(ESCAPE), doEscape$1),
        rule(inSet(SPACE), stopEventForFirefox)
      ]);
      var FlatgridType = typical(schema$y, flatgrid$1, getKeydownRules$4, getKeyupRules$4, () => Optional.some(focusIn$4));
      const f = (container, selector, current, delta, getNewIndex) => {
        const isDisabledButton = (candidate) => name$3(candidate) === "button" && get$g(candidate, "disabled") === "disabled";
        const tryNewIndex = (initial, index, candidates) => getNewIndex(initial, index, delta, 0, candidates.length - 1, candidates[index], (newIndex) => isDisabledButton(candidates[newIndex]) ? tryNewIndex(initial, newIndex, candidates) : Optional.from(candidates[newIndex]));
        return locateVisible(container, current, selector).bind((identified) => {
          const index = identified.index;
          const candidates = identified.candidates;
          return tryNewIndex(index, index, candidates);
        });
      };
      const horizontalWithoutCycles = (container, selector, current, delta) => f(container, selector, current, delta, (prevIndex, v, d, min2, max2, oldCandidate, onNewIndex) => {
        const newIndex = clamp(v + d, min2, max2);
        return newIndex === prevIndex ? Optional.from(oldCandidate) : onNewIndex(newIndex);
      });
      const horizontal = (container, selector, current, delta) => f(container, selector, current, delta, (prevIndex, v, d, min2, max2, _oldCandidate, onNewIndex) => {
        const newIndex = cycleBy(v, d, min2, max2);
        return newIndex === prevIndex ? Optional.none() : onNewIndex(newIndex);
      });
      const schema$x = [
        required$1("selector"),
        defaulted("getInitial", Optional.none),
        defaulted("execute", defaultExecute),
        onKeyboardHandler("onEscape"),
        defaulted("executeOnMove", false),
        defaulted("allowVertical", true),
        defaulted("allowHorizontal", true),
        defaulted("cycles", true)
      ];
      const findCurrent = (component, flowConfig) => flowConfig.focusManager.get(component).bind((elem) => closest$3(elem, flowConfig.selector));
      const execute$2 = (component, simulatedEvent, flowConfig) => findCurrent(component, flowConfig).bind((focused) => flowConfig.execute(component, simulatedEvent, focused));
      const focusIn$3 = (component, flowConfig, _state) => {
        flowConfig.getInitial(component).orThunk(() => descendant(component.element, flowConfig.selector)).each((first2) => {
          flowConfig.focusManager.set(component, first2);
        });
      };
      const moveLeft$2 = (element2, focused, info) => (info.cycles ? horizontal : horizontalWithoutCycles)(element2, info.selector, focused, -1);
      const moveRight$2 = (element2, focused, info) => (info.cycles ? horizontal : horizontalWithoutCycles)(element2, info.selector, focused, 1);
      const doMove$1 = (movement) => (component, simulatedEvent, flowConfig, flowState) => movement(component, simulatedEvent, flowConfig, flowState).bind(() => flowConfig.executeOnMove ? execute$2(component, simulatedEvent, flowConfig) : Optional.some(true));
      const doEscape = (component, simulatedEvent, flowConfig) => flowConfig.onEscape(component, simulatedEvent);
      const getKeydownRules$3 = (_component, _se, flowConfig, _flowState) => {
        const westMovers = [...flowConfig.allowHorizontal ? LEFT : []].concat(flowConfig.allowVertical ? UP : []);
        const eastMovers = [...flowConfig.allowHorizontal ? RIGHT : []].concat(flowConfig.allowVertical ? DOWN : []);
        return [
          rule(inSet(westMovers), doMove$1(west(moveLeft$2, moveRight$2))),
          rule(inSet(eastMovers), doMove$1(east(moveLeft$2, moveRight$2))),
          rule(inSet(ENTER), execute$2),
          rule(inSet(SPACE), execute$2)
        ];
      };
      const getKeyupRules$3 = constant$1([
        rule(inSet(SPACE), stopEventForFirefox),
        rule(inSet(ESCAPE), doEscape)
      ]);
      var FlowType = typical(schema$x, NoState.init, getKeydownRules$3, getKeyupRules$3, () => Optional.some(focusIn$3));
      const toCell = (matrix2, rowIndex, columnIndex) => Optional.from(matrix2[rowIndex]).bind((row) => Optional.from(row[columnIndex]).map((cell) => ({
        rowIndex,
        columnIndex,
        cell
      })));
      const cycleHorizontal = (matrix2, rowIndex, startCol, deltaCol) => {
        const row = matrix2[rowIndex];
        const colsInRow = row.length;
        const newColIndex = cycleBy(startCol, deltaCol, 0, colsInRow - 1);
        return toCell(matrix2, rowIndex, newColIndex);
      };
      const cycleVertical = (matrix2, colIndex, startRow, deltaRow) => {
        const nextRowIndex = cycleBy(startRow, deltaRow, 0, matrix2.length - 1);
        const colsInNextRow = matrix2[nextRowIndex].length;
        const nextColIndex = clamp(colIndex, 0, colsInNextRow - 1);
        return toCell(matrix2, nextRowIndex, nextColIndex);
      };
      const moveHorizontal = (matrix2, rowIndex, startCol, deltaCol) => {
        const row = matrix2[rowIndex];
        const colsInRow = row.length;
        const newColIndex = clamp(startCol + deltaCol, 0, colsInRow - 1);
        return toCell(matrix2, rowIndex, newColIndex);
      };
      const moveVertical = (matrix2, colIndex, startRow, deltaRow) => {
        const nextRowIndex = clamp(startRow + deltaRow, 0, matrix2.length - 1);
        const colsInNextRow = matrix2[nextRowIndex].length;
        const nextColIndex = clamp(colIndex, 0, colsInNextRow - 1);
        return toCell(matrix2, nextRowIndex, nextColIndex);
      };
      const cycleRight = (matrix2, startRow, startCol) => cycleHorizontal(matrix2, startRow, startCol, 1);
      const cycleLeft = (matrix2, startRow, startCol) => cycleHorizontal(matrix2, startRow, startCol, -1);
      const cycleUp = (matrix2, startRow, startCol) => cycleVertical(matrix2, startCol, startRow, -1);
      const cycleDown = (matrix2, startRow, startCol) => cycleVertical(matrix2, startCol, startRow, 1);
      const moveLeft$1 = (matrix2, startRow, startCol) => moveHorizontal(matrix2, startRow, startCol, -1);
      const moveRight$1 = (matrix2, startRow, startCol) => moveHorizontal(matrix2, startRow, startCol, 1);
      const moveUp$1 = (matrix2, startRow, startCol) => moveVertical(matrix2, startCol, startRow, -1);
      const moveDown$1 = (matrix2, startRow, startCol) => moveVertical(matrix2, startCol, startRow, 1);
      const schema$w = [
        requiredObjOf("selectors", [
          required$1("row"),
          required$1("cell")
        ]),
        // Used to determine whether pressing right/down at the end cycles back to the start/top
        defaulted("cycles", true),
        defaulted("previousSelector", Optional.none),
        defaulted("execute", defaultExecute)
      ];
      const focusIn$2 = (component, matrixConfig, _state) => {
        const focused = matrixConfig.previousSelector(component).orThunk(() => {
          const selectors = matrixConfig.selectors;
          return descendant(component.element, selectors.cell);
        });
        focused.each((cell) => {
          matrixConfig.focusManager.set(component, cell);
        });
      };
      const execute$1 = (component, simulatedEvent, matrixConfig) => search(component.element).bind((focused) => matrixConfig.execute(component, simulatedEvent, focused));
      const toMatrix = (rows, matrixConfig) => map$2(rows, (row) => descendants(row, matrixConfig.selectors.cell));
      const doMove = (ifCycle, ifMove) => (element2, focused, matrixConfig) => {
        const move2 = matrixConfig.cycles ? ifCycle : ifMove;
        return closest$3(focused, matrixConfig.selectors.row).bind((inRow) => {
          const cellsInRow = descendants(inRow, matrixConfig.selectors.cell);
          return findIndex(cellsInRow, focused).bind((colIndex) => {
            const allRows = descendants(element2, matrixConfig.selectors.row);
            return findIndex(allRows, inRow).bind((rowIndex) => {
              const matrix2 = toMatrix(allRows, matrixConfig);
              return move2(matrix2, rowIndex, colIndex).map((next) => next.cell);
            });
          });
        });
      };
      const moveLeft = doMove(cycleLeft, moveLeft$1);
      const moveRight = doMove(cycleRight, moveRight$1);
      const moveNorth = doMove(cycleUp, moveUp$1);
      const moveSouth = doMove(cycleDown, moveDown$1);
      const getKeydownRules$2 = constant$1([
        rule(inSet(LEFT), west(moveLeft, moveRight)),
        rule(inSet(RIGHT), east(moveLeft, moveRight)),
        rule(inSet(UP), north(moveNorth)),
        rule(inSet(DOWN), south(moveSouth)),
        rule(inSet(SPACE.concat(ENTER)), execute$1)
      ]);
      const getKeyupRules$2 = constant$1([
        rule(inSet(SPACE), stopEventForFirefox)
      ]);
      var MatrixType = typical(schema$w, NoState.init, getKeydownRules$2, getKeyupRules$2, () => Optional.some(focusIn$2));
      const schema$v = [
        required$1("selector"),
        defaulted("execute", defaultExecute),
        defaulted("moveOnTab", false)
      ];
      const execute = (component, simulatedEvent, menuConfig) => menuConfig.focusManager.get(component).bind((focused) => menuConfig.execute(component, simulatedEvent, focused));
      const focusIn$1 = (component, menuConfig, _state) => {
        descendant(component.element, menuConfig.selector).each((first2) => {
          menuConfig.focusManager.set(component, first2);
        });
      };
      const moveUp = (element2, focused, info) => horizontal(element2, info.selector, focused, -1);
      const moveDown = (element2, focused, info) => horizontal(element2, info.selector, focused, 1);
      const fireShiftTab = (component, simulatedEvent, menuConfig, menuState) => menuConfig.moveOnTab ? move$1(moveUp)(component, simulatedEvent, menuConfig, menuState) : Optional.none();
      const fireTab = (component, simulatedEvent, menuConfig, menuState) => menuConfig.moveOnTab ? move$1(moveDown)(component, simulatedEvent, menuConfig, menuState) : Optional.none();
      const getKeydownRules$1 = constant$1([
        rule(inSet(UP), move$1(moveUp)),
        rule(inSet(DOWN), move$1(moveDown)),
        rule(and([isShift$1, inSet(TAB)]), fireShiftTab),
        rule(and([isNotShift, inSet(TAB)]), fireTab),
        rule(inSet(ENTER), execute),
        rule(inSet(SPACE), execute)
      ]);
      const getKeyupRules$1 = constant$1([
        rule(inSet(SPACE), stopEventForFirefox)
      ]);
      var MenuType = typical(schema$v, NoState.init, getKeydownRules$1, getKeyupRules$1, () => Optional.some(focusIn$1));
      const schema$u = [
        onKeyboardHandler("onSpace"),
        onKeyboardHandler("onEnter"),
        onKeyboardHandler("onShiftEnter"),
        onKeyboardHandler("onLeft"),
        onKeyboardHandler("onRight"),
        onKeyboardHandler("onTab"),
        onKeyboardHandler("onShiftTab"),
        onKeyboardHandler("onUp"),
        onKeyboardHandler("onDown"),
        onKeyboardHandler("onEscape"),
        defaulted("stopSpaceKeyup", false),
        option$3("focusIn")
      ];
      const getKeydownRules = (component, simulatedEvent, specialInfo) => [
        rule(inSet(SPACE), specialInfo.onSpace),
        rule(and([isNotShift, inSet(ENTER)]), specialInfo.onEnter),
        rule(and([isShift$1, inSet(ENTER)]), specialInfo.onShiftEnter),
        rule(and([isShift$1, inSet(TAB)]), specialInfo.onShiftTab),
        rule(and([isNotShift, inSet(TAB)]), specialInfo.onTab),
        rule(inSet(UP), specialInfo.onUp),
        rule(inSet(DOWN), specialInfo.onDown),
        rule(inSet(LEFT), specialInfo.onLeft),
        rule(inSet(RIGHT), specialInfo.onRight),
        rule(inSet(SPACE), specialInfo.onSpace)
      ];
      const getKeyupRules = (component, simulatedEvent, specialInfo) => [
        ...specialInfo.stopSpaceKeyup ? [rule(inSet(SPACE), stopEventForFirefox)] : [],
        rule(inSet(ESCAPE), specialInfo.onEscape)
      ];
      var SpecialType = typical(schema$u, NoState.init, getKeydownRules, getKeyupRules, (specialInfo) => specialInfo.focusIn);
      const acyclic = AcyclicType.schema();
      const cyclic = CyclicType.schema();
      const flow = FlowType.schema();
      const flatgrid = FlatgridType.schema();
      const matrix = MatrixType.schema();
      const execution = ExecutionType.schema();
      const menu = MenuType.schema();
      const special = SpecialType.schema();
      var KeyboardBranches = Object.freeze({
        __proto__: null,
        acyclic,
        cyclic,
        flow,
        flatgrid,
        matrix,
        execution,
        menu,
        special
      });
      const isFlatgridState = (keyState) => hasNonNullableKey(keyState, "setGridSize");
      const Keying = createModes({
        branchKey: "mode",
        branches: KeyboardBranches,
        name: "keying",
        active: {
          events: (keyingConfig, keyingState) => {
            const handler = keyingConfig.handler;
            return handler.toEvents(keyingConfig, keyingState);
          }
        },
        apis: {
          focusIn: (component, keyConfig, keyState) => {
            keyConfig.sendFocusIn(keyConfig).fold(() => {
              component.getSystem().triggerFocus(component.element, component.element);
            }, (sendFocusIn) => {
              sendFocusIn(component, keyConfig, keyState);
            });
          },
          // These APIs are going to be interesting because they are not
          // available for all keying modes
          setGridSize: (component, keyConfig, keyState, numRows, numColumns) => {
            if (!isFlatgridState(keyState)) {
              console.error("Layout does not support setGridSize");
            } else {
              keyState.setGridSize(numRows, numColumns);
            }
          }
        },
        state: KeyingState
      });
      const premadeTag = generate$6("alloy-premade");
      const premade$1 = (comp) => {
        Object.defineProperty(comp.element.dom, premadeTag, {
          value: comp.uid,
          writable: true
        });
        return wrap(premadeTag, comp);
      };
      const isPremade = (element2) => has$2(element2.dom, premadeTag);
      const getPremade = (spec) => get$h(spec, premadeTag);
      const makeApi = (f2) => markAsSketchApi((component, ...rest) => f2(component.getApis(), component, ...rest), f2);
      const isConnected = (comp) => comp.getSystem().isConnected();
      const fireDetaching = (component) => {
        emit(component, detachedFromDom());
        const children2 = component.components();
        each$1(children2, fireDetaching);
      };
      const fireAttaching = (component) => {
        const children2 = component.components();
        each$1(children2, fireAttaching);
        emit(component, attachedToDom());
      };
      const virtualAttach = (parent2, child2) => {
        parent2.getSystem().addToWorld(child2);
        if (inBody(parent2.element)) {
          fireAttaching(child2);
        }
      };
      const virtualDetach = (comp) => {
        fireDetaching(comp);
        comp.getSystem().removeFromWorld(comp);
      };
      const attach$1 = (parent2, child2) => {
        append$2(parent2.element, child2.element);
      };
      const detachChildren$1 = (component) => {
        each$1(component.components(), (childComp) => remove$7(childComp.element));
        empty(component.element);
        component.syncComponents();
      };
      const replaceChildren = (component, newSpecs, buildNewChildren) => {
        const subs2 = component.components();
        detachChildren$1(component);
        const newChildren = buildNewChildren(newSpecs);
        const deleted = difference(subs2, newChildren);
        each$1(deleted, (comp) => {
          fireDetaching(comp);
          component.getSystem().removeFromWorld(comp);
        });
        each$1(newChildren, (childComp) => {
          if (!isConnected(childComp)) {
            component.getSystem().addToWorld(childComp);
            attach$1(component, childComp);
            if (inBody(component.element)) {
              fireAttaching(childComp);
            }
          } else {
            attach$1(component, childComp);
          }
        });
        component.syncComponents();
      };
      const virtualReplaceChildren = (component, newSpecs, buildNewChildren) => {
        const subs2 = component.components();
        const existingComps = bind$3(newSpecs, (spec) => getPremade(spec).toArray());
        each$1(subs2, (childComp) => {
          if (!contains$2(existingComps, childComp)) {
            virtualDetach(childComp);
          }
        });
        const newChildren = buildNewChildren(newSpecs);
        const deleted = difference(subs2, newChildren);
        each$1(deleted, (deletedComp) => {
          if (isConnected(deletedComp)) {
            virtualDetach(deletedComp);
          }
        });
        each$1(newChildren, (childComp) => {
          if (!isConnected(childComp)) {
            virtualAttach(component, childComp);
          }
        });
        component.syncComponents();
      };
      const attach = (parent2, child2) => {
        attachWith(parent2, child2, append$2);
      };
      const attachWith = (parent2, child2, insertion) => {
        parent2.getSystem().addToWorld(child2);
        insertion(parent2.element, child2.element);
        if (inBody(parent2.element)) {
          fireAttaching(child2);
        }
        parent2.syncComponents();
      };
      const doDetach = (component) => {
        fireDetaching(component);
        remove$7(component.element);
        component.getSystem().removeFromWorld(component);
      };
      const detach = (component) => {
        const parent$1 = parent(component.element).bind((p) => component.getSystem().getByDom(p).toOptional());
        doDetach(component);
        parent$1.each((p) => {
          p.syncComponents();
        });
      };
      const detachChildren = (component) => {
        const subs2 = component.components();
        each$1(subs2, doDetach);
        empty(component.element);
        component.syncComponents();
      };
      const attachSystem = (element2, guiSystem) => {
        attachSystemWith(element2, guiSystem, append$2);
      };
      const attachSystemAfter = (element2, guiSystem) => {
        attachSystemWith(element2, guiSystem, after$1);
      };
      const attachSystemWith = (element2, guiSystem, inserter) => {
        inserter(element2, guiSystem.element);
        const children$1 = children(guiSystem.element);
        each$1(children$1, (child2) => {
          guiSystem.getByDom(child2).each(fireAttaching);
        });
      };
      const detachSystem = (guiSystem) => {
        const children$1 = children(guiSystem.element);
        each$1(children$1, (child2) => {
          guiSystem.getByDom(child2).each(fireDetaching);
        });
        remove$7(guiSystem.element);
      };
      const determineObsoleted = (parent2, index, oldObsoleted) => {
        const newObsoleted = child$2(parent2, index);
        return newObsoleted.map((newObs) => {
          const elemChanged = oldObsoleted.exists((o) => !eq(o, newObs));
          if (elemChanged) {
            const oldTag = oldObsoleted.map(name$3).getOr("span");
            const marker = SugarElement.fromTag(oldTag);
            before$1(newObs, marker);
            return marker;
          } else {
            return newObs;
          }
        });
      };
      const ensureInDom = (parent2, child2, obsoleted) => {
        obsoleted.fold(
          // There is nothing here, so just append to the parent
          () => append$2(parent2, child2),
          (obs) => {
            if (!eq(obs, child2)) {
              before$1(obs, child2);
              remove$7(obs);
            }
          }
        );
      };
      const patchChildrenWith = (parent2, nu2, f2) => {
        const builtChildren = map$2(nu2, f2);
        const currentChildren = children(parent2);
        each$1(currentChildren.slice(builtChildren.length), remove$7);
        return builtChildren;
      };
      const patchSpecChild = (parent2, index, spec, build2) => {
        const oldObsoleted = child$2(parent2, index);
        const childComp = build2(spec, oldObsoleted);
        const obsoleted = determineObsoleted(parent2, index, oldObsoleted);
        ensureInDom(parent2, childComp.element, obsoleted);
        return childComp;
      };
      const patchSpecChildren = (parent2, specs, build2) => patchChildrenWith(parent2, specs, (spec, index) => patchSpecChild(parent2, index, spec, build2));
      const patchDomChildren = (parent2, nodes) => patchChildrenWith(parent2, nodes, (node, index) => {
        const optObsoleted = child$2(parent2, index);
        ensureInDom(parent2, node, optObsoleted);
        return node;
      });
      const preserve = (f2, container) => {
        const dos = getRootNode(container);
        const refocus = active$1(dos).bind((focused) => {
          const hasFocus2 = (elem) => eq(focused, elem);
          return hasFocus2(container) ? Optional.some(container) : descendant$1(container, hasFocus2);
        });
        const result = f2(container);
        refocus.each((oldFocus) => {
          active$1(dos).filter((newFocus) => eq(newFocus, oldFocus)).fold(() => {
            focus$4(oldFocus);
          }, noop);
        });
        return result;
      };
      const withoutReuse = (parent2, data) => {
        preserve(() => {
          replaceChildren(parent2, data, () => map$2(data, parent2.getSystem().build));
        }, parent2.element);
      };
      const withReuse = (parent2, data) => {
        preserve(() => {
          virtualReplaceChildren(parent2, data, () => {
            return patchSpecChildren(parent2.element, data, parent2.getSystem().buildOrPatch);
          });
        }, parent2.element);
      };
      const virtualReplace = (component, replacee, replaceeIndex, childSpec) => {
        virtualDetach(replacee);
        const child2 = patchSpecChild(component.element, replaceeIndex, childSpec, component.getSystem().buildOrPatch);
        virtualAttach(component, child2);
        component.syncComponents();
      };
      const insert = (component, insertion, childSpec) => {
        const child2 = component.getSystem().build(childSpec);
        attachWith(component, child2, insertion);
      };
      const replace = (component, replacee, replaceeIndex, childSpec) => {
        detach(replacee);
        insert(component, (p, c) => appendAt(p, c, replaceeIndex), childSpec);
      };
      const set$3 = (component, replaceConfig, replaceState, data) => {
        const replacer = replaceConfig.reuseDom ? withReuse : withoutReuse;
        return replacer(component, data);
      };
      const append = (component, replaceConfig, replaceState, appendee) => {
        insert(component, append$2, appendee);
      };
      const prepend = (component, replaceConfig, replaceState, prependee) => {
        insert(component, prepend$1, prependee);
      };
      const remove = (component, replaceConfig, replaceState, removee) => {
        const children2 = contents(component);
        const foundChild = find$5(children2, (child2) => eq(removee.element, child2.element));
        foundChild.each(detach);
      };
      const contents = (component, _replaceConfig) => component.components();
      const replaceAt = (component, replaceConfig, replaceState, replaceeIndex, replacer) => {
        const children2 = contents(component);
        return Optional.from(children2[replaceeIndex]).map((replacee) => {
          replacer.fold(() => detach(replacee), (r2) => {
            const replacer2 = replaceConfig.reuseDom ? virtualReplace : replace;
            replacer2(component, replacee, replaceeIndex, r2);
          });
          return replacee;
        });
      };
      const replaceBy = (component, replaceConfig, replaceState, replaceePred, replacer) => {
        const children2 = contents(component);
        return findIndex$1(children2, replaceePred).bind((replaceeIndex) => replaceAt(component, replaceConfig, replaceState, replaceeIndex, replacer));
      };
      var ReplaceApis = Object.freeze({
        __proto__: null,
        append,
        prepend,
        remove,
        replaceAt,
        replaceBy,
        set: set$3,
        contents
      });
      const Replacing = create$3({
        fields: [
          defaultedBoolean("reuseDom", true)
        ],
        name: "replacing",
        apis: ReplaceApis
      });
      const isRecursive = (component, originator, target) => eq(originator, component.element) && !eq(originator, target);
      const events$g = derive$2([
        can(focus$3(), (component, simulatedEvent) => {
          const event = simulatedEvent.event;
          const originator = event.originator;
          const target = event.target;
          if (isRecursive(component, originator, target)) {
            console.warn(focus$3() + " did not get interpreted by the desired target. \nOriginator: " + element(originator) + "\nTarget: " + element(target) + "\nCheck the " + focus$3() + " event handlers");
            return false;
          } else {
            return true;
          }
        })
      ]);
      var DefaultEvents = Object.freeze({
        __proto__: null,
        events: events$g
      });
      const prefix$1 = constant$1("alloy-id-");
      const idAttr$1 = constant$1("data-alloy-id");
      const prefix = prefix$1();
      const idAttr = idAttr$1();
      const write = (label2, elem) => {
        const id = generate$6(prefix + label2);
        writeOnly(elem, id);
        return id;
      };
      const writeOnly = (elem, uid) => {
        Object.defineProperty(elem.dom, idAttr, {
          value: uid,
          writable: true
        });
      };
      const read = (elem) => {
        const id = isElement$1(elem) ? elem.dom[idAttr] : null;
        return Optional.from(id);
      };
      const generate$4 = (prefix2) => generate$6(prefix2);
      const make$7 = identity;
      const NoContextApi = (getComp) => {
        const getMessage = (event) => `The component must be in a context to execute: ${event}` + (getComp ? "\n" + element(getComp().element) + " is not in context." : "");
        const fail = (event) => () => {
          throw new Error(getMessage(event));
        };
        const warn = (event) => () => {
          console.warn(getMessage(event));
        };
        return {
          debugInfo: constant$1("fake"),
          triggerEvent: warn("triggerEvent"),
          triggerFocus: warn("triggerFocus"),
          triggerEscape: warn("triggerEscape"),
          broadcast: warn("broadcast"),
          broadcastOn: warn("broadcastOn"),
          broadcastEvent: warn("broadcastEvent"),
          build: fail("build"),
          buildOrPatch: fail("buildOrPatch"),
          addToWorld: fail("addToWorld"),
          removeFromWorld: fail("removeFromWorld"),
          addToGui: fail("addToGui"),
          removeFromGui: fail("removeFromGui"),
          getByUid: fail("getByUid"),
          getByDom: fail("getByDom"),
          isConnected: never
        };
      };
      const singleton = NoContextApi();
      const generateFrom$1 = (spec, all2) => {
        const schema2 = map$2(all2, (a) => (
          // Optional here probably just due to ForeignGui listing everything it supports. Can most likely
          // change it to strict once I fix the other errors.
          optionObjOf(a.name(), [
            required$1("config"),
            defaulted("state", NoState)
          ])
        ));
        const validated = asRaw("component.behaviours", objOf(schema2), spec.behaviours).fold((errInfo) => {
          throw new Error(formatError(errInfo) + "\nComplete spec:\n" + JSON.stringify(spec, null, 2));
        }, identity);
        return {
          list: all2,
          data: map$1(validated, (optBlobThunk) => {
            const output2 = optBlobThunk.map((blob) => ({
              config: blob.config,
              state: blob.state.init(blob.config)
            }));
            return constant$1(output2);
          })
        };
      };
      const getBehaviours$3 = (bData) => bData.list;
      const getData$2 = (bData) => bData.data;
      const byInnerKey = (data, tuple) => {
        const r2 = {};
        each(data, (detail, key) => {
          each(detail, (value2, indexKey) => {
            const chain = get$h(r2, indexKey).getOr([]);
            r2[indexKey] = chain.concat([
              tuple(key, value2)
            ]);
          });
        });
        return r2;
      };
      const combine$1 = (info, baseMod, behaviours2, base2) => {
        const modsByBehaviour = { ...baseMod };
        each$1(behaviours2, (behaviour) => {
          modsByBehaviour[behaviour.name()] = behaviour.exhibit(info, base2);
        });
        const byAspect = byInnerKey(modsByBehaviour, (name2, modification) => ({ name: name2, modification }));
        const combineObjects = (objects) => foldr(objects, (b2, a) => ({ ...a.modification, ...b2 }), {});
        const combinedClasses = foldr(byAspect.classes, (b2, a) => a.modification.concat(b2), []);
        const combinedAttributes = combineObjects(byAspect.attributes);
        const combinedStyles = combineObjects(byAspect.styles);
        return nu$2({
          classes: combinedClasses,
          attributes: combinedAttributes,
          styles: combinedStyles
        });
      };
      const sortKeys = (label2, keyName, array, order) => {
        try {
          const sorted = sort(array, (a, b2) => {
            const aKey = a[keyName];
            const bKey = b2[keyName];
            const aIndex = order.indexOf(aKey);
            const bIndex = order.indexOf(bKey);
            if (aIndex === -1) {
              throw new Error("The ordering for " + label2 + " does not have an entry for " + aKey + ".\nOrder specified: " + JSON.stringify(order, null, 2));
            }
            if (bIndex === -1) {
              throw new Error("The ordering for " + label2 + " does not have an entry for " + bKey + ".\nOrder specified: " + JSON.stringify(order, null, 2));
            }
            if (aIndex < bIndex) {
              return -1;
            } else if (bIndex < aIndex) {
              return 1;
            } else {
              return 0;
            }
          });
          return Result.value(sorted);
        } catch (err) {
          return Result.error([err]);
        }
      };
      const uncurried = (handler, purpose) => ({
        handler,
        purpose
      });
      const curried = (handler, purpose) => ({
        cHandler: handler,
        purpose
      });
      const curryArgs = (descHandler, extraArgs) => curried(curry.apply(void 0, [descHandler.handler].concat(extraArgs)), descHandler.purpose);
      const getCurried = (descHandler) => descHandler.cHandler;
      const behaviourTuple = (name2, handler) => ({
        name: name2,
        handler
      });
      const nameToHandlers = (behaviours2, info) => {
        const r2 = {};
        each$1(behaviours2, (behaviour) => {
          r2[behaviour.name()] = behaviour.handlers(info);
        });
        return r2;
      };
      const groupByEvents = (info, behaviours2, base2) => {
        const behaviourEvents = {
          ...base2,
          ...nameToHandlers(behaviours2, info)
        };
        return byInnerKey(behaviourEvents, behaviourTuple);
      };
      const combine = (info, eventOrder, behaviours2, base2) => {
        const byEventName = groupByEvents(info, behaviours2, base2);
        return combineGroups(byEventName, eventOrder);
      };
      const assemble = (rawHandler) => {
        const handler = read$1(rawHandler);
        return (component, simulatedEvent, ...rest) => {
          const args = [component, simulatedEvent].concat(rest);
          if (handler.abort.apply(void 0, args)) {
            simulatedEvent.stop();
          } else if (handler.can.apply(void 0, args)) {
            handler.run.apply(void 0, args);
          }
        };
      };
      const missingOrderError = (eventName, tuples) => Result.error([
        "The event (" + eventName + ') has more than one behaviour that listens to it.\nWhen this occurs, you must specify an event ordering for the behaviours in your spec (e.g. [ "listing", "toggling" ]).\nThe behaviours that can trigger it are: ' + JSON.stringify(map$2(tuples, (c) => c.name), null, 2)
      ]);
      const fuse = (tuples, eventOrder, eventName) => {
        const order = eventOrder[eventName];
        if (!order) {
          return missingOrderError(eventName, tuples);
        } else {
          return sortKeys("Event: " + eventName, "name", tuples, order).map((sortedTuples) => {
            const handlers2 = map$2(sortedTuples, (tuple) => tuple.handler);
            return fuse$1(handlers2);
          });
        }
      };
      const combineGroups = (byEventName, eventOrder) => {
        const r2 = mapToArray(byEventName, (tuples, eventName) => {
          const combined = tuples.length === 1 ? Result.value(tuples[0].handler) : fuse(tuples, eventOrder, eventName);
          return combined.map((handler) => {
            const assembled = assemble(handler);
            const purpose = tuples.length > 1 ? filter$2(eventOrder[eventName], (o) => exists(tuples, (t2) => t2.name === o)).join(" > ") : tuples[0].name;
            return wrap(eventName, uncurried(assembled, purpose));
          });
        });
        return consolidate(r2, {});
      };
      const baseBehaviour = "alloy.base.behaviour";
      const schema$t = objOf([
        field$1("dom", "dom", required$2(), objOf([
          // Note, no children.
          required$1("tag"),
          defaulted("styles", {}),
          defaulted("classes", []),
          defaulted("attributes", {}),
          option$3("value"),
          option$3("innerHtml")
        ])),
        required$1("components"),
        required$1("uid"),
        defaulted("events", {}),
        defaulted("apis", {}),
        // Use mergeWith in the future when pre-built behaviours conflict
        field$1("eventOrder", "eventOrder", mergeWith({
          // Note, not using constant behaviour names to avoid code size of unused behaviours
          [execute$5()]: ["disabling", baseBehaviour, "toggling", "typeaheadevents"],
          [focus$3()]: [baseBehaviour, "focusing", "keying"],
          [systemInit()]: [baseBehaviour, "disabling", "toggling", "representing", "tooltipping"],
          [input()]: [baseBehaviour, "representing", "streaming", "invalidating"],
          [detachedFromDom()]: [baseBehaviour, "representing", "item-events", "toolbar-button-events", "tooltipping"],
          [mousedown()]: ["focusing", baseBehaviour, "item-type-events"],
          [touchstart()]: ["focusing", baseBehaviour, "item-type-events"],
          [mouseover()]: ["item-type-events", "tooltipping"],
          [receive()]: ["receiving", "reflecting", "tooltipping"]
        }), anyValue()),
        option$3("domModification")
      ]);
      const toInfo = (spec) => asRaw("custom.definition", schema$t, spec);
      const toDefinition = (detail) => (
        // EFFICIENCY: Consider not merging here.
        {
          ...detail.dom,
          uid: detail.uid,
          domChildren: map$2(detail.components, (comp) => comp.element)
        }
      );
      const toModification = (detail) => detail.domModification.fold(() => nu$2({}), nu$2);
      const toEvents = (info) => info.events;
      const diffKeyValueSet = (newObj, oldObj) => {
        const newKeys = keys(newObj);
        const oldKeys = keys(oldObj);
        const toRemove = difference(oldKeys, newKeys);
        const toSet = bifilter(newObj, (v, k) => {
          return !has$2(oldObj, k) || v !== oldObj[k];
        }).t;
        return { toRemove, toSet };
      };
      const reconcileToDom = (definition, obsoleted) => {
        const { class: clazz, style, ...existingAttributes } = clone$2(obsoleted);
        const { toSet: attrsToSet, toRemove: attrsToRemove } = diffKeyValueSet(definition.attributes, existingAttributes);
        const updateAttrs = () => {
          each$1(attrsToRemove, (a) => remove$8(obsoleted, a));
          setAll$1(obsoleted, attrsToSet);
        };
        const existingStyles = getAllRaw(obsoleted);
        const { toSet: stylesToSet, toRemove: stylesToRemove } = diffKeyValueSet(definition.styles, existingStyles);
        const updateStyles = () => {
          each$1(stylesToRemove, (s) => remove$6(obsoleted, s));
          setAll(obsoleted, stylesToSet);
        };
        const existingClasses = get$7(obsoleted);
        const classesToRemove = difference(existingClasses, definition.classes);
        const classesToAdd = difference(definition.classes, existingClasses);
        const updateClasses = () => {
          add$1(obsoleted, classesToAdd);
          remove$2(obsoleted, classesToRemove);
        };
        const updateHtml = (html2) => {
          set$8(obsoleted, html2);
        };
        const updateChildren = () => {
          const children2 = definition.domChildren;
          patchDomChildren(obsoleted, children2);
        };
        const updateValue = () => {
          const valueElement = obsoleted;
          const value2 = definition.value.getOrUndefined();
          if (value2 !== get$5(valueElement)) {
            set$4(valueElement, value2 !== null && value2 !== void 0 ? value2 : "");
          }
        };
        updateAttrs();
        updateClasses();
        updateStyles();
        definition.innerHtml.fold(updateChildren, updateHtml);
        updateValue();
        return obsoleted;
      };
      const introduceToDom = (definition) => {
        const subject = SugarElement.fromTag(definition.tag);
        setAll$1(subject, definition.attributes);
        add$1(subject, definition.classes);
        setAll(subject, definition.styles);
        definition.innerHtml.each((html2) => set$8(subject, html2));
        const children2 = definition.domChildren;
        append$1(subject, children2);
        definition.value.each((value2) => {
          set$4(subject, value2);
        });
        return subject;
      };
      const attemptPatch = (definition, obsoleted) => {
        try {
          const e = reconcileToDom(definition, obsoleted);
          return Optional.some(e);
        } catch (_a) {
          return Optional.none();
        }
      };
      const hasMixedChildren = (definition) => definition.innerHtml.isSome() && definition.domChildren.length > 0;
      const renderToDom = (definition, optObsoleted) => {
        const canBePatched = (candidate) => name$3(candidate) === definition.tag && !hasMixedChildren(definition) && !isPremade(candidate);
        const elem = optObsoleted.filter(canBePatched).bind((obsoleted) => attemptPatch(definition, obsoleted)).getOrThunk(() => introduceToDom(definition));
        writeOnly(elem, definition.uid);
        return elem;
      };
      const getBehaviours$2 = (spec) => {
        const behaviours2 = get$h(spec, "behaviours").getOr({});
        return bind$3(keys(behaviours2), (name2) => {
          const behaviour = behaviours2[name2];
          return isNonNullable(behaviour) ? [behaviour.me] : [];
        });
      };
      const generateFrom = (spec, all2) => generateFrom$1(spec, all2);
      const generate$3 = (spec) => {
        const all2 = getBehaviours$2(spec);
        return generateFrom(spec, all2);
      };
      const getDomDefinition = (info, bList, bData) => {
        const definition = toDefinition(info);
        const infoModification = toModification(info);
        const baseModification = {
          "alloy.base.modification": infoModification
        };
        const modification = bList.length > 0 ? combine$1(bData, baseModification, bList, definition) : infoModification;
        return merge(definition, modification);
      };
      const getEvents = (info, bList, bData) => {
        const baseEvents = {
          "alloy.base.behaviour": toEvents(info)
        };
        return combine(bData, info.eventOrder, bList, baseEvents).getOrDie();
      };
      const build$2 = (spec, obsoleted) => {
        const getMe = () => me;
        const systemApi = Cell(singleton);
        const info = getOrDie(toInfo(spec));
        const bBlob = generate$3(spec);
        const bList = getBehaviours$3(bBlob);
        const bData = getData$2(bBlob);
        const modDefinition = getDomDefinition(info, bList, bData);
        const item2 = renderToDom(modDefinition, obsoleted);
        const events2 = getEvents(info, bList, bData);
        const subcomponents = Cell(info.components);
        const connect = (newApi) => {
          systemApi.set(newApi);
        };
        const disconnect = () => {
          systemApi.set(NoContextApi(getMe));
        };
        const syncComponents = () => {
          const children$1 = children(item2);
          const subs2 = bind$3(children$1, (child2) => systemApi.get().getByDom(child2).fold(() => [], pure$2));
          subcomponents.set(subs2);
        };
        const config2 = (behaviour) => {
          const b2 = bData;
          const f2 = isFunction(b2[behaviour.name()]) ? b2[behaviour.name()] : () => {
            throw new Error("Could not find " + behaviour.name() + " in " + JSON.stringify(spec, null, 2));
          };
          return f2();
        };
        const hasConfigured = (behaviour) => isFunction(bData[behaviour.name()]);
        const getApis = () => info.apis;
        const readState = (behaviourName) => bData[behaviourName]().map((b2) => b2.state.readState()).getOr("not enabled");
        const me = {
          uid: spec.uid,
          getSystem: systemApi.get,
          config: config2,
          hasConfigured,
          spec,
          readState,
          getApis,
          connect,
          disconnect,
          element: item2,
          syncComponents,
          components: subcomponents.get,
          events: events2
        };
        return me;
      };
      const buildSubcomponents = (spec, obsoleted) => {
        const components2 = get$h(spec, "components").getOr([]);
        return obsoleted.fold(() => map$2(components2, build$1), (obs) => map$2(components2, (c, i) => {
          return buildOrPatch(c, child$2(obs, i));
        }));
      };
      const buildFromSpec = (userSpec, obsoleted) => {
        const { events: specEvents, ...spec } = make$7(userSpec);
        const components2 = buildSubcomponents(spec, obsoleted);
        const completeSpec = {
          ...spec,
          events: { ...DefaultEvents, ...specEvents },
          components: components2
        };
        return Result.value(
          // Note, this isn't a spec any more, because it has built children
          build$2(completeSpec, obsoleted)
        );
      };
      const text$2 = (textContent) => {
        const element2 = SugarElement.fromText(textContent);
        return external({
          element: element2
        });
      };
      const external = (spec) => {
        const extSpec = asRawOrDie$1("external.component", objOfOnly([
          required$1("element"),
          option$3("uid")
        ]), spec);
        const systemApi = Cell(NoContextApi());
        const connect = (newApi) => {
          systemApi.set(newApi);
        };
        const disconnect = () => {
          systemApi.set(NoContextApi(() => me));
        };
        const uid = extSpec.uid.getOrThunk(() => generate$4("external"));
        writeOnly(extSpec.element, uid);
        const me = {
          uid,
          getSystem: systemApi.get,
          config: Optional.none,
          hasConfigured: never,
          connect,
          disconnect,
          getApis: () => ({}),
          element: extSpec.element,
          spec,
          readState: constant$1("No state"),
          syncComponents: noop,
          components: constant$1([]),
          events: {}
        };
        return premade$1(me);
      };
      const uids = generate$4;
      const isSketchSpec$1 = (spec) => has$2(spec, "uid");
      const buildOrPatch = (spec, obsoleted) => getPremade(spec).getOrThunk(() => {
        const userSpecWithUid = isSketchSpec$1(spec) ? spec : {
          uid: uids(""),
          ...spec
        };
        return buildFromSpec(userSpecWithUid, obsoleted).getOrDie();
      });
      const build$1 = (spec) => buildOrPatch(spec, Optional.none());
      const premade = premade$1;
      const block = (component, config2, state, getBusySpec2) => {
        set$9(component.element, "aria-busy", true);
        const root = config2.getRoot(component).getOr(component);
        const blockerBehaviours = derive$1([
          // Trap the "Tab" key and don't let it escape.
          Keying.config({
            mode: "special",
            onTab: () => Optional.some(true),
            onShiftTab: () => Optional.some(true)
          }),
          Focusing.config({})
        ]);
        const blockSpec = getBusySpec2(root, blockerBehaviours);
        const blocker = root.getSystem().build(blockSpec);
        Replacing.append(root, premade(blocker));
        if (blocker.hasConfigured(Keying) && config2.focus) {
          Keying.focusIn(blocker);
        }
        if (!state.isBlocked()) {
          config2.onBlock(component);
        }
        state.blockWith(() => Replacing.remove(root, blocker));
      };
      const unblock = (component, config2, state) => {
        remove$8(component.element, "aria-busy");
        if (state.isBlocked()) {
          config2.onUnblock(component);
        }
        state.clear();
      };
      const isBlocked = (component, blockingConfig, blockingState) => blockingState.isBlocked();
      var BlockingApis = Object.freeze({
        __proto__: null,
        block,
        unblock,
        isBlocked
      });
      var BlockingSchema = [
        // The blocking behaviour places a blocking element over the DOM while the
        // component is in the blocked state. If a function is provided here that
        // returns Some, then the blocking element will be added as a child of the
        // element returned. Otherwise, it will be added as a child of the main
        // component.
        defaultedFunction("getRoot", Optional.none),
        // This boolean, if provided, will specify whether the blocking element is
        // focused when the component is first blocked
        defaultedBoolean("focus", true),
        // This function, if provided, will be called any time the component is
        // blocked (unless it was already blocked).
        onHandler("onBlock"),
        // This function, if provided, will be called any time the component is
        // unblocked (unless it was already unblocked).
        onHandler("onUnblock")
      ];
      const init$f = () => {
        const blocker = destroyable();
        const blockWith = (destroy) => {
          blocker.set({ destroy });
        };
        return nu$4({
          readState: blocker.isSet,
          blockWith,
          clear: blocker.clear,
          isBlocked: blocker.isSet
        });
      };
      var BlockingState = Object.freeze({
        __proto__: null,
        init: init$f
      });
      const Blocking = create$3({
        fields: BlockingSchema,
        name: "blocking",
        apis: BlockingApis,
        state: BlockingState
      });
      const getCurrent = (component, composeConfig, _composeState) => composeConfig.find(component);
      var ComposeApis = Object.freeze({
        __proto__: null,
        getCurrent
      });
      const ComposeSchema = [
        required$1("find")
      ];
      const Composing = create$3({
        fields: ComposeSchema,
        name: "composing",
        apis: ComposeApis
      });
      const getCoupled = (component, coupleConfig, coupleState, name2) => coupleState.getOrCreate(component, coupleConfig, name2);
      const getExistingCoupled = (component, coupleConfig, coupleState, name2) => coupleState.getExisting(component, coupleConfig, name2);
      var CouplingApis = Object.freeze({
        __proto__: null,
        getCoupled,
        getExistingCoupled
      });
      var CouplingSchema = [
        requiredOf("others", setOf(Result.value, anyValue()))
      ];
      const init$e = () => {
        const coupled = {};
        const lookupCoupled = (coupleConfig, coupledName) => {
          const available = keys(coupleConfig.others);
          if (available.length === 0) {
            throw new Error("Cannot find any known coupled components");
          } else {
            return get$h(coupled, coupledName);
          }
        };
        const getOrCreate = (component, coupleConfig, name2) => {
          return lookupCoupled(coupleConfig, name2).getOrThunk(() => {
            const builder2 = get$h(coupleConfig.others, name2).getOrDie("No information found for coupled component: " + name2);
            const spec = builder2(component);
            const built = component.getSystem().build(spec);
            coupled[name2] = built;
            return built;
          });
        };
        const getExisting = (component, coupleConfig, name2) => {
          return lookupCoupled(coupleConfig, name2).orThunk(() => {
            get$h(coupleConfig.others, name2).getOrDie("No information found for coupled component: " + name2);
            return Optional.none();
          });
        };
        const readState = constant$1({});
        return nu$4({
          readState,
          getExisting,
          getOrCreate
        });
      };
      var CouplingState = Object.freeze({
        __proto__: null,
        init: init$e
      });
      const Coupling = create$3({
        fields: CouplingSchema,
        name: "coupling",
        apis: CouplingApis,
        state: CouplingState
      });
      const nativeDisabled = [
        "input",
        "button",
        "textarea",
        "select"
      ];
      const onLoad$5 = (component, disableConfig, disableState) => {
        const f2 = disableConfig.disabled() ? disable : enable;
        f2(component, disableConfig);
      };
      const hasNative = (component, config2) => config2.useNative === true && contains$2(nativeDisabled, name$3(component.element));
      const nativeIsDisabled = (component) => has$1(component.element, "disabled");
      const nativeDisable = (component) => {
        set$9(component.element, "disabled", "disabled");
      };
      const nativeEnable = (component) => {
        remove$8(component.element, "disabled");
      };
      const ariaIsDisabled = (component) => get$g(component.element, "aria-disabled") === "true";
      const ariaDisable = (component) => {
        set$9(component.element, "aria-disabled", "true");
      };
      const ariaEnable = (component) => {
        set$9(component.element, "aria-disabled", "false");
      };
      const disable = (component, disableConfig, _disableState) => {
        disableConfig.disableClass.each((disableClass) => {
          add$2(component.element, disableClass);
        });
        const f2 = hasNative(component, disableConfig) ? nativeDisable : ariaDisable;
        f2(component);
        disableConfig.onDisabled(component);
      };
      const enable = (component, disableConfig, _disableState) => {
        disableConfig.disableClass.each((disableClass) => {
          remove$3(component.element, disableClass);
        });
        const f2 = hasNative(component, disableConfig) ? nativeEnable : ariaEnable;
        f2(component);
        disableConfig.onEnabled(component);
      };
      const isDisabled$1 = (component, disableConfig) => hasNative(component, disableConfig) ? nativeIsDisabled(component) : ariaIsDisabled(component);
      const set$2 = (component, disableConfig, disableState, disabled) => {
        const f2 = disabled ? disable : enable;
        f2(component, disableConfig);
      };
      var DisableApis = Object.freeze({
        __proto__: null,
        enable,
        disable,
        isDisabled: isDisabled$1,
        onLoad: onLoad$5,
        set: set$2
      });
      const exhibit$5 = (base2, disableConfig) => nu$2({
        // Do not add the attribute yet, because it will depend on the node name
        // if we use "aria-disabled" or just "disabled"
        classes: disableConfig.disabled() ? disableConfig.disableClass.toArray() : []
      });
      const events$f = (disableConfig, disableState) => derive$2([
        abort(execute$5(), (component, _simulatedEvent) => isDisabled$1(component, disableConfig)),
        loadEvent(disableConfig, disableState, onLoad$5)
      ]);
      var ActiveDisable = Object.freeze({
        __proto__: null,
        exhibit: exhibit$5,
        events: events$f
      });
      var DisableSchema = [
        defaultedFunction("disabled", never),
        defaulted("useNative", true),
        option$3("disableClass"),
        onHandler("onDisabled"),
        onHandler("onEnabled")
      ];
      const Disabling = create$3({
        fields: DisableSchema,
        name: "disabling",
        active: ActiveDisable,
        apis: DisableApis
      });
      const NuPositionCss = (position2, left2, top2, right2, bottom2) => {
        const toPx = (num) => num + "px";
        return {
          position: position2,
          left: left2.map(toPx),
          top: top2.map(toPx),
          right: right2.map(toPx),
          bottom: bottom2.map(toPx)
        };
      };
      const toOptions = (position2) => ({
        ...position2,
        position: Optional.some(position2.position)
      });
      const applyPositionCss = (element2, position2) => {
        setOptions(element2, toOptions(position2));
      };
      const appear = (component, contextualInfo) => {
        const elem = component.element;
        add$2(elem, contextualInfo.transitionClass);
        remove$3(elem, contextualInfo.fadeOutClass);
        add$2(elem, contextualInfo.fadeInClass);
        contextualInfo.onShow(component);
      };
      const disappear = (component, contextualInfo) => {
        const elem = component.element;
        add$2(elem, contextualInfo.transitionClass);
        remove$3(elem, contextualInfo.fadeInClass);
        add$2(elem, contextualInfo.fadeOutClass);
        contextualInfo.onHide(component);
      };
      const isPartiallyVisible = (box2, bounds2) => box2.y < bounds2.bottom && box2.bottom > bounds2.y;
      const isTopCompletelyVisible = (box2, bounds2) => box2.y >= bounds2.y;
      const isBottomCompletelyVisible = (box2, bounds2) => box2.bottom <= bounds2.bottom;
      const forceTopPosition = (winBox, leftX, viewport2) => ({
        location: "top",
        leftX,
        topY: viewport2.bounds.y - winBox.y
      });
      const forceBottomPosition = (winBox, leftX, viewport2) => ({
        location: "bottom",
        leftX,
        bottomY: winBox.bottom - viewport2.bounds.bottom
      });
      const getDockedLeftPosition = (bounds2) => {
        return bounds2.box.x - bounds2.win.x;
      };
      const tryDockingPosition = (modes, bounds2, viewport2) => {
        const winBox = bounds2.win;
        const box2 = bounds2.box;
        const leftX = getDockedLeftPosition(bounds2);
        return findMap(modes, (mode) => {
          switch (mode) {
            case "bottom":
              return !isBottomCompletelyVisible(box2, viewport2.bounds) ? Optional.some(forceBottomPosition(winBox, leftX, viewport2)) : Optional.none();
            case "top":
              return !isTopCompletelyVisible(box2, viewport2.bounds) ? Optional.some(forceTopPosition(winBox, leftX, viewport2)) : Optional.none();
            default:
              return Optional.none();
          }
        }).getOr({
          location: "no-dock"
        });
      };
      const isVisibleForModes = (modes, box2, viewport2) => forall(modes, (mode) => {
        switch (mode) {
          case "bottom":
            return isBottomCompletelyVisible(box2, viewport2.bounds);
          case "top":
            return isTopCompletelyVisible(box2, viewport2.bounds);
        }
      });
      const getXYForRestoring = (pos, viewport2) => {
        const priorY = viewport2.optScrollEnv.fold(constant$1(pos.bounds.y), (scrollEnv) => scrollEnv.scrollElmTop + (pos.bounds.y - scrollEnv.currentScrollTop));
        return SugarPosition(pos.bounds.x, priorY);
      };
      const getXYForSaving = (box2, viewport2) => {
        const priorY = viewport2.optScrollEnv.fold(constant$1(box2.y), (scrollEnv) => box2.y + scrollEnv.currentScrollTop - scrollEnv.scrollElmTop);
        return SugarPosition(box2.x, priorY);
      };
      const getPrior = (elem, viewport2, state) => state.getInitialPos().map((pos) => {
        const xy = getXYForRestoring(pos, viewport2);
        return {
          box: bounds(xy.left, xy.top, get$c(elem), get$d(elem)),
          location: pos.location
        };
      });
      const storePrior = (elem, box2, viewport2, state, decision) => {
        const xy = getXYForSaving(box2, viewport2);
        const bounds$12 = bounds(xy.left, xy.top, box2.width, box2.height);
        state.setInitialPos({
          style: getAllRaw(elem),
          position: get$e(elem, "position") || "static",
          bounds: bounds$12,
          location: decision.location
        });
      };
      const storePriorIfNone = (elem, box2, viewport2, state, decision) => {
        state.getInitialPos().fold(() => storePrior(elem, box2, viewport2, state, decision), () => noop);
      };
      const revertToOriginal = (elem, box2, state) => state.getInitialPos().bind((position2) => {
        var _a;
        state.clearInitialPos();
        switch (position2.position) {
          case "static":
            return Optional.some({
              morph: "static"
            });
          case "absolute":
            const offsetParent2 = getOffsetParent(elem).getOr(body());
            const offsetBox = box$1(offsetParent2);
            const scrollDelta = (_a = offsetParent2.dom.scrollTop) !== null && _a !== void 0 ? _a : 0;
            return Optional.some({
              morph: "absolute",
              positionCss: NuPositionCss("absolute", get$h(position2.style, "left").map((_left) => box2.x - offsetBox.x), get$h(position2.style, "top").map((_top) => box2.y - offsetBox.y + scrollDelta), get$h(position2.style, "right").map((_right) => offsetBox.right - box2.right), get$h(position2.style, "bottom").map((_bottom) => offsetBox.bottom - box2.bottom))
            });
          default:
            return Optional.none();
        }
      });
      const tryMorphToOriginal = (elem, viewport2, state) => getPrior(elem, viewport2, state).filter(({ box: box2 }) => isVisibleForModes(state.getModes(), box2, viewport2)).bind(({ box: box2 }) => revertToOriginal(elem, box2, state));
      const tryDecisionToFixedMorph = (decision) => {
        switch (decision.location) {
          case "top": {
            return Optional.some({
              morph: "fixed",
              positionCss: NuPositionCss("fixed", Optional.some(decision.leftX), Optional.some(decision.topY), Optional.none(), Optional.none())
            });
          }
          case "bottom": {
            return Optional.some({
              morph: "fixed",
              positionCss: NuPositionCss("fixed", Optional.some(decision.leftX), Optional.none(), Optional.none(), Optional.some(decision.bottomY))
            });
          }
          default:
            return Optional.none();
        }
      };
      const tryMorphToFixed = (elem, viewport2, state) => {
        const box2 = box$1(elem);
        const winBox = win();
        const decision = tryDockingPosition(state.getModes(), {
          win: winBox,
          box: box2
        }, viewport2);
        if (decision.location === "top" || decision.location === "bottom") {
          storePrior(elem, box2, viewport2, state, decision);
          return tryDecisionToFixedMorph(decision);
        } else {
          return Optional.none();
        }
      };
      const tryMorphToOriginalOrUpdateFixed = (elem, viewport2, state) => {
        return tryMorphToOriginal(elem, viewport2, state).orThunk(() => {
          return viewport2.optScrollEnv.bind((_) => getPrior(elem, viewport2, state)).bind(({ box: box2, location }) => {
            const winBox = win();
            const leftX = getDockedLeftPosition({ win: winBox, box: box2 });
            const decision = location === "top" ? forceTopPosition(winBox, leftX, viewport2) : forceBottomPosition(winBox, leftX, viewport2);
            return tryDecisionToFixedMorph(decision);
          });
        });
      };
      const tryMorph = (component, viewport2, state) => {
        const elem = component.element;
        const isDocked2 = is$1(getRaw(elem, "position"), "fixed");
        return isDocked2 ? tryMorphToOriginalOrUpdateFixed(elem, viewport2, state) : tryMorphToFixed(elem, viewport2, state);
      };
      const calculateMorphToOriginal = (component, viewport2, state) => {
        const elem = component.element;
        return getPrior(elem, viewport2, state).bind(({ box: box2 }) => revertToOriginal(elem, box2, state));
      };
      const forceDockWith = (elem, viewport2, state, getDecision) => {
        const box2 = box$1(elem);
        const winBox = win();
        const leftX = getDockedLeftPosition({ win: winBox, box: box2 });
        const decision = getDecision(winBox, leftX, viewport2);
        if (decision.location === "bottom" || decision.location === "top") {
          storePriorIfNone(elem, box2, viewport2, state, decision);
          return tryDecisionToFixedMorph(decision);
        } else {
          return Optional.none();
        }
      };
      const morphToStatic = (component, config2, state) => {
        state.setDocked(false);
        each$1(["left", "right", "top", "bottom", "position"], (prop) => remove$6(component.element, prop));
        config2.onUndocked(component);
      };
      const morphToCoord = (component, config2, state, position2) => {
        const isDocked2 = position2.position === "fixed";
        state.setDocked(isDocked2);
        applyPositionCss(component.element, position2);
        const method = isDocked2 ? config2.onDocked : config2.onUndocked;
        method(component);
      };
      const updateVisibility = (component, config2, state, viewport2, morphToDocked = false) => {
        config2.contextual.each((contextInfo) => {
          contextInfo.lazyContext(component).each((box2) => {
            const isVisible2 = isPartiallyVisible(box2, viewport2.bounds);
            if (isVisible2 !== state.isVisible()) {
              state.setVisible(isVisible2);
              if (morphToDocked && !isVisible2) {
                add$1(component.element, [contextInfo.fadeOutClass]);
                contextInfo.onHide(component);
              } else {
                const method = isVisible2 ? appear : disappear;
                method(component, contextInfo);
              }
            }
          });
        });
      };
      const applyFixedMorph = (component, config2, state, viewport2, morph) => {
        updateVisibility(component, config2, state, viewport2, true);
        morphToCoord(component, config2, state, morph.positionCss);
      };
      const applyMorph = (component, config2, state, viewport2, morph) => {
        switch (morph.morph) {
          case "static": {
            return morphToStatic(component, config2, state);
          }
          case "absolute": {
            return morphToCoord(component, config2, state, morph.positionCss);
          }
          case "fixed": {
            return applyFixedMorph(component, config2, state, viewport2, morph);
          }
        }
      };
      const refreshInternal = (component, config2, state) => {
        const viewport2 = config2.lazyViewport(component);
        updateVisibility(component, config2, state, viewport2);
        tryMorph(component, viewport2, state).each((morph) => {
          applyMorph(component, config2, state, viewport2, morph);
        });
      };
      const resetInternal = (component, config2, state) => {
        const elem = component.element;
        state.setDocked(false);
        const viewport2 = config2.lazyViewport(component);
        calculateMorphToOriginal(component, viewport2, state).each((staticOrAbsoluteMorph) => {
          switch (staticOrAbsoluteMorph.morph) {
            case "static": {
              morphToStatic(component, config2, state);
              break;
            }
            case "absolute": {
              morphToCoord(component, config2, state, staticOrAbsoluteMorph.positionCss);
              break;
            }
          }
        });
        state.setVisible(true);
        config2.contextual.each((contextInfo) => {
          remove$2(elem, [contextInfo.fadeInClass, contextInfo.fadeOutClass, contextInfo.transitionClass]);
          contextInfo.onShow(component);
        });
        refresh$4(component, config2, state);
      };
      const refresh$4 = (component, config2, state) => {
        if (component.getSystem().isConnected()) {
          refreshInternal(component, config2, state);
        }
      };
      const reset$1 = (component, config2, state) => {
        if (state.isDocked()) {
          resetInternal(component, config2, state);
        }
      };
      const forceDockWithDecision = (getDecision) => (component, config2, state) => {
        const viewport2 = config2.lazyViewport(component);
        const optMorph = forceDockWith(component.element, viewport2, state, getDecision);
        optMorph.each((morph) => {
          applyFixedMorph(component, config2, state, viewport2, morph);
        });
      };
      const forceDockToTop = forceDockWithDecision(forceTopPosition);
      const forceDockToBottom = forceDockWithDecision(forceBottomPosition);
      const isDocked$2 = (component, config2, state) => state.isDocked();
      const setModes = (component, config2, state, modes) => state.setModes(modes);
      const getModes = (component, config2, state) => state.getModes();
      var DockingApis = Object.freeze({
        __proto__: null,
        refresh: refresh$4,
        reset: reset$1,
        isDocked: isDocked$2,
        getModes,
        setModes,
        forceDockToTop,
        forceDockToBottom
      });
      const events$e = (dockInfo, dockState) => derive$2([
        runOnSource(transitionend(), (component, simulatedEvent) => {
          dockInfo.contextual.each((contextInfo) => {
            if (has(component.element, contextInfo.transitionClass)) {
              remove$2(component.element, [contextInfo.transitionClass, contextInfo.fadeInClass]);
              const notify = dockState.isVisible() ? contextInfo.onShown : contextInfo.onHidden;
              notify(component);
            }
            simulatedEvent.stop();
          });
        }),
        run$1(windowScroll(), (component, _) => {
          refresh$4(component, dockInfo, dockState);
        }),
        run$1(externalElementScroll(), (component, _) => {
          refresh$4(component, dockInfo, dockState);
        }),
        run$1(windowResize(), (component, _) => {
          reset$1(component, dockInfo, dockState);
        })
      ]);
      var ActiveDocking = Object.freeze({
        __proto__: null,
        events: events$e
      });
      var DockingSchema = [
        optionObjOf("contextual", [
          requiredString("fadeInClass"),
          requiredString("fadeOutClass"),
          requiredString("transitionClass"),
          requiredFunction("lazyContext"),
          onHandler("onShow"),
          onHandler("onShown"),
          onHandler("onHide"),
          onHandler("onHidden")
        ]),
        defaultedFunction("lazyViewport", () => ({
          bounds: win(),
          optScrollEnv: Optional.none()
        })),
        defaultedArrayOf("modes", ["top", "bottom"], string),
        onHandler("onDocked"),
        onHandler("onUndocked")
      ];
      const init$d = (spec) => {
        const docked = Cell(false);
        const visible = Cell(true);
        const initialBounds = value$2();
        const modes = Cell(spec.modes);
        const readState = () => `docked:  ${docked.get()}, visible: ${visible.get()}, modes: ${modes.get().join(",")}`;
        return nu$4({
          isDocked: docked.get,
          setDocked: docked.set,
          getInitialPos: initialBounds.get,
          setInitialPos: initialBounds.set,
          clearInitialPos: initialBounds.clear,
          isVisible: visible.get,
          setVisible: visible.set,
          getModes: modes.get,
          setModes: modes.set,
          readState
        });
      };
      var DockingState = Object.freeze({
        __proto__: null,
        init: init$d
      });
      const Docking = create$3({
        fields: DockingSchema,
        name: "docking",
        active: ActiveDocking,
        apis: DockingApis,
        state: DockingState
      });
      const adt$4 = Adt.generate([
        { offset: ["x", "y"] },
        { absolute: ["x", "y"] },
        { fixed: ["x", "y"] }
      ]);
      const subtract = (change2) => (point2) => point2.translate(-change2.left, -change2.top);
      const add = (change2) => (point2) => point2.translate(change2.left, change2.top);
      const transform = (changes) => (x, y) => foldl(changes, (rest, f2) => f2(rest), SugarPosition(x, y));
      const asFixed = (coord, scroll, origin) => coord.fold(
        // offset to fixed
        transform([add(origin), subtract(scroll)]),
        // absolute to fixed
        transform([subtract(scroll)]),
        // fixed to fixed
        transform([])
      );
      const asAbsolute = (coord, scroll, origin) => coord.fold(
        // offset to absolute
        transform([add(origin)]),
        // absolute to absolute
        transform([]),
        // fixed to absolute
        transform([add(scroll)])
      );
      const asOffset = (coord, scroll, origin) => coord.fold(
        // offset to offset
        transform([]),
        // absolute to offset
        transform([subtract(origin)]),
        // fixed to offset
        transform([add(scroll), subtract(origin)])
      );
      const withinRange = (coord1, coord2, xRange2, yRange2, scroll, origin) => {
        const a1 = asAbsolute(coord1, scroll, origin);
        const a2 = asAbsolute(coord2, scroll, origin);
        return Math.abs(a1.left - a2.left) <= xRange2 && Math.abs(a1.top - a2.top) <= yRange2;
      };
      const getDeltas = (coord1, coord2, xRange2, yRange2, scroll, origin) => {
        const a1 = asAbsolute(coord1, scroll, origin);
        const a2 = asAbsolute(coord2, scroll, origin);
        const left2 = Math.abs(a1.left - a2.left);
        const top2 = Math.abs(a1.top - a2.top);
        return SugarPosition(left2, top2);
      };
      const toStyles = (coord, scroll, origin) => {
        const stylesOpt = coord.fold(
          (x, y) => ({ position: Optional.some("absolute"), left: Optional.some(x + "px"), top: Optional.some(y + "px") }),
          // offset
          (x, y) => ({ position: Optional.some("absolute"), left: Optional.some(x - origin.left + "px"), top: Optional.some(y - origin.top + "px") }),
          // absolute
          (x, y) => ({ position: Optional.some("fixed"), left: Optional.some(x + "px"), top: Optional.some(y + "px") })
          // fixed
        );
        return { right: Optional.none(), bottom: Optional.none(), ...stylesOpt };
      };
      const translate$2 = (coord, deltaX, deltaY) => coord.fold((x, y) => offset(x + deltaX, y + deltaY), (x, y) => absolute$1(x + deltaX, y + deltaY), (x, y) => fixed$1(x + deltaX, y + deltaY));
      const absorb = (partialCoord, originalCoord, scroll, origin) => {
        const absorbOne = (stencil, nu2) => (optX, optY) => {
          const original2 = stencil(originalCoord, scroll, origin);
          return nu2(optX.getOr(original2.left), optY.getOr(original2.top));
        };
        return partialCoord.fold(absorbOne(asOffset, offset), absorbOne(asAbsolute, absolute$1), absorbOne(asFixed, fixed$1));
      };
      const offset = adt$4.offset;
      const absolute$1 = adt$4.absolute;
      const fixed$1 = adt$4.fixed;
      const parseAttrToInt = (element2, name2) => {
        const value2 = get$g(element2, name2);
        return isUndefined(value2) ? NaN : parseInt(value2, 10);
      };
      const get$3 = (component, snapsInfo) => {
        const element2 = component.element;
        const x = parseAttrToInt(element2, snapsInfo.leftAttr);
        const y = parseAttrToInt(element2, snapsInfo.topAttr);
        return isNaN(x) || isNaN(y) ? Optional.none() : Optional.some(SugarPosition(x, y));
      };
      const set$1 = (component, snapsInfo, pt) => {
        const element2 = component.element;
        set$9(element2, snapsInfo.leftAttr, pt.left + "px");
        set$9(element2, snapsInfo.topAttr, pt.top + "px");
      };
      const clear = (component, snapsInfo) => {
        const element2 = component.element;
        remove$8(element2, snapsInfo.leftAttr);
        remove$8(element2, snapsInfo.topAttr);
      };
      const getCoords = (component, snapInfo, coord, delta) => get$3(component, snapInfo).fold(() => coord, (fixed2) => (
        // We have a pre-snap position, so we have to apply the delta ourselves
        fixed$1(fixed2.left + delta.left, fixed2.top + delta.top)
      ));
      const moveOrSnap = (component, snapInfo, coord, delta, scroll, origin) => {
        const newCoord = getCoords(component, snapInfo, coord, delta);
        const snap2 = snapInfo.mustSnap ? findClosestSnap(component, snapInfo, newCoord, scroll, origin) : findSnap(component, snapInfo, newCoord, scroll, origin);
        const fixedCoord = asFixed(newCoord, scroll, origin);
        set$1(component, snapInfo, fixedCoord);
        return snap2.fold(
          () => ({
            coord: fixed$1(fixedCoord.left, fixedCoord.top),
            extra: Optional.none()
          }),
          (spanned) => ({
            coord: spanned.output,
            extra: spanned.extra
          })
        );
      };
      const stopDrag = (component, snapInfo) => {
        clear(component, snapInfo);
      };
      const findMatchingSnap = (snaps, newCoord, scroll, origin) => findMap(snaps, (snap2) => {
        const sensor = snap2.sensor;
        const inRange = withinRange(newCoord, sensor, snap2.range.left, snap2.range.top, scroll, origin);
        return inRange ? Optional.some({
          output: absorb(snap2.output, newCoord, scroll, origin),
          extra: snap2.extra
        }) : Optional.none();
      });
      const findClosestSnap = (component, snapInfo, newCoord, scroll, origin) => {
        const snaps = snapInfo.getSnapPoints(component);
        const matchSnap = findMatchingSnap(snaps, newCoord, scroll, origin);
        return matchSnap.orThunk(() => {
          const bestSnap = foldl(snaps, (acc, snap2) => {
            const sensor = snap2.sensor;
            const deltas = getDeltas(newCoord, sensor, snap2.range.left, snap2.range.top, scroll, origin);
            return acc.deltas.fold(() => ({
              deltas: Optional.some(deltas),
              snap: Optional.some(snap2)
            }), (bestDeltas) => {
              const currAvg = (deltas.left + deltas.top) / 2;
              const bestAvg = (bestDeltas.left + bestDeltas.top) / 2;
              if (currAvg <= bestAvg) {
                return {
                  deltas: Optional.some(deltas),
                  snap: Optional.some(snap2)
                };
              } else {
                return acc;
              }
            });
          }, {
            deltas: Optional.none(),
            snap: Optional.none()
          });
          return bestSnap.snap.map((snap2) => ({
            output: absorb(snap2.output, newCoord, scroll, origin),
            extra: snap2.extra
          }));
        });
      };
      const findSnap = (component, snapInfo, newCoord, scroll, origin) => {
        const snaps = snapInfo.getSnapPoints(component);
        return findMatchingSnap(snaps, newCoord, scroll, origin);
      };
      const snapTo$1 = (snap2, scroll, origin) => ({
        // TODO: This looks to be incorrect and needs fixing as DragCoord definitely needs a number
        // based drag coord for the second argument here, so this is probably a bug.
        coord: absorb(snap2.output, snap2.output, scroll, origin),
        extra: snap2.extra
      });
      const snapTo = (component, dragConfig, _state, snap2) => {
        const target = dragConfig.getTarget(component.element);
        if (dragConfig.repositionTarget) {
          const doc = owner$4(component.element);
          const scroll = get$b(doc);
          const origin = getOrigin(target);
          const snapPin = snapTo$1(snap2, scroll, origin);
          const styles = toStyles(snapPin.coord, scroll, origin);
          setOptions(target, styles);
        }
      };
      var DraggingApis = Object.freeze({
        __proto__: null,
        snapTo
      });
      const field = (name2, forbidden) => defaultedObjOf(name2, {}, map$2(forbidden, (f2) => forbid(f2.name(), "Cannot configure " + f2.name() + " for " + name2)).concat([
        customField("dump", identity)
      ]));
      const get$2 = (data) => data.dump;
      const augment = (data, original2) => ({
        ...derive$1(original2),
        ...data.dump
      });
      const SketchBehaviours = {
        field,
        augment,
        get: get$2
      };
      const base = (partSchemas, partUidsSchemas) => {
        const ps = partSchemas.length > 0 ? [
          requiredObjOf("parts", partSchemas)
        ] : [];
        return ps.concat([
          required$1("uid"),
          defaulted("dom", {}),
          // Maybe get rid of.
          defaulted("components", []),
          snapshot("originalSpec"),
          defaulted("debug.sketcher", {})
        ]).concat(partUidsSchemas);
      };
      const asRawOrDie = (label2, schema2, spec, partSchemas, partUidsSchemas) => {
        const baseS = base(partSchemas, partUidsSchemas);
        return asRawOrDie$1(label2 + " [SpecSchema]", objOfOnly(baseS.concat(schema2)), spec);
      };
      const single$1 = (owner2, schema2, factory2, spec) => {
        const specWithUid = supplyUid(spec);
        const detail = asRawOrDie(owner2, schema2, specWithUid, [], []);
        return factory2(detail, specWithUid);
      };
      const composite$1 = (owner2, schema2, partTypes, factory2, spec) => {
        const specWithUid = supplyUid(spec);
        const partSchemas = schemas(partTypes);
        const partUidsSchema = defaultUidsSchema(partTypes);
        const detail = asRawOrDie(owner2, schema2, specWithUid, partSchemas, [partUidsSchema]);
        const subs2 = substitutes(owner2, detail, partTypes);
        const components2 = components$1(owner2, detail, subs2.internals());
        return factory2(detail, components2, specWithUid, subs2.externals());
      };
      const hasUid = (spec) => has$2(spec, "uid");
      const supplyUid = (spec) => {
        return hasUid(spec) ? spec : {
          ...spec,
          uid: generate$4("uid")
        };
      };
      const isSketchSpec = (spec) => {
        return spec.uid !== void 0;
      };
      const singleSchema = objOfOnly([
        required$1("name"),
        required$1("factory"),
        required$1("configFields"),
        defaulted("apis", {}),
        defaulted("extraApis", {})
      ]);
      const compositeSchema = objOfOnly([
        required$1("name"),
        required$1("factory"),
        required$1("configFields"),
        required$1("partFields"),
        defaulted("apis", {}),
        defaulted("extraApis", {})
      ]);
      const single = (rawConfig) => {
        const config2 = asRawOrDie$1("Sketcher for " + rawConfig.name, singleSchema, rawConfig);
        const sketch2 = (spec) => single$1(config2.name, config2.configFields, config2.factory, spec);
        const apis = map$1(config2.apis, makeApi);
        const extraApis = map$1(config2.extraApis, (f2, k) => markAsExtraApi(f2, k));
        return {
          name: config2.name,
          configFields: config2.configFields,
          sketch: sketch2,
          ...apis,
          ...extraApis
        };
      };
      const composite = (rawConfig) => {
        const config2 = asRawOrDie$1("Sketcher for " + rawConfig.name, compositeSchema, rawConfig);
        const sketch2 = (spec) => composite$1(config2.name, config2.configFields, config2.partFields, config2.factory, spec);
        const parts2 = generate$5(config2.name, config2.partFields);
        const apis = map$1(config2.apis, makeApi);
        const extraApis = map$1(config2.extraApis, (f2, k) => markAsExtraApi(f2, k));
        return {
          name: config2.name,
          partFields: config2.partFields,
          configFields: config2.configFields,
          sketch: sketch2,
          parts: parts2,
          ...apis,
          ...extraApis
        };
      };
      const factory$o = (detail) => {
        const { attributes, ...domWithoutAttributes } = detail.dom;
        return {
          uid: detail.uid,
          dom: {
            tag: "div",
            attributes: {
              role: "presentation",
              ...attributes
            },
            ...domWithoutAttributes
          },
          components: detail.components,
          behaviours: get$2(detail.containerBehaviours),
          events: detail.events,
          domModification: detail.domModification,
          eventOrder: detail.eventOrder
        };
      };
      const Container = single({
        name: "Container",
        factory: factory$o,
        configFields: [
          defaulted("components", []),
          field("containerBehaviours", []),
          // TODO: Deprecate
          defaulted("events", {}),
          defaulted("domModification", {}),
          defaulted("eventOrder", {})
        ]
      });
      const initialAttribute = "data-initial-z-index";
      const resetZIndex = (blocker) => {
        parent(blocker.element).filter(isElement$1).each((root) => {
          getOpt(root, initialAttribute).fold(() => remove$6(root, "z-index"), (zIndex) => set$7(root, "z-index", zIndex));
          remove$8(root, initialAttribute);
        });
      };
      const changeZIndex = (blocker) => {
        parent(blocker.element).filter(isElement$1).each((root) => {
          getRaw(root, "z-index").each((zindex) => {
            set$9(root, initialAttribute, zindex);
          });
          set$7(root, "z-index", get$e(blocker.element, "z-index"));
        });
      };
      const instigate = (anyComponent, blocker) => {
        anyComponent.getSystem().addToGui(blocker);
        changeZIndex(blocker);
      };
      const discard = (blocker) => {
        resetZIndex(blocker);
        blocker.getSystem().removeFromGui(blocker);
      };
      const createComponent = (component, blockerClass, blockerEvents) => component.getSystem().build(Container.sketch({
        dom: {
          // Probably consider doing with classes?
          styles: {
            "left": "0px",
            "top": "0px",
            "width": "100%",
            "height": "100%",
            "position": "fixed",
            "z-index": "1000000000000000"
          },
          classes: [blockerClass]
        },
        events: blockerEvents
      }));
      var SnapSchema = optionObjOf("snaps", [
        required$1("getSnapPoints"),
        onHandler("onSensor"),
        required$1("leftAttr"),
        required$1("topAttr"),
        defaulted("lazyViewport", win),
        defaulted("mustSnap", false)
      ]);
      const schema$s = [
        // Is this used?
        defaulted("useFixed", never),
        required$1("blockerClass"),
        defaulted("getTarget", identity),
        defaulted("onDrag", noop),
        defaulted("repositionTarget", true),
        defaulted("onDrop", noop),
        defaultedFunction("getBounds", win),
        SnapSchema
      ];
      const getCurrentCoord = (target) => lift3(getRaw(target, "left"), getRaw(target, "top"), getRaw(target, "position"), (left2, top2, position2) => {
        const nu2 = position2 === "fixed" ? fixed$1 : offset;
        return nu2(parseInt(left2, 10), parseInt(top2, 10));
      }).getOrThunk(() => {
        const location = absolute$3(target);
        return absolute$1(location.left, location.top);
      });
      const clampCoords = (component, coords, scroll, origin, startData) => {
        const bounds2 = startData.bounds;
        const absoluteCoord = asAbsolute(coords, scroll, origin);
        const newX = clamp(absoluteCoord.left, bounds2.x, bounds2.x + bounds2.width - startData.width);
        const newY = clamp(absoluteCoord.top, bounds2.y, bounds2.y + bounds2.height - startData.height);
        const newCoords = absolute$1(newX, newY);
        return coords.fold(
          // offset
          () => {
            const offset$1 = asOffset(newCoords, scroll, origin);
            return offset(offset$1.left, offset$1.top);
          },
          // absolute
          constant$1(newCoords),
          // fixed
          () => {
            const fixed2 = asFixed(newCoords, scroll, origin);
            return fixed$1(fixed2.left, fixed2.top);
          }
        );
      };
      const calcNewCoord = (component, optSnaps, currentCoord, scroll, origin, delta, startData) => {
        const newCoord = optSnaps.fold(() => {
          const translated = translate$2(currentCoord, delta.left, delta.top);
          const fixedCoord = asFixed(translated, scroll, origin);
          return fixed$1(fixedCoord.left, fixedCoord.top);
        }, (snapInfo) => {
          const snapping = moveOrSnap(component, snapInfo, currentCoord, delta, scroll, origin);
          snapping.extra.each((extra) => {
            snapInfo.onSensor(component, extra);
          });
          return snapping.coord;
        });
        return clampCoords(component, newCoord, scroll, origin, startData);
      };
      const dragBy = (component, dragConfig, startData, delta) => {
        const target = dragConfig.getTarget(component.element);
        if (dragConfig.repositionTarget) {
          const doc = owner$4(component.element);
          const scroll = get$b(doc);
          const origin = getOrigin(target);
          const currentCoord = getCurrentCoord(target);
          const newCoord = calcNewCoord(component, dragConfig.snaps, currentCoord, scroll, origin, delta, startData);
          const styles = toStyles(newCoord, scroll, origin);
          setOptions(target, styles);
        }
        dragConfig.onDrag(component, target, delta);
      };
      const calcStartData = (dragConfig, comp) => ({
        bounds: dragConfig.getBounds(),
        height: getOuter$1(comp.element),
        width: getOuter(comp.element)
      });
      const move = (component, dragConfig, dragState, dragMode, event) => {
        const delta = dragState.update(dragMode, event);
        const dragStartData = dragState.getStartData().getOrThunk(() => calcStartData(dragConfig, component));
        delta.each((dlt) => {
          dragBy(component, dragConfig, dragStartData, dlt);
        });
      };
      const stop = (component, blocker, dragConfig, dragState) => {
        blocker.each(discard);
        dragConfig.snaps.each((snapInfo) => {
          stopDrag(component, snapInfo);
        });
        const target = dragConfig.getTarget(component.element);
        dragState.reset();
        dragConfig.onDrop(component, target);
      };
      const handlers = (events2) => (dragConfig, dragState) => {
        const updateStartState = (comp) => {
          dragState.setStartData(calcStartData(dragConfig, comp));
        };
        return derive$2([
          run$1(windowScroll(), (comp) => {
            dragState.getStartData().each(() => updateStartState(comp));
          }),
          ...events2(dragConfig, dragState, updateStartState)
        ]);
      };
      const init$c = (dragApi) => derive$2([
        // When the user clicks on the blocker, something has probably gone slightly
        // wrong, so we'll just drop for safety. The blocker should really only
        // be there when the mouse is already down and not released, so a 'click'
        run$1(mousedown(), dragApi.forceDrop),
        // When the user releases the mouse on the blocker, that is a drop
        run$1(mouseup(), dragApi.drop),
        // As the user moves the mouse around (while pressed down), we move the
        // component around
        run$1(mousemove(), (comp, simulatedEvent) => {
          dragApi.move(simulatedEvent.event);
        }),
        // When the use moves outside the range, schedule a block to occur but
        // give it a chance to be cancelled.
        run$1(mouseout(), dragApi.delayDrop)
      ]);
      const getData$1 = (event) => Optional.from(SugarPosition(event.x, event.y));
      const getDelta$1 = (old, nu2) => SugarPosition(nu2.left - old.left, nu2.top - old.top);
      var MouseData = Object.freeze({
        __proto__: null,
        getData: getData$1,
        getDelta: getDelta$1
      });
      const events$d = (dragConfig, dragState, updateStartState) => [
        run$1(mousedown(), (component, simulatedEvent) => {
          const raw = simulatedEvent.event.raw;
          if (raw.button !== 0) {
            return;
          }
          simulatedEvent.stop();
          const stop$1 = () => stop(component, Optional.some(blocker), dragConfig, dragState);
          const delayDrop = DelayedFunction(stop$1, 200);
          const dragApi = {
            drop: stop$1,
            delayDrop: delayDrop.schedule,
            forceDrop: stop$1,
            move: (event) => {
              delayDrop.cancel();
              move(component, dragConfig, dragState, MouseData, event);
            }
          };
          const blocker = createComponent(component, dragConfig.blockerClass, init$c(dragApi));
          const start = () => {
            updateStartState(component);
            instigate(component, blocker);
          };
          start();
        })
      ];
      const schema$r = [
        ...schema$s,
        output$1("dragger", {
          handlers: handlers(events$d)
        })
      ];
      const init$b = (dragApi) => derive$2([
        // When the user taps on the blocker, something has probably gone slightly
        // wrong, so we'll just drop for safety. The blocker should really only
        // be there when their finger is already down and not released, so a 'tap'
        run$1(touchstart(), dragApi.forceDrop),
        // When the user releases their finger on the blocker, that is a drop
        run$1(touchend(), dragApi.drop),
        run$1(touchcancel(), dragApi.drop),
        // As the user moves their finger around (while pressed down), we move the
        // component around
        run$1(touchmove(), (comp, simulatedEvent) => {
          dragApi.move(simulatedEvent.event);
        })
      ]);
      const getDataFrom = (touches) => {
        const touch2 = touches[0];
        return Optional.some(SugarPosition(touch2.clientX, touch2.clientY));
      };
      const getData = (event) => {
        const raw = event.raw;
        const touches = raw.touches;
        return touches.length === 1 ? getDataFrom(touches) : Optional.none();
      };
      const getDelta = (old, nu2) => SugarPosition(nu2.left - old.left, nu2.top - old.top);
      var TouchData = Object.freeze({
        __proto__: null,
        getData,
        getDelta
      });
      const events$c = (dragConfig, dragState, updateStartState) => {
        const blockerSingleton = value$2();
        const stopBlocking = (component) => {
          stop(component, blockerSingleton.get(), dragConfig, dragState);
          blockerSingleton.clear();
        };
        return [
          run$1(touchstart(), (component, simulatedEvent) => {
            simulatedEvent.stop();
            const stop2 = () => stopBlocking(component);
            const dragApi = {
              drop: stop2,
              // delayDrop is not used by touch
              delayDrop: noop,
              forceDrop: stop2,
              move: (event) => {
                move(component, dragConfig, dragState, TouchData, event);
              }
            };
            const blocker = createComponent(component, dragConfig.blockerClass, init$b(dragApi));
            blockerSingleton.set(blocker);
            const start = () => {
              updateStartState(component);
              instigate(component, blocker);
            };
            start();
          }),
          run$1(touchmove(), (component, simulatedEvent) => {
            simulatedEvent.stop();
            move(component, dragConfig, dragState, TouchData, simulatedEvent.event);
          }),
          run$1(touchend(), (component, simulatedEvent) => {
            simulatedEvent.stop();
            stopBlocking(component);
          }),
          run$1(touchcancel(), stopBlocking)
        ];
      };
      const schema$q = [
        ...schema$s,
        output$1("dragger", {
          handlers: handlers(events$c)
        })
      ];
      const events$b = (dragConfig, dragState, updateStartState) => [
        ...events$d(dragConfig, dragState, updateStartState),
        ...events$c(dragConfig, dragState, updateStartState)
      ];
      const schema$p = [
        ...schema$s,
        output$1("dragger", {
          handlers: handlers(events$b)
        })
      ];
      const mouse = schema$r;
      const touch = schema$q;
      const mouseOrTouch = schema$p;
      var DraggingBranches = Object.freeze({
        __proto__: null,
        mouse,
        touch,
        mouseOrTouch
      });
      const init$a = () => {
        let previous = Optional.none();
        let startData = Optional.none();
        const reset2 = () => {
          previous = Optional.none();
          startData = Optional.none();
        };
        const calculateDelta = (mode, nu2) => {
          const result = previous.map((old) => mode.getDelta(old, nu2));
          previous = Optional.some(nu2);
          return result;
        };
        const update = (mode, dragEvent) => mode.getData(dragEvent).bind((nuData) => calculateDelta(mode, nuData));
        const setStartData = (data) => {
          startData = Optional.some(data);
        };
        const getStartData = () => startData;
        const readState = constant$1({});
        return nu$4({
          readState,
          reset: reset2,
          update,
          getStartData,
          setStartData
        });
      };
      var DragState = Object.freeze({
        __proto__: null,
        init: init$a
      });
      const Dragging = createModes({
        branchKey: "mode",
        branches: DraggingBranches,
        name: "dragging",
        active: {
          events: (dragConfig, dragState) => {
            const dragger = dragConfig.dragger;
            return dragger.handlers(dragConfig, dragState);
          }
        },
        extra: {
          // Extra. Does not need component as input.
          snap: (sConfig) => ({
            sensor: sConfig.sensor,
            range: sConfig.range,
            output: sConfig.output,
            extra: Optional.from(sConfig.extra)
          })
        },
        state: DragState,
        apis: DraggingApis
      });
      const ariaElements = [
        "input",
        "textarea"
      ];
      const isAriaElement = (elem) => {
        const name2 = name$3(elem);
        return contains$2(ariaElements, name2);
      };
      const markValid = (component, invalidConfig) => {
        const elem = invalidConfig.getRoot(component).getOr(component.element);
        remove$3(elem, invalidConfig.invalidClass);
        invalidConfig.notify.each((notifyInfo) => {
          if (isAriaElement(component.element)) {
            set$9(component.element, "aria-invalid", false);
          }
          notifyInfo.getContainer(component).each((container) => {
            set$8(container, notifyInfo.validHtml);
          });
          notifyInfo.onValid(component);
        });
      };
      const markInvalid = (component, invalidConfig, invalidState, text2) => {
        const elem = invalidConfig.getRoot(component).getOr(component.element);
        add$2(elem, invalidConfig.invalidClass);
        invalidConfig.notify.each((notifyInfo) => {
          if (isAriaElement(component.element)) {
            set$9(component.element, "aria-invalid", true);
          }
          notifyInfo.getContainer(component).each((container) => {
            set$8(container, text2);
          });
          notifyInfo.onInvalid(component, text2);
        });
      };
      const query = (component, invalidConfig, _invalidState) => invalidConfig.validator.fold(() => Future.pure(Result.value(true)), (validatorInfo) => validatorInfo.validate(component));
      const run = (component, invalidConfig, invalidState) => {
        invalidConfig.notify.each((notifyInfo) => {
          notifyInfo.onValidate(component);
        });
        return query(component, invalidConfig).map((valid) => {
          if (component.getSystem().isConnected()) {
            return valid.fold((err) => {
              markInvalid(component, invalidConfig, invalidState, err);
              return Result.error(err);
            }, (v) => {
              markValid(component, invalidConfig);
              return Result.value(v);
            });
          } else {
            return Result.error("No longer in system");
          }
        });
      };
      const isInvalid = (component, invalidConfig) => {
        const elem = invalidConfig.getRoot(component).getOr(component.element);
        return has(elem, invalidConfig.invalidClass);
      };
      var InvalidateApis = Object.freeze({
        __proto__: null,
        markValid,
        markInvalid,
        query,
        run,
        isInvalid
      });
      const events$a = (invalidConfig, invalidState) => invalidConfig.validator.map((validatorInfo) => derive$2([
        run$1(validatorInfo.onEvent, (component) => {
          run(component, invalidConfig, invalidState).get(identity);
        })
      ].concat(validatorInfo.validateOnLoad ? [
        runOnAttached((component) => {
          run(component, invalidConfig, invalidState).get(noop);
        })
      ] : []))).getOr({});
      var ActiveInvalidate = Object.freeze({
        __proto__: null,
        events: events$a
      });
      var InvalidateSchema = [
        required$1("invalidClass"),
        defaulted("getRoot", Optional.none),
        // TODO: Completely rework the notify API
        optionObjOf("notify", [
          defaulted("aria", "alert"),
          // Maybe we should use something else.
          defaulted("getContainer", Optional.none),
          defaulted("validHtml", ""),
          onHandler("onValid"),
          onHandler("onInvalid"),
          onHandler("onValidate")
        ]),
        optionObjOf("validator", [
          required$1("validate"),
          defaulted("onEvent", "input"),
          defaulted("validateOnLoad", true)
        ])
      ];
      const onLoad$4 = (component, repConfig, repState) => {
        repConfig.store.manager.onLoad(component, repConfig, repState);
      };
      const onUnload$2 = (component, repConfig, repState) => {
        repConfig.store.manager.onUnload(component, repConfig, repState);
      };
      const setValue$3 = (component, repConfig, repState, data) => {
        repConfig.store.manager.setValue(component, repConfig, repState, data);
      };
      const getValue$3 = (component, repConfig, repState) => repConfig.store.manager.getValue(component, repConfig, repState);
      const getState$2 = (component, repConfig, repState) => repState;
      var RepresentApis = Object.freeze({
        __proto__: null,
        onLoad: onLoad$4,
        onUnload: onUnload$2,
        setValue: setValue$3,
        getValue: getValue$3,
        getState: getState$2
      });
      const events$9 = (repConfig, repState) => {
        const es = repConfig.resetOnDom ? [
          runOnAttached((comp, _se) => {
            onLoad$4(comp, repConfig, repState);
          }),
          runOnDetached((comp, _se) => {
            onUnload$2(comp, repConfig, repState);
          })
        ] : [
          loadEvent(repConfig, repState, onLoad$4)
        ];
        return derive$2(es);
      };
      var ActiveRepresenting = Object.freeze({
        __proto__: null,
        events: events$9
      });
      const memory$1 = () => {
        const data = Cell(null);
        const readState = () => ({
          mode: "memory",
          value: data.get()
        });
        const isNotSet = () => data.get() === null;
        const clear2 = () => {
          data.set(null);
        };
        return nu$4({
          set: data.set,
          get: data.get,
          isNotSet,
          clear: clear2,
          readState
        });
      };
      const manual = () => {
        const readState = noop;
        return nu$4({
          readState
        });
      };
      const dataset = () => {
        const dataByValue = Cell({});
        const dataByText = Cell({});
        const readState = () => ({
          mode: "dataset",
          dataByValue: dataByValue.get(),
          dataByText: dataByText.get()
        });
        const clear2 = () => {
          dataByValue.set({});
          dataByText.set({});
        };
        const lookup2 = (itemString) => get$h(dataByValue.get(), itemString).orThunk(() => get$h(dataByText.get(), itemString));
        const update = (items) => {
          const currentDataByValue = dataByValue.get();
          const currentDataByText = dataByText.get();
          const newDataByValue = {};
          const newDataByText = {};
          each$1(items, (item2) => {
            newDataByValue[item2.value] = item2;
            get$h(item2, "meta").each((meta) => {
              get$h(meta, "text").each((text2) => {
                newDataByText[text2] = item2;
              });
            });
          });
          dataByValue.set({
            ...currentDataByValue,
            ...newDataByValue
          });
          dataByText.set({
            ...currentDataByText,
            ...newDataByText
          });
        };
        return nu$4({
          readState,
          lookup: lookup2,
          update,
          clear: clear2
        });
      };
      const init$9 = (spec) => spec.store.manager.state(spec);
      var RepresentState = Object.freeze({
        __proto__: null,
        memory: memory$1,
        dataset,
        manual,
        init: init$9
      });
      const setValue$2 = (component, repConfig, repState, data) => {
        const store2 = repConfig.store;
        repState.update([data]);
        store2.setValue(component, data);
        repConfig.onSetValue(component, data);
      };
      const getValue$2 = (component, repConfig, repState) => {
        const store2 = repConfig.store;
        const key = store2.getDataKey(component);
        return repState.lookup(key).getOrThunk(() => store2.getFallbackEntry(key));
      };
      const onLoad$3 = (component, repConfig, repState) => {
        const store2 = repConfig.store;
        store2.initialValue.each((data) => {
          setValue$2(component, repConfig, repState, data);
        });
      };
      const onUnload$1 = (component, repConfig, repState) => {
        repState.clear();
      };
      var DatasetStore = [
        option$3("initialValue"),
        required$1("getFallbackEntry"),
        required$1("getDataKey"),
        required$1("setValue"),
        output$1("manager", {
          setValue: setValue$2,
          getValue: getValue$2,
          onLoad: onLoad$3,
          onUnload: onUnload$1,
          state: dataset
        })
      ];
      const getValue$1 = (component, repConfig, _repState) => repConfig.store.getValue(component);
      const setValue$1 = (component, repConfig, _repState, data) => {
        repConfig.store.setValue(component, data);
        repConfig.onSetValue(component, data);
      };
      const onLoad$2 = (component, repConfig, _repState) => {
        repConfig.store.initialValue.each((data) => {
          repConfig.store.setValue(component, data);
        });
      };
      var ManualStore = [
        required$1("getValue"),
        defaulted("setValue", noop),
        option$3("initialValue"),
        output$1("manager", {
          setValue: setValue$1,
          getValue: getValue$1,
          onLoad: onLoad$2,
          onUnload: noop,
          state: NoState.init
        })
      ];
      const setValue = (component, repConfig, repState, data) => {
        repState.set(data);
        repConfig.onSetValue(component, data);
      };
      const getValue = (component, repConfig, repState) => repState.get();
      const onLoad$1 = (component, repConfig, repState) => {
        repConfig.store.initialValue.each((initVal) => {
          if (repState.isNotSet()) {
            repState.set(initVal);
          }
        });
      };
      const onUnload = (component, repConfig, repState) => {
        repState.clear();
      };
      var MemoryStore = [
        option$3("initialValue"),
        output$1("manager", {
          setValue,
          getValue,
          onLoad: onLoad$1,
          onUnload,
          state: memory$1
        })
      ];
      var RepresentSchema = [
        defaultedOf("store", { mode: "memory" }, choose$1("mode", {
          memory: MemoryStore,
          manual: ManualStore,
          dataset: DatasetStore
        })),
        onHandler("onSetValue"),
        defaulted("resetOnDom", false)
      ];
      const Representing = create$3({
        fields: RepresentSchema,
        name: "representing",
        active: ActiveRepresenting,
        apis: RepresentApis,
        extra: {
          setValueFrom: (component, source) => {
            const value2 = Representing.getValue(source);
            Representing.setValue(component, value2);
          }
        },
        state: RepresentState
      });
      const Invalidating = create$3({
        fields: InvalidateSchema,
        name: "invalidating",
        active: ActiveInvalidate,
        apis: InvalidateApis,
        extra: {
          // Note, this requires representing to be on the validatee
          validation: (validator) => {
            return (component) => {
              const v = Representing.getValue(component);
              return Future.pure(validator(v));
            };
          }
        }
      });
      const exhibit$4 = (base2, posConfig) => nu$2({
        classes: [],
        styles: posConfig.useFixed() ? {} : { position: "relative" }
      });
      var ActivePosition = Object.freeze({
        __proto__: null,
        exhibit: exhibit$4
      });
      const adt$3 = Adt.generate([
        { none: [] },
        { relative: ["x", "y", "width", "height"] },
        { fixed: ["x", "y", "width", "height"] }
      ]);
      const positionWithDirection = (posName, decision, x, y, width2, height2) => {
        const decisionRect = decision.rect;
        const decisionX = decisionRect.x - x;
        const decisionY = decisionRect.y - y;
        const decisionWidth = decisionRect.width;
        const decisionHeight = decisionRect.height;
        const decisionRight = width2 - (decisionX + decisionWidth);
        const decisionBottom = height2 - (decisionY + decisionHeight);
        const left2 = Optional.some(decisionX);
        const top2 = Optional.some(decisionY);
        const right2 = Optional.some(decisionRight);
        const bottom2 = Optional.some(decisionBottom);
        const none = Optional.none();
        return cata$1(
          decision.direction,
          () => NuPositionCss(posName, left2, top2, none, none),
          // southeast
          () => NuPositionCss(posName, none, top2, right2, none),
          // southwest
          () => NuPositionCss(posName, left2, none, none, bottom2),
          // northeast
          () => NuPositionCss(posName, none, none, right2, bottom2),
          // northwest
          () => NuPositionCss(posName, left2, top2, none, none),
          // south
          () => NuPositionCss(posName, left2, none, none, bottom2),
          // north
          () => NuPositionCss(posName, left2, top2, none, none),
          // east
          () => NuPositionCss(posName, none, top2, right2, none)
          // west
        );
      };
      const reposition = (origin, decision) => origin.fold(() => {
        const decisionRect = decision.rect;
        return NuPositionCss("absolute", Optional.some(decisionRect.x), Optional.some(decisionRect.y), Optional.none(), Optional.none());
      }, (x, y, width2, height2) => {
        return positionWithDirection("absolute", decision, x, y, width2, height2);
      }, (x, y, width2, height2) => {
        return positionWithDirection("fixed", decision, x, y, width2, height2);
      });
      const toBox = (origin, element2) => {
        const rel = curry(find$2, element2);
        const position2 = origin.fold(rel, rel, () => {
          const scroll = get$b();
          return find$2(element2).translate(-scroll.left, -scroll.top);
        });
        const width2 = getOuter(element2);
        const height2 = getOuter$1(element2);
        return bounds(position2.left, position2.top, width2, height2);
      };
      const viewport = (origin, optBounds) => optBounds.fold(
        /* There are no bounds supplied */
        () => origin.fold(win, win, bounds),
        (bounds$12) => (
          /* Use any bounds supplied or remove the scroll position of the bounds for fixed. */
          origin.fold(constant$1(bounds$12), constant$1(bounds$12), () => {
            const pos = translate$1(origin, bounds$12.x, bounds$12.y);
            return bounds(pos.left, pos.top, bounds$12.width, bounds$12.height);
          })
        )
      );
      const translate$1 = (origin, x, y) => {
        const pos = SugarPosition(x, y);
        const removeScroll = () => {
          const outerScroll = get$b();
          return pos.translate(-outerScroll.left, -outerScroll.top);
        };
        return origin.fold(constant$1(pos), constant$1(pos), removeScroll);
      };
      const cata = (subject, onNone, onRelative, onFixed) => subject.fold(onNone, onRelative, onFixed);
      adt$3.none;
      const relative = adt$3.relative;
      const fixed = adt$3.fixed;
      const anchor = (anchorBox, origin) => ({
        anchorBox,
        origin
      });
      const box = (anchorBox, origin) => anchor(anchorBox, origin);
      const adt$2 = Adt.generate([
        { fit: ["reposition"] },
        { nofit: ["reposition", "visibleW", "visibleH", "isVisible"] }
      ]);
      const determinePosition = (box2, bounds2) => {
        const { x: boundsX, y: boundsY, right: boundsRight, bottom: boundsBottom } = bounds2;
        const { x, y, right: right2, bottom: bottom2, width: width2, height: height2 } = box2;
        const xInBounds = x >= boundsX && x <= boundsRight;
        const yInBounds = y >= boundsY && y <= boundsBottom;
        const originInBounds = xInBounds && yInBounds;
        const rightInBounds = right2 <= boundsRight && right2 >= boundsX;
        const bottomInBounds = bottom2 <= boundsBottom && bottom2 >= boundsY;
        const sizeInBounds = rightInBounds && bottomInBounds;
        const visibleW = Math.min(width2, x >= boundsX ? boundsRight - x : right2 - boundsX);
        const visibleH = Math.min(height2, y >= boundsY ? boundsBottom - y : bottom2 - boundsY);
        return {
          originInBounds,
          sizeInBounds,
          visibleW,
          visibleH
        };
      };
      const calcReposition = (box2, bounds$12) => {
        const { x: boundsX, y: boundsY, right: boundsRight, bottom: boundsBottom } = bounds$12;
        const { x, y, width: width2, height: height2 } = box2;
        const maxX2 = Math.max(boundsX, boundsRight - width2);
        const maxY2 = Math.max(boundsY, boundsBottom - height2);
        const restrictedX = clamp(x, boundsX, maxX2);
        const restrictedY = clamp(y, boundsY, maxY2);
        const restrictedWidth = Math.min(restrictedX + width2, boundsRight) - restrictedX;
        const restrictedHeight = Math.min(restrictedY + height2, boundsBottom) - restrictedY;
        return bounds(restrictedX, restrictedY, restrictedWidth, restrictedHeight);
      };
      const calcMaxSizes = (direction, box2, bounds2) => {
        const upAvailable = constant$1(box2.bottom - bounds2.y);
        const downAvailable = constant$1(bounds2.bottom - box2.y);
        const maxHeight = cataVertical(
          direction,
          downAvailable,
          /* middle */
          downAvailable,
          upAvailable
        );
        const westAvailable = constant$1(box2.right - bounds2.x);
        const eastAvailable = constant$1(bounds2.right - box2.x);
        const maxWidth = cataHorizontal(
          direction,
          eastAvailable,
          /* middle */
          eastAvailable,
          westAvailable
        );
        return {
          maxWidth,
          maxHeight
        };
      };
      const attempt = (candidate, width2, height2, bounds$12) => {
        const bubble = candidate.bubble;
        const bubbleOffset = bubble.offset;
        const adjustedBounds = adjustBounds(bounds$12, candidate.restriction, bubbleOffset);
        const newX = candidate.x + bubbleOffset.left;
        const newY = candidate.y + bubbleOffset.top;
        const box2 = bounds(newX, newY, width2, height2);
        const { originInBounds, sizeInBounds, visibleW, visibleH } = determinePosition(box2, adjustedBounds);
        const fits = originInBounds && sizeInBounds;
        const fittedBox = fits ? box2 : calcReposition(box2, adjustedBounds);
        const isPartlyVisible = fittedBox.width > 0 && fittedBox.height > 0;
        const { maxWidth, maxHeight } = calcMaxSizes(candidate.direction, fittedBox, bounds$12);
        const reposition2 = {
          rect: fittedBox,
          maxHeight,
          maxWidth,
          direction: candidate.direction,
          placement: candidate.placement,
          classes: {
            on: bubble.classesOn,
            off: bubble.classesOff
          },
          layout: candidate.label,
          testY: newY
        };
        return fits || candidate.alwaysFit ? adt$2.fit(reposition2) : adt$2.nofit(reposition2, visibleW, visibleH, isPartlyVisible);
      };
      const attempts = (element2, candidates, anchorBox, elementBox, bubbles, bounds2) => {
        const panelWidth = elementBox.width;
        const panelHeight = elementBox.height;
        const attemptBestFit = (layout2, reposition2, visibleW, visibleH, isVisible2) => {
          const next = layout2(anchorBox, elementBox, bubbles, element2, bounds2);
          const attemptLayout = attempt(next, panelWidth, panelHeight, bounds2);
          return attemptLayout.fold(constant$1(attemptLayout), (newReposition, newVisibleW, newVisibleH, newIsVisible) => {
            const improved = isVisible2 === newIsVisible ? newVisibleH > visibleH || newVisibleW > visibleW : !isVisible2 && newIsVisible;
            return improved ? attemptLayout : adt$2.nofit(reposition2, visibleW, visibleH, isVisible2);
          });
        };
        const abc = foldl(
          candidates,
          (b2, a) => {
            const bestNext = curry(attemptBestFit, a);
            return b2.fold(constant$1(b2), bestNext);
          },
          // fold base case: No candidates, it's never going to be correct, so do whatever
          adt$2.nofit({
            rect: anchorBox,
            maxHeight: elementBox.height,
            maxWidth: elementBox.width,
            direction: southeast$3(),
            placement: "southeast",
            classes: {
              on: [],
              off: []
            },
            layout: "none",
            testY: anchorBox.y
          }, -1, -1, false)
        );
        return abc.fold(identity, identity);
      };
      const properties = ["top", "bottom", "right", "left"];
      const timerAttr = "data-alloy-transition-timer";
      const isTransitioning$1 = (element2, transition) => hasAll(element2, transition.classes);
      const shouldApplyTransitionCss = (transition, decision, lastPlacement) => {
        return lastPlacement.exists((placer) => {
          const mode = transition.mode;
          return mode === "all" ? true : placer[mode] !== decision[mode];
        });
      };
      const hasChanges = (position2, intermediate) => {
        const round2 = (value2) => parseFloat(value2).toFixed(3);
        return find$4(intermediate, (value2, key) => {
          const newValue = position2[key].map(round2);
          const val = value2.map(round2);
          return !equals(newValue, val);
        }).isSome();
      };
      const getTransitionDuration = (element2) => {
        const get2 = (name2) => {
          const style = get$e(element2, name2);
          const times = style.split(/\s*,\s*/);
          return filter$2(times, isNotEmpty);
        };
        const parse2 = (value2) => {
          if (isString(value2) && /^[\d.]+/.test(value2)) {
            const num = parseFloat(value2);
            return endsWith(value2, "ms") ? num : num * 1e3;
          } else {
            return 0;
          }
        };
        const delay = get2("transition-delay");
        const duration = get2("transition-duration");
        return foldl(duration, (acc, dur, i) => {
          const time = parse2(delay[i]) + parse2(dur);
          return Math.max(acc, time);
        }, 0);
      };
      const setupTransitionListeners = (element2, transition) => {
        const transitionEnd = unbindable();
        const transitionCancel = unbindable();
        let timer;
        const isSourceTransition = (e) => {
          var _a;
          const pseudoElement = (_a = e.raw.pseudoElement) !== null && _a !== void 0 ? _a : "";
          return eq(e.target, element2) && isEmpty(pseudoElement) && contains$2(properties, e.raw.propertyName);
        };
        const transitionDone = (e) => {
          if (isNullable(e) || isSourceTransition(e)) {
            transitionEnd.clear();
            transitionCancel.clear();
            const type2 = e === null || e === void 0 ? void 0 : e.raw.type;
            if (isNullable(type2) || type2 === transitionend()) {
              clearTimeout(timer);
              remove$8(element2, timerAttr);
              remove$2(element2, transition.classes);
            }
          }
        };
        const transitionStart = bind$1(element2, transitionstart(), (e) => {
          if (isSourceTransition(e)) {
            transitionStart.unbind();
            transitionEnd.set(bind$1(element2, transitionend(), transitionDone));
            transitionCancel.set(bind$1(element2, transitioncancel(), transitionDone));
          }
        });
        const duration = getTransitionDuration(element2);
        requestAnimationFrame(() => {
          timer = setTimeout(transitionDone, duration + 17);
          set$9(element2, timerAttr, timer);
        });
      };
      const startTransitioning = (element2, transition) => {
        add$1(element2, transition.classes);
        getOpt(element2, timerAttr).each((timerId) => {
          clearTimeout(parseInt(timerId, 10));
          remove$8(element2, timerAttr);
        });
        setupTransitionListeners(element2, transition);
      };
      const applyTransitionCss = (element2, origin, position2, transition, decision, lastPlacement) => {
        const shouldTransition = shouldApplyTransitionCss(transition, decision, lastPlacement);
        if (shouldTransition || isTransitioning$1(element2, transition)) {
          set$7(element2, "position", position2.position);
          const rect2 = toBox(origin, element2);
          const intermediatePosition = reposition(origin, { ...decision, rect: rect2 });
          const intermediateCssOptions = mapToObject(properties, (prop) => intermediatePosition[prop]);
          if (hasChanges(position2, intermediateCssOptions)) {
            setOptions(element2, intermediateCssOptions);
            if (shouldTransition) {
              startTransitioning(element2, transition);
            }
            reflow(element2);
          }
        } else {
          remove$2(element2, transition.classes);
        }
      };
      const elementSize = (p) => ({
        width: Math.ceil(getOuterExact(p)),
        height: getOuter$1(p)
      });
      const layout = (anchorBox, element2, bubbles, options) => {
        remove$6(element2, "max-height");
        remove$6(element2, "max-width");
        const elementBox = elementSize(element2);
        return attempts(element2, options.preference, anchorBox, elementBox, bubbles, options.bounds);
      };
      const setClasses = (element2, decision) => {
        const classInfo = decision.classes;
        remove$2(element2, classInfo.off);
        add$1(element2, classInfo.on);
      };
      const setHeight = (element2, decision, options) => {
        const maxHeightFunction = options.maxHeightFunction;
        maxHeightFunction(element2, decision.maxHeight);
      };
      const setWidth = (element2, decision, options) => {
        const maxWidthFunction = options.maxWidthFunction;
        maxWidthFunction(element2, decision.maxWidth);
      };
      const position$2 = (element2, decision, options) => {
        const positionCss = reposition(options.origin, decision);
        options.transition.each((transition) => {
          applyTransitionCss(element2, options.origin, positionCss, transition, decision, options.lastPlacement);
        });
        applyPositionCss(element2, positionCss);
      };
      const setPlacement = (element2, decision) => {
        setPlacement$1(element2, decision.placement);
      };
      const defaultOr = (options, key, dephault) => options[key] === void 0 ? dephault : options[key];
      const simple = (anchor2, element2, bubble, layouts2, lastPlacement, optBounds, overrideOptions, transition) => {
        const maxHeightFunction = defaultOr(overrideOptions, "maxHeightFunction", anchored());
        const maxWidthFunction = defaultOr(overrideOptions, "maxWidthFunction", noop);
        const anchorBox = anchor2.anchorBox;
        const origin = anchor2.origin;
        const options = {
          bounds: viewport(origin, optBounds),
          origin,
          preference: layouts2,
          maxHeightFunction,
          maxWidthFunction,
          lastPlacement,
          transition
        };
        return go(anchorBox, element2, bubble, options);
      };
      const go = (anchorBox, element2, bubble, options) => {
        const decision = layout(anchorBox, element2, bubble, options);
        position$2(element2, decision, options);
        setPlacement(element2, decision);
        setClasses(element2, decision);
        setHeight(element2, decision, options);
        setWidth(element2, decision, options);
        return {
          layout: decision.layout,
          placement: decision.placement
        };
      };
      const nu$1 = identity;
      const schema$o = () => optionObjOf("layouts", [
        required$1("onLtr"),
        required$1("onRtl"),
        option$3("onBottomLtr"),
        option$3("onBottomRtl")
      ]);
      const get$1 = (elem, info, defaultLtr, defaultRtl, defaultBottomLtr, defaultBottomRtl, dirElement) => {
        const isBottomToTop = dirElement.map(isBottomToTopDir).getOr(false);
        const customLtr = info.layouts.map((ls) => ls.onLtr(elem));
        const customRtl = info.layouts.map((ls) => ls.onRtl(elem));
        const ltr = isBottomToTop ? info.layouts.bind((ls) => ls.onBottomLtr.map((f3) => f3(elem))).or(customLtr).getOr(defaultBottomLtr) : customLtr.getOr(defaultLtr);
        const rtl = isBottomToTop ? info.layouts.bind((ls) => ls.onBottomRtl.map((f3) => f3(elem))).or(customRtl).getOr(defaultBottomRtl) : customRtl.getOr(defaultRtl);
        const f2 = onDirection(ltr, rtl);
        return f2(elem);
      };
      const placement$4 = (component, anchorInfo, origin) => {
        const hotspot = anchorInfo.hotspot;
        const anchorBox = toBox(origin, hotspot.element);
        const layouts2 = get$1(component.element, anchorInfo, belowOrAbove(), belowOrAboveRtl(), aboveOrBelow(), aboveOrBelowRtl(), Optional.some(anchorInfo.hotspot.element));
        return Optional.some(nu$1({
          anchorBox,
          bubble: anchorInfo.bubble.getOr(fallback()),
          overrides: anchorInfo.overrides,
          layouts: layouts2
        }));
      };
      var HotspotAnchor = [
        required$1("hotspot"),
        option$3("bubble"),
        defaulted("overrides", {}),
        schema$o(),
        output$1("placement", placement$4)
      ];
      const placement$3 = (component, anchorInfo, origin) => {
        const pos = translate$1(origin, anchorInfo.x, anchorInfo.y);
        const anchorBox = bounds(pos.left, pos.top, anchorInfo.width, anchorInfo.height);
        const layouts2 = get$1(
          component.element,
          anchorInfo,
          all$2(),
          allRtl$1(),
          // No default bottomToTop layouts currently needed
          all$2(),
          allRtl$1(),
          Optional.none()
        );
        return Optional.some(nu$1({
          anchorBox,
          bubble: anchorInfo.bubble,
          overrides: anchorInfo.overrides,
          layouts: layouts2
        }));
      };
      var MakeshiftAnchor = [
        required$1("x"),
        required$1("y"),
        defaulted("height", 0),
        defaulted("width", 0),
        defaulted("bubble", fallback()),
        defaulted("overrides", {}),
        schema$o(),
        output$1("placement", placement$3)
      ];
      const adt$1 = Adt.generate([
        { screen: ["point"] },
        { absolute: ["point", "scrollLeft", "scrollTop"] }
      ]);
      const toFixed = (pos) => (
        // TODO: Use new ADT methods
        pos.fold(identity, (point2, scrollLeft, scrollTop) => point2.translate(-scrollLeft, -scrollTop))
      );
      const toAbsolute = (pos) => pos.fold(identity, identity);
      const sum = (points) => foldl(points, (b2, a) => b2.translate(a.left, a.top), SugarPosition(0, 0));
      const sumAsFixed = (positions) => {
        const points = map$2(positions, toFixed);
        return sum(points);
      };
      const sumAsAbsolute = (positions) => {
        const points = map$2(positions, toAbsolute);
        return sum(points);
      };
      const screen = adt$1.screen;
      const absolute = adt$1.absolute;
      const getOffset = (component, origin, anchorInfo) => {
        const win2 = defaultView(anchorInfo.root).dom;
        const hasSameOwner = (frame) => {
          const frameOwner = owner$4(frame);
          const compOwner = owner$4(component.element);
          return eq(frameOwner, compOwner);
        };
        return Optional.from(win2.frameElement).map(SugarElement.fromDom).filter(hasSameOwner).map(absolute$3);
      };
      const getRootPoint = (component, origin, anchorInfo) => {
        const doc = owner$4(component.element);
        const outerScroll = get$b(doc);
        const offset2 = getOffset(component, origin, anchorInfo).getOr(outerScroll);
        return absolute(offset2, outerScroll.left, outerScroll.top);
      };
      const getBox = (left2, top2, width2, height2) => {
        const point2 = screen(SugarPosition(left2, top2));
        return Optional.some(pointed(point2, width2, height2));
      };
      const calcNewAnchor = (optBox, rootPoint, anchorInfo, origin, elem) => optBox.map((box2) => {
        const points = [rootPoint, box2.point];
        const topLeft = cata(origin, () => sumAsAbsolute(points), () => sumAsAbsolute(points), () => sumAsFixed(points));
        const anchorBox = rect(topLeft.left, topLeft.top, box2.width, box2.height);
        const layoutsLtr = anchorInfo.showAbove ? aboveOrBelow() : belowOrAbove();
        const layoutsRtl = anchorInfo.showAbove ? aboveOrBelowRtl() : belowOrAboveRtl();
        const layouts2 = get$1(elem, anchorInfo, layoutsLtr, layoutsRtl, layoutsLtr, layoutsRtl, Optional.none());
        return nu$1({
          anchorBox,
          bubble: anchorInfo.bubble.getOr(fallback()),
          overrides: anchorInfo.overrides,
          layouts: layouts2
        });
      });
      const placement$2 = (component, anchorInfo, origin) => {
        const rootPoint = getRootPoint(component, origin, anchorInfo);
        return anchorInfo.node.filter(inBody).bind((target) => {
          const rect2 = target.dom.getBoundingClientRect();
          const nodeBox = getBox(rect2.left, rect2.top, rect2.width, rect2.height);
          const elem = anchorInfo.node.getOr(component.element);
          return calcNewAnchor(nodeBox, rootPoint, anchorInfo, origin, elem);
        });
      };
      var NodeAnchor = [
        required$1("node"),
        required$1("root"),
        option$3("bubble"),
        schema$o(),
        // chiefly MaxHeight.expandable()
        defaulted("overrides", {}),
        defaulted("showAbove", false),
        output$1("placement", placement$2)
      ];
      const point = (element2, offset2) => ({
        element: element2,
        offset: offset2
      });
      const descendOnce$1 = (element2, offset2) => {
        const children$1 = children(element2);
        if (children$1.length === 0) {
          return point(element2, offset2);
        } else if (offset2 < children$1.length) {
          return point(children$1[offset2], 0);
        } else {
          const last2 = children$1[children$1.length - 1];
          const len = isText(last2) ? get$a(last2).length : children(last2).length;
          return point(last2, len);
        }
      };
      const descendOnce = (element2, offset2) => isText(element2) ? point(element2, offset2) : descendOnce$1(element2, offset2);
      const isSimRange = (detail) => detail.foffset !== void 0;
      const getAnchorSelection = (win2, anchorInfo) => {
        const getSelection = anchorInfo.getSelection.getOrThunk(() => () => getExact(win2));
        return getSelection().map((sel) => {
          if (isSimRange(sel)) {
            const modStart = descendOnce(sel.start, sel.soffset);
            const modFinish = descendOnce(sel.finish, sel.foffset);
            return SimSelection.range(modStart.element, modStart.offset, modFinish.element, modFinish.offset);
          } else {
            return sel;
          }
        });
      };
      const placement$1 = (component, anchorInfo, origin) => {
        const win2 = defaultView(anchorInfo.root).dom;
        const rootPoint = getRootPoint(component, origin, anchorInfo);
        const selectionBox = getAnchorSelection(win2, anchorInfo).bind((sel) => {
          if (isSimRange(sel)) {
            const optRect = getBounds$2(win2, SimSelection.exactFromRange(sel)).orThunk(() => {
              const zeroWidth$1 = SugarElement.fromText(zeroWidth);
              before$1(sel.start, zeroWidth$1);
              const rect2 = getFirstRect(win2, SimSelection.exact(zeroWidth$1, 0, zeroWidth$1, 1));
              remove$7(zeroWidth$1);
              return rect2;
            });
            return optRect.bind((rawRect) => {
              return getBox(rawRect.left, rawRect.top, rawRect.width, rawRect.height);
            });
          } else {
            const selectionRect = map$1(sel, (cell) => cell.dom.getBoundingClientRect());
            const bounds2 = {
              left: Math.min(selectionRect.firstCell.left, selectionRect.lastCell.left),
              right: Math.max(selectionRect.firstCell.right, selectionRect.lastCell.right),
              top: Math.min(selectionRect.firstCell.top, selectionRect.lastCell.top),
              bottom: Math.max(selectionRect.firstCell.bottom, selectionRect.lastCell.bottom)
            };
            return getBox(bounds2.left, bounds2.top, bounds2.right - bounds2.left, bounds2.bottom - bounds2.top);
          }
        });
        const targetElement = getAnchorSelection(win2, anchorInfo).bind((sel) => {
          if (isSimRange(sel)) {
            return isElement$1(sel.start) ? Optional.some(sel.start) : parentElement(sel.start);
          } else {
            return Optional.some(sel.firstCell);
          }
        });
        const elem = targetElement.getOr(component.element);
        return calcNewAnchor(selectionBox, rootPoint, anchorInfo, origin, elem);
      };
      var SelectionAnchor = [
        option$3("getSelection"),
        required$1("root"),
        option$3("bubble"),
        schema$o(),
        defaulted("overrides", {}),
        defaulted("showAbove", false),
        output$1("placement", placement$1)
      ];
      const labelPrefix = "link-layout";
      const eastX = (anchor2) => anchor2.x + anchor2.width;
      const westX = (anchor2, element2) => anchor2.x - element2.width;
      const northY = (anchor2, element2) => anchor2.y - element2.height + anchor2.height;
      const southY = (anchor2) => anchor2.y;
      const southeast = (anchor2, element2, bubbles) => nu$5(eastX(anchor2), southY(anchor2), bubbles.southeast(), southeast$3(), "southeast", boundsRestriction(anchor2, {
        left: 0,
        top: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix);
      const southwest = (anchor2, element2, bubbles) => nu$5(westX(anchor2, element2), southY(anchor2), bubbles.southwest(), southwest$3(), "southwest", boundsRestriction(anchor2, {
        right: 1,
        top: 2
        /* AnchorBoxBounds.TopEdge */
      }), labelPrefix);
      const northeast = (anchor2, element2, bubbles) => nu$5(eastX(anchor2), northY(anchor2, element2), bubbles.northeast(), northeast$3(), "northeast", boundsRestriction(anchor2, {
        left: 0,
        bottom: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix);
      const northwest = (anchor2, element2, bubbles) => nu$5(westX(anchor2, element2), northY(anchor2, element2), bubbles.northwest(), northwest$3(), "northwest", boundsRestriction(anchor2, {
        right: 1,
        bottom: 3
        /* AnchorBoxBounds.BottomEdge */
      }), labelPrefix);
      const all = () => [southeast, southwest, northeast, northwest];
      const allRtl = () => [southwest, southeast, northwest, northeast];
      const placement = (component, submenuInfo, origin) => {
        const anchorBox = toBox(origin, submenuInfo.item.element);
        const layouts2 = get$1(
          component.element,
          submenuInfo,
          all(),
          allRtl(),
          // No default bottomToTop layouts currently needed
          all(),
          allRtl(),
          Optional.none()
        );
        return Optional.some(nu$1({
          anchorBox,
          bubble: fallback(),
          overrides: submenuInfo.overrides,
          layouts: layouts2
        }));
      };
      var SubmenuAnchor = [
        required$1("item"),
        schema$o(),
        defaulted("overrides", {}),
        output$1("placement", placement)
      ];
      var AnchorSchema = choose$1("type", {
        selection: SelectionAnchor,
        node: NodeAnchor,
        hotspot: HotspotAnchor,
        submenu: SubmenuAnchor,
        makeshift: MakeshiftAnchor
      });
      const TransitionSchema = [
        requiredArrayOf("classes", string),
        defaultedStringEnum("mode", "all", ["all", "layout", "placement"])
      ];
      const PositionSchema = [
        defaulted("useFixed", never),
        option$3("getBounds")
      ];
      const PlacementSchema = [
        requiredOf("anchor", AnchorSchema),
        optionObjOf("transition", TransitionSchema)
      ];
      const getFixedOrigin = () => {
        const html2 = document.documentElement;
        return fixed(0, 0, html2.clientWidth, html2.clientHeight);
      };
      const getRelativeOrigin = (component) => {
        const position2 = absolute$3(component.element);
        const bounds2 = component.element.dom.getBoundingClientRect();
        return relative(position2.left, position2.top, bounds2.width, bounds2.height);
      };
      const place = (origin, anchoring, optBounds, placee, lastPlace, transition) => {
        const anchor2 = box(anchoring.anchorBox, origin);
        return simple(anchor2, placee.element, anchoring.bubble, anchoring.layouts, lastPlace, optBounds, anchoring.overrides, transition);
      };
      const position$1 = (component, posConfig, posState, placee, placementSpec) => {
        const optWithinBounds = Optional.none();
        positionWithinBounds(component, posConfig, posState, placee, placementSpec, optWithinBounds);
      };
      const positionWithinBounds = (component, posConfig, posState, placee, placementSpec, optWithinBounds) => {
        const placeeDetail = asRawOrDie$1("placement.info", objOf(PlacementSchema), placementSpec);
        const anchorage = placeeDetail.anchor;
        const element2 = placee.element;
        const placeeState = posState.get(placee.uid);
        preserve(() => {
          set$7(element2, "position", "fixed");
          const oldVisibility = getRaw(element2, "visibility");
          set$7(element2, "visibility", "hidden");
          const origin = posConfig.useFixed() ? getFixedOrigin() : getRelativeOrigin(component);
          anchorage.placement(component, anchorage, origin).each((anchoring) => {
            const optBounds = optWithinBounds.orThunk(() => posConfig.getBounds.map(apply$1));
            const newState = place(origin, anchoring, optBounds, placee, placeeState, placeeDetail.transition);
            posState.set(placee.uid, newState);
          });
          oldVisibility.fold(() => {
            remove$6(element2, "visibility");
          }, (vis) => {
            set$7(element2, "visibility", vis);
          });
          if (getRaw(element2, "left").isNone() && getRaw(element2, "top").isNone() && getRaw(element2, "right").isNone() && getRaw(element2, "bottom").isNone() && is$1(getRaw(element2, "position"), "fixed")) {
            remove$6(element2, "position");
          }
        }, element2);
      };
      const getMode = (component, pConfig, _pState) => pConfig.useFixed() ? "fixed" : "absolute";
      const reset = (component, pConfig, posState, placee) => {
        const element2 = placee.element;
        each$1(["position", "left", "right", "top", "bottom"], (prop) => remove$6(element2, prop));
        reset$2(element2);
        posState.clear(placee.uid);
      };
      var PositionApis = Object.freeze({
        __proto__: null,
        position: position$1,
        positionWithinBounds,
        getMode,
        reset
      });
      const init$8 = () => {
        let state = {};
        const set2 = (id, data) => {
          state[id] = data;
        };
        const get2 = (id) => get$h(state, id);
        const clear2 = (id) => {
          if (isNonNullable(id)) {
            delete state[id];
          } else {
            state = {};
          }
        };
        return nu$4({
          readState: () => state,
          clear: clear2,
          set: set2,
          get: get2
        });
      };
      var PositioningState = Object.freeze({
        __proto__: null,
        init: init$8
      });
      const Positioning = create$3({
        fields: PositionSchema,
        name: "positioning",
        active: ActivePosition,
        apis: PositionApis,
        state: PositioningState
      });
      const chooseChannels = (channels, message) => message.universal ? channels : filter$2(channels, (ch) => contains$2(message.channels, ch));
      const events$8 = (receiveConfig) => derive$2([
        run$1(receive(), (component, message) => {
          const channelMap = receiveConfig.channels;
          const channels = keys(channelMap);
          const receivingData = message;
          const targetChannels = chooseChannels(channels, receivingData);
          each$1(targetChannels, (ch) => {
            const channelInfo = channelMap[ch];
            const channelSchema = channelInfo.schema;
            const data = asRawOrDie$1("channel[" + ch + "] data\nReceiver: " + element(component.element), channelSchema, receivingData.data);
            channelInfo.onReceive(component, data);
          });
        })
      ]);
      var ActiveReceiving = Object.freeze({
        __proto__: null,
        events: events$8
      });
      var ReceivingSchema = [
        requiredOf("channels", setOf(
          // Allow any keys.
          Result.value,
          objOfOnly([
            onStrictHandler("onReceive"),
            defaulted("schema", anyValue())
          ])
        ))
      ];
      const Receiving = create$3({
        fields: ReceivingSchema,
        name: "receiving",
        active: ActiveReceiving
      });
      const events$7 = (reflectingConfig, reflectingState) => {
        const update = (component, data) => {
          reflectingConfig.updateState.each((updateState) => {
            const newState = updateState(component, data);
            reflectingState.set(newState);
          });
          reflectingConfig.renderComponents.each((renderComponents2) => {
            const newComponents = renderComponents2(data, reflectingState.get());
            const replacer = reflectingConfig.reuseDom ? withReuse : withoutReuse;
            replacer(component, newComponents);
          });
        };
        return derive$2([
          run$1(receive(), (component, message) => {
            const receivingData = message;
            if (!receivingData.universal) {
              const channel = reflectingConfig.channel;
              if (contains$2(receivingData.channels, channel)) {
                update(component, receivingData.data);
              }
            }
          }),
          runOnAttached((comp, _se) => {
            reflectingConfig.initialData.each((rawData) => {
              update(comp, rawData);
            });
          })
        ]);
      };
      var ActiveReflecting = Object.freeze({
        __proto__: null,
        events: events$7
      });
      const getState$1 = (component, replaceConfig, reflectState) => reflectState;
      var ReflectingApis = Object.freeze({
        __proto__: null,
        getState: getState$1
      });
      var ReflectingSchema = [
        required$1("channel"),
        option$3("renderComponents"),
        option$3("updateState"),
        option$3("initialData"),
        defaultedBoolean("reuseDom", true)
      ];
      const init$7 = () => {
        const cell = Cell(Optional.none());
        const clear2 = () => cell.set(Optional.none());
        const readState = () => cell.get().getOr("none");
        return {
          readState,
          get: cell.get,
          set: cell.set,
          clear: clear2
        };
      };
      var ReflectingState = Object.freeze({
        __proto__: null,
        init: init$7
      });
      const Reflecting = create$3({
        fields: ReflectingSchema,
        name: "reflecting",
        active: ActiveReflecting,
        apis: ReflectingApis,
        state: ReflectingState
      });
      const rebuild = (sandbox, sConfig, sState, data) => {
        sState.get().each((_data) => {
          detachChildren(sandbox);
        });
        const point2 = sConfig.getAttachPoint(sandbox);
        attach(point2, sandbox);
        const built = sandbox.getSystem().build(data);
        attach(sandbox, built);
        sState.set(built);
        return built;
      };
      const open$1 = (sandbox, sConfig, sState, data) => {
        const newState = rebuild(sandbox, sConfig, sState, data);
        sConfig.onOpen(sandbox, newState);
        return newState;
      };
      const setContent = (sandbox, sConfig, sState, data) => sState.get().map(() => rebuild(sandbox, sConfig, sState, data));
      const openWhileCloaked = (sandbox, sConfig, sState, data, transaction) => {
        cloak(sandbox, sConfig);
        open$1(sandbox, sConfig, sState, data);
        transaction();
        decloak(sandbox, sConfig);
      };
      const close$1 = (sandbox, sConfig, sState) => {
        sState.get().each((data) => {
          detachChildren(sandbox);
          detach(sandbox);
          sConfig.onClose(sandbox, data);
          sState.clear();
        });
      };
      const isOpen$1 = (_sandbox, _sConfig, sState) => sState.isOpen();
      const isPartOf$1 = (sandbox, sConfig, sState, queryElem) => isOpen$1(sandbox, sConfig, sState) && sState.get().exists((data) => sConfig.isPartOf(sandbox, data, queryElem));
      const getState = (_sandbox, _sConfig, sState) => sState.get();
      const store = (sandbox, cssKey, attr, newValue) => {
        getRaw(sandbox.element, cssKey).fold(() => {
          remove$8(sandbox.element, attr);
        }, (v) => {
          set$9(sandbox.element, attr, v);
        });
        set$7(sandbox.element, cssKey, newValue);
      };
      const restore = (sandbox, cssKey, attr) => {
        getOpt(sandbox.element, attr).fold(() => remove$6(sandbox.element, cssKey), (oldValue) => set$7(sandbox.element, cssKey, oldValue));
      };
      const cloak = (sandbox, sConfig, _sState) => {
        const sink = sConfig.getAttachPoint(sandbox);
        set$7(sandbox.element, "position", Positioning.getMode(sink));
        store(sandbox, "visibility", sConfig.cloakVisibilityAttr, "hidden");
      };
      const hasPosition = (element2) => exists(["top", "left", "right", "bottom"], (pos) => getRaw(element2, pos).isSome());
      const decloak = (sandbox, sConfig, _sState) => {
        if (!hasPosition(sandbox.element)) {
          remove$6(sandbox.element, "position");
        }
        restore(sandbox, "visibility", sConfig.cloakVisibilityAttr);
      };
      var SandboxApis = Object.freeze({
        __proto__: null,
        cloak,
        decloak,
        open: open$1,
        openWhileCloaked,
        close: close$1,
        isOpen: isOpen$1,
        isPartOf: isPartOf$1,
        getState,
        setContent
      });
      const events$6 = (sandboxConfig, sandboxState) => derive$2([
        run$1(sandboxClose(), (sandbox, _simulatedEvent) => {
          close$1(sandbox, sandboxConfig, sandboxState);
        })
      ]);
      var ActiveSandbox = Object.freeze({
        __proto__: null,
        events: events$6
      });
      var SandboxSchema = [
        onHandler("onOpen"),
        onHandler("onClose"),
        // Maybe this should be optional
        required$1("isPartOf"),
        required$1("getAttachPoint"),
        defaulted("cloakVisibilityAttr", "data-precloak-visibility")
      ];
      const init$6 = () => {
        const contents2 = value$2();
        const readState = constant$1("not-implemented");
        return nu$4({
          readState,
          isOpen: contents2.isSet,
          clear: contents2.clear,
          set: contents2.set,
          get: contents2.get
        });
      };
      var SandboxState = Object.freeze({
        __proto__: null,
        init: init$6
      });
      const Sandboxing = create$3({
        fields: SandboxSchema,
        name: "sandboxing",
        active: ActiveSandbox,
        apis: SandboxApis,
        state: SandboxState
      });
      const getAnimationRoot = (component, slideConfig) => slideConfig.getAnimationRoot.fold(() => component.element, (get2) => get2(component));
      const getDimensionProperty = (slideConfig) => slideConfig.dimension.property;
      const getDimension = (slideConfig, elem) => slideConfig.dimension.getDimension(elem);
      const disableTransitions = (component, slideConfig) => {
        const root = getAnimationRoot(component, slideConfig);
        remove$2(root, [slideConfig.shrinkingClass, slideConfig.growingClass]);
      };
      const setShrunk = (component, slideConfig) => {
        remove$3(component.element, slideConfig.openClass);
        add$2(component.element, slideConfig.closedClass);
        set$7(component.element, getDimensionProperty(slideConfig), "0px");
        reflow(component.element);
      };
      const setGrown = (component, slideConfig) => {
        remove$3(component.element, slideConfig.closedClass);
        add$2(component.element, slideConfig.openClass);
        remove$6(component.element, getDimensionProperty(slideConfig));
      };
      const doImmediateShrink = (component, slideConfig, slideState, _calculatedSize) => {
        slideState.setCollapsed();
        set$7(component.element, getDimensionProperty(slideConfig), getDimension(slideConfig, component.element));
        disableTransitions(component, slideConfig);
        setShrunk(component, slideConfig);
        slideConfig.onStartShrink(component);
        slideConfig.onShrunk(component);
      };
      const doStartShrink = (component, slideConfig, slideState, calculatedSize) => {
        const size = calculatedSize.getOrThunk(() => getDimension(slideConfig, component.element));
        slideState.setCollapsed();
        set$7(component.element, getDimensionProperty(slideConfig), size);
        reflow(component.element);
        const root = getAnimationRoot(component, slideConfig);
        remove$3(root, slideConfig.growingClass);
        add$2(root, slideConfig.shrinkingClass);
        setShrunk(component, slideConfig);
        slideConfig.onStartShrink(component);
      };
      const doStartSmartShrink = (component, slideConfig, slideState) => {
        const size = getDimension(slideConfig, component.element);
        const shrinker = size === "0px" ? doImmediateShrink : doStartShrink;
        shrinker(component, slideConfig, slideState, Optional.some(size));
      };
      const doStartGrow = (component, slideConfig, slideState) => {
        const root = getAnimationRoot(component, slideConfig);
        const wasShrinking = has(root, slideConfig.shrinkingClass);
        const beforeSize = getDimension(slideConfig, component.element);
        setGrown(component, slideConfig);
        const fullSize = getDimension(slideConfig, component.element);
        const startPartialGrow = () => {
          set$7(component.element, getDimensionProperty(slideConfig), beforeSize);
          reflow(component.element);
        };
        const startCompleteGrow = () => {
          setShrunk(component, slideConfig);
        };
        const setStartSize = wasShrinking ? startPartialGrow : startCompleteGrow;
        setStartSize();
        remove$3(root, slideConfig.shrinkingClass);
        add$2(root, slideConfig.growingClass);
        setGrown(component, slideConfig);
        set$7(component.element, getDimensionProperty(slideConfig), fullSize);
        slideState.setExpanded();
        slideConfig.onStartGrow(component);
      };
      const refresh$3 = (component, slideConfig, slideState) => {
        if (slideState.isExpanded()) {
          remove$6(component.element, getDimensionProperty(slideConfig));
          const fullSize = getDimension(slideConfig, component.element);
          set$7(component.element, getDimensionProperty(slideConfig), fullSize);
        }
      };
      const grow = (component, slideConfig, slideState) => {
        if (!slideState.isExpanded()) {
          doStartGrow(component, slideConfig, slideState);
        }
      };
      const shrink = (component, slideConfig, slideState) => {
        if (slideState.isExpanded()) {
          doStartSmartShrink(component, slideConfig, slideState);
        }
      };
      const immediateShrink = (component, slideConfig, slideState) => {
        if (slideState.isExpanded()) {
          doImmediateShrink(component, slideConfig, slideState);
        }
      };
      const hasGrown = (component, slideConfig, slideState) => slideState.isExpanded();
      const hasShrunk = (component, slideConfig, slideState) => slideState.isCollapsed();
      const isGrowing = (component, slideConfig, _slideState) => {
        const root = getAnimationRoot(component, slideConfig);
        return has(root, slideConfig.growingClass) === true;
      };
      const isShrinking = (component, slideConfig, _slideState) => {
        const root = getAnimationRoot(component, slideConfig);
        return has(root, slideConfig.shrinkingClass) === true;
      };
      const isTransitioning = (component, slideConfig, slideState) => isGrowing(component, slideConfig) || isShrinking(component, slideConfig);
      const toggleGrow = (component, slideConfig, slideState) => {
        const f2 = slideState.isExpanded() ? doStartSmartShrink : doStartGrow;
        f2(component, slideConfig, slideState);
      };
      const immediateGrow = (component, slideConfig, slideState) => {
        if (!slideState.isExpanded()) {
          setGrown(component, slideConfig);
          set$7(component.element, getDimensionProperty(slideConfig), getDimension(slideConfig, component.element));
          disableTransitions(component, slideConfig);
          slideState.setExpanded();
          slideConfig.onStartGrow(component);
          slideConfig.onGrown(component);
        }
      };
      var SlidingApis = Object.freeze({
        __proto__: null,
        refresh: refresh$3,
        grow,
        shrink,
        immediateShrink,
        hasGrown,
        hasShrunk,
        isGrowing,
        isShrinking,
        isTransitioning,
        toggleGrow,
        disableTransitions,
        immediateGrow
      });
      const exhibit$3 = (base2, slideConfig, _slideState) => {
        const expanded = slideConfig.expanded;
        return expanded ? nu$2({
          classes: [slideConfig.openClass],
          styles: {}
        }) : nu$2({
          classes: [slideConfig.closedClass],
          styles: wrap(slideConfig.dimension.property, "0px")
        });
      };
      const events$5 = (slideConfig, slideState) => derive$2([
        runOnSource(transitionend(), (component, simulatedEvent) => {
          const raw = simulatedEvent.event.raw;
          if (raw.propertyName === slideConfig.dimension.property) {
            disableTransitions(component, slideConfig);
            if (slideState.isExpanded()) {
              remove$6(component.element, slideConfig.dimension.property);
            }
            const notify = slideState.isExpanded() ? slideConfig.onGrown : slideConfig.onShrunk;
            notify(component);
          }
        })
      ]);
      var ActiveSliding = Object.freeze({
        __proto__: null,
        exhibit: exhibit$3,
        events: events$5
      });
      var SlidingSchema = [
        required$1("closedClass"),
        required$1("openClass"),
        required$1("shrinkingClass"),
        required$1("growingClass"),
        // Element which shrinking and growing animations
        option$3("getAnimationRoot"),
        onHandler("onShrunk"),
        onHandler("onStartShrink"),
        onHandler("onGrown"),
        onHandler("onStartGrow"),
        defaulted("expanded", false),
        requiredOf("dimension", choose$1("property", {
          width: [
            output$1("property", "width"),
            output$1("getDimension", (elem) => get$c(elem) + "px")
          ],
          height: [
            output$1("property", "height"),
            output$1("getDimension", (elem) => get$d(elem) + "px")
          ]
        }))
      ];
      const init$5 = (spec) => {
        const state = Cell(spec.expanded);
        const readState = () => "expanded: " + state.get();
        return nu$4({
          isExpanded: () => state.get() === true,
          isCollapsed: () => state.get() === false,
          setCollapsed: curry(state.set, false),
          setExpanded: curry(state.set, true),
          readState
        });
      };
      var SlidingState = Object.freeze({
        __proto__: null,
        init: init$5
      });
      const Sliding = create$3({
        fields: SlidingSchema,
        name: "sliding",
        active: ActiveSliding,
        apis: SlidingApis,
        state: SlidingState
      });
      const events$4 = (streamConfig, streamState) => {
        const streams = streamConfig.stream.streams;
        const processor = streams.setup(streamConfig, streamState);
        return derive$2([
          run$1(streamConfig.event, processor),
          runOnDetached(() => streamState.cancel())
        ].concat(streamConfig.cancelEvent.map((e) => [
          run$1(e, () => streamState.cancel())
        ]).getOr([])));
      };
      var ActiveStreaming = Object.freeze({
        __proto__: null,
        events: events$4
      });
      const throttle = (_config) => {
        const state = Cell(null);
        const readState = () => ({
          timer: state.get() !== null ? "set" : "unset"
        });
        const setTimer = (t2) => {
          state.set(t2);
        };
        const cancel = () => {
          const t2 = state.get();
          if (t2 !== null) {
            t2.cancel();
          }
        };
        return nu$4({
          readState,
          setTimer,
          cancel
        });
      };
      const init$4 = (spec) => spec.stream.streams.state(spec);
      var StreamingState = Object.freeze({
        __proto__: null,
        throttle,
        init: init$4
      });
      const setup$e = (streamInfo, streamState) => {
        const sInfo = streamInfo.stream;
        const throttler = last(streamInfo.onStream, sInfo.delay);
        streamState.setTimer(throttler);
        return (component, simulatedEvent) => {
          throttler.throttle(component, simulatedEvent);
          if (sInfo.stopEvent) {
            simulatedEvent.stop();
          }
        };
      };
      var StreamingSchema = [
        requiredOf("stream", choose$1("mode", {
          throttle: [
            required$1("delay"),
            defaulted("stopEvent", true),
            output$1("streams", {
              setup: setup$e,
              state: throttle
            })
          ]
        })),
        defaulted("event", "input"),
        option$3("cancelEvent"),
        onStrictHandler("onStream")
      ];
      const Streaming = create$3({
        fields: StreamingSchema,
        name: "streaming",
        active: ActiveStreaming,
        state: StreamingState
      });
      const exhibit$2 = (base2, tabConfig) => nu$2({
        attributes: wrapAll([
          { key: tabConfig.tabAttr, value: "true" }
        ])
      });
      var ActiveTabstopping = Object.freeze({
        __proto__: null,
        exhibit: exhibit$2
      });
      var TabstopSchema = [
        defaulted("tabAttr", "data-alloy-tabstop")
      ];
      const Tabstopping = create$3({
        fields: TabstopSchema,
        name: "tabstopping",
        active: ActiveTabstopping
      });
      const updateAriaState = (component, toggleConfig, toggleState) => {
        const ariaInfo = toggleConfig.aria;
        ariaInfo.update(component, ariaInfo, toggleState.get());
      };
      const updateClass = (component, toggleConfig, toggleState) => {
        toggleConfig.toggleClass.each((toggleClass) => {
          if (toggleState.get()) {
            add$2(component.element, toggleClass);
          } else {
            remove$3(component.element, toggleClass);
          }
        });
      };
      const set = (component, toggleConfig, toggleState, state) => {
        const initialState = toggleState.get();
        toggleState.set(state);
        updateClass(component, toggleConfig, toggleState);
        updateAriaState(component, toggleConfig, toggleState);
        if (initialState !== state) {
          toggleConfig.onToggled(component, state);
        }
      };
      const toggle$2 = (component, toggleConfig, toggleState) => {
        set(component, toggleConfig, toggleState, !toggleState.get());
      };
      const on = (component, toggleConfig, toggleState) => {
        set(component, toggleConfig, toggleState, true);
      };
      const off = (component, toggleConfig, toggleState) => {
        set(component, toggleConfig, toggleState, false);
      };
      const isOn = (component, toggleConfig, toggleState) => toggleState.get();
      const onLoad = (component, toggleConfig, toggleState) => {
        set(component, toggleConfig, toggleState, toggleConfig.selected);
      };
      var ToggleApis = Object.freeze({
        __proto__: null,
        onLoad,
        toggle: toggle$2,
        isOn,
        on,
        off,
        set
      });
      const exhibit$1 = () => nu$2({});
      const events$3 = (toggleConfig, toggleState) => {
        const execute2 = executeEvent(toggleConfig, toggleState, toggle$2);
        const load = loadEvent(toggleConfig, toggleState, onLoad);
        return derive$2(flatten([
          toggleConfig.toggleOnExecute ? [execute2] : [],
          [load]
        ]));
      };
      var ActiveToggle = Object.freeze({
        __proto__: null,
        exhibit: exhibit$1,
        events: events$3
      });
      const updatePressed = (component, ariaInfo, status) => {
        set$9(component.element, "aria-pressed", status);
        if (ariaInfo.syncWithExpanded) {
          updateExpanded(component, ariaInfo, status);
        }
      };
      const updateSelected = (component, ariaInfo, status) => {
        set$9(component.element, "aria-selected", status);
      };
      const updateChecked = (component, ariaInfo, status) => {
        set$9(component.element, "aria-checked", status);
      };
      const updateExpanded = (component, ariaInfo, status) => {
        set$9(component.element, "aria-expanded", status);
      };
      var ToggleSchema = [
        defaulted("selected", false),
        option$3("toggleClass"),
        defaulted("toggleOnExecute", true),
        onHandler("onToggled"),
        defaultedOf("aria", {
          mode: "none"
        }, choose$1("mode", {
          pressed: [
            defaulted("syncWithExpanded", false),
            output$1("update", updatePressed)
          ],
          checked: [
            output$1("update", updateChecked)
          ],
          expanded: [
            output$1("update", updateExpanded)
          ],
          selected: [
            output$1("update", updateSelected)
          ],
          none: [
            output$1("update", noop)
          ]
        }))
      ];
      const Toggling = create$3({
        fields: ToggleSchema,
        name: "toggling",
        active: ActiveToggle,
        apis: ToggleApis,
        state: SetupBehaviourCellState(false)
      });
      const ExclusivityChannel = generate$6("tooltip.exclusive");
      const ShowTooltipEvent = generate$6("tooltip.show");
      const HideTooltipEvent = generate$6("tooltip.hide");
      const ImmediateHideTooltipEvent = generate$6("tooltip.immediateHide");
      const ImmediateShowTooltipEvent = generate$6("tooltip.immediateShow");
      const hideAllExclusive = (component, _tConfig, _tState) => {
        component.getSystem().broadcastOn([ExclusivityChannel], {});
      };
      const setComponents = (_component, _tConfig, tState, specs) => {
        tState.getTooltip().each((tooltip) => {
          if (tooltip.getSystem().isConnected()) {
            Replacing.set(tooltip, specs);
          }
        });
      };
      const isEnabled = (_component, _tConfig, tState) => tState.isEnabled();
      const setEnabled = (_component, _tConfig, tState, enabled2) => tState.setEnabled(enabled2);
      const immediateOpenClose = (component, _tConfig, _tState, open2) => emit(component, open2 ? ImmediateShowTooltipEvent : ImmediateHideTooltipEvent);
      var TooltippingApis = Object.freeze({
        __proto__: null,
        hideAllExclusive,
        immediateOpenClose,
        isEnabled,
        setComponents,
        setEnabled
      });
      const events$2 = (tooltipConfig, state) => {
        const hide = (comp) => {
          state.getTooltip().each((p) => {
            if (p.getSystem().isConnected()) {
              detach(p);
              tooltipConfig.onHide(comp, p);
              state.clearTooltip();
            }
          });
          state.clearTimer();
        };
        const show2 = (comp) => {
          if (!state.isShowing() && state.isEnabled()) {
            hideAllExclusive(comp);
            const sink = tooltipConfig.lazySink(comp).getOrDie();
            const popup = comp.getSystem().build({
              dom: tooltipConfig.tooltipDom,
              components: tooltipConfig.tooltipComponents,
              events: derive$2(tooltipConfig.mode === "normal" ? [
                run$1(mouseover(), (_) => {
                  emit(comp, ShowTooltipEvent);
                }),
                run$1(mouseout(), (_) => {
                  emit(comp, HideTooltipEvent);
                })
              ] : []),
              behaviours: derive$1([
                Replacing.config({})
              ])
            });
            state.setTooltip(popup);
            attach(sink, popup);
            tooltipConfig.onShow(comp, popup);
            Positioning.position(sink, popup, { anchor: tooltipConfig.anchor(comp) });
          }
        };
        const reposition2 = (comp) => {
          state.getTooltip().each((tooltip) => {
            const sink = tooltipConfig.lazySink(comp).getOrDie();
            Positioning.position(sink, tooltip, { anchor: tooltipConfig.anchor(comp) });
          });
        };
        const getEvents2 = () => {
          switch (tooltipConfig.mode) {
            case "normal":
              return [
                run$1(focusin(), (comp) => {
                  emit(comp, ImmediateShowTooltipEvent);
                }),
                run$1(postBlur(), (comp) => {
                  emit(comp, ImmediateHideTooltipEvent);
                }),
                run$1(mouseover(), (comp) => {
                  emit(comp, ShowTooltipEvent);
                }),
                run$1(mouseout(), (comp) => {
                  emit(comp, HideTooltipEvent);
                })
              ];
            case "follow-highlight":
              return [
                run$1(highlight$1(), (comp, _se) => {
                  emit(comp, ShowTooltipEvent);
                }),
                run$1(dehighlight$1(), (comp) => {
                  emit(comp, HideTooltipEvent);
                })
              ];
            case "children-normal":
              return [
                run$1(focusin(), (comp, se) => {
                  search(comp.element).each((_) => {
                    if (is(se.event.target, "[data-mce-tooltip]")) {
                      state.getTooltip().fold(() => {
                        emit(comp, ImmediateShowTooltipEvent);
                      }, (tooltip) => {
                        if (state.isShowing()) {
                          tooltipConfig.onShow(comp, tooltip);
                          reposition2(comp);
                        }
                      });
                    }
                  });
                }),
                run$1(postBlur(), (comp) => {
                  search(comp.element).fold(() => {
                    emit(comp, ImmediateHideTooltipEvent);
                  }, noop);
                }),
                run$1(mouseover(), (comp) => {
                  descendant(comp.element, "[data-mce-tooltip]:hover").each((_) => {
                    state.getTooltip().fold(() => {
                      emit(comp, ShowTooltipEvent);
                    }, (tooltip) => {
                      if (state.isShowing()) {
                        tooltipConfig.onShow(comp, tooltip);
                        reposition2(comp);
                      }
                    });
                  });
                }),
                run$1(mouseout(), (comp) => {
                  descendant(comp.element, "[data-mce-tooltip]:hover").fold(() => {
                    emit(comp, HideTooltipEvent);
                  }, noop);
                })
              ];
            default:
              return [
                run$1(focusin(), (comp, se) => {
                  search(comp.element).each((_) => {
                    if (is(se.event.target, "[data-mce-tooltip]")) {
                      state.getTooltip().fold(() => {
                        emit(comp, ImmediateShowTooltipEvent);
                      }, (tooltip) => {
                        if (state.isShowing()) {
                          tooltipConfig.onShow(comp, tooltip);
                          reposition2(comp);
                        }
                      });
                    }
                  });
                }),
                run$1(postBlur(), (comp) => {
                  search(comp.element).fold(() => {
                    emit(comp, ImmediateHideTooltipEvent);
                  }, noop);
                })
              ];
          }
        };
        return derive$2(flatten([
          [
            runOnInit((component) => {
              tooltipConfig.onSetup(component);
            }),
            run$1(ShowTooltipEvent, (comp) => {
              state.resetTimer(() => {
                show2(comp);
              }, tooltipConfig.delayForShow());
            }),
            run$1(HideTooltipEvent, (comp) => {
              state.resetTimer(() => {
                hide(comp);
              }, tooltipConfig.delayForHide());
            }),
            run$1(ImmediateShowTooltipEvent, (comp) => {
              state.resetTimer(() => {
                show2(comp);
              }, 0);
            }),
            run$1(ImmediateHideTooltipEvent, (comp) => {
              state.resetTimer(() => {
                hide(comp);
              }, 0);
            }),
            run$1(receive(), (comp, message) => {
              const receivingData = message;
              if (!receivingData.universal) {
                if (contains$2(receivingData.channels, ExclusivityChannel)) {
                  hide(comp);
                }
              }
            }),
            runOnDetached((comp) => {
              hide(comp);
            })
          ],
          getEvents2()
        ]));
      };
      var ActiveTooltipping = Object.freeze({
        __proto__: null,
        events: events$2
      });
      var TooltippingSchema = [
        required$1("lazySink"),
        required$1("tooltipDom"),
        defaulted("exclusive", true),
        defaulted("tooltipComponents", []),
        defaultedFunction("delayForShow", constant$1(300)),
        defaultedFunction("delayForHide", constant$1(100)),
        defaultedFunction("onSetup", noop),
        defaultedStringEnum("mode", "normal", ["normal", "follow-highlight", "children-keyboard-focus", "children-normal"]),
        defaulted("anchor", (comp) => ({
          type: "hotspot",
          hotspot: comp,
          layouts: {
            onLtr: constant$1([south$2, north$2, southeast$2, northeast$2, southwest$2, northwest$2]),
            onRtl: constant$1([south$2, north$2, southeast$2, northeast$2, southwest$2, northwest$2])
          },
          bubble: nu$6(0, -2, {})
        })),
        onHandler("onHide"),
        onHandler("onShow")
      ];
      const init$3 = () => {
        const enabled2 = Cell(true);
        const timer = value$2();
        const popup = value$2();
        const clearTimer = () => {
          timer.on(clearTimeout);
        };
        const resetTimer = (f2, delay) => {
          clearTimer();
          timer.set(setTimeout(f2, delay));
        };
        const readState = constant$1("not-implemented");
        return nu$4({
          getTooltip: popup.get,
          isShowing: popup.isSet,
          setTooltip: popup.set,
          clearTooltip: popup.clear,
          clearTimer,
          resetTimer,
          readState,
          isEnabled: () => enabled2.get(),
          setEnabled: (setToEnabled) => enabled2.set(setToEnabled)
        });
      };
      var TooltippingState = Object.freeze({
        __proto__: null,
        init: init$3
      });
      const Tooltipping = create$3({
        fields: TooltippingSchema,
        name: "tooltipping",
        active: ActiveTooltipping,
        state: TooltippingState,
        apis: TooltippingApis
      });
      const exhibit = () => nu$2({
        styles: {
          "-webkit-user-select": "none",
          "user-select": "none",
          "-ms-user-select": "none",
          "-moz-user-select": "-moz-none"
        },
        attributes: {
          unselectable: "on"
        }
      });
      const events$1 = () => derive$2([
        abort(selectstart(), always)
      ]);
      var ActiveUnselecting = Object.freeze({
        __proto__: null,
        events: events$1,
        exhibit
      });
      const Unselecting = create$3({
        fields: [],
        name: "unselecting",
        active: ActiveUnselecting
      });
      const getAttrs = (elem) => {
        const attributes = elem.dom.attributes !== void 0 ? elem.dom.attributes : [];
        return foldl(attributes, (b2, attr) => {
          if (attr.name === "class") {
            return b2;
          } else {
            return { ...b2, [attr.name]: attr.value };
          }
        }, {});
      };
      const getClasses = (elem) => Array.prototype.slice.call(elem.dom.classList, 0);
      const fromHtml = (html2) => {
        const elem = SugarElement.fromHtml(html2);
        const children$1 = children(elem);
        const attrs = getAttrs(elem);
        const classes2 = getClasses(elem);
        const contents2 = children$1.length === 0 ? {} : { innerHtml: get$f(elem) };
        return {
          tag: name$3(elem),
          classes: classes2,
          attributes: attrs,
          ...contents2
        };
      };
      const record = (spec) => {
        const uid = isSketchSpec(spec) && hasNonNullableKey(spec, "uid") ? spec.uid : generate$4("memento");
        const get2 = (anyInSystem) => anyInSystem.getSystem().getByUid(uid).getOrDie();
        const getOpt2 = (anyInSystem) => anyInSystem.getSystem().getByUid(uid).toOptional();
        const asSpec = () => ({
          ...spec,
          uid
        });
        return {
          get: get2,
          getOpt: getOpt2,
          asSpec
        };
      };
      const parts$h = AlloyParts;
      const partType$1 = PartType;
      const dismissPopups = constant$1("dismiss.popups");
      const repositionPopups = constant$1("reposition.popups");
      const mouseReleased = constant$1("mouse.released");
      const fromSource = (event, source) => {
        const stopper2 = Cell(false);
        const cutter2 = Cell(false);
        const stop2 = () => {
          stopper2.set(true);
        };
        const cut = () => {
          cutter2.set(true);
        };
        return {
          stop: stop2,
          cut,
          isStopped: stopper2.get,
          isCut: cutter2.get,
          event,
          // Used only for tiered menu at the moment. It is an element, not a component
          setSource: source.set,
          getSource: source.get
        };
      };
      const fromExternal = (event) => {
        const stopper2 = Cell(false);
        const stop2 = () => {
          stopper2.set(true);
        };
        return {
          stop: stop2,
          cut: noop,
          // cutting has no meaning for a broadcasted event
          isStopped: stopper2.get,
          isCut: never,
          event,
          // Nor do targets really
          setSource: die("Cannot set source of a broadcasted event"),
          getSource: die("Cannot get source of a broadcasted event")
        };
      };
      const isDangerous = (event) => {
        const keyEv = event.raw;
        return keyEv.which === BACKSPACE[0] && !contains$2(["input", "textarea"], name$3(event.target)) && !closest$1(event.target, '[contenteditable="true"]');
      };
      const setup$d = (container, rawSettings) => {
        const settings = {
          stopBackspace: true,
          ...rawSettings
        };
        const pointerEvents2 = [
          "touchstart",
          "touchmove",
          "touchend",
          "touchcancel",
          "gesturestart",
          "mousedown",
          "mouseup",
          "mouseover",
          "mousemove",
          "mouseout",
          "click"
        ];
        const tapEvent = monitor(settings);
        const simpleEvents = map$2(pointerEvents2.concat([
          "selectstart",
          "input",
          "contextmenu",
          "change",
          "transitionend",
          "transitioncancel",
          // Test the drag events
          "drag",
          "dragstart",
          "dragend",
          "dragenter",
          "dragleave",
          "dragover",
          "drop",
          "keyup"
        ]), (type2) => bind$1(container, type2, (event) => {
          tapEvent.fireIfReady(event, type2).each((tapStopped) => {
            if (tapStopped) {
              event.kill();
            }
          });
          const stopped = settings.triggerEvent(type2, event);
          if (stopped) {
            event.kill();
          }
        }));
        const pasteTimeout = value$2();
        const onPaste = bind$1(container, "paste", (event) => {
          tapEvent.fireIfReady(event, "paste").each((tapStopped) => {
            if (tapStopped) {
              event.kill();
            }
          });
          const stopped = settings.triggerEvent("paste", event);
          if (stopped) {
            event.kill();
          }
          pasteTimeout.set(setTimeout(() => {
            settings.triggerEvent(postPaste(), event);
          }, 0));
        });
        const onKeydown = bind$1(container, "keydown", (event) => {
          const stopped = settings.triggerEvent("keydown", event);
          if (stopped) {
            event.kill();
          } else if (settings.stopBackspace && isDangerous(event)) {
            event.prevent();
          }
        });
        const onFocusIn = bind$1(container, "focusin", (event) => {
          const stopped = settings.triggerEvent("focusin", event);
          if (stopped) {
            event.kill();
          }
        });
        const focusoutTimeout = value$2();
        const onFocusOut = bind$1(container, "focusout", (event) => {
          const stopped = settings.triggerEvent("focusout", event);
          if (stopped) {
            event.kill();
          }
          focusoutTimeout.set(setTimeout(() => {
            settings.triggerEvent(postBlur(), event);
          }, 0));
        });
        const unbind2 = () => {
          each$1(simpleEvents, (e) => {
            e.unbind();
          });
          onKeydown.unbind();
          onFocusIn.unbind();
          onFocusOut.unbind();
          onPaste.unbind();
          pasteTimeout.on(clearTimeout);
          focusoutTimeout.on(clearTimeout);
        };
        return {
          unbind: unbind2
        };
      };
      const derive = (rawEvent, rawTarget) => {
        const source = get$h(rawEvent, "target").getOr(rawTarget);
        return Cell(source);
      };
      const adt = Adt.generate([
        { stopped: [] },
        { resume: ["element"] },
        { complete: [] }
      ]);
      const doTriggerHandler = (lookup2, eventType, rawEvent, target, source, logger) => {
        const handler = lookup2(eventType, target);
        const simulatedEvent = fromSource(rawEvent, source);
        return handler.fold(() => {
          logger.logEventNoHandlers(eventType, target);
          return adt.complete();
        }, (handlerInfo) => {
          const descHandler = handlerInfo.descHandler;
          const eventHandler2 = getCurried(descHandler);
          eventHandler2(simulatedEvent);
          if (simulatedEvent.isStopped()) {
            logger.logEventStopped(eventType, handlerInfo.element, descHandler.purpose);
            return adt.stopped();
          } else if (simulatedEvent.isCut()) {
            logger.logEventCut(eventType, handlerInfo.element, descHandler.purpose);
            return adt.complete();
          } else {
            return parent(handlerInfo.element).fold(() => {
              logger.logNoParent(eventType, handlerInfo.element, descHandler.purpose);
              return adt.complete();
            }, (parent2) => {
              logger.logEventResponse(eventType, handlerInfo.element, descHandler.purpose);
              return adt.resume(parent2);
            });
          }
        });
      };
      const doTriggerOnUntilStopped = (lookup2, eventType, rawEvent, rawTarget, source, logger) => doTriggerHandler(lookup2, eventType, rawEvent, rawTarget, source, logger).fold(
        // stopped.
        always,
        // Go again.
        (parent2) => doTriggerOnUntilStopped(lookup2, eventType, rawEvent, parent2, source, logger),
        // completed
        never
      );
      const triggerHandler = (lookup2, eventType, rawEvent, target, logger) => {
        const source = derive(rawEvent, target);
        return doTriggerHandler(lookup2, eventType, rawEvent, target, source, logger);
      };
      const broadcast = (listeners, rawEvent, _logger) => {
        const simulatedEvent = fromExternal(rawEvent);
        each$1(listeners, (listener) => {
          const descHandler = listener.descHandler;
          const handler = getCurried(descHandler);
          handler(simulatedEvent);
        });
        return simulatedEvent.isStopped();
      };
      const triggerUntilStopped = (lookup2, eventType, rawEvent, logger) => triggerOnUntilStopped(lookup2, eventType, rawEvent, rawEvent.target, logger);
      const triggerOnUntilStopped = (lookup2, eventType, rawEvent, rawTarget, logger) => {
        const source = derive(rawEvent, rawTarget);
        return doTriggerOnUntilStopped(lookup2, eventType, rawEvent, rawTarget, source, logger);
      };
      const eventHandler = (element2, descHandler) => ({
        element: element2,
        descHandler
      });
      const broadcastHandler = (id, handler) => ({
        id,
        descHandler: handler
      });
      const EventRegistry = () => {
        const registry = {};
        const registerId = (extraArgs, id, events2) => {
          each(events2, (v, k) => {
            const handlers2 = registry[k] !== void 0 ? registry[k] : {};
            handlers2[id] = curryArgs(v, extraArgs);
            registry[k] = handlers2;
          });
        };
        const findHandler = (handlers2, elem) => read(elem).bind((id) => get$h(handlers2, id)).map((descHandler) => eventHandler(elem, descHandler));
        const filterByType = (type2) => get$h(registry, type2).map((handlers2) => mapToArray(handlers2, (f2, id) => broadcastHandler(id, f2))).getOr([]);
        const find2 = (isAboveRoot, type2, target) => get$h(registry, type2).bind((handlers2) => closest(target, (elem) => findHandler(handlers2, elem), isAboveRoot));
        const unregisterId = (id) => {
          each(registry, (handlersById, _eventName) => {
            if (has$2(handlersById, id)) {
              delete handlersById[id];
            }
          });
        };
        return {
          registerId,
          unregisterId,
          filterByType,
          find: find2
        };
      };
      const Registry = () => {
        const events2 = EventRegistry();
        const components2 = {};
        const readOrTag = (component) => {
          const elem = component.element;
          return read(elem).getOrThunk(() => (
            // No existing tag, so add one.
            write("uid-", component.element)
          ));
        };
        const failOnDuplicate = (component, tagId) => {
          const conflict = components2[tagId];
          if (conflict === component) {
            unregister(component);
          } else {
            throw new Error('The tagId "' + tagId + '" is already used by: ' + element(conflict.element) + "\nCannot use it for: " + element(component.element) + "\nThe conflicting element is" + (inBody(conflict.element) ? " " : " not ") + "already in the DOM");
          }
        };
        const register2 = (component) => {
          const tagId = readOrTag(component);
          if (hasNonNullableKey(components2, tagId)) {
            failOnDuplicate(component, tagId);
          }
          const extraArgs = [component];
          events2.registerId(extraArgs, tagId, component.events);
          components2[tagId] = component;
        };
        const unregister = (component) => {
          read(component.element).each((tagId) => {
            delete components2[tagId];
            events2.unregisterId(tagId);
          });
        };
        const filter2 = (type2) => events2.filterByType(type2);
        const find2 = (isAboveRoot, type2, target) => events2.find(isAboveRoot, type2, target);
        const getById = (id) => get$h(components2, id);
        return {
          find: find2,
          filter: filter2,
          register: register2,
          unregister,
          getById
        };
      };
      const takeover = (root) => {
        const isAboveRoot = (el) => parent(root.element).fold(always, (parent2) => eq(el, parent2));
        const registry = Registry();
        const lookup2 = (eventName, target) => registry.find(isAboveRoot, eventName, target);
        const domEvents = setup$d(root.element, {
          triggerEvent: (eventName, event) => {
            return monitorEvent(eventName, event.target, (logger) => triggerUntilStopped(lookup2, eventName, event, logger));
          }
        });
        const systemApi = {
          // This is a real system
          debugInfo: constant$1("real"),
          triggerEvent: (eventName, target, data) => {
            monitorEvent(eventName, target, (logger) => (
              // The return value is not used because this is a fake event.
              triggerOnUntilStopped(lookup2, eventName, data, target, logger)
            ));
          },
          triggerFocus: (target, originator) => {
            read(target).fold(() => {
              focus$4(target);
            }, (_alloyId) => {
              monitorEvent(focus$3(), target, (logger) => {
                triggerHandler(lookup2, focus$3(), {
                  // originator is used by the default events to ensure that focus doesn't
                  // get called infinitely
                  originator,
                  kill: noop,
                  prevent: noop,
                  target
                }, target, logger);
                return false;
              });
            });
          },
          triggerEscape: (comp, simulatedEvent) => {
            systemApi.triggerEvent("keydown", comp.element, simulatedEvent.event);
          },
          getByUid: (uid) => {
            return getByUid(uid);
          },
          getByDom: (elem) => {
            return getByDom(elem);
          },
          build: build$1,
          buildOrPatch,
          addToGui: (c) => {
            add2(c);
          },
          removeFromGui: (c) => {
            remove2(c);
          },
          addToWorld: (c) => {
            addToWorld(c);
          },
          removeFromWorld: (c) => {
            removeFromWorld(c);
          },
          broadcast: (message) => {
            broadcast$1(message);
          },
          broadcastOn: (channels, message) => {
            broadcastOn(channels, message);
          },
          broadcastEvent: (eventName, event) => {
            broadcastEvent(eventName, event);
          },
          isConnected: always
        };
        const addToWorld = (component) => {
          component.connect(systemApi);
          if (!isText(component.element)) {
            registry.register(component);
            each$1(component.components(), addToWorld);
            systemApi.triggerEvent(systemInit(), component.element, { target: component.element });
          }
        };
        const removeFromWorld = (component) => {
          if (!isText(component.element)) {
            each$1(component.components(), removeFromWorld);
            registry.unregister(component);
          }
          component.disconnect();
        };
        const add2 = (component) => {
          attach(root, component);
        };
        const remove2 = (component) => {
          detach(component);
        };
        const destroy = () => {
          domEvents.unbind();
          remove$7(root.element);
        };
        const broadcastData = (data) => {
          const receivers = registry.filter(receive());
          each$1(receivers, (receiver) => {
            const descHandler = receiver.descHandler;
            const handler = getCurried(descHandler);
            handler(data);
          });
        };
        const broadcast$1 = (message) => {
          broadcastData({
            universal: true,
            data: message
          });
        };
        const broadcastOn = (channels, message) => {
          broadcastData({
            universal: false,
            channels,
            data: message
          });
        };
        const broadcastEvent = (eventName, event) => {
          const listeners = registry.filter(eventName);
          return broadcast(listeners, event);
        };
        const getByUid = (uid) => registry.getById(uid).fold(() => Result.error(new Error('Could not find component with uid: "' + uid + '" in system.')), Result.value);
        const getByDom = (elem) => {
          const uid = read(elem).getOr("not found");
          return getByUid(uid);
        };
        addToWorld(root);
        return {
          root,
          element: root.element,
          destroy,
          add: add2,
          remove: remove2,
          getByUid,
          getByDom,
          addToWorld,
          removeFromWorld,
          broadcast: broadcast$1,
          broadcastOn,
          broadcastEvent
        };
      };
      const pointerEvents = () => {
        const onClick = (component, simulatedEvent) => {
          simulatedEvent.stop();
          emitExecute(component);
        };
        return [
          // Trigger execute when clicked
          run$1(click(), onClick),
          run$1(tap(), onClick),
          // Other mouse down listeners above this one should not get mousedown behaviour (like dragging)
          cutter(touchstart()),
          cutter(mousedown())
        ];
      };
      const events = (optAction) => {
        const executeHandler = (action) => runOnExecute$1((component, simulatedEvent) => {
          action(component);
          simulatedEvent.stop();
        });
        return derive$2(flatten([
          // Only listen to execute if it is supplied
          optAction.map(executeHandler).toArray(),
          pointerEvents()
        ]));
      };
      const factory$n = (detail) => {
        const events$12 = events(detail.action);
        const tag = detail.dom.tag;
        const lookupAttr = (attr) => get$h(detail.dom, "attributes").bind((attrs) => get$h(attrs, attr));
        const getModAttributes = () => {
          if (tag === "button") {
            const type2 = lookupAttr("type").getOr("button");
            const roleAttrs = lookupAttr("role").map((role) => ({ role })).getOr({});
            return {
              type: type2,
              ...roleAttrs
            };
          } else {
            const role = detail.role.getOr(lookupAttr("role").getOr("button"));
            return { role };
          }
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: detail.components,
          events: events$12,
          behaviours: SketchBehaviours.augment(detail.buttonBehaviours, [
            Focusing.config({}),
            Keying.config({
              mode: "execution",
              // Note execution will capture keyup when the focus is on the button
              // on Firefox, because otherwise it will fire a click event and double
              // up on the action
              useSpace: true,
              useEnter: true
            })
          ]),
          domModification: {
            attributes: getModAttributes()
          },
          eventOrder: detail.eventOrder
        };
      };
      const Button = single({
        name: "Button",
        factory: factory$n,
        configFields: [
          defaulted("uid", void 0),
          required$1("dom"),
          defaulted("components", []),
          SketchBehaviours.field("buttonBehaviours", [Focusing, Keying]),
          option$3("action"),
          option$3("role"),
          defaulted("eventOrder", {})
        ]
      });
      const schema$n = constant$1([
        defaulted("shell", false),
        required$1("makeItem"),
        defaulted("setupItem", noop),
        SketchBehaviours.field("listBehaviours", [Replacing])
      ]);
      const customListDetail = () => ({
        behaviours: derive$1([
          Replacing.config({})
        ])
      });
      const itemsPart = optional({
        name: "items",
        overrides: customListDetail
      });
      const parts$g = constant$1([
        itemsPart
      ]);
      const name$1 = constant$1("CustomList");
      const factory$m = (detail, components2, _spec, _external) => {
        const setItems = (list, items) => {
          getListContainer(list).fold(() => {
            console.error("Custom List was defined to not be a shell, but no item container was specified in components");
            throw new Error("Custom List was defined to not be a shell, but no item container was specified in components");
          }, (container) => {
            const itemComps = Replacing.contents(container);
            const numListsRequired = items.length;
            const numListsToAdd = numListsRequired - itemComps.length;
            const itemsToAdd = numListsToAdd > 0 ? range$2(numListsToAdd, () => detail.makeItem()) : [];
            const itemsToRemove = itemComps.slice(numListsRequired);
            each$1(itemsToRemove, (item2) => Replacing.remove(container, item2));
            each$1(itemsToAdd, (item2) => Replacing.append(container, item2));
            const builtLists = Replacing.contents(container);
            each$1(builtLists, (item2, i) => {
              detail.setupItem(list, item2, items[i], i);
            });
          });
        };
        const extra = detail.shell ? { behaviours: [Replacing.config({})], components: [] } : { behaviours: [], components: components2 };
        const getListContainer = (component) => detail.shell ? Optional.some(component) : getPart(component, detail, "items");
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: extra.components,
          behaviours: augment(detail.listBehaviours, extra.behaviours),
          apis: {
            setItems
          }
        };
      };
      const CustomList = composite({
        name: name$1(),
        configFields: schema$n(),
        partFields: parts$g(),
        factory: factory$m,
        apis: {
          setItems: (apis, list, items) => {
            apis.setItems(list, items);
          }
        }
      });
      const attribute = "aria-controls";
      const find$1 = (queryElem) => {
        const dependent = closest$4(queryElem, (elem) => {
          if (!isElement$1(elem)) {
            return false;
          }
          const id = get$g(elem, "id");
          return id !== void 0 && id.indexOf(attribute) > -1;
        });
        return dependent.bind((dep) => {
          const id = get$g(dep, "id");
          const dos = getRootNode(dep);
          return descendant(dos, `[${attribute}="${id}"]`);
        });
      };
      const manager = () => {
        const ariaId = generate$6(attribute);
        const link = (elem) => {
          set$9(elem, attribute, ariaId);
        };
        const unlink = (elem) => {
          remove$8(elem, attribute);
        };
        return {
          id: ariaId,
          link,
          unlink
        };
      };
      const isAriaPartOf = (component, queryElem) => find$1(queryElem).exists((owner2) => isPartOf(component, owner2));
      const isPartOf = (component, queryElem) => closest$2(queryElem, (el) => eq(el, component.element), never) || isAriaPartOf(component, queryElem);
      const hoverEvent = "alloy.item-hover";
      const focusEvent = "alloy.item-focus";
      const toggledEvent = "alloy.item-toggled";
      const onHover = (item2) => {
        if (search(item2.element).isNone() || Focusing.isFocused(item2)) {
          if (!Focusing.isFocused(item2)) {
            Focusing.focus(item2);
          }
          emitWith(item2, hoverEvent, { item: item2 });
        }
      };
      const onFocus$1 = (item2) => {
        emitWith(item2, focusEvent, { item: item2 });
      };
      const onToggled = (item2, state) => {
        emitWith(item2, toggledEvent, { item: item2, state });
      };
      const hover = constant$1(hoverEvent);
      const focus$1 = constant$1(focusEvent);
      const toggled = constant$1(toggledEvent);
      const getItemRole = (detail) => detail.role.fold(() => detail.toggling.map((toggling) => toggling.exclusive ? "menuitemradio" : "menuitemcheckbox").getOr("menuitem"), identity);
      const getTogglingSpec = (tConfig, isOption) => ({
        aria: {
          mode: isOption ? "selected" : "checked"
        },
        // Filter out the additional properties that are not in Toggling Behaviour's configuration (e.g. exclusive)
        ...filter$1(tConfig, (_value, name2) => name2 !== "exclusive"),
        onToggled: (component, state) => {
          if (isFunction(tConfig.onToggled)) {
            tConfig.onToggled(component, state);
          }
          onToggled(component, state);
        }
      });
      const builder$2 = (detail) => ({
        dom: detail.dom,
        domModification: {
          // INVESTIGATE: If more efficient, destructure attributes out
          ...detail.domModification,
          attributes: {
            "role": getItemRole(detail),
            ...detail.domModification.attributes,
            "aria-haspopup": detail.hasSubmenu,
            ...detail.hasSubmenu ? { "aria-expanded": false } : {}
          }
        },
        behaviours: SketchBehaviours.augment(detail.itemBehaviours, [
          // Investigate, is the Toggling.revoke still necessary here?
          detail.toggling.fold(Toggling.revoke, (tConfig) => Toggling.config(getTogglingSpec(tConfig, detail.role.exists((role) => role === "option")))),
          Focusing.config({
            ignore: detail.ignoreFocus,
            // Rationale: because nothing is focusable, when you click
            // on the items to choose them, the focus jumps to the first
            // focusable outer container ... often the body. If we prevent
            // mouseDown ... that doesn't happen. But only tested on Chrome/FF.
            stopMousedown: detail.ignoreFocus,
            onFocus: (component) => {
              onFocus$1(component);
            }
          }),
          Keying.config({
            mode: "execution"
          }),
          Representing.config({
            store: {
              mode: "memory",
              initialValue: detail.data
            }
          }),
          config("item-type-events", [
            // Treat clicks the same as a button
            ...pointerEvents(),
            run$1(mouseover(), onHover),
            run$1(focusItem(), Focusing.focus)
          ])
        ]),
        components: detail.components,
        eventOrder: detail.eventOrder
      });
      const schema$m = [
        required$1("data"),
        required$1("components"),
        required$1("dom"),
        defaulted("hasSubmenu", false),
        option$3("toggling"),
        option$3("role"),
        // Maybe this needs to have fewer behaviours
        SketchBehaviours.field("itemBehaviours", [Toggling, Focusing, Keying, Representing]),
        defaulted("ignoreFocus", false),
        defaulted("domModification", {}),
        output$1("builder", builder$2),
        defaulted("eventOrder", {})
      ];
      var ItemType = schema$m;
      const builder$1 = (detail) => ({
        dom: detail.dom,
        components: detail.components,
        events: derive$2([
          stopper(focusItem())
        ])
      });
      const schema$l = [
        required$1("dom"),
        required$1("components"),
        output$1("builder", builder$1)
      ];
      var SeparatorType = schema$l;
      const owner$2 = constant$1("item-widget");
      const parts$f = constant$1([
        required({
          name: "widget",
          overrides: (detail) => {
            return {
              behaviours: derive$1([
                Representing.config({
                  store: {
                    mode: "manual",
                    getValue: (_component) => {
                      return detail.data;
                    },
                    setValue: noop
                  }
                })
              ])
            };
          }
        })
      ]);
      const builder = (detail) => {
        const subs2 = substitutes(owner$2(), detail, parts$f());
        const components2 = components$1(owner$2(), detail, subs2.internals());
        const focusWidget = (component) => getPart(component, detail, "widget").map((widget) => {
          Keying.focusIn(widget);
          return widget;
        });
        const onHorizontalArrow = (component, simulatedEvent) => inside(simulatedEvent.event.target) ? Optional.none() : (() => {
          if (detail.autofocus) {
            simulatedEvent.setSource(component.element);
            return Optional.none();
          } else {
            return Optional.none();
          }
        })();
        return {
          dom: detail.dom,
          components: components2,
          domModification: detail.domModification,
          events: derive$2([
            runOnExecute$1((component, simulatedEvent) => {
              focusWidget(component).each((_widget) => {
                simulatedEvent.stop();
              });
            }),
            run$1(mouseover(), onHover),
            run$1(focusItem(), (component, _simulatedEvent) => {
              if (detail.autofocus) {
                focusWidget(component);
              } else {
                Focusing.focus(component);
              }
            })
          ]),
          behaviours: SketchBehaviours.augment(detail.widgetBehaviours, [
            Representing.config({
              store: {
                mode: "memory",
                initialValue: detail.data
              }
            }),
            Focusing.config({
              ignore: detail.ignoreFocus,
              // What about stopMousedown from ItemType?
              onFocus: (component) => {
                onFocus$1(component);
              }
            }),
            Keying.config({
              mode: "special",
              // This is required as long as Highlighting tries to focus the first thing (after focusItem fires)
              focusIn: detail.autofocus ? (component) => {
                focusWidget(component);
              } : revoke(),
              onLeft: onHorizontalArrow,
              onRight: onHorizontalArrow,
              onEscape: (component, simulatedEvent) => {
                if (!Focusing.isFocused(component) && !detail.autofocus) {
                  Focusing.focus(component);
                  return Optional.some(true);
                } else if (detail.autofocus) {
                  simulatedEvent.setSource(component.element);
                  return Optional.none();
                } else {
                  return Optional.none();
                }
              }
            })
          ])
        };
      };
      const schema$k = [
        required$1("uid"),
        required$1("data"),
        required$1("components"),
        required$1("dom"),
        defaulted("autofocus", false),
        defaulted("ignoreFocus", false),
        SketchBehaviours.field("widgetBehaviours", [Representing, Focusing, Keying]),
        defaulted("domModification", {}),
        // We don't have the uid at this point
        defaultUidsSchema(parts$f()),
        output$1("builder", builder)
      ];
      var WidgetType = schema$k;
      const itemSchema$2 = choose$1("type", {
        widget: WidgetType,
        item: ItemType,
        separator: SeparatorType
      });
      const configureGrid = (detail, movementInfo) => ({
        mode: "flatgrid",
        selector: "." + detail.markers.item,
        initSize: {
          numColumns: movementInfo.initSize.numColumns,
          numRows: movementInfo.initSize.numRows
        },
        focusManager: detail.focusManager
      });
      const configureMatrix = (detail, movementInfo) => ({
        mode: "matrix",
        selectors: {
          row: movementInfo.rowSelector,
          cell: "." + detail.markers.item
        },
        previousSelector: movementInfo.previousSelector,
        focusManager: detail.focusManager
      });
      const configureMenu = (detail, movementInfo) => ({
        mode: "menu",
        selector: "." + detail.markers.item,
        moveOnTab: movementInfo.moveOnTab,
        focusManager: detail.focusManager
      });
      const parts$e = constant$1([
        group({
          factory: {
            sketch: (spec) => {
              const itemInfo = asRawOrDie$1("menu.spec item", itemSchema$2, spec);
              return itemInfo.builder(itemInfo);
            }
          },
          name: "items",
          unit: "item",
          defaults: (detail, u) => {
            return has$2(u, "uid") ? u : {
              ...u,
              uid: generate$4("item")
            };
          },
          overrides: (detail, u) => {
            return {
              type: u.type,
              ignoreFocus: detail.fakeFocus,
              domModification: {
                classes: [detail.markers.item]
              }
            };
          }
        })
      ]);
      const schema$j = constant$1([
        optionString("role"),
        required$1("value"),
        required$1("items"),
        required$1("dom"),
        required$1("components"),
        defaulted("eventOrder", {}),
        field("menuBehaviours", [Highlighting, Representing, Composing, Keying]),
        defaultedOf("movement", {
          // When you don't specify movement for a Menu, this is what you get
          // a "menu" type of movement that moves on tab. If you want finer-grained
          // control, like disabling moveOnTab, then you need to specify
          // your entire movement configuration when creating your MenuSpec.
          mode: "menu",
          moveOnTab: true
        }, choose$1("mode", {
          grid: [
            initSize(),
            output$1("config", configureGrid)
          ],
          matrix: [
            output$1("config", configureMatrix),
            required$1("rowSelector"),
            defaulted("previousSelector", Optional.none)
          ],
          menu: [
            defaulted("moveOnTab", true),
            output$1("config", configureMenu)
          ]
        })),
        itemMarkers(),
        defaulted("fakeFocus", false),
        defaulted("focusManager", dom$2()),
        onHandler("onHighlight"),
        onHandler("onDehighlight"),
        defaulted("showMenuRole", true)
      ]);
      const focus = constant$1("alloy.menu-focus");
      const deselectOtherRadioItems = (menu2, item2) => {
        const checkedRadioItems = descendants(menu2.element, '[role="menuitemradio"][aria-checked="true"]');
        each$1(checkedRadioItems, (ele) => {
          if (!eq(ele, item2.element)) {
            menu2.getSystem().getByDom(ele).each((c) => {
              Toggling.off(c);
            });
          }
        });
      };
      const make$6 = (detail, components2, _spec, _externals) => ({
        uid: detail.uid,
        dom: detail.dom,
        markers: detail.markers,
        behaviours: augment(detail.menuBehaviours, [
          Highlighting.config({
            // Highlighting for a menu is selecting items inside the menu
            highlightClass: detail.markers.selectedItem,
            itemClass: detail.markers.item,
            onHighlight: detail.onHighlight,
            onDehighlight: detail.onDehighlight
          }),
          Representing.config({
            store: {
              mode: "memory",
              initialValue: detail.value
            }
          }),
          Composing.config({
            find: Optional.some
          }),
          Keying.config(detail.movement.config(detail, detail.movement))
        ]),
        events: derive$2([
          // This is dispatched from a menu to tell an item to be highlighted.
          run$1(focus$1(), (menu2, simulatedEvent) => {
            const event = simulatedEvent.event;
            menu2.getSystem().getByDom(event.target).each((item2) => {
              Highlighting.highlight(menu2, item2);
              simulatedEvent.stop();
              emitWith(menu2, focus(), { menu: menu2, item: item2 });
            });
          }),
          // Highlight the item that the cursor is over. The onHighlight
          // code needs to handle updating focus if required
          run$1(hover(), (menu2, simulatedEvent) => {
            const item2 = simulatedEvent.event.item;
            Highlighting.highlight(menu2, item2);
          }),
          // Enforce only a single radio menu item is toggled by finding any other toggled
          // radio menu items and untoggling them when a certain item is toggled
          run$1(toggled(), (menu2, simulatedEvent) => {
            const { item: item2, state } = simulatedEvent.event;
            if (state && get$g(item2.element, "role") === "menuitemradio") {
              deselectOtherRadioItems(menu2, item2);
            }
          })
        ]),
        components: components2,
        eventOrder: detail.eventOrder,
        ...detail.showMenuRole ? {
          domModification: {
            attributes: {
              role: detail.role.getOr("menu")
            }
          }
        } : {}
      });
      const Menu = composite({
        name: "Menu",
        configFields: schema$j(),
        partFields: parts$e(),
        factory: make$6
      });
      const transpose$1 = (obj) => (
        // Assumes no duplicate fields.
        tupleMap(obj, (v, k) => ({ k: v, v: k }))
      );
      const trace = (items, byItem, byMenu, finish) => (
        // Given a finishing submenu (which will be the value of expansions),
        // find the triggering item, find its menu, and repeat the process. If there
        // is no triggering item, we are done.
        get$h(byMenu, finish).bind((triggerItem) => get$h(items, triggerItem).bind((triggerMenu) => {
          const rest = trace(items, byItem, byMenu, triggerMenu);
          return Optional.some([triggerMenu].concat(rest));
        })).getOr([])
      );
      const generate$2 = (menus, expansions) => {
        const items = {};
        each(menus, (menuItems, menu2) => {
          each$1(menuItems, (item2) => {
            items[item2] = menu2;
          });
        });
        const byItem = expansions;
        const byMenu = transpose$1(expansions);
        const menuPaths = map$1(byMenu, (_triggerItem, submenu) => [submenu].concat(trace(items, byItem, byMenu, submenu)));
        return map$1(items, (menu2) => get$h(menuPaths, menu2).getOr([menu2]));
      };
      const init$2 = () => {
        const expansions = Cell({});
        const menus = Cell({});
        const paths = Cell({});
        const primary2 = value$2();
        const directory = Cell({});
        const clear2 = () => {
          expansions.set({});
          menus.set({});
          paths.set({});
          primary2.clear();
        };
        const isClear = () => primary2.get().isNone();
        const setMenuBuilt = (menuName, built) => {
          menus.set({
            ...menus.get(),
            [menuName]: {
              type: "prepared",
              menu: built
            }
          });
        };
        const setContents = (sPrimary, sMenus, sExpansions, dir) => {
          primary2.set(sPrimary);
          expansions.set(sExpansions);
          menus.set(sMenus);
          directory.set(dir);
          const sPaths = generate$2(dir, sExpansions);
          paths.set(sPaths);
        };
        const getTriggeringItem = (menuValue) => find$4(expansions.get(), (v, _k) => v === menuValue);
        const getTriggerData = (menuValue, getItemByValue, path2) => getPreparedMenu(menuValue).bind((menu2) => getTriggeringItem(menuValue).bind((triggeringItemValue) => getItemByValue(triggeringItemValue).map((triggeredItem) => ({
          triggeredMenu: menu2,
          triggeringItem: triggeredItem,
          triggeringPath: path2
        }))));
        const getTriggeringPath = (itemValue, getItemByValue) => {
          const extraPath = filter$2(lookupItem(itemValue).toArray(), (menuValue) => getPreparedMenu(menuValue).isSome());
          return get$h(paths.get(), itemValue).bind((path2) => {
            const revPath = reverse(extraPath.concat(path2));
            const triggers = bind$3(revPath, (menuValue, menuIndex) => (
              // finding menuValue, it should match the trigger
              getTriggerData(menuValue, getItemByValue, revPath.slice(0, menuIndex + 1)).fold(() => is$1(primary2.get(), menuValue) ? [] : [Optional.none()], (data) => [Optional.some(data)])
            ));
            return sequence(triggers);
          });
        };
        const expand2 = (itemValue) => get$h(expansions.get(), itemValue).map((menu2) => {
          const current = get$h(paths.get(), itemValue).getOr([]);
          return [menu2].concat(current);
        });
        const collapse = (itemValue) => (
          // Look up which key has the itemValue
          get$h(paths.get(), itemValue).bind((path2) => path2.length > 1 ? Optional.some(path2.slice(1)) : Optional.none())
        );
        const refresh2 = (itemValue) => get$h(paths.get(), itemValue);
        const getPreparedMenu = (menuValue) => lookupMenu(menuValue).bind(extractPreparedMenu);
        const lookupMenu = (menuValue) => get$h(menus.get(), menuValue);
        const lookupItem = (itemValue) => get$h(expansions.get(), itemValue);
        const otherMenus = (path2) => {
          const menuValues = directory.get();
          return difference(keys(menuValues), path2);
        };
        const getPrimary = () => primary2.get().bind(getPreparedMenu);
        const getMenus2 = () => menus.get();
        return {
          setMenuBuilt,
          setContents,
          expand: expand2,
          refresh: refresh2,
          collapse,
          lookupMenu,
          lookupItem,
          otherMenus,
          getPrimary,
          getMenus: getMenus2,
          clear: clear2,
          isClear,
          getTriggeringPath
        };
      };
      const extractPreparedMenu = (prep) => prep.type === "prepared" ? Optional.some(prep.menu) : Optional.none();
      const LayeredState = {
        init: init$2,
        extractPreparedMenu
      };
      const onMenuItemHighlightedEvent = generate$6("tiered-menu-item-highlight");
      const onMenuItemDehighlightedEvent = generate$6("tiered-menu-item-dehighlight");
      const make$5 = (detail, _rawUiSpec) => {
        const submenuParentItems = value$2();
        const buildMenus = (container, primaryName, menus) => map$1(menus, (spec, name2) => {
          const makeSketch = () => Menu.sketch({
            ...spec,
            value: name2,
            // The TieredMenu markers should be inherited by the Menu. "Markers" are things like
            // what is the class for the currently selected item
            markers: detail.markers,
            // If the TieredMenu has been configured with FakeFocus, it needs the menus that it generates
            // to preserve that configuration. Generally, FakeFocus is used for situations where the user
            // wants to keep focus inside some editable element (like an input, or editor content)
            fakeFocus: detail.fakeFocus,
            // The TieredMenu detail.onHighlight function only relates to selecting an item,
            // not a menu, and the menuComp it is passed is the menu, not the tiered menu.
            // This makes it a difficult handler to use for a tieredmenu, so we are
            // deprecating it.
            onHighlight: (menuComp, itemComp) => {
              const highlightData = {
                menuComp,
                itemComp
              };
              emitWith(menuComp, onMenuItemHighlightedEvent, highlightData);
            },
            onDehighlight: (menuComp, itemComp) => {
              const dehighlightData = {
                menuComp,
                itemComp
              };
              emitWith(menuComp, onMenuItemDehighlightedEvent, dehighlightData);
            },
            // The Menu itself doesn't set the focusManager based on the value of fakeFocus. It only uses
            // its fakeFocus configuration for creating items that ignore focus, but it still needs to be
            // told which focusManager to use. Perhaps we should change this, though it does allow for more
            // complex focusManagers in single menus.
            focusManager: detail.fakeFocus ? highlights() : dom$2()
          });
          return name2 === primaryName ? {
            type: "prepared",
            menu: container.getSystem().build(makeSketch())
          } : {
            type: "notbuilt",
            nbMenu: makeSketch
          };
        });
        const layeredState = LayeredState.init();
        const setup2 = (container) => {
          const componentMap = buildMenus(container, detail.data.primary, detail.data.menus);
          const directory = toDirectory();
          layeredState.setContents(detail.data.primary, componentMap, detail.data.expansions, directory);
          return layeredState.getPrimary();
        };
        const getItemValue = (item2) => Representing.getValue(item2).value;
        const getItemByValue = (_container, menus, itemValue) => (
          // Can *greatly* improve the performance of this by calculating things up front.
          findMap(menus, (menu2) => {
            if (!menu2.getSystem().isConnected()) {
              return Optional.none();
            }
            const candidates = Highlighting.getCandidates(menu2);
            return find$5(candidates, (c) => getItemValue(c) === itemValue);
          })
        );
        const toDirectory = (_container) => map$1(detail.data.menus, (data, _menuName) => bind$3(data.items, (item2) => item2.type === "separator" ? [] : [item2.data.value]));
        const setActiveMenu = Highlighting.highlight;
        const setActiveMenuAndItem = (container, menu2) => {
          setActiveMenu(container, menu2);
          Highlighting.getHighlighted(menu2).orThunk(() => Highlighting.getFirst(menu2)).each((item2) => {
            if (detail.fakeFocus) {
              Highlighting.highlight(menu2, item2);
            } else {
              dispatch(container, item2.element, focusItem());
            }
          });
        };
        const getMenus2 = (state, menuValues) => cat(map$2(menuValues, (mv) => state.lookupMenu(mv).bind((prep) => prep.type === "prepared" ? Optional.some(prep.menu) : Optional.none())));
        const closeOthers = (container, state, path2) => {
          const others = getMenus2(state, state.otherMenus(path2));
          each$1(others, (o) => {
            remove$2(o.element, [detail.markers.backgroundMenu]);
            if (!detail.stayInDom) {
              Replacing.remove(container, o);
            }
          });
        };
        const getSubmenuParents = (container) => submenuParentItems.get().getOrThunk(() => {
          const r2 = {};
          const items = descendants(container.element, `.${detail.markers.item}`);
          const parentItems = filter$2(items, (i) => get$g(i, "aria-haspopup") === "true");
          each$1(parentItems, (i) => {
            container.getSystem().getByDom(i).each((itemComp) => {
              const key = getItemValue(itemComp);
              r2[key] = itemComp;
            });
          });
          submenuParentItems.set(r2);
          return r2;
        });
        const updateAriaExpansions = (container, path2) => {
          const parentItems = getSubmenuParents(container);
          each(parentItems, (v, k) => {
            const expanded = contains$2(path2, k);
            set$9(v.element, "aria-expanded", expanded);
          });
        };
        const updateMenuPath = (container, state, path2) => Optional.from(path2[0]).bind((latestMenuName) => state.lookupMenu(latestMenuName).bind((menuPrep) => {
          if (menuPrep.type === "notbuilt") {
            return Optional.none();
          } else {
            const activeMenu = menuPrep.menu;
            const rest = getMenus2(state, path2.slice(1));
            each$1(rest, (r2) => {
              add$2(r2.element, detail.markers.backgroundMenu);
            });
            if (!inBody(activeMenu.element)) {
              Replacing.append(container, premade(activeMenu));
            }
            remove$2(activeMenu.element, [detail.markers.backgroundMenu]);
            setActiveMenuAndItem(container, activeMenu);
            closeOthers(container, state, path2);
            return Optional.some(activeMenu);
          }
        }));
        let ExpandHighlightDecision;
        (function(ExpandHighlightDecision2) {
          ExpandHighlightDecision2[ExpandHighlightDecision2["HighlightSubmenu"] = 0] = "HighlightSubmenu";
          ExpandHighlightDecision2[ExpandHighlightDecision2["HighlightParent"] = 1] = "HighlightParent";
        })(ExpandHighlightDecision || (ExpandHighlightDecision = {}));
        const buildIfRequired = (container, menuName, menuPrep) => {
          if (menuPrep.type === "notbuilt") {
            const menu2 = container.getSystem().build(menuPrep.nbMenu());
            layeredState.setMenuBuilt(menuName, menu2);
            return menu2;
          } else {
            return menuPrep.menu;
          }
        };
        const expandRight = (container, item2, decision = ExpandHighlightDecision.HighlightSubmenu) => {
          if (item2.hasConfigured(Disabling) && Disabling.isDisabled(item2)) {
            return Optional.some(item2);
          } else {
            const value2 = getItemValue(item2);
            return layeredState.expand(value2).bind((path2) => {
              updateAriaExpansions(container, path2);
              return Optional.from(path2[0]).bind((menuName) => layeredState.lookupMenu(menuName).bind((activeMenuPrep) => {
                const activeMenu = buildIfRequired(container, menuName, activeMenuPrep);
                if (!inBody(activeMenu.element)) {
                  Replacing.append(container, premade(activeMenu));
                }
                detail.onOpenSubmenu(container, item2, activeMenu, reverse(path2));
                if (decision === ExpandHighlightDecision.HighlightSubmenu) {
                  Highlighting.highlightFirst(activeMenu);
                  return updateMenuPath(container, layeredState, path2);
                } else {
                  Highlighting.dehighlightAll(activeMenu);
                  return Optional.some(item2);
                }
              }));
            });
          }
        };
        const collapseLeft = (container, item2) => {
          const value2 = getItemValue(item2);
          return layeredState.collapse(value2).bind((path2) => {
            updateAriaExpansions(container, path2);
            return updateMenuPath(container, layeredState, path2).map((activeMenu) => {
              detail.onCollapseMenu(container, item2, activeMenu);
              return activeMenu;
            });
          });
        };
        const updateView = (container, item2) => {
          const value2 = getItemValue(item2);
          return layeredState.refresh(value2).bind((path2) => {
            updateAriaExpansions(container, path2);
            return updateMenuPath(container, layeredState, path2);
          });
        };
        const onRight2 = (container, item2) => inside(item2.element) ? Optional.none() : expandRight(container, item2, ExpandHighlightDecision.HighlightSubmenu);
        const onLeft2 = (container, item2) => (
          // Exclude inputs, textareas etc.
          inside(item2.element) ? Optional.none() : collapseLeft(container, item2)
        );
        const onEscape = (container, item2) => collapseLeft(container, item2).orThunk(
          () => detail.onEscape(container, item2).map(() => container)
          // This should only fire when the user presses ESC ... not any other close.
        );
        const keyOnItem = (f2) => (container, simulatedEvent) => {
          return closest$3(simulatedEvent.getSource(), `.${detail.markers.item}`).bind((target) => container.getSystem().getByDom(target).toOptional().bind((item2) => f2(container, item2).map(always)));
        };
        const events2 = derive$2([
          // Set "active-menu" for the menu with focus
          run$1(focus(), (tmenu, simulatedEvent) => {
            const item2 = simulatedEvent.event.item;
            layeredState.lookupItem(getItemValue(item2)).each(() => {
              const menu2 = simulatedEvent.event.menu;
              Highlighting.highlight(tmenu, menu2);
              const value2 = getItemValue(simulatedEvent.event.item);
              layeredState.refresh(value2).each((path2) => closeOthers(tmenu, layeredState, path2));
            });
          }),
          runOnExecute$1((component, simulatedEvent) => {
            const target = simulatedEvent.event.target;
            component.getSystem().getByDom(target).each((item2) => {
              const itemValue = getItemValue(item2);
              if (itemValue.indexOf("collapse-item") === 0) {
                collapseLeft(component, item2);
              }
              expandRight(component, item2, ExpandHighlightDecision.HighlightSubmenu).fold(() => {
                detail.onExecute(component, item2);
              }, noop);
            });
          }),
          // Open the menu as soon as it is added to the DOM
          runOnAttached((container, _simulatedEvent) => {
            setup2(container).each((primary2) => {
              Replacing.append(container, premade(primary2));
              detail.onOpenMenu(container, primary2);
              if (detail.highlightOnOpen === HighlightOnOpen.HighlightMenuAndItem) {
                setActiveMenuAndItem(container, primary2);
              } else if (detail.highlightOnOpen === HighlightOnOpen.HighlightJustMenu) {
                setActiveMenu(container, primary2);
              }
            });
          }),
          // Listen to the events bubbling up from menu about highlighting, and trigger
          // our handlers with tmenu, menu and item
          run$1(onMenuItemHighlightedEvent, (tmenuComp, se) => {
            detail.onHighlightItem(tmenuComp, se.event.menuComp, se.event.itemComp);
          }),
          run$1(onMenuItemDehighlightedEvent, (tmenuComp, se) => {
            detail.onDehighlightItem(tmenuComp, se.event.menuComp, se.event.itemComp);
          }),
          ...detail.navigateOnHover ? [
            // Hide any irrelevant submenus and expand any submenus based
            // on hovered item
            run$1(hover(), (tmenu, simulatedEvent) => {
              const item2 = simulatedEvent.event.item;
              updateView(tmenu, item2);
              expandRight(tmenu, item2, ExpandHighlightDecision.HighlightParent);
              detail.onHover(tmenu, item2);
            })
          ] : []
        ]);
        const getActiveItem = (container) => Highlighting.getHighlighted(container).bind(Highlighting.getHighlighted);
        const collapseMenuApi = (container) => {
          getActiveItem(container).each((currentItem) => {
            collapseLeft(container, currentItem);
          });
        };
        const highlightPrimary = (container) => {
          layeredState.getPrimary().each((primary2) => {
            setActiveMenuAndItem(container, primary2);
          });
        };
        const extractMenuFromContainer = (container) => Optional.from(container.components()[0]).filter((comp) => get$g(comp.element, "role") === "menu");
        const repositionMenus2 = (container) => {
          const maybeActivePrimary = layeredState.getPrimary().bind((primary2) => (
            // Get the triggering path (item, menu) up to the active item
            getActiveItem(container).bind((currentItem) => {
              const itemValue = getItemValue(currentItem);
              const allMenus = values(layeredState.getMenus());
              const preparedMenus = cat(map$2(allMenus, LayeredState.extractPreparedMenu));
              return layeredState.getTriggeringPath(itemValue, (v) => getItemByValue(container, preparedMenus, v));
            }).map((triggeringPath) => ({ primary: primary2, triggeringPath }))
          ));
          maybeActivePrimary.fold(() => {
            extractMenuFromContainer(container).each((primaryMenu) => {
              detail.onRepositionMenu(container, primaryMenu, []);
            });
          }, ({ primary: primary2, triggeringPath }) => {
            detail.onRepositionMenu(container, primary2, triggeringPath);
          });
        };
        const apis = {
          collapseMenu: collapseMenuApi,
          highlightPrimary,
          repositionMenus: repositionMenus2
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          markers: detail.markers,
          behaviours: augment(detail.tmenuBehaviours, [
            Keying.config({
              mode: "special",
              onRight: keyOnItem(onRight2),
              onLeft: keyOnItem(onLeft2),
              onEscape: keyOnItem(onEscape),
              focusIn: (container, _keyInfo) => {
                layeredState.getPrimary().each((primary2) => {
                  dispatch(container, primary2.element, focusItem());
                });
              }
            }),
            // Highlighting is used for highlighting the active menu
            Highlighting.config({
              highlightClass: detail.markers.selectedMenu,
              itemClass: detail.markers.menu
            }),
            Composing.config({
              find: (container) => {
                return Highlighting.getHighlighted(container);
              }
            }),
            Replacing.config({})
          ]),
          eventOrder: detail.eventOrder,
          apis,
          events: events2
        };
      };
      const collapseItem$1 = constant$1("collapse-item");
      const tieredData = (primary2, menus, expansions) => ({
        primary: primary2,
        menus,
        expansions
      });
      const singleData = (name2, menu2) => ({
        primary: name2,
        menus: wrap(name2, menu2),
        expansions: {}
      });
      const collapseItem = (text2) => ({
        value: generate$6(collapseItem$1()),
        meta: {
          text: text2
        }
      });
      const tieredMenu = single({
        name: "TieredMenu",
        configFields: [
          onStrictKeyboardHandler("onExecute"),
          onStrictKeyboardHandler("onEscape"),
          onStrictHandler("onOpenMenu"),
          onStrictHandler("onOpenSubmenu"),
          onHandler("onRepositionMenu"),
          onHandler("onCollapseMenu"),
          // Ideally, we should validate that this is a valid value, but
          // this is an number-based enum, so it would just be a number.
          defaulted("highlightOnOpen", HighlightOnOpen.HighlightMenuAndItem),
          requiredObjOf("data", [
            required$1("primary"),
            required$1("menus"),
            required$1("expansions")
          ]),
          defaulted("fakeFocus", false),
          onHandler("onHighlightItem"),
          onHandler("onDehighlightItem"),
          onHandler("onHover"),
          tieredMenuMarkers(),
          required$1("dom"),
          defaulted("navigateOnHover", true),
          defaulted("stayInDom", false),
          field("tmenuBehaviours", [Keying, Highlighting, Composing, Replacing]),
          defaulted("eventOrder", {})
        ],
        apis: {
          collapseMenu: (apis, tmenu) => {
            apis.collapseMenu(tmenu);
          },
          // This will highlight the primary menu AND an item in the primary menu
          // Do not use just to set the active menu.
          highlightPrimary: (apis, tmenu) => {
            apis.highlightPrimary(tmenu);
          },
          repositionMenus: (apis, tmenu) => {
            apis.repositionMenus(tmenu);
          }
        },
        factory: make$5,
        extraApis: {
          tieredData,
          singleData,
          collapseItem
        }
      });
      const suffix = constant$1("sink");
      const partType = constant$1(optional({
        name: suffix(),
        overrides: constant$1({
          dom: {
            tag: "div"
          },
          behaviours: derive$1([
            Positioning.config({
              // TODO: Make an internal sink also be able to be used with relative layouts
              useFixed: always
            })
          ]),
          events: derive$2([
            // Sinks should not let keydown or click propagate
            cutter(keydown()),
            cutter(mousedown()),
            cutter(click())
          ])
        })
      }));
      const schema$i = objOfOnly([
        defaulted("isExtraPart", never),
        optionObjOf("fireEventInstead", [
          defaulted("event", dismissRequested())
        ])
      ]);
      const receivingChannel$1 = (rawSpec) => {
        const detail = asRawOrDie$1("Dismissal", schema$i, rawSpec);
        return {
          [dismissPopups()]: {
            schema: objOfOnly([
              required$1("target")
            ]),
            onReceive: (sandbox, data) => {
              if (Sandboxing.isOpen(sandbox)) {
                const isPart = Sandboxing.isPartOf(sandbox, data.target) || detail.isExtraPart(sandbox, data.target);
                if (!isPart) {
                  detail.fireEventInstead.fold(() => Sandboxing.close(sandbox), (fe) => emit(sandbox, fe.event));
                }
              }
            }
          }
        };
      };
      const schema$h = objOfOnly([
        optionObjOf("fireEventInstead", [
          defaulted("event", repositionRequested())
        ]),
        requiredFunction("doReposition")
      ]);
      const receivingChannel = (rawSpec) => {
        const detail = asRawOrDie$1("Reposition", schema$h, rawSpec);
        return {
          [repositionPopups()]: {
            onReceive: (sandbox) => {
              if (Sandboxing.isOpen(sandbox)) {
                detail.fireEventInstead.fold(() => detail.doReposition(sandbox), (fe) => emit(sandbox, fe.event));
              }
            }
          }
        };
      };
      const getAnchor = (detail, component) => {
        const hotspot = detail.getHotspot(component).getOr(component);
        const type2 = "hotspot";
        const overrides = detail.getAnchorOverrides();
        return detail.layouts.fold(() => ({ type: type2, hotspot, overrides }), (layouts2) => ({ type: type2, hotspot, overrides, layouts: layouts2 }));
      };
      const fetch$1 = (detail, mapFetch, component) => {
        const fetcher = detail.fetch;
        return fetcher(component).map(mapFetch);
      };
      const openF = (detail, mapFetch, anchor2, component, sandbox, externals, highlightOnOpen) => {
        const futureData = fetch$1(detail, mapFetch, component);
        const getLazySink = getSink(component, detail);
        return futureData.map((tdata) => tdata.bind((data) => {
          const primaryMenu = data.menus[data.primary];
          Optional.from(primaryMenu).each((menu2) => {
            detail.listRole.each((listRole) => {
              menu2.role = listRole;
            });
          });
          return Optional.from(tieredMenu.sketch({
            // Externals are configured by the "menu" part. It's called external because it isn't contained
            // within the DOM descendants of the dropdown. You can configure things like `fakeFocus` here.
            ...externals.menu(),
            uid: generate$4(""),
            data,
            highlightOnOpen,
            onOpenMenu: (tmenu, menu2) => {
              const sink = getLazySink().getOrDie();
              Positioning.position(sink, menu2, { anchor: anchor2 });
              Sandboxing.decloak(sandbox);
            },
            onOpenSubmenu: (tmenu, item2, submenu) => {
              const sink = getLazySink().getOrDie();
              Positioning.position(sink, submenu, {
                anchor: {
                  type: "submenu",
                  item: item2
                }
              });
              Sandboxing.decloak(sandbox);
            },
            onRepositionMenu: (tmenu, primaryMenu2, submenuTriggers) => {
              const sink = getLazySink().getOrDie();
              Positioning.position(sink, primaryMenu2, { anchor: anchor2 });
              each$1(submenuTriggers, (st) => {
                Positioning.position(sink, st.triggeredMenu, {
                  anchor: { type: "submenu", item: st.triggeringItem }
                });
              });
            },
            onEscape: () => {
              Focusing.focus(component);
              Sandboxing.close(sandbox);
              return Optional.some(true);
            }
          }));
        }));
      };
      const open = (detail, mapFetch, hotspot, sandbox, externals, onOpenSync, highlightOnOpen) => {
        const anchor2 = getAnchor(detail, hotspot);
        const processed = openF(detail, mapFetch, anchor2, hotspot, sandbox, externals, highlightOnOpen);
        return processed.map((tdata) => {
          tdata.fold(() => {
            if (Sandboxing.isOpen(sandbox)) {
              Sandboxing.close(sandbox);
            }
          }, (data) => {
            Sandboxing.cloak(sandbox);
            Sandboxing.open(sandbox, data);
            onOpenSync(sandbox);
          });
          return sandbox;
        });
      };
      const close = (detail, mapFetch, component, sandbox, _externals, _onOpenSync, _highlightOnOpen) => {
        Sandboxing.close(sandbox);
        return Future.pure(sandbox);
      };
      const togglePopup = (detail, mapFetch, hotspot, externals, onOpenSync, highlightOnOpen) => {
        const sandbox = Coupling.getCoupled(hotspot, "sandbox");
        const showing = Sandboxing.isOpen(sandbox);
        const action = showing ? close : open;
        return action(detail, mapFetch, hotspot, sandbox, externals, onOpenSync, highlightOnOpen);
      };
      const matchWidth = (hotspot, container, useMinWidth) => {
        const menu2 = Composing.getCurrent(container).getOr(container);
        const buttonWidth = get$c(hotspot.element);
        if (useMinWidth) {
          set$7(menu2.element, "min-width", buttonWidth + "px");
        } else {
          set$6(menu2.element, buttonWidth);
        }
      };
      const getSink = (anyInSystem, sinkDetail) => anyInSystem.getSystem().getByUid(sinkDetail.uid + "-" + suffix()).map((internalSink) => () => Result.value(internalSink)).getOrThunk(() => sinkDetail.lazySink.fold(() => () => Result.error(new Error("No internal sink is specified, nor could an external sink be found")), (lazySinkFn) => () => lazySinkFn(anyInSystem)));
      const doRepositionMenus = (sandbox) => {
        Sandboxing.getState(sandbox).each((tmenu) => {
          tieredMenu.repositionMenus(tmenu);
        });
      };
      const makeSandbox$1 = (detail, hotspot, extras) => {
        const ariaControls = manager();
        const onOpen = (component, menu2) => {
          const anchor2 = getAnchor(detail, hotspot);
          ariaControls.link(hotspot.element);
          if (detail.matchWidth) {
            matchWidth(anchor2.hotspot, menu2, detail.useMinWidth);
          }
          detail.onOpen(anchor2, component, menu2);
          if (extras !== void 0 && extras.onOpen !== void 0) {
            extras.onOpen(component, menu2);
          }
        };
        const onClose = (component, menu2) => {
          ariaControls.unlink(hotspot.element);
          lazySink().getOr(menu2).element.dom.dispatchEvent(new window.FocusEvent("focusout"));
          if (extras !== void 0 && extras.onClose !== void 0) {
            extras.onClose(component, menu2);
          }
        };
        const lazySink = getSink(hotspot, detail);
        return {
          dom: {
            tag: "div",
            classes: detail.sandboxClasses,
            // TODO: Add aria-selected attribute
            attributes: {
              id: ariaControls.id
            }
          },
          behaviours: SketchBehaviours.augment(detail.sandboxBehaviours, [
            Representing.config({
              store: {
                mode: "memory",
                initialValue: hotspot
              }
            }),
            Sandboxing.config({
              onOpen,
              onClose,
              isPartOf: (container, data, queryElem) => {
                return isPartOf(data, queryElem) || isPartOf(hotspot, queryElem);
              },
              getAttachPoint: () => {
                return lazySink().getOrDie();
              }
            }),
            // The Composing of the dropdown here is the the active menu of the TieredMenu
            // inside the sandbox.
            Composing.config({
              find: (sandbox) => {
                return Sandboxing.getState(sandbox).bind((menu2) => Composing.getCurrent(menu2));
              }
            }),
            Receiving.config({
              channels: {
                ...receivingChannel$1({
                  isExtraPart: never
                }),
                ...receivingChannel({
                  doReposition: doRepositionMenus
                })
              }
            })
          ])
        };
      };
      const repositionMenus = (comp) => {
        const sandbox = Coupling.getCoupled(comp, "sandbox");
        doRepositionMenus(sandbox);
      };
      const sandboxFields = () => [
        defaulted("sandboxClasses", []),
        SketchBehaviours.field("sandboxBehaviours", [Composing, Receiving, Sandboxing, Representing])
      ];
      const schema$g = constant$1([
        required$1("dom"),
        required$1("fetch"),
        onHandler("onOpen"),
        onKeyboardHandler("onExecute"),
        defaulted("getHotspot", Optional.some),
        defaulted("getAnchorOverrides", constant$1({})),
        schema$o(),
        field("dropdownBehaviours", [Toggling, Coupling, Keying, Focusing]),
        required$1("toggleClass"),
        defaulted("eventOrder", {}),
        option$3("lazySink"),
        defaulted("matchWidth", false),
        defaulted("useMinWidth", false),
        option$3("role"),
        option$3("listRole")
      ].concat(sandboxFields()));
      const parts$d = constant$1([
        external$1({
          schema: [
            tieredMenuMarkers(),
            // Defining a defaulted field isn't necessary when dealing with
            // external parts, because the post-boulder part spec is not passed
            // through to any of these functions (defaults, overrides etc.). So all
            // this does is make it a bit clearer what you should expect, but remember
            // that the default value here is irrelevant!
            defaulted("fakeFocus", false)
          ],
          name: "menu",
          defaults: (detail) => {
            return {
              onExecute: detail.onExecute
            };
          }
        }),
        partType()
      ]);
      const factory$l = (detail, components2, _spec, externals) => {
        const lookupAttr = (attr) => get$h(detail.dom, "attributes").bind((attrs) => get$h(attrs, attr));
        const switchToMenu = (sandbox) => {
          Sandboxing.getState(sandbox).each((tmenu) => {
            tieredMenu.highlightPrimary(tmenu);
          });
        };
        const togglePopup$1 = (dropdownComp, onOpenSync, highlightOnOpen) => {
          return togglePopup(detail, identity, dropdownComp, externals, onOpenSync, highlightOnOpen);
        };
        const action = (component) => {
          const onOpenSync = switchToMenu;
          togglePopup$1(component, onOpenSync, HighlightOnOpen.HighlightMenuAndItem).get(noop);
        };
        const apis = {
          expand: (comp) => {
            if (!Toggling.isOn(comp)) {
              togglePopup$1(comp, noop, HighlightOnOpen.HighlightNone).get(noop);
            }
          },
          open: (comp) => {
            if (!Toggling.isOn(comp)) {
              togglePopup$1(comp, noop, HighlightOnOpen.HighlightMenuAndItem).get(noop);
            }
          },
          refetch: (comp) => {
            const optSandbox = Coupling.getExistingCoupled(comp, "sandbox");
            return optSandbox.fold(() => {
              return togglePopup$1(comp, noop, HighlightOnOpen.HighlightMenuAndItem).map(noop);
            }, (sandboxComp) => {
              return open(
                detail,
                identity,
                comp,
                // NOTE: The TieredMenu is inside the sandbox. They aren't the same component.
                sandboxComp,
                externals,
                noop,
                HighlightOnOpen.HighlightMenuAndItem
              ).map(noop);
            });
          },
          isOpen: Toggling.isOn,
          close: (comp) => {
            if (Toggling.isOn(comp)) {
              togglePopup$1(comp, noop, HighlightOnOpen.HighlightMenuAndItem).get(noop);
            }
          },
          // If we are open, refresh the menus in the tiered menu system
          repositionMenus: (comp) => {
            if (Toggling.isOn(comp)) {
              repositionMenus(comp);
            }
          }
        };
        const triggerExecute = (comp, _se) => {
          emitExecute(comp);
          return Optional.some(true);
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: augment(detail.dropdownBehaviours, [
            Toggling.config({
              toggleClass: detail.toggleClass,
              aria: {
                mode: "expanded"
              }
            }),
            Coupling.config({
              others: {
                sandbox: (hotspot) => {
                  return makeSandbox$1(detail, hotspot, {
                    onOpen: () => Toggling.on(hotspot),
                    onClose: () => Toggling.off(hotspot)
                  });
                }
              }
            }),
            Keying.config({
              mode: "special",
              onSpace: triggerExecute,
              onEnter: triggerExecute,
              onDown: (comp, _se) => {
                if (Dropdown.isOpen(comp)) {
                  const sandbox = Coupling.getCoupled(comp, "sandbox");
                  switchToMenu(sandbox);
                } else {
                  Dropdown.open(comp);
                }
                return Optional.some(true);
              },
              onEscape: (comp, _se) => {
                if (Dropdown.isOpen(comp)) {
                  Dropdown.close(comp);
                  return Optional.some(true);
                } else {
                  return Optional.none();
                }
              }
            }),
            Focusing.config({})
          ]),
          events: events(Optional.some(action)),
          eventOrder: {
            ...detail.eventOrder,
            // Order, the button state is toggled first, so assumed !selected means close.
            [execute$5()]: ["disabling", "toggling", "alloy.base.behaviour"]
          },
          apis,
          domModification: {
            attributes: {
              "aria-haspopup": detail.listRole.getOr("true"),
              ...detail.role.fold(() => ({}), (role) => ({ role })),
              ...detail.dom.tag === "button" ? { type: lookupAttr("type").getOr("button") } : {}
            }
          }
        };
      };
      const Dropdown = composite({
        name: "Dropdown",
        configFields: schema$g(),
        partFields: parts$d(),
        factory: factory$l,
        apis: {
          open: (apis, comp) => apis.open(comp),
          refetch: (apis, comp) => apis.refetch(comp),
          expand: (apis, comp) => apis.expand(comp),
          close: (apis, comp) => apis.close(comp),
          isOpen: (apis, comp) => apis.isOpen(comp),
          repositionMenus: (apis, comp) => apis.repositionMenus(comp)
        }
      });
      const owner$1 = "form";
      const schema$f = [
        field("formBehaviours", [Representing])
      ];
      const getPartName$1 = (name2) => "<alloy.field." + name2 + ">";
      const sketch$2 = (fSpec) => {
        const parts2 = (() => {
          const record2 = [];
          const field2 = (name2, config2) => {
            record2.push(name2);
            return generateOne$1(owner$1, getPartName$1(name2), config2);
          };
          return {
            field: field2,
            record: constant$1(record2)
          };
        })();
        const spec = fSpec(parts2);
        const partNames = parts2.record();
        const fieldParts = map$2(partNames, (n) => required({ name: n, pname: getPartName$1(n) }));
        return composite$1(owner$1, schema$f, fieldParts, make$4, spec);
      };
      const toResult = (o, e) => o.fold(() => Result.error(e), Result.value);
      const make$4 = (detail, components2) => ({
        uid: detail.uid,
        dom: detail.dom,
        components: components2,
        // Form has an assumption that every field must have composing, and that the composed element has representing.
        behaviours: augment(detail.formBehaviours, [
          Representing.config({
            store: {
              mode: "manual",
              getValue: (form) => {
                const resPs = getAllParts(form, detail);
                return map$1(resPs, (resPThunk, pName) => resPThunk().bind((v) => {
                  const opt = Composing.getCurrent(v);
                  return toResult(opt, new Error(`Cannot find a current component to extract the value from for form part '${pName}': ` + element(v.element)));
                }).map(Representing.getValue));
              },
              setValue: (form, values2) => {
                each(values2, (newValue, key) => {
                  getPart(form, detail, key).each((wrapper) => {
                    Composing.getCurrent(wrapper).each((field2) => {
                      Representing.setValue(field2, newValue);
                    });
                  });
                });
              }
            }
          })
        ]),
        apis: {
          getField: (form, key) => {
            return getPart(form, detail, key).bind(Composing.getCurrent);
          }
        }
      });
      const Form = {
        getField: makeApi((apis, component, key) => apis.getField(component, key)),
        sketch: sketch$2
      };
      const schema$e = constant$1([
        required$1("dom"),
        defaulted("shell", true),
        field("toolbarBehaviours", [Replacing])
      ]);
      const enhanceGroups = () => ({
        behaviours: derive$1([
          Replacing.config({})
        ])
      });
      const parts$c = constant$1([
        // Note, is the container for putting all the groups in, not a group itself.
        optional({
          name: "groups",
          overrides: enhanceGroups
        })
      ]);
      const factory$k = (detail, components2, _spec, _externals) => {
        const setGroups2 = (toolbar, groups) => {
          getGroupContainer(toolbar).fold(() => {
            console.error("Toolbar was defined to not be a shell, but no groups container was specified in components");
            throw new Error("Toolbar was defined to not be a shell, but no groups container was specified in components");
          }, (container) => {
            Replacing.set(container, groups);
          });
        };
        const getGroupContainer = (component) => detail.shell ? Optional.some(component) : getPart(component, detail, "groups");
        const extra = detail.shell ? { behaviours: [Replacing.config({})], components: [] } : { behaviours: [], components: components2 };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: extra.components,
          behaviours: augment(detail.toolbarBehaviours, extra.behaviours),
          apis: {
            setGroups: setGroups2,
            refresh: noop
          },
          domModification: {
            attributes: {
              role: "group"
            }
          }
        };
      };
      const Toolbar = composite({
        name: "Toolbar",
        configFields: schema$e(),
        partFields: parts$c(),
        factory: factory$k,
        apis: {
          setGroups: (apis, toolbar, groups) => {
            apis.setGroups(toolbar, groups);
          }
        }
      });
      const schema$d = constant$1([
        markers$1(["toggledClass"]),
        required$1("lazySink"),
        requiredFunction("fetch"),
        optionFunction("getBounds"),
        optionObjOf("fireDismissalEventInstead", [
          defaulted("event", dismissRequested())
        ]),
        schema$o(),
        onHandler("onToggled")
      ]);
      const parts$b = constant$1([
        external$1({
          name: "button",
          overrides: (detail) => ({
            dom: {
              attributes: {
                "aria-haspopup": "true"
              }
            },
            buttonBehaviours: derive$1([
              Toggling.config({
                toggleClass: detail.markers.toggledClass,
                aria: {
                  mode: "expanded"
                },
                toggleOnExecute: false,
                /**
                 * For FloatingToolbars, we can hook up our `onToggled` handler directly to the Toggling
                 * because we don't have to worry about any animations.
                 *
                 * Unfortunately, for SlidingToolbars, Toggling is more directly hooked into the animation for growing,
                 * so to have an event `onToggled` that doesn't care about the animation, we can't just hook into the Toggling config.
                 */
                onToggled: detail.onToggled
              })
            ])
          })
        }),
        external$1({
          factory: Toolbar,
          schema: schema$e(),
          name: "toolbar",
          overrides: (detail) => {
            return {
              toolbarBehaviours: derive$1([
                Keying.config({
                  mode: "cyclic",
                  onEscape: (comp) => {
                    getPart(comp, detail, "button").each(Focusing.focus);
                    return Optional.none();
                  }
                })
              ])
            };
          }
        })
      ]);
      const shouldSkipFocus = value$2();
      const toggleWithoutFocusing = (button2, externals) => {
        shouldSkipFocus.set(true);
        toggle$1(button2, externals);
        shouldSkipFocus.clear();
      };
      const toggle$1 = (button2, externals) => {
        const toolbarSandbox = Coupling.getCoupled(button2, "toolbarSandbox");
        if (Sandboxing.isOpen(toolbarSandbox)) {
          Sandboxing.close(toolbarSandbox);
        } else {
          Sandboxing.open(toolbarSandbox, externals.toolbar());
        }
      };
      const position = (button2, toolbar, detail, layouts2) => {
        const bounds2 = detail.getBounds.map((bounder) => bounder());
        const sink = detail.lazySink(button2).getOrDie();
        Positioning.positionWithinBounds(sink, toolbar, {
          anchor: {
            type: "hotspot",
            hotspot: button2,
            layouts: layouts2,
            overrides: {
              maxWidthFunction: expandable()
            }
          }
        }, bounds2);
      };
      const setGroups$1 = (button2, toolbar, detail, layouts2, groups) => {
        Toolbar.setGroups(toolbar, groups);
        position(button2, toolbar, detail, layouts2);
        Toggling.on(button2);
      };
      const makeSandbox = (button2, spec, detail) => {
        const ariaControls = manager();
        const onOpen = (sandbox, toolbar) => {
          const skipFocus = shouldSkipFocus.get().getOr(false);
          detail.fetch().get((groups) => {
            setGroups$1(button2, toolbar, detail, spec.layouts, groups);
            ariaControls.link(button2.element);
            if (!skipFocus) {
              Keying.focusIn(toolbar);
            }
          });
        };
        const onClose = () => {
          Toggling.off(button2);
          if (!shouldSkipFocus.get().getOr(false)) {
            Focusing.focus(button2);
          }
          ariaControls.unlink(button2.element);
        };
        return {
          dom: {
            tag: "div",
            attributes: {
              id: ariaControls.id
            }
          },
          behaviours: derive$1([
            Keying.config({
              mode: "special",
              onEscape: (comp) => {
                Sandboxing.close(comp);
                return Optional.some(true);
              }
            }),
            Sandboxing.config({
              onOpen,
              onClose,
              isPartOf: (container, data, queryElem) => {
                return isPartOf(data, queryElem) || isPartOf(button2, queryElem);
              },
              getAttachPoint: () => {
                return detail.lazySink(button2).getOrDie();
              }
            }),
            Receiving.config({
              channels: {
                ...receivingChannel$1({
                  isExtraPart: never,
                  ...detail.fireDismissalEventInstead.map((fe) => ({ fireEventInstead: { event: fe.event } })).getOr({})
                }),
                ...receivingChannel({
                  doReposition: () => {
                    Sandboxing.getState(Coupling.getCoupled(button2, "toolbarSandbox")).each((toolbar) => {
                      position(button2, toolbar, detail, spec.layouts);
                    });
                  }
                })
              }
            })
          ])
        };
      };
      const factory$j = (detail, components2, spec, externals) => ({
        ...Button.sketch({
          ...externals.button(),
          action: (button2) => {
            toggle$1(button2, externals);
          },
          buttonBehaviours: SketchBehaviours.augment({ dump: externals.button().buttonBehaviours }, [
            Coupling.config({
              others: {
                toolbarSandbox: (button2) => {
                  return makeSandbox(button2, spec, detail);
                }
              }
            })
          ])
        }),
        apis: {
          setGroups: (button2, groups) => {
            Sandboxing.getState(Coupling.getCoupled(button2, "toolbarSandbox")).each((toolbar) => {
              setGroups$1(button2, toolbar, detail, spec.layouts, groups);
            });
          },
          reposition: (button2) => {
            Sandboxing.getState(Coupling.getCoupled(button2, "toolbarSandbox")).each((toolbar) => {
              position(button2, toolbar, detail, spec.layouts);
            });
          },
          toggle: (button2) => {
            toggle$1(button2, externals);
          },
          toggleWithoutFocusing: (button2) => {
            toggleWithoutFocusing(button2, externals);
          },
          getToolbar: (button2) => {
            return Sandboxing.getState(Coupling.getCoupled(button2, "toolbarSandbox"));
          },
          isOpen: (button2) => {
            return Sandboxing.isOpen(Coupling.getCoupled(button2, "toolbarSandbox"));
          }
        }
      });
      const FloatingToolbarButton = composite({
        name: "FloatingToolbarButton",
        factory: factory$j,
        configFields: schema$d(),
        partFields: parts$b(),
        apis: {
          setGroups: (apis, button2, groups) => {
            apis.setGroups(button2, groups);
          },
          reposition: (apis, button2) => {
            apis.reposition(button2);
          },
          toggle: (apis, button2) => {
            apis.toggle(button2);
          },
          toggleWithoutFocusing: (apis, button2) => {
            apis.toggleWithoutFocusing(button2);
          },
          getToolbar: (apis, button2) => apis.getToolbar(button2),
          isOpen: (apis, button2) => apis.isOpen(button2)
        }
      });
      const schema$c = constant$1([
        defaulted("prefix", "form-field"),
        field("fieldBehaviours", [Composing, Representing])
      ]);
      const parts$a = constant$1([
        optional({
          schema: [required$1("dom")],
          name: "label"
        }),
        optional({
          factory: {
            sketch: (spec) => {
              return {
                uid: spec.uid,
                dom: {
                  tag: "span",
                  styles: {
                    display: "none"
                  },
                  attributes: {
                    "aria-hidden": "true"
                  },
                  innerHtml: spec.text
                }
              };
            }
          },
          schema: [required$1("text")],
          name: "aria-descriptor"
        }),
        required({
          factory: {
            sketch: (spec) => {
              const excludeFactory = exclude(spec, ["factory"]);
              return spec.factory.sketch(excludeFactory);
            }
          },
          schema: [required$1("factory")],
          name: "field"
        })
      ]);
      const factory$i = (detail, components2, _spec, _externals) => {
        const behaviours2 = augment(detail.fieldBehaviours, [
          Composing.config({
            find: (container) => {
              return getPart(container, detail, "field");
            }
          }),
          Representing.config({
            store: {
              mode: "manual",
              getValue: (field2) => {
                return Composing.getCurrent(field2).bind(Representing.getValue);
              },
              setValue: (field2, value2) => {
                Composing.getCurrent(field2).each((current) => {
                  Representing.setValue(current, value2);
                });
              }
            }
          })
        ]);
        const events2 = derive$2([
          // Used to be systemInit
          runOnAttached((component, _simulatedEvent) => {
            const ps = getParts(component, detail, ["label", "field", "aria-descriptor"]);
            ps.field().each((field2) => {
              const id = generate$6(detail.prefix);
              ps.label().each((label2) => {
                set$9(label2.element, "for", id);
                set$9(field2.element, "id", id);
              });
              ps["aria-descriptor"]().each((descriptor) => {
                const descriptorId = generate$6(detail.prefix);
                set$9(descriptor.element, "id", descriptorId);
                set$9(field2.element, "aria-describedby", descriptorId);
              });
            });
          })
        ]);
        const apis = {
          getField: (container) => getPart(container, detail, "field"),
          getLabel: (container) => (
            // TODO: Use constants for part names
            getPart(container, detail, "label")
          )
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: behaviours2,
          events: events2,
          apis
        };
      };
      const FormField = composite({
        name: "FormField",
        configFields: schema$c(),
        partFields: parts$a(),
        factory: factory$i,
        apis: {
          getField: (apis, comp) => apis.getField(comp),
          getLabel: (apis, comp) => apis.getLabel(comp)
        }
      });
      const schema$b = constant$1([
        defaulted("field1Name", "field1"),
        defaulted("field2Name", "field2"),
        onStrictHandler("onLockedChange"),
        markers$1(["lockClass"]),
        defaulted("locked", false),
        SketchBehaviours.field("coupledFieldBehaviours", [Composing, Representing]),
        defaultedFunction("onInput", noop)
      ]);
      const getField = (comp, detail, partName) => getPart(comp, detail, partName).bind(Composing.getCurrent);
      const coupledPart = (selfName, otherName) => required({
        factory: FormField,
        name: selfName,
        overrides: (detail) => {
          return {
            fieldBehaviours: derive$1([
              config("coupled-input-behaviour", [
                run$1(input(), (me) => {
                  getField(me, detail, otherName).each((other) => {
                    getPart(me, detail, "lock").each((lock) => {
                      if (Toggling.isOn(lock)) {
                        detail.onLockedChange(me, other, lock);
                      }
                      detail.onInput(me);
                    });
                  });
                })
              ])
            ])
          };
        }
      });
      const parts$9 = constant$1([
        coupledPart("field1", "field2"),
        coupledPart("field2", "field1"),
        required({
          factory: Button,
          schema: [
            required$1("dom")
          ],
          name: "lock",
          overrides: (detail) => {
            return {
              buttonBehaviours: derive$1([
                Toggling.config({
                  selected: detail.locked,
                  toggleClass: detail.markers.lockClass,
                  aria: {
                    mode: "pressed"
                  }
                })
              ])
            };
          }
        })
      ]);
      const factory$h = (detail, components2, _spec, _externals) => ({
        uid: detail.uid,
        dom: detail.dom,
        components: components2,
        behaviours: SketchBehaviours.augment(detail.coupledFieldBehaviours, [
          Composing.config({ find: Optional.some }),
          Representing.config({
            store: {
              mode: "manual",
              getValue: (comp) => {
                const parts2 = getPartsOrDie(comp, detail, ["field1", "field2"]);
                return {
                  [detail.field1Name]: Representing.getValue(parts2.field1()),
                  [detail.field2Name]: Representing.getValue(parts2.field2())
                };
              },
              setValue: (comp, value2) => {
                const parts2 = getPartsOrDie(comp, detail, ["field1", "field2"]);
                if (hasNonNullableKey(value2, detail.field1Name)) {
                  Representing.setValue(parts2.field1(), value2[detail.field1Name]);
                }
                if (hasNonNullableKey(value2, detail.field2Name)) {
                  Representing.setValue(parts2.field2(), value2[detail.field2Name]);
                }
              }
            }
          })
        ]),
        apis: {
          getField1: (component) => getPart(component, detail, "field1"),
          getField2: (component) => getPart(component, detail, "field2"),
          getLock: (component) => getPart(component, detail, "lock")
        }
      });
      const FormCoupledInputs = composite({
        name: "FormCoupledInputs",
        configFields: schema$b(),
        partFields: parts$9(),
        factory: factory$h,
        apis: {
          getField1: (apis, component) => apis.getField1(component),
          getField2: (apis, component) => apis.getField2(component),
          getLock: (apis, component) => apis.getLock(component)
        }
      });
      const factory$g = (detail, _spec) => {
        const options = map$2(detail.options, (option2) => ({
          dom: {
            tag: "option",
            value: option2.value,
            innerHtml: option2.text
          }
        }));
        const initialValues = detail.data.map((v) => wrap("initialValue", v)).getOr({});
        return {
          uid: detail.uid,
          dom: {
            tag: "select",
            classes: detail.selectClasses,
            attributes: detail.selectAttributes
          },
          components: options,
          behaviours: augment(detail.selectBehaviours, [
            Focusing.config({}),
            Representing.config({
              store: {
                mode: "manual",
                getValue: (select2) => {
                  return get$5(select2.element);
                },
                setValue: (select2, newValue) => {
                  const firstOption = head(detail.options);
                  const found = find$5(detail.options, (opt) => opt.value === newValue);
                  if (found.isSome()) {
                    set$4(select2.element, newValue);
                  } else if (select2.element.dom.selectedIndex === -1 && newValue === "") {
                    firstOption.each((value2) => set$4(select2.element, value2.value));
                  }
                },
                ...initialValues
              }
            })
          ])
        };
      };
      const HtmlSelect = single({
        name: "HtmlSelect",
        configFields: [
          required$1("options"),
          field("selectBehaviours", [Focusing, Representing]),
          defaulted("selectClasses", []),
          defaulted("selectAttributes", {}),
          option$3("data")
        ],
        factory: factory$g
      });
      const makeMenu = (detail, menuSandbox, placementSpec, menuSpec, getBounds2) => {
        const lazySink = () => detail.lazySink(menuSandbox);
        const layouts2 = menuSpec.type === "horizontal" ? { layouts: {
          onLtr: () => belowOrAbove(),
          onRtl: () => belowOrAboveRtl()
        } } : {};
        const isFirstTierSubmenu = (triggeringPaths) => triggeringPaths.length === 2;
        const getSubmenuLayouts = (triggeringPaths) => isFirstTierSubmenu(triggeringPaths) ? layouts2 : {};
        return tieredMenu.sketch({
          dom: {
            tag: "div"
          },
          data: menuSpec.data,
          markers: menuSpec.menu.markers,
          highlightOnOpen: menuSpec.menu.highlightOnOpen,
          fakeFocus: menuSpec.menu.fakeFocus,
          onEscape: () => {
            Sandboxing.close(menuSandbox);
            detail.onEscape.map((handler) => handler(menuSandbox));
            return Optional.some(true);
          },
          onExecute: () => {
            return Optional.some(true);
          },
          onOpenMenu: (tmenu, menu2) => {
            Positioning.positionWithinBounds(lazySink().getOrDie(), menu2, placementSpec, getBounds2());
          },
          onOpenSubmenu: (tmenu, item2, submenu, triggeringPaths) => {
            const sink = lazySink().getOrDie();
            Positioning.position(sink, submenu, {
              anchor: {
                type: "submenu",
                item: item2,
                ...getSubmenuLayouts(triggeringPaths)
              }
            });
          },
          onRepositionMenu: (tmenu, primaryMenu, submenuTriggers) => {
            const sink = lazySink().getOrDie();
            Positioning.positionWithinBounds(sink, primaryMenu, placementSpec, getBounds2());
            each$1(submenuTriggers, (st) => {
              const submenuLayouts = getSubmenuLayouts(st.triggeringPath);
              Positioning.position(sink, st.triggeredMenu, {
                anchor: { type: "submenu", item: st.triggeringItem, ...submenuLayouts }
              });
            });
          }
        });
      };
      const factory$f = (detail, spec) => {
        const isPartOfRelated = (sandbox, queryElem) => {
          const related = detail.getRelated(sandbox);
          return related.exists((rel) => isPartOf(rel, queryElem));
        };
        const setContent2 = (sandbox, thing) => {
          Sandboxing.setContent(sandbox, thing);
        };
        const showAt = (sandbox, thing, placementSpec) => {
          const getBounds2 = Optional.none;
          showWithinBounds(sandbox, thing, placementSpec, getBounds2);
        };
        const showWithinBounds = (sandbox, thing, placementSpec, getBounds2) => {
          const sink = detail.lazySink(sandbox).getOrDie();
          Sandboxing.openWhileCloaked(sandbox, thing, () => Positioning.positionWithinBounds(sink, sandbox, placementSpec, getBounds2()));
          Representing.setValue(sandbox, Optional.some({
            mode: "position",
            config: placementSpec,
            getBounds: getBounds2
          }));
        };
        const showMenuAt = (sandbox, placementSpec, menuSpec) => {
          showMenuWithinBounds(sandbox, placementSpec, menuSpec, Optional.none);
        };
        const showMenuWithinBounds = (sandbox, placementSpec, menuSpec, getBounds2) => {
          const menu2 = makeMenu(detail, sandbox, placementSpec, menuSpec, getBounds2);
          Sandboxing.open(sandbox, menu2);
          Representing.setValue(sandbox, Optional.some({
            mode: "menu",
            menu: menu2
          }));
        };
        const hide = (sandbox) => {
          if (Sandboxing.isOpen(sandbox)) {
            Representing.setValue(sandbox, Optional.none());
            Sandboxing.close(sandbox);
          }
        };
        const getContent = (sandbox) => Sandboxing.getState(sandbox);
        const reposition2 = (sandbox) => {
          if (Sandboxing.isOpen(sandbox)) {
            Representing.getValue(sandbox).each((state) => {
              switch (state.mode) {
                case "menu":
                  Sandboxing.getState(sandbox).each(tieredMenu.repositionMenus);
                  break;
                case "position":
                  const sink = detail.lazySink(sandbox).getOrDie();
                  Positioning.positionWithinBounds(sink, sandbox, state.config, state.getBounds());
                  break;
              }
            });
          }
        };
        const apis = {
          setContent: setContent2,
          showAt,
          showWithinBounds,
          showMenuAt,
          showMenuWithinBounds,
          hide,
          getContent,
          reposition: reposition2,
          isOpen: Sandboxing.isOpen
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          behaviours: augment(detail.inlineBehaviours, [
            Sandboxing.config({
              isPartOf: (sandbox, data, queryElem) => {
                return isPartOf(data, queryElem) || isPartOfRelated(sandbox, queryElem);
              },
              getAttachPoint: (sandbox) => {
                return detail.lazySink(sandbox).getOrDie();
              },
              onOpen: (sandbox) => {
                detail.onShow(sandbox);
              },
              onClose: (sandbox) => {
                detail.onHide(sandbox);
              }
            }),
            Representing.config({
              store: {
                mode: "memory",
                initialValue: Optional.none()
              }
            }),
            Receiving.config({
              channels: {
                ...receivingChannel$1({
                  isExtraPart: spec.isExtraPart,
                  ...detail.fireDismissalEventInstead.map((fe) => ({ fireEventInstead: { event: fe.event } })).getOr({})
                }),
                ...receivingChannel({
                  ...detail.fireRepositionEventInstead.map((fe) => ({ fireEventInstead: { event: fe.event } })).getOr({}),
                  doReposition: reposition2
                })
              }
            })
          ]),
          eventOrder: detail.eventOrder,
          apis
        };
      };
      const InlineView = single({
        name: "InlineView",
        configFields: [
          required$1("lazySink"),
          onHandler("onShow"),
          onHandler("onHide"),
          optionFunction("onEscape"),
          field("inlineBehaviours", [Sandboxing, Representing, Receiving]),
          optionObjOf("fireDismissalEventInstead", [
            defaulted("event", dismissRequested())
          ]),
          optionObjOf("fireRepositionEventInstead", [
            defaulted("event", repositionRequested())
          ]),
          defaulted("getRelated", Optional.none),
          defaulted("isExtraPart", never),
          defaulted("eventOrder", Optional.none)
        ],
        factory: factory$f,
        apis: {
          showAt: (apis, component, anchor2, thing) => {
            apis.showAt(component, anchor2, thing);
          },
          showWithinBounds: (apis, component, anchor2, thing, bounds2) => {
            apis.showWithinBounds(component, anchor2, thing, bounds2);
          },
          showMenuAt: (apis, component, anchor2, menuSpec) => {
            apis.showMenuAt(component, anchor2, menuSpec);
          },
          showMenuWithinBounds: (apis, component, anchor2, menuSpec, bounds2) => {
            apis.showMenuWithinBounds(component, anchor2, menuSpec, bounds2);
          },
          hide: (apis, component) => {
            apis.hide(component);
          },
          isOpen: (apis, component) => apis.isOpen(component),
          getContent: (apis, component) => apis.getContent(component),
          setContent: (apis, component, thing) => {
            apis.setContent(component, thing);
          },
          reposition: (apis, component) => {
            apis.reposition(component);
          }
        }
      });
      const schema$a = constant$1([
        defaultedString("type", "text"),
        option$3("data"),
        defaulted("inputAttributes", {}),
        defaulted("inputStyles", {}),
        defaulted("tag", "input"),
        defaulted("inputClasses", []),
        onHandler("onSetValue"),
        defaultedFunction("fromInputValue", identity),
        defaultedFunction("toInputValue", identity),
        defaulted("styles", {}),
        defaulted("eventOrder", {}),
        field("inputBehaviours", [Representing, Focusing]),
        defaulted("selectOnFocus", true)
      ]);
      const focusBehaviours = (detail) => derive$1([
        Focusing.config({
          onFocus: !detail.selectOnFocus ? noop : (component) => {
            const input2 = component.element;
            const value2 = get$5(input2);
            if (detail.type !== "range") {
              input2.dom.setSelectionRange(0, value2.length);
            }
          }
        })
      ]);
      const behaviours = (detail) => ({
        ...focusBehaviours(detail),
        ...augment(detail.inputBehaviours, [
          Representing.config({
            store: {
              mode: "manual",
              // Propagating its Optional
              ...detail.data.map((data) => ({ initialValue: data })).getOr({}),
              getValue: (input2) => {
                return detail.fromInputValue(get$5(input2.element));
              },
              setValue: (input2, data) => {
                const current = get$5(input2.element);
                if (current !== data) {
                  set$4(input2.element, detail.toInputValue(data));
                }
              }
            },
            onSetValue: detail.onSetValue
          })
        ])
      });
      const dom$1 = (detail) => ({
        tag: detail.tag,
        attributes: {
          type: detail.type,
          ...detail.inputAttributes
        },
        styles: detail.inputStyles,
        classes: detail.inputClasses
      });
      const factory$e = (detail, _spec) => ({
        uid: detail.uid,
        dom: dom$1(detail),
        // No children.
        components: [],
        behaviours: behaviours(detail),
        eventOrder: detail.eventOrder
      });
      const Input = single({
        name: "Input",
        configFields: schema$a(),
        factory: factory$e
      });
      const parts$8 = generate$5(owner$2(), parts$f());
      const labelledBy = (labelledElement, labelElement) => {
        const labelId = getOpt(labelledElement, "id").fold(() => {
          const id = generate$6("dialog-label");
          set$9(labelElement, "id", id);
          return id;
        }, identity);
        set$9(labelledElement, "aria-labelledby", labelId);
      };
      const schema$9 = constant$1([
        required$1("lazySink"),
        option$3("dragBlockClass"),
        defaultedFunction("getBounds", win),
        defaulted("useTabstopAt", always),
        defaulted("firstTabstop", 0),
        defaulted("eventOrder", {}),
        field("modalBehaviours", [Keying]),
        onKeyboardHandler("onExecute"),
        onStrictKeyboardHandler("onEscape")
      ]);
      const basic = { sketch: identity };
      const parts$7 = constant$1([
        optional({
          name: "draghandle",
          overrides: (detail, spec) => {
            return {
              behaviours: derive$1([
                Dragging.config({
                  mode: "mouse",
                  getTarget: (handle2) => {
                    return ancestor$1(handle2, '[role="dialog"]').getOr(handle2);
                  },
                  blockerClass: detail.dragBlockClass.getOrDie(
                    // TODO: Support errors in Optional getOrDie.
                    new Error("The drag blocker class was not specified for a dialog with a drag handle: \n" + JSON.stringify(spec, null, 2)).message
                  ),
                  getBounds: detail.getDragBounds
                })
              ])
            };
          }
        }),
        required({
          schema: [required$1("dom")],
          name: "title"
        }),
        required({
          factory: basic,
          schema: [required$1("dom")],
          name: "close"
        }),
        required({
          factory: basic,
          schema: [required$1("dom")],
          name: "body"
        }),
        optional({
          factory: basic,
          schema: [required$1("dom")],
          name: "footer"
        }),
        external$1({
          factory: {
            sketch: (spec, detail) => (
              // Merging should take care of the uid
              {
                ...spec,
                dom: detail.dom,
                components: detail.components
              }
            )
          },
          schema: [
            defaulted("dom", {
              tag: "div",
              styles: {
                position: "fixed",
                left: "0px",
                top: "0px",
                right: "0px",
                bottom: "0px"
              }
            }),
            defaulted("components", [])
          ],
          name: "blocker"
        })
      ]);
      const factory$d = (detail, components2, spec, externals) => {
        const dialogComp = value$2();
        const showDialog = (dialog) => {
          dialogComp.set(dialog);
          const sink = detail.lazySink(dialog).getOrDie();
          const externalBlocker = externals.blocker();
          const blocker = sink.getSystem().build({
            ...externalBlocker,
            components: externalBlocker.components.concat([
              premade(dialog)
            ]),
            behaviours: derive$1([
              Focusing.config({}),
              config("dialog-blocker-events", [
                // Ensure we use runOnSource otherwise this would cause an infinite loop, as `focusIn` would fire a `focusin` which would then get responded to and so forth
                runOnSource(focusin(), () => {
                  Blocking.isBlocked(dialog) ? noop() : Keying.focusIn(dialog);
                })
              ])
            ])
          });
          attach(sink, blocker);
          Keying.focusIn(dialog);
        };
        const hideDialog = (dialog) => {
          dialogComp.clear();
          parent(dialog.element).each((blockerDom) => {
            dialog.getSystem().getByDom(blockerDom).each((blocker) => {
              detach(blocker);
            });
          });
        };
        const getDialogBody = (dialog) => getPartOrDie(dialog, detail, "body");
        const getDialogFooter = (dialog) => getPart(dialog, detail, "footer");
        const setBusy = (dialog, getBusySpec2) => {
          Blocking.block(dialog, getBusySpec2);
        };
        const setIdle = (dialog) => {
          Blocking.unblock(dialog);
        };
        const modalEventsId = generate$6("modal-events");
        const eventOrder = {
          ...detail.eventOrder,
          [attachedToDom()]: [modalEventsId].concat(detail.eventOrder["alloy.system.attached"] || [])
        };
        const browser2 = detect$1();
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          apis: {
            show: showDialog,
            hide: hideDialog,
            getBody: getDialogBody,
            getFooter: getDialogFooter,
            setIdle,
            setBusy
          },
          eventOrder,
          domModification: {
            attributes: {
              "role": "dialog",
              "aria-modal": "true"
            }
          },
          behaviours: augment(detail.modalBehaviours, [
            Replacing.config({}),
            Keying.config({
              mode: "cyclic",
              onEnter: detail.onExecute,
              onEscape: detail.onEscape,
              useTabstopAt: detail.useTabstopAt,
              firstTabstop: detail.firstTabstop
            }),
            Blocking.config({
              getRoot: dialogComp.get
            }),
            config(modalEventsId, [
              runOnAttached((c) => {
                const titleElm = getPartOrDie(c, detail, "title").element;
                const title2 = get$6(titleElm);
                if (browser2.os.isMacOS() && isNonNullable(title2)) {
                  set$9(c.element, "aria-label", title2);
                } else {
                  labelledBy(c.element, titleElm);
                }
              })
            ])
          ])
        };
      };
      const ModalDialog = composite({
        name: "ModalDialog",
        configFields: schema$9(),
        partFields: parts$7(),
        factory: factory$d,
        apis: {
          show: (apis, dialog) => {
            apis.show(dialog);
          },
          hide: (apis, dialog) => {
            apis.hide(dialog);
          },
          getBody: (apis, dialog) => apis.getBody(dialog),
          getFooter: (apis, dialog) => apis.getFooter(dialog),
          setBusy: (apis, dialog, getBusySpec2) => {
            apis.setBusy(dialog, getBusySpec2);
          },
          setIdle: (apis, dialog) => {
            apis.setIdle(dialog);
          }
        }
      });
      const labelPart = optional({
        schema: [required$1("dom")],
        name: "label"
      });
      const edgePart = (name2) => optional({
        name: "" + name2 + "-edge",
        overrides: (detail) => {
          const action = detail.model.manager.edgeActions[name2];
          return action.fold(() => ({}), (a) => ({
            events: derive$2([
              runActionExtra(touchstart(), (comp, se, d) => a(comp, d), [detail]),
              runActionExtra(mousedown(), (comp, se, d) => a(comp, d), [detail]),
              runActionExtra(mousemove(), (comp, se, det) => {
                if (det.mouseIsDown.get()) {
                  a(comp, det);
                }
              }, [detail])
            ])
          }));
        }
      });
      const tlEdgePart = edgePart("top-left");
      const tedgePart = edgePart("top");
      const trEdgePart = edgePart("top-right");
      const redgePart = edgePart("right");
      const brEdgePart = edgePart("bottom-right");
      const bedgePart = edgePart("bottom");
      const blEdgePart = edgePart("bottom-left");
      const ledgePart = edgePart("left");
      const thumbPart = required({
        name: "thumb",
        defaults: constant$1({
          dom: {
            styles: { position: "absolute" }
          }
        }),
        overrides: (detail) => {
          return {
            events: derive$2([
              // If the user touches the thumb itself, pretend they touched the spectrum instead. This
              // allows sliding even when they touchstart the current value
              redirectToPart(touchstart(), detail, "spectrum"),
              redirectToPart(touchmove(), detail, "spectrum"),
              redirectToPart(touchend(), detail, "spectrum"),
              redirectToPart(mousedown(), detail, "spectrum"),
              redirectToPart(mousemove(), detail, "spectrum"),
              redirectToPart(mouseup(), detail, "spectrum")
            ])
          };
        }
      });
      const isShift = (event) => isShift$1(event.event);
      const spectrumPart = required({
        schema: [
          customField("mouseIsDown", () => Cell(false))
        ],
        name: "spectrum",
        overrides: (detail) => {
          const modelDetail = detail.model;
          const model = modelDetail.manager;
          const setValueFrom2 = (component, simulatedEvent) => model.getValueFromEvent(simulatedEvent).map((value2) => model.setValueFrom(component, detail, value2));
          return {
            behaviours: derive$1([
              // Move left and right along the spectrum
              Keying.config({
                mode: "special",
                onLeft: (spectrum, event) => model.onLeft(spectrum, detail, isShift(event)),
                onRight: (spectrum, event) => model.onRight(spectrum, detail, isShift(event)),
                onUp: (spectrum, event) => model.onUp(spectrum, detail, isShift(event)),
                onDown: (spectrum, event) => model.onDown(spectrum, detail, isShift(event))
              }),
              Tabstopping.config({}),
              Focusing.config({})
            ]),
            events: derive$2([
              run$1(touchstart(), setValueFrom2),
              run$1(touchmove(), setValueFrom2),
              run$1(mousedown(), setValueFrom2),
              run$1(mousemove(), (spectrum, se) => {
                if (detail.mouseIsDown.get()) {
                  setValueFrom2(spectrum, se);
                }
              })
            ])
          };
        }
      });
      var SliderParts = [
        labelPart,
        ledgePart,
        redgePart,
        tedgePart,
        bedgePart,
        tlEdgePart,
        trEdgePart,
        blEdgePart,
        brEdgePart,
        thumbPart,
        spectrumPart
      ];
      const _sliderChangeEvent = "slider.change.value";
      const sliderChangeEvent = constant$1(_sliderChangeEvent);
      const isTouchEvent$2 = (evt) => evt.type.indexOf("touch") !== -1;
      const getEventSource = (simulatedEvent) => {
        const evt = simulatedEvent.event.raw;
        if (isTouchEvent$2(evt)) {
          const touchEvent = evt;
          return touchEvent.touches !== void 0 && touchEvent.touches.length === 1 ? Optional.some(touchEvent.touches[0]).map((t2) => SugarPosition(t2.clientX, t2.clientY)) : Optional.none();
        } else {
          const mouseEvent = evt;
          return mouseEvent.clientX !== void 0 ? Optional.some(mouseEvent).map((me) => SugarPosition(me.clientX, me.clientY)) : Optional.none();
        }
      };
      const t = "top", r = "right", b = "bottom", l = "left";
      const minX = (detail) => detail.model.minX;
      const minY = (detail) => detail.model.minY;
      const min1X = (detail) => detail.model.minX - 1;
      const min1Y = (detail) => detail.model.minY - 1;
      const maxX = (detail) => detail.model.maxX;
      const maxY = (detail) => detail.model.maxY;
      const max1X = (detail) => detail.model.maxX + 1;
      const max1Y = (detail) => detail.model.maxY + 1;
      const range = (detail, max2, min2) => max2(detail) - min2(detail);
      const xRange = (detail) => range(detail, maxX, minX);
      const yRange = (detail) => range(detail, maxY, minY);
      const halfX = (detail) => xRange(detail) / 2;
      const halfY = (detail) => yRange(detail) / 2;
      const step = (detail, useMultiplier) => useMultiplier ? detail.stepSize * detail.speedMultiplier : detail.stepSize;
      const snap = (detail) => detail.snapToGrid;
      const snapStart = (detail) => detail.snapStart;
      const rounded = (detail) => detail.rounded;
      const hasEdge = (detail, edgeName) => detail[edgeName + "-edge"] !== void 0;
      const hasLEdge = (detail) => hasEdge(detail, l);
      const hasREdge = (detail) => hasEdge(detail, r);
      const hasTEdge = (detail) => hasEdge(detail, t);
      const hasBEdge = (detail) => hasEdge(detail, b);
      const currentValue = (detail) => detail.model.value.get();
      const xyValue = (x, y) => ({
        x,
        y
      });
      const fireSliderChange$3 = (component, value2) => {
        emitWith(component, sliderChangeEvent(), { value: value2 });
      };
      const setToTLEdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(min1X(detail), min1Y(detail)));
      };
      const setToTEdge = (edge2, detail) => {
        fireSliderChange$3(edge2, min1Y(detail));
      };
      const setToTEdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(halfX(detail), min1Y(detail)));
      };
      const setToTREdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(max1X(detail), min1Y(detail)));
      };
      const setToREdge = (edge2, detail) => {
        fireSliderChange$3(edge2, max1X(detail));
      };
      const setToREdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(max1X(detail), halfY(detail)));
      };
      const setToBREdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(max1X(detail), max1Y(detail)));
      };
      const setToBEdge = (edge2, detail) => {
        fireSliderChange$3(edge2, max1Y(detail));
      };
      const setToBEdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(halfX(detail), max1Y(detail)));
      };
      const setToBLEdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(min1X(detail), max1Y(detail)));
      };
      const setToLEdge = (edge2, detail) => {
        fireSliderChange$3(edge2, min1X(detail));
      };
      const setToLEdgeXY = (edge2, detail) => {
        fireSliderChange$3(edge2, xyValue(min1X(detail), halfY(detail)));
      };
      const reduceBy = (value2, min2, max2, step2) => {
        if (value2 < min2) {
          return value2;
        } else if (value2 > max2) {
          return max2;
        } else if (value2 === min2) {
          return min2 - 1;
        } else {
          return Math.max(min2, value2 - step2);
        }
      };
      const increaseBy = (value2, min2, max2, step2) => {
        if (value2 > max2) {
          return value2;
        } else if (value2 < min2) {
          return min2;
        } else if (value2 === max2) {
          return max2 + 1;
        } else {
          return Math.min(max2, value2 + step2);
        }
      };
      const capValue = (value2, min2, max2) => Math.max(min2, Math.min(max2, value2));
      const snapValueOf = (value2, min2, max2, step2, snapStart2) => (
        // We are snapping by the step size. Therefore, find the nearest multiple of
        // the step
        snapStart2.fold(() => {
          const initValue = value2 - min2;
          const extraValue = Math.round(initValue / step2) * step2;
          return capValue(min2 + extraValue, min2 - 1, max2 + 1);
        }, (start) => {
          const remainder = (value2 - start) % step2;
          const adjustment = Math.round(remainder / step2);
          const rawSteps = Math.floor((value2 - start) / step2);
          const maxSteps = Math.floor((max2 - start) / step2);
          const numSteps = Math.min(maxSteps, rawSteps + adjustment);
          const r2 = start + numSteps * step2;
          return Math.max(start, r2);
        })
      );
      const findOffsetOf = (value2, min2, max2) => Math.min(max2, Math.max(value2, min2)) - min2;
      const findValueOf = (args) => {
        const { min: min2, max: max2, range: range2, value: value2, step: step2, snap: snap2, snapStart: snapStart2, rounded: rounded2, hasMinEdge, hasMaxEdge, minBound, maxBound, screenRange } = args;
        const capMin = hasMinEdge ? min2 - 1 : min2;
        const capMax = hasMaxEdge ? max2 + 1 : max2;
        if (value2 < minBound) {
          return capMin;
        } else if (value2 > maxBound) {
          return capMax;
        } else {
          const offset2 = findOffsetOf(value2, minBound, maxBound);
          const newValue = capValue(offset2 / screenRange * range2 + min2, capMin, capMax);
          if (snap2 && newValue >= min2 && newValue <= max2) {
            return snapValueOf(newValue, min2, max2, step2, snapStart2);
          } else if (rounded2) {
            return Math.round(newValue);
          } else {
            return newValue;
          }
        }
      };
      const findOffsetOfValue$2 = (args) => {
        const { min: min2, max: max2, range: range2, value: value2, hasMinEdge, hasMaxEdge, maxBound, maxOffset, centerMinEdge, centerMaxEdge } = args;
        if (value2 < min2) {
          return hasMinEdge ? 0 : centerMinEdge;
        } else if (value2 > max2) {
          return hasMaxEdge ? maxBound : centerMaxEdge;
        } else {
          return (value2 - min2) / range2 * maxOffset;
        }
      };
      const top = "top", right = "right", bottom = "bottom", left = "left", width = "width", height = "height";
      const getBounds = (component) => component.element.dom.getBoundingClientRect();
      const getBoundsProperty = (bounds2, property) => bounds2[property];
      const getMinXBounds = (component) => {
        const bounds2 = getBounds(component);
        return getBoundsProperty(bounds2, left);
      };
      const getMaxXBounds = (component) => {
        const bounds2 = getBounds(component);
        return getBoundsProperty(bounds2, right);
      };
      const getMinYBounds = (component) => {
        const bounds2 = getBounds(component);
        return getBoundsProperty(bounds2, top);
      };
      const getMaxYBounds = (component) => {
        const bounds2 = getBounds(component);
        return getBoundsProperty(bounds2, bottom);
      };
      const getXScreenRange = (component) => {
        const bounds2 = getBounds(component);
        return getBoundsProperty(bounds2, width);
      };
      const getYScreenRange = (component) => {
        const bounds2 = getBounds(component);
        return getBoundsProperty(bounds2, height);
      };
      const getCenterOffsetOf = (componentMinEdge, componentMaxEdge, spectrumMinEdge) => (componentMinEdge + componentMaxEdge) / 2 - spectrumMinEdge;
      const getXCenterOffSetOf = (component, spectrum) => {
        const componentBounds = getBounds(component);
        const spectrumBounds = getBounds(spectrum);
        const componentMinEdge = getBoundsProperty(componentBounds, left);
        const componentMaxEdge = getBoundsProperty(componentBounds, right);
        const spectrumMinEdge = getBoundsProperty(spectrumBounds, left);
        return getCenterOffsetOf(componentMinEdge, componentMaxEdge, spectrumMinEdge);
      };
      const getYCenterOffSetOf = (component, spectrum) => {
        const componentBounds = getBounds(component);
        const spectrumBounds = getBounds(spectrum);
        const componentMinEdge = getBoundsProperty(componentBounds, top);
        const componentMaxEdge = getBoundsProperty(componentBounds, bottom);
        const spectrumMinEdge = getBoundsProperty(spectrumBounds, top);
        return getCenterOffsetOf(componentMinEdge, componentMaxEdge, spectrumMinEdge);
      };
      const fireSliderChange$2 = (spectrum, value2) => {
        emitWith(spectrum, sliderChangeEvent(), { value: value2 });
      };
      const findValueOfOffset$1 = (spectrum, detail, left2) => {
        const args = {
          min: minX(detail),
          max: maxX(detail),
          range: xRange(detail),
          value: left2,
          step: step(detail),
          snap: snap(detail),
          snapStart: snapStart(detail),
          rounded: rounded(detail),
          hasMinEdge: hasLEdge(detail),
          hasMaxEdge: hasREdge(detail),
          minBound: getMinXBounds(spectrum),
          maxBound: getMaxXBounds(spectrum),
          screenRange: getXScreenRange(spectrum)
        };
        return findValueOf(args);
      };
      const setValueFrom$2 = (spectrum, detail, value2) => {
        const xValue = findValueOfOffset$1(spectrum, detail, value2);
        const sliderVal = xValue;
        fireSliderChange$2(spectrum, sliderVal);
        return xValue;
      };
      const setToMin$2 = (spectrum, detail) => {
        const min2 = minX(detail);
        fireSliderChange$2(spectrum, min2);
      };
      const setToMax$2 = (spectrum, detail) => {
        const max2 = maxX(detail);
        fireSliderChange$2(spectrum, max2);
      };
      const moveBy$2 = (direction, spectrum, detail, useMultiplier) => {
        const f2 = direction > 0 ? increaseBy : reduceBy;
        const xValue = f2(currentValue(detail), minX(detail), maxX(detail), step(detail, useMultiplier));
        fireSliderChange$2(spectrum, xValue);
        return Optional.some(xValue);
      };
      const handleMovement$2 = (direction) => (spectrum, detail, useMultiplier) => moveBy$2(direction, spectrum, detail, useMultiplier).map(always);
      const getValueFromEvent$2 = (simulatedEvent) => {
        const pos = getEventSource(simulatedEvent);
        return pos.map((p) => p.left);
      };
      const findOffsetOfValue$1 = (spectrum, detail, value2, minEdge, maxEdge) => {
        const minOffset = 0;
        const maxOffset = getXScreenRange(spectrum);
        const centerMinEdge = minEdge.bind((edge2) => Optional.some(getXCenterOffSetOf(edge2, spectrum))).getOr(minOffset);
        const centerMaxEdge = maxEdge.bind((edge2) => Optional.some(getXCenterOffSetOf(edge2, spectrum))).getOr(maxOffset);
        const args = {
          min: minX(detail),
          max: maxX(detail),
          range: xRange(detail),
          value: value2,
          hasMinEdge: hasLEdge(detail),
          hasMaxEdge: hasREdge(detail),
          minBound: getMinXBounds(spectrum),
          minOffset,
          maxBound: getMaxXBounds(spectrum),
          maxOffset,
          centerMinEdge,
          centerMaxEdge
        };
        return findOffsetOfValue$2(args);
      };
      const findPositionOfValue$1 = (slider, spectrum, value2, minEdge, maxEdge, detail) => {
        const offset2 = findOffsetOfValue$1(spectrum, detail, value2, minEdge, maxEdge);
        return getMinXBounds(spectrum) - getMinXBounds(slider) + offset2;
      };
      const setPositionFromValue$2 = (slider, thumb, detail, edges) => {
        const value2 = currentValue(detail);
        const pos = findPositionOfValue$1(slider, edges.getSpectrum(slider), value2, edges.getLeftEdge(slider), edges.getRightEdge(slider), detail);
        const thumbRadius = get$c(thumb.element) / 2;
        set$7(thumb.element, "left", pos - thumbRadius + "px");
      };
      const onLeft$2 = handleMovement$2(-1);
      const onRight$2 = handleMovement$2(1);
      const onUp$2 = Optional.none;
      const onDown$2 = Optional.none;
      const edgeActions$2 = {
        "top-left": Optional.none(),
        "top": Optional.none(),
        "top-right": Optional.none(),
        "right": Optional.some(setToREdge),
        "bottom-right": Optional.none(),
        "bottom": Optional.none(),
        "bottom-left": Optional.none(),
        "left": Optional.some(setToLEdge)
      };
      var HorizontalModel = Object.freeze({
        __proto__: null,
        setValueFrom: setValueFrom$2,
        setToMin: setToMin$2,
        setToMax: setToMax$2,
        findValueOfOffset: findValueOfOffset$1,
        getValueFromEvent: getValueFromEvent$2,
        findPositionOfValue: findPositionOfValue$1,
        setPositionFromValue: setPositionFromValue$2,
        onLeft: onLeft$2,
        onRight: onRight$2,
        onUp: onUp$2,
        onDown: onDown$2,
        edgeActions: edgeActions$2
      });
      const fireSliderChange$1 = (spectrum, value2) => {
        emitWith(spectrum, sliderChangeEvent(), { value: value2 });
      };
      const findValueOfOffset = (spectrum, detail, top2) => {
        const args = {
          min: minY(detail),
          max: maxY(detail),
          range: yRange(detail),
          value: top2,
          step: step(detail),
          snap: snap(detail),
          snapStart: snapStart(detail),
          rounded: rounded(detail),
          hasMinEdge: hasTEdge(detail),
          hasMaxEdge: hasBEdge(detail),
          minBound: getMinYBounds(spectrum),
          maxBound: getMaxYBounds(spectrum),
          screenRange: getYScreenRange(spectrum)
        };
        return findValueOf(args);
      };
      const setValueFrom$1 = (spectrum, detail, value2) => {
        const yValue = findValueOfOffset(spectrum, detail, value2);
        const sliderVal = yValue;
        fireSliderChange$1(spectrum, sliderVal);
        return yValue;
      };
      const setToMin$1 = (spectrum, detail) => {
        const min2 = minY(detail);
        fireSliderChange$1(spectrum, min2);
      };
      const setToMax$1 = (spectrum, detail) => {
        const max2 = maxY(detail);
        fireSliderChange$1(spectrum, max2);
      };
      const moveBy$1 = (direction, spectrum, detail, useMultiplier) => {
        const f2 = direction > 0 ? increaseBy : reduceBy;
        const yValue = f2(currentValue(detail), minY(detail), maxY(detail), step(detail, useMultiplier));
        fireSliderChange$1(spectrum, yValue);
        return Optional.some(yValue);
      };
      const handleMovement$1 = (direction) => (spectrum, detail, useMultiplier) => moveBy$1(direction, spectrum, detail, useMultiplier).map(always);
      const getValueFromEvent$1 = (simulatedEvent) => {
        const pos = getEventSource(simulatedEvent);
        return pos.map((p) => {
          return p.top;
        });
      };
      const findOffsetOfValue = (spectrum, detail, value2, minEdge, maxEdge) => {
        const minOffset = 0;
        const maxOffset = getYScreenRange(spectrum);
        const centerMinEdge = minEdge.bind((edge2) => Optional.some(getYCenterOffSetOf(edge2, spectrum))).getOr(minOffset);
        const centerMaxEdge = maxEdge.bind((edge2) => Optional.some(getYCenterOffSetOf(edge2, spectrum))).getOr(maxOffset);
        const args = {
          min: minY(detail),
          max: maxY(detail),
          range: yRange(detail),
          value: value2,
          hasMinEdge: hasTEdge(detail),
          hasMaxEdge: hasBEdge(detail),
          minBound: getMinYBounds(spectrum),
          minOffset,
          maxBound: getMaxYBounds(spectrum),
          maxOffset,
          centerMinEdge,
          centerMaxEdge
        };
        return findOffsetOfValue$2(args);
      };
      const findPositionOfValue = (slider, spectrum, value2, minEdge, maxEdge, detail) => {
        const offset2 = findOffsetOfValue(spectrum, detail, value2, minEdge, maxEdge);
        return getMinYBounds(spectrum) - getMinYBounds(slider) + offset2;
      };
      const setPositionFromValue$1 = (slider, thumb, detail, edges) => {
        const value2 = currentValue(detail);
        const pos = findPositionOfValue(slider, edges.getSpectrum(slider), value2, edges.getTopEdge(slider), edges.getBottomEdge(slider), detail);
        const thumbRadius = get$d(thumb.element) / 2;
        set$7(thumb.element, "top", pos - thumbRadius + "px");
      };
      const onLeft$1 = Optional.none;
      const onRight$1 = Optional.none;
      const onUp$1 = handleMovement$1(-1);
      const onDown$1 = handleMovement$1(1);
      const edgeActions$1 = {
        "top-left": Optional.none(),
        "top": Optional.some(setToTEdge),
        "top-right": Optional.none(),
        "right": Optional.none(),
        "bottom-right": Optional.none(),
        "bottom": Optional.some(setToBEdge),
        "bottom-left": Optional.none(),
        "left": Optional.none()
      };
      var VerticalModel = Object.freeze({
        __proto__: null,
        setValueFrom: setValueFrom$1,
        setToMin: setToMin$1,
        setToMax: setToMax$1,
        findValueOfOffset,
        getValueFromEvent: getValueFromEvent$1,
        findPositionOfValue,
        setPositionFromValue: setPositionFromValue$1,
        onLeft: onLeft$1,
        onRight: onRight$1,
        onUp: onUp$1,
        onDown: onDown$1,
        edgeActions: edgeActions$1
      });
      const fireSliderChange = (spectrum, value2) => {
        emitWith(spectrum, sliderChangeEvent(), { value: value2 });
      };
      const sliderValue = (x, y) => ({
        x,
        y
      });
      const setValueFrom = (spectrum, detail, value2) => {
        const xValue = findValueOfOffset$1(spectrum, detail, value2.left);
        const yValue = findValueOfOffset(spectrum, detail, value2.top);
        const val = sliderValue(xValue, yValue);
        fireSliderChange(spectrum, val);
        return val;
      };
      const moveBy = (direction, isVerticalMovement, spectrum, detail, useMultiplier) => {
        const f2 = direction > 0 ? increaseBy : reduceBy;
        const xValue = isVerticalMovement ? currentValue(detail).x : f2(currentValue(detail).x, minX(detail), maxX(detail), step(detail, useMultiplier));
        const yValue = !isVerticalMovement ? currentValue(detail).y : f2(currentValue(detail).y, minY(detail), maxY(detail), step(detail, useMultiplier));
        fireSliderChange(spectrum, sliderValue(xValue, yValue));
        return Optional.some(xValue);
      };
      const handleMovement = (direction, isVerticalMovement) => (spectrum, detail, useMultiplier) => moveBy(direction, isVerticalMovement, spectrum, detail, useMultiplier).map(always);
      const setToMin = (spectrum, detail) => {
        const mX = minX(detail);
        const mY = minY(detail);
        fireSliderChange(spectrum, sliderValue(mX, mY));
      };
      const setToMax = (spectrum, detail) => {
        const mX = maxX(detail);
        const mY = maxY(detail);
        fireSliderChange(spectrum, sliderValue(mX, mY));
      };
      const getValueFromEvent = (simulatedEvent) => getEventSource(simulatedEvent);
      const setPositionFromValue = (slider, thumb, detail, edges) => {
        const value2 = currentValue(detail);
        const xPos = findPositionOfValue$1(slider, edges.getSpectrum(slider), value2.x, edges.getLeftEdge(slider), edges.getRightEdge(slider), detail);
        const yPos = findPositionOfValue(slider, edges.getSpectrum(slider), value2.y, edges.getTopEdge(slider), edges.getBottomEdge(slider), detail);
        const thumbXRadius = get$c(thumb.element) / 2;
        const thumbYRadius = get$d(thumb.element) / 2;
        set$7(thumb.element, "left", xPos - thumbXRadius + "px");
        set$7(thumb.element, "top", yPos - thumbYRadius + "px");
      };
      const onLeft = handleMovement(-1, false);
      const onRight = handleMovement(1, false);
      const onUp = handleMovement(-1, true);
      const onDown = handleMovement(1, true);
      const edgeActions = {
        "top-left": Optional.some(setToTLEdgeXY),
        "top": Optional.some(setToTEdgeXY),
        "top-right": Optional.some(setToTREdgeXY),
        "right": Optional.some(setToREdgeXY),
        "bottom-right": Optional.some(setToBREdgeXY),
        "bottom": Optional.some(setToBEdgeXY),
        "bottom-left": Optional.some(setToBLEdgeXY),
        "left": Optional.some(setToLEdgeXY)
      };
      var TwoDModel = Object.freeze({
        __proto__: null,
        setValueFrom,
        setToMin,
        setToMax,
        getValueFromEvent,
        setPositionFromValue,
        onLeft,
        onRight,
        onUp,
        onDown,
        edgeActions
      });
      const SliderSchema = [
        defaulted("stepSize", 1),
        defaulted("speedMultiplier", 10),
        defaulted("onChange", noop),
        defaulted("onChoose", noop),
        defaulted("onInit", noop),
        defaulted("onDragStart", noop),
        defaulted("onDragEnd", noop),
        defaulted("snapToGrid", false),
        defaulted("rounded", true),
        option$3("snapStart"),
        requiredOf("model", choose$1("mode", {
          x: [
            defaulted("minX", 0),
            defaulted("maxX", 100),
            customField("value", (spec) => Cell(spec.mode.minX)),
            required$1("getInitialValue"),
            output$1("manager", HorizontalModel)
          ],
          y: [
            defaulted("minY", 0),
            defaulted("maxY", 100),
            customField("value", (spec) => Cell(spec.mode.minY)),
            required$1("getInitialValue"),
            output$1("manager", VerticalModel)
          ],
          xy: [
            defaulted("minX", 0),
            defaulted("maxX", 100),
            defaulted("minY", 0),
            defaulted("maxY", 100),
            customField("value", (spec) => Cell({
              x: spec.mode.minX,
              y: spec.mode.minY
            })),
            required$1("getInitialValue"),
            output$1("manager", TwoDModel)
          ]
        })),
        field("sliderBehaviours", [Keying, Representing]),
        customField("mouseIsDown", () => Cell(false))
      ];
      const sketch$1 = (detail, components2, _spec, _externals) => {
        const getThumb = (component) => getPartOrDie(component, detail, "thumb");
        const getSpectrum = (component) => getPartOrDie(component, detail, "spectrum");
        const getLeftEdge = (component) => getPart(component, detail, "left-edge");
        const getRightEdge = (component) => getPart(component, detail, "right-edge");
        const getTopEdge = (component) => getPart(component, detail, "top-edge");
        const getBottomEdge = (component) => getPart(component, detail, "bottom-edge");
        const modelDetail = detail.model;
        const model = modelDetail.manager;
        const refresh2 = (slider, thumb) => {
          model.setPositionFromValue(slider, thumb, detail, {
            getLeftEdge,
            getRightEdge,
            getTopEdge,
            getBottomEdge,
            getSpectrum
          });
        };
        const setValue2 = (slider, newValue) => {
          modelDetail.value.set(newValue);
          const thumb = getThumb(slider);
          refresh2(slider, thumb);
        };
        const changeValue = (slider, newValue) => {
          setValue2(slider, newValue);
          const thumb = getThumb(slider);
          detail.onChange(slider, thumb, newValue);
          return Optional.some(true);
        };
        const resetToMin = (slider) => {
          model.setToMin(slider, detail);
        };
        const resetToMax = (slider) => {
          model.setToMax(slider, detail);
        };
        const choose2 = (slider) => {
          const fireOnChoose = () => {
            getPart(slider, detail, "thumb").each((thumb) => {
              const value2 = modelDetail.value.get();
              detail.onChoose(slider, thumb, value2);
            });
          };
          const wasDown = detail.mouseIsDown.get();
          detail.mouseIsDown.set(false);
          if (wasDown) {
            fireOnChoose();
          }
        };
        const onDragStart = (slider, simulatedEvent) => {
          simulatedEvent.stop();
          detail.mouseIsDown.set(true);
          detail.onDragStart(slider, getThumb(slider));
        };
        const onDragEnd = (slider, simulatedEvent) => {
          simulatedEvent.stop();
          detail.onDragEnd(slider, getThumb(slider));
          choose2(slider);
        };
        const focusWidget = (component) => {
          getPart(component, detail, "spectrum").map(Keying.focusIn);
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: augment(detail.sliderBehaviours, [
            Keying.config({
              mode: "special",
              focusIn: focusWidget
            }),
            Representing.config({
              store: {
                mode: "manual",
                getValue: (_) => {
                  return modelDetail.value.get();
                },
                setValue: setValue2
              }
            }),
            Receiving.config({
              channels: {
                [mouseReleased()]: {
                  onReceive: choose2
                }
              }
            })
          ]),
          events: derive$2([
            run$1(sliderChangeEvent(), (slider, simulatedEvent) => {
              changeValue(slider, simulatedEvent.event.value);
            }),
            runOnAttached((slider, _simulatedEvent) => {
              const getInitial = modelDetail.getInitialValue();
              modelDetail.value.set(getInitial);
              const thumb = getThumb(slider);
              refresh2(slider, thumb);
              const spectrum = getSpectrum(slider);
              detail.onInit(slider, thumb, spectrum, modelDetail.value.get());
            }),
            run$1(touchstart(), onDragStart),
            run$1(touchend(), onDragEnd),
            run$1(mousedown(), (component, event) => {
              focusWidget(component);
              onDragStart(component, event);
            }),
            run$1(mouseup(), onDragEnd)
          ]),
          apis: {
            resetToMin,
            resetToMax,
            setValue: setValue2,
            refresh: refresh2
          },
          domModification: {
            styles: {
              position: "relative"
            }
          }
        };
      };
      const Slider = composite({
        name: "Slider",
        configFields: SliderSchema,
        partFields: SliderParts,
        factory: sketch$1,
        apis: {
          setValue: (apis, slider, value2) => {
            apis.setValue(slider, value2);
          },
          resetToMin: (apis, slider) => {
            apis.resetToMin(slider);
          },
          resetToMax: (apis, slider) => {
            apis.resetToMax(slider);
          },
          refresh: (apis, slider) => {
            apis.refresh(slider);
          }
        }
      });
      const owner = "container";
      const schema$8 = [
        field("slotBehaviours", [])
      ];
      const getPartName = (name2) => "<alloy.field." + name2 + ">";
      const sketch = (sSpec) => {
        const parts2 = (() => {
          const record2 = [];
          const slot = (name2, config2) => {
            record2.push(name2);
            return generateOne$1(owner, getPartName(name2), config2);
          };
          return {
            slot,
            record: constant$1(record2)
          };
        })();
        const spec = sSpec(parts2);
        const partNames = parts2.record();
        const fieldParts = map$2(partNames, (n) => required({ name: n, pname: getPartName(n) }));
        return composite$1(owner, schema$8, fieldParts, make$3, spec);
      };
      const make$3 = (detail, components2) => {
        const getSlotNames = (_) => getAllPartNames(detail);
        const getSlot = (container, key) => getPart(container, detail, key);
        const onSlot = (f2, def) => (container, key) => getPart(container, detail, key).map((slot) => f2(slot, key)).getOr(def);
        const onSlots = (f2) => (container, keys2) => {
          each$1(keys2, (key) => f2(container, key));
        };
        const doShowing = (comp, _key) => get$g(comp.element, "aria-hidden") !== "true";
        const doShow = (comp, key) => {
          if (!doShowing(comp)) {
            const element2 = comp.element;
            remove$6(element2, "display");
            remove$8(element2, "aria-hidden");
            emitWith(comp, slotVisibility(), { name: key, visible: true });
          }
        };
        const doHide = (comp, key) => {
          if (doShowing(comp)) {
            const element2 = comp.element;
            set$7(element2, "display", "none");
            set$9(element2, "aria-hidden", "true");
            emitWith(comp, slotVisibility(), { name: key, visible: false });
          }
        };
        const isShowing = onSlot(doShowing, false);
        const hideSlot = onSlot(doHide);
        const hideSlots = onSlots(hideSlot);
        const hideAllSlots = (container) => hideSlots(container, getSlotNames());
        const showSlot = onSlot(doShow);
        const apis = {
          getSlotNames,
          getSlot,
          isShowing,
          hideSlot,
          hideAllSlots,
          showSlot
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: get$2(detail.slotBehaviours),
          apis
        };
      };
      const slotApis = map$1({
        getSlotNames: (apis, c) => apis.getSlotNames(c),
        getSlot: (apis, c, key) => apis.getSlot(c, key),
        isShowing: (apis, c, key) => apis.isShowing(c, key),
        hideSlot: (apis, c, key) => apis.hideSlot(c, key),
        hideAllSlots: (apis, c) => apis.hideAllSlots(c),
        showSlot: (apis, c, key) => apis.showSlot(c, key)
      }, (value2) => makeApi(value2));
      const SlotContainer = {
        ...slotApis,
        ...{ sketch }
      };
      const schema$7 = constant$1([
        required$1("toggleClass"),
        required$1("fetch"),
        onStrictHandler("onExecute"),
        defaulted("getHotspot", Optional.some),
        defaulted("getAnchorOverrides", constant$1({})),
        schema$o(),
        onStrictHandler("onItemExecute"),
        option$3("lazySink"),
        required$1("dom"),
        onHandler("onOpen"),
        field("splitDropdownBehaviours", [Coupling, Keying, Focusing]),
        defaulted("matchWidth", false),
        defaulted("useMinWidth", false),
        defaulted("eventOrder", {}),
        option$3("role"),
        option$3("listRole")
      ].concat(sandboxFields()));
      const arrowPart = required({
        factory: Button,
        schema: [required$1("dom")],
        name: "arrow",
        defaults: () => {
          return {
            buttonBehaviours: derive$1([
              // TODO: Remove all traces of revoking
              Focusing.revoke()
            ])
          };
        },
        overrides: (detail) => {
          return {
            dom: {
              tag: "span",
              attributes: {
                role: "presentation"
              }
            },
            action: (arrow) => {
              arrow.getSystem().getByUid(detail.uid).each(emitExecute);
            },
            buttonBehaviours: derive$1([
              Toggling.config({
                toggleOnExecute: false,
                toggleClass: detail.toggleClass
              })
            ])
          };
        }
      });
      const buttonPart = required({
        factory: Button,
        schema: [required$1("dom")],
        name: "button",
        defaults: () => {
          return {
            buttonBehaviours: derive$1([
              // TODO: Remove all traces of revoking
              Focusing.revoke()
            ])
          };
        },
        overrides: (detail) => {
          return {
            dom: {
              tag: "span",
              attributes: {
                role: "presentation"
              }
            },
            action: (btn) => {
              btn.getSystem().getByUid(detail.uid).each((splitDropdown) => {
                detail.onExecute(splitDropdown, btn);
              });
            }
          };
        }
      });
      const parts$6 = constant$1([
        arrowPart,
        buttonPart,
        optional({
          factory: {
            sketch: (spec) => {
              return {
                uid: spec.uid,
                dom: {
                  tag: "span",
                  styles: {
                    display: "none"
                  },
                  attributes: {
                    "aria-hidden": "true"
                  },
                  innerHtml: spec.text
                }
              };
            }
          },
          schema: [required$1("text")],
          name: "aria-descriptor"
        }),
        external$1({
          schema: [
            tieredMenuMarkers()
          ],
          name: "menu",
          defaults: (detail) => {
            return {
              onExecute: (tmenu, item2) => {
                tmenu.getSystem().getByUid(detail.uid).each((splitDropdown) => {
                  detail.onItemExecute(splitDropdown, tmenu, item2);
                });
              }
            };
          }
        }),
        partType()
      ]);
      const factory$c = (detail, components2, spec, externals) => {
        const switchToMenu = (sandbox) => {
          Composing.getCurrent(sandbox).each((current) => {
            Highlighting.highlightFirst(current);
            Keying.focusIn(current);
          });
        };
        const action = (component) => {
          const onOpenSync = switchToMenu;
          togglePopup(detail, identity, component, externals, onOpenSync, HighlightOnOpen.HighlightMenuAndItem).get(noop);
        };
        const openMenu = (comp) => {
          action(comp);
          return Optional.some(true);
        };
        const executeOnButton = (comp) => {
          const button2 = getPartOrDie(comp, detail, "button");
          emitExecute(button2);
          return Optional.some(true);
        };
        const buttonEvents = {
          ...derive$2([
            runOnAttached((component, _simulatedEvent) => {
              const ariaDescriptor = getPart(component, detail, "aria-descriptor");
              ariaDescriptor.each((descriptor) => {
                const descriptorId = generate$6("aria");
                set$9(descriptor.element, "id", descriptorId);
                set$9(component.element, "aria-describedby", descriptorId);
              });
            })
          ]),
          ...events(Optional.some(action))
        };
        const apis = {
          repositionMenus: (comp) => {
            if (Toggling.isOn(comp)) {
              repositionMenus(comp);
            }
          }
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          apis,
          eventOrder: {
            ...detail.eventOrder,
            // Order, the button state is toggled first, so assumed !selected means close.
            [execute$5()]: ["disabling", "toggling", "alloy.base.behaviour"]
          },
          events: buttonEvents,
          behaviours: augment(detail.splitDropdownBehaviours, [
            Coupling.config({
              others: {
                sandbox: (hotspot) => {
                  const arrow = getPartOrDie(hotspot, detail, "arrow");
                  const extras = {
                    onOpen: () => {
                      Toggling.on(arrow);
                      Toggling.on(hotspot);
                    },
                    onClose: () => {
                      Toggling.off(arrow);
                      Toggling.off(hotspot);
                    }
                  };
                  return makeSandbox$1(detail, hotspot, extras);
                }
              }
            }),
            Keying.config({
              mode: "special",
              onSpace: executeOnButton,
              onEnter: executeOnButton,
              onDown: openMenu
            }),
            Focusing.config({}),
            Toggling.config({
              toggleOnExecute: false,
              aria: {
                mode: "expanded"
              }
            })
          ]),
          domModification: {
            attributes: {
              "role": detail.role.getOr("button"),
              "aria-haspopup": true
            }
          }
        };
      };
      const SplitDropdown = composite({
        name: "SplitDropdown",
        configFields: schema$7(),
        partFields: parts$6(),
        factory: factory$c,
        apis: {
          repositionMenus: (apis, comp) => apis.repositionMenus(comp)
        }
      });
      const generate$1 = (xs, f2) => {
        const init2 = {
          len: 0,
          list: []
        };
        const r2 = foldl(xs, (b2, a) => {
          const value2 = f2(a, b2.len);
          return value2.fold(constant$1(b2), (v) => ({
            len: v.finish,
            list: b2.list.concat([v])
          }));
        }, init2);
        return r2.list;
      };
      const output = (within, extra, withinWidth) => ({
        within,
        extra,
        withinWidth
      });
      const apportion = (units2, total, len) => {
        const parray = generate$1(units2, (unit, current) => {
          const width2 = len(unit);
          return Optional.some({
            element: unit,
            start: current,
            finish: current + width2,
            width: width2
          });
        });
        const within = filter$2(parray, (unit) => unit.finish <= total);
        const withinWidth = foldr(within, (acc, el) => acc + el.width, 0);
        const extra = parray.slice(within.length);
        return {
          within,
          extra,
          withinWidth
        };
      };
      const toUnit = (parray) => map$2(parray, (unit) => unit.element);
      const fitLast = (within, extra, withinWidth) => {
        const fits = toUnit(within.concat(extra));
        return output(fits, [], withinWidth);
      };
      const overflow = (within, extra, overflower, withinWidth) => {
        const fits = toUnit(within).concat([overflower]);
        return output(fits, toUnit(extra), withinWidth);
      };
      const fitAll = (within, extra, withinWidth) => output(toUnit(within), [], withinWidth);
      const tryFit = (total, units2, len) => {
        const divide = apportion(units2, total, len);
        return divide.extra.length === 0 ? Optional.some(divide) : Optional.none();
      };
      const partition = (total, units2, len, overflower) => {
        const divide = tryFit(total, units2, len).getOrThunk(() => (
          // If that doesn't work, overflow
          apportion(units2, total - len(overflower), len)
        ));
        const within = divide.within;
        const extra = divide.extra;
        const withinWidth = divide.withinWidth;
        if (extra.length === 1 && extra[0].width <= len(overflower)) {
          return fitLast(within, extra, withinWidth);
        } else if (extra.length >= 1) {
          return overflow(within, extra, overflower, withinWidth);
        } else {
          return fitAll(within, extra, withinWidth);
        }
      };
      const setGroups = (toolbar, storedGroups) => {
        const bGroups = map$2(storedGroups, (g) => premade(g));
        Toolbar.setGroups(toolbar, bGroups);
      };
      const findFocusedComp = (comps) => findMap(comps, (comp) => search(comp.element).bind((focusedElm) => comp.getSystem().getByDom(focusedElm).toOptional()));
      const refresh$2 = (toolbar, detail, setOverflow) => {
        const builtGroups = detail.builtGroups.get();
        if (builtGroups.length === 0) {
          return;
        }
        const primary2 = getPartOrDie(toolbar, detail, "primary");
        const overflowGroup = Coupling.getCoupled(toolbar, "overflowGroup");
        set$7(primary2.element, "visibility", "hidden");
        const groups = builtGroups.concat([overflowGroup]);
        const focusedComp = findFocusedComp(groups);
        setOverflow([]);
        setGroups(primary2, groups);
        const availableWidth = get$c(primary2.element);
        const overflows = partition(availableWidth, detail.builtGroups.get(), (comp) => Math.ceil(comp.element.dom.getBoundingClientRect().width), overflowGroup);
        if (overflows.extra.length === 0) {
          Replacing.remove(primary2, overflowGroup);
          setOverflow([]);
        } else {
          setGroups(primary2, overflows.within);
          setOverflow(overflows.extra);
        }
        remove$6(primary2.element, "visibility");
        reflow(primary2.element);
        focusedComp.each(Focusing.focus);
      };
      const schema$6 = constant$1([
        field("splitToolbarBehaviours", [Coupling]),
        customField("builtGroups", () => Cell([]))
      ]);
      const schema$5 = constant$1([
        markers$1(["overflowToggledClass"]),
        optionFunction("getOverflowBounds"),
        required$1("lazySink"),
        customField("overflowGroups", () => Cell([])),
        onHandler("onOpened"),
        onHandler("onClosed")
      ].concat(schema$6()));
      const parts$5 = constant$1([
        required({
          factory: Toolbar,
          schema: schema$e(),
          name: "primary"
        }),
        external$1({
          schema: schema$e(),
          name: "overflow"
        }),
        external$1({
          name: "overflow-button"
        }),
        external$1({
          name: "overflow-group"
        })
      ]);
      const schema$4 = constant$1([
        required$1("items"),
        markers$1(["itemSelector"]),
        field("tgroupBehaviours", [Keying])
      ]);
      const parts$4 = constant$1([
        group({
          name: "items",
          unit: "item"
        })
      ]);
      const factory$b = (detail, components2, _spec, _externals) => ({
        uid: detail.uid,
        dom: detail.dom,
        components: components2,
        behaviours: augment(detail.tgroupBehaviours, [
          Keying.config({
            mode: "flow",
            selector: detail.markers.itemSelector
          })
        ]),
        domModification: {
          attributes: {
            role: "toolbar"
          }
        }
      });
      const ToolbarGroup = composite({
        name: "ToolbarGroup",
        configFields: schema$4(),
        partFields: parts$4(),
        factory: factory$b
      });
      const buildGroups = (comps) => map$2(comps, (g) => premade(g));
      const refresh$1 = (toolbar, memFloatingToolbarButton, detail) => {
        refresh$2(toolbar, detail, (overflowGroups) => {
          detail.overflowGroups.set(overflowGroups);
          memFloatingToolbarButton.getOpt(toolbar).each((floatingToolbarButton) => {
            FloatingToolbarButton.setGroups(floatingToolbarButton, buildGroups(overflowGroups));
          });
        });
      };
      const factory$a = (detail, components2, spec, externals) => {
        const memFloatingToolbarButton = record(FloatingToolbarButton.sketch({
          fetch: () => Future.nu((resolve2) => {
            resolve2(buildGroups(detail.overflowGroups.get()));
          }),
          layouts: {
            onLtr: () => [southwest$2, southeast$2],
            onRtl: () => [southeast$2, southwest$2],
            onBottomLtr: () => [northwest$2, northeast$2],
            onBottomRtl: () => [northeast$2, northwest$2]
          },
          getBounds: spec.getOverflowBounds,
          lazySink: detail.lazySink,
          fireDismissalEventInstead: {},
          markers: {
            toggledClass: detail.markers.overflowToggledClass
          },
          parts: {
            button: externals["overflow-button"](),
            toolbar: externals.overflow()
          },
          onToggled: (comp, state) => detail[state ? "onOpened" : "onClosed"](comp)
        }));
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: augment(detail.splitToolbarBehaviours, [
            Coupling.config({
              others: {
                overflowGroup: () => {
                  return ToolbarGroup.sketch({
                    ...externals["overflow-group"](),
                    items: [
                      memFloatingToolbarButton.asSpec()
                    ]
                  });
                }
              }
            })
          ]),
          apis: {
            setGroups: (toolbar, groups) => {
              detail.builtGroups.set(map$2(groups, toolbar.getSystem().build));
              refresh$1(toolbar, memFloatingToolbarButton, detail);
            },
            refresh: (toolbar) => refresh$1(toolbar, memFloatingToolbarButton, detail),
            toggle: (toolbar) => {
              memFloatingToolbarButton.getOpt(toolbar).each((floatingToolbarButton) => {
                FloatingToolbarButton.toggle(floatingToolbarButton);
              });
            },
            toggleWithoutFocusing: (toolbar) => {
              memFloatingToolbarButton.getOpt(toolbar).each(FloatingToolbarButton.toggleWithoutFocusing);
            },
            isOpen: (toolbar) => memFloatingToolbarButton.getOpt(toolbar).map(FloatingToolbarButton.isOpen).getOr(false),
            reposition: (toolbar) => {
              memFloatingToolbarButton.getOpt(toolbar).each((floatingToolbarButton) => {
                FloatingToolbarButton.reposition(floatingToolbarButton);
              });
            },
            getOverflow: (toolbar) => memFloatingToolbarButton.getOpt(toolbar).bind(FloatingToolbarButton.getToolbar)
          },
          domModification: {
            attributes: { role: "group" }
          }
        };
      };
      const SplitFloatingToolbar = composite({
        name: "SplitFloatingToolbar",
        configFields: schema$5(),
        partFields: parts$5(),
        factory: factory$a,
        apis: {
          setGroups: (apis, toolbar, groups) => {
            apis.setGroups(toolbar, groups);
          },
          refresh: (apis, toolbar) => {
            apis.refresh(toolbar);
          },
          reposition: (apis, toolbar) => {
            apis.reposition(toolbar);
          },
          toggle: (apis, toolbar) => {
            apis.toggle(toolbar);
          },
          toggleWithoutFocusing: (apis, toolbar) => {
            apis.toggle(toolbar);
          },
          isOpen: (apis, toolbar) => apis.isOpen(toolbar),
          getOverflow: (apis, toolbar) => apis.getOverflow(toolbar)
        }
      });
      const schema$3 = constant$1([
        markers$1(["closedClass", "openClass", "shrinkingClass", "growingClass", "overflowToggledClass"]),
        onHandler("onOpened"),
        onHandler("onClosed")
      ].concat(schema$6()));
      const parts$3 = constant$1([
        required({
          factory: Toolbar,
          schema: schema$e(),
          name: "primary"
        }),
        required({
          factory: Toolbar,
          schema: schema$e(),
          name: "overflow",
          overrides: (detail) => {
            return {
              toolbarBehaviours: derive$1([
                Sliding.config({
                  dimension: {
                    property: "height"
                  },
                  closedClass: detail.markers.closedClass,
                  openClass: detail.markers.openClass,
                  shrinkingClass: detail.markers.shrinkingClass,
                  growingClass: detail.markers.growingClass,
                  onShrunk: (comp) => {
                    getPart(comp, detail, "overflow-button").each((button2) => {
                      Toggling.off(button2);
                    });
                    detail.onClosed(comp);
                  },
                  onGrown: (comp) => {
                    detail.onOpened(comp);
                  },
                  onStartGrow: (comp) => {
                    getPart(comp, detail, "overflow-button").each(Toggling.on);
                  }
                }),
                Keying.config({
                  mode: "acyclic",
                  onEscape: (comp) => {
                    getPart(comp, detail, "overflow-button").each(Focusing.focus);
                    return Optional.some(true);
                  }
                })
              ])
            };
          }
        }),
        external$1({
          name: "overflow-button",
          overrides: (detail) => ({
            buttonBehaviours: derive$1([
              Toggling.config({
                toggleClass: detail.markers.overflowToggledClass,
                aria: {
                  mode: "expanded"
                },
                toggleOnExecute: false
              })
            ])
          })
        }),
        external$1({
          name: "overflow-group"
        })
      ]);
      const isOpen = (toolbar, detail) => getPart(toolbar, detail, "overflow").map(Sliding.hasGrown).getOr(false);
      const toggleToolbar = (toolbar, detail, skipFocus) => {
        getPart(toolbar, detail, "overflow-button").each((oveflowButton) => {
          getPart(toolbar, detail, "overflow").each((overf) => {
            refresh(toolbar, detail);
            if (Sliding.hasShrunk(overf)) {
              const fn = detail.onOpened;
              detail.onOpened = (comp) => {
                if (!skipFocus) {
                  Keying.focusIn(overf);
                }
                fn(comp);
                detail.onOpened = fn;
              };
            } else {
              const fn = detail.onClosed;
              detail.onClosed = (comp) => {
                if (!skipFocus) {
                  Focusing.focus(oveflowButton);
                }
                fn(comp);
                detail.onClosed = fn;
              };
            }
            Sliding.toggleGrow(overf);
          });
        });
      };
      const refresh = (toolbar, detail) => {
        getPart(toolbar, detail, "overflow").each((overflow2) => {
          refresh$2(toolbar, detail, (groups) => {
            const builtGroups = map$2(groups, (g) => premade(g));
            Toolbar.setGroups(overflow2, builtGroups);
          });
          getPart(toolbar, detail, "overflow-button").each((button2) => {
            if (Sliding.hasGrown(overflow2)) {
              Toggling.on(button2);
            }
          });
          Sliding.refresh(overflow2);
        });
      };
      const factory$9 = (detail, components2, spec, externals) => {
        const toolbarToggleEvent = "alloy.toolbar.toggle";
        const doSetGroups = (toolbar, groups) => {
          const built = map$2(groups, toolbar.getSystem().build);
          detail.builtGroups.set(built);
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: augment(detail.splitToolbarBehaviours, [
            Coupling.config({
              others: {
                overflowGroup: (toolbar) => {
                  return ToolbarGroup.sketch({
                    ...externals["overflow-group"](),
                    items: [
                      Button.sketch({
                        ...externals["overflow-button"](),
                        action: (_button) => {
                          emit(toolbar, toolbarToggleEvent);
                        }
                      })
                    ]
                  });
                }
              }
            }),
            config("toolbar-toggle-events", [
              run$1(toolbarToggleEvent, (toolbar) => {
                toggleToolbar(toolbar, detail, false);
              })
            ])
          ]),
          apis: {
            setGroups: (toolbar, groups) => {
              doSetGroups(toolbar, groups);
              refresh(toolbar, detail);
            },
            refresh: (toolbar) => refresh(toolbar, detail),
            toggle: (toolbar) => {
              toggleToolbar(toolbar, detail, false);
            },
            toggleWithoutFocusing: (toolbar) => {
              toggleToolbar(toolbar, detail, true);
            },
            isOpen: (toolbar) => isOpen(toolbar, detail)
          },
          domModification: {
            attributes: { role: "group" }
          }
        };
      };
      const SplitSlidingToolbar = composite({
        name: "SplitSlidingToolbar",
        configFields: schema$3(),
        partFields: parts$3(),
        factory: factory$9,
        apis: {
          setGroups: (apis, toolbar, groups) => {
            apis.setGroups(toolbar, groups);
          },
          refresh: (apis, toolbar) => {
            apis.refresh(toolbar);
          },
          toggle: (apis, toolbar) => {
            apis.toggle(toolbar);
          },
          isOpen: (apis, toolbar) => apis.isOpen(toolbar)
        }
      });
      const factory$8 = (detail, _spec) => ({
        uid: detail.uid,
        dom: detail.dom,
        components: detail.components,
        events: events(detail.action),
        behaviours: augment(detail.tabButtonBehaviours, [
          Focusing.config({}),
          Keying.config({
            mode: "execution",
            useSpace: true,
            useEnter: true
          }),
          Representing.config({
            store: {
              mode: "memory",
              initialValue: detail.value
            }
          })
        ]),
        domModification: detail.domModification
      });
      const TabButton = single({
        name: "TabButton",
        configFields: [
          defaulted("uid", void 0),
          required$1("value"),
          field$1("dom", "dom", mergeWithThunk(() => ({
            attributes: {
              "role": "tab",
              // NOTE: This is used in TabSection to connect "labelledby"
              "id": generate$6("aria"),
              "aria-selected": "false"
            }
          })), anyValue()),
          option$3("action"),
          defaulted("domModification", {}),
          field("tabButtonBehaviours", [Focusing, Keying, Representing]),
          required$1("view")
        ],
        factory: factory$8
      });
      const schema$2 = constant$1([
        required$1("tabs"),
        required$1("dom"),
        defaulted("clickToDismiss", false),
        field("tabbarBehaviours", [Highlighting, Keying]),
        markers$1(["tabClass", "selectedClass"])
      ]);
      const tabsPart = group({
        factory: TabButton,
        name: "tabs",
        unit: "tab",
        overrides: (barDetail) => {
          const dismissTab$1 = (tabbar, button2) => {
            Highlighting.dehighlight(tabbar, button2);
            emitWith(tabbar, dismissTab(), {
              tabbar,
              button: button2
            });
          };
          const changeTab$1 = (tabbar, button2) => {
            Highlighting.highlight(tabbar, button2);
            emitWith(tabbar, changeTab(), {
              tabbar,
              button: button2
            });
          };
          return {
            action: (button2) => {
              const tabbar = button2.getSystem().getByUid(barDetail.uid).getOrDie();
              const activeButton = Highlighting.isHighlighted(tabbar, button2);
              const response = (() => {
                if (activeButton && barDetail.clickToDismiss) {
                  return dismissTab$1;
                } else if (!activeButton) {
                  return changeTab$1;
                } else {
                  return noop;
                }
              })();
              response(tabbar, button2);
            },
            domModification: {
              classes: [barDetail.markers.tabClass]
            }
          };
        }
      });
      const parts$2 = constant$1([
        tabsPart
      ]);
      const factory$7 = (detail, components2, _spec, _externals) => ({
        "uid": detail.uid,
        "dom": detail.dom,
        components: components2,
        "debug.sketcher": "Tabbar",
        "domModification": {
          attributes: {
            role: "tablist"
          }
        },
        "behaviours": augment(detail.tabbarBehaviours, [
          Highlighting.config({
            highlightClass: detail.markers.selectedClass,
            itemClass: detail.markers.tabClass,
            // https://www.w3.org/TR/2010/WD-wai-aria-practices-20100916/#tabpanel
            // Consider a more seam-less way of combining highlighting and toggling
            onHighlight: (tabbar, tab) => {
              set$9(tab.element, "aria-selected", "true");
            },
            onDehighlight: (tabbar, tab) => {
              set$9(tab.element, "aria-selected", "false");
            }
          }),
          Keying.config({
            mode: "flow",
            getInitial: (tabbar) => {
              return Highlighting.getHighlighted(tabbar).map((tab) => tab.element);
            },
            selector: "." + detail.markers.tabClass,
            executeOnMove: true
          })
        ])
      });
      const Tabbar = composite({
        name: "Tabbar",
        configFields: schema$2(),
        partFields: parts$2(),
        factory: factory$7
      });
      const factory$6 = (detail, _spec) => ({
        uid: detail.uid,
        dom: detail.dom,
        behaviours: augment(detail.tabviewBehaviours, [
          Replacing.config({})
        ]),
        domModification: {
          attributes: { role: "tabpanel" }
        }
      });
      const Tabview = single({
        name: "Tabview",
        configFields: [
          field("tabviewBehaviours", [Replacing])
        ],
        factory: factory$6
      });
      const schema$1 = constant$1([
        defaulted("selectFirst", true),
        onHandler("onChangeTab"),
        onHandler("onDismissTab"),
        defaulted("tabs", []),
        field("tabSectionBehaviours", [])
      ]);
      const barPart = required({
        factory: Tabbar,
        schema: [
          required$1("dom"),
          requiredObjOf("markers", [
            required$1("tabClass"),
            required$1("selectedClass")
          ])
        ],
        name: "tabbar",
        defaults: (detail) => {
          return {
            tabs: detail.tabs
          };
        }
      });
      const viewPart = required({
        factory: Tabview,
        name: "tabview"
      });
      const parts$1 = constant$1([
        barPart,
        viewPart
      ]);
      const factory$5 = (detail, components2, _spec, _externals) => {
        const changeTab$1 = (button2) => {
          const tabValue = Representing.getValue(button2);
          getPart(button2, detail, "tabview").each((tabview) => {
            const tabWithValue = find$5(detail.tabs, (t2) => t2.value === tabValue);
            tabWithValue.each((tabData) => {
              const panel = tabData.view();
              getOpt(button2.element, "id").each((id) => {
                set$9(tabview.element, "aria-labelledby", id);
              });
              Replacing.set(tabview, panel);
              detail.onChangeTab(tabview, button2, panel);
            });
          });
        };
        const changeTabBy = (section, byPred) => {
          getPart(section, detail, "tabbar").each((tabbar) => {
            byPred(tabbar).each(emitExecute);
          });
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: get$2(detail.tabSectionBehaviours),
          events: derive$2(flatten([
            detail.selectFirst ? [
              runOnAttached((section, _simulatedEvent) => {
                changeTabBy(section, Highlighting.getFirst);
              })
            ] : [],
            [
              run$1(changeTab(), (section, simulatedEvent) => {
                const button2 = simulatedEvent.event.button;
                changeTab$1(button2);
              }),
              run$1(dismissTab(), (section, simulatedEvent) => {
                const button2 = simulatedEvent.event.button;
                detail.onDismissTab(section, button2);
              })
            ]
          ])),
          apis: {
            getViewItems: (section) => {
              return getPart(section, detail, "tabview").map((tabview) => Replacing.contents(tabview)).getOr([]);
            },
            // How should "clickToDismiss" interact with this? At the moment, it will never dismiss
            showTab: (section, tabKey) => {
              const getTabIfNotActive = (tabbar) => {
                const candidates = Highlighting.getCandidates(tabbar);
                const optTab = find$5(candidates, (c) => Representing.getValue(c) === tabKey);
                return optTab.filter((tab) => !Highlighting.isHighlighted(tabbar, tab));
              };
              changeTabBy(section, getTabIfNotActive);
            }
          }
        };
      };
      const TabSection = composite({
        name: "TabSection",
        configFields: schema$1(),
        partFields: parts$1(),
        factory: factory$5,
        apis: {
          getViewItems: (apis, component) => apis.getViewItems(component),
          showTab: (apis, component, tabKey) => {
            apis.showTab(component, tabKey);
          }
        }
      });
      const setValueFromItem = (model, input2, item2) => {
        const itemData = Representing.getValue(item2);
        Representing.setValue(input2, itemData);
        setCursorAtEnd(input2);
      };
      const setSelectionOn = (input2, f2) => {
        const el = input2.element;
        const value2 = get$5(el);
        const node = el.dom;
        if (get$g(el, "type") !== "number") {
          f2(node, value2);
        }
      };
      const setCursorAtEnd = (input2) => {
        setSelectionOn(input2, (node, value2) => node.setSelectionRange(value2.length, value2.length));
      };
      const setSelectionToEnd = (input2, startOffset) => {
        setSelectionOn(input2, (node, value2) => node.setSelectionRange(startOffset, value2.length));
      };
      const attemptSelectOver = (model, input2, item2) => {
        if (!model.selectsOver) {
          return Optional.none();
        } else {
          const currentValue2 = Representing.getValue(input2);
          const inputDisplay = model.getDisplayText(currentValue2);
          const itemValue = Representing.getValue(item2);
          const itemDisplay = model.getDisplayText(itemValue);
          return itemDisplay.indexOf(inputDisplay) === 0 ? Optional.some(() => {
            setValueFromItem(model, input2, item2);
            setSelectionToEnd(input2, inputDisplay.length);
          }) : Optional.none();
        }
      };
      const itemExecute = constant$1("alloy.typeahead.itemexecute");
      const make$2 = (detail, components2, spec, externals) => {
        const navigateList = (comp, simulatedEvent, highlighter) => {
          detail.previewing.set(false);
          const sandbox = Coupling.getCoupled(comp, "sandbox");
          if (Sandboxing.isOpen(sandbox)) {
            Composing.getCurrent(sandbox).each((menu2) => {
              Highlighting.getHighlighted(menu2).fold(() => {
                highlighter(menu2);
              }, () => {
                dispatchEvent(sandbox, menu2.element, "keydown", simulatedEvent);
              });
            });
          } else {
            const onOpenSync = (sandbox2) => {
              Composing.getCurrent(sandbox2).each(highlighter);
            };
            open(detail, mapFetch(comp), comp, sandbox, externals, onOpenSync, HighlightOnOpen.HighlightMenuAndItem).get(noop);
          }
        };
        const focusBehaviours$1 = focusBehaviours(detail);
        const mapFetch = (comp) => (tdata) => tdata.map((data) => {
          const menus = values(data.menus);
          const items = bind$3(menus, (menu2) => filter$2(menu2.items, (item2) => item2.type === "item"));
          const repState = Representing.getState(comp);
          repState.update(map$2(items, (item2) => item2.data));
          return data;
        });
        const getActiveMenu = (sandboxComp) => Composing.getCurrent(sandboxComp);
        const typeaheadCustomEvents = "typeaheadevents";
        const behaviours2 = [
          Focusing.config({}),
          Representing.config({
            onSetValue: detail.onSetValue,
            store: {
              mode: "dataset",
              getDataKey: (comp) => get$5(comp.element),
              // This really needs to be configurable
              getFallbackEntry: (itemString) => ({
                value: itemString,
                meta: {}
              }),
              setValue: (comp, data) => {
                set$4(comp.element, detail.model.getDisplayText(data));
              },
              ...detail.initialData.map((d) => wrap("initialValue", d)).getOr({})
            }
          }),
          Streaming.config({
            stream: {
              mode: "throttle",
              delay: detail.responseTime,
              stopEvent: false
            },
            onStream: (component, _simulatedEvent) => {
              const sandbox = Coupling.getCoupled(component, "sandbox");
              const focusInInput = Focusing.isFocused(component);
              if (focusInInput) {
                if (get$5(component.element).length >= detail.minChars) {
                  const previousValue = getActiveMenu(sandbox).bind((activeMenu) => Highlighting.getHighlighted(activeMenu).map(Representing.getValue));
                  detail.previewing.set(true);
                  const onOpenSync = (_sandbox) => {
                    getActiveMenu(sandbox).each((activeMenu) => {
                      previousValue.fold(() => {
                        if (detail.model.selectsOver) {
                          Highlighting.highlightFirst(activeMenu);
                        }
                      }, (pv) => {
                        Highlighting.highlightBy(activeMenu, (item2) => {
                          const itemData = Representing.getValue(item2);
                          return itemData.value === pv.value;
                        });
                        Highlighting.getHighlighted(activeMenu).orThunk(() => {
                          Highlighting.highlightFirst(activeMenu);
                          return Optional.none();
                        });
                      });
                    });
                  };
                  open(
                    detail,
                    mapFetch(component),
                    component,
                    sandbox,
                    externals,
                    onOpenSync,
                    // The onOpenSync takes care of what should be given the highlights, but
                    // we want to highlight just the menu so that the onOpenSync can find the
                    // activeMenu.
                    HighlightOnOpen.HighlightJustMenu
                  ).get(noop);
                }
              }
            },
            cancelEvent: typeaheadCancel()
          }),
          Keying.config({
            mode: "special",
            onDown: (comp, simulatedEvent) => {
              navigateList(comp, simulatedEvent, Highlighting.highlightFirst);
              return Optional.some(true);
            },
            onEscape: (comp) => {
              const sandbox = Coupling.getCoupled(comp, "sandbox");
              if (Sandboxing.isOpen(sandbox)) {
                Sandboxing.close(sandbox);
                return Optional.some(true);
              }
              return Optional.none();
            },
            onUp: (comp, simulatedEvent) => {
              navigateList(comp, simulatedEvent, Highlighting.highlightLast);
              return Optional.some(true);
            },
            onEnter: (comp) => {
              const sandbox = Coupling.getCoupled(comp, "sandbox");
              const sandboxIsOpen = Sandboxing.isOpen(sandbox);
              if (sandboxIsOpen && !detail.previewing.get()) {
                return getActiveMenu(sandbox).bind((activeMenu) => Highlighting.getHighlighted(activeMenu)).map((item2) => {
                  emitWith(comp, itemExecute(), { item: item2 });
                  return true;
                });
              } else {
                const currentValue2 = Representing.getValue(comp);
                emit(comp, typeaheadCancel());
                detail.onExecute(sandbox, comp, currentValue2);
                if (sandboxIsOpen) {
                  Sandboxing.close(sandbox);
                }
                return Optional.some(true);
              }
            }
          }),
          Toggling.config({
            toggleClass: detail.markers.openClass,
            aria: {
              mode: "expanded"
            }
          }),
          Coupling.config({
            others: {
              sandbox: (hotspot) => {
                return makeSandbox$1(detail, hotspot, {
                  onOpen: () => Toggling.on(hotspot),
                  onClose: () => {
                    detail.lazyTypeaheadComp.get().each((input2) => remove$8(input2.element, "aria-activedescendant"));
                    Toggling.off(hotspot);
                  }
                });
              }
            }
          }),
          config(typeaheadCustomEvents, [
            runOnAttached((typeaheadComp) => {
              detail.lazyTypeaheadComp.set(Optional.some(typeaheadComp));
            }),
            runOnDetached((_typeaheadComp) => {
              detail.lazyTypeaheadComp.set(Optional.none());
            }),
            runOnExecute$1((comp) => {
              const onOpenSync = noop;
              togglePopup(detail, mapFetch(comp), comp, externals, onOpenSync, HighlightOnOpen.HighlightMenuAndItem).get(noop);
            }),
            run$1(itemExecute(), (comp, se) => {
              const sandbox = Coupling.getCoupled(comp, "sandbox");
              setValueFromItem(detail.model, comp, se.event.item);
              emit(comp, typeaheadCancel());
              detail.onItemExecute(comp, sandbox, se.event.item, Representing.getValue(comp));
              Sandboxing.close(sandbox);
              setCursorAtEnd(comp);
            })
          ].concat(detail.dismissOnBlur ? [
            run$1(postBlur(), (typeahead) => {
              const sandbox = Coupling.getCoupled(typeahead, "sandbox");
              if (search(sandbox.element).isNone()) {
                Sandboxing.close(sandbox);
              }
            })
          ] : []))
        ];
        const eventOrder = {
          [detachedFromDom()]: [
            Representing.name(),
            Streaming.name(),
            typeaheadCustomEvents
          ],
          ...detail.eventOrder
        };
        return {
          uid: detail.uid,
          dom: dom$1(deepMerge(detail, {
            // TODO: Add aria-activedescendant attribute
            inputAttributes: {
              "role": "combobox",
              "aria-autocomplete": "list",
              "aria-haspopup": "true"
            }
          })),
          behaviours: {
            ...focusBehaviours$1,
            ...augment(detail.typeaheadBehaviours, behaviours2)
          },
          eventOrder
        };
      };
      const schema = constant$1([
        option$3("lazySink"),
        required$1("fetch"),
        defaulted("minChars", 5),
        defaulted("responseTime", 1e3),
        onHandler("onOpen"),
        // TODO: Remove dupe with Dropdown
        defaulted("getHotspot", Optional.some),
        defaulted("getAnchorOverrides", constant$1({})),
        defaulted("layouts", Optional.none()),
        defaulted("eventOrder", {}),
        // Information about what these model settings do can be found in TypeaheadTypes
        defaultedObjOf("model", {}, [
          defaulted("getDisplayText", (itemData) => itemData.meta !== void 0 && itemData.meta.text !== void 0 ? itemData.meta.text : itemData.value),
          defaulted("selectsOver", true),
          defaulted("populateFromBrowse", true)
        ]),
        onHandler("onSetValue"),
        onKeyboardHandler("onExecute"),
        onHandler("onItemExecute"),
        defaulted("inputClasses", []),
        defaulted("inputAttributes", {}),
        defaulted("inputStyles", {}),
        defaulted("matchWidth", true),
        defaulted("useMinWidth", false),
        defaulted("dismissOnBlur", true),
        markers$1(["openClass"]),
        option$3("initialData"),
        option$3("listRole"),
        field("typeaheadBehaviours", [
          Focusing,
          Representing,
          Streaming,
          Keying,
          Toggling,
          Coupling
        ]),
        customField("lazyTypeaheadComp", () => Cell(Optional.none)),
        customField("previewing", () => Cell(true))
      ].concat(schema$a()).concat(sandboxFields()));
      const parts = constant$1([
        external$1({
          schema: [
            tieredMenuMarkers()
          ],
          name: "menu",
          overrides: (detail) => {
            return {
              fakeFocus: true,
              onHighlightItem: (_tmenu, menu2, item2) => {
                if (!detail.previewing.get()) {
                  detail.lazyTypeaheadComp.get().each((input2) => {
                    if (detail.model.populateFromBrowse) {
                      setValueFromItem(detail.model, input2, item2);
                    }
                    getOpt(item2.element, "id").each((id) => set$9(input2.element, "aria-activedescendant", id));
                  });
                } else {
                  detail.lazyTypeaheadComp.get().each((input2) => {
                    attemptSelectOver(detail.model, input2, item2).fold(
                      // If we are in "previewing" mode and we can't select over the
                      // thing that is first, then clear the highlight.
                      // Hopefully, this doesn't cause a flicker. Find a better
                      // way to do this.
                      () => {
                        if (detail.model.selectsOver) {
                          Highlighting.dehighlight(menu2, item2);
                          detail.previewing.set(true);
                        } else {
                          detail.previewing.set(false);
                        }
                      },
                      (selectOverTextInInput) => {
                        selectOverTextInInput();
                        detail.previewing.set(false);
                      }
                    );
                  });
                }
              },
              // Because the focus stays inside the input, this onExecute is fired when the
              // user "clicks" on an item. The focusing behaviour should be configured
              // so that items don't get focus, but they prevent a mousedown event from
              // firing so that the typeahead doesn't lose focus. This is the handler
              // for clicking on an item. We need to close the sandbox, update the typeahead
              // to show the item clicked on, and fire an execute.
              onExecute: (_menu, item2) => {
                return detail.lazyTypeaheadComp.get().map((typeahead) => {
                  emitWith(typeahead, itemExecute(), { item: item2 });
                  return true;
                });
              },
              onHover: (menu2, item2) => {
                detail.previewing.set(false);
                detail.lazyTypeaheadComp.get().each((input2) => {
                  if (detail.model.populateFromBrowse) {
                    setValueFromItem(detail.model, input2, item2);
                  }
                });
              }
            };
          }
        })
      ]);
      const Typeahead = composite({
        name: "Typeahead",
        configFields: schema(),
        partFields: parts(),
        factory: make$2
      });
      var global$b = tinymce.util.Tools.resolve("tinymce.ThemeManager");
      var global$a = tinymce.util.Tools.resolve("tinymce.util.Delay");
      var global$9 = tinymce.util.Tools.resolve("tinymce.dom.DOMUtils");
      var global$8 = tinymce.util.Tools.resolve("tinymce.EditorManager");
      var global$7 = tinymce.util.Tools.resolve("tinymce.Env");
      var ToolbarMode$1;
      (function(ToolbarMode2) {
        ToolbarMode2["default"] = "wrap";
        ToolbarMode2["floating"] = "floating";
        ToolbarMode2["sliding"] = "sliding";
        ToolbarMode2["scrolling"] = "scrolling";
      })(ToolbarMode$1 || (ToolbarMode$1 = {}));
      var ToolbarLocation$1;
      (function(ToolbarLocation2) {
        ToolbarLocation2["auto"] = "auto";
        ToolbarLocation2["top"] = "top";
        ToolbarLocation2["bottom"] = "bottom";
      })(ToolbarLocation$1 || (ToolbarLocation$1 = {}));
      const option$2 = (name2) => (editor) => editor.options.get(name2);
      const wrapOptional = (fn) => (editor) => Optional.from(fn(editor));
      const register$f = (editor) => {
        const isPhone2 = global$7.deviceType.isPhone();
        const isMobile = global$7.deviceType.isTablet() || isPhone2;
        const registerOption = editor.options.register;
        const stringOrFalseProcessor = (value2) => isString(value2) || value2 === false;
        const stringOrNumberProcessor = (value2) => isString(value2) || isNumber(value2);
        registerOption("skin", {
          processor: (value2) => isString(value2) || value2 === false,
          default: "oxide"
        });
        registerOption("skin_url", {
          processor: "string"
        });
        registerOption("height", {
          processor: stringOrNumberProcessor,
          default: Math.max(editor.getElement().offsetHeight, 400)
        });
        registerOption("width", {
          processor: stringOrNumberProcessor,
          default: global$9.DOM.getStyle(editor.getElement(), "width")
        });
        registerOption("min_height", {
          processor: "number",
          default: 100
        });
        registerOption("min_width", {
          processor: "number"
        });
        registerOption("max_height", {
          processor: "number"
        });
        registerOption("max_width", {
          processor: "number"
        });
        registerOption("style_formats", {
          processor: "object[]"
        });
        registerOption("style_formats_merge", {
          processor: "boolean",
          default: false
        });
        registerOption("style_formats_autohide", {
          processor: "boolean",
          default: false
        });
        registerOption("line_height_formats", {
          processor: "string",
          default: "1 1.1 1.2 1.3 1.4 1.5 2"
        });
        registerOption("font_family_formats", {
          processor: "string",
          default: "Andale Mono=andale mono,monospace;Arial=arial,helvetica,sans-serif;Arial Black=arial black,sans-serif;Book Antiqua=book antiqua,palatino,serif;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,palatino,serif;Helvetica=helvetica,arial,sans-serif;Impact=impact,sans-serif;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco,monospace;Times New Roman=times new roman,times,serif;Trebuchet MS=trebuchet ms,geneva,sans-serif;Verdana=verdana,geneva,sans-serif;Webdings=webdings;Wingdings=wingdings,zapf dingbats"
        });
        registerOption("font_size_formats", {
          processor: "string",
          default: "8pt 10pt 12pt 14pt 18pt 24pt 36pt"
        });
        registerOption("font_size_input_default_unit", {
          processor: "string",
          default: "pt"
        });
        registerOption("block_formats", {
          processor: "string",
          default: "Paragraph=p;Heading 1=h1;Heading 2=h2;Heading 3=h3;Heading 4=h4;Heading 5=h5;Heading 6=h6;Preformatted=pre"
        });
        registerOption("content_langs", {
          processor: "object[]"
        });
        registerOption("removed_menuitems", {
          processor: "string",
          default: ""
        });
        registerOption("menubar", {
          processor: (value2) => isString(value2) || isBoolean(value2),
          // Phones don't have a lot of screen space so disable the menubar
          default: !isPhone2
        });
        registerOption("menu", {
          processor: "object",
          default: {}
        });
        registerOption("toolbar", {
          processor: (value2) => {
            if (isBoolean(value2) || isString(value2) || isArray(value2)) {
              return { value: value2, valid: true };
            } else {
              return { valid: false, message: "Must be a boolean, string or array." };
            }
          },
          default: true
        });
        range$2(9, (num) => {
          registerOption("toolbar" + (num + 1), {
            processor: "string"
          });
        });
        registerOption("toolbar_mode", {
          processor: "string",
          // Use the default side-scrolling toolbar for tablets/phones
          default: isMobile ? "scrolling" : "floating"
        });
        registerOption("toolbar_groups", {
          processor: "object",
          default: {}
        });
        registerOption("toolbar_location", {
          processor: "string",
          default: ToolbarLocation$1.auto
        });
        registerOption("toolbar_persist", {
          processor: "boolean",
          default: false
        });
        registerOption("toolbar_sticky", {
          processor: "boolean",
          default: editor.inline
        });
        registerOption("toolbar_sticky_offset", {
          processor: "number",
          default: 0
        });
        registerOption("fixed_toolbar_container", {
          processor: "string",
          default: ""
        });
        registerOption("fixed_toolbar_container_target", {
          processor: "object"
        });
        registerOption("ui_mode", {
          processor: "string",
          default: "combined"
        });
        registerOption("file_picker_callback", {
          processor: "function"
        });
        registerOption("file_picker_validator_handler", {
          processor: "function"
        });
        registerOption("file_picker_types", {
          processor: "string"
        });
        registerOption("typeahead_urls", {
          processor: "boolean",
          default: true
        });
        registerOption("anchor_top", {
          processor: stringOrFalseProcessor,
          default: "#top"
        });
        registerOption("anchor_bottom", {
          processor: stringOrFalseProcessor,
          default: "#bottom"
        });
        registerOption("draggable_modal", {
          processor: "boolean",
          default: false
        });
        registerOption("statusbar", {
          processor: "boolean",
          default: true
        });
        registerOption("elementpath", {
          processor: "boolean",
          default: true
        });
        registerOption("branding", {
          processor: "boolean",
          default: true
        });
        registerOption("promotion", {
          processor: "boolean",
          default: true
        });
        registerOption("resize", {
          processor: (value2) => value2 === "both" || isBoolean(value2),
          // Editor resize doesn't work on touch devices at this stage
          default: !global$7.deviceType.isTouch()
        });
        registerOption("sidebar_show", {
          processor: "string"
        });
        registerOption("help_accessibility", {
          processor: "boolean",
          default: editor.hasPlugin("help")
        });
        registerOption("default_font_stack", {
          processor: "string[]",
          default: []
        });
      };
      const isReadOnly = option$2("readonly");
      const isDisabled = option$2("disabled");
      const getHeightOption = option$2("height");
      const getWidthOption = option$2("width");
      const getMinWidthOption = wrapOptional(option$2("min_width"));
      const getMinHeightOption = wrapOptional(option$2("min_height"));
      const getMaxWidthOption = wrapOptional(option$2("max_width"));
      const getMaxHeightOption = wrapOptional(option$2("max_height"));
      const getUserStyleFormats = wrapOptional(option$2("style_formats"));
      const shouldMergeStyleFormats = option$2("style_formats_merge");
      const shouldAutoHideStyleFormats = option$2("style_formats_autohide");
      const getContentLanguages = option$2("content_langs");
      const getRemovedMenuItems = option$2("removed_menuitems");
      const getToolbarMode = option$2("toolbar_mode");
      const getToolbarGroups = option$2("toolbar_groups");
      const getToolbarLocation = option$2("toolbar_location");
      const fixedContainerSelector = option$2("fixed_toolbar_container");
      const fixedToolbarContainerTarget = option$2("fixed_toolbar_container_target");
      const isToolbarPersist = option$2("toolbar_persist");
      const getStickyToolbarOffset = option$2("toolbar_sticky_offset");
      const getMenubar = option$2("menubar");
      const getToolbar = option$2("toolbar");
      const getFilePickerCallback = option$2("file_picker_callback");
      const getFilePickerValidatorHandler = option$2("file_picker_validator_handler");
      const getFontSizeInputDefaultUnit = option$2("font_size_input_default_unit");
      const getFilePickerTypes = option$2("file_picker_types");
      const useTypeaheadUrls = option$2("typeahead_urls");
      const getAnchorTop = option$2("anchor_top");
      const getAnchorBottom = option$2("anchor_bottom");
      const isDraggableModal$1 = option$2("draggable_modal");
      const useStatusBar = option$2("statusbar");
      const useElementPath = option$2("elementpath");
      const useBranding = option$2("branding");
      const getResize = option$2("resize");
      const getPasteAsText = option$2("paste_as_text");
      const getSidebarShow = option$2("sidebar_show");
      const promotionEnabled = option$2("promotion");
      const useHelpAccessibility = option$2("help_accessibility");
      const getDefaultFontStack = option$2("default_font_stack");
      const getSkin = option$2("skin");
      const isSkinDisabled = (editor) => editor.options.get("skin") === false;
      const isMenubarEnabled = (editor) => editor.options.get("menubar") !== false;
      const getSkinUrl = (editor) => {
        const skinUrl = editor.options.get("skin_url");
        if (isSkinDisabled(editor)) {
          return skinUrl;
        } else {
          if (skinUrl) {
            return editor.documentBaseURI.toAbsolute(skinUrl);
          } else {
            const skin = editor.options.get("skin");
            return global$8.baseURL + "/skins/ui/" + skin;
          }
        }
      };
      const getSkinUrlOption = (editor) => Optional.from(editor.options.get("skin_url"));
      const getLineHeightFormats = (editor) => editor.options.get("line_height_formats").split(" ");
      const isToolbarEnabled = (editor) => {
        const toolbar = getToolbar(editor);
        const isToolbarString = isString(toolbar);
        const isToolbarObjectArray = isArray(toolbar) && toolbar.length > 0;
        return !isMultipleToolbars(editor) && (isToolbarObjectArray || isToolbarString || toolbar === true);
      };
      const getMultipleToolbarsOption = (editor) => {
        const toolbars = range$2(9, (num) => editor.options.get("toolbar" + (num + 1)));
        const toolbarArray = filter$2(toolbars, isString);
        return someIf(toolbarArray.length > 0, toolbarArray);
      };
      const isMultipleToolbars = (editor) => getMultipleToolbarsOption(editor).fold(() => {
        const toolbar = getToolbar(editor);
        return isArrayOf(toolbar, isString) && toolbar.length > 0;
      }, always);
      const isToolbarLocationBottom = (editor) => getToolbarLocation(editor) === ToolbarLocation$1.bottom;
      const fixedContainerTarget = (editor) => {
        var _a;
        if (!editor.inline) {
          return Optional.none();
        }
        const selector = (_a = fixedContainerSelector(editor)) !== null && _a !== void 0 ? _a : "";
        if (selector.length > 0) {
          return descendant(body(), selector);
        }
        const element2 = fixedToolbarContainerTarget(editor);
        if (isNonNullable(element2)) {
          return Optional.some(SugarElement.fromDom(element2));
        }
        return Optional.none();
      };
      const useFixedContainer = (editor) => editor.inline && fixedContainerTarget(editor).isSome();
      const getUiContainer = (editor) => {
        const fixedContainer = fixedContainerTarget(editor);
        return fixedContainer.getOrThunk(() => getContentContainer(getRootNode(SugarElement.fromDom(editor.getElement()))));
      };
      const isDistractionFree = (editor) => editor.inline && !isMenubarEnabled(editor) && !isToolbarEnabled(editor) && !isMultipleToolbars(editor);
      const isStickyToolbar = (editor) => {
        const isStickyToolbar2 = editor.options.get("toolbar_sticky");
        return (isStickyToolbar2 || editor.inline) && !useFixedContainer(editor) && !isDistractionFree(editor);
      };
      const isSplitUiMode = (editor) => !useFixedContainer(editor) && editor.options.get("ui_mode") === "split";
      const getMenus = (editor) => {
        const menu2 = editor.options.get("menu");
        return map$1(menu2, (menu3) => ({ ...menu3, items: menu3.items }));
      };
      var Options = Object.freeze({
        __proto__: null,
        get ToolbarMode() {
          return ToolbarMode$1;
        },
        get ToolbarLocation() {
          return ToolbarLocation$1;
        },
        register: register$f,
        getSkinUrl,
        getSkinUrlOption,
        isReadOnly,
        isDisabled,
        getSkin,
        isSkinDisabled,
        getHeightOption,
        getWidthOption,
        getMinWidthOption,
        getMinHeightOption,
        getMaxWidthOption,
        getMaxHeightOption,
        getUserStyleFormats,
        shouldMergeStyleFormats,
        shouldAutoHideStyleFormats,
        getLineHeightFormats,
        getContentLanguages,
        getRemovedMenuItems,
        isMenubarEnabled,
        isMultipleToolbars,
        isToolbarEnabled,
        isToolbarPersist,
        getMultipleToolbarsOption,
        getUiContainer,
        useFixedContainer,
        isSplitUiMode,
        getToolbarMode,
        isDraggableModal: isDraggableModal$1,
        isDistractionFree,
        isStickyToolbar,
        getStickyToolbarOffset,
        getToolbarLocation,
        isToolbarLocationBottom,
        getToolbarGroups,
        getMenus,
        getMenubar,
        getToolbar,
        getFilePickerCallback,
        getFilePickerTypes,
        useTypeaheadUrls,
        getAnchorTop,
        getAnchorBottom,
        getFilePickerValidatorHandler,
        getFontSizeInputDefaultUnit,
        useStatusBar,
        useElementPath,
        promotionEnabled,
        useBranding,
        getResize,
        getPasteAsText,
        getSidebarShow,
        useHelpAccessibility,
        getDefaultFontStack
      });
      const nonScrollingOverflows = ["visible", "hidden", "clip"];
      const isScrollingOverflowValue = (value2) => trim$1(value2).length > 0 && !contains$2(nonScrollingOverflows, value2);
      const isScroller = (elem) => {
        if (isHTMLElement(elem)) {
          const overflowX = get$e(elem, "overflow-x");
          const overflowY = get$e(elem, "overflow-y");
          return isScrollingOverflowValue(overflowX) || isScrollingOverflowValue(overflowY);
        } else {
          return false;
        }
      };
      const isFullscreen = (editor) => editor.plugins.fullscreen && editor.plugins.fullscreen.isFullscreen();
      const detect = (editor, popupSinkElem) => {
        const ancestorsScrollers = ancestors(popupSinkElem, isScroller);
        const scrollers = ancestorsScrollers.length === 0 ? getShadowRoot(popupSinkElem).map(getShadowHost).map((x) => ancestors(x, isScroller)).getOr([]) : ancestorsScrollers;
        return head(scrollers).map((element2) => ({
          element: element2,
          // A list of all scrolling elements above the nearest scroller,
          // ordered from closest to popup -> closest to top of document
          others: scrollers.slice(1),
          isFullscreen: () => isFullscreen(editor)
        }));
      };
      const detectWhenSplitUiMode = (editor, popupSinkElem) => isSplitUiMode(editor) ? detect(editor, popupSinkElem) : Optional.none();
      const getBoundsFrom = (sc) => {
        const scrollableBoxes = [
          // sc.element is the main scroller, others are *additional* scrollers above that
          // we need to combine all of them to constrain the bounds
          ...map$2(sc.others, box$1),
          win()
        ];
        return sc.isFullscreen() ? win() : constrainByMany(box$1(sc.element), scrollableBoxes);
      };
      const {
        entries,
        setPrototypeOf,
        isFrozen,
        getPrototypeOf,
        getOwnPropertyDescriptor
      } = Object;
      let {
        freeze,
        seal,
        create: create$1
      } = Object;
      let {
        apply,
        construct
      } = typeof Reflect !== "undefined" && Reflect;
      if (!freeze) {
        freeze = function freeze2(x) {
          return x;
        };
      }
      if (!seal) {
        seal = function seal2(x) {
          return x;
        };
      }
      if (!apply) {
        apply = function apply2(fun, thisValue, args) {
          return fun.apply(thisValue, args);
        };
      }
      if (!construct) {
        construct = function construct2(Func, args) {
          return new Func(...args);
        };
      }
      const arrayForEach = unapply(Array.prototype.forEach);
      const arrayLastIndexOf = unapply(Array.prototype.lastIndexOf);
      const arrayPop = unapply(Array.prototype.pop);
      const arrayPush = unapply(Array.prototype.push);
      const arraySplice = unapply(Array.prototype.splice);
      const stringToLowerCase = unapply(String.prototype.toLowerCase);
      const stringToString = unapply(String.prototype.toString);
      const stringMatch = unapply(String.prototype.match);
      const stringReplace = unapply(String.prototype.replace);
      const stringIndexOf = unapply(String.prototype.indexOf);
      const stringTrim = unapply(String.prototype.trim);
      const objectHasOwnProperty = unapply(Object.prototype.hasOwnProperty);
      const regExpTest = unapply(RegExp.prototype.test);
      const typeErrorCreate = unconstruct(TypeError);
      function unapply(func) {
        return function(thisArg) {
          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }
          return apply(func, thisArg, args);
        };
      }
      function unconstruct(func) {
        return function() {
          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }
          return construct(func, args);
        };
      }
      function addToSet(set2, array) {
        let transformCaseFunc = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : stringToLowerCase;
        if (setPrototypeOf) {
          setPrototypeOf(set2, null);
        }
        let l2 = array.length;
        while (l2--) {
          let element2 = array[l2];
          if (typeof element2 === "string") {
            const lcElement = transformCaseFunc(element2);
            if (lcElement !== element2) {
              if (!isFrozen(array)) {
                array[l2] = lcElement;
              }
              element2 = lcElement;
            }
          }
          set2[element2] = true;
        }
        return set2;
      }
      function cleanArray(array) {
        for (let index = 0; index < array.length; index++) {
          const isPropertyExist = objectHasOwnProperty(array, index);
          if (!isPropertyExist) {
            array[index] = null;
          }
        }
        return array;
      }
      function clone(object) {
        const newObject = create$1(null);
        for (const [property, value2] of entries(object)) {
          const isPropertyExist = objectHasOwnProperty(object, property);
          if (isPropertyExist) {
            if (Array.isArray(value2)) {
              newObject[property] = cleanArray(value2);
            } else if (value2 && typeof value2 === "object" && value2.constructor === Object) {
              newObject[property] = clone(value2);
            } else {
              newObject[property] = value2;
            }
          }
        }
        return newObject;
      }
      function lookupGetter(object, prop) {
        while (object !== null) {
          const desc = getOwnPropertyDescriptor(object, prop);
          if (desc) {
            if (desc.get) {
              return unapply(desc.get);
            }
            if (typeof desc.value === "function") {
              return unapply(desc.value);
            }
          }
          object = getPrototypeOf(object);
        }
        function fallbackValue() {
          return null;
        }
        return fallbackValue;
      }
      const html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
      const svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
      const svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
      const svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
      const mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "mprescripts"]);
      const mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
      const text$1 = freeze(["#text"]);
      const html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "popover", "popovertarget", "popovertargetaction", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "wrap", "xmlns", "slot"]);
      const svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "amplitude", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "exponent", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "intercept", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "slope", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "tablevalues", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
      const mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
      const xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
      const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
      const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
      const TMPLIT_EXPR = seal(/\$\{[\w\W]*/gm);
      const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]+$/);
      const ARIA_ATTR = seal(/^aria-[\-\w]+$/);
      const IS_ALLOWED_URI = seal(
        /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
        // eslint-disable-line no-useless-escape
      );
      const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
      const ATTR_WHITESPACE = seal(
        /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
        // eslint-disable-line no-control-regex
      );
      const DOCTYPE_NAME = seal(/^html$/i);
      const CUSTOM_ELEMENT = seal(/^[a-z][.\w]*(-[.\w]+)+$/i);
      var EXPRESSIONS = Object.freeze({
        __proto__: null,
        ARIA_ATTR,
        ATTR_WHITESPACE,
        CUSTOM_ELEMENT,
        DATA_ATTR,
        DOCTYPE_NAME,
        ERB_EXPR,
        IS_ALLOWED_URI,
        IS_SCRIPT_OR_DATA,
        MUSTACHE_EXPR,
        TMPLIT_EXPR
      });
      const NODE_TYPE = {
        element: 1,
        attribute: 2,
        text: 3,
        cdataSection: 4,
        entityReference: 5,
        // Deprecated
        entityNode: 6,
        // Deprecated
        progressingInstruction: 7,
        comment: 8,
        document: 9,
        documentType: 10,
        documentFragment: 11,
        notation: 12
        // Deprecated
      };
      const getGlobal = function getGlobal2() {
        return typeof window === "undefined" ? null : window;
      };
      const _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, purifyHostElement) {
        if (typeof trustedTypes !== "object" || typeof trustedTypes.createPolicy !== "function") {
          return null;
        }
        let suffix2 = null;
        const ATTR_NAME = "data-tt-policy-suffix";
        if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
          suffix2 = purifyHostElement.getAttribute(ATTR_NAME);
        }
        const policyName = "dompurify" + (suffix2 ? "#" + suffix2 : "");
        try {
          return trustedTypes.createPolicy(policyName, {
            createHTML(html2) {
              return html2;
            },
            createScriptURL(scriptUrl) {
              return scriptUrl;
            }
          });
        } catch (_) {
          console.warn("TrustedTypes policy " + policyName + " could not be created.");
          return null;
        }
      };
      const _createHooksMap = function _createHooksMap2() {
        return {
          afterSanitizeAttributes: [],
          afterSanitizeElements: [],
          afterSanitizeShadowDOM: [],
          beforeSanitizeAttributes: [],
          beforeSanitizeElements: [],
          beforeSanitizeShadowDOM: [],
          uponSanitizeAttribute: [],
          uponSanitizeElement: [],
          uponSanitizeShadowNode: []
        };
      };
      function createDOMPurify() {
        let window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
        const DOMPurify = (root) => createDOMPurify(root);
        DOMPurify.version = "3.2.4";
        DOMPurify.removed = [];
        if (!window2 || !window2.document || window2.document.nodeType !== NODE_TYPE.document || !window2.Element) {
          DOMPurify.isSupported = false;
          return DOMPurify;
        }
        let {
          document: document2
        } = window2;
        const originalDocument = document2;
        const currentScript = originalDocument.currentScript;
        const {
          DocumentFragment,
          HTMLTemplateElement,
          Node,
          Element,
          NodeFilter,
          NamedNodeMap = window2.NamedNodeMap || window2.MozNamedAttrMap,
          HTMLFormElement,
          DOMParser,
          trustedTypes
        } = window2;
        const ElementPrototype = Element.prototype;
        const cloneNode = lookupGetter(ElementPrototype, "cloneNode");
        const remove2 = lookupGetter(ElementPrototype, "remove");
        const getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
        const getChildNodes = lookupGetter(ElementPrototype, "childNodes");
        const getParentNode = lookupGetter(ElementPrototype, "parentNode");
        if (typeof HTMLTemplateElement === "function") {
          const template = document2.createElement("template");
          if (template.content && template.content.ownerDocument) {
            document2 = template.content.ownerDocument;
          }
        }
        let trustedTypesPolicy;
        let emptyHTML = "";
        const {
          implementation,
          createNodeIterator,
          createDocumentFragment,
          getElementsByTagName
        } = document2;
        const {
          importNode
        } = originalDocument;
        let hooks = _createHooksMap();
        DOMPurify.isSupported = typeof entries === "function" && typeof getParentNode === "function" && implementation && implementation.createHTMLDocument !== void 0;
        const {
          MUSTACHE_EXPR: MUSTACHE_EXPR2,
          ERB_EXPR: ERB_EXPR2,
          TMPLIT_EXPR: TMPLIT_EXPR2,
          DATA_ATTR: DATA_ATTR2,
          ARIA_ATTR: ARIA_ATTR2,
          IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA2,
          ATTR_WHITESPACE: ATTR_WHITESPACE2,
          CUSTOM_ELEMENT: CUSTOM_ELEMENT2
        } = EXPRESSIONS;
        let {
          IS_ALLOWED_URI: IS_ALLOWED_URI$1
        } = EXPRESSIONS;
        let ALLOWED_TAGS = null;
        const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text$1]);
        let ALLOWED_ATTR = null;
        const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html, ...svg, ...mathMl, ...xml]);
        let CUSTOM_ELEMENT_HANDLING = Object.seal(create$1(null, {
          tagNameCheck: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: null
          },
          attributeNameCheck: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: null
          },
          allowCustomizedBuiltInElements: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: false
          }
        }));
        let FORBID_TAGS = null;
        let FORBID_ATTR = null;
        let ALLOW_ARIA_ATTR = true;
        let ALLOW_DATA_ATTR = true;
        let ALLOW_UNKNOWN_PROTOCOLS = false;
        let ALLOW_SELF_CLOSE_IN_ATTR = true;
        let SAFE_FOR_TEMPLATES = false;
        let SAFE_FOR_XML = true;
        let WHOLE_DOCUMENT = false;
        let SET_CONFIG = false;
        let FORCE_BODY = false;
        let RETURN_DOM = false;
        let RETURN_DOM_FRAGMENT = false;
        let RETURN_TRUSTED_TYPE = false;
        let SANITIZE_DOM = true;
        let SANITIZE_NAMED_PROPS = false;
        const SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
        let KEEP_CONTENT = true;
        let IN_PLACE = false;
        let USE_PROFILES = {};
        let FORBID_CONTENTS = null;
        const DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
        let DATA_URI_TAGS = null;
        const DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
        let URI_SAFE_ATTRIBUTES = null;
        const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
        const MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
        const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
        const HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
        let NAMESPACE = HTML_NAMESPACE;
        let IS_EMPTY_INPUT = false;
        let ALLOWED_NAMESPACES = null;
        const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
        let MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
        let HTML_INTEGRATION_POINTS = addToSet({}, ["annotation-xml"]);
        const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
        let PARSER_MEDIA_TYPE = null;
        const SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
        const DEFAULT_PARSER_MEDIA_TYPE = "text/html";
        let transformCaseFunc = null;
        let CONFIG = null;
        const formElement = document2.createElement("form");
        const isRegexOrFunction = function isRegexOrFunction2(testValue) {
          return testValue instanceof RegExp || testValue instanceof Function;
        };
        const _parseConfig = function _parseConfig2() {
          let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
          if (CONFIG && CONFIG === cfg) {
            return;
          }
          if (!cfg || typeof cfg !== "object") {
            cfg = {};
          }
          cfg = clone(cfg);
          PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
          SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? DEFAULT_PARSER_MEDIA_TYPE : cfg.PARSER_MEDIA_TYPE;
          transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
          ALLOWED_TAGS = objectHasOwnProperty(cfg, "ALLOWED_TAGS") ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
          ALLOWED_ATTR = objectHasOwnProperty(cfg, "ALLOWED_ATTR") ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
          ALLOWED_NAMESPACES = objectHasOwnProperty(cfg, "ALLOWED_NAMESPACES") ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
          URI_SAFE_ATTRIBUTES = objectHasOwnProperty(cfg, "ADD_URI_SAFE_ATTR") ? addToSet(clone(DEFAULT_URI_SAFE_ATTRIBUTES), cfg.ADD_URI_SAFE_ATTR, transformCaseFunc) : DEFAULT_URI_SAFE_ATTRIBUTES;
          DATA_URI_TAGS = objectHasOwnProperty(cfg, "ADD_DATA_URI_TAGS") ? addToSet(clone(DEFAULT_DATA_URI_TAGS), cfg.ADD_DATA_URI_TAGS, transformCaseFunc) : DEFAULT_DATA_URI_TAGS;
          FORBID_CONTENTS = objectHasOwnProperty(cfg, "FORBID_CONTENTS") ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
          FORBID_TAGS = objectHasOwnProperty(cfg, "FORBID_TAGS") ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
          FORBID_ATTR = objectHasOwnProperty(cfg, "FORBID_ATTR") ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
          USE_PROFILES = objectHasOwnProperty(cfg, "USE_PROFILES") ? cfg.USE_PROFILES : false;
          ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
          ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
          ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
          ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
          SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
          SAFE_FOR_XML = cfg.SAFE_FOR_XML !== false;
          WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
          RETURN_DOM = cfg.RETURN_DOM || false;
          RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
          RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
          FORCE_BODY = cfg.FORCE_BODY || false;
          SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
          SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
          KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
          IN_PLACE = cfg.IN_PLACE || false;
          IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
          NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
          MATHML_TEXT_INTEGRATION_POINTS = cfg.MATHML_TEXT_INTEGRATION_POINTS || MATHML_TEXT_INTEGRATION_POINTS;
          HTML_INTEGRATION_POINTS = cfg.HTML_INTEGRATION_POINTS || HTML_INTEGRATION_POINTS;
          CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
          if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
            CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
          }
          if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
            CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
          }
          if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
            CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
          }
          if (SAFE_FOR_TEMPLATES) {
            ALLOW_DATA_ATTR = false;
          }
          if (RETURN_DOM_FRAGMENT) {
            RETURN_DOM = true;
          }
          if (USE_PROFILES) {
            ALLOWED_TAGS = addToSet({}, text$1);
            ALLOWED_ATTR = [];
            if (USE_PROFILES.html === true) {
              addToSet(ALLOWED_TAGS, html$1);
              addToSet(ALLOWED_ATTR, html);
            }
            if (USE_PROFILES.svg === true) {
              addToSet(ALLOWED_TAGS, svg$1);
              addToSet(ALLOWED_ATTR, svg);
              addToSet(ALLOWED_ATTR, xml);
            }
            if (USE_PROFILES.svgFilters === true) {
              addToSet(ALLOWED_TAGS, svgFilters);
              addToSet(ALLOWED_ATTR, svg);
              addToSet(ALLOWED_ATTR, xml);
            }
            if (USE_PROFILES.mathMl === true) {
              addToSet(ALLOWED_TAGS, mathMl$1);
              addToSet(ALLOWED_ATTR, mathMl);
              addToSet(ALLOWED_ATTR, xml);
            }
          }
          if (cfg.ADD_TAGS) {
            if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
              ALLOWED_TAGS = clone(ALLOWED_TAGS);
            }
            addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
          }
          if (cfg.ADD_ATTR) {
            if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
              ALLOWED_ATTR = clone(ALLOWED_ATTR);
            }
            addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
          }
          if (cfg.ADD_URI_SAFE_ATTR) {
            addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
          }
          if (cfg.FORBID_CONTENTS) {
            if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
              FORBID_CONTENTS = clone(FORBID_CONTENTS);
            }
            addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
          }
          if (KEEP_CONTENT) {
            ALLOWED_TAGS["#text"] = true;
          }
          if (WHOLE_DOCUMENT) {
            addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
          }
          if (ALLOWED_TAGS.table) {
            addToSet(ALLOWED_TAGS, ["tbody"]);
            delete FORBID_TAGS.tbody;
          }
          if (cfg.TRUSTED_TYPES_POLICY) {
            if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== "function") {
              throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
            }
            if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== "function") {
              throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
            }
            trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
            emptyHTML = trustedTypesPolicy.createHTML("");
          } else {
            if (trustedTypesPolicy === void 0) {
              trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
            }
            if (trustedTypesPolicy !== null && typeof emptyHTML === "string") {
              emptyHTML = trustedTypesPolicy.createHTML("");
            }
          }
          if (freeze) {
            freeze(cfg);
          }
          CONFIG = cfg;
        };
        const ALL_SVG_TAGS = addToSet({}, [...svg$1, ...svgFilters, ...svgDisallowed]);
        const ALL_MATHML_TAGS = addToSet({}, [...mathMl$1, ...mathMlDisallowed]);
        const _checkValidNamespace = function _checkValidNamespace2(element2) {
          let parent2 = getParentNode(element2);
          if (!parent2 || !parent2.tagName) {
            parent2 = {
              namespaceURI: NAMESPACE,
              tagName: "template"
            };
          }
          const tagName = stringToLowerCase(element2.tagName);
          const parentTagName = stringToLowerCase(parent2.tagName);
          if (!ALLOWED_NAMESPACES[element2.namespaceURI]) {
            return false;
          }
          if (element2.namespaceURI === SVG_NAMESPACE) {
            if (parent2.namespaceURI === HTML_NAMESPACE) {
              return tagName === "svg";
            }
            if (parent2.namespaceURI === MATHML_NAMESPACE) {
              return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
            }
            return Boolean(ALL_SVG_TAGS[tagName]);
          }
          if (element2.namespaceURI === MATHML_NAMESPACE) {
            if (parent2.namespaceURI === HTML_NAMESPACE) {
              return tagName === "math";
            }
            if (parent2.namespaceURI === SVG_NAMESPACE) {
              return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
            }
            return Boolean(ALL_MATHML_TAGS[tagName]);
          }
          if (element2.namespaceURI === HTML_NAMESPACE) {
            if (parent2.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
              return false;
            }
            if (parent2.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
              return false;
            }
            return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
          }
          if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element2.namespaceURI]) {
            return true;
          }
          return false;
        };
        const _forceRemove = function _forceRemove2(node) {
          arrayPush(DOMPurify.removed, {
            element: node
          });
          try {
            getParentNode(node).removeChild(node);
          } catch (_) {
            remove2(node);
          }
        };
        const _removeAttribute = function _removeAttribute2(name2, element2) {
          try {
            arrayPush(DOMPurify.removed, {
              attribute: element2.getAttributeNode(name2),
              from: element2
            });
          } catch (_) {
            arrayPush(DOMPurify.removed, {
              attribute: null,
              from: element2
            });
          }
          element2.removeAttribute(name2);
          if (name2 === "is") {
            if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
              try {
                _forceRemove(element2);
              } catch (_) {
              }
            } else {
              try {
                element2.setAttribute(name2, "");
              } catch (_) {
              }
            }
          }
        };
        const _initDocument = function _initDocument2(dirty) {
          let doc = null;
          let leadingWhitespace = null;
          if (FORCE_BODY) {
            dirty = "<remove></remove>" + dirty;
          } else {
            const matches = stringMatch(dirty, /^[\r\n\t ]+/);
            leadingWhitespace = matches && matches[0];
          }
          if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
            dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
          }
          const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
          if (NAMESPACE === HTML_NAMESPACE) {
            try {
              doc = new DOMParser().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
            } catch (_) {
            }
          }
          if (!doc || !doc.documentElement) {
            doc = implementation.createDocument(NAMESPACE, "template", null);
            try {
              doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
            } catch (_) {
            }
          }
          const body2 = doc.body || doc.documentElement;
          if (dirty && leadingWhitespace) {
            body2.insertBefore(document2.createTextNode(leadingWhitespace), body2.childNodes[0] || null);
          }
          if (NAMESPACE === HTML_NAMESPACE) {
            return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
          }
          return WHOLE_DOCUMENT ? doc.documentElement : body2;
        };
        const _createNodeIterator = function _createNodeIterator2(root) {
          return createNodeIterator.call(
            root.ownerDocument || root,
            root,
            // eslint-disable-next-line no-bitwise
            NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT | NodeFilter.SHOW_PROCESSING_INSTRUCTION | NodeFilter.SHOW_CDATA_SECTION,
            null
          );
        };
        const _isClobbered = function _isClobbered2(element2) {
          return element2 instanceof HTMLFormElement && (typeof element2.nodeName !== "string" || typeof element2.textContent !== "string" || typeof element2.removeChild !== "function" || !(element2.attributes instanceof NamedNodeMap) || typeof element2.removeAttribute !== "function" || typeof element2.setAttribute !== "function" || typeof element2.namespaceURI !== "string" || typeof element2.insertBefore !== "function" || typeof element2.hasChildNodes !== "function");
        };
        const _isNode = function _isNode2(value2) {
          return typeof Node === "function" && value2 instanceof Node;
        };
        function _executeHooks(hooks2, currentNode, data) {
          arrayForEach(hooks2, (hook) => {
            hook.call(DOMPurify, currentNode, data, CONFIG);
          });
        }
        const _sanitizeElements = function _sanitizeElements2(currentNode) {
          let content = null;
          _executeHooks(hooks.beforeSanitizeElements, currentNode, null);
          if (_isClobbered(currentNode)) {
            _forceRemove(currentNode);
            return true;
          }
          const tagName = transformCaseFunc(currentNode.nodeName);
          _executeHooks(hooks.uponSanitizeElement, currentNode, {
            tagName,
            allowedTags: ALLOWED_TAGS
          });
          if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
            _forceRemove(currentNode);
            return true;
          }
          if (currentNode.nodeType === NODE_TYPE.progressingInstruction) {
            _forceRemove(currentNode);
            return true;
          }
          if (SAFE_FOR_XML && currentNode.nodeType === NODE_TYPE.comment && regExpTest(/<[/\w]/g, currentNode.data)) {
            _forceRemove(currentNode);
            return true;
          }
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            if (!FORBID_TAGS[tagName] && _isBasicCustomElement(tagName)) {
              if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) {
                return false;
              }
              if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) {
                return false;
              }
            }
            if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
              const parentNode2 = getParentNode(currentNode) || currentNode.parentNode;
              const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
              if (childNodes && parentNode2) {
                const childCount = childNodes.length;
                for (let i = childCount - 1; i >= 0; --i) {
                  const childClone = cloneNode(childNodes[i], true);
                  childClone.__removalCount = (currentNode.__removalCount || 0) + 1;
                  parentNode2.insertBefore(childClone, getNextSibling(currentNode));
                }
              }
            }
            _forceRemove(currentNode);
            return true;
          }
          if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
            _forceRemove(currentNode);
            return true;
          }
          if ((tagName === "noscript" || tagName === "noembed" || tagName === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
            _forceRemove(currentNode);
            return true;
          }
          if (SAFE_FOR_TEMPLATES && currentNode.nodeType === NODE_TYPE.text) {
            content = currentNode.textContent;
            arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
              content = stringReplace(content, expr, " ");
            });
            if (currentNode.textContent !== content) {
              arrayPush(DOMPurify.removed, {
                element: currentNode.cloneNode()
              });
              currentNode.textContent = content;
            }
          }
          _executeHooks(hooks.afterSanitizeElements, currentNode, null);
          return false;
        };
        const _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value2) {
          if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value2 in document2 || value2 in formElement)) {
            return false;
          }
          if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR2, lcName))
            ;
          else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR2, lcName))
            ;
          else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
            if (
              // First condition does a very basic check if a) it's basically a valid custom element tagname AND
              // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
              // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
              _isBasicCustomElement(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
              // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
              lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value2) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value2))
            )
              ;
            else {
              return false;
            }
          } else if (URI_SAFE_ATTRIBUTES[lcName])
            ;
          else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value2, ATTR_WHITESPACE2, "")))
            ;
          else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value2, "data:") === 0 && DATA_URI_TAGS[lcTag])
            ;
          else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA2, stringReplace(value2, ATTR_WHITESPACE2, "")))
            ;
          else if (value2) {
            return false;
          } else
            ;
          return true;
        };
        const _isBasicCustomElement = function _isBasicCustomElement2(tagName) {
          return tagName !== "annotation-xml" && stringMatch(tagName, CUSTOM_ELEMENT2);
        };
        const _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
          _executeHooks(hooks.beforeSanitizeAttributes, currentNode, null);
          const {
            attributes
          } = currentNode;
          if (!attributes || _isClobbered(currentNode)) {
            return;
          }
          const hookEvent = {
            attrName: "",
            attrValue: "",
            keepAttr: true,
            allowedAttributes: ALLOWED_ATTR,
            forceKeepAttr: void 0
          };
          let l2 = attributes.length;
          while (l2--) {
            const attr = attributes[l2];
            const {
              name: name2,
              namespaceURI,
              value: attrValue
            } = attr;
            const lcName = transformCaseFunc(name2);
            let value2 = name2 === "value" ? attrValue : stringTrim(attrValue);
            const initValue = value2;
            hookEvent.attrName = lcName;
            hookEvent.attrValue = value2;
            hookEvent.keepAttr = true;
            hookEvent.forceKeepAttr = void 0;
            _executeHooks(hooks.uponSanitizeAttribute, currentNode, hookEvent);
            value2 = hookEvent.attrValue;
            if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
              _removeAttribute(name2, currentNode);
              value2 = SANITIZE_NAMED_PROPS_PREFIX + value2;
            }
            if (SAFE_FOR_XML && regExpTest(/((--!?|])>)|<\/(style|title)/i, value2)) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (hookEvent.forceKeepAttr) {
              continue;
            }
            if (!hookEvent.keepAttr) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value2)) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (SAFE_FOR_TEMPLATES) {
              arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
                value2 = stringReplace(value2, expr, " ");
              });
            }
            const lcTag = transformCaseFunc(currentNode.nodeName);
            if (!_isValidAttribute(lcTag, lcName, value2)) {
              _removeAttribute(name2, currentNode);
              continue;
            }
            if (trustedTypesPolicy && typeof trustedTypes === "object" && typeof trustedTypes.getAttributeType === "function") {
              if (namespaceURI)
                ;
              else {
                switch (trustedTypes.getAttributeType(lcTag, lcName)) {
                  case "TrustedHTML": {
                    value2 = trustedTypesPolicy.createHTML(value2);
                    break;
                  }
                  case "TrustedScriptURL": {
                    value2 = trustedTypesPolicy.createScriptURL(value2);
                    break;
                  }
                }
              }
            }
            if (value2 !== initValue) {
              try {
                if (namespaceURI) {
                  currentNode.setAttributeNS(namespaceURI, name2, value2);
                } else {
                  currentNode.setAttribute(name2, value2);
                }
                if (_isClobbered(currentNode)) {
                  _forceRemove(currentNode);
                } else {
                  arrayPop(DOMPurify.removed);
                }
              } catch (_) {
              }
            }
          }
          _executeHooks(hooks.afterSanitizeAttributes, currentNode, null);
        };
        const _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
          let shadowNode = null;
          const shadowIterator = _createNodeIterator(fragment);
          _executeHooks(hooks.beforeSanitizeShadowDOM, fragment, null);
          while (shadowNode = shadowIterator.nextNode()) {
            _executeHooks(hooks.uponSanitizeShadowNode, shadowNode, null);
            _sanitizeElements(shadowNode);
            _sanitizeAttributes(shadowNode);
            if (shadowNode.content instanceof DocumentFragment) {
              _sanitizeShadowDOM2(shadowNode.content);
            }
          }
          _executeHooks(hooks.afterSanitizeShadowDOM, fragment, null);
        };
        DOMPurify.sanitize = function(dirty) {
          let cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          let body2 = null;
          let importedNode = null;
          let currentNode = null;
          let returnNode = null;
          IS_EMPTY_INPUT = !dirty;
          if (IS_EMPTY_INPUT) {
            dirty = "<!-->";
          }
          if (typeof dirty !== "string" && !_isNode(dirty)) {
            if (typeof dirty.toString === "function") {
              dirty = dirty.toString();
              if (typeof dirty !== "string") {
                throw typeErrorCreate("dirty is not a string, aborting");
              }
            } else {
              throw typeErrorCreate("toString is not a function");
            }
          }
          if (!DOMPurify.isSupported) {
            return dirty;
          }
          if (!SET_CONFIG) {
            _parseConfig(cfg);
          }
          DOMPurify.removed = [];
          if (typeof dirty === "string") {
            IN_PLACE = false;
          }
          if (IN_PLACE) {
            if (dirty.nodeName) {
              const tagName = transformCaseFunc(dirty.nodeName);
              if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
                throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
              }
            }
          } else if (dirty instanceof Node) {
            body2 = _initDocument("<!---->");
            importedNode = body2.ownerDocument.importNode(dirty, true);
            if (importedNode.nodeType === NODE_TYPE.element && importedNode.nodeName === "BODY") {
              body2 = importedNode;
            } else if (importedNode.nodeName === "HTML") {
              body2 = importedNode;
            } else {
              body2.appendChild(importedNode);
            }
          } else {
            if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
            dirty.indexOf("<") === -1) {
              return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
            }
            body2 = _initDocument(dirty);
            if (!body2) {
              return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
            }
          }
          if (body2 && FORCE_BODY) {
            _forceRemove(body2.firstChild);
          }
          const nodeIterator = _createNodeIterator(IN_PLACE ? dirty : body2);
          while (currentNode = nodeIterator.nextNode()) {
            _sanitizeElements(currentNode);
            _sanitizeAttributes(currentNode);
            if (currentNode.content instanceof DocumentFragment) {
              _sanitizeShadowDOM(currentNode.content);
            }
          }
          if (IN_PLACE) {
            return dirty;
          }
          if (RETURN_DOM) {
            if (RETURN_DOM_FRAGMENT) {
              returnNode = createDocumentFragment.call(body2.ownerDocument);
              while (body2.firstChild) {
                returnNode.appendChild(body2.firstChild);
              }
            } else {
              returnNode = body2;
            }
            if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
              returnNode = importNode.call(originalDocument, returnNode, true);
            }
            return returnNode;
          }
          let serializedHTML = WHOLE_DOCUMENT ? body2.outerHTML : body2.innerHTML;
          if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body2.ownerDocument && body2.ownerDocument.doctype && body2.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body2.ownerDocument.doctype.name)) {
            serializedHTML = "<!DOCTYPE " + body2.ownerDocument.doctype.name + ">\n" + serializedHTML;
          }
          if (SAFE_FOR_TEMPLATES) {
            arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
              serializedHTML = stringReplace(serializedHTML, expr, " ");
            });
          }
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
        };
        DOMPurify.setConfig = function() {
          let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
          _parseConfig(cfg);
          SET_CONFIG = true;
        };
        DOMPurify.clearConfig = function() {
          CONFIG = null;
          SET_CONFIG = false;
        };
        DOMPurify.isValidAttribute = function(tag, attr, value2) {
          if (!CONFIG) {
            _parseConfig({});
          }
          const lcTag = transformCaseFunc(tag);
          const lcName = transformCaseFunc(attr);
          return _isValidAttribute(lcTag, lcName, value2);
        };
        DOMPurify.addHook = function(entryPoint, hookFunction) {
          if (typeof hookFunction !== "function") {
            return;
          }
          arrayPush(hooks[entryPoint], hookFunction);
        };
        DOMPurify.removeHook = function(entryPoint, hookFunction) {
          if (hookFunction !== void 0) {
            const index = arrayLastIndexOf(hooks[entryPoint], hookFunction);
            return index === -1 ? void 0 : arraySplice(hooks[entryPoint], index, 1)[0];
          }
          return arrayPop(hooks[entryPoint]);
        };
        DOMPurify.removeHooks = function(entryPoint) {
          hooks[entryPoint] = [];
        };
        DOMPurify.removeAllHooks = function() {
          hooks = _createHooksMap();
        };
        return DOMPurify;
      }
      var purify = createDOMPurify();
      const sanitizeHtmlString = (html2) => purify().sanitize(html2);
      var global$6 = tinymce.util.Tools.resolve("tinymce.util.I18n");
      const rtlTransform = {
        "indent": true,
        "outdent": true,
        "table-insert-column-after": true,
        "table-insert-column-before": true,
        "paste-column-after": true,
        "paste-column-before": true,
        "unordered-list": true,
        "list-bull-circle": true,
        "list-bull-disc": true,
        "list-bull-default": true,
        "list-bull-square": true
      };
      const defaultIconName = "temporary-placeholder";
      const defaultIcon = (icons) => () => get$h(icons, defaultIconName).getOr("!not found!");
      const getIconName = (name2, icons) => {
        const lcName = name2.toLowerCase();
        if (global$6.isRtl()) {
          const rtlName = ensureTrailing(lcName, "-rtl");
          return has$2(icons, rtlName) ? rtlName : lcName;
        } else {
          return lcName;
        }
      };
      const lookupIcon = (name2, icons) => get$h(icons, getIconName(name2, icons));
      const get = (name2, iconProvider) => {
        const icons = iconProvider();
        return lookupIcon(name2, icons).getOrThunk(defaultIcon(icons));
      };
      const getOr = (name2, iconProvider, fallbackIcon) => {
        const icons = iconProvider();
        return lookupIcon(name2, icons).or(fallbackIcon).getOrThunk(defaultIcon(icons));
      };
      const needsRtlTransform = (iconName) => global$6.isRtl() ? has$2(rtlTransform, iconName) : false;
      const addFocusableBehaviour = () => config("add-focusable", [
        runOnAttached((comp) => {
          child(comp.element, "svg").each((svg2) => set$9(svg2, "focusable", "false"));
        })
      ]);
      const renderIcon$3 = (spec, iconName, icons, fallbackIcon) => {
        var _a, _b;
        const rtlIconClasses = needsRtlTransform(iconName) ? ["tox-icon--flip"] : [];
        const iconHtml = get$h(icons, getIconName(iconName, icons)).or(fallbackIcon).getOrThunk(defaultIcon(icons));
        return {
          dom: {
            tag: spec.tag,
            attributes: (_a = spec.attributes) !== null && _a !== void 0 ? _a : {},
            classes: spec.classes.concat(rtlIconClasses),
            innerHtml: iconHtml
          },
          behaviours: derive$1([
            ...(_b = spec.behaviours) !== null && _b !== void 0 ? _b : [],
            addFocusableBehaviour()
          ])
        };
      };
      const render$4 = (iconName, spec, iconProvider, fallbackIcon = Optional.none()) => renderIcon$3(spec, iconName, iconProvider(), fallbackIcon);
      const renderFirst = (iconNames, spec, iconProvider) => {
        const icons = iconProvider();
        const iconName = find$5(iconNames, (name2) => has$2(icons, getIconName(name2, icons)));
        return renderIcon$3(spec, iconName.getOr(defaultIconName), icons, Optional.none());
      };
      const notificationIconMap = {
        success: "checkmark",
        error: "warning",
        err: "error",
        warning: "warning",
        warn: "warning",
        info: "info"
      };
      const factory$4 = (detail) => {
        const notificationTextId = generate$6("notification-text");
        const memBannerText = record({
          dom: fromHtml(`<p id=${notificationTextId}>${sanitizeHtmlString(detail.backstageProvider.translate(detail.text))}</p>`),
          behaviours: derive$1([
            Replacing.config({})
          ])
        });
        const renderPercentBar = (percent) => ({
          dom: {
            tag: "div",
            classes: ["tox-bar"],
            styles: {
              width: `${percent}%`
            }
          }
        });
        const renderPercentText = (percent) => ({
          dom: {
            tag: "div",
            classes: ["tox-text"],
            innerHtml: `${percent}%`
          }
        });
        const memBannerProgress = record({
          dom: {
            tag: "div",
            classes: detail.progress ? ["tox-progress-bar", "tox-progress-indicator"] : ["tox-progress-bar"]
          },
          components: [
            {
              dom: {
                tag: "div",
                classes: ["tox-bar-container"]
              },
              components: [
                renderPercentBar(0)
              ]
            },
            renderPercentText(0)
          ],
          behaviours: derive$1([
            Replacing.config({})
          ])
        });
        const updateProgress = (comp, percent) => {
          if (comp.getSystem().isConnected()) {
            memBannerProgress.getOpt(comp).each((progress) => {
              Replacing.set(progress, [
                {
                  dom: {
                    tag: "div",
                    classes: ["tox-bar-container"]
                  },
                  components: [
                    renderPercentBar(percent)
                  ]
                },
                renderPercentText(percent)
              ]);
            });
          }
        };
        const updateText = (comp, text2) => {
          if (comp.getSystem().isConnected()) {
            const banner = memBannerText.get(comp);
            Replacing.set(banner, [
              text$2(text2)
            ]);
          }
        };
        const apis = {
          updateProgress,
          updateText
        };
        const iconChoices = flatten([
          detail.icon.toArray(),
          [detail.level],
          Optional.from(notificationIconMap[detail.level]).toArray()
        ]);
        const memButton = record(Button.sketch({
          dom: {
            tag: "button",
            classes: ["tox-notification__dismiss", "tox-button", "tox-button--naked", "tox-button--icon"],
            attributes: {
              "aria-label": detail.backstageProvider.translate("Close")
            }
          },
          components: [
            render$4("close", {
              tag: "span",
              classes: ["tox-icon"]
            }, detail.iconProvider)
          ],
          buttonBehaviours: derive$1([
            Tabstopping.config({}),
            Tooltipping.config({
              ...detail.backstageProvider.tooltips.getConfig({
                tooltipText: detail.backstageProvider.translate("Close")
              })
            })
          ]),
          action: (comp) => {
            detail.onAction(comp);
          }
        }));
        const notificationIconSpec = renderFirst(iconChoices, { tag: "div", classes: ["tox-notification__icon"] }, detail.iconProvider);
        const notificationBodySpec = {
          dom: {
            tag: "div",
            classes: ["tox-notification__body"]
          },
          components: [
            memBannerText.asSpec()
          ],
          behaviours: derive$1([
            Replacing.config({})
          ])
        };
        const components2 = [notificationIconSpec, notificationBodySpec];
        return {
          uid: detail.uid,
          dom: {
            tag: "div",
            attributes: {
              "role": "alert",
              "aria-labelledby": notificationTextId
            },
            classes: ["tox-notification", "tox-notification--in", `tox-notification--${detail.level}`]
          },
          behaviours: derive$1([
            Tabstopping.config({}),
            Focusing.config({}),
            Keying.config({
              mode: "special",
              onEscape: (comp) => {
                detail.onAction(comp);
                return Optional.some(true);
              }
            })
          ]),
          components: components2.concat(detail.progress ? [memBannerProgress.asSpec()] : []).concat([memButton.asSpec()]),
          apis
        };
      };
      const Notification = single({
        name: "Notification",
        factory: factory$4,
        configFields: [
          defaultedStringEnum("level", "info", ["success", "error", "warning", "warn", "info"]),
          required$1("progress"),
          option$3("icon"),
          required$1("onAction"),
          required$1("text"),
          required$1("iconProvider"),
          required$1("backstageProvider")
        ],
        apis: {
          updateProgress: (apis, comp, percent) => {
            apis.updateProgress(comp, percent);
          },
          updateText: (apis, comp, text2) => {
            apis.updateText(comp, text2);
          }
        }
      });
      var NotificationManagerImpl = (editor, extras, uiMothership, notificationRegion) => {
        const sharedBackstage = extras.backstage.shared;
        const getBoundsContainer = () => SugarElement.fromDom(editor.queryCommandValue("ToggleView") === "" ? editor.getContentAreaContainer() : editor.getContainer());
        const getBounds2 = () => {
          const contentArea = box$1(getBoundsContainer());
          return Optional.some(contentArea);
        };
        const clampComponentsToBounds = (components2) => {
          getBounds2().each((bounds2) => {
            each$1(components2, (comp) => {
              remove$6(comp.element, "width");
              if (get$c(comp.element) > bounds2.width) {
                set$7(comp.element, "width", bounds2.width + "px");
              }
            });
          });
        };
        const open2 = (settings, closeCallback, isEditorOrUIFocused) => {
          const close3 = () => {
            const removeNotificationAndReposition = (region) => {
              Replacing.remove(region, notification);
              reposition2();
            };
            const manageRegionVisibility = (region, editorOrUiFocused) => {
              if (children(region.element).length === 0) {
                handleEmptyRegion(region, editorOrUiFocused);
              } else {
                handleRegionWithChildren(region, editorOrUiFocused);
              }
            };
            const handleEmptyRegion = (region, editorOrUIFocused) => {
              InlineView.hide(region);
              notificationRegion.clear();
              if (editorOrUIFocused) {
                editor.focus();
              }
            };
            const handleRegionWithChildren = (region, editorOrUIFocused) => {
              if (editorOrUIFocused) {
                Keying.focusIn(region);
              }
            };
            notificationRegion.on((region) => {
              closeCallback();
              const editorOrUIFocused = isEditorOrUIFocused();
              removeNotificationAndReposition(region);
              manageRegionVisibility(region, editorOrUIFocused);
            });
          };
          const shouldApplyDocking = () => !isStickyToolbar(editor) || !sharedBackstage.header.isPositionedAtTop();
          const notification = build$1(Notification.sketch({
            text: settings.text,
            level: contains$2(["success", "error", "warning", "warn", "info"], settings.type) ? settings.type : void 0,
            progress: settings.progressBar === true,
            icon: settings.icon,
            onAction: close3,
            iconProvider: sharedBackstage.providers.icons,
            backstageProvider: sharedBackstage.providers
          }));
          if (!notificationRegion.isSet()) {
            const notificationWrapper = build$1(InlineView.sketch({
              dom: {
                tag: "div",
                classes: ["tox-notifications-container"],
                attributes: {
                  "aria-label": "Notifications",
                  "role": "region"
                }
              },
              lazySink: sharedBackstage.getSink,
              fireDismissalEventInstead: {},
              ...sharedBackstage.header.isPositionedAtTop() ? {} : { fireRepositionEventInstead: {} },
              inlineBehaviours: derive$1([
                Keying.config({
                  mode: "cyclic",
                  selector: ".tox-notification, .tox-notification a, .tox-notification button"
                }),
                Replacing.config({}),
                ...shouldApplyDocking() ? [
                  Docking.config({
                    contextual: {
                      lazyContext: () => Optional.some(box$1(getBoundsContainer())),
                      fadeInClass: "tox-notification-container-dock-fadein",
                      fadeOutClass: "tox-notification-container-dock-fadeout",
                      transitionClass: "tox-notification-container-dock-transition"
                    },
                    modes: ["top"],
                    lazyViewport: (comp) => {
                      const optScrollingContext = detectWhenSplitUiMode(editor, comp.element);
                      return optScrollingContext.map((sc) => {
                        const combinedBounds = getBoundsFrom(sc);
                        return {
                          bounds: combinedBounds,
                          optScrollEnv: Optional.some({
                            currentScrollTop: sc.element.dom.scrollTop,
                            scrollElmTop: absolute$3(sc.element).top
                          })
                        };
                      }).getOrThunk(() => ({
                        bounds: win(),
                        optScrollEnv: Optional.none()
                      }));
                    }
                  })
                ] : []
              ])
            }));
            const notificationSpec = premade(notification);
            const anchorOverrides2 = {
              maxHeightFunction: expandable$1()
            };
            const anchor2 = {
              ...sharedBackstage.anchors.banner(),
              overrides: anchorOverrides2
            };
            notificationRegion.set(notificationWrapper);
            uiMothership.add(notificationWrapper);
            InlineView.showWithinBounds(notificationWrapper, notificationSpec, { anchor: anchor2 }, getBounds2);
          } else {
            const notificationSpec = premade(notification);
            notificationRegion.on((notificationWrapper) => {
              Replacing.append(notificationWrapper, notificationSpec);
              InlineView.reposition(notificationWrapper);
              if (notification.hasConfigured(Docking)) {
                Docking.refresh(notificationWrapper);
              }
              clampComponentsToBounds(notificationWrapper.components());
            });
          }
          if (isNumber(settings.timeout) && settings.timeout > 0) {
            global$a.setEditorTimeout(editor, () => {
              close3();
            }, settings.timeout);
          }
          const reposition2 = () => {
            notificationRegion.on((region) => {
              InlineView.reposition(region);
              if (region.hasConfigured(Docking)) {
                Docking.refresh(region);
              }
              clampComponentsToBounds(region.components());
            });
          };
          const thisNotification = {
            close: close3,
            reposition: reposition2,
            text: (nuText) => {
              Notification.updateText(notification, nuText);
            },
            settings,
            getEl: () => notification.element.dom,
            progressBar: {
              value: (percent) => {
                Notification.updateProgress(notification, percent);
              }
            }
          };
          return thisNotification;
        };
        const close2 = (notification) => {
          notification.close();
        };
        const getArgs = (notification) => {
          return notification.settings;
        };
        return {
          open: open2,
          close: close2,
          getArgs
        };
      };
      const setup$c = (api2, editor) => {
        const redirectKeyToItem = (item2, e) => {
          emitWith(item2, keydown(), { raw: e });
        };
        const getItem = () => api2.getMenu().bind(Highlighting.getHighlighted);
        editor.on("keydown", (e) => {
          const keyCode = e.which;
          if (!api2.isActive()) {
            return;
          }
          if (api2.isMenuOpen()) {
            if (keyCode === 13) {
              getItem().each(emitExecute);
              e.preventDefault();
            } else if (keyCode === 40) {
              getItem().fold(
                // No current item, so highlight the first one
                () => {
                  api2.getMenu().each(Highlighting.highlightFirst);
                },
                // There is a current item, so move down in the menu
                (item2) => {
                  redirectKeyToItem(item2, e);
                }
              );
              e.preventDefault();
              e.stopImmediatePropagation();
            } else if (keyCode === 37 || keyCode === 38 || keyCode === 39) {
              getItem().each((item2) => {
                redirectKeyToItem(item2, e);
                e.preventDefault();
                e.stopImmediatePropagation();
              });
            }
          } else {
            if (keyCode === 13 || keyCode === 38 || keyCode === 40) {
              api2.cancelIfNecessary();
            }
          }
        });
        editor.on("NodeChange", () => {
          if (api2.isActive() && !api2.isProcessingAction() && !editor.queryCommandState("mceAutoCompleterInRange")) {
            api2.cancelIfNecessary();
          }
        });
      };
      const AutocompleterEditorEvents = {
        setup: setup$c
      };
      var ItemResponse;
      (function(ItemResponse2) {
        ItemResponse2[ItemResponse2["CLOSE_ON_EXECUTE"] = 0] = "CLOSE_ON_EXECUTE";
        ItemResponse2[ItemResponse2["BUBBLE_TO_SANDBOX"] = 1] = "BUBBLE_TO_SANDBOX";
      })(ItemResponse || (ItemResponse = {}));
      var ItemResponse$1 = ItemResponse;
      const navClass = "tox-menu-nav__js";
      const selectableClass = "tox-collection__item";
      const colorClass = "tox-swatch";
      const presetClasses = {
        normal: navClass,
        color: colorClass
      };
      const tickedClass = "tox-collection__item--enabled";
      const groupHeadingClass = "tox-collection__group-heading";
      const iconClass = "tox-collection__item-icon";
      const imageClass = "tox-collection__item-image";
      const imageSelectorClasll = "tox-collection__item-image-selector";
      const textClass = "tox-collection__item-label";
      const accessoryClass = "tox-collection__item-accessory";
      const caretClass = "tox-collection__item-caret";
      const checkmarkClass = "tox-collection__item-checkmark";
      const activeClass = "tox-collection__item--active";
      const containerClass = "tox-collection__item-container";
      const containerColumnClass = "tox-collection__item-container--column";
      const containerRowClass = "tox-collection__item-container--row";
      const containerAlignRightClass = "tox-collection__item-container--align-right";
      const containerAlignLeftClass = "tox-collection__item-container--align-left";
      const containerValignTopClass = "tox-collection__item-container--valign-top";
      const containerValignMiddleClass = "tox-collection__item-container--valign-middle";
      const containerValignBottomClass = "tox-collection__item-container--valign-bottom";
      const classForPreset = (presets) => get$h(presetClasses, presets).getOr(navClass);
      const forMenu = (presets) => {
        if (presets === "color") {
          return "tox-swatches";
        } else {
          return "tox-menu";
        }
      };
      const classes = (presets) => ({
        backgroundMenu: "tox-background-menu",
        selectedMenu: "tox-selected-menu",
        selectedItem: "tox-collection__item--active",
        hasIcons: "tox-menu--has-icons",
        menu: forMenu(presets),
        tieredMenu: "tox-tiered-menu"
      });
      const markers = (presets) => {
        const menuClasses = classes(presets);
        return {
          backgroundMenu: menuClasses.backgroundMenu,
          selectedMenu: menuClasses.selectedMenu,
          menu: menuClasses.menu,
          selectedItem: menuClasses.selectedItem,
          item: classForPreset(presets)
        };
      };
      const dom = (hasIcons, columns, presets) => {
        const menuClasses = classes(presets);
        return {
          tag: "div",
          classes: flatten([
            [menuClasses.menu, `tox-menu-${columns}-column`],
            hasIcons ? [menuClasses.hasIcons] : []
          ])
        };
      };
      const components = [
        Menu.parts.items({})
      ];
      const part = (hasIcons, columns, presets) => {
        const menuClasses = classes(presets);
        const d = {
          tag: "div",
          classes: flatten([
            [menuClasses.tieredMenu]
          ])
        };
        return {
          dom: d,
          markers: markers(presets)
        };
      };
      const refetchTriggerEvent = generate$6("refetch-trigger-event");
      const redirectMenuItemInteractionEvent = generate$6("redirect-menu-item-interaction");
      const menuSearcherClass = "tox-menu__searcher";
      const findWithinSandbox = (sandboxComp) => {
        return descendant(sandboxComp.element, `.${menuSearcherClass}`).bind((inputElem) => sandboxComp.getSystem().getByDom(inputElem).toOptional());
      };
      const findWithinMenu = findWithinSandbox;
      const restoreState = (inputComp, searcherState) => {
        Representing.setValue(inputComp, searcherState.fetchPattern);
        inputComp.element.dom.selectionStart = searcherState.selectionStart;
        inputComp.element.dom.selectionEnd = searcherState.selectionEnd;
      };
      const saveState = (inputComp) => {
        const fetchPattern = Representing.getValue(inputComp);
        const selectionStart = inputComp.element.dom.selectionStart;
        const selectionEnd = inputComp.element.dom.selectionEnd;
        return {
          fetchPattern,
          selectionStart,
          selectionEnd
        };
      };
      const setActiveDescendant = (inputComp, active2) => {
        getOpt(active2.element, "id").each((id) => set$9(inputComp.element, "aria-activedescendant", id));
      };
      const renderMenuSearcher = (spec) => {
        const handleByBrowser = (comp, se) => {
          se.cut();
          return Optional.none();
        };
        const handleByHighlightedItem = (comp, se) => {
          const eventData = {
            interactionEvent: se.event,
            eventType: se.event.raw.type
          };
          emitWith(comp, redirectMenuItemInteractionEvent, eventData);
          return Optional.some(true);
        };
        const customSearcherEventsName = "searcher-events";
        return {
          dom: {
            tag: "div",
            // NOTE: This is very intentionally NOT the navigation class, because
            // we don't want the searcher to be part of the navigation. This class
            // is just for styling consistency. Perhaps it should be its own class.
            classes: [selectableClass]
          },
          components: [
            Input.sketch({
              inputClasses: [menuSearcherClass, "tox-textfield"],
              inputAttributes: {
                ...spec.placeholder.map((placeholder2) => ({ placeholder: spec.i18n(placeholder2) })).getOr({}),
                // This ARIA is based on the algolia example documented in TINY-8952
                "type": "search",
                "aria-autocomplete": "list"
              },
              inputBehaviours: derive$1([
                config(customSearcherEventsName, [
                  // When the user types into the search field, we want to retrigger
                  // a fetch on the dropdown. This will be fired from within the
                  // dropdown's sandbox, so the dropdown is going to have to listen
                  // for it there. See CommonDropdown.ts.
                  run$1(
                    // Use "input" to handle keydown, paste etc.
                    input(),
                    (inputComp) => {
                      emit(inputComp, refetchTriggerEvent);
                    }
                  ),
                  run$1(keydown(), (inputComp, se) => {
                    if (se.event.raw.key === "Escape") {
                      se.stop();
                    }
                  })
                ]),
                // In addition to input handling, we want special handling for
                // Up/Down/Left/Right/Enter/Escape/Space. We can divide these into two categories
                //  - events that we don't want to allow the overall menu system to process (left and right and space)
                //  - events that we want to redispatch on the "highlighted item" based on the
                // current fake focus.
                Keying.config({
                  mode: "special",
                  onLeft: handleByBrowser,
                  onRight: handleByBrowser,
                  onSpace: handleByBrowser,
                  onEnter: handleByHighlightedItem,
                  onEscape: handleByHighlightedItem,
                  onUp: handleByHighlightedItem,
                  onDown: handleByHighlightedItem
                })
              ]),
              // Because we have customised handling for keydown, and we are configuring
              // Keying, we need to specify which "behaviour" (custom events or keying) gets to
              // process the keydown event first. In this situation, we want to stop escape before
              // anything happens (although it really isn't necessary)
              eventOrder: {
                keydown: [customSearcherEventsName, Keying.name()]
              }
            })
          ]
        };
      };
      const searchResultsClass = "tox-collection--results__js";
      const augmentWithAria = (item2) => {
        var _a;
        if (item2.dom) {
          return {
            ...item2,
            dom: {
              ...item2.dom,
              attributes: {
                ...(_a = item2.dom.attributes) !== null && _a !== void 0 ? _a : {},
                "id": generate$6("aria-item-search-result-id"),
                "aria-selected": "false"
              }
            }
          };
        } else {
          return item2;
        }
      };
      const chunk = (rowDom, numColumns) => (items) => {
        const chunks = chunk$1(items, numColumns);
        return map$2(chunks, (c) => ({
          dom: rowDom,
          components: c
        }));
      };
      const forSwatch = (columns) => ({
        dom: {
          tag: "div",
          classes: ["tox-menu", "tox-swatches-menu"]
        },
        components: [
          {
            dom: {
              tag: "div",
              classes: ["tox-swatches"]
            },
            components: [
              Menu.parts.items({
                preprocess: columns !== "auto" ? chunk({
                  tag: "div",
                  classes: ["tox-swatches__row"]
                }, columns) : identity
              })
            ]
          }
        ]
      });
      const forImageSelector = (columns) => ({
        dom: {
          tag: "div",
          classes: ["tox-menu", "tox-image-selector-menu"]
        },
        components: [
          {
            dom: {
              tag: "div",
              classes: ["tox-image-selector"]
            },
            components: [
              Menu.parts.items({
                preprocess: columns !== "auto" ? chunk({
                  tag: "div",
                  classes: ["tox-image-selector__row"]
                }, columns) : identity
              })
            ]
          }
        ]
      });
      const forToolbar = (columns) => ({
        dom: {
          tag: "div",
          // TODO: Configurable lg setting?
          classes: ["tox-menu", "tox-collection", "tox-collection--toolbar", "tox-collection--toolbar-lg"]
        },
        components: [
          Menu.parts.items({
            preprocess: chunk({
              tag: "div",
              classes: ["tox-collection__group"]
            }, columns)
          })
        ]
      });
      const preprocessCollection = (items, isSeparator2) => {
        const allSplits = [];
        let currentSplit = [];
        each$1(items, (item2, i) => {
          if (isSeparator2(item2, i)) {
            if (currentSplit.length > 0) {
              allSplits.push(currentSplit);
            }
            currentSplit = [];
            if (has$2(item2.dom, "innerHtml") || item2.components && item2.components.length > 0) {
              currentSplit.push(item2);
            }
          } else {
            currentSplit.push(item2);
          }
        });
        if (currentSplit.length > 0) {
          allSplits.push(currentSplit);
        }
        return map$2(allSplits, (s) => ({
          dom: {
            tag: "div",
            classes: ["tox-collection__group"]
          },
          components: s
        }));
      };
      const insertItemsPlaceholder = (columns, initItems, onItem) => {
        return Menu.parts.items({
          preprocess: (rawItems) => {
            const enrichedItems = map$2(rawItems, onItem);
            if (columns !== "auto" && columns > 1) {
              return chunk({
                tag: "div",
                classes: ["tox-collection__group"]
              }, columns)(enrichedItems);
            } else {
              return preprocessCollection(enrichedItems, (_item, i) => initItems[i].type === "separator");
            }
          }
        });
      };
      const forCollection = (columns, initItems, _hasIcons = true) => ({
        dom: {
          tag: "div",
          classes: ["tox-menu", "tox-collection"].concat(columns === 1 ? ["tox-collection--list"] : ["tox-collection--grid"])
        },
        components: [
          // We don't need to add IDs for each item because there are no
          // aria relationships we need to maintain
          insertItemsPlaceholder(columns, initItems, identity)
        ]
      });
      const forCollectionWithSearchResults = (columns, initItems, _hasIcons = true) => {
        const ariaControlsSearchResults = generate$6("aria-controls-search-results");
        return {
          dom: {
            tag: "div",
            classes: ["tox-menu", "tox-collection", searchResultsClass].concat(columns === 1 ? ["tox-collection--list"] : ["tox-collection--grid"]),
            attributes: {
              id: ariaControlsSearchResults
            }
          },
          components: [
            // For each item, it needs to have an ID, so that we can refer to it
            // by the aria-activedescendant attribute
            insertItemsPlaceholder(columns, initItems, augmentWithAria)
          ]
        };
      };
      const forCollectionWithSearchField = (columns, initItems, searchField) => {
        const ariaControlsSearchResults = generate$6("aria-controls-search-results");
        return {
          dom: {
            tag: "div",
            classes: ["tox-menu", "tox-collection"].concat(columns === 1 ? ["tox-collection--list"] : ["tox-collection--grid"])
          },
          components: [
            // Importantly, the search bar is not in the "items" part, which means that it is
            // not given any of the item decorations by default. In order to ensure that is
            // not part of the navigation, however, we need to prevent it from getting the nav
            // class. For general collection menu items, it is navClass, which is:
            // tox-menu-nav__js. So simply, do not add this class when creating
            // the search, so that it isn't in the navigation. Ideally, it would only ever look
            // inside its items section, but the items aren't guaranteed to have a separate
            // container, and navigation candidates are found anywhere inside the menu
            // container. We could add configuration to alloy's Menu movement, where there was
            // a 'navigation container' that all items would be in. That could be another
            // way to solve the problem. For now, we'll just manually avoid adding the navClass
            renderMenuSearcher({
              i18n: global$6.translate,
              placeholder: searchField.placeholder
            }),
            {
              // We need a separate container for the items, because this is the container
              // that multiple tox-collection__groups might go into, and will be the container
              // that the search bar controls.
              dom: {
                tag: "div",
                classes: [
                  ...columns === 1 ? ["tox-collection--list"] : ["tox-collection--grid"],
                  searchResultsClass
                ],
                attributes: {
                  id: ariaControlsSearchResults
                }
              },
              components: [
                // For each item, it needs to have an ID, so that we can refer to it
                // by the aria-activedescendant attribute
                insertItemsPlaceholder(columns, initItems, augmentWithAria)
              ]
            }
          ]
        };
      };
      const forHorizontalCollection = (initItems, _hasIcons = true) => ({
        dom: {
          tag: "div",
          classes: ["tox-collection", "tox-collection--horizontal"]
        },
        components: [
          Menu.parts.items({
            preprocess: (items) => preprocessCollection(items, (_item, i) => initItems[i].type === "separator")
          })
        ]
      });
      const menuHasIcons = (xs) => exists(xs, (item2) => "icon" in item2 && item2.icon !== void 0);
      const handleError = (error2) => {
        console.error(formatError(error2));
        console.log(error2);
        return Optional.none();
      };
      const createHorizontalPartialMenuWithAlloyItems = (value2, _hasIcons, items, _columns, _menuLayout) => {
        const structure = forHorizontalCollection(items);
        return {
          value: value2,
          dom: structure.dom,
          components: structure.components,
          items
        };
      };
      const createPartialMenuWithAlloyItems = (value2, hasIcons, items, columns, menuLayout) => {
        const getNormalStructure = () => {
          if (menuLayout.menuType !== "searchable") {
            return forCollection(columns, items);
          } else {
            return menuLayout.searchMode.searchMode === "search-with-field" ? forCollectionWithSearchField(columns, items, menuLayout.searchMode) : forCollectionWithSearchResults(columns, items);
          }
        };
        if (menuLayout.menuType === "color") {
          const structure = forSwatch(columns);
          return {
            value: value2,
            dom: structure.dom,
            components: structure.components,
            items
          };
        } else if (menuLayout.menuType === "imageselector" && columns !== "auto") {
          const structure = forImageSelector(columns);
          return {
            value: value2,
            dom: structure.dom,
            components: structure.components,
            items
          };
        } else if (menuLayout.menuType === "normal" && columns === "auto") {
          const structure = forCollection(columns, items);
          return {
            value: value2,
            dom: structure.dom,
            components: structure.components,
            items
          };
        } else if (menuLayout.menuType === "normal" || menuLayout.menuType === "searchable") {
          const structure = getNormalStructure();
          return {
            value: value2,
            dom: structure.dom,
            components: structure.components,
            items
          };
        } else if (menuLayout.menuType === "listpreview" && columns !== "auto") {
          const structure = forToolbar(columns);
          return {
            value: value2,
            dom: structure.dom,
            components: structure.components,
            items
          };
        } else {
          return {
            value: value2,
            dom: dom(hasIcons, columns, menuLayout.menuType),
            components,
            items
          };
        }
      };
      const type = requiredString("type");
      const name = requiredString("name");
      const label = requiredString("label");
      const text = requiredString("text");
      const title = requiredString("title");
      const icon = requiredString("icon");
      const url = requiredString("url");
      const value = requiredString("value");
      const fetch = requiredFunction("fetch");
      const getSubmenuItems = requiredFunction("getSubmenuItems");
      const onAction = requiredFunction("onAction");
      const onItemAction = requiredFunction("onItemAction");
      const onSetup = defaultedFunction("onSetup", () => noop);
      const optionalName = optionString("name");
      const optionalText = optionString("text");
      const optionalRole = optionString("role");
      const optionalIcon = optionString("icon");
      const optionalTooltip = optionString("tooltip");
      const optionalLabel = optionString("label");
      const optionalShortcut = optionString("shortcut");
      const optionalSelect = optionFunction("select");
      const active = defaultedBoolean("active", false);
      const borderless = defaultedBoolean("borderless", false);
      const enabled = defaultedBoolean("enabled", true);
      const primary = defaultedBoolean("primary", false);
      const defaultedColumns = (num) => defaulted("columns", num);
      const defaultedMeta = defaulted("meta", {});
      const defaultedOnAction = defaultedFunction("onAction", noop);
      const defaultedType = (type2) => defaultedString("type", type2);
      const generatedName = (namePrefix) => field$1("name", "name", defaultedThunk(() => generate$6(`${namePrefix}-name`)), string);
      const generatedValue = (valuePrefix) => field$1("value", "value", defaultedThunk(() => generate$6(`${valuePrefix}-value`)), anyValue());
      const alertBannerFields = [
        type,
        text,
        requiredStringEnum("level", ["info", "warn", "error", "success"]),
        icon,
        defaulted("url", "")
      ];
      const alertBannerSchema = objOf(alertBannerFields);
      const createBarFields = (itemsField) => [
        type,
        itemsField
      ];
      const buttonFields = [
        type,
        text,
        enabled,
        generatedName("button"),
        optionalIcon,
        borderless,
        // this should be defaulted to `secondary` but the implementation needs to manage the deprecation
        optionStringEnum("buttonType", ["primary", "secondary", "toolbar"]),
        // this should be removed, but must live here because FieldSchema doesn't have a way to manage deprecated fields
        primary,
        defaultedString("context", "mode:design")
      ];
      const buttonSchema = objOf(buttonFields);
      const formComponentFields = [
        type,
        name
      ];
      const formComponentWithLabelFields = formComponentFields.concat([
        optionalLabel
      ]);
      const checkboxFields = formComponentFields.concat([
        label,
        enabled,
        defaultedString("context", "mode:design")
      ]);
      const checkboxSchema = objOf(checkboxFields);
      const checkboxDataProcessor = boolean;
      const collectionFields = formComponentWithLabelFields.concat([
        defaultedColumns("auto"),
        defaultedString("context", "mode:design")
      ]);
      const collectionSchema = objOf(collectionFields);
      const collectionDataProcessor = arrOfObj([
        value,
        text,
        icon
      ]);
      const colorInputFields = formComponentWithLabelFields.concat([
        defaultedString("storageKey", "default"),
        defaultedString("context", "mode:design")
      ]);
      const colorInputSchema = objOf(colorInputFields);
      const colorInputDataProcessor = string;
      const colorPickerFields = formComponentWithLabelFields;
      const colorPickerSchema = objOf(colorPickerFields);
      const colorPickerDataProcessor = string;
      const customEditorFields = formComponentFields.concat([
        defaultedString("tag", "textarea"),
        requiredString("scriptId"),
        requiredString("scriptUrl"),
        optionFunction("onFocus"),
        defaultedPostMsg("settings", void 0)
      ]);
      const customEditorFieldsOld = formComponentFields.concat([
        defaultedString("tag", "textarea"),
        requiredFunction("init")
      ]);
      const customEditorSchema = valueOf((v) => asRaw("customeditor.old", objOfOnly(customEditorFieldsOld), v).orThunk(() => asRaw("customeditor.new", objOfOnly(customEditorFields), v)));
      const customEditorDataProcessor = string;
      const commonMenuItemFields = [
        enabled,
        optionalText,
        optionalRole,
        optionalShortcut,
        generatedValue("menuitem"),
        defaultedMeta,
        defaultedString("context", "mode:design")
      ];
      const dialogToggleMenuItemSchema = objOf([
        type,
        name
      ].concat(commonMenuItemFields));
      const dialogToggleMenuItemDataProcessor = boolean;
      const baseFooterButtonFields = [
        generatedName("button"),
        optionalIcon,
        defaultedStringEnum("align", "end", ["start", "end"]),
        // this should be removed, but must live here because FieldSchema doesn't have a way to manage deprecated fields
        primary,
        enabled,
        // this should be defaulted to `secondary` but the implementation needs to manage the deprecation
        optionStringEnum("buttonType", ["primary", "secondary"]),
        defaultedString("context", "mode:design")
      ];
      const dialogFooterButtonFields = [
        ...baseFooterButtonFields,
        text
      ];
      const normalFooterButtonFields = [
        requiredStringEnum("type", ["submit", "cancel", "custom"]),
        ...dialogFooterButtonFields
      ];
      const menuFooterButtonFields = [
        requiredStringEnum("type", ["menu"]),
        optionalText,
        optionalTooltip,
        optionalIcon,
        requiredArrayOf("items", dialogToggleMenuItemSchema),
        ...baseFooterButtonFields
      ];
      const toggleButtonSpecFields = [
        ...baseFooterButtonFields,
        requiredStringEnum("type", ["togglebutton"]),
        optionalTooltip,
        optionalIcon,
        optionalText,
        defaultedBoolean("active", false)
      ];
      const dialogFooterButtonSchema = choose$1("type", {
        submit: normalFooterButtonFields,
        cancel: normalFooterButtonFields,
        custom: normalFooterButtonFields,
        menu: menuFooterButtonFields,
        togglebutton: toggleButtonSpecFields
      });
      const dropZoneFields = formComponentWithLabelFields.concat([
        defaultedString("context", "mode:design")
      ]);
      const dropZoneSchema = objOf(dropZoneFields);
      const dropZoneDataProcessor = arrOfVal();
      const createGridFields = (itemsField) => [
        type,
        requiredNumber("columns"),
        itemsField
      ];
      const htmlPanelFields = [
        type,
        requiredString("html"),
        defaultedStringEnum("presets", "presentation", ["presentation", "document"]),
        defaultedFunction("onInit", noop),
        defaultedBoolean("stretched", false)
      ];
      const htmlPanelSchema = objOf(htmlPanelFields);
      const iframeFields = formComponentWithLabelFields.concat([
        defaultedBoolean("border", false),
        defaultedBoolean("sandboxed", true),
        defaultedBoolean("streamContent", false),
        defaultedBoolean("transparent", true)
      ]);
      const iframeSchema = objOf(iframeFields);
      const iframeDataProcessor = string;
      const imagePreviewSchema = objOf(formComponentFields.concat([
        optionString("height")
      ]));
      const imagePreviewDataProcessor = objOf([
        requiredString("url"),
        optionNumber("zoom"),
        optionNumber("cachedWidth"),
        optionNumber("cachedHeight")
      ]);
      const inputFields = formComponentWithLabelFields.concat([
        optionString("inputMode"),
        optionString("placeholder"),
        defaultedBoolean("maximized", false),
        enabled,
        defaultedString("context", "mode:design")
      ]);
      const inputSchema = objOf(inputFields);
      const inputDataProcessor = string;
      const createLabelFields = (itemsField) => [
        type,
        label,
        itemsField,
        defaultedStringEnum("align", "start", ["start", "center", "end"]),
        optionString("for")
      ];
      const listBoxSingleItemFields = [
        text,
        value
      ];
      const listBoxNestedItemFields = [
        text,
        requiredArrayOf("items", thunkOf("items", () => listBoxItemSchema))
      ];
      const listBoxItemSchema = oneOf([
        objOf(listBoxSingleItemFields),
        objOf(listBoxNestedItemFields)
      ]);
      const listBoxFields = formComponentWithLabelFields.concat([
        requiredArrayOf("items", listBoxItemSchema),
        enabled,
        defaultedString("context", "mode:design")
      ]);
      const listBoxSchema = objOf(listBoxFields);
      const listBoxDataProcessor = string;
      const selectBoxFields = formComponentWithLabelFields.concat([
        requiredArrayOfObj("items", [
          text,
          value
        ]),
        defaultedNumber("size", 1),
        enabled,
        defaultedString("context", "mode:design")
      ]);
      const selectBoxSchema = objOf(selectBoxFields);
      const selectBoxDataProcessor = string;
      const sizeInputFields = formComponentWithLabelFields.concat([
        defaultedBoolean("constrain", true),
        enabled,
        defaultedString("context", "mode:design")
      ]);
      const sizeInputSchema = objOf(sizeInputFields);
      const sizeInputDataProcessor = objOf([
        requiredString("width"),
        requiredString("height")
      ]);
      const sliderFields = formComponentFields.concat([
        label,
        defaultedNumber("min", 0),
        defaultedNumber("max", 0)
      ]);
      const sliderSchema = objOf(sliderFields);
      const sliderInputDataProcessor = number;
      const tableFields = [
        type,
        requiredArrayOf("header", string),
        requiredArrayOf("cells", arrOf(string))
      ];
      const tableSchema = objOf(tableFields);
      const textAreaFields = formComponentWithLabelFields.concat([
        optionString("placeholder"),
        defaultedBoolean("maximized", false),
        enabled,
        defaultedString("context", "mode:design")
      ]);
      const textAreaSchema = objOf(textAreaFields);
      const textAreaDataProcessor = string;
      const baseMenuButtonFields = [
        defaultedString("buttonType", "default"),
        optionString("text"),
        optionString("tooltip"),
        optionString("icon"),
        defaultedOf(
          "search",
          false,
          // So our boulder validation are:
          // a) boolean -> we need to map it into an Option
          // b) object -> we need to map it into a Some
          oneOf(
            [
              // Unfortunately, due to objOf not checking to see that the
              // input is an object, the boolean check MUST be first
              boolean,
              objOf([
                optionString("placeholder")
              ])
            ],
            // This function allows you to standardise the output.
            (x) => {
              if (isBoolean(x)) {
                return x ? Optional.some({ placeholder: Optional.none() }) : Optional.none();
              } else {
                return Optional.some(x);
              }
            }
          )
        ),
        requiredFunction("fetch"),
        defaultedFunction("onSetup", () => noop),
        defaultedString("context", "mode:design")
      ];
      const MenuButtonSchema = objOf([
        type,
        ...baseMenuButtonFields
      ]);
      const createMenuButton = (spec) => asRaw("menubutton", MenuButtonSchema, spec);
      const baseTreeItemFields = [
        requiredStringEnum("type", ["directory", "leaf"]),
        title,
        requiredString("id"),
        optionOf("menu", MenuButtonSchema),
        optionString("customStateIcon"),
        optionString("customStateIconTooltip")
      ];
      const treeItemLeafFields = baseTreeItemFields;
      const treeItemLeafSchema = objOf(treeItemLeafFields);
      const treeItemDirectoryFields = baseTreeItemFields.concat([
        requiredArrayOf("children", thunkOf("children", () => {
          return choose$2("type", {
            directory: treeItemDirectorySchema,
            leaf: treeItemLeafSchema
          });
        }))
      ]);
      const treeItemDirectorySchema = objOf(treeItemDirectoryFields);
      const treeItemSchema = choose$2("type", {
        directory: treeItemDirectorySchema,
        leaf: treeItemLeafSchema
      });
      const treeFields = [
        type,
        requiredArrayOf("items", treeItemSchema),
        optionFunction("onLeafAction"),
        optionFunction("onToggleExpand"),
        defaultedArrayOf("defaultExpandedIds", [], string),
        optionString("defaultSelectedId")
      ];
      const treeSchema = objOf(treeFields);
      const urlInputFields = formComponentWithLabelFields.concat([
        defaultedStringEnum("filetype", "file", ["image", "media", "file"]),
        enabled,
        optionString("picker_text"),
        defaultedString("context", "mode:design")
      ]);
      const urlInputSchema = objOf(urlInputFields);
      const urlInputDataProcessor = objOf([
        value,
        defaultedMeta
      ]);
      const createItemsField = (name2) => field$1("items", "items", required$2(), arrOf(valueOf((v) => asRaw(`Checking item of ${name2}`, itemSchema$1, v).fold((sErr) => Result.error(formatError(sErr)), (passValue) => Result.value(passValue)))));
      const itemSchema$1 = valueThunk(() => choose$2("type", {
        alertbanner: alertBannerSchema,
        bar: objOf(createBarFields(createItemsField("bar"))),
        button: buttonSchema,
        checkbox: checkboxSchema,
        colorinput: colorInputSchema,
        colorpicker: colorPickerSchema,
        dropzone: dropZoneSchema,
        grid: objOf(createGridFields(createItemsField("grid"))),
        iframe: iframeSchema,
        input: inputSchema,
        listbox: listBoxSchema,
        selectbox: selectBoxSchema,
        sizeinput: sizeInputSchema,
        slider: sliderSchema,
        textarea: textAreaSchema,
        urlinput: urlInputSchema,
        customeditor: customEditorSchema,
        htmlpanel: htmlPanelSchema,
        imagepreview: imagePreviewSchema,
        collection: collectionSchema,
        label: objOf(createLabelFields(createItemsField("label"))),
        table: tableSchema,
        tree: treeSchema,
        panel: panelSchema
      }));
      const panelFields = [
        type,
        defaulted("classes", []),
        requiredArrayOf("items", itemSchema$1)
      ];
      const panelSchema = objOf(panelFields);
      const tabFields = [
        generatedName("tab"),
        title,
        requiredArrayOf("items", itemSchema$1)
      ];
      const tabPanelFields = [
        type,
        requiredArrayOfObj("tabs", tabFields)
      ];
      const tabPanelSchema = objOf(tabPanelFields);
      const dialogButtonFields = dialogFooterButtonFields;
      const dialogButtonSchema = dialogFooterButtonSchema;
      const dialogSchema = objOf([
        requiredString("title"),
        requiredOf("body", choose$2("type", {
          panel: panelSchema,
          tabpanel: tabPanelSchema
        })),
        defaultedString("size", "normal"),
        defaultedArrayOf("buttons", [], dialogButtonSchema),
        defaulted("initialData", {}),
        defaultedFunction("onAction", noop),
        defaultedFunction("onChange", noop),
        defaultedFunction("onSubmit", noop),
        defaultedFunction("onClose", noop),
        defaultedFunction("onCancel", noop),
        defaultedFunction("onTabChange", noop)
      ]);
      const createDialog = (spec) => asRaw("dialog", dialogSchema, spec);
      const urlDialogButtonSchema = objOf([
        requiredStringEnum("type", ["cancel", "custom"]),
        ...dialogButtonFields
      ]);
      const urlDialogSchema = objOf([
        requiredString("title"),
        requiredString("url"),
        optionNumber("height"),
        optionNumber("width"),
        optionArrayOf("buttons", urlDialogButtonSchema),
        defaultedFunction("onAction", noop),
        defaultedFunction("onCancel", noop),
        defaultedFunction("onClose", noop),
        defaultedFunction("onMessage", noop)
      ]);
      const createUrlDialog = (spec) => asRaw("dialog", urlDialogSchema, spec);
      const getAllObjects = (obj) => {
        if (isObject(obj)) {
          return [obj].concat(bind$3(values(obj), getAllObjects));
        } else if (isArray(obj)) {
          return bind$3(obj, getAllObjects);
        } else {
          return [];
        }
      };
      const isNamedItem = (obj) => isString(obj.type) && isString(obj.name);
      const dataProcessors = {
        checkbox: checkboxDataProcessor,
        colorinput: colorInputDataProcessor,
        colorpicker: colorPickerDataProcessor,
        dropzone: dropZoneDataProcessor,
        input: inputDataProcessor,
        iframe: iframeDataProcessor,
        imagepreview: imagePreviewDataProcessor,
        selectbox: selectBoxDataProcessor,
        sizeinput: sizeInputDataProcessor,
        slider: sliderInputDataProcessor,
        listbox: listBoxDataProcessor,
        size: sizeInputDataProcessor,
        textarea: textAreaDataProcessor,
        urlinput: urlInputDataProcessor,
        customeditor: customEditorDataProcessor,
        collection: collectionDataProcessor,
        togglemenuitem: dialogToggleMenuItemDataProcessor
      };
      const getDataProcessor = (item2) => Optional.from(dataProcessors[item2.type]);
      const getNamedItems = (structure) => filter$2(getAllObjects(structure), isNamedItem);
      const createDataValidator = (structure) => {
        const namedItems = getNamedItems(structure);
        const fields = bind$3(namedItems, (item2) => getDataProcessor(item2).fold(() => [], (schema2) => [requiredOf(item2.name, schema2)]));
        return objOf(fields);
      };
      const extract = (structure) => {
        var _a;
        const internalDialog = getOrDie(createDialog(structure));
        const dataValidator = createDataValidator(structure);
        const initialData = (_a = structure.initialData) !== null && _a !== void 0 ? _a : {};
        return {
          internalDialog,
          dataValidator,
          initialData
        };
      };
      const DialogManager = {
        open: (factory2, structure) => {
          const extraction = extract(structure);
          return factory2(extraction.internalDialog, extraction.initialData, extraction.dataValidator);
        },
        openUrl: (factory2, structure) => {
          const internalDialog = getOrDie(createUrlDialog(structure));
          return factory2(internalDialog);
        },
        redial: (structure) => extract(structure)
      };
      const separatorMenuItemSchema = objOf([
        type,
        optionalText
      ]);
      const createSeparatorMenuItem = (spec) => asRaw("separatormenuitem", separatorMenuItemSchema, spec);
      const autocompleterItemSchema = objOf([
        // Currently, autocomplete items don't support configuring type, active, disabled, meta
        defaultedType("autocompleteitem"),
        active,
        enabled,
        defaultedMeta,
        value,
        optionalText,
        optionalIcon
      ]);
      objOf([
        type,
        requiredString("trigger"),
        defaultedNumber("minChars", 1),
        defaultedColumns(1),
        defaultedNumber("maxResults", 10),
        optionFunction("matches"),
        fetch,
        onAction,
        defaultedArrayOf("highlightOn", [], string)
      ]);
      const createSeparatorItem = (spec) => asRaw("Autocompleter.Separator", separatorMenuItemSchema, spec);
      const createAutocompleterItem = (spec) => asRaw("Autocompleter.Item", autocompleterItemSchema, spec);
      const baseToolbarButtonFields = [
        enabled,
        optionalTooltip,
        optionalIcon,
        optionalText,
        onSetup,
        defaultedString("context", "mode:design")
      ];
      const toolbarButtonSchema = objOf([
        type,
        onAction,
        optionalShortcut
      ].concat(baseToolbarButtonFields));
      const createToolbarButton = (spec) => asRaw("toolbarbutton", toolbarButtonSchema, spec);
      const baseToolbarToggleButtonFields = [
        active
      ].concat(baseToolbarButtonFields);
      const toggleButtonSchema = objOf(baseToolbarToggleButtonFields.concat([
        type,
        onAction,
        optionalShortcut
      ]));
      const createToggleButton = (spec) => asRaw("ToggleButton", toggleButtonSchema, spec);
      const contextBarFields = [
        defaultedFunction("predicate", never),
        defaultedStringEnum("scope", "node", ["node", "editor"]),
        defaultedStringEnum("position", "selection", ["node", "selection", "line"])
      ];
      const contextButtonFields = baseToolbarButtonFields.concat([
        defaultedType("contextformbutton"),
        defaultedString("align", "end"),
        primary,
        onAction,
        customField("original", identity)
      ]);
      const contextToggleButtonFields = baseToolbarToggleButtonFields.concat([
        defaultedType("contextformbutton"),
        defaultedString("align", "end"),
        primary,
        onAction,
        customField("original", identity)
      ]);
      const launchButtonFields$1 = baseToolbarButtonFields.concat([
        defaultedType("contextformbutton")
      ]);
      const launchToggleButtonFields = baseToolbarToggleButtonFields.concat([
        defaultedType("contextformtogglebutton")
      ]);
      const toggleOrNormal = choose$1("type", {
        contextformbutton: contextButtonFields,
        contextformtogglebutton: contextToggleButtonFields
      });
      const baseContextFormFields = [
        optionalLabel,
        requiredArrayOf("commands", toggleOrNormal),
        optionOf("launch", choose$1("type", {
          contextformbutton: launchButtonFields$1,
          contextformtogglebutton: launchToggleButtonFields
        })),
        defaultedFunction("onInput", noop),
        defaultedFunction("onSetup", noop)
      ];
      const contextFormFields = [
        ...contextBarFields,
        ...baseContextFormFields,
        requiredStringEnum("type", ["contextform"]),
        defaultedFunction("initValue", constant$1("")),
        optionString("placeholder")
      ];
      const contextSliderFormFields = [
        ...contextBarFields,
        ...baseContextFormFields,
        requiredStringEnum("type", ["contextsliderform"]),
        defaultedFunction("initValue", constant$1(0)),
        defaultedFunction("min", constant$1(0)),
        defaultedFunction("max", constant$1(100))
      ];
      const contextSizeInputFormFields = [
        ...contextBarFields,
        ...baseContextFormFields,
        requiredStringEnum("type", ["contextsizeinputform"]),
        defaultedFunction("initValue", constant$1({ width: "", height: "" }))
      ];
      const contextFormSchema = choose$1("type", {
        contextform: contextFormFields,
        contextsliderform: contextSliderFormFields,
        contextsizeinputform: contextSizeInputFormFields
      });
      const createContextForm = (spec) => asRaw("ContextForm", contextFormSchema, spec);
      const launchButtonFields = baseToolbarButtonFields.concat([
        defaultedType("contexttoolbarbutton")
      ]);
      const contextToolbarSchema = objOf([
        defaultedType("contexttoolbar"),
        optionObjOf("launch", launchButtonFields),
        requiredOf("items", oneOf([
          string,
          arrOfObj([
            optionString("name"),
            optionString("label"),
            requiredArrayOf("items", string)
          ])
        ]))
      ].concat(contextBarFields));
      const toolbarGroupBackToSpec = (toolbarGroup) => ({
        name: toolbarGroup.name.getOrUndefined(),
        label: toolbarGroup.label.getOrUndefined(),
        items: toolbarGroup.items
      });
      const contextToolbarToSpec = (contextToolbar) => ({
        ...contextToolbar,
        launch: contextToolbar.launch.getOrUndefined(),
        items: isString(contextToolbar.items) ? contextToolbar.items : map$2(contextToolbar.items, toolbarGroupBackToSpec)
      });
      const createContextToolbar = (spec) => asRaw("ContextToolbar", contextToolbarSchema, spec);
      const cardImageFields = [
        type,
        requiredString("src"),
        optionString("alt"),
        defaultedArrayOf("classes", [], string)
      ];
      const cardImageSchema = objOf(cardImageFields);
      const cardTextFields = [
        type,
        text,
        optionalName,
        defaultedArrayOf("classes", ["tox-collection__item-label"], string)
      ];
      const cardTextSchema = objOf(cardTextFields);
      const itemSchema = valueThunk(() => choose$2("type", {
        cardimage: cardImageSchema,
        cardtext: cardTextSchema,
        cardcontainer: cardContainerSchema
      }));
      const cardContainerSchema = objOf([
        type,
        defaultedString("direction", "horizontal"),
        defaultedString("align", "left"),
        defaultedString("valign", "middle"),
        requiredArrayOf("items", itemSchema)
      ]);
      const cardMenuItemSchema = objOf([
        type,
        optionalLabel,
        requiredArrayOf("items", itemSchema),
        onSetup,
        defaultedOnAction
      ].concat(commonMenuItemFields));
      const createCardMenuItem = (spec) => asRaw("cardmenuitem", cardMenuItemSchema, spec);
      const choiceMenuItemSchema = objOf([
        type,
        active,
        optionalIcon,
        optionalLabel
      ].concat(commonMenuItemFields));
      const createChoiceMenuItem = (spec) => asRaw("choicemenuitem", choiceMenuItemSchema, spec);
      const baseFields = [
        type,
        requiredString("fancytype"),
        defaultedOnAction
      ];
      const insertTableFields = [
        defaulted("initData", {})
      ].concat(baseFields);
      const colorSwatchFields = [
        optionFunction("select"),
        defaultedObjOf("initData", {}, [
          defaultedBoolean("allowCustomColors", true),
          defaultedString("storageKey", "default"),
          // Note: We don't validate the colors as they are instead validated by choiceschema when rendering
          optionArrayOf("colors", anyValue())
        ])
      ].concat(baseFields);
      const imageSelectFields = [
        optionFunction("select"),
        requiredObjOf("initData", [
          requiredNumber("columns"),
          // Note: We don't validate the items as they are instead validated by imageMenuItemSchema when rendering
          defaultedArrayOf("items", [], anyValue())
        ])
      ].concat(baseFields);
      const fancyMenuItemSchema = choose$1("fancytype", {
        inserttable: insertTableFields,
        colorswatch: colorSwatchFields,
        imageselect: imageSelectFields
      });
      const createFancyMenuItem = (spec) => asRaw("fancymenuitem", fancyMenuItemSchema, spec);
      const imageMenuItemSchema = objOf([
        type,
        active,
        url,
        optionalLabel,
        optionalTooltip
      ].concat(commonMenuItemFields));
      const resetImageItemSchema = objOf([
        type,
        active,
        icon,
        label,
        optionalTooltip,
        value
      ].concat(commonMenuItemFields));
      const createImageMenuItem = (spec) => asRaw("imagemenuitem", imageMenuItemSchema, spec);
      const createResetImageItem = (spec) => asRaw("resetimageitem", resetImageItemSchema, spec);
      const menuItemSchema = objOf([
        type,
        onSetup,
        defaultedOnAction,
        optionalIcon
      ].concat(commonMenuItemFields));
      const createMenuItem = (spec) => asRaw("menuitem", menuItemSchema, spec);
      const nestedMenuItemSchema = objOf([
        type,
        getSubmenuItems,
        onSetup,
        optionalIcon
      ].concat(commonMenuItemFields));
      const createNestedMenuItem = (spec) => asRaw("nestedmenuitem", nestedMenuItemSchema, spec);
      const toggleMenuItemSchema = objOf([
        type,
        optionalIcon,
        active,
        onSetup,
        onAction
      ].concat(commonMenuItemFields));
      const createToggleMenuItem = (spec) => asRaw("togglemenuitem", toggleMenuItemSchema, spec);
      const sidebarSchema = objOf([
        optionalIcon,
        optionalTooltip,
        defaultedFunction("onShow", noop),
        defaultedFunction("onHide", noop),
        onSetup
      ]);
      const createSidebar = (spec) => asRaw("sidebar", sidebarSchema, spec);
      const groupToolbarButtonSchema = objOf([
        type,
        requiredOf("items", oneOf([
          arrOfObj([
            name,
            requiredArrayOf("items", string)
          ]),
          string
        ]))
      ].concat(baseToolbarButtonFields));
      const createGroupToolbarButton = (spec) => asRaw("GroupToolbarButton", groupToolbarButtonSchema, spec);
      const splitButtonSchema = objOf([
        type,
        optionalTooltip,
        optionalIcon,
        optionalText,
        optionalSelect,
        fetch,
        onSetup,
        // TODO: Validate the allowed presets
        defaultedStringEnum("presets", "normal", ["normal", "color", "listpreview"]),
        defaultedColumns(1),
        onAction,
        onItemAction,
        defaultedString("context", "mode:design")
      ]);
      const createSplitButton = (spec) => asRaw("SplitButton", splitButtonSchema, spec);
      const baseButtonFields = [
        optionalText,
        optionalIcon,
        optionString("tooltip"),
        defaultedStringEnum("buttonType", "secondary", ["primary", "secondary"]),
        defaultedBoolean("borderless", false),
        requiredFunction("onAction"),
        defaultedString("context", "mode:design")
      ];
      const normalButtonFields = [
        ...baseButtonFields,
        text,
        requiredStringEnum("type", ["button"])
      ];
      const toggleButtonFields = [
        ...baseButtonFields,
        defaultedBoolean("active", false),
        requiredStringEnum("type", ["togglebutton"])
      ];
      const schemaWithoutGroupButton = {
        button: normalButtonFields,
        togglebutton: toggleButtonFields
      };
      const groupFields = [
        requiredStringEnum("type", ["group"]),
        defaultedArrayOf("buttons", [], choose$1("type", schemaWithoutGroupButton))
      ];
      const viewButtonSchema = choose$1("type", {
        ...schemaWithoutGroupButton,
        group: groupFields
      });
      const viewSchema = objOf([
        defaultedArrayOf("buttons", [], viewButtonSchema),
        requiredFunction("onShow"),
        requiredFunction("onHide")
      ]);
      const createView = (spec) => asRaw("view", viewSchema, spec);
      const detectSize = (comp, margin, selectorClass) => {
        const descendants$1 = descendants(comp.element, "." + selectorClass);
        if (descendants$1.length > 0) {
          const columnLength = findIndex$1(descendants$1, (c) => {
            const thisTop = c.dom.getBoundingClientRect().top;
            const cTop = descendants$1[0].dom.getBoundingClientRect().top;
            return Math.abs(thisTop - cTop) > margin;
          }).getOr(descendants$1.length);
          return Optional.some({
            numColumns: columnLength,
            numRows: Math.ceil(descendants$1.length / columnLength)
          });
        } else {
          return Optional.none();
        }
      };
      const namedEvents = (name2, handlers2) => derive$1([
        config(name2, handlers2)
      ]);
      const unnamedEvents = (handlers2) => namedEvents(generate$6("unnamed-events"), handlers2);
      const SimpleBehaviours = {
        namedEvents,
        unnamedEvents
      };
      const item = (disabled) => Disabling.config({
        disabled,
        disableClass: "tox-collection__item--state-disabled"
      });
      const button = (disabled) => Disabling.config({
        disabled
      });
      const splitButton = (disabled) => Disabling.config({
        disabled,
        disableClass: "tox-tbtn--disabled"
      });
      const toolbarButton = (disabled) => Disabling.config({
        disabled,
        disableClass: "tox-tbtn--disabled",
        useNative: false
      });
      const DisablingConfigs = {
        item,
        button,
        splitButton,
        toolbarButton
      };
      const runWithApi = (info, comp) => {
        const api2 = info.getApi(comp);
        return (f2) => {
          f2(api2);
        };
      };
      const onControlAttached = (info, editorOffCell) => runOnAttached((comp) => {
        if (isFunction(info.onBeforeSetup)) {
          info.onBeforeSetup(comp);
        }
        const run2 = runWithApi(info, comp);
        run2((api2) => {
          const onDestroy = info.onSetup(api2);
          if (isFunction(onDestroy)) {
            editorOffCell.set(onDestroy);
          }
        });
      });
      const onControlDetached = (getApi2, editorOffCell) => runOnDetached((comp) => runWithApi(getApi2, comp)(editorOffCell.get()));
      const onContextFormControlDetached = (getApi2, editorOffCell, valueState) => runOnDetached((comp) => {
        valueState.set(Representing.getValue(comp));
        return runWithApi(getApi2, comp)(editorOffCell.get());
      });
      const UiStateChannel = "silver.uistate";
      const messageSetDisabled = "setDisabled";
      const messageSetEnabled = "setEnabled";
      const messageInit = "init";
      const messageSwitchMode = "switchmode";
      const modeContextMessages = [messageSwitchMode, messageInit];
      const broadcastEvents = (uiRefs, messageType) => {
        const outerContainer = uiRefs.mainUi.outerContainer;
        const motherships = [uiRefs.mainUi.mothership, ...uiRefs.uiMotherships];
        if (messageType === messageSetDisabled) {
          each$1(motherships, (m) => {
            m.broadcastOn([dismissPopups()], { target: outerContainer.element });
          });
        }
        each$1(motherships, (m) => {
          m.broadcastOn([UiStateChannel], messageType);
        });
      };
      const setupEventsForUi = (editor, uiRefs) => {
        editor.on("init SwitchMode", (event) => {
          broadcastEvents(uiRefs, event.type);
        });
        editor.on("DisabledStateChange", (event) => {
          if (!event.isDefaultPrevented()) {
            const messageType = event.state ? messageSetDisabled : messageInit;
            broadcastEvents(uiRefs, messageType);
            if (!event.state) {
              editor.nodeChanged();
            }
          }
        });
        editor.on("NodeChange", (e) => {
          const messageType = editor.ui.isEnabled() ? e.type : messageSetDisabled;
          broadcastEvents(uiRefs, messageType);
        });
        if (isReadOnly(editor)) {
          editor.mode.set("readonly");
        }
      };
      const toggleOnReceive = (getContext) => Receiving.config({
        channels: {
          [UiStateChannel]: {
            onReceive: (comp, messageType) => {
              if (messageType === messageSetDisabled || messageType === messageSetEnabled) {
                Disabling.set(comp, messageType === messageSetDisabled);
                return;
              }
              const { contextType, shouldDisable } = getContext();
              if (contextType === "mode" && !contains$2(modeContextMessages, messageType)) {
                return;
              }
              Disabling.set(comp, shouldDisable);
            }
          }
        }
      });
      const onMenuItemExecute = (info, itemResponse) => runOnExecute$1((comp, simulatedEvent) => {
        runWithApi(info, comp)(info.onAction);
        if (!info.triggersSubmenu && itemResponse === ItemResponse$1.CLOSE_ON_EXECUTE) {
          if (comp.getSystem().isConnected()) {
            emit(comp, sandboxClose());
          }
          simulatedEvent.stop();
        }
      });
      const menuItemEventOrder = {
        // TODO: use the constants provided by behaviours.
        [execute$5()]: ["disabling", "alloy.base.behaviour", "toggling", "item-events"]
      };
      const componentRenderPipeline = cat;
      const renderCommonItem = (spec, structure, itemResponse, providersBackstage) => {
        const editorOffCell = Cell(noop);
        return {
          type: "item",
          dom: structure.dom,
          components: componentRenderPipeline(structure.optComponents),
          data: spec.data,
          eventOrder: menuItemEventOrder,
          hasSubmenu: spec.triggersSubmenu,
          itemBehaviours: derive$1([
            config("item-events", [
              onMenuItemExecute(spec, itemResponse),
              onControlAttached(spec, editorOffCell),
              onControlDetached(spec, editorOffCell)
            ]),
            DisablingConfigs.item(() => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context)),
            Replacing.config({})
          ].concat(spec.itemBehaviours))
        };
      };
      const buildData = (source) => ({
        value: source.value,
        meta: {
          text: source.text.getOr(""),
          ...source.meta
        }
      });
      const renderImage$1 = (spec, imageUrl) => {
        var _a, _b;
        const spinnerElement = SugarElement.fromTag("div");
        add$2(spinnerElement, "tox-image-selector-loading-spinner");
        const addSpinnerElement = (loadingElement) => {
          add$2(loadingElement, "tox-image-selector-loading-spinner-wrapper");
          append$2(loadingElement, spinnerElement);
        };
        const removeSpinnerElement = (loadingElement) => {
          remove$3(loadingElement, "tox-image-selector-loading-spinner-wrapper");
          remove$7(spinnerElement);
        };
        return {
          dom: {
            tag: spec.tag,
            attributes: (_a = spec.attributes) !== null && _a !== void 0 ? _a : {},
            classes: spec.classes
          },
          components: [
            {
              dom: {
                tag: "div",
                classes: ["tox-image-selector-image-wrapper"]
              },
              components: [
                {
                  dom: {
                    tag: "img",
                    attributes: { src: imageUrl },
                    classes: ["tox-image-selector-image-img"]
                  }
                }
              ]
            },
            ...spec.checkMark.toArray()
          ],
          behaviours: derive$1([
            ...(_b = spec.behaviours) !== null && _b !== void 0 ? _b : [],
            config("render-image-events", [
              runOnAttached((component) => {
                addSpinnerElement(component.element);
                descendant(component.element, "img").each((image$1) => {
                  image(image$1).catch((e) => {
                    console.error(e);
                  }).finally(() => {
                    removeSpinnerElement(component.element);
                  });
                });
              })
            ])
          ])
        };
      };
      const render$3 = (imageUrl, spec) => renderImage$1(spec, imageUrl);
      const convertText = (source) => {
        const isMac = global$7.os.isMacOS() || global$7.os.isiOS();
        const mac = {
          alt: "⌥",
          ctrl: "⌃",
          shift: "⇧",
          meta: "⌘",
          access: "⌃⌥"
        };
        const other = {
          meta: "Ctrl",
          access: "Shift+Alt"
        };
        const replace2 = isMac ? mac : other;
        const shortcut = source.split("+");
        const updated = map$2(shortcut, (segment) => {
          const search2 = segment.toLowerCase().trim();
          return has$2(replace2, search2) ? replace2[search2] : segment;
        });
        return isMac ? updated.join("") : updated.join("+");
      };
      const renderIcon$2 = (name2, icons, classes2 = [iconClass]) => render$4(name2, { tag: "div", classes: classes2 }, icons);
      const renderText = (text2) => ({
        dom: {
          tag: "div",
          classes: [textClass]
        },
        components: [text$2(global$6.translate(text2))]
      });
      const renderHtml = (html2, classes2) => ({
        dom: {
          tag: "div",
          classes: classes2,
          innerHtml: html2
        }
      });
      const renderStyledText = (style, text2) => ({
        dom: {
          tag: "div",
          classes: [textClass]
        },
        components: [
          {
            dom: {
              tag: style.tag,
              styles: style.styles
            },
            components: [text$2(global$6.translate(text2))]
          }
        ]
      });
      const renderShortcut = (shortcut) => ({
        dom: {
          tag: "div",
          classes: [accessoryClass]
        },
        components: [
          text$2(convertText(shortcut))
        ]
      });
      const renderCheckmark = (icons) => renderIcon$2("checkmark", icons, [checkmarkClass]);
      const renderSubmenuCaret = (icons) => renderIcon$2("chevron-right", icons, [caretClass]);
      const renderDownwardsCaret = (icons) => renderIcon$2("chevron-down", icons, [caretClass]);
      const renderContainer = (container, components2) => {
        const directionClass = container.direction === "vertical" ? containerColumnClass : containerRowClass;
        const alignClass = container.align === "left" ? containerAlignLeftClass : containerAlignRightClass;
        const getValignClass = () => {
          switch (container.valign) {
            case "top":
              return containerValignTopClass;
            case "middle":
              return containerValignMiddleClass;
            case "bottom":
              return containerValignBottomClass;
          }
        };
        return {
          dom: {
            tag: "div",
            classes: [
              containerClass,
              directionClass,
              alignClass,
              getValignClass()
            ]
          },
          components: components2
        };
      };
      const renderImage = (src, classes2, alt) => ({
        dom: {
          tag: "img",
          classes: classes2,
          attributes: {
            src,
            alt: alt.getOr("")
          }
        }
      });
      const renderColorStructure = (item2, providerBackstage, fallbackIcon) => {
        const colorPickerCommand = "custom";
        const removeColorCommand = "remove";
        const itemValue = item2.value;
        const iconSvg = item2.iconContent.map((name2) => getOr(name2, providerBackstage.icons, fallbackIcon));
        const attributes = item2.ariaLabel.map((al) => ({
          "aria-label": providerBackstage.translate(al),
          "data-mce-name": al
        })).getOr({});
        const getDom = () => {
          const common = colorClass;
          const icon2 = iconSvg.getOr("");
          const baseDom = {
            tag: "div",
            attributes,
            classes: [common]
          };
          if (itemValue === colorPickerCommand) {
            return {
              ...baseDom,
              tag: "button",
              classes: [...baseDom.classes, "tox-swatches__picker-btn"],
              innerHtml: icon2
            };
          } else if (itemValue === removeColorCommand) {
            return {
              ...baseDom,
              classes: [...baseDom.classes, "tox-swatch--remove"],
              innerHtml: icon2
            };
          } else if (isNonNullable(itemValue)) {
            return {
              ...baseDom,
              attributes: {
                ...baseDom.attributes,
                "data-mce-color": itemValue
              },
              styles: {
                "background-color": itemValue
              },
              innerHtml: icon2
            };
          } else {
            return baseDom;
          }
        };
        return {
          dom: getDom(),
          optComponents: []
        };
      };
      const renderItemDomStructure = (ariaLabel, classes2) => {
        const domTitle = ariaLabel.map((label2) => ({
          attributes: {
            "id": generate$6("menu-item"),
            "aria-label": global$6.translate(label2)
          }
        })).getOr({});
        return {
          tag: "div",
          classes: [navClass, selectableClass].concat(classes2),
          ...domTitle
        };
      };
      const createLabel = (label2) => {
        return {
          dom: {
            tag: "label"
          },
          components: [
            text$2(label2)
          ]
        };
      };
      const renderNormalItemStructure = (info, providersBackstage, renderIcons, fallbackIcon) => {
        const iconSpec = { tag: "div", classes: [iconClass] };
        const renderIcon2 = (iconName) => render$4(iconName, iconSpec, providersBackstage.icons, fallbackIcon);
        const renderEmptyIcon = () => Optional.some({ dom: iconSpec });
        const leftIcon = renderIcons ? info.iconContent.map(renderIcon2).orThunk(renderEmptyIcon) : Optional.none();
        const checkmark = info.checkMark;
        const textRender = Optional.from(info.meta).fold(() => renderText, (meta) => has$2(meta, "style") ? curry(renderStyledText, meta.style) : renderText);
        const content = info.htmlContent.fold(() => info.textContent.map(textRender), (html2) => Optional.some(renderHtml(html2, [textClass])));
        const menuItem = {
          dom: renderItemDomStructure(info.ariaLabel, []),
          optComponents: [
            leftIcon,
            content,
            info.shortcutContent.map(renderShortcut),
            checkmark,
            info.caret,
            info.labelContent.map(createLabel)
          ]
        };
        return menuItem;
      };
      const renderImgItemStructure = (info) => {
        const menuItem = {
          dom: renderItemDomStructure(info.ariaLabel, [imageSelectorClasll]),
          optComponents: [
            Optional.some(render$3(info.iconContent.getOrDie(), { tag: "div", classes: [imageClass], checkMark: info.checkMark })),
            info.labelContent.map(createLabel)
          ]
        };
        return menuItem;
      };
      const renderItemStructure = (info, providersBackstage, renderIcons, fallbackIcon = Optional.none()) => {
        if (info.presets === "color") {
          return renderColorStructure(info, providersBackstage, fallbackIcon);
        } else if (info.presets === "img") {
          return renderImgItemStructure(info);
        } else {
          return renderNormalItemStructure(info, providersBackstage, renderIcons, fallbackIcon);
        }
      };
      const tooltipBehaviour = (meta, sharedBackstage, tooltipText) => get$h(meta, "tooltipWorker").map((tooltipWorker) => [
        Tooltipping.config({
          lazySink: sharedBackstage.getSink,
          tooltipDom: {
            tag: "div",
            classes: ["tox-tooltip-worker-container"]
          },
          tooltipComponents: [],
          anchor: (comp) => ({
            type: "submenu",
            item: comp,
            overrides: {
              // NOTE: this avoids it setting overflow and max-height.
              maxHeightFunction: expandable$1
            }
          }),
          mode: "follow-highlight",
          onShow: (component, _tooltip) => {
            tooltipWorker((elm) => {
              Tooltipping.setComponents(component, [
                external({ element: SugarElement.fromDom(elm) })
              ]);
            });
          }
        })
      ]).getOrThunk(() => {
        return tooltipText.map((text2) => [
          Tooltipping.config({
            ...sharedBackstage.providers.tooltips.getConfig({
              tooltipText: text2
            }),
            mode: "follow-highlight"
          })
        ]).getOr([]);
      });
      const encodeText = (text2) => global$9.DOM.encode(text2);
      const replaceText = (text2, matchText) => {
        const translated = global$6.translate(text2);
        const encoded = encodeText(translated);
        if (matchText.length > 0) {
          const escapedMatchRegex = new RegExp(escape(matchText), "gi");
          return encoded.replace(escapedMatchRegex, (match) => `<span class="tox-autocompleter-highlight">${match}</span>`);
        } else {
          return encoded;
        }
      };
      const renderAutocompleteItem = (spec, matchText, useText, presets, onItemValueHandler, itemResponse, sharedBackstage, renderIcons = true) => {
        const structure = renderItemStructure({
          presets,
          textContent: Optional.none(),
          htmlContent: useText ? spec.text.map((text2) => replaceText(text2, matchText)) : Optional.none(),
          ariaLabel: spec.text,
          labelContent: Optional.none(),
          iconContent: spec.icon,
          shortcutContent: Optional.none(),
          checkMark: Optional.none(),
          caret: Optional.none(),
          value: spec.value
        }, sharedBackstage.providers, renderIcons, spec.icon);
        const tooltipString = spec.text.filter((text2) => !useText && text2 !== "");
        return renderCommonItem({
          context: "mode:design",
          data: buildData(spec),
          enabled: spec.enabled,
          getApi: constant$1({}),
          onAction: (_api) => onItemValueHandler(spec.value, spec.meta),
          onSetup: constant$1(noop),
          triggersSubmenu: false,
          itemBehaviours: tooltipBehaviour(spec, sharedBackstage, tooltipString)
        }, structure, itemResponse, sharedBackstage.providers);
      };
      const render$2 = (items, extras) => map$2(items, (item2) => {
        switch (item2.type) {
          case "cardcontainer":
            return renderContainer(item2, render$2(item2.items, extras));
          case "cardimage":
            return renderImage(item2.src, item2.classes, item2.alt);
          case "cardtext":
            const shouldHighlight = item2.name.exists((name2) => contains$2(extras.cardText.highlightOn, name2));
            const matchText = shouldHighlight ? Optional.from(extras.cardText.matchText).getOr("") : "";
            return renderHtml(replaceText(item2.text, matchText), item2.classes);
        }
      });
      const renderCardMenuItem = (spec, itemResponse, sharedBackstage, extras) => {
        const getApi2 = (component) => ({
          isEnabled: () => !Disabling.isDisabled(component),
          setEnabled: (state) => {
            Disabling.set(component, !state);
            each$1(descendants(component.element, "*"), (elm) => {
              component.getSystem().getByDom(elm).each((comp) => {
                if (comp.hasConfigured(Disabling)) {
                  Disabling.set(comp, !state);
                }
              });
            });
          }
        });
        const structure = {
          dom: renderItemDomStructure(spec.label, []),
          optComponents: [
            Optional.some({
              dom: {
                tag: "div",
                classes: [containerClass, containerRowClass]
              },
              components: render$2(spec.items, extras)
            })
          ]
        };
        return renderCommonItem({
          context: "mode:design",
          data: buildData({ text: Optional.none(), ...spec }),
          enabled: spec.enabled,
          getApi: getApi2,
          onAction: spec.onAction,
          onSetup: spec.onSetup,
          triggersSubmenu: false,
          itemBehaviours: Optional.from(extras.itemBehaviours).getOr([])
        }, structure, itemResponse, sharedBackstage.providers);
      };
      const renderChoiceItem = (spec, useText, presets, onItemValueHandler, isSelected, itemResponse, providersBackstage, renderIcons = true) => {
        const getApi2 = (component) => ({
          setActive: (state) => {
            Toggling.set(component, state);
          },
          isActive: () => Toggling.isOn(component),
          isEnabled: () => !Disabling.isDisabled(component),
          setEnabled: (state) => Disabling.set(component, !state)
        });
        const structure = renderItemStructure({
          presets,
          textContent: useText ? spec.text : Optional.none(),
          htmlContent: Optional.none(),
          labelContent: spec.label,
          ariaLabel: spec.text,
          iconContent: spec.icon,
          shortcutContent: useText ? spec.shortcut : Optional.none(),
          // useText essentially says that we have one column. In one column lists, we should show a tick
          // The tick is controlled by the tickedClass (via css). It is always present
          // but is hidden unless the tickedClass is present.
          checkMark: useText ? Optional.some(renderCheckmark(providersBackstage.icons)) : Optional.none(),
          caret: Optional.none(),
          value: spec.value
        }, providersBackstage, renderIcons);
        const optTooltipping = spec.text.filter(constant$1(!useText)).map((t2) => Tooltipping.config(providersBackstage.tooltips.getConfig({
          tooltipText: providersBackstage.translate(t2)
        })));
        return deepMerge(renderCommonItem({
          context: spec.context,
          data: buildData(spec),
          enabled: spec.enabled,
          getApi: getApi2,
          onAction: (_api) => onItemValueHandler(spec.value),
          onSetup: (api2) => {
            api2.setActive(isSelected);
            return noop;
          },
          triggersSubmenu: false,
          itemBehaviours: [
            ...optTooltipping.toArray()
          ]
        }, structure, itemResponse, providersBackstage), {
          toggling: {
            toggleClass: tickedClass,
            toggleOnExecute: false,
            selected: spec.active,
            exclusive: true
          }
        });
      };
      const hexColour = (value2) => ({
        value: normalizeHex(value2)
      });
      const shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
      const longformRegex = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
      const isHexString = (hex) => shorthandRegex.test(hex) || longformRegex.test(hex);
      const normalizeHex = (hex) => removeLeading(hex, "#").toUpperCase();
      const fromString$1 = (hex) => isHexString(hex) ? Optional.some({ value: normalizeHex(hex) }) : Optional.none();
      const getLongForm = (hex) => {
        const hexString = hex.value.replace(shorthandRegex, (m, r2, g, b2) => r2 + r2 + g + g + b2 + b2);
        return { value: hexString };
      };
      const extractValues = (hex) => {
        const longForm = getLongForm(hex);
        const splitForm = longformRegex.exec(longForm.value);
        return splitForm === null ? ["FFFFFF", "FF", "FF", "FF"] : splitForm;
      };
      const toHex = (component) => {
        const hex = component.toString(16);
        return (hex.length === 1 ? "0" + hex : hex).toUpperCase();
      };
      const fromRgba = (rgbaColour2) => {
        const value2 = toHex(rgbaColour2.red) + toHex(rgbaColour2.green) + toHex(rgbaColour2.blue);
        return hexColour(value2);
      };
      const hsvColour = (hue, saturation, value2) => ({
        hue,
        saturation,
        value: value2
      });
      const fromRgb = (rgbaColour2) => {
        let h = 0;
        let s = 0;
        let v = 0;
        const r2 = rgbaColour2.red / 255;
        const g = rgbaColour2.green / 255;
        const b2 = rgbaColour2.blue / 255;
        const minRGB = Math.min(r2, Math.min(g, b2));
        const maxRGB = Math.max(r2, Math.max(g, b2));
        if (minRGB === maxRGB) {
          v = minRGB;
          return hsvColour(0, 0, v * 100);
        }
        const d = r2 === minRGB ? g - b2 : b2 === minRGB ? r2 - g : b2 - r2;
        h = r2 === minRGB ? 3 : b2 === minRGB ? 1 : 5;
        h = 60 * (h - d / (maxRGB - minRGB));
        s = (maxRGB - minRGB) / maxRGB;
        v = maxRGB;
        return hsvColour(Math.round(h), Math.round(s * 100), Math.round(v * 100));
      };
      const min = Math.min;
      const max = Math.max;
      const round$1 = Math.round;
      const rgbRegex = /^\s*rgb\s*\(\s*(\d+)\s*[,\s]\s*(\d+)\s*[,\s]\s*(\d+)\s*\)\s*$/i;
      const rgbaRegex = /^\s*rgba\s*\(\s*(\d+)\s*[,\s]\s*(\d+)\s*[,\s]\s*(\d+)\s*[,\s]\s*((?:\d?\.\d+|\d+)%?)\s*\)\s*$/i;
      const rgbaColour = (red2, green, blue, alpha) => ({
        red: red2,
        green,
        blue,
        alpha
      });
      const isRgbaComponent = (value2) => {
        const num = parseInt(value2, 10);
        return num.toString() === value2 && num >= 0 && num <= 255;
      };
      const fromHsv = (hsv) => {
        let r2;
        let g;
        let b2;
        const hue = (hsv.hue || 0) % 360;
        let saturation = hsv.saturation / 100;
        let brightness = hsv.value / 100;
        saturation = max(0, min(saturation, 1));
        brightness = max(0, min(brightness, 1));
        if (saturation === 0) {
          r2 = g = b2 = round$1(255 * brightness);
          return rgbaColour(r2, g, b2, 1);
        }
        const side = hue / 60;
        const chroma = brightness * saturation;
        const x = chroma * (1 - Math.abs(side % 2 - 1));
        const match = brightness - chroma;
        switch (Math.floor(side)) {
          case 0:
            r2 = chroma;
            g = x;
            b2 = 0;
            break;
          case 1:
            r2 = x;
            g = chroma;
            b2 = 0;
            break;
          case 2:
            r2 = 0;
            g = chroma;
            b2 = x;
            break;
          case 3:
            r2 = 0;
            g = x;
            b2 = chroma;
            break;
          case 4:
            r2 = x;
            g = 0;
            b2 = chroma;
            break;
          case 5:
            r2 = chroma;
            g = 0;
            b2 = x;
            break;
          default:
            r2 = g = b2 = 0;
        }
        r2 = round$1(255 * (r2 + match));
        g = round$1(255 * (g + match));
        b2 = round$1(255 * (b2 + match));
        return rgbaColour(r2, g, b2, 1);
      };
      const fromHex = (hexColour2) => {
        const result = extractValues(hexColour2);
        const red2 = parseInt(result[1], 16);
        const green = parseInt(result[2], 16);
        const blue = parseInt(result[3], 16);
        return rgbaColour(red2, green, blue, 1);
      };
      const fromStringValues = (red2, green, blue, alpha) => {
        const r2 = parseInt(red2, 10);
        const g = parseInt(green, 10);
        const b2 = parseInt(blue, 10);
        const a = parseFloat(alpha);
        return rgbaColour(r2, g, b2, a);
      };
      const fromString = (rgbaString) => {
        const rgbMatch = rgbRegex.exec(rgbaString);
        if (rgbMatch !== null) {
          return Optional.some(fromStringValues(rgbMatch[1], rgbMatch[2], rgbMatch[3], "1"));
        }
        const rgbaMatch = rgbaRegex.exec(rgbaString);
        if (rgbaMatch !== null) {
          return Optional.some(fromStringValues(rgbaMatch[1], rgbaMatch[2], rgbaMatch[3], rgbaMatch[4]));
        }
        return Optional.none();
      };
      const toString = (rgba) => `rgba(${rgba.red},${rgba.green},${rgba.blue},${rgba.alpha})`;
      const red = rgbaColour(255, 0, 0, 1);
      const hexToHsv = (hex) => fromRgb(fromHex(hex));
      const hsvToHex = (hsv) => fromRgba(fromHsv(hsv));
      const anyToHex = (color) => fromString$1(color).orThunk(() => fromString(color).map(fromRgba)).getOrThunk(() => {
        const canvas = document.createElement("canvas");
        canvas.height = 1;
        canvas.width = 1;
        const canvasContext = canvas.getContext("2d");
        canvasContext.clearRect(0, 0, canvas.width, canvas.height);
        canvasContext.fillStyle = "#FFFFFF";
        canvasContext.fillStyle = color;
        canvasContext.fillRect(0, 0, 1, 1);
        const rgba = canvasContext.getImageData(0, 0, 1, 1).data;
        const r2 = rgba[0];
        const g = rgba[1];
        const b2 = rgba[2];
        const a = rgba[3];
        return fromRgba(rgbaColour(r2, g, b2, a));
      });
      const fireSkinLoaded$1 = (editor) => {
        editor.dispatch("SkinLoaded");
      };
      const fireSkinLoadError$1 = (editor, error2) => {
        editor.dispatch("SkinLoadError", error2);
      };
      const fireResizeEditor = (editor) => {
        editor.dispatch("ResizeEditor");
      };
      const fireResizeContent = (editor, e) => {
        editor.dispatch("ResizeContent", e);
      };
      const fireScrollContent = (editor, e) => {
        editor.dispatch("ScrollContent", e);
      };
      const fireTextColorChange = (editor, data) => {
        editor.dispatch("TextColorChange", data);
      };
      const fireAfterProgressState = (editor, state) => {
        editor.dispatch("AfterProgressState", { state });
      };
      const fireResolveName = (editor, node) => editor.dispatch("ResolveName", {
        name: node.nodeName.toLowerCase(),
        target: node
      });
      const fireToggleToolbarDrawer = (editor, state) => {
        editor.dispatch("ToggleToolbarDrawer", { state });
      };
      const fireStylesTextUpdate = (editor, data) => {
        editor.dispatch("StylesTextUpdate", data);
      };
      const fireAlignTextUpdate = (editor, data) => {
        editor.dispatch("AlignTextUpdate", data);
      };
      const fireFontSizeTextUpdate = (editor, data) => {
        editor.dispatch("FontSizeTextUpdate", data);
      };
      const fireFontSizeInputTextUpdate = (editor, data) => {
        editor.dispatch("FontSizeInputTextUpdate", data);
      };
      const fireBlocksTextUpdate = (editor, data) => {
        editor.dispatch("BlocksTextUpdate", data);
      };
      const fireFontFamilyTextUpdate = (editor, data) => {
        editor.dispatch("FontFamilyTextUpdate", data);
      };
      const fireToggleSidebar = (editor) => {
        editor.dispatch("ToggleSidebar");
      };
      const fireToggleView = (editor) => {
        editor.dispatch("ToggleView");
      };
      const fireContextToolbarClose = (editor) => {
        editor.dispatch("ContextToolbarClose");
      };
      const fireContextFormSlideBack = (editor) => {
        editor.dispatch("ContextFormSlideBack");
      };
      const composeUnbinders = (f2, g) => () => {
        f2();
        g();
      };
      const onSetupEditableToggle = (editor, enabledPredicate = always) => onSetupEvent(editor, "NodeChange", (api2) => {
        api2.setEnabled(editor.selection.isEditable() && enabledPredicate());
      });
      const onSetupFormatToggle = (editor, name2) => (api2) => {
        const boundFormatChangeCallback = unbindable();
        const init2 = () => {
          api2.setActive(editor.formatter.match(name2));
          const binding = editor.formatter.formatChanged(name2, api2.setActive);
          boundFormatChangeCallback.set(binding);
        };
        editor.initialized ? init2() : editor.once("init", init2);
        return () => {
          editor.off("init", init2);
          boundFormatChangeCallback.clear();
        };
      };
      const onSetupStateToggle = (editor, name2) => (api2) => {
        const unbindEditableToogle = onSetupEditableToggle(editor)(api2);
        const unbindFormatToggle = onSetupFormatToggle(editor, name2)(api2);
        return () => {
          unbindEditableToogle();
          unbindFormatToggle();
        };
      };
      const onSetupEvent = (editor, event, f2) => (api2) => {
        const handleEvent = () => f2(api2);
        const init2 = () => {
          f2(api2);
          editor.on(event, handleEvent);
        };
        editor.initialized ? init2() : editor.once("init", init2);
        return () => {
          editor.off("init", init2);
          editor.off(event, handleEvent);
        };
      };
      const onActionToggleFormat$1 = (editor) => (rawItem) => () => {
        editor.undoManager.transact(() => {
          editor.focus();
          editor.execCommand("mceToggleFormat", false, rawItem.format);
        });
      };
      const onActionExecCommand = (editor, command) => () => editor.execCommand(command);
      var global$5 = tinymce.util.Tools.resolve("tinymce.util.LocalStorage");
      const cacheStorage = {};
      const ColorCache = (storageId, max2 = 10) => {
        const storageString = global$5.getItem(storageId);
        const localstorage = isString(storageString) ? JSON.parse(storageString) : [];
        const prune = (list) => {
          const diff = max2 - list.length;
          return diff < 0 ? list.slice(0, max2) : list;
        };
        const cache = prune(localstorage);
        const add2 = (key) => {
          indexOf(cache, key).each(remove2);
          cache.unshift(key);
          if (cache.length > max2) {
            cache.pop();
          }
          global$5.setItem(storageId, JSON.stringify(cache));
        };
        const remove2 = (idx) => {
          cache.splice(idx, 1);
        };
        const state = () => cache.slice(0);
        return {
          add: add2,
          state
        };
      };
      const getCacheForId = (id) => get$h(cacheStorage, id).getOrThunk(() => {
        const storageId = `tinymce-custom-colors-${id}`;
        const currentData = global$5.getItem(storageId);
        if (isNullable(currentData)) {
          const legacyDefault = global$5.getItem("tinymce-custom-colors");
          global$5.setItem(storageId, isNonNullable(legacyDefault) ? legacyDefault : "[]");
        }
        const storage = ColorCache(storageId, 10);
        cacheStorage[id] = storage;
        return storage;
      });
      const getCurrentColors = (id) => map$2(getCacheForId(id).state(), (color) => ({
        type: "choiceitem",
        text: color,
        icon: "checkmark",
        value: color
      }));
      const addColor = (id, color) => {
        getCacheForId(id).add(color);
      };
      const foregroundId = "forecolor";
      const backgroundId = "hilitecolor";
      const fallbackCols = 5;
      const mapColors = (colorMap) => mapColorsRaw(colorMap.map((color, index) => {
        if (index % 2 === 0) {
          return "#" + anyToHex(color).value;
        }
        return color;
      }));
      const mapColorsRaw = (colorMap) => {
        const colors = [];
        for (let i = 0; i < colorMap.length; i += 2) {
          colors.push({
            text: colorMap[i + 1],
            value: colorMap[i],
            icon: "checkmark",
            type: "choiceitem"
          });
        }
        return colors;
      };
      const option$1 = (name2) => (editor) => editor.options.get(name2);
      const fallbackColor = "#000000";
      const register$e = (editor) => {
        const registerOption = editor.options.register;
        const colorProcessor = (value2) => {
          if (isArrayOf(value2, isString)) {
            return { value: mapColors(value2), valid: true };
          } else {
            return { valid: false, message: "Must be an array of strings." };
          }
        };
        const colorProcessorRaw = (value2) => {
          if (isArrayOf(value2, isString)) {
            return { value: mapColorsRaw(value2), valid: true };
          } else {
            return { valid: false, message: "Must be an array of strings." };
          }
        };
        const colorColsProcessor = (value2) => {
          if (isNumber(value2) && value2 > 0) {
            return { value: value2, valid: true };
          } else {
            return { valid: false, message: "Must be a positive number." };
          }
        };
        registerOption("color_map", {
          processor: colorProcessor,
          default: [
            "#BFEDD2",
            "Light Green",
            "#FBEEB8",
            "Light Yellow",
            "#F8CAC6",
            "Light Red",
            "#ECCAFA",
            "Light Purple",
            "#C2E0F4",
            "Light Blue",
            "#2DC26B",
            "Green",
            "#F1C40F",
            "Yellow",
            "#E03E2D",
            "Red",
            "#B96AD9",
            "Purple",
            "#3598DB",
            "Blue",
            "#169179",
            "Dark Turquoise",
            "#E67E23",
            "Orange",
            "#BA372A",
            "Dark Red",
            "#843FA1",
            "Dark Purple",
            "#236FA1",
            "Dark Blue",
            "#ECF0F1",
            "Light Gray",
            "#CED4D9",
            "Medium Gray",
            "#95A5A6",
            "Gray",
            "#7E8C8D",
            "Dark Gray",
            "#34495E",
            "Navy Blue",
            "#000000",
            "Black",
            "#ffffff",
            "White"
          ]
        });
        registerOption("color_map_raw", {
          processor: colorProcessorRaw
        });
        registerOption("color_map_background", {
          processor: colorProcessor
        });
        registerOption("color_map_foreground", {
          processor: colorProcessor
        });
        registerOption("color_cols", {
          processor: colorColsProcessor,
          default: calcCols(editor)
        });
        registerOption("color_cols_foreground", {
          processor: colorColsProcessor,
          default: defaultCols(editor, foregroundId)
        });
        registerOption("color_cols_background", {
          processor: colorColsProcessor,
          default: defaultCols(editor, backgroundId)
        });
        registerOption("custom_colors", {
          processor: "boolean",
          default: true
        });
        registerOption("color_default_foreground", {
          processor: "string",
          default: fallbackColor
        });
        registerOption("color_default_background", {
          processor: "string",
          default: fallbackColor
        });
      };
      const getColors$2 = (editor, id) => {
        if (id === foregroundId && editor.options.isSet("color_map_foreground")) {
          return option$1("color_map_foreground")(editor);
        } else if (id === backgroundId && editor.options.isSet("color_map_background")) {
          return option$1("color_map_background")(editor);
        } else if (editor.options.isSet("color_map_raw")) {
          return option$1("color_map_raw")(editor);
        } else {
          return option$1("color_map")(editor);
        }
      };
      const calcCols = (editor, id = "default") => Math.max(fallbackCols, Math.ceil(Math.sqrt(getColors$2(editor, id).length)));
      const defaultCols = (editor, id) => {
        const defaultCols2 = option$1("color_cols")(editor);
        const calculatedCols = calcCols(editor, id);
        if (defaultCols2 === calcCols(editor)) {
          return calculatedCols;
        } else {
          return defaultCols2;
        }
      };
      const getColorCols$1 = (editor, id = "default") => {
        const getCols = () => {
          if (id === foregroundId) {
            return option$1("color_cols_foreground")(editor);
          } else if (id === backgroundId) {
            return option$1("color_cols_background")(editor);
          } else {
            return option$1("color_cols")(editor);
          }
        };
        return Math.round(getCols());
      };
      const hasCustomColors$1 = option$1("custom_colors");
      const getDefaultForegroundColor = option$1("color_default_foreground");
      const getDefaultBackgroundColor = option$1("color_default_background");
      const defaultBackgroundColor = "rgba(0, 0, 0, 0)";
      const isValidBackgroundColor = (value2) => fromString(value2).exists((c) => c.alpha !== 0);
      const getClosestCssBackgroundColorValue = (scope) => {
        return closest(scope, (node) => {
          if (isElement$1(node)) {
            const color = get$e(node, "background-color");
            return someIf(isValidBackgroundColor(color), color);
          } else {
            return Optional.none();
          }
        }).getOr(defaultBackgroundColor);
      };
      const getCurrentColor = (editor, format) => {
        const node = SugarElement.fromDom(editor.selection.getStart());
        const cssRgbValue = format === "hilitecolor" ? getClosestCssBackgroundColorValue(node) : get$e(node, "color");
        return fromString(cssRgbValue).map((rgba) => "#" + fromRgba(rgba).value);
      };
      const applyFormat = (editor, format, value2) => {
        editor.undoManager.transact(() => {
          editor.focus();
          editor.formatter.apply(format, { value: value2 });
          editor.nodeChanged();
        });
      };
      const removeFormat = (editor, format) => {
        editor.undoManager.transact(() => {
          editor.focus();
          editor.formatter.remove(format, { value: null }, void 0, true);
          editor.nodeChanged();
        });
      };
      const registerCommands = (editor) => {
        editor.addCommand("mceApplyTextcolor", (format, value2) => {
          applyFormat(editor, format, value2);
        });
        editor.addCommand("mceRemoveTextcolor", (format) => {
          removeFormat(editor, format);
        });
      };
      const getAdditionalColors = (hasCustom) => {
        const type2 = "choiceitem";
        const remove2 = {
          type: type2,
          text: "Remove color",
          icon: "color-swatch-remove-color",
          value: "remove"
        };
        const custom2 = {
          type: type2,
          text: "Custom color",
          icon: "color-picker",
          value: "custom"
        };
        return hasCustom ? [
          remove2,
          custom2
        ] : [remove2];
      };
      const applyColor = (editor, format, value2, onChoice) => {
        if (value2 === "custom") {
          const dialog = colorPickerDialog(editor);
          dialog((colorOpt) => {
            colorOpt.each((color) => {
              addColor(format, color);
              editor.execCommand("mceApplyTextcolor", format, color);
              onChoice(color);
            });
          }, getCurrentColor(editor, format).getOr(fallbackColor));
        } else if (value2 === "remove") {
          onChoice("");
          editor.execCommand("mceRemoveTextcolor", format);
        } else {
          onChoice(value2);
          editor.execCommand("mceApplyTextcolor", format, value2);
        }
      };
      const getColors$1 = (colors, id, hasCustom) => colors.concat(getCurrentColors(id).concat(getAdditionalColors(hasCustom)));
      const getFetch$1 = (colors, id, hasCustom) => (callback) => {
        callback(getColors$1(colors, id, hasCustom));
      };
      const setIconColor = (splitButtonApi, name2, newColor) => {
        const id = name2 === "forecolor" ? "tox-icon-text-color__color" : "tox-icon-highlight-bg-color__color";
        splitButtonApi.setIconFill(id, newColor);
      };
      const setTooltip = (buttonApi, tooltip) => {
        buttonApi.setTooltip(tooltip);
      };
      const select$1 = (editor, format) => (value2) => {
        const optCurrentHex = getCurrentColor(editor, format);
        return is$1(optCurrentHex, value2.toUpperCase());
      };
      const getToolTipText = (editor, format, lastColor) => {
        if (isEmpty(lastColor)) {
          return format === "forecolor" ? "Text color" : "Background color";
        }
        const tooltipPrefix = format === "forecolor" ? "Text color {0}" : "Background color {0}";
        const colors = getColors$1(getColors$2(editor, format), format, false);
        const colorText = find$5(colors, (c) => c.value === lastColor).getOr({ text: "" }).text;
        return editor.translate([tooltipPrefix, editor.translate(colorText)]);
      };
      const registerTextColorButton = (editor, name2, format, lastColor) => {
        editor.ui.registry.addSplitButton(name2, {
          tooltip: getToolTipText(editor, format, lastColor.get()),
          presets: "color",
          icon: name2 === "forecolor" ? "text-color" : "highlight-bg-color",
          select: select$1(editor, format),
          columns: getColorCols$1(editor, format),
          fetch: getFetch$1(getColors$2(editor, format), format, hasCustomColors$1(editor)),
          onAction: (_splitButtonApi) => {
            applyColor(editor, format, lastColor.get(), noop);
          },
          onItemAction: (_splitButtonApi, value2) => {
            applyColor(editor, format, value2, (newColor) => {
              lastColor.set(newColor);
              fireTextColorChange(editor, {
                name: name2,
                color: newColor
              });
            });
          },
          onSetup: (splitButtonApi) => {
            setIconColor(splitButtonApi, name2, lastColor.get());
            const handler = (e) => {
              if (e.name === name2) {
                setIconColor(splitButtonApi, e.name, e.color);
                setTooltip(splitButtonApi, getToolTipText(editor, format, e.color));
              }
            };
            editor.on("TextColorChange", handler);
            return composeUnbinders(onSetupEditableToggle(editor)(splitButtonApi), () => {
              editor.off("TextColorChange", handler);
            });
          }
        });
      };
      const registerTextColorMenuItem = (editor, name2, format, text2, lastColor) => {
        editor.ui.registry.addNestedMenuItem(name2, {
          text: text2,
          icon: name2 === "forecolor" ? "text-color" : "highlight-bg-color",
          onSetup: (api2) => {
            setTooltip(api2, getToolTipText(editor, format, lastColor.get()));
            setIconColor(api2, name2, lastColor.get());
            return onSetupEditableToggle(editor)(api2);
          },
          getSubmenuItems: () => [
            {
              type: "fancymenuitem",
              fancytype: "colorswatch",
              select: select$1(editor, format),
              initData: {
                storageKey: format
              },
              onAction: (data) => {
                applyColor(editor, format, data.value, (newColor) => {
                  lastColor.set(newColor);
                  fireTextColorChange(editor, {
                    name: name2,
                    color: newColor
                  });
                });
              }
            }
          ]
        });
      };
      const colorPickerDialog = (editor) => (callback, value2) => {
        let isValid = false;
        const onSubmit = (api2) => {
          const data = api2.getData();
          const hex = data.colorpicker;
          if (isValid) {
            callback(Optional.from(hex));
            api2.close();
          } else {
            editor.windowManager.alert(editor.translate(["Invalid hex color code: {0}", hex]));
          }
        };
        const onAction2 = (_api, details) => {
          if (details.name === "hex-valid") {
            isValid = details.value;
          }
        };
        const initialData = {
          colorpicker: value2
        };
        editor.windowManager.open({
          title: "Color Picker",
          size: "normal",
          body: {
            type: "panel",
            items: [
              {
                type: "colorpicker",
                name: "colorpicker",
                label: "Color"
              }
            ]
          },
          buttons: [
            {
              type: "cancel",
              name: "cancel",
              text: "Cancel"
            },
            {
              type: "submit",
              name: "save",
              text: "Save",
              primary: true
            }
          ],
          initialData,
          onAction: onAction2,
          onSubmit,
          onClose: noop,
          onCancel: () => {
            callback(Optional.none());
          }
        });
      };
      const register$d = (editor) => {
        registerCommands(editor);
        const fallbackColorForeground = getDefaultForegroundColor(editor);
        const fallbackColorBackground = getDefaultBackgroundColor(editor);
        const lastForeColor = Cell(fallbackColorForeground);
        const lastBackColor = Cell(fallbackColorBackground);
        registerTextColorButton(editor, "forecolor", "forecolor", lastForeColor);
        registerTextColorButton(editor, "backcolor", "hilitecolor", lastBackColor);
        registerTextColorMenuItem(editor, "forecolor", "forecolor", "Text color", lastForeColor);
        registerTextColorMenuItem(editor, "backcolor", "hilitecolor", "Background color", lastBackColor);
      };
      const renderImgItem = (spec, onItemValueHandler, isSelected, itemResponse, providersBackstage) => {
        const getApi2 = (component) => ({
          setActive: (state) => {
            Toggling.set(component, state);
          },
          isActive: () => Toggling.isOn(component),
          isEnabled: () => !Disabling.isDisabled(component),
          setEnabled: (state) => Disabling.set(component, !state)
        });
        const structure = renderItemStructure({
          presets: "img",
          textContent: Optional.none(),
          htmlContent: Optional.none(),
          ariaLabel: spec.tooltip,
          iconContent: Optional.some(spec.url),
          labelContent: spec.label,
          shortcutContent: Optional.none(),
          checkMark: Optional.some(renderCheckmark(providersBackstage.icons)),
          caret: Optional.none(),
          value: spec.value
        }, providersBackstage, true);
        const optTooltipping = spec.tooltip.map((t2) => Tooltipping.config(providersBackstage.tooltips.getConfig({
          tooltipText: providersBackstage.translate(t2)
        })));
        return deepMerge(renderCommonItem({
          context: spec.context,
          data: buildData(spec),
          enabled: spec.enabled,
          getApi: getApi2,
          onAction: (api2) => {
            onItemValueHandler(spec.value);
            api2.setActive(true);
          },
          onSetup: (api2) => {
            api2.setActive(isSelected);
            return noop;
          },
          triggersSubmenu: false,
          itemBehaviours: [
            ...optTooltipping.toArray()
          ]
        }, structure, itemResponse, providersBackstage), {
          toggling: {
            toggleClass: tickedClass,
            toggleOnExecute: false,
            selected: spec.active,
            exclusive: true
          }
        });
      };
      const createPartialChoiceMenu = (value2, items, onItemValueHandler, columns, presets, itemResponse, select2, providersBackstage) => {
        const hasIcons = menuHasIcons(items);
        const presetItemTypes = presets !== "color" ? "normal" : "color";
        const alloyItems = createChoiceItems(items, onItemValueHandler, columns, presetItemTypes, itemResponse, select2, providersBackstage);
        const menuLayout = {
          menuType: presets
        };
        return createPartialMenuWithAlloyItems(value2, hasIcons, alloyItems, columns, menuLayout);
      };
      const createChoiceItems = (items, onItemValueHandler, columns, itemPresets, itemResponse, select2, providersBackstage) => cat(map$2(items, (item2) => {
        if (item2.type === "choiceitem") {
          return createChoiceMenuItem(item2).fold(handleError, (d) => Optional.some(renderChoiceItem(d, columns === 1, itemPresets, onItemValueHandler, select2(d.value), itemResponse, providersBackstage, menuHasIcons(items))));
        } else if (item2.type === "imageitem") {
          return createImageMenuItem(item2).fold(handleError, (d) => Optional.some(renderImgItem(d, onItemValueHandler, select2(d.value), itemResponse, providersBackstage)));
        } else if (item2.type === "resetimage") {
          return createResetImageItem(item2).fold(handleError, (d) => Optional.some(renderChoiceItem({
            ...d,
            type: "choiceitem",
            text: d.tooltip,
            icon: Optional.some(d.icon),
            label: Optional.some(d.label)
          }, columns === 1, itemPresets, onItemValueHandler, select2(d.value), itemResponse, providersBackstage, menuHasIcons(items))));
        } else {
          return Optional.none();
        }
      }));
      const deriveMenuMovement = (columns, presets) => {
        const menuMarkers = markers(presets);
        if (columns === 1) {
          return { mode: "menu", moveOnTab: true };
        } else if (columns === "auto") {
          return {
            mode: "grid",
            selector: "." + menuMarkers.item,
            initSize: {
              numColumns: 1,
              numRows: 1
            }
          };
        } else {
          const rowClass = {
            color: "tox-swatches__row",
            imageselector: "tox-image-selector__row",
            listpreview: "tox-collection__group",
            normal: "tox-collection__group"
          }[presets];
          return {
            mode: "matrix",
            rowSelector: "." + rowClass,
            previousSelector: (menu2) => {
              return presets === "color" ? descendant(menu2.element, "[aria-checked=true]") : Optional.none();
            }
          };
        }
      };
      const deriveCollectionMovement = (columns, presets) => {
        if (columns === 1) {
          return {
            mode: "menu",
            moveOnTab: false,
            selector: ".tox-collection__item"
          };
        } else if (columns === "auto") {
          return {
            mode: "flatgrid",
            selector: ".tox-collection__item",
            initSize: {
              numColumns: 1,
              numRows: 1
            }
          };
        } else {
          return {
            mode: "matrix",
            selectors: {
              row: presets === "color" ? ".tox-swatches__row" : ".tox-collection__group",
              cell: presets === "color" ? `.${colorClass}` : `.${selectableClass}`
            }
          };
        }
      };
      const renderColorSwatchItem = (spec, backstage) => {
        const items = getColorItems(spec, backstage);
        const columns = backstage.colorinput.getColorCols(spec.initData.storageKey);
        const presets = "color";
        const menuSpec = createPartialChoiceMenu(generate$6("menu-value"), items, (value2) => {
          spec.onAction({ value: value2 });
        }, columns, presets, ItemResponse$1.CLOSE_ON_EXECUTE, spec.select.getOr(never), backstage.shared.providers);
        const widgetSpec = {
          ...menuSpec,
          markers: markers(presets),
          movement: deriveMenuMovement(columns, presets),
          // TINY-10806: Avoid duplication of ARIA role="menu" in the accessibility tree for Color Swatch menu item.
          showMenuRole: false
        };
        return {
          type: "widget",
          data: { value: generate$6("widget-id") },
          dom: {
            tag: "div",
            classes: ["tox-fancymenuitem"]
          },
          autofocus: true,
          components: [
            parts$8.widget(Menu.sketch(widgetSpec))
          ]
        };
      };
      const getColorItems = (spec, backstage) => {
        const useCustomColors = spec.initData.allowCustomColors && backstage.colorinput.hasCustomColors();
        return spec.initData.colors.fold(() => getColors$1(backstage.colorinput.getColors(spec.initData.storageKey), spec.initData.storageKey, useCustomColors), (colors) => colors.concat(getAdditionalColors(useCustomColors)));
      };
      const renderImageSelector = (spec, backstage) => {
        const presets = "imageselector";
        const columns = spec.initData.columns;
        const menuSpec = createPartialChoiceMenu(generate$6("menu-value"), spec.initData.items, (value2) => {
          spec.onAction({ value: value2 });
        }, columns, presets, ItemResponse$1.CLOSE_ON_EXECUTE, spec.select.getOr(never), backstage.shared.providers);
        const widgetSpec = {
          ...menuSpec,
          markers: markers(presets),
          movement: deriveMenuMovement(columns, presets),
          // TINY-10806: Avoid duplication of ARIA role="menu" in the accessibility tree for Image Selector menu item.
          showMenuRole: false
        };
        return {
          type: "widget",
          data: { value: generate$6("widget-id") },
          dom: {
            tag: "div",
            classes: ["tox-fancymenuitem", "tox-collection--toolbar"]
          },
          autofocus: true,
          components: [
            parts$8.widget(Menu.sketch(widgetSpec))
          ]
        };
      };
      const cellOverEvent = generate$6("cell-over");
      const cellExecuteEvent = generate$6("cell-execute");
      const makeAnnouncementText = (backstage) => (row, col) => backstage.shared.providers.translate(["{0} columns, {1} rows", col, row]);
      const makeCell = (row, col, label2) => {
        const emitCellOver = (c) => emitWith(c, cellOverEvent, { row, col });
        const emitExecute2 = (c) => emitWith(c, cellExecuteEvent, { row, col });
        const onClick = (c, se) => {
          se.stop();
          emitExecute2(c);
        };
        return build$1({
          dom: {
            tag: "div",
            attributes: {
              role: "button",
              ["aria-label"]: label2
            }
          },
          behaviours: derive$1([
            config("insert-table-picker-cell", [
              run$1(mouseover(), Focusing.focus),
              run$1(execute$5(), emitExecute2),
              run$1(click(), onClick),
              run$1(tap(), onClick)
            ]),
            Toggling.config({
              toggleClass: "tox-insert-table-picker__selected",
              toggleOnExecute: false
            }),
            Focusing.config({ onFocus: emitCellOver })
          ])
        });
      };
      const makeCells = (getCellLabel, numRows, numCols) => {
        const cells = [];
        for (let i = 0; i < numRows; i++) {
          const row = [];
          for (let j = 0; j < numCols; j++) {
            const label2 = getCellLabel(i + 1, j + 1);
            row.push(makeCell(i, j, label2));
          }
          cells.push(row);
        }
        return cells;
      };
      const selectCells = (cells, selectedRow, selectedColumn, numRows, numColumns) => {
        for (let i = 0; i < numRows; i++) {
          for (let j = 0; j < numColumns; j++) {
            Toggling.set(cells[i][j], i <= selectedRow && j <= selectedColumn);
          }
        }
      };
      const makeComponents = (cells) => bind$3(cells, (cellRow) => map$2(cellRow, premade));
      const makeLabelText = (row, col) => text$2(`${col}x${row}`);
      const renderInsertTableMenuItem = (spec, backstage) => {
        const numRows = 10;
        const numColumns = 10;
        const getCellLabel = makeAnnouncementText(backstage);
        const cells = makeCells(getCellLabel, numRows, numColumns);
        const emptyLabelText = makeLabelText(0, 0);
        const memLabel = record({
          dom: {
            tag: "span",
            classes: ["tox-insert-table-picker__label"]
          },
          components: [emptyLabelText],
          behaviours: derive$1([
            Replacing.config({})
          ])
        });
        return {
          type: "widget",
          data: { value: generate$6("widget-id") },
          dom: {
            tag: "div",
            classes: ["tox-fancymenuitem"]
          },
          autofocus: true,
          components: [parts$8.widget({
            dom: {
              tag: "div",
              classes: ["tox-insert-table-picker"]
            },
            components: makeComponents(cells).concat(memLabel.asSpec()),
            behaviours: derive$1([
              config("insert-table-picker", [
                runOnAttached((c) => {
                  Replacing.set(memLabel.get(c), [emptyLabelText]);
                }),
                runWithTarget(cellOverEvent, (c, t2, e) => {
                  const { row, col } = e.event;
                  selectCells(cells, row, col, numRows, numColumns);
                  Replacing.set(memLabel.get(c), [makeLabelText(row + 1, col + 1)]);
                }),
                runWithTarget(cellExecuteEvent, (c, _, e) => {
                  const { row, col } = e.event;
                  emit(c, sandboxClose());
                  spec.onAction({ numRows: row + 1, numColumns: col + 1 });
                })
              ]),
              Keying.config({
                initSize: {
                  numRows,
                  numColumns
                },
                mode: "flatgrid",
                selector: '[role="button"]'
              })
            ])
          })]
        };
      };
      const fancyMenuItems = {
        inserttable: renderInsertTableMenuItem,
        colorswatch: renderColorSwatchItem,
        imageselect: renderImageSelector
      };
      const renderFancyMenuItem = (spec, backstage) => get$h(fancyMenuItems, spec.fancytype).map((render2) => render2(spec, backstage));
      const renderNestedItem = (spec, itemResponse, providersBackstage, renderIcons = true, downwardsCaret = false) => {
        const caret = downwardsCaret ? renderDownwardsCaret(providersBackstage.icons) : renderSubmenuCaret(providersBackstage.icons);
        const getApi2 = (component) => ({
          isEnabled: () => !Disabling.isDisabled(component),
          setEnabled: (state) => Disabling.set(component, !state),
          setIconFill: (id, value2) => {
            descendant(component.element, `svg path[class="${id}"], rect[class="${id}"]`).each((underlinePath) => {
              set$9(underlinePath, "fill", value2);
            });
          },
          setTooltip: (tooltip) => {
            const translatedTooltip = providersBackstage.translate(tooltip);
            set$9(component.element, "aria-label", translatedTooltip);
          }
        });
        const structure = renderItemStructure({
          presets: "normal",
          iconContent: spec.icon,
          textContent: spec.text,
          htmlContent: Optional.none(),
          ariaLabel: spec.text,
          labelContent: Optional.none(),
          caret: Optional.some(caret),
          checkMark: Optional.none(),
          shortcutContent: spec.shortcut
        }, providersBackstage, renderIcons);
        return renderCommonItem({
          context: spec.context,
          data: buildData(spec),
          getApi: getApi2,
          enabled: spec.enabled,
          onAction: noop,
          onSetup: spec.onSetup,
          triggersSubmenu: true,
          itemBehaviours: []
        }, structure, itemResponse, providersBackstage);
      };
      const renderNormalItem = (spec, itemResponse, providersBackstage, renderIcons = true) => {
        const getApi2 = (component) => ({
          isEnabled: () => !Disabling.isDisabled(component),
          setEnabled: (state) => Disabling.set(component, !state)
        });
        const structure = renderItemStructure({
          presets: "normal",
          iconContent: spec.icon,
          textContent: spec.text,
          htmlContent: Optional.none(),
          labelContent: Optional.none(),
          ariaLabel: spec.text,
          caret: Optional.none(),
          checkMark: Optional.none(),
          shortcutContent: spec.shortcut
        }, providersBackstage, renderIcons);
        return renderCommonItem({
          context: spec.context,
          data: buildData(spec),
          getApi: getApi2,
          enabled: spec.enabled,
          onAction: spec.onAction,
          onSetup: spec.onSetup,
          triggersSubmenu: false,
          itemBehaviours: []
        }, structure, itemResponse, providersBackstage);
      };
      const renderSeparatorItem = (spec) => ({
        type: "separator",
        dom: {
          tag: "div",
          classes: [selectableClass, groupHeadingClass]
        },
        components: spec.text.map(text$2).toArray()
      });
      const renderToggleMenuItem = (spec, itemResponse, providersBackstage, renderIcons = true) => {
        const getApi2 = (component) => ({
          setActive: (state) => {
            Toggling.set(component, state);
          },
          isActive: () => Toggling.isOn(component),
          isEnabled: () => !Disabling.isDisabled(component),
          setEnabled: (state) => Disabling.set(component, !state)
        });
        const structure = renderItemStructure({
          iconContent: spec.icon,
          textContent: spec.text,
          htmlContent: Optional.none(),
          labelContent: Optional.none(),
          ariaLabel: spec.text,
          checkMark: Optional.some(renderCheckmark(providersBackstage.icons)),
          caret: Optional.none(),
          shortcutContent: spec.shortcut,
          presets: "normal",
          meta: spec.meta
        }, providersBackstage, renderIcons);
        return deepMerge(renderCommonItem({
          context: spec.context,
          data: buildData(spec),
          enabled: spec.enabled,
          getApi: getApi2,
          onAction: spec.onAction,
          onSetup: spec.onSetup,
          triggersSubmenu: false,
          itemBehaviours: []
        }, structure, itemResponse, providersBackstage), {
          toggling: {
            toggleClass: tickedClass,
            toggleOnExecute: false,
            selected: spec.active
          },
          role: spec.role.getOrUndefined()
        });
      };
      const autocomplete = renderAutocompleteItem;
      const separator$3 = renderSeparatorItem;
      const normal = renderNormalItem;
      const nested = renderNestedItem;
      const toggle = renderToggleMenuItem;
      const fancy = renderFancyMenuItem;
      const card = renderCardMenuItem;
      const identifyMenuLayout = (searchMode) => {
        switch (searchMode.searchMode) {
          case "no-search": {
            return {
              menuType: "normal"
            };
          }
          default: {
            return {
              menuType: "searchable",
              searchMode
            };
          }
        }
      };
      const handleRefetchTrigger = (originalSandboxComp) => {
        const dropdown = Representing.getValue(originalSandboxComp);
        const optSearcherState = findWithinSandbox(originalSandboxComp).map(saveState);
        Dropdown.refetch(dropdown).get(() => {
          const newSandboxComp = Coupling.getCoupled(dropdown, "sandbox");
          optSearcherState.each((searcherState) => findWithinSandbox(newSandboxComp).each((inputComp) => restoreState(inputComp, searcherState)));
        });
      };
      const handleRedirectToMenuItem = (sandboxComp, se) => {
        getActiveMenuItemFrom(sandboxComp).each((activeItem) => {
          retargetAndDispatchWith(sandboxComp, activeItem.element, se.event.eventType, se.event.interactionEvent);
        });
      };
      const getActiveMenuItemFrom = (sandboxComp) => {
        return Sandboxing.getState(sandboxComp).bind(Highlighting.getHighlighted).bind(Highlighting.getHighlighted);
      };
      const getSearchResults = (activeMenuComp) => {
        return has(activeMenuComp.element, searchResultsClass) ? Optional.some(activeMenuComp.element) : descendant(activeMenuComp.element, "." + searchResultsClass);
      };
      const updateAriaOnHighlight = (tmenuComp, menuComp, itemComp) => {
        findWithinMenu(tmenuComp).each((inputComp) => {
          setActiveDescendant(inputComp, itemComp);
          const optActiveResults = getSearchResults(menuComp);
          optActiveResults.each((resultsElem) => {
            getOpt(resultsElem, "id").each((controlledId) => set$9(inputComp.element, "aria-controls", controlledId));
          });
        });
        set$9(itemComp.element, "aria-selected", "true");
      };
      const updateAriaOnDehighlight = (tmenuComp, menuComp, itemComp) => {
        set$9(itemComp.element, "aria-selected", "false");
      };
      const focusSearchField = (tmenuComp) => {
        findWithinMenu(tmenuComp).each((searcherComp) => Focusing.focus(searcherComp));
      };
      const getSearchPattern = (dropdownComp) => {
        const optSandboxComp = Coupling.getExistingCoupled(dropdownComp, "sandbox");
        return optSandboxComp.bind(findWithinSandbox).map(saveState).map((state) => state.fetchPattern).getOr("");
      };
      var FocusMode;
      (function(FocusMode2) {
        FocusMode2[FocusMode2["ContentFocus"] = 0] = "ContentFocus";
        FocusMode2[FocusMode2["UiFocus"] = 1] = "UiFocus";
      })(FocusMode || (FocusMode = {}));
      const createMenuItemFromBridge = (item2, itemResponse, backstage, menuHasIcons2, isHorizontalMenu) => {
        const providersBackstage = backstage.shared.providers;
        const parseForHorizontalMenu = (menuitem) => !isHorizontalMenu ? menuitem : {
          ...menuitem,
          shortcut: Optional.none(),
          icon: menuitem.text.isSome() ? Optional.none() : menuitem.icon
        };
        switch (item2.type) {
          case "menuitem":
            return createMenuItem(item2).fold(handleError, (d) => Optional.some(normal(parseForHorizontalMenu(d), itemResponse, providersBackstage, menuHasIcons2)));
          case "nestedmenuitem":
            return createNestedMenuItem(item2).fold(handleError, (d) => Optional.some(nested(parseForHorizontalMenu(d), itemResponse, providersBackstage, menuHasIcons2, isHorizontalMenu)));
          case "togglemenuitem":
            return createToggleMenuItem(item2).fold(handleError, (d) => Optional.some(toggle(parseForHorizontalMenu(d), itemResponse, providersBackstage, menuHasIcons2)));
          case "separator":
            return createSeparatorMenuItem(item2).fold(handleError, (d) => Optional.some(separator$3(d)));
          case "fancymenuitem":
            return createFancyMenuItem(item2).fold(
              handleError,
              // Fancy menu items don't have shortcuts or icons
              (d) => fancy(d, backstage)
            );
          default: {
            console.error("Unknown item in general menu", item2);
            return Optional.none();
          }
        }
      };
      const createAutocompleteItems = (items, matchText, onItemValueHandler, columns, itemResponse, sharedBackstage, highlightOn) => {
        const renderText2 = columns === 1;
        const renderIcons = !renderText2 || menuHasIcons(items);
        return cat(map$2(items, (item2) => {
          switch (item2.type) {
            case "separator":
              return createSeparatorItem(item2).fold(handleError, (d) => Optional.some(separator$3(d)));
            case "cardmenuitem":
              return createCardMenuItem(item2).fold(handleError, (d) => Optional.some(card({
                ...d,
                // Intercept action
                onAction: (api2) => {
                  d.onAction(api2);
                  onItemValueHandler(d.value, d.meta);
                }
              }, itemResponse, sharedBackstage, {
                itemBehaviours: tooltipBehaviour(d.meta, sharedBackstage, Optional.none()),
                cardText: {
                  matchText,
                  highlightOn
                }
              })));
            case "autocompleteitem":
            default:
              return createAutocompleterItem(item2).fold(handleError, (d) => Optional.some(autocomplete(d, matchText, renderText2, "normal", onItemValueHandler, itemResponse, sharedBackstage, renderIcons)));
          }
        }));
      };
      const createPartialMenu = (value2, items, itemResponse, backstage, isHorizontalMenu, searchMode) => {
        const hasIcons = menuHasIcons(items);
        const alloyItems = cat(map$2(items, (item2) => {
          const itemHasIcon = (i) => isHorizontalMenu ? !has$2(i, "text") : hasIcons;
          const createItem = (i) => createMenuItemFromBridge(i, itemResponse, backstage, itemHasIcon(i), isHorizontalMenu);
          if (item2.type === "nestedmenuitem" && item2.getSubmenuItems().length <= 0) {
            return createItem({ ...item2, enabled: false });
          } else {
            return createItem(item2);
          }
        }));
        const menuLayout = identifyMenuLayout(searchMode);
        const createPartial = isHorizontalMenu ? createHorizontalPartialMenuWithAlloyItems : createPartialMenuWithAlloyItems;
        return createPartial(value2, hasIcons, alloyItems, 1, menuLayout);
      };
      const createTieredDataFrom = (partialMenu) => tieredMenu.singleData(partialMenu.value, partialMenu);
      const createInlineMenuFrom = (partialMenu, columns, focusMode, presets) => {
        const movement = deriveMenuMovement(columns, presets);
        const menuMarkers = markers(presets);
        return {
          data: createTieredDataFrom({
            ...partialMenu,
            movement,
            menuBehaviours: SimpleBehaviours.unnamedEvents(columns !== "auto" ? [] : [
              runOnAttached((comp, _se) => {
                detectSize(comp, 4, menuMarkers.item).each(({ numColumns, numRows }) => {
                  Keying.setGridSize(comp, numRows, numColumns);
                });
              })
            ])
          }),
          menu: {
            markers: markers(presets),
            fakeFocus: focusMode === FocusMode.ContentFocus
          }
        };
      };
      const rangeToSimRange = (r2) => SimRange.create(SugarElement.fromDom(r2.startContainer), r2.startOffset, SugarElement.fromDom(r2.endContainer), r2.endOffset);
      const register$c = (editor, sharedBackstage) => {
        const autocompleterId = generate$6("autocompleter");
        const processingAction = Cell(false);
        const activeState = Cell(false);
        const activeRange = value$2();
        const autocompleter = build$1(InlineView.sketch({
          dom: {
            tag: "div",
            classes: ["tox-autocompleter"],
            attributes: {
              id: autocompleterId
            }
          },
          components: [],
          fireDismissalEventInstead: {},
          inlineBehaviours: derive$1([
            config("dismissAutocompleter", [
              run$1(dismissRequested(), () => cancelIfNecessary()),
              run$1(highlight$1(), (_, se) => {
                getOpt(se.event.target, "id").each((id) => set$9(SugarElement.fromDom(editor.getBody()), "aria-activedescendant", id));
              })
            ])
          ]),
          lazySink: sharedBackstage.getSink
        }));
        const isMenuOpen = () => InlineView.isOpen(autocompleter);
        const isActive = activeState.get;
        const hideIfNecessary = () => {
          if (isMenuOpen()) {
            InlineView.hide(autocompleter);
            editor.dom.remove(autocompleterId, false);
            const editorBody = SugarElement.fromDom(editor.getBody());
            getOpt(editorBody, "aria-owns").filter((ariaOwnsAttr) => ariaOwnsAttr === autocompleterId).each(() => {
              remove$8(editorBody, "aria-owns");
              remove$8(editorBody, "aria-activedescendant");
            });
          }
        };
        const getMenu = () => InlineView.getContent(autocompleter).bind((tmenu) => {
          return get$i(tmenu.components(), 0);
        });
        const cancelIfNecessary = () => editor.execCommand("mceAutocompleterClose");
        const getCombinedItems = (matches) => {
          const columns = findMap(matches, (m) => Optional.from(m.columns)).getOr(1);
          return bind$3(matches, (match) => {
            const choices = match.items;
            return createAutocompleteItems(choices, match.matchText, (itemValue, itemMeta) => {
              const autocompleterApi = {
                hide: () => cancelIfNecessary(),
                reload: (fetchOptions) => {
                  hideIfNecessary();
                  editor.execCommand("mceAutocompleterReload", false, { fetchOptions });
                }
              };
              editor.execCommand("mceAutocompleterRefreshActiveRange");
              activeRange.get().each((range2) => {
                processingAction.set(true);
                match.onAction(autocompleterApi, range2, itemValue, itemMeta);
                processingAction.set(false);
              });
            }, columns, ItemResponse$1.BUBBLE_TO_SANDBOX, sharedBackstage, match.highlightOn);
          });
        };
        const display = (lookupData, items) => {
          const columns = findMap(lookupData, (ld) => Optional.from(ld.columns)).getOr(1);
          InlineView.showMenuAt(autocompleter, {
            anchor: {
              type: "selection",
              getSelection: () => activeRange.get().map(rangeToSimRange),
              root: SugarElement.fromDom(editor.getBody())
            }
          }, createInlineMenuFrom(
            createPartialMenuWithAlloyItems("autocompleter-value", true, items, columns, { menuType: "normal" }),
            columns,
            FocusMode.ContentFocus,
            // Use the constant.
            "normal"
          ));
          getMenu().each(Highlighting.highlightFirst);
        };
        const updateDisplay = (lookupData) => {
          const combinedItems = getCombinedItems(lookupData);
          if (combinedItems.length > 0) {
            display(lookupData, combinedItems);
            set$9(SugarElement.fromDom(editor.getBody()), "aria-owns", autocompleterId);
            if (!editor.inline) {
              cloneAutocompleterToEditorDoc();
            }
          } else {
            hideIfNecessary();
          }
        };
        const cloneAutocompleterToEditorDoc = () => {
          if (editor.dom.get(autocompleterId)) {
            editor.dom.remove(autocompleterId, false);
          }
          const docElm = editor.getDoc().documentElement;
          const selection = editor.selection.getNode();
          const newElm = deep(autocompleter.element);
          setAll(newElm, {
            border: "0",
            clip: "rect(0 0 0 0)",
            height: "1px",
            margin: "-1px",
            overflow: "hidden",
            padding: "0",
            position: "absolute",
            width: "1px",
            top: `${selection.offsetTop}px`,
            left: `${selection.offsetLeft}px`
          });
          editor.dom.add(docElm, newElm.dom);
          descendant(newElm, '[role="menu"]').each((child2) => {
            remove$6(child2, "position");
            remove$6(child2, "max-height");
          });
        };
        editor.on("AutocompleterStart", ({ lookupData }) => {
          activeState.set(true);
          processingAction.set(false);
          updateDisplay(lookupData);
        });
        editor.on("AutocompleterUpdate", ({ lookupData }) => updateDisplay(lookupData));
        editor.on("AutocompleterUpdateActiveRange", ({ range: range2 }) => activeRange.set(range2));
        editor.on("AutocompleterEnd", () => {
          hideIfNecessary();
          activeState.set(false);
          processingAction.set(false);
          activeRange.clear();
        });
        const autocompleterUiApi = {
          cancelIfNecessary,
          isMenuOpen,
          isActive,
          isProcessingAction: processingAction.get,
          getMenu
        };
        AutocompleterEditorEvents.setup(autocompleterUiApi, editor);
      };
      const Autocompleter = {
        register: register$c
      };
      const renderBar = (spec, backstage) => ({
        dom: {
          tag: "div",
          classes: ["tox-bar", "tox-form__controls-h-stack"]
        },
        components: map$2(spec.items, backstage.interpreter)
      });
      var global$4 = tinymce.util.Tools.resolve("tinymce.html.Entities");
      const renderFormFieldWith = (pLabel, pField, extraClasses, extraBehaviours) => {
        const spec = renderFormFieldSpecWith(pLabel, pField, extraClasses, extraBehaviours);
        return FormField.sketch(spec);
      };
      const renderFormField = (pLabel, pField) => renderFormFieldWith(pLabel, pField, [], []);
      const renderFormFieldSpecWith = (pLabel, pField, extraClasses, extraBehaviours) => ({
        dom: renderFormFieldDomWith(extraClasses),
        components: pLabel.toArray().concat([pField]),
        fieldBehaviours: derive$1(extraBehaviours)
      });
      const renderFormFieldDom = () => renderFormFieldDomWith([]);
      const renderFormFieldDomWith = (extraClasses) => ({
        tag: "div",
        classes: ["tox-form__group"].concat(extraClasses)
      });
      const renderLabel$3 = (label2, providersBackstage) => FormField.parts.label({
        dom: {
          tag: "label",
          classes: ["tox-label"]
        },
        components: [
          text$2(providersBackstage.translate(label2))
        ]
      });
      const formChangeEvent = generate$6("form-component-change");
      const formInputEvent = generate$6("form-component-input");
      const formCloseEvent = generate$6("form-close");
      const formCancelEvent = generate$6("form-cancel");
      const formActionEvent = generate$6("form-action");
      const formSubmitEvent = generate$6("form-submit");
      const formBlockEvent = generate$6("form-block");
      const formUnblockEvent = generate$6("form-unblock");
      const formTabChangeEvent = generate$6("form-tabchange");
      const formResizeEvent = generate$6("form-resize");
      const renderCollection = (spec, providersBackstage, initialData) => {
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, providersBackstage));
        const icons = providersBackstage.icons();
        const getIcon = (icon2) => {
          var _a;
          return (_a = icons[icon2]) !== null && _a !== void 0 ? _a : icon2;
        };
        const runOnItem = (f2) => (comp, se) => {
          closest$3(se.event.target, "[data-collection-item-value]").each((target) => {
            f2(comp, se, target, get$g(target, "data-collection-item-value"));
          });
        };
        const setContents = (comp, items) => {
          const disabled = providersBackstage.checkUiComponentContext("mode:design").shouldDisable || providersBackstage.isDisabled();
          const disabledClass = disabled ? " tox-collection__item--state-disabled" : "";
          const htmlLines = map$2(items, (item2) => {
            const itemText = global$6.translate(item2.text);
            const textContent = spec.columns === 1 ? `<div class="tox-collection__item-label">${itemText}</div>` : "";
            const iconContent = `<div class="tox-collection__item-icon">${getIcon(item2.icon)}</div>`;
            const mapItemName = {
              "_": " ",
              " - ": " ",
              "-": " "
            };
            const ariaLabel = itemText.replace(/\_| \- |\-/g, (match) => mapItemName[match]);
            return `<div data-mce-tooltip="${ariaLabel}" class="tox-collection__item${disabledClass}" tabindex="-1" data-collection-item-value="${global$4.encodeAllRaw(item2.value)}" aria-label="${ariaLabel}">${iconContent}${textContent}</div>`;
          });
          const chunks = spec.columns !== "auto" && spec.columns > 1 ? chunk$1(htmlLines, spec.columns) : [htmlLines];
          const html2 = map$2(chunks, (ch) => `<div class="tox-collection__group">${ch.join("")}</div>`);
          set$8(comp.element, html2.join(""));
        };
        const onClick = runOnItem((comp, se, tgt, itemValue) => {
          se.stop();
          if (!(providersBackstage.checkUiComponentContext("mode:design").shouldDisable || providersBackstage.isDisabled())) {
            emitWith(comp, formActionEvent, {
              name: spec.name,
              value: itemValue
            });
          }
        });
        const collectionEvents = [
          run$1(mouseover(), runOnItem((comp, se, tgt) => {
            focus$4(tgt, true);
          })),
          run$1(click(), onClick),
          run$1(tap(), onClick),
          run$1(focusin(), runOnItem((comp, se, tgt) => {
            descendant(comp.element, "." + activeClass).each((currentActive) => {
              remove$3(currentActive, activeClass);
            });
            add$2(tgt, activeClass);
          })),
          run$1(focusout(), runOnItem((comp) => {
            descendant(comp.element, "." + activeClass).each((currentActive) => {
              remove$3(currentActive, activeClass);
              blur$1(currentActive);
            });
          })),
          runOnExecute$1(runOnItem((comp, se, tgt, itemValue) => {
            emitWith(comp, formActionEvent, {
              name: spec.name,
              value: itemValue
            });
          }))
        ];
        const iterCollectionItems = (comp, applyAttributes) => map$2(descendants(comp.element, ".tox-collection__item"), applyAttributes);
        const pField = FormField.parts.field({
          dom: {
            tag: "div",
            // FIX: Read from columns
            classes: ["tox-collection"].concat(spec.columns !== 1 ? ["tox-collection--grid"] : ["tox-collection--list"])
          },
          components: [],
          factory: { sketch: identity },
          behaviours: derive$1([
            Disabling.config({
              disabled: () => providersBackstage.checkUiComponentContext(spec.context).shouldDisable,
              onDisabled: (comp) => {
                iterCollectionItems(comp, (childElm) => {
                  add$2(childElm, "tox-collection__item--state-disabled");
                  set$9(childElm, "aria-disabled", true);
                });
              },
              onEnabled: (comp) => {
                iterCollectionItems(comp, (childElm) => {
                  remove$3(childElm, "tox-collection__item--state-disabled");
                  remove$8(childElm, "aria-disabled");
                });
              }
            }),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context)),
            Replacing.config({}),
            Tooltipping.config({
              ...providersBackstage.tooltips.getConfig({
                tooltipText: "",
                onShow: (comp) => {
                  descendant(comp.element, "." + activeClass + "[data-mce-tooltip]").each((current) => {
                    getOpt(current, "data-mce-tooltip").each((text2) => {
                      Tooltipping.setComponents(comp, providersBackstage.tooltips.getComponents({ tooltipText: text2 }));
                    });
                  });
                }
              }),
              mode: "children-keyboard-focus",
              anchor: (comp) => ({
                type: "node",
                node: descendant(comp.element, "." + activeClass).orThunk(() => first(".tox-collection__item")),
                root: comp.element,
                layouts: {
                  onLtr: constant$1([south$2, north$2, southeast$2, northeast$2, southwest$2, northwest$2]),
                  onRtl: constant$1([south$2, north$2, southeast$2, northeast$2, southwest$2, northwest$2])
                },
                bubble: nu$6(0, -2, {})
              })
            }),
            Representing.config({
              store: {
                mode: "memory",
                initialValue: initialData.getOr([])
              },
              onSetValue: (comp, items) => {
                setContents(comp, items);
                if (spec.columns === "auto") {
                  detectSize(comp, 5, "tox-collection__item").each(({ numRows, numColumns }) => {
                    Keying.setGridSize(comp, numRows, numColumns);
                  });
                }
                emit(comp, formResizeEvent);
              }
            }),
            Tabstopping.config({}),
            Keying.config(deriveCollectionMovement(spec.columns, "normal")),
            config("collection-events", collectionEvents)
          ]),
          eventOrder: {
            [execute$5()]: ["disabling", "alloy.base.behaviour", "collection-events"],
            [focusin()]: ["collection-events", "tooltipping"]
          }
        });
        const extraClasses = ["tox-form__group--collection"];
        return renderFormFieldWith(pLabel, pField, extraClasses, []);
      };
      const renderPanelButton = (spec, sharedBackstage) => Dropdown.sketch({
        dom: spec.dom,
        components: spec.components,
        toggleClass: "mce-active",
        dropdownBehaviours: derive$1([
          DisablingConfigs.button(() => sharedBackstage.providers.isDisabled() || sharedBackstage.providers.checkUiComponentContext(spec.context).shouldDisable),
          toggleOnReceive(() => sharedBackstage.providers.checkUiComponentContext(spec.context)),
          Unselecting.config({}),
          Tabstopping.config({})
        ]),
        layouts: spec.layouts,
        sandboxClasses: ["tox-dialog__popups"],
        lazySink: sharedBackstage.getSink,
        fetch: (comp) => Future.nu((callback) => spec.fetch(callback)).map((items) => Optional.from(createTieredDataFrom(deepMerge(createPartialChoiceMenu(
          generate$6("menu-value"),
          items,
          (value2) => {
            spec.onItemAction(comp, value2);
          },
          spec.columns,
          spec.presets,
          ItemResponse$1.CLOSE_ON_EXECUTE,
          // No colour is ever selected on opening
          never,
          sharedBackstage.providers
        ), {
          movement: deriveMenuMovement(spec.columns, spec.presets)
        })))),
        parts: {
          menu: part(false, 1, spec.presets)
        }
      });
      const colorInputChangeEvent = generate$6("color-input-change");
      const colorSwatchChangeEvent = generate$6("color-swatch-change");
      const colorPickerCancelEvent = generate$6("color-picker-cancel");
      const renderColorInput = (spec, sharedBackstage, colorInputBackstage, initialData) => {
        const pField = FormField.parts.field({
          factory: Input,
          inputClasses: ["tox-textfield"],
          data: initialData,
          onSetValue: (c) => Invalidating.run(c).get(noop),
          inputBehaviours: derive$1([
            Disabling.config({
              disabled: () => sharedBackstage.providers.isDisabled() || sharedBackstage.providers.checkUiComponentContext(spec.context).shouldDisable
            }),
            toggleOnReceive(() => sharedBackstage.providers.checkUiComponentContext(spec.context)),
            Tabstopping.config({}),
            Invalidating.config({
              invalidClass: "tox-textbox-field-invalid",
              getRoot: (comp) => parentElement(comp.element),
              notify: {
                onValid: (comp) => {
                  const val = Representing.getValue(comp);
                  emitWith(comp, colorInputChangeEvent, {
                    color: val
                  });
                }
              },
              validator: {
                validateOnLoad: false,
                validate: (input2) => {
                  const inputValue = Representing.getValue(input2);
                  if (inputValue.length === 0) {
                    return Future.pure(Result.value(true));
                  } else {
                    const span = SugarElement.fromTag("span");
                    set$7(span, "background-color", inputValue);
                    const res = getRaw(span, "background-color").fold(
                      // TODO: Work out what we want to do here.
                      () => Result.error("blah"),
                      (_) => Result.value(inputValue)
                    );
                    return Future.pure(res);
                  }
                }
              }
            })
          ]),
          selectOnFocus: false
        });
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, sharedBackstage.providers));
        const emitSwatchChange = (colorBit, value2) => {
          emitWith(colorBit, colorSwatchChangeEvent, {
            value: value2
          });
        };
        const onItemAction2 = (comp, value2) => {
          memColorButton.getOpt(comp).each((colorBit) => {
            if (value2 === "custom") {
              colorInputBackstage.colorPicker((valueOpt) => {
                valueOpt.fold(() => emit(colorBit, colorPickerCancelEvent), (value3) => {
                  emitSwatchChange(colorBit, value3);
                  addColor(spec.storageKey, value3);
                });
              }, "#ffffff");
            } else if (value2 === "remove") {
              emitSwatchChange(colorBit, "");
            } else {
              emitSwatchChange(colorBit, value2);
            }
          });
        };
        const memColorButton = record(renderPanelButton({
          dom: {
            tag: "span",
            attributes: {
              "aria-label": sharedBackstage.providers.translate("Color swatch")
            }
          },
          layouts: {
            onRtl: () => [southwest$2, southeast$2, south$2],
            onLtr: () => [southeast$2, southwest$2, south$2]
          },
          components: [],
          fetch: getFetch$1(colorInputBackstage.getColors(spec.storageKey), spec.storageKey, colorInputBackstage.hasCustomColors()),
          columns: colorInputBackstage.getColorCols(spec.storageKey),
          presets: "color",
          onItemAction: onItemAction2,
          context: spec.context
        }, sharedBackstage));
        return FormField.sketch({
          dom: {
            tag: "div",
            classes: ["tox-form__group"]
          },
          components: pLabel.toArray().concat([
            {
              dom: {
                tag: "div",
                classes: ["tox-color-input"]
              },
              components: [
                pField,
                memColorButton.asSpec()
              ]
            }
          ]),
          fieldBehaviours: derive$1([
            config("form-field-events", [
              run$1(colorInputChangeEvent, (comp, se) => {
                memColorButton.getOpt(comp).each((colorButton) => {
                  set$7(colorButton.element, "background-color", se.event.color);
                });
                emitWith(comp, formChangeEvent, { name: spec.name });
              }),
              run$1(colorSwatchChangeEvent, (comp, se) => {
                FormField.getField(comp).each((field2) => {
                  Representing.setValue(field2, se.event.value);
                  Composing.getCurrent(comp).each(Focusing.focus);
                });
              }),
              run$1(colorPickerCancelEvent, (comp, _se) => {
                FormField.getField(comp).each((_field) => {
                  Composing.getCurrent(comp).each(Focusing.focus);
                });
              })
            ])
          ])
        });
      };
      const self = () => Composing.config({
        find: Optional.some
      });
      const memento$1 = (mem) => Composing.config({
        find: mem.getOpt
      });
      const childAt = (index) => Composing.config({
        find: (comp) => child$2(comp.element, index).bind((element2) => comp.getSystem().getByDom(element2).toOptional())
      });
      const ComposingConfigs = {
        self,
        memento: memento$1,
        childAt
      };
      const processors = objOf([
        defaulted("preprocess", identity),
        defaulted("postprocess", identity)
      ]);
      const memento = (mem, rawProcessors) => {
        const ps = asRawOrDie$1("RepresentingConfigs.memento processors", processors, rawProcessors);
        return Representing.config({
          store: {
            mode: "manual",
            getValue: (comp) => {
              const other = mem.get(comp);
              const rawValue = Representing.getValue(other);
              return ps.postprocess(rawValue);
            },
            setValue: (comp, rawValue) => {
              const newValue = ps.preprocess(rawValue);
              const other = mem.get(comp);
              Representing.setValue(other, newValue);
            }
          }
        });
      };
      const withComp = (optInitialValue, getter, setter) => Representing.config({
        store: {
          mode: "manual",
          ...optInitialValue.map((initialValue) => ({ initialValue })).getOr({}),
          getValue: getter,
          setValue: setter
        }
      });
      const withElement = (initialValue, getter, setter) => withComp(initialValue, (c) => getter(c.element), (c, v) => setter(c.element, v));
      const domHtml = (optInitialValue) => withElement(optInitialValue, get$f, set$8);
      const memory = (initialValue) => Representing.config({
        store: {
          mode: "memory",
          initialValue
        }
      });
      const fieldsUpdate = generate$6("rgb-hex-update");
      const sliderUpdate = generate$6("slider-update");
      const paletteUpdate = generate$6("palette-update");
      const sliderFactory = (translate2, getClass) => {
        const spectrum = Slider.parts.spectrum({
          dom: {
            tag: "div",
            classes: [getClass("hue-slider-spectrum")],
            attributes: {
              role: "presentation"
            }
          }
        });
        const thumb = Slider.parts.thumb({
          dom: {
            tag: "div",
            classes: [getClass("hue-slider-thumb")],
            attributes: {
              role: "presentation"
            }
          }
        });
        return Slider.sketch({
          dom: {
            tag: "div",
            classes: [getClass("hue-slider")],
            attributes: {
              "role": "slider",
              "aria-valuemin": 0,
              "aria-valuemax": 360,
              "aria-valuenow": 120
            }
          },
          rounded: false,
          model: {
            mode: "y",
            getInitialValue: constant$1(0)
          },
          components: [
            spectrum,
            thumb
          ],
          sliderBehaviours: derive$1([
            Focusing.config({})
          ]),
          onChange: (slider, _thumb, value2) => {
            set$9(slider.element, "aria-valuenow", Math.floor(360 - value2 * 3.6));
            emitWith(slider, sliderUpdate, {
              value: value2
            });
          }
        });
      };
      const validInput = generate$6("valid-input");
      const invalidInput = generate$6("invalid-input");
      const validatingInput = generate$6("validating-input");
      const translatePrefix = "colorcustom.rgb.";
      const uninitiatedTooltipApi = {
        isEnabled: always,
        setEnabled: noop,
        immediatelyShow: noop,
        immediatelyHide: noop
      };
      const rgbFormFactory = (translate2, getClass, onValidHexx, onInvalidHexx, tooltipGetConfig, makeIcon) => {
        const setTooltipEnabled = (enabled2, tooltipApi) => {
          const api2 = tooltipApi.get();
          if (enabled2 === api2.isEnabled()) {
            return;
          }
          api2.setEnabled(enabled2);
          if (enabled2) {
            api2.immediatelyShow();
          } else {
            api2.immediatelyHide();
          }
        };
        const invalidation = (label2, isValid, tooltipApi) => Invalidating.config({
          invalidClass: getClass("invalid"),
          notify: {
            onValidate: (comp) => {
              emitWith(comp, validatingInput, {
                type: label2
              });
            },
            onValid: (comp) => {
              setTooltipEnabled(false, tooltipApi);
              emitWith(comp, validInput, {
                type: label2,
                value: Representing.getValue(comp)
              });
            },
            onInvalid: (comp) => {
              setTooltipEnabled(true, tooltipApi);
              emitWith(comp, invalidInput, {
                type: label2,
                value: Representing.getValue(comp)
              });
            }
          },
          validator: {
            validate: (comp) => {
              const value2 = Representing.getValue(comp);
              const res = isValid(value2) ? Result.value(true) : Result.error(translate2("aria.input.invalid"));
              return Future.pure(res);
            },
            validateOnLoad: false
          }
        });
        const renderTextField2 = (isValid, name2, label2, description, data) => {
          const tooltipApi = Cell(uninitiatedTooltipApi);
          const helptext = translate2(translatePrefix + "range");
          const pLabel = FormField.parts.label({
            dom: { tag: "label" },
            components: [text$2(label2)]
          });
          const pField = FormField.parts.field({
            data,
            factory: Input,
            inputAttributes: {
              "type": "text",
              "aria-label": description,
              ...name2 === "hex" ? { "aria-live": "polite" } : {}
            },
            inputClasses: [getClass("textfield")],
            // Have basic invalidating and tabstopping behaviour.
            inputBehaviours: derive$1([
              invalidation(name2, isValid, tooltipApi),
              Tabstopping.config({}),
              Tooltipping.config({
                ...tooltipGetConfig({
                  tooltipText: "",
                  onSetup: (comp) => {
                    tooltipApi.set({
                      isEnabled: () => {
                        return Tooltipping.isEnabled(comp);
                      },
                      setEnabled: (enabled2) => {
                        return Tooltipping.setEnabled(comp, enabled2);
                      },
                      immediatelyShow: () => {
                        return Tooltipping.immediateOpenClose(comp, true);
                      },
                      immediatelyHide: () => {
                        return Tooltipping.immediateOpenClose(comp, false);
                      }
                    });
                    Tooltipping.setEnabled(comp, false);
                  },
                  onShow: (component, _tooltip) => {
                    Tooltipping.setComponents(component, [
                      {
                        dom: {
                          tag: "p",
                          classes: [
                            getClass("rgb-warning-note")
                          ]
                        },
                        components: [text$2(translate2(name2 === "hex" ? "colorcustom.rgb.invalidHex" : "colorcustom.rgb.invalid"))]
                      }
                    ]);
                  }
                })
              })
            ]),
            // If it was invalid, and the value was set, run validation against it.
            onSetValue: (input2) => {
              if (Invalidating.isInvalid(input2)) {
                const run2 = Invalidating.run(input2);
                run2.get(noop);
              }
            }
          });
          const errorId2 = generate$6("aria-invalid");
          const memInvalidIcon = record(makeIcon("invalid", Optional.some(errorId2), "warning"));
          const memStatus = record({
            dom: {
              tag: "div",
              classes: [getClass("invalid-icon")]
            },
            components: [
              memInvalidIcon.asSpec()
            ]
          });
          const comps = [pLabel, pField, memStatus.asSpec()];
          const concats = name2 !== "hex" ? [FormField.parts["aria-descriptor"]({
            text: helptext
          })] : [];
          const components2 = comps.concat(concats);
          return {
            dom: {
              tag: "div",
              attributes: {
                role: "presentation"
              },
              classes: [
                getClass("rgb-container")
              ]
            },
            components: components2
          };
        };
        const copyRgbToHex = (form, rgba) => {
          const hex = fromRgba(rgba);
          Form.getField(form, "hex").each((hexField) => {
            if (!Focusing.isFocused(hexField)) {
              Representing.setValue(form, {
                hex: hex.value
              });
            }
          });
          return hex;
        };
        const copyRgbToForm = (form, rgb) => {
          const red2 = rgb.red;
          const green = rgb.green;
          const blue = rgb.blue;
          Representing.setValue(form, { red: red2, green, blue });
        };
        const memPreview = record({
          dom: {
            tag: "div",
            classes: [getClass("rgba-preview")],
            styles: {
              "background-color": "white"
            },
            attributes: {
              role: "presentation"
            }
          }
        });
        const updatePreview = (anyInSystem, hex) => {
          memPreview.getOpt(anyInSystem).each((preview) => {
            set$7(preview.element, "background-color", "#" + hex.value);
          });
        };
        const factory2 = () => {
          const state = {
            red: Cell(Optional.some(255)),
            green: Cell(Optional.some(255)),
            blue: Cell(Optional.some(255)),
            hex: Cell(Optional.some("ffffff"))
          };
          const copyHexToRgb = (form, hex) => {
            const rgb = fromHex(hex);
            copyRgbToForm(form, rgb);
            setValueRgb(rgb);
          };
          const get2 = (prop) => state[prop].get();
          const set2 = (prop, value2) => {
            state[prop].set(value2);
          };
          const getValueRgb = () => get2("red").bind((red2) => get2("green").bind((green) => get2("blue").map((blue) => rgbaColour(red2, green, blue, 1))));
          const setValueRgb = (rgb) => {
            const red2 = rgb.red;
            const green = rgb.green;
            const blue = rgb.blue;
            set2("red", Optional.some(red2));
            set2("green", Optional.some(green));
            set2("blue", Optional.some(blue));
          };
          const onInvalidInput = (form, simulatedEvent) => {
            const data = simulatedEvent.event;
            if (data.type !== "hex") {
              set2(data.type, Optional.none());
            } else {
              onInvalidHexx(form);
            }
          };
          const onValidHex = (form, value2) => {
            onValidHexx(form);
            const hex = hexColour(value2);
            set2("hex", Optional.some(hex.value));
            const rgb = fromHex(hex);
            copyRgbToForm(form, rgb);
            setValueRgb(rgb);
            emitWith(form, fieldsUpdate, {
              hex
            });
            updatePreview(form, hex);
          };
          const onValidRgb = (form, prop, value2) => {
            const val = parseInt(value2, 10);
            set2(prop, Optional.some(val));
            getValueRgb().each((rgb) => {
              const hex = copyRgbToHex(form, rgb);
              emitWith(form, fieldsUpdate, {
                hex
              });
              updatePreview(form, hex);
            });
          };
          const isHexInputEvent = (data) => data.type === "hex";
          const onValidInput = (form, simulatedEvent) => {
            const data = simulatedEvent.event;
            if (isHexInputEvent(data)) {
              onValidHex(form, data.value);
            } else {
              onValidRgb(form, data.type, data.value);
            }
          };
          const formPartStrings = (key) => ({
            label: translate2(translatePrefix + key + ".label"),
            description: translate2(translatePrefix + key + ".description")
          });
          const redStrings = formPartStrings("red");
          const greenStrings = formPartStrings("green");
          const blueStrings = formPartStrings("blue");
          const hexStrings = formPartStrings("hex");
          return deepMerge(Form.sketch((parts2) => ({
            dom: {
              tag: "form",
              classes: [getClass("rgb-form")],
              attributes: { "aria-label": translate2("aria.color.picker") }
            },
            components: [
              parts2.field("red", FormField.sketch(renderTextField2(isRgbaComponent, "red", redStrings.label, redStrings.description, 255))),
              parts2.field("green", FormField.sketch(renderTextField2(isRgbaComponent, "green", greenStrings.label, greenStrings.description, 255))),
              parts2.field("blue", FormField.sketch(renderTextField2(isRgbaComponent, "blue", blueStrings.label, blueStrings.description, 255))),
              parts2.field("hex", FormField.sketch(renderTextField2(isHexString, "hex", hexStrings.label, hexStrings.description, "ffffff"))),
              memPreview.asSpec()
            ],
            formBehaviours: derive$1([
              Invalidating.config({
                invalidClass: getClass("form-invalid")
              }),
              config("rgb-form-events", [
                run$1(validInput, onValidInput),
                run$1(invalidInput, onInvalidInput),
                run$1(validatingInput, onInvalidInput)
              ])
            ])
          })), {
            apis: {
              updateHex: (form, hex) => {
                Representing.setValue(form, {
                  hex: hex.value
                });
                copyHexToRgb(form, hex);
                updatePreview(form, hex);
              }
            }
          });
        };
        const rgbFormSketcher = single({
          factory: factory2,
          name: "RgbForm",
          configFields: [],
          apis: {
            updateHex: (apis, form, hex) => {
              apis.updateHex(form, hex);
            }
          },
          extraApis: {}
        });
        return rgbFormSketcher;
      };
      const paletteFactory = (translate2, getClass) => {
        const spectrumPart2 = Slider.parts.spectrum({
          dom: {
            tag: "canvas",
            attributes: {
              role: "presentation"
            },
            classes: [getClass("sv-palette-spectrum")]
          }
        });
        const thumbPart2 = Slider.parts.thumb({
          dom: {
            tag: "div",
            attributes: {
              role: "presentation"
            },
            classes: [getClass("sv-palette-thumb")],
            innerHtml: `<div class=${getClass("sv-palette-inner-thumb")} role="presentation"></div>`
          }
        });
        const setColour = (canvas, rgba) => {
          const { width: width2, height: height2 } = canvas;
          const ctx = canvas.getContext("2d");
          if (ctx === null) {
            return;
          }
          ctx.fillStyle = rgba;
          ctx.fillRect(0, 0, width2, height2);
          const grdWhite = ctx.createLinearGradient(0, 0, width2, 0);
          grdWhite.addColorStop(0, "rgba(255,255,255,1)");
          grdWhite.addColorStop(1, "rgba(255,255,255,0)");
          ctx.fillStyle = grdWhite;
          ctx.fillRect(0, 0, width2, height2);
          const grdBlack = ctx.createLinearGradient(0, 0, 0, height2);
          grdBlack.addColorStop(0, "rgba(0,0,0,0)");
          grdBlack.addColorStop(1, "rgba(0,0,0,1)");
          ctx.fillStyle = grdBlack;
          ctx.fillRect(0, 0, width2, height2);
        };
        const setPaletteHue = (slider, hue) => {
          const canvas = slider.components()[0].element.dom;
          const hsv = hsvColour(hue, 100, 100);
          const rgba = fromHsv(hsv);
          setColour(canvas, toString(rgba));
        };
        const setPaletteThumb = (slider, hex) => {
          const hsv = fromRgb(fromHex(hex));
          Slider.setValue(slider, { x: hsv.saturation, y: 100 - hsv.value });
          set$9(slider.element, "aria-valuetext", translate2(["Saturation {0}%, Brightness {1}%", hsv.saturation, hsv.value]));
        };
        const factory2 = (_detail) => {
          const getInitialValue = constant$1({
            x: 0,
            y: 0
          });
          const onChange = (slider, _thumb, value2) => {
            if (!isNumber(value2)) {
              set$9(slider.element, "aria-valuetext", translate2(["Saturation {0}%, Brightness {1}%", Math.floor(value2.x), Math.floor(100 - value2.y)]));
            }
            emitWith(slider, paletteUpdate, {
              value: value2
            });
          };
          const onInit = (_slider, _thumb, spectrum, _value) => {
            setColour(spectrum.element.dom, toString(red));
          };
          const sliderBehaviours = derive$1([
            Composing.config({
              find: Optional.some
            }),
            Focusing.config({})
          ]);
          return Slider.sketch({
            dom: {
              tag: "div",
              attributes: {
                "role": "slider",
                "aria-valuetext": translate2(["Saturation {0}%, Brightness {1}%", 0, 0])
              },
              classes: [getClass("sv-palette")]
            },
            model: {
              mode: "xy",
              getInitialValue
            },
            rounded: false,
            components: [
              spectrumPart2,
              thumbPart2
            ],
            onChange,
            onInit,
            sliderBehaviours
          });
        };
        const saturationBrightnessPaletteSketcher = single({
          factory: factory2,
          name: "SaturationBrightnessPalette",
          configFields: [],
          apis: {
            setHue: (_apis, slider, hue) => {
              setPaletteHue(slider, hue);
            },
            setThumb: (_apis, slider, hex) => {
              setPaletteThumb(slider, hex);
            }
          },
          extraApis: {}
        });
        return saturationBrightnessPaletteSketcher;
      };
      const makeFactory = (translate2, getClass, tooltipConfig, makeIcon) => {
        const factory2 = (detail) => {
          const rgbForm = rgbFormFactory(translate2, getClass, detail.onValidHex, detail.onInvalidHex, tooltipConfig, makeIcon);
          const sbPalette = paletteFactory(translate2, getClass);
          const hueSliderToDegrees = (hue) => (100 - hue) / 100 * 360;
          const hueDegreesToSlider = (hue) => 100 - hue / 360 * 100;
          const state = {
            paletteRgba: Cell(red),
            paletteHue: Cell(0)
          };
          const memSlider = record(sliderFactory(translate2, getClass));
          const memPalette = record(sbPalette.sketch({}));
          const memRgb = record(rgbForm.sketch({}));
          const updatePalette = (anyInSystem, _hex, hue) => {
            memPalette.getOpt(anyInSystem).each((palette) => {
              sbPalette.setHue(palette, hue);
            });
          };
          const updateFields = (anyInSystem, hex) => {
            memRgb.getOpt(anyInSystem).each((form) => {
              rgbForm.updateHex(form, hex);
            });
          };
          const updateSlider = (anyInSystem, _hex, hue) => {
            memSlider.getOpt(anyInSystem).each((slider) => {
              Slider.setValue(slider, hueDegreesToSlider(hue));
            });
          };
          const updatePaletteThumb = (anyInSystem, hex) => {
            memPalette.getOpt(anyInSystem).each((palette) => {
              sbPalette.setThumb(palette, hex);
            });
          };
          const updateState = (hex, hue) => {
            const rgba = fromHex(hex);
            state.paletteRgba.set(rgba);
            state.paletteHue.set(hue);
          };
          const runUpdates = (anyInSystem, hex, hue, updates) => {
            updateState(hex, hue);
            each$1(updates, (update) => {
              update(anyInSystem, hex, hue);
            });
          };
          const onPaletteUpdate = () => {
            const updates = [updateFields];
            return (form, simulatedEvent) => {
              const value2 = simulatedEvent.event.value;
              const oldHue = state.paletteHue.get();
              const newHsv = hsvColour(oldHue, value2.x, 100 - value2.y);
              const newHex = hsvToHex(newHsv);
              runUpdates(form, newHex, oldHue, updates);
            };
          };
          const onSliderUpdate = () => {
            const updates = [updatePalette, updateFields];
            return (form, simulatedEvent) => {
              const hue = hueSliderToDegrees(simulatedEvent.event.value);
              const oldRgb = state.paletteRgba.get();
              const oldHsv = fromRgb(oldRgb);
              const newHsv = hsvColour(hue, oldHsv.saturation, oldHsv.value);
              const newHex = hsvToHex(newHsv);
              runUpdates(form, newHex, hue, updates);
            };
          };
          const onFieldsUpdate = () => {
            const updates = [updatePalette, updateSlider, updatePaletteThumb];
            return (form, simulatedEvent) => {
              const hex = simulatedEvent.event.hex;
              const hsv = hexToHsv(hex);
              runUpdates(form, hex, hsv.hue, updates);
            };
          };
          return {
            uid: detail.uid,
            dom: detail.dom,
            components: [
              memPalette.asSpec(),
              memSlider.asSpec(),
              memRgb.asSpec()
            ],
            behaviours: derive$1([
              config("colour-picker-events", [
                run$1(fieldsUpdate, onFieldsUpdate()),
                run$1(paletteUpdate, onPaletteUpdate()),
                run$1(sliderUpdate, onSliderUpdate())
              ]),
              Composing.config({
                find: (comp) => memRgb.getOpt(comp)
              }),
              Keying.config({
                mode: "acyclic"
              })
            ])
          };
        };
        const colourPickerSketcher = single({
          name: "ColourPicker",
          configFields: [
            required$1("dom"),
            defaulted("onValidHex", noop),
            defaulted("onInvalidHex", noop)
          ],
          factory: factory2
        });
        return colourPickerSketcher;
      };
      const english = {
        "colorcustom.rgb.red.label": "R",
        "colorcustom.rgb.red.description": "Red channel",
        "colorcustom.rgb.green.label": "G",
        "colorcustom.rgb.green.description": "Green channel",
        "colorcustom.rgb.blue.label": "B",
        "colorcustom.rgb.blue.description": "Blue channel",
        "colorcustom.rgb.hex.label": "#",
        "colorcustom.rgb.hex.description": "Hex color code",
        "colorcustom.rgb.range": "Range 0 to 255",
        "colorcustom.rgb.invalid": "Numbers only, 0 to 255",
        "colorcustom.rgb.invalidHex": "Hexadecimal only, 000000 to FFFFFF",
        "aria.color.picker": "Color Picker",
        "aria.input.invalid": "Invalid input"
      };
      const translate = (providerBackstage) => (key) => {
        if (isString(key)) {
          return providerBackstage.translate(english[key]);
        } else {
          return providerBackstage.translate(key);
        }
      };
      const renderColorPicker = (_spec, providerBackstage, initialData) => {
        const getClass = (key) => "tox-" + key;
        const renderIcon2 = (name2, errId, icon2 = name2, label2 = name2) => render$4(icon2, {
          tag: "div",
          classes: ["tox-icon", "tox-control-wrap__status-icon-" + name2],
          attributes: {
            "title": providerBackstage.translate(label2),
            "aria-live": "polite",
            ...errId.fold(() => ({}), (id) => ({ id }))
          }
        }, providerBackstage.icons);
        const colourPickerFactory = makeFactory(translate(providerBackstage), getClass, providerBackstage.tooltips.getConfig, renderIcon2);
        const onValidHex = (form) => {
          emitWith(form, formActionEvent, { name: "hex-valid", value: true });
        };
        const onInvalidHex = (form) => {
          emitWith(form, formActionEvent, { name: "hex-valid", value: false });
        };
        const memPicker = record(colourPickerFactory.sketch({
          dom: {
            tag: "div",
            classes: [getClass("color-picker-container")],
            attributes: {
              role: "presentation"
            }
          },
          onValidHex,
          onInvalidHex
        }));
        return {
          dom: {
            tag: "div"
          },
          components: [
            memPicker.asSpec()
          ],
          behaviours: derive$1([
            // We'll allow invalid values
            withComp(initialData, (comp) => {
              const picker = memPicker.get(comp);
              const optRgbForm = Composing.getCurrent(picker);
              const optHex = optRgbForm.bind((rgbForm) => {
                const formValues = Representing.getValue(rgbForm);
                return formValues.hex;
              });
              return optHex.map((hex) => "#" + removeLeading(hex, "#")).getOr("");
            }, (comp, newValue) => {
              const pattern2 = /^#([a-fA-F0-9]{3}(?:[a-fA-F0-9]{3})?)/;
              const valOpt = Optional.from(pattern2.exec(newValue)).bind((matches) => get$i(matches, 1));
              const picker = memPicker.get(comp);
              const optRgbForm = Composing.getCurrent(picker);
              optRgbForm.fold(() => {
                console.log("Can not find form");
              }, (rgbForm) => {
                Representing.setValue(rgbForm, {
                  hex: valOpt.getOr("")
                });
                Form.getField(rgbForm, "hex").each((hexField) => {
                  emit(hexField, input());
                });
              });
            }),
            ComposingConfigs.self()
          ])
        };
      };
      var global$3 = tinymce.util.Tools.resolve("tinymce.Resource");
      const isOldCustomEditor = (spec) => has$2(spec, "init");
      const renderCustomEditor = (spec) => {
        const editorApi = value$2();
        const memReplaced = record({
          dom: {
            tag: spec.tag
          }
        });
        const initialValue = value$2();
        const focusBehaviour = !isOldCustomEditor(spec) && spec.onFocus.isSome() ? [
          Focusing.config({
            onFocus: (comp) => {
              spec.onFocus.each((onFocusFn) => {
                onFocusFn(comp.element.dom);
              });
            }
          }),
          Tabstopping.config({})
        ] : [];
        return {
          dom: {
            tag: "div",
            classes: ["tox-custom-editor"]
          },
          behaviours: derive$1([
            config("custom-editor-events", [
              runOnAttached((component) => {
                memReplaced.getOpt(component).each((ta) => {
                  (isOldCustomEditor(spec) ? spec.init(ta.element.dom) : global$3.load(spec.scriptId, spec.scriptUrl).then((init2) => init2(ta.element.dom, spec.settings))).then((ea) => {
                    initialValue.on((cvalue) => {
                      ea.setValue(cvalue);
                    });
                    initialValue.clear();
                    editorApi.set(ea);
                  });
                });
              })
            ]),
            withComp(Optional.none(), () => editorApi.get().fold(() => initialValue.get().getOr(""), (ed) => ed.getValue()), (_component, value2) => {
              editorApi.get().fold(() => initialValue.set(value2), (ed) => ed.setValue(value2));
            }),
            ComposingConfigs.self()
          ].concat(focusBehaviour)),
          components: [memReplaced.asSpec()]
        };
      };
      var global$2 = tinymce.util.Tools.resolve("tinymce.util.Tools");
      const browseFilesEvent = generate$6("browse.files.event");
      const filterByExtension = (files, providersBackstage) => {
        const allowedImageFileTypes = global$2.explode(providersBackstage.getOption("images_file_types"));
        const isFileInAllowedTypes = (file) => exists(allowedImageFileTypes, (type2) => endsWith(file.name.toLowerCase(), `.${type2.toLowerCase()}`));
        return filter$2(from(files), isFileInAllowedTypes);
      };
      const renderDropZone = (spec, providersBackstage, initialData) => {
        const stopper2 = (_, se) => {
          se.stop();
        };
        const sequence2 = (actions) => (comp, se) => {
          each$1(actions, (a) => {
            a(comp, se);
          });
        };
        const onDrop = (comp, se) => {
          var _a;
          if (!Disabling.isDisabled(comp)) {
            const transferEvent = se.event.raw;
            emitWith(comp, browseFilesEvent, { files: (_a = transferEvent.dataTransfer) === null || _a === void 0 ? void 0 : _a.files });
          }
        };
        const onSelect = (component, simulatedEvent) => {
          const input2 = simulatedEvent.event.raw.target;
          emitWith(component, browseFilesEvent, { files: input2.files });
        };
        const handleFiles = (component, files) => {
          if (files) {
            Representing.setValue(component, filterByExtension(files, providersBackstage));
            emitWith(component, formChangeEvent, { name: spec.name });
          }
        };
        const memInput = record({
          dom: {
            tag: "input",
            attributes: {
              type: "file",
              accept: "image/*"
            },
            styles: {
              display: "none"
            }
          },
          behaviours: derive$1([
            config("input-file-events", [
              cutter(click()),
              cutter(tap())
            ])
          ])
        });
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, providersBackstage));
        const pField = FormField.parts.field({
          factory: Button,
          dom: {
            tag: "button",
            styles: {
              position: "relative"
            },
            classes: ["tox-button", "tox-button--secondary"]
          },
          components: [
            text$2(providersBackstage.translate("Browse for an image")),
            memInput.asSpec()
          ],
          action: (comp) => {
            const inputComp = memInput.get(comp);
            inputComp.element.dom.click();
          },
          buttonBehaviours: derive$1([
            ComposingConfigs.self(),
            memory(initialData.getOr([])),
            Tabstopping.config({}),
            DisablingConfigs.button(() => providersBackstage.checkUiComponentContext(spec.context).shouldDisable),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context))
          ])
        });
        const wrapper = {
          dom: {
            tag: "div",
            classes: ["tox-dropzone-container"]
          },
          behaviours: derive$1([
            Disabling.config({
              disabled: () => providersBackstage.checkUiComponentContext(spec.context).shouldDisable
            }),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context)),
            Toggling.config({
              toggleClass: "dragenter",
              toggleOnExecute: false
            }),
            config("dropzone-events", [
              run$1("dragenter", sequence2([stopper2, Toggling.toggle])),
              run$1("dragleave", sequence2([stopper2, Toggling.toggle])),
              run$1("dragover", stopper2),
              run$1("drop", sequence2([stopper2, onDrop])),
              run$1(change(), onSelect)
            ])
          ]),
          components: [
            {
              dom: {
                tag: "div",
                classes: ["tox-dropzone"],
                styles: {}
              },
              components: [
                {
                  dom: {
                    tag: "p"
                  },
                  components: [
                    text$2(providersBackstage.translate("Drop an image here"))
                  ]
                },
                pField
              ]
            }
          ]
        };
        return renderFormFieldWith(pLabel, wrapper, ["tox-form__group--stretched"], [config("handle-files", [
          run$1(browseFilesEvent, (comp, se) => {
            FormField.getField(comp).each((field2) => {
              handleFiles(field2, se.event.files);
            });
          })
        ])]);
      };
      const renderGrid = (spec, backstage) => ({
        dom: {
          tag: "div",
          classes: ["tox-form__grid", `tox-form__grid--${spec.columns}col`]
        },
        components: map$2(spec.items, backstage.interpreter)
      });
      const beforeObject = generate$6("alloy-fake-before-tabstop");
      const afterObject = generate$6("alloy-fake-after-tabstop");
      const craftWithClasses = (classes2) => {
        return {
          dom: {
            tag: "div",
            styles: {
              width: "1px",
              height: "1px",
              outline: "none"
            },
            attributes: {
              tabindex: "0"
              // Capture native tabbing in the appropriate order
            },
            classes: classes2
          },
          behaviours: derive$1([
            Focusing.config({ ignore: true }),
            Tabstopping.config({})
          ])
        };
      };
      const craft = (containerClasses, spec) => {
        return {
          dom: {
            tag: "div",
            classes: ["tox-navobj", ...containerClasses.getOr([])]
          },
          components: [
            craftWithClasses([beforeObject]),
            spec,
            craftWithClasses([afterObject])
          ],
          behaviours: derive$1([
            ComposingConfigs.childAt(1)
          ])
        };
      };
      const triggerTab = (placeholder2, shiftKey) => {
        emitWith(placeholder2, keydown(), {
          raw: {
            which: 9,
            shiftKey
          }
        });
      };
      const onFocus = (container, targetComp) => {
        const target = targetComp.element;
        if (has(target, beforeObject)) {
          triggerTab(container, true);
        } else if (has(target, afterObject)) {
          triggerTab(container, false);
        }
      };
      const isPseudoStop = (element2) => {
        return closest$1(element2, ["." + beforeObject, "." + afterObject].join(","), never);
      };
      const dialogChannel = generate$6("update-dialog");
      const titleChannel = generate$6("update-title");
      const bodyChannel = generate$6("update-body");
      const footerChannel = generate$6("update-footer");
      const bodySendMessageChannel = generate$6("body-send-message");
      const dialogFocusShiftedChannel = generate$6("dialog-focus-shifted");
      const browser = detect$1().browser;
      const isSafari = browser.isSafari();
      const isFirefox = browser.isFirefox();
      const isSafariOrFirefox = isSafari || isFirefox;
      const isChromium = browser.isChromium();
      const isElementScrollAtBottom = ({ scrollTop, scrollHeight, clientHeight }) => Math.ceil(scrollTop) + clientHeight >= scrollHeight;
      const scrollToY = (win2, y) => (
        // TINY-10128: The iframe body is occasionally null when we attempt to scroll, so instead of using body.scrollHeight, use a
        // fallback value of 99999999. To minimise the potential impact of future browser changes, this fallback is significantly smaller
        // than the minimum of the maximum value Window.scrollTo would take on supported browsers:
        // Chromium: > Number.MAX_SAFE_INTEGER
        // Safari: 2^31 - 1 = 2147483647
        // Firefox: 2147483583
        win2.scrollTo(0, y === "bottom" ? 99999999 : y)
      );
      const getScrollingElement = (doc, html2) => {
        const body2 = doc.body;
        return Optional.from(!/^<!DOCTYPE (html|HTML)/.test(html2) && (!isChromium && !isSafari || isNonNullable(body2) && (body2.scrollTop !== 0 || Math.abs(body2.scrollHeight - body2.clientHeight) > 1)) ? body2 : doc.documentElement);
      };
      const writeValue = (iframeElement, html2, fallbackFn) => {
        const iframe2 = iframeElement.dom;
        Optional.from(iframe2.contentDocument).fold(fallbackFn, (doc) => {
          let lastScrollTop = 0;
          const isScrollAtBottom = getScrollingElement(doc, html2).map((el) => {
            lastScrollTop = el.scrollTop;
            return el;
          }).forall(isElementScrollAtBottom);
          const scrollAfterWrite = () => {
            const win2 = iframe2.contentWindow;
            if (isNonNullable(win2)) {
              if (isScrollAtBottom) {
                scrollToY(win2, "bottom");
              } else if (!isScrollAtBottom && isSafariOrFirefox && lastScrollTop !== 0) {
                scrollToY(win2, lastScrollTop);
              }
            }
          };
          if (isSafari) {
            iframe2.addEventListener("load", scrollAfterWrite, { once: true });
          }
          doc.open();
          doc.write(html2);
          doc.close();
          if (!isSafari) {
            scrollAfterWrite();
          }
        });
      };
      const throttleInterval = someIf(isSafariOrFirefox, isSafari ? 500 : 200);
      const writeValueThrottler = throttleInterval.map((interval) => adaptable(writeValue, interval));
      const getDynamicSource = (initialData, stream) => {
        const cachedValue = Cell(initialData.getOr(""));
        return {
          getValue: (_frameComponent) => (
            // Ideally we should fetch data from the iframe...innerHtml, this triggers Cors errors
            cachedValue.get()
          ),
          setValue: (frameComponent, html2) => {
            if (cachedValue.get() !== html2) {
              const iframeElement = frameComponent.element;
              const setSrcdocValue = () => set$9(iframeElement, "srcdoc", html2);
              if (stream) {
                writeValueThrottler.fold(constant$1(writeValue), (throttler) => throttler.throttle)(iframeElement, html2, setSrcdocValue);
              } else {
                setSrcdocValue();
              }
            }
            cachedValue.set(html2);
          }
        };
      };
      const renderIFrame = (spec, providersBackstage, initialData) => {
        const baseClass = "tox-dialog__iframe";
        const opaqueClass = spec.transparent ? [] : [`${baseClass}--opaque`];
        const containerBorderedClass = spec.border ? [`tox-navobj-bordered`] : [];
        const attributes = {
          ...spec.label.map((title2) => ({ title: title2 })).getOr({}),
          ...initialData.map((html2) => ({ srcdoc: html2 })).getOr({}),
          ...spec.sandboxed ? { sandbox: "allow-scripts allow-same-origin" } : {}
        };
        const sourcing = getDynamicSource(initialData, spec.streamContent);
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, providersBackstage));
        const factory2 = (newSpec) => craft(Optional.from(containerBorderedClass), {
          // We need to use the part uid or the label and field won't be linked with ARIA
          uid: newSpec.uid,
          dom: {
            tag: "iframe",
            attributes,
            classes: [
              baseClass,
              ...opaqueClass
            ]
          },
          behaviours: derive$1([
            Tabstopping.config({}),
            Focusing.config({}),
            withComp(initialData, sourcing.getValue, sourcing.setValue),
            Receiving.config({
              channels: {
                [dialogFocusShiftedChannel]: {
                  onReceive: (comp, message) => {
                    message.newFocus.each((newFocus) => {
                      parentElement(comp.element).each((parent2) => {
                        const f2 = eq(comp.element, newFocus) ? add$2 : remove$3;
                        f2(parent2, "tox-navobj-bordered-focus");
                      });
                    });
                  }
                }
              }
            })
          ])
        });
        const pField = FormField.parts.field({
          factory: { sketch: factory2 }
        });
        return renderFormFieldWith(pLabel, pField, ["tox-form__group--stretched"], []);
      };
      const calculateImagePosition = (panelWidth, panelHeight, imageWidth, imageHeight, zoom) => {
        const width2 = imageWidth * zoom;
        const height2 = imageHeight * zoom;
        const left2 = Math.max(0, panelWidth / 2 - width2 / 2);
        const top2 = Math.max(0, panelHeight / 2 - height2 / 2);
        return {
          left: left2.toString() + "px",
          top: top2.toString() + "px",
          width: width2.toString() + "px",
          height: height2.toString() + "px"
        };
      };
      const zoomToFit = (panel, width2, height2) => {
        const panelW = get$c(panel);
        const panelH = get$d(panel);
        return Math.min(panelW / width2, panelH / height2, 1);
      };
      const renderImagePreview = (spec, initialData) => {
        const cachedData = Cell(initialData.getOr({ url: "" }));
        const memImage = record({
          dom: {
            tag: "img",
            classes: ["tox-imagepreview__image"],
            attributes: initialData.map((data) => ({ src: data.url })).getOr({})
          }
        });
        const memContainer = record({
          dom: {
            tag: "div",
            classes: ["tox-imagepreview__container"],
            attributes: {
              role: "presentation"
            }
          },
          components: [
            memImage.asSpec()
          ]
        });
        const setValue2 = (frameComponent, data) => {
          const translatedData = {
            url: data.url
          };
          data.zoom.each((z) => translatedData.zoom = z);
          data.cachedWidth.each((z) => translatedData.cachedWidth = z);
          data.cachedHeight.each((z) => translatedData.cachedHeight = z);
          cachedData.set(translatedData);
          const applyFramePositioning = () => {
            const { cachedWidth, cachedHeight, zoom } = translatedData;
            if (!isUndefined(cachedWidth) && !isUndefined(cachedHeight)) {
              if (isUndefined(zoom)) {
                const z = zoomToFit(frameComponent.element, cachedWidth, cachedHeight);
                translatedData.zoom = z;
              }
              const position2 = calculateImagePosition(get$c(frameComponent.element), get$d(frameComponent.element), cachedWidth, cachedHeight, translatedData.zoom);
              memContainer.getOpt(frameComponent).each((container) => {
                setAll(container.element, position2);
              });
            }
          };
          memImage.getOpt(frameComponent).each((imageComponent) => {
            const img = imageComponent.element;
            if (data.url !== get$g(img, "src")) {
              set$9(img, "src", data.url);
              remove$3(frameComponent.element, "tox-imagepreview__loaded");
            }
            applyFramePositioning();
            image(img).then((img2) => {
              if (frameComponent.getSystem().isConnected()) {
                add$2(frameComponent.element, "tox-imagepreview__loaded");
                translatedData.cachedWidth = img2.dom.naturalWidth;
                translatedData.cachedHeight = img2.dom.naturalHeight;
                applyFramePositioning();
              }
            });
          });
        };
        const styles = {};
        spec.height.each((h) => styles.height = h);
        const fakeValidatedData = initialData.map((d) => ({
          url: d.url,
          zoom: Optional.from(d.zoom),
          cachedWidth: Optional.from(d.cachedWidth),
          cachedHeight: Optional.from(d.cachedHeight)
        }));
        return {
          dom: {
            tag: "div",
            classes: ["tox-imagepreview"],
            styles,
            attributes: {
              role: "presentation"
            }
          },
          components: [
            memContainer.asSpec()
          ],
          behaviours: derive$1([
            ComposingConfigs.self(),
            withComp(fakeValidatedData, () => (
              /*
                          NOTE: This is intentionally returning the cached image width and height.
              
                          Including those details in the dialog data helps when `setData` only changes the URL, as
                          the old image must continue to be displayed at the old size until the new image has loaded.
                        */
              cachedData.get()
            ), setValue2)
          ])
        };
      };
      const renderLabel$2 = (spec, backstageShared, getCompByName2) => {
        const baseClass = "tox-label";
        const centerClass = spec.align === "center" ? [`${baseClass}--center`] : [];
        const endClass = spec.align === "end" ? [`${baseClass}--end`] : [];
        const label2 = record({
          dom: {
            tag: "label",
            classes: [baseClass, ...centerClass, ...endClass]
          },
          components: [
            text$2(backstageShared.providers.translate(spec.label))
          ]
        });
        const comps = map$2(spec.items, backstageShared.interpreter);
        return {
          dom: {
            tag: "div",
            classes: ["tox-form__group"]
          },
          components: [
            label2.asSpec(),
            ...comps
          ],
          behaviours: derive$1([
            ComposingConfigs.self(),
            Replacing.config({}),
            domHtml(Optional.none()),
            Keying.config({
              mode: "acyclic"
            }),
            config("label", [
              runOnAttached((comp) => {
                spec.for.each((name2) => {
                  getCompByName2(name2).each((target) => {
                    label2.getOpt(comp).each((labelComp) => {
                      var _a;
                      const id = (_a = get$g(target.element, "id")) !== null && _a !== void 0 ? _a : generate$6("form-field");
                      set$9(target.element, "id", id);
                      set$9(labelComp.element, "for", id);
                    });
                  });
                });
              })
            ])
          ])
        };
      };
      const internalToolbarButtonExecute = generate$6("toolbar.button.execute");
      const onToolbarButtonExecute = (info) => runOnExecute$1((comp, _simulatedEvent) => {
        runWithApi(info, comp)((itemApi) => {
          emitWith(comp, internalToolbarButtonExecute, {
            buttonApi: itemApi
          });
          info.onAction(itemApi);
        });
      });
      const commonButtonDisplayEvent = generate$6("common-button-display-events");
      const toolbarButtonEventOrder = {
        // TODO: use the constants provided by behaviours.
        [execute$5()]: ["disabling", "alloy.base.behaviour", "toggling", "toolbar-button-events", "tooltipping"],
        [attachedToDom()]: [
          "toolbar-button-events",
          commonButtonDisplayEvent
        ],
        [detachedFromDom()]: ["toolbar-button-events", "dropdown-events", "tooltipping"],
        [mousedown()]: [
          "focusing",
          "alloy.base.behaviour",
          commonButtonDisplayEvent
        ]
      };
      const forceInitialSize = (comp) => set$7(comp.element, "width", get$e(comp.element, "width"));
      const renderIcon$1 = (iconName, iconsProvider, behaviours2) => render$4(iconName, {
        tag: "span",
        classes: [
          "tox-icon",
          "tox-tbtn__icon-wrap"
          /* ToolbarButtonClasses.IconWrap */
        ],
        behaviours: behaviours2
      }, iconsProvider);
      const renderIconFromPack$1 = (iconName, iconsProvider) => renderIcon$1(iconName, iconsProvider, []);
      const renderReplaceableIconFromPack = (iconName, iconsProvider) => renderIcon$1(iconName, iconsProvider, [Replacing.config({})]);
      const renderLabel$1 = (text2, prefix2, providersBackstage) => ({
        dom: {
          tag: "span",
          classes: [`${prefix2}__select-label`]
        },
        components: [
          text$2(providersBackstage.translate(text2))
        ],
        behaviours: derive$1([
          Replacing.config({})
        ])
      });
      const updateMenuText = generate$6("update-menu-text");
      const updateMenuIcon = generate$6("update-menu-icon");
      const updateTooltiptext = generate$6("update-tooltip-text");
      const renderCommonDropdown = (spec, prefix2, sharedBackstage, btnName) => {
        const editorOffCell = Cell(noop);
        const tooltip = Cell(spec.tooltip);
        const optMemDisplayText = spec.text.map((text2) => record(renderLabel$1(text2, prefix2, sharedBackstage.providers)));
        const optMemDisplayIcon = spec.icon.map((iconName) => record(renderReplaceableIconFromPack(iconName, sharedBackstage.providers.icons)));
        const onLeftOrRightInMenu = (comp, se) => {
          const dropdown = Representing.getValue(comp);
          Focusing.focus(dropdown);
          emitWith(dropdown, "keydown", {
            raw: se.event.raw
          });
          Dropdown.close(dropdown);
          return Optional.some(true);
        };
        const role = spec.role.fold(() => ({}), (role2) => ({ role: role2 }));
        const listRole = Optional.from(spec.listRole).map((listRole2) => ({ listRole: listRole2 })).getOr({});
        const ariaLabelAttribute = spec.ariaLabel.fold(() => ({}), (ariaLabel) => {
          const translatedAriaLabel = sharedBackstage.providers.translate(ariaLabel);
          return {
            "aria-label": translatedAriaLabel
          };
        });
        const iconSpec = render$4("chevron-down", {
          tag: "div",
          classes: [`${prefix2}__select-chevron`]
        }, sharedBackstage.providers.icons);
        const fixWidthBehaviourName = generate$6("common-button-display-events");
        const customEventsName = "dropdown-events";
        const memDropdown = record(Dropdown.sketch({
          ...spec.uid ? { uid: spec.uid } : {},
          ...role,
          ...listRole,
          dom: {
            tag: "button",
            classes: [prefix2, `${prefix2}--select`].concat(map$2(spec.classes, (c) => `${prefix2}--${c}`)),
            attributes: {
              ...ariaLabelAttribute,
              ...isNonNullable(btnName) ? { "data-mce-name": btnName } : {}
            }
          },
          components: componentRenderPipeline([
            optMemDisplayIcon.map((mem) => mem.asSpec()),
            optMemDisplayText.map((mem) => mem.asSpec()),
            Optional.some(iconSpec)
          ]),
          matchWidth: true,
          useMinWidth: true,
          // When the dropdown opens, if we are in search mode, then we want to
          // focus our searcher.
          onOpen: (anchor2, dropdownComp, tmenuComp) => {
            if (spec.searchable) {
              focusSearchField(tmenuComp);
            }
          },
          dropdownBehaviours: derive$1([
            ...spec.dropdownBehaviours,
            DisablingConfigs.button(() => spec.disabled || sharedBackstage.providers.checkUiComponentContext(spec.context).shouldDisable),
            toggleOnReceive(() => sharedBackstage.providers.checkUiComponentContext(spec.context)),
            // INVESTIGATE (TINY-9012): There was a old comment here about something not quite working, and that
            // we can still get the button focused. It was probably related to Unselecting.
            Unselecting.config({}),
            Replacing.config({}),
            ...spec.tooltip.map((t2) => Tooltipping.config(sharedBackstage.providers.tooltips.getConfig({
              tooltipText: sharedBackstage.providers.translate(t2),
              onShow: (comp) => {
                if (lift2(tooltip.get(), spec.tooltip, (tooltipStr, tt) => tt !== tooltipStr).getOr(false)) {
                  const translatedTooltip = sharedBackstage.providers.translate(tooltip.get().getOr(""));
                  Tooltipping.setComponents(comp, sharedBackstage.providers.tooltips.getComponents({ tooltipText: translatedTooltip }));
                }
              }
            }))).toArray(),
            // This is the generic way to make onSetup and onDestroy call as the component is attached /
            // detached from the page/DOM.
            config(customEventsName, [
              onControlAttached(spec, editorOffCell),
              onControlDetached(spec, editorOffCell)
            ]),
            config(fixWidthBehaviourName, [
              runOnAttached((comp, _se) => {
                if (spec.listRole !== "listbox") {
                  forceInitialSize(comp);
                }
              })
            ]),
            config("update-dropdown-width-variable", [
              run$1(windowResize(), (comp, _se) => Dropdown.close(comp))
            ]),
            config("menubutton-update-display-text", [
              // These handlers are just using Replacing to replace either the menu
              // text or the icon.
              run$1(updateMenuText, (comp, se) => {
                optMemDisplayText.bind((mem) => mem.getOpt(comp)).each((displayText) => {
                  Replacing.set(displayText, [text$2(sharedBackstage.providers.translate(se.event.text))]);
                });
              }),
              run$1(updateMenuIcon, (comp, se) => {
                optMemDisplayIcon.bind((mem) => mem.getOpt(comp)).each((displayIcon) => {
                  Replacing.set(displayIcon, [
                    renderReplaceableIconFromPack(se.event.icon, sharedBackstage.providers.icons)
                  ]);
                });
              }),
              run$1(updateTooltiptext, (comp, se) => {
                const translatedTooltip = sharedBackstage.providers.translate(se.event.text);
                set$9(comp.element, "aria-label", translatedTooltip);
                tooltip.set(Optional.some(se.event.text));
              })
            ])
          ]),
          eventOrder: deepMerge(toolbarButtonEventOrder, {
            // INVESTIGATE (TINY-9014): Explain why we need the events in this order.
            // Ideally, have a test that fails when they are in a different order if order
            // is important
            [mousedown()]: ["focusing", "alloy.base.behaviour", "item-type-events", "normal-dropdown-events"],
            [attachedToDom()]: [
              "toolbar-button-events",
              Tooltipping.name(),
              customEventsName,
              fixWidthBehaviourName
            ]
          }),
          sandboxBehaviours: derive$1([
            Keying.config({
              mode: "special",
              onLeft: onLeftOrRightInMenu,
              onRight: onLeftOrRightInMenu
            }),
            config("dropdown-sandbox-events", [
              run$1(refetchTriggerEvent, (originalSandboxComp, se) => {
                handleRefetchTrigger(originalSandboxComp);
                se.stop();
              }),
              run$1(redirectMenuItemInteractionEvent, (sandboxComp, se) => {
                handleRedirectToMenuItem(sandboxComp, se);
                se.stop();
              })
            ])
          ]),
          lazySink: sharedBackstage.getSink,
          toggleClass: `${prefix2}--active`,
          parts: {
            menu: {
              ...part(false, spec.columns, spec.presets),
              // When the menu is "searchable", use fakeFocus so that keyboard
              // focus stays in the search field
              fakeFocus: spec.searchable,
              // We don't want to update the  `aria-selected` on highlight or dehighlight for the `listbox` role because that is used to indicate the selected item
              ...spec.listRole === "listbox" ? {} : {
                onHighlightItem: updateAriaOnHighlight,
                onCollapseMenu: (tmenuComp, itemCompCausingCollapse, nowActiveMenuComp) => {
                  Highlighting.getHighlighted(nowActiveMenuComp).each((itemComp) => {
                    updateAriaOnHighlight(tmenuComp, nowActiveMenuComp, itemComp);
                  });
                },
                onDehighlightItem: updateAriaOnDehighlight
              }
            }
          },
          getAnchorOverrides: () => {
            return {
              maxHeightFunction: (element2, available) => {
                anchored()(element2, available - 10);
              }
            };
          },
          fetch: (comp) => Future.nu(curry(spec.fetch, comp))
        }));
        return memDropdown.asSpec();
      };
      const isMenuItemReference = (item2) => isString(item2);
      const isSeparator$2 = (item2) => item2.type === "separator";
      const isExpandingMenuItem = (item2) => has$2(item2, "getSubmenuItems");
      const separator$2 = {
        type: "separator"
      };
      const unwrapReferences = (items, menuItems) => {
        const realItems = foldl(items, (acc, item2) => {
          if (isMenuItemReference(item2)) {
            if (item2 === "") {
              return acc;
            } else if (item2 === "|") {
              return acc.length > 0 && !isSeparator$2(acc[acc.length - 1]) ? acc.concat([separator$2]) : acc;
            } else if (has$2(menuItems, item2.toLowerCase())) {
              return acc.concat([menuItems[item2.toLowerCase()]]);
            } else {
              return acc;
            }
          } else {
            return acc.concat([item2]);
          }
        }, []);
        if (realItems.length > 0 && isSeparator$2(realItems[realItems.length - 1])) {
          realItems.pop();
        }
        return realItems;
      };
      const getFromExpandingItem = (item2, menuItems) => {
        const submenuItems = item2.getSubmenuItems();
        const rest = expand(submenuItems, menuItems);
        const newMenus = deepMerge(rest.menus, { [item2.value]: rest.items });
        const newExpansions = deepMerge(rest.expansions, { [item2.value]: item2.value });
        return {
          item: item2,
          menus: newMenus,
          expansions: newExpansions
        };
      };
      const generateValueIfRequired = (item2) => {
        const itemValue = get$h(item2, "value").getOrThunk(() => generate$6("generated-menu-item"));
        return deepMerge({ value: itemValue }, item2);
      };
      const expand = (items, menuItems) => {
        const realItems = unwrapReferences(isString(items) ? items.split(" ") : items, menuItems);
        return foldr(realItems, (acc, item2) => {
          if (isExpandingMenuItem(item2)) {
            const itemWithValue = generateValueIfRequired(item2);
            const newData = getFromExpandingItem(itemWithValue, menuItems);
            return {
              // Combine all of our current submenus and items with the new submenus created by
              // this item with nested subitems
              menus: deepMerge(acc.menus, newData.menus),
              // Add our parent item into the list of items in the *current menu*.
              items: [newData.item, ...acc.items],
              // Merge together our "this item opens this submenu" objects
              expansions: deepMerge(acc.expansions, newData.expansions)
            };
          } else {
            return {
              ...acc,
              items: [item2, ...acc.items]
            };
          }
        }, {
          menus: {},
          expansions: {},
          items: []
        });
      };
      const getSearchModeForField = (settings) => {
        return settings.search.fold(() => ({ searchMode: "no-search" }), (searchSettings) => ({
          searchMode: "search-with-field",
          placeholder: searchSettings.placeholder
        }));
      };
      const getSearchModeForResults = (settings) => {
        return settings.search.fold(() => ({ searchMode: "no-search" }), (_) => ({ searchMode: "search-with-results" }));
      };
      const build = (items, itemResponse, backstage, settings) => {
        const primary2 = generate$6("primary-menu");
        const data = expand(items, backstage.shared.providers.menuItems());
        if (data.items.length === 0) {
          return Optional.none();
        }
        const mainMenuSearchMode = getSearchModeForField(settings);
        const mainMenu = createPartialMenu(primary2, data.items, itemResponse, backstage, settings.isHorizontalMenu, mainMenuSearchMode);
        const submenuSearchMode = getSearchModeForResults(settings);
        const submenus = map$1(data.menus, (menuItems, menuName) => createPartialMenu(
          menuName,
          menuItems,
          itemResponse,
          backstage,
          // Currently, submenus cannot be horizontal menus (so always false)
          false,
          submenuSearchMode
        ));
        const menus = deepMerge(submenus, wrap(primary2, mainMenu));
        return Optional.from(tieredMenu.tieredData(primary2, menus, data.expansions));
      };
      const isSingleListItem = (item2) => !has$2(item2, "items");
      const dataAttribute = "data-value";
      const fetchItems = (dropdownComp, name2, items, selectedValue, hasNestedItems) => map$2(items, (item2) => {
        if (!isSingleListItem(item2)) {
          return {
            type: "nestedmenuitem",
            text: item2.text,
            getSubmenuItems: () => fetchItems(dropdownComp, name2, item2.items, selectedValue, hasNestedItems)
          };
        } else {
          return {
            type: "togglemenuitem",
            ...hasNestedItems ? {} : { role: "option" },
            text: item2.text,
            value: item2.value,
            active: item2.value === selectedValue,
            onAction: () => {
              Representing.setValue(dropdownComp, item2.value);
              emitWith(dropdownComp, formChangeEvent, { name: name2 });
              Focusing.focus(dropdownComp);
            }
          };
        }
      });
      const findItemByValue = (items, value2) => findMap(items, (item2) => {
        if (!isSingleListItem(item2)) {
          return findItemByValue(item2.items, value2);
        } else {
          return someIf(item2.value === value2, item2);
        }
      });
      const renderListBox = (spec, backstage, initialData) => {
        const hasNestedItems = exists(spec.items, (item2) => !isSingleListItem(item2));
        const providersBackstage = backstage.shared.providers;
        const initialItem = initialData.bind((value2) => findItemByValue(spec.items, value2)).orThunk(() => head(spec.items).filter(isSingleListItem));
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, providersBackstage));
        const pField = FormField.parts.field({
          dom: {},
          factory: {
            sketch: (sketchSpec) => renderCommonDropdown({
              context: spec.context,
              uid: sketchSpec.uid,
              text: initialItem.map((item2) => item2.text),
              icon: Optional.none(),
              tooltip: Optional.none(),
              role: someIf(!hasNestedItems, "combobox"),
              ...hasNestedItems ? {} : { listRole: "listbox" },
              ariaLabel: spec.label,
              fetch: (comp, callback) => {
                const items = fetchItems(comp, spec.name, spec.items, Representing.getValue(comp), hasNestedItems);
                callback(build(items, ItemResponse$1.CLOSE_ON_EXECUTE, backstage, {
                  isHorizontalMenu: false,
                  search: Optional.none()
                }));
              },
              onSetup: constant$1(noop),
              getApi: constant$1({}),
              columns: 1,
              presets: "normal",
              classes: [],
              dropdownBehaviours: [
                Tabstopping.config({}),
                withComp(initialItem.map((item2) => item2.value), (comp) => get$g(comp.element, dataAttribute), (comp, data) => {
                  findItemByValue(spec.items, data).each((item2) => {
                    set$9(comp.element, dataAttribute, item2.value);
                    emitWith(comp, updateMenuText, { text: item2.text });
                  });
                })
              ]
            }, "tox-listbox", backstage.shared)
          }
        });
        const listBoxWrap = {
          dom: {
            tag: "div",
            classes: ["tox-listboxfield"]
          },
          components: [pField]
        };
        return FormField.sketch({
          dom: {
            tag: "div",
            classes: ["tox-form__group"]
          },
          components: flatten([pLabel.toArray(), [listBoxWrap]]),
          fieldBehaviours: derive$1([
            Disabling.config({
              disabled: () => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable,
              onDisabled: (comp) => {
                FormField.getField(comp).each(Disabling.disable);
              },
              onEnabled: (comp) => {
                FormField.getField(comp).each(Disabling.enable);
              }
            })
          ])
        });
      };
      const renderPanel = (spec, backstage) => ({
        dom: {
          tag: "div",
          classes: spec.classes
        },
        // All of the items passed through the form need to be put through the interpreter
        // with their form part preserved.
        components: map$2(spec.items, backstage.shared.interpreter)
      });
      const renderSelectBox = (spec, providersBackstage, initialData) => {
        const translatedOptions = map$2(spec.items, (item2) => ({
          text: providersBackstage.translate(item2.text),
          value: item2.value
        }));
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, providersBackstage));
        const pField = FormField.parts.field({
          // TODO: Alloy should not allow dom changing of an HTML select!
          dom: {},
          ...initialData.map((data) => ({ data })).getOr({}),
          selectAttributes: {
            size: spec.size
          },
          options: translatedOptions,
          factory: HtmlSelect,
          selectBehaviours: derive$1([
            Disabling.config({
              disabled: () => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable
            }),
            Tabstopping.config({}),
            config("selectbox-change", [
              run$1(change(), (component, _) => {
                emitWith(component, formChangeEvent, { name: spec.name });
              })
            ])
          ])
        });
        const chevron = spec.size > 1 ? Optional.none() : Optional.some(render$4("chevron-down", { tag: "div", classes: ["tox-selectfield__icon-js"] }, providersBackstage.icons));
        const selectWrap = {
          dom: {
            tag: "div",
            classes: ["tox-selectfield"]
          },
          components: flatten([[pField], chevron.toArray()])
        };
        return FormField.sketch({
          dom: {
            tag: "div",
            classes: ["tox-form__group"]
          },
          components: flatten([pLabel.toArray(), [selectWrap]]),
          fieldBehaviours: derive$1([
            Disabling.config({
              disabled: () => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable,
              onDisabled: (comp) => {
                FormField.getField(comp).each(Disabling.disable);
              },
              onEnabled: (comp) => {
                FormField.getField(comp).each(Disabling.enable);
              }
            }),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context))
          ])
        });
      };
      const formatSize = (size) => {
        const unitDec = {
          "": 0,
          "px": 0,
          "pt": 1,
          "mm": 1,
          "pc": 2,
          "ex": 2,
          "em": 2,
          "ch": 2,
          "rem": 2,
          "cm": 3,
          "in": 4,
          "%": 4
        };
        const maxDecimal = (unit) => unit in unitDec ? unitDec[unit] : 1;
        let numText = size.value.toFixed(maxDecimal(size.unit));
        if (numText.indexOf(".") !== -1) {
          numText = numText.replace(/\.?0*$/, "");
        }
        return numText + size.unit;
      };
      const parseSize = (sizeText) => {
        const numPattern = /^\s*(\d+(?:\.\d+)?)\s*(|cm|mm|in|px|pt|pc|em|ex|ch|rem|vw|vh|vmin|vmax|%)\s*$/;
        const match = numPattern.exec(sizeText);
        if (match !== null) {
          const value2 = parseFloat(match[1]);
          const unit = match[2];
          return Result.value({ value: value2, unit });
        } else {
          return Result.error(sizeText);
        }
      };
      const convertUnit = (size, unit) => {
        const inInch = {
          "": 96,
          "px": 96,
          "pt": 72,
          "cm": 2.54,
          "pc": 12,
          "mm": 25.4,
          "in": 1
        };
        const supported = (u) => has$2(inInch, u);
        if (size.unit === unit) {
          return Optional.some(size.value);
        } else if (supported(size.unit) && supported(unit)) {
          if (inInch[size.unit] === inInch[unit]) {
            return Optional.some(size.value);
          } else {
            return Optional.some(size.value / inInch[size.unit] * inInch[unit]);
          }
        } else {
          return Optional.none();
        }
      };
      const noSizeConversion = (_input) => Optional.none();
      const ratioSizeConversion = (scale, unit) => (size) => convertUnit(size, unit).map((value2) => ({ value: value2 * scale, unit }));
      const makeRatioConverter = (currentFieldText, otherFieldText) => {
        const cValue = parseSize(currentFieldText).toOptional();
        const oValue = parseSize(otherFieldText).toOptional();
        return lift2(cValue, oValue, (cSize, oSize) => convertUnit(cSize, oSize.unit).map((val) => oSize.value / val).map((r2) => ratioSizeConversion(r2, oSize.unit)).getOr(noSizeConversion)).getOr(noSizeConversion);
      };
      const renderSizeInput = (spec, providersBackstage) => {
        let converter = noSizeConversion;
        const ratioEvent = generate$6("ratio-event");
        const makeIcon = (iconName) => render$4(iconName, { tag: "span", classes: ["tox-icon", "tox-lock-icon__" + iconName] }, providersBackstage.icons);
        const disabled = () => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable;
        const toggleOnReceive$1 = toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context));
        const label2 = spec.label.getOr("Constrain proportions");
        const translatedLabel = providersBackstage.translate(label2);
        const pLock = FormCoupledInputs.parts.lock({
          dom: {
            tag: "button",
            classes: ["tox-lock", "tox-button", "tox-button--naked", "tox-button--icon"],
            attributes: {
              "aria-label": translatedLabel,
              "data-mce-name": label2
            }
          },
          components: [
            makeIcon("lock"),
            makeIcon("unlock")
          ],
          buttonBehaviours: derive$1([
            Disabling.config({ disabled }),
            toggleOnReceive$1,
            Tabstopping.config({}),
            Tooltipping.config(providersBackstage.tooltips.getConfig({
              tooltipText: translatedLabel
            }))
          ])
        });
        const formGroup = (components2) => ({
          dom: {
            tag: "div",
            classes: ["tox-form__group"]
          },
          components: components2
        });
        const getFieldPart = (isField1) => FormField.parts.field({
          factory: Input,
          inputClasses: ["tox-textfield"],
          inputBehaviours: derive$1([
            Disabling.config({ disabled }),
            toggleOnReceive$1,
            Tabstopping.config({}),
            config("size-input-events", [
              run$1(focusin(), (component, _simulatedEvent) => {
                emitWith(component, ratioEvent, { isField1 });
              }),
              run$1(change(), (component, _simulatedEvent) => {
                emitWith(component, formChangeEvent, { name: spec.name });
              })
            ])
          ]),
          selectOnFocus: false
        });
        const getLabel = (label3) => ({
          dom: {
            tag: "label",
            classes: ["tox-label"]
          },
          components: [
            text$2(providersBackstage.translate(label3))
          ]
        });
        const widthField = FormCoupledInputs.parts.field1(formGroup([FormField.parts.label(getLabel("Width")), getFieldPart(true)]));
        const heightField = FormCoupledInputs.parts.field2(formGroup([FormField.parts.label(getLabel("Height")), getFieldPart(false)]));
        return FormCoupledInputs.sketch({
          dom: {
            tag: "div",
            classes: ["tox-form__group"]
          },
          components: [
            {
              dom: {
                tag: "div",
                classes: ["tox-form__controls-h-stack"]
              },
              components: [
                // NOTE: Form coupled inputs to the FormField.sketch themselves.
                widthField,
                heightField,
                formGroup([
                  getLabel(nbsp),
                  pLock
                ])
              ]
            }
          ],
          field1Name: "width",
          field2Name: "height",
          locked: true,
          markers: {
            lockClass: "tox-locked"
          },
          onLockedChange: (current, other, _lock) => {
            parseSize(Representing.getValue(current)).each((size) => {
              converter(size).each((newSize) => {
                Representing.setValue(other, formatSize(newSize));
              });
            });
          },
          coupledFieldBehaviours: derive$1([
            Disabling.config({
              disabled,
              onDisabled: (comp) => {
                FormCoupledInputs.getField1(comp).bind(FormField.getField).each(Disabling.disable);
                FormCoupledInputs.getField2(comp).bind(FormField.getField).each(Disabling.disable);
                FormCoupledInputs.getLock(comp).each(Disabling.disable);
              },
              onEnabled: (comp) => {
                FormCoupledInputs.getField1(comp).bind(FormField.getField).each(Disabling.enable);
                FormCoupledInputs.getField2(comp).bind(FormField.getField).each(Disabling.enable);
                FormCoupledInputs.getLock(comp).each(Disabling.enable);
              }
            }),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext("mode:design")),
            config("size-input-events2", [
              run$1(ratioEvent, (component, simulatedEvent) => {
                const isField1 = simulatedEvent.event.isField1;
                const optCurrent = isField1 ? FormCoupledInputs.getField1(component) : FormCoupledInputs.getField2(component);
                const optOther = isField1 ? FormCoupledInputs.getField2(component) : FormCoupledInputs.getField1(component);
                const value1 = optCurrent.map(Representing.getValue).getOr("");
                const value2 = optOther.map(Representing.getValue).getOr("");
                converter = makeRatioConverter(value1, value2);
              })
            ])
          ])
        });
      };
      const renderSlider = (spec, providerBackstage, initialData) => {
        const labelPart2 = Slider.parts.label({
          dom: {
            tag: "label",
            classes: ["tox-label"]
          },
          components: [
            text$2(providerBackstage.translate(spec.label))
          ]
        });
        const spectrum = Slider.parts.spectrum({
          dom: {
            tag: "div",
            classes: ["tox-slider__rail"],
            attributes: {
              role: "presentation"
            }
          }
        });
        const thumb = Slider.parts.thumb({
          dom: {
            tag: "div",
            classes: ["tox-slider__handle"],
            attributes: {
              role: "presentation"
            }
          }
        });
        return Slider.sketch({
          dom: {
            tag: "div",
            classes: ["tox-slider"],
            attributes: {
              role: "presentation"
            }
          },
          model: {
            mode: "x",
            minX: spec.min,
            maxX: spec.max,
            getInitialValue: constant$1(initialData.getOrThunk(() => (Math.abs(spec.max) - Math.abs(spec.min)) / 2))
          },
          components: [
            labelPart2,
            spectrum,
            thumb
          ],
          sliderBehaviours: derive$1([
            ComposingConfigs.self(),
            Focusing.config({})
          ]),
          onChoose: (component, thumb2, value2) => {
            emitWith(component, formChangeEvent, { name: spec.name, value: value2 });
          },
          onChange: (component, thumb2, value2) => {
            emitWith(component, formChangeEvent, { name: spec.name, value: value2 });
          }
        });
      };
      const renderTable = (spec, providersBackstage) => {
        const renderTh = (text2) => ({
          dom: {
            tag: "th",
            innerHtml: providersBackstage.translate(text2)
          }
        });
        const renderHeader2 = (header) => ({
          dom: {
            tag: "thead"
          },
          components: [
            {
              dom: {
                tag: "tr"
              },
              components: map$2(header, renderTh)
            }
          ]
        });
        const renderTd = (text2) => ({ dom: { tag: "td", innerHtml: providersBackstage.translate(text2) } });
        const renderTr = (row) => ({ dom: { tag: "tr" }, components: map$2(row, renderTd) });
        const renderRows = (rows) => ({ dom: { tag: "tbody" }, components: map$2(rows, renderTr) });
        return {
          dom: {
            tag: "table",
            classes: ["tox-dialog__table"]
          },
          components: [
            renderHeader2(spec.header),
            renderRows(spec.cells)
          ],
          behaviours: derive$1([
            Tabstopping.config({}),
            Focusing.config({})
          ])
        };
      };
      const renderTextField = (spec, providersBackstage) => {
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, providersBackstage));
        const baseInputBehaviours = [
          Disabling.config({
            disabled: () => spec.disabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable
          }),
          toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context)),
          Keying.config({
            mode: "execution",
            useEnter: spec.multiline !== true,
            useControlEnter: spec.multiline === true,
            execute: (comp) => {
              emit(comp, formSubmitEvent);
              return Optional.some(true);
            }
          }),
          config("textfield-change", [
            run$1(input(), (component, _) => {
              emitWith(component, formChangeEvent, { name: spec.name });
            }),
            run$1(postPaste(), (component, _) => {
              emitWith(component, formChangeEvent, { name: spec.name });
            })
          ]),
          Tabstopping.config({})
        ];
        const validatingBehaviours = spec.validation.map((vl) => Invalidating.config({
          getRoot: (input2) => {
            return parentElement(input2.element);
          },
          invalidClass: "tox-invalid",
          validator: {
            validate: (input2) => {
              const v = Representing.getValue(input2);
              const result = vl.validator(v);
              return Future.pure(result === true ? Result.value(v) : Result.error(result));
            },
            validateOnLoad: vl.validateOnLoad
          }
        })).toArray();
        const placeholder2 = spec.placeholder.fold(constant$1({}), (p) => ({ placeholder: providersBackstage.translate(p) }));
        const inputMode = spec.inputMode.fold(constant$1({}), (mode) => ({ inputmode: mode }));
        const inputAttributes = {
          ...placeholder2,
          ...inputMode,
          "data-mce-name": spec.name
        };
        const pField = FormField.parts.field({
          tag: spec.multiline === true ? "textarea" : "input",
          ...spec.data.map((data) => ({ data })).getOr({}),
          inputAttributes,
          inputClasses: [spec.classname],
          inputBehaviours: derive$1(flatten([
            baseInputBehaviours,
            validatingBehaviours
          ])),
          selectOnFocus: false,
          factory: Input
        });
        const pTextField = spec.multiline ? {
          dom: {
            tag: "div",
            classes: ["tox-textarea-wrap"]
          },
          components: [pField]
        } : pField;
        const extraClasses = spec.flex ? ["tox-form__group--stretched"] : [];
        const extraClasses2 = extraClasses.concat(spec.maximized ? ["tox-form-group--maximize"] : []);
        const extraBehaviours = [
          Disabling.config({
            disabled: () => spec.disabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable,
            onDisabled: (comp) => {
              FormField.getField(comp).each(Disabling.disable);
            },
            onEnabled: (comp) => {
              FormField.getField(comp).each(Disabling.enable);
            }
          }),
          toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context))
        ];
        return renderFormFieldWith(pLabel, pTextField, extraClasses2, extraBehaviours);
      };
      const renderInput = (spec, providersBackstage, initialData) => renderTextField({
        name: spec.name,
        multiline: false,
        label: spec.label,
        inputMode: spec.inputMode,
        placeholder: spec.placeholder,
        flex: false,
        disabled: !spec.enabled,
        classname: "tox-textfield",
        validation: Optional.none(),
        maximized: spec.maximized,
        data: initialData,
        context: spec.context
      }, providersBackstage);
      const renderTextarea = (spec, providersBackstage, initialData) => renderTextField({
        name: spec.name,
        multiline: true,
        label: spec.label,
        inputMode: Optional.none(),
        // type attribute is not valid for textareas
        placeholder: spec.placeholder,
        flex: true,
        disabled: !spec.enabled,
        classname: "tox-textarea",
        validation: Optional.none(),
        maximized: spec.maximized,
        data: initialData,
        context: spec.context
      }, providersBackstage);
      const getMenuButtonApi = (component) => ({
        isEnabled: () => !Disabling.isDisabled(component),
        setEnabled: (state) => Disabling.set(component, !state),
        setActive: (state) => {
          const elm = component.element;
          if (state) {
            add$2(
              elm,
              "tox-tbtn--enabled"
              /* ToolbarButtonClasses.Ticked */
            );
            set$9(elm, "aria-pressed", true);
          } else {
            remove$3(
              elm,
              "tox-tbtn--enabled"
              /* ToolbarButtonClasses.Ticked */
            );
            remove$8(elm, "aria-pressed");
          }
        },
        isActive: () => has(
          component.element,
          "tox-tbtn--enabled"
          /* ToolbarButtonClasses.Ticked */
        ),
        setTooltip: (tooltip) => {
          emitWith(component, updateTooltiptext, {
            text: tooltip
          });
        },
        setText: (text2) => {
          emitWith(component, updateMenuText, {
            text: text2
          });
        },
        setIcon: (icon2) => emitWith(component, updateMenuIcon, {
          icon: icon2
        })
      });
      const renderMenuButton = (spec, prefix2, backstage, role, tabstopping = true, btnName) => {
        const classes2 = spec.buttonType === "bordered" ? ["bordered"] : [];
        return renderCommonDropdown({
          text: spec.text,
          icon: spec.icon,
          tooltip: spec.tooltip,
          ariaLabel: spec.tooltip,
          searchable: spec.search.isSome(),
          // https://www.w3.org/TR/wai-aria-practices/examples/menubar/menubar-2/menubar-2.html
          role,
          fetch: (dropdownComp, callback) => {
            const fetchContext = {
              pattern: spec.search.isSome() ? getSearchPattern(dropdownComp) : ""
            };
            spec.fetch((items) => {
              callback(build(items, ItemResponse$1.CLOSE_ON_EXECUTE, backstage, {
                isHorizontalMenu: false,
                // MenuButtons are the only dropdowns that support searchable (2022-08-16)
                search: spec.search
              }));
            }, fetchContext, getMenuButtonApi(dropdownComp));
          },
          onSetup: spec.onSetup,
          getApi: (comp) => getMenuButtonApi(comp),
          columns: 1,
          presets: "normal",
          classes: classes2,
          dropdownBehaviours: [
            ...tabstopping ? [Tabstopping.config({})] : []
          ],
          context: spec.context
        }, prefix2, backstage.shared, btnName);
      };
      const getFetch = (items, getButton, backstage) => {
        const getMenuItemAction = (item2) => (api2) => {
          const newValue = !api2.isActive();
          api2.setActive(newValue);
          item2.storage.set(newValue);
          backstage.shared.getSink().each((sink) => {
            getButton().getOpt(sink).each((orig) => {
              focus$4(orig.element);
              emitWith(orig, formActionEvent, {
                name: item2.name,
                value: item2.storage.get()
              });
            });
          });
        };
        const getMenuItemSetup = (item2) => (api2) => {
          api2.setActive(item2.storage.get());
        };
        return (success) => {
          success(map$2(items, (item2) => {
            const text2 = item2.text.fold(() => ({}), (text3) => ({
              text: text3
            }));
            return {
              type: item2.type,
              active: false,
              ...text2,
              context: item2.context,
              onAction: getMenuItemAction(item2),
              onSetup: getMenuItemSetup(item2)
            };
          }));
        };
      };
      const renderLabel = (text2) => ({
        dom: {
          tag: "span",
          classes: ["tox-tree__label"],
          attributes: {
            "aria-label": text2
          }
        },
        components: [
          text$2(text2)
        ]
      });
      const renderCustomStateIcon = (container, components2, backstage) => {
        container.customStateIcon.each((icon2) => components2.push(renderIcon(icon2, backstage.shared.providers.icons, container.customStateIconTooltip.fold(() => [], (tooltip) => [
          Tooltipping.config(backstage.shared.providers.tooltips.getConfig({
            tooltipText: tooltip
          }))
        ]), ["tox-icon-custom-state"])));
      };
      const leafLabelEventsId = generate$6("leaf-label-event-id");
      const renderLeafLabel = ({ leaf: leaf2, onLeafAction, visible, treeId, selectedId, backstage }) => {
        const internalMenuButton = leaf2.menu.map((btn) => renderMenuButton(btn, "tox-mbtn", backstage, Optional.none(), visible));
        const components2 = [renderLabel(leaf2.title)];
        renderCustomStateIcon(leaf2, components2, backstage);
        internalMenuButton.each((btn) => components2.push(btn));
        return Button.sketch({
          dom: {
            tag: "div",
            classes: ["tox-tree--leaf__label", "tox-trbtn"].concat(visible ? ["tox-tree--leaf__label--visible"] : [])
          },
          components: components2,
          role: "treeitem",
          action: (button2) => {
            onLeafAction(leaf2.id);
            button2.getSystem().broadcastOn([`update-active-item-${treeId}`], {
              value: leaf2.id
            });
          },
          eventOrder: {
            [keydown()]: [
              leafLabelEventsId,
              "keying"
            ]
          },
          buttonBehaviours: derive$1([
            ...visible ? [Tabstopping.config({})] : [],
            Toggling.config({
              toggleClass: "tox-trbtn--enabled",
              toggleOnExecute: false,
              aria: {
                mode: "selected"
              }
            }),
            Receiving.config({
              channels: {
                [`update-active-item-${treeId}`]: {
                  onReceive: (comp, message) => {
                    (message.value === leaf2.id ? Toggling.on : Toggling.off)(comp);
                  }
                }
              }
            }),
            config(leafLabelEventsId, [
              runOnAttached((comp, _se) => {
                selectedId.each((id) => {
                  const toggle2 = id === leaf2.id ? Toggling.on : Toggling.off;
                  toggle2(comp);
                });
              }),
              run$1(keydown(), (comp, se) => {
                const isLeftArrowKey = se.event.raw.code === "ArrowLeft";
                const isRightArrowKey = se.event.raw.code === "ArrowRight";
                if (isLeftArrowKey) {
                  ancestor$1(comp.element, ".tox-tree--directory").each((dirElement) => {
                    comp.getSystem().getByDom(dirElement).each((dirComp) => {
                      child(dirElement, ".tox-tree--directory__label").each((dirLabelElement) => {
                        dirComp.getSystem().getByDom(dirLabelElement).each(Focusing.focus);
                      });
                    });
                  });
                  se.stop();
                } else if (isRightArrowKey) {
                  se.stop();
                }
              })
            ])
          ])
        });
      };
      const renderIcon = (iconName, iconsProvider, behaviours2, extraClasses, extraAttributes) => render$4(iconName, {
        tag: "span",
        classes: [
          "tox-tree__icon-wrap",
          "tox-icon"
        ].concat(extraClasses || []),
        behaviours: behaviours2,
        attributes: extraAttributes
      }, iconsProvider);
      const renderIconFromPack = (iconName, iconsProvider) => renderIcon(iconName, iconsProvider, []);
      const directoryLabelEventsId = generate$6("directory-label-event-id");
      const renderDirectoryLabel = ({ directory, visible, noChildren, backstage }) => {
        const internalMenuButton = directory.menu.map((btn) => renderMenuButton(btn, "tox-mbtn", backstage, Optional.none()));
        const components2 = [
          {
            dom: {
              tag: "div",
              classes: ["tox-chevron"]
            },
            components: [
              renderIconFromPack("chevron-right", backstage.shared.providers.icons)
            ]
          },
          renderLabel(directory.title)
        ];
        renderCustomStateIcon(directory, components2, backstage);
        internalMenuButton.each((btn) => {
          components2.push(btn);
        });
        const toggleExpandChildren = (button2) => {
          ancestor$1(button2.element, ".tox-tree--directory").each((directoryEle) => {
            button2.getSystem().getByDom(directoryEle).each((directoryComp) => {
              const willExpand = !Toggling.isOn(directoryComp);
              Toggling.toggle(directoryComp);
              emitWith(button2, "expand-tree-node", { expanded: willExpand, node: directory.id });
            });
          });
        };
        return Button.sketch({
          dom: {
            tag: "div",
            classes: ["tox-tree--directory__label", "tox-trbtn"].concat(visible ? ["tox-tree--directory__label--visible"] : [])
          },
          components: components2,
          action: toggleExpandChildren,
          eventOrder: {
            [keydown()]: [
              directoryLabelEventsId,
              "keying"
            ]
          },
          buttonBehaviours: derive$1([
            ...visible ? [Tabstopping.config({})] : [],
            config(directoryLabelEventsId, [
              run$1(keydown(), (comp, se) => {
                const isRightArrowKey = se.event.raw.code === "ArrowRight";
                const isLeftArrowKey = se.event.raw.code === "ArrowLeft";
                if (isRightArrowKey && noChildren) {
                  se.stop();
                }
                if (isRightArrowKey || isLeftArrowKey) {
                  ancestor$1(comp.element, ".tox-tree--directory").each((directoryEle) => {
                    comp.getSystem().getByDom(directoryEle).each((directoryComp) => {
                      if (!Toggling.isOn(directoryComp) && isRightArrowKey || Toggling.isOn(directoryComp) && isLeftArrowKey) {
                        toggleExpandChildren(comp);
                        se.stop();
                      } else if (isLeftArrowKey && !Toggling.isOn(directoryComp)) {
                        ancestor$1(directoryComp.element, ".tox-tree--directory").each((parentDirElement) => {
                          child(parentDirElement, ".tox-tree--directory__label").each((parentDirLabelElement) => {
                            directoryComp.getSystem().getByDom(parentDirLabelElement).each(Focusing.focus);
                          });
                        });
                        se.stop();
                      }
                    });
                  });
                }
              })
            ])
          ])
        });
      };
      const renderDirectoryChildren = ({ children: children2, onLeafAction, visible, treeId, expandedIds, selectedId, backstage }) => {
        return {
          dom: {
            tag: "div",
            classes: ["tox-tree--directory__children"]
          },
          components: children2.map((item2) => {
            return item2.type === "leaf" ? renderLeafLabel({ leaf: item2, selectedId, onLeafAction, visible, treeId, backstage }) : renderDirectory({ directory: item2, expandedIds, selectedId, onLeafAction, labelTabstopping: visible, treeId, backstage });
          }),
          behaviours: derive$1([
            Sliding.config({
              dimension: {
                property: "height"
              },
              closedClass: "tox-tree--directory__children--closed",
              openClass: "tox-tree--directory__children--open",
              growingClass: "tox-tree--directory__children--growing",
              shrinkingClass: "tox-tree--directory__children--shrinking",
              expanded: visible
            }),
            Replacing.config({})
          ])
        };
      };
      const directoryEventsId = generate$6("directory-event-id");
      const renderDirectory = ({ directory, onLeafAction, labelTabstopping, treeId, backstage, expandedIds, selectedId }) => {
        const { children: children2 } = directory;
        const expandedIdsCell = Cell(expandedIds);
        const computedChildrenComponents = (visible) => children2.map((item2) => {
          return item2.type === "leaf" ? renderLeafLabel({ leaf: item2, selectedId, onLeafAction, visible, treeId, backstage }) : renderDirectory({ directory: item2, expandedIds: expandedIdsCell.get(), selectedId, onLeafAction, labelTabstopping: visible, treeId, backstage });
        });
        const childrenVisible = expandedIds.includes(directory.id);
        return {
          dom: {
            tag: "div",
            classes: ["tox-tree--directory"],
            attributes: {
              role: "treeitem"
            }
          },
          components: [
            renderDirectoryLabel({ directory, visible: labelTabstopping, noChildren: directory.children.length === 0, backstage }),
            renderDirectoryChildren({ children: children2, expandedIds, selectedId, onLeafAction, visible: childrenVisible, treeId, backstage })
          ],
          behaviours: derive$1([
            config(directoryEventsId, [
              runOnAttached((comp, _se) => {
                Toggling.set(comp, childrenVisible);
              }),
              run$1("expand-tree-node", (_cmp, se) => {
                const { expanded, node } = se.event;
                expandedIdsCell.set(expanded ? [...expandedIdsCell.get(), node] : expandedIdsCell.get().filter((id) => id !== node));
              })
            ]),
            Toggling.config({
              ...directory.children.length > 0 ? {
                aria: {
                  mode: "expanded"
                }
              } : {},
              toggleClass: "tox-tree--directory--expanded",
              onToggled: (comp, childrenVisible2) => {
                const childrenComp = comp.components()[1];
                const newChildren = computedChildrenComponents(childrenVisible2);
                if (childrenVisible2) {
                  Sliding.grow(childrenComp);
                } else {
                  Sliding.shrink(childrenComp);
                }
                Replacing.set(childrenComp, newChildren);
              }
            })
          ])
        };
      };
      const treeEventsId = generate$6("tree-event-id");
      const renderTree = (spec, backstage) => {
        const onLeafAction = spec.onLeafAction.getOr(noop);
        const onToggleExpand = spec.onToggleExpand.getOr(noop);
        const defaultExpandedIds = spec.defaultExpandedIds;
        const expandedIds = Cell(defaultExpandedIds);
        const selectedIdCell = Cell(spec.defaultSelectedId);
        const treeId = generate$6("tree-id");
        const children2 = (selectedId, expandedIds2) => spec.items.map((item2) => {
          return item2.type === "leaf" ? renderLeafLabel({ leaf: item2, selectedId, onLeafAction, visible: true, treeId, backstage }) : renderDirectory({ directory: item2, selectedId, onLeafAction, expandedIds: expandedIds2, labelTabstopping: true, treeId, backstage });
        });
        return {
          dom: {
            tag: "div",
            classes: ["tox-tree"],
            attributes: {
              role: "tree"
            }
          },
          components: children2(selectedIdCell.get(), expandedIds.get()),
          behaviours: derive$1([
            Keying.config({
              mode: "flow",
              selector: ".tox-tree--leaf__label--visible, .tox-tree--directory__label--visible",
              cycles: false
            }),
            config(treeEventsId, [
              run$1("expand-tree-node", (_cmp, se) => {
                const { expanded, node } = se.event;
                expandedIds.set(expanded ? [...expandedIds.get(), node] : expandedIds.get().filter((id) => id !== node));
                onToggleExpand(expandedIds.get(), { expanded, node });
              })
            ]),
            Receiving.config({
              channels: {
                [`update-active-item-${treeId}`]: {
                  onReceive: (comp, message) => {
                    selectedIdCell.set(Optional.some(message.value));
                    Replacing.set(comp, children2(Optional.some(message.value), expandedIds.get()));
                  }
                }
              }
            }),
            Replacing.config({})
          ])
        };
      };
      const renderCommonSpec = (spec, actionOpt, extraBehaviours = [], dom2, components2, tooltip, providersBackstage) => {
        const action = actionOpt.fold(() => ({}), (action2) => ({
          action: action2
        }));
        const common = {
          buttonBehaviours: derive$1([
            DisablingConfigs.item(() => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context)),
            Tabstopping.config({}),
            ...tooltip.map((t2) => Tooltipping.config(providersBackstage.tooltips.getConfig({
              tooltipText: providersBackstage.translate(t2)
            }))).toArray(),
            config("button press", [
              preventDefault("click")
            ])
          ].concat(extraBehaviours)),
          eventOrder: {
            click: ["button press", "alloy.base.behaviour"],
            mousedown: ["button press", "alloy.base.behaviour"]
          },
          ...action
        };
        const domFinal = deepMerge(common, { dom: dom2 });
        return deepMerge(domFinal, { components: components2 });
      };
      const renderIconButtonSpec = (spec, action, providersBackstage, extraBehaviours = [], btnName) => {
        const tooltipAttributes = spec.tooltip.map((tooltip) => ({
          "aria-label": providersBackstage.translate(tooltip)
        })).getOr({});
        const dom2 = {
          tag: "button",
          classes: [
            "tox-tbtn"
            /* ToolbarButtonClasses.Button */
          ],
          attributes: { ...tooltipAttributes, "data-mce-name": btnName }
        };
        const icon2 = spec.icon.map((iconName) => renderIconFromPack$1(iconName, providersBackstage.icons));
        const components2 = componentRenderPipeline([
          icon2
        ]);
        return renderCommonSpec(spec, action, extraBehaviours, dom2, components2, spec.tooltip, providersBackstage);
      };
      const calculateClassesFromButtonType = (buttonType) => {
        switch (buttonType) {
          case "primary":
            return ["tox-button"];
          case "toolbar":
            return ["tox-tbtn"];
          case "secondary":
          default:
            return ["tox-button", "tox-button--secondary"];
        }
      };
      const renderButtonSpec = (spec, action, providersBackstage, extraBehaviours = [], extraClasses = []) => {
        const translatedText = providersBackstage.translate(spec.text);
        const icon2 = spec.icon.map((iconName) => renderIconFromPack$1(iconName, providersBackstage.icons));
        const components2 = [icon2.getOrThunk(() => text$2(translatedText))];
        const buttonType = spec.buttonType.getOr(!spec.primary && !spec.borderless ? "secondary" : "primary");
        const baseClasses = calculateClassesFromButtonType(buttonType);
        const classes2 = [
          ...baseClasses,
          ...icon2.isSome() ? ["tox-button--icon"] : [],
          ...spec.borderless ? ["tox-button--naked"] : [],
          ...extraClasses
        ];
        const dom2 = {
          tag: "button",
          classes: classes2,
          attributes: {
            "aria-label": translatedText,
            "data-mce-name": spec.text
          }
        };
        const optTooltip = spec.icon.map(constant$1(translatedText));
        return renderCommonSpec(spec, action, extraBehaviours, dom2, components2, optTooltip, providersBackstage);
      };
      const renderButton$1 = (spec, action, providersBackstage, extraBehaviours = [], extraClasses = []) => {
        const buttonSpec = renderButtonSpec(spec, Optional.some(action), providersBackstage, extraBehaviours, extraClasses);
        return Button.sketch(buttonSpec);
      };
      const getAction = (name2, buttonType) => (comp) => {
        if (buttonType === "custom") {
          emitWith(comp, formActionEvent, {
            name: name2,
            value: {}
          });
        } else if (buttonType === "submit") {
          emit(comp, formSubmitEvent);
        } else if (buttonType === "cancel") {
          emit(comp, formCancelEvent);
        } else {
          console.error("Unknown button type: ", buttonType);
        }
      };
      const isMenuFooterButtonSpec = (spec, buttonType) => buttonType === "menu";
      const isNormalFooterButtonSpec = (spec, buttonType) => buttonType === "custom" || buttonType === "cancel" || buttonType === "submit";
      const isToggleButtonSpec = (spec, buttonType) => buttonType === "togglebutton";
      const renderToggleButton = (spec, providers, btnName) => {
        var _a, _b;
        const optMemIcon = spec.icon.map((memIcon) => renderReplaceableIconFromPack(memIcon, providers.icons)).map(record);
        const action = (comp) => {
          emitWith(comp, formActionEvent, {
            name: spec.name,
            value: {
              setIcon: (newIcon) => {
                optMemIcon.map((memIcon) => memIcon.getOpt(comp).each((displayIcon) => {
                  Replacing.set(displayIcon, [
                    renderReplaceableIconFromPack(newIcon, providers.icons)
                  ]);
                }));
              }
            }
          });
        };
        const buttonType = spec.buttonType.getOr(!spec.primary ? "secondary" : "primary");
        const buttonSpec = {
          ...spec,
          name: (_a = spec.name) !== null && _a !== void 0 ? _a : "",
          primary: buttonType === "primary",
          tooltip: spec.tooltip,
          enabled: (_b = spec.enabled) !== null && _b !== void 0 ? _b : false,
          borderless: false
        };
        const tooltipAttributes = buttonSpec.tooltip.or(spec.text).map((tooltip) => ({
          "aria-label": providers.translate(tooltip)
        })).getOr({});
        const buttonTypeClasses = calculateClassesFromButtonType(buttonType !== null && buttonType !== void 0 ? buttonType : "secondary");
        const showIconAndText = spec.icon.isSome() && spec.text.isSome();
        const dom2 = {
          tag: "button",
          classes: [
            ...buttonTypeClasses.concat(spec.icon.isSome() ? ["tox-button--icon"] : []),
            ...spec.active ? [
              "tox-button--enabled"
              /* ViewButtonClasses.Ticked */
            ] : [],
            ...showIconAndText ? ["tox-button--icon-and-text"] : []
          ],
          attributes: {
            ...tooltipAttributes,
            ...isNonNullable(btnName) ? { "data-mce-name": btnName } : {}
          }
        };
        const extraBehaviours = [];
        const translatedText = providers.translate(spec.text.getOr(""));
        const translatedTextComponed = text$2(translatedText);
        const iconComp = componentRenderPipeline([optMemIcon.map((memIcon) => memIcon.asSpec())]);
        const components2 = [
          ...iconComp,
          ...spec.text.isSome() ? [translatedTextComponed] : []
        ];
        const iconButtonSpec = renderCommonSpec(buttonSpec, Optional.some(action), extraBehaviours, dom2, components2, spec.tooltip, providers);
        return Button.sketch(iconButtonSpec);
      };
      const renderFooterButton = (spec, buttonType, backstage) => {
        if (isMenuFooterButtonSpec(spec, buttonType)) {
          const getButton = () => memButton;
          const menuButtonSpec = spec;
          const fixedSpec = {
            ...spec,
            buttonType: "default",
            type: "menubutton",
            // Currently, dialog-based menu buttons cannot be searchable.
            search: Optional.none(),
            onSetup: (api2) => {
              api2.setEnabled(spec.enabled);
              return noop;
            },
            fetch: getFetch(menuButtonSpec.items, getButton, backstage)
          };
          const memButton = record(renderMenuButton(fixedSpec, "tox-tbtn", backstage, Optional.none(), true, spec.text.or(spec.tooltip).getOrUndefined()));
          return memButton.asSpec();
        } else if (isNormalFooterButtonSpec(spec, buttonType)) {
          const action = getAction(spec.name, buttonType);
          const buttonSpec = {
            ...spec,
            context: buttonType === "cancel" ? "any" : spec.context,
            borderless: false
          };
          return renderButton$1(buttonSpec, action, backstage.shared.providers, []);
        } else if (isToggleButtonSpec(spec, buttonType)) {
          return renderToggleButton(spec, backstage.shared.providers, spec.text.or(spec.tooltip).getOrUndefined());
        } else {
          console.error("Unknown footer button type: ", buttonType);
          throw new Error("Unknown footer button type");
        }
      };
      const renderDialogButton = (spec, providersBackstage) => {
        const action = getAction(spec.name, "custom");
        return renderFormField(Optional.none(), FormField.parts.field({
          factory: Button,
          ...renderButtonSpec(spec, Optional.some(action), providersBackstage, [
            memory(""),
            ComposingConfigs.self()
          ])
        }));
      };
      const separator$1 = {
        type: "separator"
      };
      const toMenuItem = (target) => ({
        type: "menuitem",
        value: target.url,
        text: target.title,
        meta: {
          attach: target.attach
        },
        onAction: noop
      });
      const staticMenuItem = (title2, url2) => ({
        type: "menuitem",
        value: url2,
        text: title2,
        meta: {
          attach: void 0
        },
        onAction: noop
      });
      const toMenuItems = (targets) => map$2(targets, toMenuItem);
      const filterLinkTargets = (type2, targets) => filter$2(targets, (target) => target.type === type2);
      const filteredTargets = (type2, targets) => toMenuItems(filterLinkTargets(type2, targets));
      const headerTargets = (linkInfo) => filteredTargets("header", linkInfo.targets);
      const anchorTargets = (linkInfo) => filteredTargets("anchor", linkInfo.targets);
      const anchorTargetTop = (linkInfo) => Optional.from(linkInfo.anchorTop).map((url2) => staticMenuItem("<top>", url2)).toArray();
      const anchorTargetBottom = (linkInfo) => Optional.from(linkInfo.anchorBottom).map((url2) => staticMenuItem("<bottom>", url2)).toArray();
      const historyTargets = (history) => map$2(history, (url2) => staticMenuItem(url2, url2));
      const joinMenuLists = (items) => {
        return foldl(items, (a, b2) => {
          const bothEmpty = a.length === 0 || b2.length === 0;
          return bothEmpty ? a.concat(b2) : a.concat(separator$1, b2);
        }, []);
      };
      const filterByQuery = (term, menuItems) => {
        const lowerCaseTerm = term.toLowerCase();
        return filter$2(menuItems, (item2) => {
          var _a;
          const text2 = item2.meta !== void 0 && item2.meta.text !== void 0 ? item2.meta.text : item2.text;
          const value2 = (_a = item2.value) !== null && _a !== void 0 ? _a : "";
          return contains$1(text2.toLowerCase(), lowerCaseTerm) || contains$1(value2.toLowerCase(), lowerCaseTerm);
        });
      };
      const getItems = (fileType, input2, urlBackstage) => {
        var _a, _b;
        const urlInputValue = Representing.getValue(input2);
        const term = (_b = (_a = urlInputValue === null || urlInputValue === void 0 ? void 0 : urlInputValue.meta) === null || _a === void 0 ? void 0 : _a.text) !== null && _b !== void 0 ? _b : urlInputValue.value;
        const info = urlBackstage.getLinkInformation();
        return info.fold(() => [], (linkInfo) => {
          const history = filterByQuery(term, historyTargets(urlBackstage.getHistory(fileType)));
          return fileType === "file" ? joinMenuLists([
            history,
            filterByQuery(term, headerTargets(linkInfo)),
            filterByQuery(term, flatten([
              anchorTargetTop(linkInfo),
              anchorTargets(linkInfo),
              anchorTargetBottom(linkInfo)
            ]))
          ]) : history;
        });
      };
      const errorId = generate$6("aria-invalid");
      const renderUrlInput = (spec, backstage, urlBackstage, initialData) => {
        const providersBackstage = backstage.shared.providers;
        const updateHistory = (component) => {
          const urlEntry = Representing.getValue(component);
          urlBackstage.addToHistory(urlEntry.value, spec.filetype);
        };
        const typeaheadSpec = {
          ...initialData.map((initialData2) => ({ initialData: initialData2 })).getOr({}),
          dismissOnBlur: true,
          inputClasses: ["tox-textfield"],
          sandboxClasses: ["tox-dialog__popups"],
          inputAttributes: {
            "aria-errormessage": errorId,
            "type": "url"
          },
          minChars: 0,
          responseTime: 0,
          fetch: (input2) => {
            const items = getItems(spec.filetype, input2, urlBackstage);
            const tdata = build(items, ItemResponse$1.BUBBLE_TO_SANDBOX, backstage, {
              isHorizontalMenu: false,
              search: Optional.none()
            });
            return Future.pure(tdata);
          },
          getHotspot: (comp) => memUrlBox.getOpt(comp),
          onSetValue: (comp, _newValue) => {
            if (comp.hasConfigured(Invalidating)) {
              Invalidating.run(comp).get(noop);
            }
          },
          typeaheadBehaviours: derive$1([
            ...urlBackstage.getValidationHandler().map((handler) => Invalidating.config({
              getRoot: (comp) => parentElement(comp.element),
              invalidClass: "tox-control-wrap--status-invalid",
              notify: {
                onInvalid: (comp, err) => {
                  memInvalidIcon.getOpt(comp).each((invalidComp) => {
                    set$9(invalidComp.element, "title", providersBackstage.translate(err));
                  });
                }
              },
              validator: {
                validate: (input2) => {
                  const urlEntry = Representing.getValue(input2);
                  return FutureResult.nu((completer) => {
                    handler({ type: spec.filetype, url: urlEntry.value }, (validation) => {
                      if (validation.status === "invalid") {
                        const err = Result.error(validation.message);
                        completer(err);
                      } else {
                        const val = Result.value(validation.message);
                        completer(val);
                      }
                    });
                  });
                },
                validateOnLoad: false
              }
            })).toArray(),
            Disabling.config({
              disabled: () => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable
            }),
            Tabstopping.config({}),
            config(
              "urlinput-events",
              // We want to get fast feedback for the link dialog, but not sure about others
              [
                run$1(input(), (comp) => {
                  const currentValue2 = get$5(comp.element);
                  const trimmedValue = currentValue2.trim();
                  if (trimmedValue !== currentValue2) {
                    set$4(comp.element, trimmedValue);
                  }
                  if (spec.filetype === "file") {
                    emitWith(comp, formChangeEvent, { name: spec.name });
                  }
                }),
                run$1(change(), (comp) => {
                  emitWith(comp, formChangeEvent, { name: spec.name });
                  updateHistory(comp);
                }),
                run$1(postPaste(), (comp) => {
                  emitWith(comp, formChangeEvent, { name: spec.name });
                  updateHistory(comp);
                })
              ]
            )
          ]),
          eventOrder: {
            [input()]: ["streaming", "urlinput-events", "invalidating"]
          },
          model: {
            getDisplayText: (itemData) => itemData.value,
            selectsOver: false,
            populateFromBrowse: false
          },
          markers: {
            openClass: "tox-textfield--popup-open"
          },
          lazySink: backstage.shared.getSink,
          parts: {
            menu: part(false, 1, "normal")
          },
          onExecute: (_menu, component, _entry) => {
            emitWith(component, formSubmitEvent, {});
          },
          onItemExecute: (typeahead, _sandbox, _item, _value) => {
            updateHistory(typeahead);
            emitWith(typeahead, formChangeEvent, { name: spec.name });
          }
        };
        const pField = FormField.parts.field({
          ...typeaheadSpec,
          factory: Typeahead
        });
        const pLabel = spec.label.map((label2) => renderLabel$3(label2, providersBackstage));
        const makeIcon = (name2, errId, icon2 = name2, label2 = name2) => render$4(icon2, {
          tag: "div",
          classes: ["tox-icon", "tox-control-wrap__status-icon-" + name2],
          attributes: {
            "title": providersBackstage.translate(label2),
            "aria-live": "polite",
            ...errId.fold(() => ({}), (id) => ({ id }))
          }
        }, providersBackstage.icons);
        const memInvalidIcon = record(makeIcon("invalid", Optional.some(errorId), "warning"));
        const memStatus = record({
          dom: {
            tag: "div",
            classes: ["tox-control-wrap__status-icon-wrap"]
          },
          components: [
            // Include the 'valid' and 'unknown' icons here only if they are to be displayed
            memInvalidIcon.asSpec()
          ]
        });
        const optUrlPicker = urlBackstage.getUrlPicker(spec.filetype);
        const browseUrlEvent = generate$6("browser.url.event");
        const memUrlBox = record({
          dom: {
            tag: "div",
            classes: ["tox-control-wrap"]
          },
          components: [pField, memStatus.asSpec()],
          behaviours: derive$1([
            Disabling.config({
              disabled: () => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable
            })
          ])
        });
        const memUrlPickerButton = record(renderButton$1({
          context: spec.context,
          name: spec.name,
          icon: Optional.some("browse"),
          text: spec.picker_text.or(spec.label).getOr(""),
          enabled: spec.enabled,
          primary: false,
          buttonType: Optional.none(),
          borderless: true
        }, (component) => emit(component, browseUrlEvent), providersBackstage, [], ["tox-browse-url"]));
        const controlHWrapper = () => ({
          dom: {
            tag: "div",
            classes: ["tox-form__controls-h-stack"]
          },
          components: flatten([
            [memUrlBox.asSpec()],
            optUrlPicker.map(() => memUrlPickerButton.asSpec()).toArray()
          ])
        });
        const openUrlPicker = (comp) => {
          Composing.getCurrent(comp).each((field2) => {
            const componentData = Representing.getValue(field2);
            const urlData = {
              fieldname: spec.name,
              ...componentData
            };
            optUrlPicker.each((picker) => {
              picker(urlData).get((chosenData) => {
                Representing.setValue(field2, chosenData);
                emitWith(comp, formChangeEvent, { name: spec.name });
              });
            });
          });
        };
        return FormField.sketch({
          dom: renderFormFieldDom(),
          components: pLabel.toArray().concat([
            controlHWrapper()
          ]),
          fieldBehaviours: derive$1([
            Disabling.config({
              disabled: () => !spec.enabled || providersBackstage.checkUiComponentContext(spec.context).shouldDisable,
              onDisabled: (comp) => {
                FormField.getField(comp).each(Disabling.disable);
                memUrlPickerButton.getOpt(comp).each(Disabling.disable);
              },
              onEnabled: (comp) => {
                FormField.getField(comp).each(Disabling.enable);
                memUrlPickerButton.getOpt(comp).each(Disabling.enable);
              }
            }),
            toggleOnReceive(() => providersBackstage.checkUiComponentContext(spec.context)),
            config("url-input-events", [
              run$1(browseUrlEvent, openUrlPicker)
            ])
          ])
        });
      };
      const renderAlertBanner = (spec, providersBackstage) => {
        const icon2 = get(spec.icon, providersBackstage.icons);
        return Container.sketch({
          dom: {
            tag: "div",
            attributes: {
              role: "alert"
            },
            classes: ["tox-notification", "tox-notification--in", `tox-notification--${spec.level}`]
          },
          components: [
            {
              dom: {
                tag: "div",
                classes: ["tox-notification__icon"],
                innerHtml: !spec.url ? icon2 : void 0
              },
              components: spec.url ? [
                Button.sketch({
                  dom: {
                    tag: "button",
                    classes: ["tox-button", "tox-button--naked", "tox-button--icon"],
                    innerHtml: icon2,
                    attributes: {
                      title: providersBackstage.translate(spec.iconTooltip)
                    }
                  },
                  // TODO: aria label this button!
                  action: (comp) => emitWith(comp, formActionEvent, { name: "alert-banner", value: spec.url }),
                  buttonBehaviours: derive$1([
                    addFocusableBehaviour()
                  ])
                })
              ] : void 0
            },
            {
              dom: {
                tag: "div",
                classes: ["tox-notification__body"],
                // TODO: AP-247: Escape this text so that it can't contain script tags
                innerHtml: providersBackstage.translate(spec.text)
              }
            }
          ]
        });
      };
      const renderCheckbox = (spec, providerBackstage, initialData) => {
        const toggleCheckboxHandler = (comp) => {
          comp.element.dom.click();
          return Optional.some(true);
        };
        const pField = FormField.parts.field({
          factory: { sketch: identity },
          dom: {
            tag: "input",
            classes: ["tox-checkbox__input"],
            attributes: {
              type: "checkbox"
            }
          },
          behaviours: derive$1([
            ComposingConfigs.self(),
            Disabling.config({
              disabled: () => !spec.enabled || providerBackstage.checkUiComponentContext(spec.context).shouldDisable,
              onDisabled: (component) => {
                parentElement(component.element).each((element2) => add$2(element2, "tox-checkbox--disabled"));
              },
              onEnabled: (component) => {
                parentElement(component.element).each((element2) => remove$3(element2, "tox-checkbox--disabled"));
              }
            }),
            Tabstopping.config({}),
            Focusing.config({}),
            withElement(initialData, get$9, set$5),
            Keying.config({
              mode: "special",
              onEnter: toggleCheckboxHandler,
              onSpace: toggleCheckboxHandler,
              stopSpaceKeyup: true
            }),
            config("checkbox-events", [
              run$1(change(), (component, _) => {
                emitWith(component, formChangeEvent, { name: spec.name });
              })
            ])
          ])
        });
        const pLabel = FormField.parts.label({
          dom: {
            tag: "span",
            classes: ["tox-checkbox__label"]
          },
          components: [
            text$2(providerBackstage.translate(spec.label))
          ],
          behaviours: derive$1([
            Unselecting.config({})
          ])
        });
        const makeIcon = (className) => {
          const iconName = className === "checked" ? "selected" : "unselected";
          return render$4(iconName, { tag: "span", classes: ["tox-icon", "tox-checkbox-icon__" + className] }, providerBackstage.icons);
        };
        const memIcons = record({
          dom: {
            tag: "div",
            classes: ["tox-checkbox__icons"]
          },
          components: [
            makeIcon("checked"),
            makeIcon("unchecked")
          ]
        });
        return FormField.sketch({
          dom: {
            tag: "label",
            classes: ["tox-checkbox"]
          },
          components: [
            pField,
            memIcons.asSpec(),
            pLabel
          ],
          fieldBehaviours: derive$1([
            Disabling.config({
              disabled: () => !spec.enabled || providerBackstage.checkUiComponentContext(spec.context).shouldDisable
            }),
            toggleOnReceive(() => providerBackstage.checkUiComponentContext(spec.context))
          ])
        });
      };
      const renderHtmlPanel = (spec, providersBackstage) => {
        const classes2 = ["tox-form__group", ...spec.stretched ? ["tox-form__group--stretched"] : []];
        const init2 = config("htmlpanel", [
          runOnAttached((comp) => {
            spec.onInit(comp.element.dom);
          })
        ]);
        if (spec.presets === "presentation") {
          return Container.sketch({
            dom: {
              tag: "div",
              classes: classes2,
              innerHtml: spec.html
            },
            containerBehaviours: derive$1([
              Tooltipping.config({
                ...providersBackstage.tooltips.getConfig({
                  tooltipText: "",
                  onShow: (comp) => {
                    descendant(comp.element, "[data-mce-tooltip]:hover").orThunk(() => search(comp.element)).each((current) => {
                      getOpt(current, "data-mce-tooltip").each((text2) => {
                        Tooltipping.setComponents(comp, providersBackstage.tooltips.getComponents({ tooltipText: text2 }));
                      });
                    });
                  }
                }),
                mode: "children-normal",
                anchor: (comp) => ({
                  type: "node",
                  node: descendant(comp.element, "[data-mce-tooltip]:hover").orThunk(() => search(comp.element).filter((current) => getOpt(current, "data-mce-tooltip").isSome())),
                  root: comp.element,
                  layouts: {
                    onLtr: constant$1([south$2, north$2, southeast$2, northeast$2, southwest$2, northwest$2]),
                    onRtl: constant$1([south$2, north$2, southeast$2, northeast$2, southwest$2, northwest$2])
                  },
                  bubble: nu$6(0, -2, {})
                })
              }),
              init2
            ])
          });
        } else {
          return Container.sketch({
            dom: {
              tag: "div",
              classes: classes2,
              innerHtml: spec.html,
              attributes: {
                role: "document"
              }
            },
            containerBehaviours: derive$1([
              Tabstopping.config({}),
              Focusing.config({}),
              init2
            ])
          });
        }
      };
      const make$1 = (render2) => {
        return (parts2, spec, dialogData, backstage, getCompByName2) => get$h(spec, "name").fold(() => render2(spec, backstage, Optional.none(), getCompByName2), (fieldName) => parts2.field(fieldName, render2(spec, backstage, get$h(dialogData, fieldName), getCompByName2)));
      };
      const makeIframe = (render2) => (parts2, spec, dialogData, backstage, getCompByName2) => {
        const iframeSpec = deepMerge(spec, {
          source: "dynamic"
        });
        return make$1(render2)(parts2, iframeSpec, dialogData, backstage, getCompByName2);
      };
      const factories = {
        bar: make$1((spec, backstage) => renderBar(spec, backstage.shared)),
        collection: make$1((spec, backstage, data) => renderCollection(spec, backstage.shared.providers, data)),
        alertbanner: make$1((spec, backstage) => renderAlertBanner(spec, backstage.shared.providers)),
        input: make$1((spec, backstage, data) => renderInput(spec, backstage.shared.providers, data)),
        textarea: make$1((spec, backstage, data) => renderTextarea(spec, backstage.shared.providers, data)),
        label: make$1((spec, backstage, _data, getCompByName2) => renderLabel$2(spec, backstage.shared, getCompByName2)),
        iframe: makeIframe((spec, backstage, data) => renderIFrame(spec, backstage.shared.providers, data)),
        button: make$1((spec, backstage) => renderDialogButton(spec, backstage.shared.providers)),
        checkbox: make$1((spec, backstage, data) => renderCheckbox(spec, backstage.shared.providers, data)),
        colorinput: make$1((spec, backstage, data) => renderColorInput(spec, backstage.shared, backstage.colorinput, data)),
        colorpicker: make$1((spec, backstage, data) => renderColorPicker(spec, backstage.shared.providers, data)),
        // Not sure if this needs name.
        dropzone: make$1((spec, backstage, data) => renderDropZone(spec, backstage.shared.providers, data)),
        grid: make$1((spec, backstage) => renderGrid(spec, backstage.shared)),
        listbox: make$1((spec, backstage, data) => renderListBox(spec, backstage, data)),
        selectbox: make$1((spec, backstage, data) => renderSelectBox(spec, backstage.shared.providers, data)),
        sizeinput: make$1((spec, backstage) => renderSizeInput(spec, backstage.shared.providers)),
        slider: make$1((spec, backstage, data) => renderSlider(spec, backstage.shared.providers, data)),
        urlinput: make$1((spec, backstage, data) => renderUrlInput(spec, backstage, backstage.urlinput, data)),
        customeditor: make$1(renderCustomEditor),
        htmlpanel: make$1((spec, backstage) => renderHtmlPanel(spec, backstage.shared.providers)),
        imagepreview: make$1((spec, _, data) => renderImagePreview(spec, data)),
        table: make$1((spec, backstage) => renderTable(spec, backstage.shared.providers)),
        tree: make$1((spec, backstage) => renderTree(spec, backstage)),
        panel: make$1((spec, backstage) => renderPanel(spec, backstage))
      };
      const noFormParts = {
        // This is cast as we only actually want an alloy spec and don't need the actual part here
        field: (_name, spec) => spec,
        record: constant$1([])
      };
      const interpretInForm = (parts2, spec, dialogData, oldBackstage, getCompByName2) => {
        const newBackstage = deepMerge(oldBackstage, {
          // Add the interpreter based on the form parts.
          shared: {
            interpreter: (childSpec) => interpretParts(parts2, childSpec, dialogData, newBackstage, getCompByName2)
          }
        });
        return interpretParts(parts2, spec, dialogData, newBackstage, getCompByName2);
      };
      const interpretParts = (parts2, spec, dialogData, backstage, getCompByName2) => get$h(factories, spec.type).fold(() => {
        console.error(`Unknown factory type "${spec.type}", defaulting to container: `, spec);
        return spec;
      }, (factory2) => factory2(parts2, spec, dialogData, backstage, getCompByName2));
      const interpretWithoutForm = (spec, dialogData, backstage, getCompByName2) => interpretParts(noFormParts, spec, dialogData, backstage, getCompByName2);
      const bubbleAlignments$2 = {
        valignCentre: [],
        alignCentre: [],
        alignLeft: [],
        alignRight: [],
        right: [],
        left: [],
        bottom: [],
        top: []
      };
      const getInlineDialogAnchor = (contentAreaElement, lazyAnchorbar, lazyUseEditableAreaAnchor) => {
        const bubbleSize2 = 12;
        const overrides = {
          maxHeightFunction: expandable$1()
        };
        const editableAreaAnchor = () => ({
          type: "node",
          root: getContentContainer(getRootNode(contentAreaElement())),
          node: Optional.from(contentAreaElement()),
          bubble: nu$6(bubbleSize2, bubbleSize2, bubbleAlignments$2),
          layouts: {
            onRtl: () => [northeast$1],
            onLtr: () => [northwest$1]
          },
          overrides
        });
        const standardAnchor = () => ({
          type: "hotspot",
          hotspot: lazyAnchorbar(),
          bubble: nu$6(-bubbleSize2, bubbleSize2, bubbleAlignments$2),
          layouts: {
            onRtl: () => [southeast$2, southwest$2, south$2],
            onLtr: () => [southwest$2, southeast$2, south$2]
          },
          overrides
        });
        return () => lazyUseEditableAreaAnchor() ? editableAreaAnchor() : standardAnchor();
      };
      const getInlineBottomDialogAnchor = (inline2, contentAreaElement, lazyBottomAnchorBar, lazyUseEditableAreaAnchor) => {
        const bubbleSize2 = 12;
        const overrides = {
          maxHeightFunction: expandable$1()
        };
        const editableAreaAnchor = () => ({
          type: "node",
          root: getContentContainer(getRootNode(contentAreaElement())),
          node: Optional.from(contentAreaElement()),
          bubble: nu$6(bubbleSize2, bubbleSize2, bubbleAlignments$2),
          layouts: {
            onRtl: () => [north$1],
            onLtr: () => [north$1]
          },
          overrides
        });
        const standardAnchor = () => inline2 ? {
          type: "node",
          root: getContentContainer(getRootNode(contentAreaElement())),
          node: Optional.from(contentAreaElement()),
          bubble: nu$6(0, -getOuter$1(contentAreaElement()), bubbleAlignments$2),
          layouts: {
            onRtl: () => [north$2],
            onLtr: () => [north$2]
          },
          overrides
        } : {
          type: "hotspot",
          hotspot: lazyBottomAnchorBar(),
          bubble: nu$6(0, 0, bubbleAlignments$2),
          layouts: {
            onRtl: () => [north$2],
            onLtr: () => [north$2]
          },
          overrides
        };
        return () => lazyUseEditableAreaAnchor() ? editableAreaAnchor() : standardAnchor();
      };
      const getBannerAnchor = (contentAreaElement, lazyAnchorbar, lazyUseEditableAreaAnchor) => {
        const editableAreaAnchor = () => ({
          type: "node",
          root: getContentContainer(getRootNode(contentAreaElement())),
          node: Optional.from(contentAreaElement()),
          layouts: {
            onRtl: () => [north$1],
            onLtr: () => [north$1]
          }
        });
        const standardAnchor = () => ({
          type: "hotspot",
          hotspot: lazyAnchorbar(),
          layouts: {
            onRtl: () => [south$2],
            onLtr: () => [south$2]
          }
        });
        return () => lazyUseEditableAreaAnchor() ? editableAreaAnchor() : standardAnchor();
      };
      const getCursorAnchor = (editor, bodyElement) => () => ({
        type: "selection",
        root: bodyElement(),
        getSelection: () => {
          const rng = editor.selection.getRng();
          const selectedCells = editor.model.table.getSelectedCells();
          if (selectedCells.length > 1) {
            const firstCell = selectedCells[0];
            const lastCell = selectedCells[selectedCells.length - 1];
            const selectionTableCellRange = {
              firstCell: SugarElement.fromDom(firstCell),
              lastCell: SugarElement.fromDom(lastCell)
            };
            return Optional.some(selectionTableCellRange);
          }
          return Optional.some(SimSelection.range(SugarElement.fromDom(rng.startContainer), rng.startOffset, SugarElement.fromDom(rng.endContainer), rng.endOffset));
        }
      });
      const getNodeAnchor$1 = (bodyElement) => (element2) => ({
        type: "node",
        root: bodyElement(),
        node: element2
      });
      const getAnchors = (editor, lazyAnchorbar, lazyBottomAnchorBar, isToolbarTop) => {
        const useFixedToolbarContainer = useFixedContainer(editor);
        const bodyElement = () => SugarElement.fromDom(editor.getBody());
        const contentAreaElement = () => SugarElement.fromDom(editor.getContentAreaContainer());
        const lazyUseEditableAreaAnchor = () => useFixedToolbarContainer || !isToolbarTop();
        return {
          inlineDialog: getInlineDialogAnchor(contentAreaElement, lazyAnchorbar, lazyUseEditableAreaAnchor),
          inlineBottomDialog: getInlineBottomDialogAnchor(editor.inline, contentAreaElement, lazyBottomAnchorBar, lazyUseEditableAreaAnchor),
          banner: getBannerAnchor(contentAreaElement, lazyAnchorbar, lazyUseEditableAreaAnchor),
          cursor: getCursorAnchor(editor, bodyElement),
          node: getNodeAnchor$1(bodyElement)
        };
      };
      const colorPicker = (editor) => (callback, value2) => {
        const dialog = colorPickerDialog(editor);
        dialog(callback, value2);
      };
      const hasCustomColors = (editor) => () => hasCustomColors$1(editor);
      const getColors = (editor) => (id) => getColors$2(editor, id);
      const getColorCols = (editor) => (id) => getColorCols$1(editor, id);
      const ColorInputBackstage = (editor) => ({
        colorPicker: colorPicker(editor),
        hasCustomColors: hasCustomColors(editor),
        getColors: getColors(editor),
        getColorCols: getColorCols(editor)
      });
      const isDraggableModal = (editor) => () => isDraggableModal$1(editor);
      const DialogBackstage = (editor) => ({
        isDraggableModal: isDraggableModal(editor)
      });
      const HeaderBackstage = (editor) => {
        const mode = Cell(isToolbarLocationBottom(editor) ? "bottom" : "top");
        return {
          isPositionedAtTop: () => mode.get() === "top",
          getDockingMode: mode.get,
          setDockingMode: mode.set
        };
      };
      const isNestedFormat = (format) => hasNonNullableKey(format, "items");
      const isFormatReference = (format) => hasNonNullableKey(format, "format");
      const defaultStyleFormats = [
        {
          title: "Headings",
          items: [
            { title: "Heading 1", format: "h1" },
            { title: "Heading 2", format: "h2" },
            { title: "Heading 3", format: "h3" },
            { title: "Heading 4", format: "h4" },
            { title: "Heading 5", format: "h5" },
            { title: "Heading 6", format: "h6" }
          ]
        },
        {
          title: "Inline",
          items: [
            { title: "Bold", format: "bold" },
            { title: "Italic", format: "italic" },
            { title: "Underline", format: "underline" },
            { title: "Strikethrough", format: "strikethrough" },
            { title: "Superscript", format: "superscript" },
            { title: "Subscript", format: "subscript" },
            { title: "Code", format: "code" }
          ]
        },
        {
          title: "Blocks",
          items: [
            { title: "Paragraph", format: "p" },
            { title: "Blockquote", format: "blockquote" },
            { title: "Div", format: "div" },
            { title: "Pre", format: "pre" }
          ]
        },
        {
          title: "Align",
          items: [
            { title: "Left", format: "alignleft" },
            { title: "Center", format: "aligncenter" },
            { title: "Right", format: "alignright" },
            { title: "Justify", format: "alignjustify" }
          ]
        }
      ];
      const isNestedFormats = (format) => has$2(format, "items");
      const isBlockFormat = (format) => has$2(format, "block");
      const isInlineFormat = (format) => has$2(format, "inline");
      const isSelectorFormat = (format) => has$2(format, "selector");
      const mapFormats = (userFormats) => foldl(userFormats, (acc, fmt) => {
        if (isNestedFormats(fmt)) {
          const result = mapFormats(fmt.items);
          return {
            customFormats: acc.customFormats.concat(result.customFormats),
            formats: acc.formats.concat([{ title: fmt.title, items: result.formats }])
          };
        } else if (isInlineFormat(fmt) || isBlockFormat(fmt) || isSelectorFormat(fmt)) {
          const formatName = isString(fmt.name) ? fmt.name : fmt.title.toLowerCase();
          const formatNameWithPrefix = `custom-${formatName}`;
          return {
            customFormats: acc.customFormats.concat([{ name: formatNameWithPrefix, format: fmt }]),
            formats: acc.formats.concat([{ title: fmt.title, format: formatNameWithPrefix, icon: fmt.icon }])
          };
        } else {
          return { ...acc, formats: acc.formats.concat(fmt) };
        }
      }, { customFormats: [], formats: [] });
      const registerCustomFormats = (editor, userFormats) => {
        const result = mapFormats(userFormats);
        const registerFormats = (customFormats) => {
          each$1(customFormats, (fmt) => {
            if (!editor.formatter.has(fmt.name)) {
              editor.formatter.register(fmt.name, fmt.format);
            }
          });
        };
        if (editor.formatter) {
          registerFormats(result.customFormats);
        } else {
          editor.on("init", () => {
            registerFormats(result.customFormats);
          });
        }
        return result.formats;
      };
      const getStyleFormats = (editor) => getUserStyleFormats(editor).map((userFormats) => {
        const registeredUserFormats = registerCustomFormats(editor, userFormats);
        return shouldMergeStyleFormats(editor) ? defaultStyleFormats.concat(registeredUserFormats) : registeredUserFormats;
      }).getOr(defaultStyleFormats);
      const isSeparator$1 = (format) => {
        const keys$1 = keys(format);
        return keys$1.length === 1 && contains$2(keys$1, "title");
      };
      const processBasic = (item2, isSelectedFor, getPreviewFor) => ({
        ...item2,
        type: "formatter",
        isSelected: isSelectedFor(item2.format),
        getStylePreview: getPreviewFor(item2.format)
      });
      const register$b = (editor, formats, isSelectedFor, getPreviewFor) => {
        const enrichSupported = (item2) => processBasic(item2, isSelectedFor, getPreviewFor);
        const enrichMenu = (item2) => {
          const newItems = doEnrich(item2.items);
          return {
            ...item2,
            type: "submenu",
            getStyleItems: constant$1(newItems)
          };
        };
        const enrichCustom = (item2) => {
          const formatName = isString(item2.name) ? item2.name : generate$6(item2.title);
          const formatNameWithPrefix = `custom-${formatName}`;
          const newItem = {
            ...item2,
            type: "formatter",
            format: formatNameWithPrefix,
            isSelected: isSelectedFor(formatNameWithPrefix),
            getStylePreview: getPreviewFor(formatNameWithPrefix)
          };
          editor.formatter.register(formatName, newItem);
          return newItem;
        };
        const doEnrich = (items) => map$2(items, (item2) => {
          if (isNestedFormat(item2)) {
            return enrichMenu(item2);
          } else if (isFormatReference(item2)) {
            return enrichSupported(item2);
          } else if (isSeparator$1(item2)) {
            return { ...item2, type: "separator" };
          } else {
            return enrichCustom(item2);
          }
        });
        return doEnrich(formats);
      };
      const init$1 = (editor) => {
        const isSelectedFor = (format) => () => editor.formatter.match(format);
        const getPreviewFor = (format) => () => {
          const fmt = editor.formatter.get(format);
          return fmt !== void 0 ? Optional.some({
            tag: fmt.length > 0 ? fmt[0].inline || fmt[0].block || "div" : "div",
            styles: editor.dom.parseStyle(editor.formatter.getCssText(format))
          }) : Optional.none();
        };
        const settingsFormats = Cell([]);
        const eventsFormats = Cell([]);
        const replaceSettings = Cell(false);
        editor.on("PreInit", (_e) => {
          const formats = getStyleFormats(editor);
          const enriched = register$b(editor, formats, isSelectedFor, getPreviewFor);
          settingsFormats.set(enriched);
        });
        editor.on("addStyleModifications", (e) => {
          const modifications = register$b(editor, e.items, isSelectedFor, getPreviewFor);
          eventsFormats.set(modifications);
          replaceSettings.set(e.replace);
        });
        const getData2 = () => {
          const fromSettings = replaceSettings.get() ? [] : settingsFormats.get();
          const fromEvents = eventsFormats.get();
          return fromSettings.concat(fromEvents);
        };
        return {
          getData: getData2
        };
      };
      const TooltipsBackstage = (getSink2) => {
        const tooltipDelay = 300;
        const intervalDelay = tooltipDelay * 0.2;
        let numActiveTooltips = 0;
        const alreadyShowingTooltips = () => numActiveTooltips > 0;
        const getComponents = (spec) => {
          return [
            {
              dom: {
                tag: "div",
                classes: ["tox-tooltip__body"]
              },
              components: [
                text$2(spec.tooltipText)
              ]
            }
          ];
        };
        const getConfig = (spec) => {
          return {
            delayForShow: () => alreadyShowingTooltips() ? intervalDelay : tooltipDelay,
            delayForHide: constant$1(tooltipDelay),
            exclusive: true,
            lazySink: getSink2,
            tooltipDom: {
              tag: "div",
              classes: ["tox-tooltip", "tox-tooltip--up"]
            },
            tooltipComponents: getComponents(spec),
            onShow: (comp, tooltip) => {
              numActiveTooltips++;
              if (spec.onShow) {
                spec.onShow(comp, tooltip);
              }
            },
            onHide: (comp, tooltip) => {
              numActiveTooltips--;
              if (spec.onHide) {
                spec.onHide(comp, tooltip);
              }
            },
            onSetup: spec.onSetup
          };
        };
        return {
          getConfig,
          getComponents
        };
      };
      const isElement = (node) => isNonNullable(node) && node.nodeType === 1;
      const trim = global$2.trim;
      const hasContentEditableState = (value2) => {
        return (node) => {
          if (isElement(node)) {
            if (node.contentEditable === value2) {
              return true;
            }
            if (node.getAttribute("data-mce-contenteditable") === value2) {
              return true;
            }
          }
          return false;
        };
      };
      const isContentEditableTrue = hasContentEditableState("true");
      const isContentEditableFalse = hasContentEditableState("false");
      const create = (type2, title2, url2, level, attach2) => ({
        type: type2,
        title: title2,
        url: url2,
        level,
        attach: attach2
      });
      const isChildOfContentEditableTrue = (node) => {
        let tempNode = node;
        while (tempNode = tempNode.parentNode) {
          const value2 = tempNode.contentEditable;
          if (value2 && value2 !== "inherit") {
            return isContentEditableTrue(tempNode);
          }
        }
        return false;
      };
      const select = (selector, root) => {
        return map$2(descendants(SugarElement.fromDom(root), selector), (element2) => {
          return element2.dom;
        });
      };
      const getElementText = (elm) => {
        return elm.innerText || elm.textContent;
      };
      const getOrGenerateId = (elm) => {
        return elm.id ? elm.id : generate$6("h");
      };
      const isAnchor = (elm) => {
        return elm && elm.nodeName === "A" && (elm.id || elm.name) !== void 0;
      };
      const isValidAnchor = (elm) => {
        return isAnchor(elm) && isEditable(elm);
      };
      const isHeader = (elm) => {
        return elm && /^(H[1-6])$/.test(elm.nodeName);
      };
      const isEditable = (elm) => {
        return isChildOfContentEditableTrue(elm) && !isContentEditableFalse(elm);
      };
      const isValidHeader = (elm) => {
        return isHeader(elm) && isEditable(elm);
      };
      const getLevel = (elm) => {
        return isHeader(elm) ? parseInt(elm.nodeName.substr(1), 10) : 0;
      };
      const headerTarget = (elm) => {
        var _a;
        const headerId = getOrGenerateId(elm);
        const attach2 = () => {
          elm.id = headerId;
        };
        return create("header", (_a = getElementText(elm)) !== null && _a !== void 0 ? _a : "", "#" + headerId, getLevel(elm), attach2);
      };
      const anchorTarget = (elm) => {
        const anchorId = elm.id || elm.name;
        const anchorText = getElementText(elm);
        return create("anchor", anchorText ? anchorText : "#" + anchorId, "#" + anchorId, 0, noop);
      };
      const getHeaderTargets = (elms) => {
        return map$2(filter$2(elms, isValidHeader), headerTarget);
      };
      const getAnchorTargets = (elms) => {
        return map$2(filter$2(elms, isValidAnchor), anchorTarget);
      };
      const getTargetElements = (elm) => {
        const elms = select("h1,h2,h3,h4,h5,h6,a:not([href])", elm);
        return elms;
      };
      const hasTitle = (target) => {
        return trim(target.title).length > 0;
      };
      const find = (elm) => {
        const elms = getTargetElements(elm);
        return filter$2(getHeaderTargets(elms).concat(getAnchorTargets(elms)), hasTitle);
      };
      const LinkTargets = {
        find
      };
      const STORAGE_KEY = "tinymce-url-history";
      const HISTORY_LENGTH = 5;
      const isHttpUrl = (url2) => isString(url2) && /^https?/.test(url2);
      const isArrayOfUrl = (a) => isArray(a) && a.length <= HISTORY_LENGTH && forall(a, isHttpUrl);
      const isRecordOfUrlArray = (r2) => isObject(r2) && find$4(r2, (value2) => !isArrayOfUrl(value2)).isNone();
      const getAllHistory = () => {
        const unparsedHistory = global$5.getItem(STORAGE_KEY);
        if (unparsedHistory === null) {
          return {};
        }
        let history;
        try {
          history = JSON.parse(unparsedHistory);
        } catch (e) {
          if (e instanceof SyntaxError) {
            console.log("Local storage " + STORAGE_KEY + " was not valid JSON", e);
            return {};
          }
          throw e;
        }
        if (!isRecordOfUrlArray(history)) {
          console.log("Local storage " + STORAGE_KEY + " was not valid format", history);
          return {};
        }
        return history;
      };
      const setAllHistory = (history) => {
        if (!isRecordOfUrlArray(history)) {
          throw new Error("Bad format for history:\n" + JSON.stringify(history));
        }
        global$5.setItem(STORAGE_KEY, JSON.stringify(history));
      };
      const getHistory = (fileType) => {
        const history = getAllHistory();
        return get$h(history, fileType).getOr([]);
      };
      const addToHistory = (url2, fileType) => {
        if (!isHttpUrl(url2)) {
          return;
        }
        const history = getAllHistory();
        const items = get$h(history, fileType).getOr([]);
        const itemsWithoutUrl = filter$2(items, (item2) => item2 !== url2);
        history[fileType] = [url2].concat(itemsWithoutUrl).slice(0, HISTORY_LENGTH);
        setAllHistory(history);
      };
      const isTruthy = (value2) => !!value2;
      const makeMap = (value2) => map$1(global$2.makeMap(value2, /[, ]/), isTruthy);
      const getPicker = (editor) => Optional.from(getFilePickerCallback(editor));
      const getPickerTypes = (editor) => {
        const optFileTypes = Optional.from(getFilePickerTypes(editor)).filter(isTruthy).map(makeMap);
        return getPicker(editor).fold(never, (_picker) => optFileTypes.fold(always, (types2) => keys(types2).length > 0 ? types2 : false));
      };
      const getPickerSetting = (editor, filetype) => {
        const pickerTypes = getPickerTypes(editor);
        if (isBoolean(pickerTypes)) {
          return pickerTypes ? getPicker(editor) : Optional.none();
        } else {
          return pickerTypes[filetype] ? getPicker(editor) : Optional.none();
        }
      };
      const getUrlPicker = (editor, filetype) => getPickerSetting(editor, filetype).map((picker) => (entry) => Future.nu((completer) => {
        const handler = (value2, meta2) => {
          if (!isString(value2)) {
            throw new Error("Expected value to be string");
          }
          if (meta2 !== void 0 && !isObject(meta2)) {
            throw new Error("Expected meta to be a object");
          }
          const r2 = { value: value2, meta: meta2 };
          completer(r2);
        };
        const meta = {
          filetype,
          fieldname: entry.fieldname,
          ...Optional.from(entry.meta).getOr({})
        };
        picker.call(editor, handler, entry.value, meta);
      }));
      const getTextSetting = (value2) => Optional.from(value2).filter(isString).getOrUndefined();
      const getLinkInformation = (editor) => {
        if (!useTypeaheadUrls(editor)) {
          return Optional.none();
        }
        return Optional.some({
          targets: LinkTargets.find(editor.getBody()),
          anchorTop: getTextSetting(getAnchorTop(editor)),
          anchorBottom: getTextSetting(getAnchorBottom(editor))
        });
      };
      const getValidationHandler = (editor) => Optional.from(getFilePickerValidatorHandler(editor));
      const UrlInputBackstage = (editor) => ({
        getHistory,
        addToHistory,
        getLinkInformation: () => getLinkInformation(editor),
        getValidationHandler: () => getValidationHandler(editor),
        getUrlPicker: (filetype) => getUrlPicker(editor, filetype)
      });
      const init = (lazySinks, editor, lazyAnchorbar, lazyBottomAnchorBar) => {
        const contextMenuState = Cell(false);
        const toolbar = HeaderBackstage(editor);
        const providers = {
          icons: () => editor.ui.registry.getAll().icons,
          menuItems: () => editor.ui.registry.getAll().menuItems,
          translate: global$6.translate,
          isDisabled: () => !editor.ui.isEnabled(),
          getOption: editor.options.get,
          tooltips: TooltipsBackstage(lazySinks.dialog),
          checkUiComponentContext: (specContext) => {
            if (isDisabled(editor)) {
              return {
                contextType: "disabled",
                shouldDisable: true
              };
            }
            const [key, value2 = ""] = specContext.split(":");
            const contexts = editor.ui.registry.getAll().contexts;
            const enabledInContext = get$h(contexts, key).fold(
              // Fallback to 'mode:design' if key is not found
              () => get$h(contexts, "mode").map((pred) => pred("design")).getOr(false),
              (pred) => value2.charAt(0) === "!" ? !pred(value2.slice(1)) : pred(value2)
            );
            return {
              contextType: key,
              shouldDisable: !enabledInContext
            };
          }
        };
        const urlinput = UrlInputBackstage(editor);
        const styles = init$1(editor);
        const colorinput = ColorInputBackstage(editor);
        const dialogSettings = DialogBackstage(editor);
        const isContextMenuOpen = () => contextMenuState.get();
        const setContextMenuState = (state) => contextMenuState.set(state);
        const commonBackstage = {
          shared: {
            providers,
            anchors: getAnchors(editor, lazyAnchorbar, lazyBottomAnchorBar, toolbar.isPositionedAtTop),
            header: toolbar
          },
          urlinput,
          styles,
          colorinput,
          dialog: dialogSettings,
          isContextMenuOpen,
          setContextMenuState
        };
        const getCompByName2 = (_name) => Optional.none();
        const popupBackstage = {
          ...commonBackstage,
          shared: {
            ...commonBackstage.shared,
            interpreter: (s) => interpretWithoutForm(s, {}, popupBackstage, getCompByName2),
            getSink: lazySinks.popup
          }
        };
        const dialogBackstage = {
          ...commonBackstage,
          shared: {
            ...commonBackstage.shared,
            interpreter: (s) => interpretWithoutForm(s, {}, dialogBackstage, getCompByName2),
            getSink: lazySinks.dialog
          }
        };
        return {
          popup: popupBackstage,
          dialog: dialogBackstage
        };
      };
      const setup$b = (editor, mothership, uiMotherships) => {
        const broadcastEvent = (name2, evt) => {
          each$1([mothership, ...uiMotherships], (m) => {
            m.broadcastEvent(name2, evt);
          });
        };
        const broadcastOn = (channel, message) => {
          each$1([mothership, ...uiMotherships], (m) => {
            m.broadcastOn([channel], message);
          });
        };
        const fireDismissPopups = (evt) => broadcastOn(dismissPopups(), { target: evt.target });
        const doc = getDocument();
        const onTouchstart = bind$1(doc, "touchstart", fireDismissPopups);
        const onTouchmove = bind$1(doc, "touchmove", (evt) => broadcastEvent(documentTouchmove(), evt));
        const onTouchend = bind$1(doc, "touchend", (evt) => broadcastEvent(documentTouchend(), evt));
        const onMousedown = bind$1(doc, "mousedown", fireDismissPopups);
        const onMouseup = bind$1(doc, "mouseup", (evt) => {
          if (evt.raw.button === 0) {
            broadcastOn(mouseReleased(), { target: evt.target });
          }
        });
        const onContentClick = (raw) => broadcastOn(dismissPopups(), { target: SugarElement.fromDom(raw.target) });
        const onContentMouseup = (raw) => {
          if (raw.button === 0) {
            broadcastOn(mouseReleased(), { target: SugarElement.fromDom(raw.target) });
          }
        };
        const onContentMousedown = () => {
          each$1(editor.editorManager.get(), (loopEditor) => {
            if (editor !== loopEditor) {
              loopEditor.dispatch("DismissPopups", { relatedTarget: editor });
            }
          });
        };
        const onWindowScroll = (evt) => broadcastEvent(windowScroll(), fromRawEvent(evt));
        const onWindowResize = (evt) => {
          broadcastOn(repositionPopups(), {});
          broadcastEvent(windowResize(), fromRawEvent(evt));
        };
        const dos = getRootNode(SugarElement.fromDom(editor.getElement()));
        const onElementScroll = capture(dos, "scroll", (evt) => {
          requestAnimationFrame(() => {
            const c = editor.getContainer();
            if (c !== void 0 && c !== null) {
              const optScrollingContext = detectWhenSplitUiMode(editor, mothership.element);
              const scrollers = optScrollingContext.map((sc) => [sc.element, ...sc.others]).getOr([]);
              if (exists(scrollers, (s) => eq(s, evt.target))) {
                editor.dispatch("ElementScroll", { target: evt.target.dom });
                broadcastEvent(externalElementScroll(), evt);
              }
            }
          });
        });
        const onEditorResize = () => broadcastOn(repositionPopups(), {});
        const onEditorProgress = (evt) => {
          if (evt.state) {
            broadcastOn(dismissPopups(), { target: SugarElement.fromDom(editor.getContainer()) });
          }
        };
        const onDismissPopups = (event) => {
          broadcastOn(dismissPopups(), { target: SugarElement.fromDom(event.relatedTarget.getContainer()) });
        };
        const onFocusIn = (event) => editor.dispatch("focusin", event);
        const onFocusOut = (event) => editor.dispatch("focusout", event);
        editor.on("PostRender", () => {
          editor.on("click", onContentClick);
          editor.on("tap", onContentClick);
          editor.on("mouseup", onContentMouseup);
          editor.on("mousedown", onContentMousedown);
          editor.on("ScrollWindow", onWindowScroll);
          editor.on("ResizeWindow", onWindowResize);
          editor.on("ResizeEditor", onEditorResize);
          editor.on("AfterProgressState", onEditorProgress);
          editor.on("DismissPopups", onDismissPopups);
          each$1([mothership, ...uiMotherships], (gui) => {
            gui.element.dom.addEventListener("focusin", onFocusIn);
            gui.element.dom.addEventListener("focusout", onFocusOut);
          });
        });
        editor.on("remove", () => {
          editor.off("click", onContentClick);
          editor.off("tap", onContentClick);
          editor.off("mouseup", onContentMouseup);
          editor.off("mousedown", onContentMousedown);
          editor.off("ScrollWindow", onWindowScroll);
          editor.off("ResizeWindow", onWindowResize);
          editor.off("ResizeEditor", onEditorResize);
          editor.off("AfterProgressState", onEditorProgress);
          editor.off("DismissPopups", onDismissPopups);
          each$1([mothership, ...uiMotherships], (gui) => {
            gui.element.dom.removeEventListener("focusin", onFocusIn);
            gui.element.dom.removeEventListener("focusout", onFocusOut);
          });
          onMousedown.unbind();
          onTouchstart.unbind();
          onTouchmove.unbind();
          onTouchend.unbind();
          onMouseup.unbind();
          onElementScroll.unbind();
        });
        editor.on("detach", () => {
          each$1([mothership, ...uiMotherships], detachSystem);
          each$1([mothership, ...uiMotherships], (m) => m.destroy());
        });
      };
      const setup$a = noop;
      const isDocked$1 = never;
      const getBehaviours$1 = constant$1([]);
      var StaticHeader = Object.freeze({
        __proto__: null,
        setup: setup$a,
        isDocked: isDocked$1,
        getBehaviours: getBehaviours$1
      });
      const toolbarHeightChange = constant$1(generate$6("toolbar-height-change"));
      const visibility = {
        fadeInClass: "tox-editor-dock-fadein",
        fadeOutClass: "tox-editor-dock-fadeout",
        transitionClass: "tox-editor-dock-transition"
      };
      const editorStickyOnClass = "tox-tinymce--toolbar-sticky-on";
      const editorStickyOffClass = "tox-tinymce--toolbar-sticky-off";
      const scrollFromBehindHeader = (e, containerHeader) => {
        const doc = owner$4(containerHeader);
        const win2 = defaultView(containerHeader);
        const viewHeight = win2.dom.innerHeight;
        const scrollPos = get$b(doc);
        const markerElement = SugarElement.fromDom(e.elm);
        const markerPos = absolute$2(markerElement);
        const markerHeight = get$d(markerElement);
        const markerTop = markerPos.y;
        const markerBottom = markerTop + markerHeight;
        const editorHeaderPos = absolute$3(containerHeader);
        const editorHeaderHeight = get$d(containerHeader);
        const editorHeaderTop = editorHeaderPos.top;
        const editorHeaderBottom = editorHeaderTop + editorHeaderHeight;
        const editorHeaderDockedAtTop = Math.abs(editorHeaderTop - scrollPos.top) < 2;
        const editorHeaderDockedAtBottom = Math.abs(editorHeaderBottom - (scrollPos.top + viewHeight)) < 2;
        if (editorHeaderDockedAtTop && markerTop < editorHeaderBottom) {
          to(scrollPos.left, markerTop - editorHeaderHeight, doc);
        } else if (editorHeaderDockedAtBottom && markerBottom > editorHeaderTop) {
          const y = markerTop - viewHeight + markerHeight + editorHeaderHeight;
          to(scrollPos.left, y, doc);
        }
      };
      const isDockedMode = (header, mode) => contains$2(Docking.getModes(header), mode);
      const updateIframeContentFlow = (header) => {
        const getOccupiedHeight = (elm2) => getOuter$1(elm2) + (parseInt(get$e(elm2, "margin-top"), 10) || 0) + (parseInt(get$e(elm2, "margin-bottom"), 10) || 0);
        const elm = header.element;
        parentElement(elm).each((parentElem) => {
          const padding = "padding-" + Docking.getModes(header)[0];
          if (Docking.isDocked(header)) {
            const parentWidth = get$c(parentElem);
            set$7(elm, "width", parentWidth + "px");
            set$7(parentElem, padding, getOccupiedHeight(elm) + "px");
          } else {
            remove$6(elm, "width");
            remove$6(parentElem, padding);
          }
        });
      };
      const updateSinkVisibility = (sinkElem, visible) => {
        if (visible) {
          remove$3(sinkElem, visibility.fadeOutClass);
          add$1(sinkElem, [visibility.transitionClass, visibility.fadeInClass]);
        } else {
          remove$3(sinkElem, visibility.fadeInClass);
          add$1(sinkElem, [visibility.fadeOutClass, visibility.transitionClass]);
        }
      };
      const updateEditorClasses = (editor, docked) => {
        const editorContainer = SugarElement.fromDom(editor.getContainer());
        if (docked) {
          add$2(editorContainer, editorStickyOnClass);
          remove$3(editorContainer, editorStickyOffClass);
        } else {
          add$2(editorContainer, editorStickyOffClass);
          remove$3(editorContainer, editorStickyOnClass);
        }
      };
      const restoreFocus = (headerElem, focusedElem) => {
        const ownerDoc = owner$4(focusedElem);
        active$1(ownerDoc).filter((activeElm) => (
          // Don't try to refocus the same element
          !eq(focusedElem, activeElm)
        )).filter((activeElm) => (
          // Only attempt to refocus if the current focus is the body or is in the header element
          eq(activeElm, SugarElement.fromDom(ownerDoc.dom.body)) || contains(headerElem, activeElm)
        )).each(() => focus$4(focusedElem));
      };
      const findFocusedElem = (rootElm, lazySink) => (
        // Check to see if an element is focused inside the header or inside the sink
        // and if so store the element so we can restore it later
        search(rootElm).orThunk(() => lazySink().toOptional().bind((sink) => search(sink.element)))
      );
      const setup$9 = (editor, sharedBackstage, lazyHeader) => {
        if (!editor.inline) {
          if (!sharedBackstage.header.isPositionedAtTop()) {
            editor.on("ResizeEditor", () => {
              lazyHeader().each(Docking.reset);
            });
          }
          editor.on("ResizeWindow ResizeEditor", () => {
            lazyHeader().each(updateIframeContentFlow);
          });
          editor.on("SkinLoaded", () => {
            lazyHeader().each((comp) => {
              Docking.isDocked(comp) ? Docking.reset(comp) : Docking.refresh(comp);
            });
          });
          editor.on("FullscreenStateChanged", () => {
            lazyHeader().each(Docking.reset);
          });
        }
        editor.on("AfterScrollIntoView", (e) => {
          lazyHeader().each((header) => {
            Docking.refresh(header);
            const headerElem = header.element;
            if (isVisible(headerElem)) {
              scrollFromBehindHeader(e, headerElem);
            }
          });
        });
        editor.on("PostRender", () => {
          updateEditorClasses(editor, false);
        });
      };
      const isDocked = (lazyHeader) => lazyHeader().map(Docking.isDocked).getOr(false);
      const getIframeBehaviours = () => [
        Receiving.config({
          channels: {
            [toolbarHeightChange()]: {
              onReceive: updateIframeContentFlow
            }
          }
        })
      ];
      const getBehaviours = (editor, sharedBackstage) => {
        const focusedElm = value$2();
        const lazySink = sharedBackstage.getSink;
        const runOnSinkElement = (f2) => {
          lazySink().each((sink) => f2(sink.element));
        };
        const onDockingSwitch = (comp) => {
          if (!editor.inline) {
            updateIframeContentFlow(comp);
          }
          updateEditorClasses(editor, Docking.isDocked(comp));
          comp.getSystem().broadcastOn([repositionPopups()], {});
          lazySink().each((sink) => sink.getSystem().broadcastOn([repositionPopups()], {}));
        };
        const additionalBehaviours = editor.inline ? [] : getIframeBehaviours();
        return [
          Focusing.config({}),
          Docking.config({
            contextual: {
              lazyContext: (comp) => {
                const headerHeight = getOuter$1(comp.element);
                const container = editor.inline ? editor.getContentAreaContainer() : editor.getContainer();
                return Optional.from(container).map((c) => {
                  const box2 = box$1(SugarElement.fromDom(c));
                  const optScrollingContext = detectWhenSplitUiMode(editor, comp.element);
                  return optScrollingContext.fold(() => {
                    const boxHeight = box2.height - headerHeight;
                    const topBound = box2.y + (isDockedMode(comp, "top") ? 0 : headerHeight);
                    return bounds(box2.x, topBound, box2.width, boxHeight);
                  }, (scrollEnv) => {
                    const constrainedBounds = constrain(box2, getBoundsFrom(scrollEnv));
                    const constrainedBoundsY = isDockedMode(comp, "top") ? constrainedBounds.y : constrainedBounds.y + headerHeight;
                    return bounds(
                      constrainedBounds.x,
                      // ASSUMPTION: The constrainedBounds removes the need for us to set this to 0px
                      // for docked mode. Also, docking in a scrolling environment will often be
                      // at the scroller top, not the window top
                      constrainedBoundsY,
                      constrainedBounds.width,
                      constrainedBounds.height - headerHeight
                    );
                  });
                });
              },
              onShow: () => {
                runOnSinkElement((elem) => updateSinkVisibility(elem, true));
              },
              onShown: (comp) => {
                runOnSinkElement((elem) => remove$2(elem, [visibility.transitionClass, visibility.fadeInClass]));
                focusedElm.get().each((elem) => {
                  restoreFocus(comp.element, elem);
                  focusedElm.clear();
                });
              },
              onHide: (comp) => {
                findFocusedElem(comp.element, lazySink).fold(focusedElm.clear, focusedElm.set);
                runOnSinkElement((elem) => updateSinkVisibility(elem, false));
              },
              onHidden: () => {
                runOnSinkElement((elem) => remove$2(elem, [visibility.transitionClass]));
              },
              ...visibility
            },
            lazyViewport: (comp) => {
              const optScrollingContext = detectWhenSplitUiMode(editor, comp.element);
              return optScrollingContext.fold(() => {
                const boundsWithoutOffset = win();
                const offset2 = getStickyToolbarOffset(editor);
                const top2 = boundsWithoutOffset.y + (isDockedMode(comp, "top") && !isFullscreen(editor) ? offset2 : 0);
                const height2 = boundsWithoutOffset.height - (isDockedMode(comp, "bottom") ? offset2 : 0);
                return {
                  bounds: bounds(boundsWithoutOffset.x, top2, boundsWithoutOffset.width, height2),
                  optScrollEnv: Optional.none()
                };
              }, (sc) => {
                const combinedBounds = getBoundsFrom(sc);
                return {
                  bounds: combinedBounds,
                  optScrollEnv: Optional.some({
                    currentScrollTop: sc.element.dom.scrollTop,
                    scrollElmTop: absolute$3(sc.element).top
                  })
                };
              });
            },
            modes: [sharedBackstage.header.getDockingMode()],
            onDocked: onDockingSwitch,
            onUndocked: onDockingSwitch
          }),
          ...additionalBehaviours
        ];
      };
      var StickyHeader = Object.freeze({
        __proto__: null,
        setup: setup$9,
        isDocked,
        getBehaviours
      });
      const renderHeader = (spec) => {
        const editor = spec.editor;
        const getBehaviours$22 = spec.sticky ? getBehaviours : getBehaviours$1;
        return {
          uid: spec.uid,
          dom: spec.dom,
          components: spec.components,
          behaviours: derive$1(getBehaviours$22(editor, spec.sharedBackstage))
        };
      };
      const factory$3 = (detail, spec) => {
        const setMenus = (comp, menus) => {
          const newMenus = map$2(menus, (m) => {
            const buttonSpec = {
              type: "menubutton",
              text: m.text,
              fetch: (callback) => {
                callback(m.getItems());
              },
              context: "any"
            };
            const internal = createMenuButton(buttonSpec).mapError((errInfo) => formatError(errInfo)).getOrDie();
            return renderMenuButton(
              internal,
              "tox-mbtn",
              spec.backstage,
              // https://www.w3.org/TR/wai-aria-practices/examples/menubar/menubar-2/menubar-2.html
              Optional.some("menuitem")
            );
          });
          Replacing.set(comp, newMenus);
        };
        const apis = {
          focus: Keying.focusIn,
          setMenus
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: [],
          behaviours: derive$1([
            Replacing.config({}),
            config("menubar-events", [
              runOnAttached((component) => {
                detail.onSetup(component);
              }),
              run$1(mouseover(), (comp, se) => {
                descendant(
                  comp.element,
                  ".tox-mbtn--active"
                  /* MenuButtonClasses.Active */
                ).each((activeButton) => {
                  closest$3(
                    se.event.target,
                    ".tox-mbtn"
                    /* MenuButtonClasses.Button */
                  ).each((hoveredButton) => {
                    if (!eq(activeButton, hoveredButton)) {
                      comp.getSystem().getByDom(activeButton).each((activeComp) => {
                        comp.getSystem().getByDom(hoveredButton).each((hoveredComp) => {
                          Dropdown.expand(hoveredComp);
                          Dropdown.close(activeComp);
                          Focusing.focus(hoveredComp);
                        });
                      });
                    }
                  });
                });
              }),
              run$1(focusShifted(), (comp, se) => {
                se.event.prevFocus.bind((prev) => comp.getSystem().getByDom(prev).toOptional()).each((prev) => {
                  se.event.newFocus.bind((nu2) => comp.getSystem().getByDom(nu2).toOptional()).each((nu2) => {
                    if (Dropdown.isOpen(prev)) {
                      Dropdown.expand(nu2);
                      Dropdown.close(prev);
                    }
                  });
                });
              })
            ]),
            Keying.config({
              mode: "flow",
              selector: ".tox-mbtn",
              onEscape: (comp) => {
                detail.onEscape(comp);
                return Optional.some(true);
              }
            }),
            Tabstopping.config({})
          ]),
          apis,
          domModification: {
            attributes: {
              role: "menubar"
            }
          }
        };
      };
      var SilverMenubar = single({
        factory: factory$3,
        name: "silver.Menubar",
        configFields: [
          required$1("dom"),
          required$1("uid"),
          required$1("onEscape"),
          required$1("backstage"),
          defaulted("onSetup", noop)
        ],
        apis: {
          focus: (apis, comp) => {
            apis.focus(comp);
          },
          setMenus: (apis, comp, menus) => {
            apis.setMenus(comp, menus);
          }
        }
      });
      const promotionMessage = "💝Get all features";
      const promotionLink = "https://www.tiny.cloud/tinymce-upgrade-to-cloud/?utm_campaign=self_hosted_upgrade_promo&utm_source=tiny&utm_medium=referral";
      const renderPromotion = (spec) => {
        const components2 = spec.promotionLink ? [
          {
            dom: {
              tag: "a",
              attributes: {
                "href": promotionLink,
                "rel": "noopener",
                "target": "_blank",
                "aria-hidden": "true"
              },
              classes: ["tox-promotion-link"],
              innerHtml: promotionMessage
            }
          }
        ] : [];
        return {
          uid: spec.uid,
          dom: spec.dom,
          components: components2
        };
      };
      const setup$8 = (editor) => {
        const { sidebars } = editor.ui.registry.getAll();
        each$1(keys(sidebars), (name2) => {
          const spec = sidebars[name2];
          const isActive = () => is$1(Optional.from(editor.queryCommandValue("ToggleSidebar")), name2);
          editor.ui.registry.addToggleButton(name2, {
            icon: spec.icon,
            tooltip: spec.tooltip,
            onAction: (buttonApi) => {
              editor.execCommand("ToggleSidebar", false, name2);
              buttonApi.setActive(isActive());
            },
            onSetup: (buttonApi) => {
              buttonApi.setActive(isActive());
              const handleToggle = () => buttonApi.setActive(isActive());
              editor.on("ToggleSidebar", handleToggle);
              return () => {
                editor.off("ToggleSidebar", handleToggle);
              };
            },
            context: "any"
          });
        });
      };
      const getApi = (comp) => ({
        element: () => comp.element.dom
      });
      const makePanels = (parts2, panelConfigs) => {
        const specs = map$2(keys(panelConfigs), (name2) => {
          const spec = panelConfigs[name2];
          const bridged = getOrDie(createSidebar(spec));
          return {
            name: name2,
            getApi,
            onSetup: bridged.onSetup,
            onShow: bridged.onShow,
            onHide: bridged.onHide
          };
        });
        return map$2(specs, (spec) => {
          const editorOffCell = Cell(noop);
          return parts2.slot(spec.name, {
            dom: {
              tag: "div",
              classes: ["tox-sidebar__pane"]
            },
            behaviours: SimpleBehaviours.unnamedEvents([
              onControlAttached(spec, editorOffCell),
              onControlDetached(spec, editorOffCell),
              run$1(slotVisibility(), (sidepanel, se) => {
                const data = se.event;
                const optSidePanelSpec = find$5(specs, (config2) => config2.name === data.name);
                optSidePanelSpec.each((sidePanelSpec) => {
                  const handler = data.visible ? sidePanelSpec.onShow : sidePanelSpec.onHide;
                  handler(sidePanelSpec.getApi(sidepanel));
                });
              })
            ])
          });
        });
      };
      const makeSidebar = (panelConfigs) => SlotContainer.sketch((parts2) => ({
        dom: {
          tag: "div",
          classes: ["tox-sidebar__pane-container"]
        },
        components: makePanels(parts2, panelConfigs),
        slotBehaviours: SimpleBehaviours.unnamedEvents([
          runOnAttached((slotContainer) => SlotContainer.hideAllSlots(slotContainer))
        ])
      }));
      const setSidebar = (sidebar, panelConfigs, showSidebar) => {
        const optSlider = Composing.getCurrent(sidebar);
        optSlider.each((slider) => {
          Replacing.set(slider, [makeSidebar(panelConfigs)]);
          const configKey = showSidebar === null || showSidebar === void 0 ? void 0 : showSidebar.toLowerCase();
          if (isString(configKey) && has$2(panelConfigs, configKey)) {
            Composing.getCurrent(slider).each((slotContainer) => {
              SlotContainer.showSlot(slotContainer, configKey);
              Sliding.immediateGrow(slider);
              remove$6(slider.element, "width");
              updateSidebarRoleOnToggle(
                sidebar.element,
                "region"
                /* SidebarStateRoleAttr.Grown */
              );
            });
          }
        });
      };
      const updateSidebarRoleOnToggle = (sidebar, sidebarState) => {
        set$9(sidebar, "role", sidebarState);
      };
      const toggleSidebar = (sidebar, name2) => {
        const optSlider = Composing.getCurrent(sidebar);
        optSlider.each((slider) => {
          const optSlotContainer = Composing.getCurrent(slider);
          optSlotContainer.each((slotContainer) => {
            if (Sliding.hasGrown(slider)) {
              if (SlotContainer.isShowing(slotContainer, name2)) {
                Sliding.shrink(slider);
                updateSidebarRoleOnToggle(
                  sidebar.element,
                  "presentation"
                  /* SidebarStateRoleAttr.Shrunk */
                );
              } else {
                SlotContainer.hideAllSlots(slotContainer);
                SlotContainer.showSlot(slotContainer, name2);
                updateSidebarRoleOnToggle(
                  sidebar.element,
                  "region"
                  /* SidebarStateRoleAttr.Grown */
                );
              }
            } else {
              SlotContainer.hideAllSlots(slotContainer);
              SlotContainer.showSlot(slotContainer, name2);
              Sliding.grow(slider);
              updateSidebarRoleOnToggle(
                sidebar.element,
                "region"
                /* SidebarStateRoleAttr.Grown */
              );
            }
          });
        });
      };
      const whichSidebar = (sidebar) => {
        const optSlider = Composing.getCurrent(sidebar);
        return optSlider.bind((slider) => {
          const sidebarOpen = Sliding.isGrowing(slider) || Sliding.hasGrown(slider);
          if (sidebarOpen) {
            const optSlotContainer = Composing.getCurrent(slider);
            return optSlotContainer.bind((slotContainer) => find$5(SlotContainer.getSlotNames(slotContainer), (name2) => SlotContainer.isShowing(slotContainer, name2)));
          } else {
            return Optional.none();
          }
        });
      };
      const fixSize = generate$6("FixSizeEvent");
      const autoSize = generate$6("AutoSizeEvent");
      const renderSidebar = (spec) => ({
        uid: spec.uid,
        dom: {
          tag: "div",
          classes: ["tox-sidebar"],
          attributes: {
            role: "presentation"
            /* SidebarStateRoleAttr.Shrunk */
          }
        },
        components: [
          {
            dom: {
              tag: "div",
              classes: ["tox-sidebar__slider"]
            },
            components: [
              // this will be replaced on setSidebar
            ],
            behaviours: derive$1([
              Tabstopping.config({}),
              Focusing.config({}),
              // TODO use Keying and use focusIn, but need to handle if sidebar contains nothing
              Sliding.config({
                dimension: {
                  property: "width"
                },
                closedClass: "tox-sidebar--sliding-closed",
                openClass: "tox-sidebar--sliding-open",
                shrinkingClass: "tox-sidebar--sliding-shrinking",
                growingClass: "tox-sidebar--sliding-growing",
                onShrunk: (slider) => {
                  const optSlotContainer = Composing.getCurrent(slider);
                  optSlotContainer.each(SlotContainer.hideAllSlots);
                  emit(slider, autoSize);
                },
                onGrown: (slider) => {
                  emit(slider, autoSize);
                },
                onStartGrow: (slider) => {
                  emitWith(slider, fixSize, { width: getRaw(slider.element, "width").getOr("") });
                },
                onStartShrink: (slider) => {
                  emitWith(slider, fixSize, { width: get$c(slider.element) + "px" });
                }
              }),
              Replacing.config({}),
              Composing.config({
                find: (comp) => {
                  const children2 = Replacing.contents(comp);
                  return head(children2);
                }
              })
            ])
          }
        ],
        behaviours: derive$1([
          ComposingConfigs.childAt(0),
          config("sidebar-sliding-events", [
            run$1(fixSize, (comp, se) => {
              set$7(comp.element, "width", se.event.width);
            }),
            run$1(autoSize, (comp, _se) => {
              remove$6(comp.element, "width");
            })
          ])
        ])
      });
      const getBusySpec$1 = (providerBackstage) => (_root, _behaviours) => ({
        dom: {
          tag: "div",
          attributes: {
            "aria-label": providerBackstage.translate("Loading..."),
            "tabindex": "0"
          },
          classes: ["tox-throbber__busy-spinner"]
        },
        components: [
          {
            dom: fromHtml('<div class="tox-spinner"><div></div><div></div><div></div></div>')
          }
        ]
      });
      const focusBusyComponent = (throbber) => Composing.getCurrent(throbber).each((comp) => focus$4(comp.element, true));
      const toggleEditorTabIndex = (editor, state) => {
        const tabIndexAttr = "tabindex";
        const dataTabIndexAttr = `data-mce-${tabIndexAttr}`;
        Optional.from(editor.iframeElement).map(SugarElement.fromDom).each((iframe2) => {
          if (state) {
            getOpt(iframe2, tabIndexAttr).each((tabIndex) => set$9(iframe2, dataTabIndexAttr, tabIndex));
            set$9(iframe2, tabIndexAttr, -1);
          } else {
            remove$8(iframe2, tabIndexAttr);
            getOpt(iframe2, dataTabIndexAttr).each((tabIndex) => {
              set$9(iframe2, tabIndexAttr, tabIndex);
              remove$8(iframe2, dataTabIndexAttr);
            });
          }
        });
      };
      const toggleThrobber = (editor, comp, state, providerBackstage) => {
        const element2 = comp.element;
        toggleEditorTabIndex(editor, state);
        if (state) {
          Blocking.block(comp, getBusySpec$1(providerBackstage));
          remove$6(element2, "display");
          remove$8(element2, "aria-hidden");
          if (editor.hasFocus()) {
            focusBusyComponent(comp);
          }
        } else {
          const throbberFocus = Composing.getCurrent(comp).exists((busyComp) => hasFocus(busyComp.element));
          Blocking.unblock(comp);
          set$7(element2, "display", "none");
          set$9(element2, "aria-hidden", "true");
          if (throbberFocus) {
            editor.focus();
          }
        }
      };
      const renderThrobber = (spec) => ({
        uid: spec.uid,
        dom: {
          tag: "div",
          attributes: {
            "aria-hidden": "true"
          },
          classes: ["tox-throbber"],
          styles: {
            display: "none"
          }
        },
        behaviours: derive$1([
          Replacing.config({}),
          Blocking.config({
            focus: false
          }),
          Composing.config({
            find: (comp) => head(comp.components())
          })
        ]),
        components: []
      });
      const isFocusEvent = (event) => event.type === "focusin";
      const isPasteBinTarget = (event) => {
        if (isFocusEvent(event)) {
          const node = event.composed ? head(event.composedPath()) : Optional.from(event.target);
          return node.map(SugarElement.fromDom).filter(isElement$1).exists((targetElm) => has(targetElm, "mce-pastebin"));
        } else {
          return false;
        }
      };
      const setup$7 = (editor, lazyThrobber, sharedBackstage) => {
        const throbberState = Cell(false);
        const timer = value$2();
        const stealFocus = (e) => {
          if (throbberState.get() && !isPasteBinTarget(e)) {
            e.preventDefault();
            focusBusyComponent(lazyThrobber());
            editor.editorManager.setActive(editor);
          }
        };
        if (!editor.inline) {
          editor.on("PreInit", () => {
            editor.dom.bind(editor.getWin(), "focusin", stealFocus);
            editor.on("BeforeExecCommand", (e) => {
              if (e.command.toLowerCase() === "mcefocus" && e.value !== true) {
                stealFocus(e);
              }
            });
          });
        }
        const toggle2 = (state) => {
          if (state !== throbberState.get()) {
            throbberState.set(state);
            toggleThrobber(editor, lazyThrobber(), state, sharedBackstage.providers);
            fireAfterProgressState(editor, state);
          }
        };
        editor.on("ProgressState", (e) => {
          timer.on(clearTimeout);
          if (isNumber(e.time)) {
            const timerId = global$a.setEditorTimeout(editor, () => toggle2(e.state), e.time);
            timer.set(timerId);
          } else {
            toggle2(e.state);
            timer.clear();
          }
        });
      };
      const renderToolbarGroupCommon = (toolbarGroup) => {
        const attributes = toolbarGroup.label.isNone() ? toolbarGroup.title.fold(() => ({}), (title2) => ({ attributes: { "aria-label": title2 } })) : toolbarGroup.label.fold(() => ({}), (label2) => ({ attributes: { "aria-label": label2 } }));
        return {
          dom: {
            tag: "div",
            classes: ["tox-toolbar__group"].concat(toolbarGroup.label.isSome() ? ["tox-toolbar__group_with_label"] : []),
            ...attributes
          },
          components: [
            ...toolbarGroup.label.map((label2) => {
              return {
                dom: {
                  tag: "span",
                  classes: ["tox-label", "tox-label--context-toolbar"]
                },
                components: [text$2(label2)]
              };
            }).toArray(),
            ToolbarGroup.parts.items({})
          ],
          items: toolbarGroup.items,
          markers: {
            // nav within a group breaks if disabled buttons are first in their group so skip them
            itemSelector: "*:not(.tox-split-button) > .tox-tbtn:not([disabled]), .tox-split-button:not([disabled]), .tox-toolbar-nav-item:not([disabled]), .tox-number-input:not([disabled])"
          },
          tgroupBehaviours: derive$1([
            Tabstopping.config({}),
            Focusing.config({
              ignore: true
            })
          ])
        };
      };
      const renderToolbarGroup = (toolbarGroup) => ToolbarGroup.sketch(renderToolbarGroupCommon(toolbarGroup));
      const getToolbarBehaviours = (toolbarSpec, modeName) => {
        const onAttached = runOnAttached((component) => {
          const groups = map$2(toolbarSpec.initGroups, renderToolbarGroup);
          Toolbar.setGroups(component, groups);
        });
        return derive$1([
          DisablingConfigs.toolbarButton(() => toolbarSpec.providers.checkUiComponentContext("any").shouldDisable),
          toggleOnReceive(() => toolbarSpec.providers.checkUiComponentContext("any")),
          Keying.config({
            // Tabs between groups
            mode: modeName,
            onEscape: toolbarSpec.onEscape,
            visibilitySelector: ".tox-toolbar__overflow",
            selector: ".tox-toolbar__group"
          }),
          config("toolbar-events", [onAttached])
        ]);
      };
      const renderMoreToolbarCommon = (toolbarSpec) => {
        const modeName = toolbarSpec.cyclicKeying ? "cyclic" : "acyclic";
        return {
          uid: toolbarSpec.uid,
          dom: {
            tag: "div",
            classes: ["tox-toolbar-overlord"]
          },
          parts: {
            // This already knows it is a toolbar group
            "overflow-group": renderToolbarGroupCommon({
              title: Optional.none(),
              label: Optional.none(),
              items: []
            }),
            "overflow-button": renderIconButtonSpec({
              context: "any",
              name: "more",
              icon: Optional.some("more-drawer"),
              enabled: true,
              tooltip: Optional.some("Reveal or hide additional toolbar items"),
              primary: false,
              buttonType: Optional.none(),
              borderless: false
            }, Optional.none(), toolbarSpec.providers, [], "overflow-button")
          },
          splitToolbarBehaviours: getToolbarBehaviours(toolbarSpec, modeName)
        };
      };
      const renderFloatingMoreToolbar = (toolbarSpec) => {
        const baseSpec = renderMoreToolbarCommon(toolbarSpec);
        const overflowXOffset = 4;
        const primary2 = SplitFloatingToolbar.parts.primary({
          dom: {
            tag: "div",
            classes: ["tox-toolbar__primary"]
          }
        });
        return SplitFloatingToolbar.sketch({
          ...baseSpec,
          lazySink: toolbarSpec.getSink,
          getOverflowBounds: () => {
            const headerElem = toolbarSpec.moreDrawerData.lazyHeader().element;
            const headerBounds = absolute$2(headerElem);
            const docElem = documentElement(headerElem);
            const docBounds = absolute$2(docElem);
            const height2 = Math.max(docElem.dom.scrollHeight, docBounds.height);
            return bounds(headerBounds.x + overflowXOffset, docBounds.y, headerBounds.width - overflowXOffset * 2, height2);
          },
          parts: {
            ...baseSpec.parts,
            overflow: {
              dom: {
                tag: "div",
                classes: ["tox-toolbar__overflow"],
                attributes: toolbarSpec.attributes
              }
            }
          },
          components: [primary2],
          markers: {
            overflowToggledClass: "tox-tbtn--enabled"
            /* ToolbarButtonClasses.Ticked */
          },
          onOpened: (comp) => toolbarSpec.onToggled(comp, true),
          onClosed: (comp) => toolbarSpec.onToggled(comp, false)
        });
      };
      const renderSlidingMoreToolbar = (toolbarSpec) => {
        const primary2 = SplitSlidingToolbar.parts.primary({
          dom: {
            tag: "div",
            classes: ["tox-toolbar__primary"]
          }
        });
        const overflow2 = SplitSlidingToolbar.parts.overflow({
          dom: {
            tag: "div",
            classes: ["tox-toolbar__overflow"]
          }
        });
        const baseSpec = renderMoreToolbarCommon(toolbarSpec);
        return SplitSlidingToolbar.sketch({
          ...baseSpec,
          components: [primary2, overflow2],
          markers: {
            openClass: "tox-toolbar__overflow--open",
            closedClass: "tox-toolbar__overflow--closed",
            growingClass: "tox-toolbar__overflow--growing",
            shrinkingClass: "tox-toolbar__overflow--shrinking",
            overflowToggledClass: "tox-tbtn--enabled"
            /* ToolbarButtonClasses.Ticked */
          },
          onOpened: (comp) => {
            comp.getSystem().broadcastOn([toolbarHeightChange()], { type: "opened" });
            toolbarSpec.onToggled(comp, true);
          },
          onClosed: (comp) => {
            comp.getSystem().broadcastOn([toolbarHeightChange()], { type: "closed" });
            toolbarSpec.onToggled(comp, false);
          }
        });
      };
      const renderToolbar = (toolbarSpec) => {
        const modeName = toolbarSpec.cyclicKeying ? "cyclic" : "acyclic";
        return Toolbar.sketch({
          uid: toolbarSpec.uid,
          dom: {
            tag: "div",
            classes: ["tox-toolbar"].concat(toolbarSpec.type === ToolbarMode$1.scrolling ? ["tox-toolbar--scrolling"] : [])
          },
          components: [
            Toolbar.parts.groups({})
          ],
          toolbarBehaviours: getToolbarBehaviours(toolbarSpec, modeName)
        });
      };
      const renderButton = (spec, providers) => {
        var _a, _b;
        const isToggleButton2 = spec.type === "togglebutton";
        const optMemIcon = spec.icon.map((memIcon) => renderReplaceableIconFromPack(memIcon, providers.icons)).map(record);
        const getAction2 = () => (comp) => {
          const setIcon = (newIcon) => {
            optMemIcon.map((memIcon) => memIcon.getOpt(comp).each((displayIcon) => {
              Replacing.set(displayIcon, [
                renderReplaceableIconFromPack(newIcon, providers.icons)
              ]);
            }));
          };
          const setActive = (state) => {
            const elm = comp.element;
            if (state) {
              add$2(
                elm,
                "tox-button--enabled"
                /* ViewButtonClasses.Ticked */
              );
              set$9(elm, "aria-pressed", true);
            } else {
              remove$3(
                elm,
                "tox-button--enabled"
                /* ViewButtonClasses.Ticked */
              );
              remove$8(elm, "aria-pressed");
            }
          };
          const isActive = () => has(
            comp.element,
            "tox-button--enabled"
            /* ViewButtonClasses.Ticked */
          );
          const focus2 = () => focus$4(comp.element);
          if (isToggleButton2) {
            return spec.onAction({ setIcon, setActive, isActive, focus: focus2 });
          }
          if (spec.type === "button") {
            return spec.onAction({ setIcon });
          }
        };
        const action = getAction2();
        const buttonSpec = {
          ...spec,
          name: isToggleButton2 ? spec.text.getOr(spec.icon.getOr("")) : (_a = spec.text) !== null && _a !== void 0 ? _a : spec.icon.getOr(""),
          primary: spec.buttonType === "primary",
          buttonType: Optional.from(spec.buttonType),
          tooltip: spec.tooltip,
          icon: spec.icon,
          enabled: true,
          borderless: spec.borderless
        };
        const buttonTypeClasses = calculateClassesFromButtonType((_b = spec.buttonType) !== null && _b !== void 0 ? _b : "secondary");
        const optTranslatedText = isToggleButton2 ? spec.text.map(providers.translate) : Optional.some(providers.translate(spec.text));
        const optTranslatedTextComponed = optTranslatedText.map(text$2);
        const ariaLabelAttributes = buttonSpec.tooltip.or(optTranslatedText).map((al) => ({
          "aria-label": providers.translate(al)
        })).getOr({});
        const optIconSpec = optMemIcon.map((memIcon) => memIcon.asSpec());
        const components2 = componentRenderPipeline([optIconSpec, optTranslatedTextComponed]);
        const hasIconAndText = spec.icon.isSome() && optTranslatedTextComponed.isSome();
        const dom2 = {
          tag: "button",
          classes: buttonTypeClasses.concat(...spec.icon.isSome() && !hasIconAndText ? ["tox-button--icon"] : []).concat(...hasIconAndText ? ["tox-button--icon-and-text"] : []).concat(...spec.borderless ? ["tox-button--naked"] : []).concat(...spec.type === "togglebutton" && spec.active ? [
            "tox-button--enabled"
            /* ViewButtonClasses.Ticked */
          ] : []),
          attributes: ariaLabelAttributes
        };
        const extraBehaviours = [];
        const iconButtonSpec = renderCommonSpec(buttonSpec, Optional.some(action), extraBehaviours, dom2, components2, spec.tooltip, providers);
        return Button.sketch(iconButtonSpec);
      };
      const renderViewButton = (spec, providers) => renderButton(spec, providers);
      const renderButtonsGroup = (spec, providers) => {
        return {
          dom: {
            tag: "div",
            classes: ["tox-view__toolbar__group"]
          },
          components: map$2(spec.buttons, (button2) => renderViewButton(button2, providers))
        };
      };
      const deviceDetection = detect$1().deviceType;
      const isPhone = deviceDetection.isPhone();
      const isTablet = deviceDetection.isTablet();
      const renderViewHeader = (spec) => {
        let hasGroups = false;
        const endButtons = map$2(spec.buttons, (btnspec) => {
          if (btnspec.type === "group") {
            hasGroups = true;
            return renderButtonsGroup(btnspec, spec.providers);
          } else {
            return renderViewButton(btnspec, spec.providers);
          }
        });
        return {
          uid: spec.uid,
          dom: {
            tag: "div",
            classes: [
              !hasGroups ? "tox-view__header" : "tox-view__toolbar",
              ...isPhone || isTablet ? ["tox-view--mobile", "tox-view--scrolling"] : []
            ]
          },
          behaviours: derive$1([
            Focusing.config({}),
            Keying.config({
              mode: "flow",
              selector: "button, .tox-button",
              focusInside: FocusInsideModes.OnEnterOrSpaceMode
            })
          ]),
          components: hasGroups ? endButtons : [
            Container.sketch({
              dom: {
                tag: "div",
                classes: ["tox-view__header-start"]
              },
              components: []
            }),
            Container.sketch({
              dom: {
                tag: "div",
                classes: ["tox-view__header-end"]
              },
              components: endButtons
            })
          ]
        };
      };
      const renderViewPane = (spec) => {
        return {
          uid: spec.uid,
          behaviours: derive$1([
            Focusing.config({}),
            Tabstopping.config({})
          ]),
          dom: {
            tag: "div",
            classes: ["tox-view__pane"]
          }
        };
      };
      const factory$2 = (detail, components2, _spec, _externals) => {
        const apis = {
          getPane: (comp) => parts$h.getPart(comp, detail, "pane"),
          getOnShow: (_comp) => detail.viewConfig.onShow,
          getOnHide: (_comp) => detail.viewConfig.onHide
        };
        return {
          uid: detail.uid,
          dom: detail.dom,
          components: components2,
          behaviours: derive$1([
            Focusing.config({}),
            Keying.config({
              mode: "cyclic",
              focusInside: FocusInsideModes.OnEnterOrSpaceMode
            })
          ]),
          apis
        };
      };
      var View = composite({
        name: "silver.View",
        configFields: [
          required$1("viewConfig")
        ],
        partFields: [
          optional({
            factory: {
              sketch: renderViewHeader
            },
            schema: [
              required$1("buttons"),
              required$1("providers")
            ],
            name: "header"
          }),
          optional({
            factory: {
              sketch: renderViewPane
            },
            schema: [],
            name: "pane"
          })
        ],
        factory: factory$2,
        apis: {
          getPane: (apis, comp) => apis.getPane(comp),
          getOnShow: (apis, comp) => apis.getOnShow(comp),
          getOnHide: (apis, comp) => apis.getOnHide(comp)
        }
      });
      const makeViews = (parts2, viewConfigs, providers) => {
        return mapToArray(viewConfigs, (config2, name2) => {
          const internalViewConfig = getOrDie(createView(config2));
          return parts2.slot(name2, View.sketch({
            dom: {
              tag: "div",
              classes: ["tox-view"]
            },
            viewConfig: internalViewConfig,
            components: [
              ...internalViewConfig.buttons.length > 0 ? [
                View.parts.header({
                  buttons: internalViewConfig.buttons,
                  providers
                })
              ] : [],
              View.parts.pane({})
            ]
          }));
        });
      };
      const makeSlotContainer = (viewConfigs, providers) => SlotContainer.sketch((parts2) => ({
        dom: {
          tag: "div",
          classes: ["tox-view-wrap__slot-container"]
        },
        components: makeViews(parts2, viewConfigs, providers),
        slotBehaviours: SimpleBehaviours.unnamedEvents([
          runOnAttached((slotContainer) => SlotContainer.hideAllSlots(slotContainer))
        ])
      }));
      const getCurrentName = (slotContainer) => {
        return find$5(SlotContainer.getSlotNames(slotContainer), (name2) => SlotContainer.isShowing(slotContainer, name2));
      };
      const hideContainer = (comp) => {
        const element2 = comp.element;
        set$7(element2, "display", "none");
        set$9(element2, "aria-hidden", "true");
      };
      const showContainer = (comp) => {
        const element2 = comp.element;
        remove$6(element2, "display");
        remove$8(element2, "aria-hidden");
      };
      const makeViewInstanceApi = (slot) => ({
        getContainer: constant$1(slot)
      });
      const runOnPaneWithInstanceApi = (slotContainer, name2, get2) => {
        SlotContainer.getSlot(slotContainer, name2).each((view2) => {
          View.getPane(view2).each((pane) => {
            const onCallback = get2(view2);
            onCallback(makeViewInstanceApi(pane.element.dom));
          });
        });
      };
      const runOnShow = (slotContainer, name2) => runOnPaneWithInstanceApi(slotContainer, name2, View.getOnShow);
      const runOnHide = (slotContainer, name2) => runOnPaneWithInstanceApi(slotContainer, name2, View.getOnHide);
      const factory$1 = (detail, spec) => {
        const setViews = (comp, viewConfigs) => {
          Replacing.set(comp, [makeSlotContainer(viewConfigs, spec.backstage.shared.providers)]);
        };
        const whichView = (comp) => {
          return Composing.getCurrent(comp).bind(getCurrentName);
        };
        const toggleView = (comp, showMainView, hideMainView, name2) => {
          return Composing.getCurrent(comp).exists((slotContainer) => {
            const optCurrentSlotName = getCurrentName(slotContainer);
            const isTogglingCurrentView = optCurrentSlotName.exists((current) => name2 === current);
            const exists2 = SlotContainer.getSlot(slotContainer, name2).isSome();
            if (exists2) {
              SlotContainer.hideAllSlots(slotContainer);
              if (!isTogglingCurrentView) {
                hideMainView();
                showContainer(comp);
                SlotContainer.showSlot(slotContainer, name2);
                runOnShow(slotContainer, name2);
              } else {
                hideContainer(comp);
                showMainView();
              }
              optCurrentSlotName.each((prevName) => runOnHide(slotContainer, prevName));
            }
            return exists2;
          });
        };
        const apis = {
          setViews,
          whichView,
          toggleView
        };
        return {
          uid: detail.uid,
          dom: {
            tag: "div",
            classes: ["tox-view-wrap"],
            attributes: { "aria-hidden": "true" },
            styles: { display: "none" }
          },
          components: [
            // this will be replaced on setViews
          ],
          behaviours: derive$1([
            Replacing.config({}),
            Composing.config({
              find: (comp) => {
                const children2 = Replacing.contents(comp);
                return head(children2);
              }
            })
          ]),
          apis
        };
      };
      var ViewWrapper = single({
        factory: factory$1,
        name: "silver.ViewWrapper",
        configFields: [
          required$1("backstage")
        ],
        apis: {
          setViews: (apis, comp, views) => apis.setViews(comp, views),
          toggleView: (apis, comp, outerContainer, editorCont, name2) => apis.toggleView(comp, outerContainer, editorCont, name2),
          whichView: (apis, comp) => apis.whichView(comp)
        }
      });
      const factory = (detail, components2, _spec) => {
        let toolbarDrawerOpenState = false;
        const toggleStatusbar = (editorContainer) => {
          sibling(editorContainer, ".tox-statusbar").each((statusBar) => {
            if (get$e(statusBar, "display") === "none" && get$g(statusBar, "aria-hidden") === "true") {
              remove$6(statusBar, "display");
              remove$8(statusBar, "aria-hidden");
            } else {
              set$7(statusBar, "display", "none");
              set$9(statusBar, "aria-hidden", "true");
            }
          });
        };
        const apis = {
          getSocket: (comp) => {
            return parts$h.getPart(comp, detail, "socket");
          },
          setSidebar: (comp, panelConfigs, showSidebar) => {
            parts$h.getPart(comp, detail, "sidebar").each((sidebar) => setSidebar(sidebar, panelConfigs, showSidebar));
          },
          toggleSidebar: (comp, name2) => {
            parts$h.getPart(comp, detail, "sidebar").each((sidebar) => toggleSidebar(sidebar, name2));
          },
          whichSidebar: (comp) => {
            return parts$h.getPart(comp, detail, "sidebar").bind(whichSidebar).getOrNull();
          },
          getHeader: (comp) => {
            return parts$h.getPart(comp, detail, "header");
          },
          getToolbar: (comp) => {
            return parts$h.getPart(comp, detail, "toolbar");
          },
          setToolbar: (comp, groups) => {
            parts$h.getPart(comp, detail, "toolbar").each((toolbar) => {
              const renderedGroups = map$2(groups, renderToolbarGroup);
              toolbar.getApis().setGroups(toolbar, renderedGroups);
            });
          },
          setToolbars: (comp, toolbars) => {
            parts$h.getPart(comp, detail, "multiple-toolbar").each((mToolbar) => {
              const renderedToolbars = map$2(toolbars, (g) => map$2(g, renderToolbarGroup));
              CustomList.setItems(mToolbar, renderedToolbars);
            });
          },
          refreshToolbar: (comp) => {
            const toolbar = parts$h.getPart(comp, detail, "toolbar");
            toolbar.each((toolbar2) => toolbar2.getApis().refresh(toolbar2));
          },
          toggleToolbarDrawer: (comp) => {
            parts$h.getPart(comp, detail, "toolbar").each((toolbar) => {
              mapFrom(toolbar.getApis().toggle, (toggle2) => toggle2(toolbar));
            });
          },
          toggleToolbarDrawerWithoutFocusing: (comp) => {
            parts$h.getPart(comp, detail, "toolbar").each((toolbar) => {
              mapFrom(toolbar.getApis().toggleWithoutFocusing, (toggleWithoutFocusing2) => toggleWithoutFocusing2(toolbar));
            });
          },
          isToolbarDrawerToggled: (comp) => {
            return parts$h.getPart(comp, detail, "toolbar").bind((toolbar) => Optional.from(toolbar.getApis().isOpen).map((isOpen2) => isOpen2(toolbar))).getOr(false);
          },
          getThrobber: (comp) => {
            return parts$h.getPart(comp, detail, "throbber");
    