import { createRouter, createWebHistory } from 'vue-router'
import LoginView from './views/LoginView.vue'
import DashboardView from './views/DashboardView.vue'
import RegisterForm from './views/RegisterForm.vue'
import NewsView from './views/NewsView.vue'
import NewsEdit from './views/NewsEdit.vue'

const routes = [
  { path: '/',   redirect: () => {
      const token = localStorage.getItem('token')
      return token ? '/dashboard' : '/login'
    } 
  },
  { path: '/login', component: LoginView },
  { path: '/dashboard', component: DashboardView, meta: { requiresAuth: true } },
  { path: '/register', component: RegisterForm, meta: { requiresAuth: true } },
  { path: '/register/:id', component: RegisterForm, meta: { requiresAuth: true } },
  { path: '/news', component: NewsView, meta: { requiresAuth: true } },
  { path: '/news/edit/:id', component: NewsEdit, meta: { requiresAuth: true } }
]

const router = createRouter({
  history: createWebHistory(import.meta.env.VITE_BASE),
  routes
})

// Auth-Guard einbauen
router.beforeEach((to, from, next) => {
  const token = localStorage.getItem('token')

  // Wenn Seite Login aufgerufen wird, aber bereits eingeloggt
  if (to.path === '/login' && token) {
    return next('/dashboard')
  }

  // Wenn Auth-Seite, aber kein Token
  if (to.meta.requiresAuth && !token) {
    return next('/login')
  }

  next()
})

export default router
