<?php

$detailId = isset($_GET['id']) ? intval($_GET['id']) : 0;
$currentNews = null;

foreach ($news as $item) {
    if (intval($item['id']) === $detailId) {
        $currentNews = $item;
        break;
    }
}

if (!$currentNews) {
    echo "<p>Beitrag nicht gefunden.</p>";
    exit;
}

// Datum formatieren (aus dd.mm.yyyy)
setlocale(LC_TIME, 'de_DE.UTF-8');
$dateObj = DateTime::createFromFormat('d.m.Y', $currentNews['date']);
$formattedDate = $dateObj ? strftime('%A, %d. %B %Y', $dateObj->getTimestamp()) : htmlspecialchars($currentNews['date']);

// Inhalte vorbereiten
$id          = intval($currentNews['id']);
$title       = htmlspecialchars($currentNews['title']);
$subheadline = htmlspecialchars($currentNews['subheadline']);
$alt         = htmlspecialchars($currentNews['alt_text']);
$credit      = htmlspecialchars($currentNews['image_credit']);
$text        = $currentNews['text']; // enthält HTML
$imageUrl    = "getNewsImage.php?id=" . $id;
?>

<section aria-labelledby="aktuelles-detail-ueberschrift" class="py-5" role="region">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <h1 class="page-header text-uppercase" id="aktuelles-detail-ueberschrift">
          <?php echo $title; ?>
        </h1>

        <span class="d-block mb-2"><?php echo $formattedDate; ?></span>

        <?php if (!empty($subheadline)): ?>
          <h2 class="mb-3"><?php echo $subheadline; ?></h2>
        <?php endif; ?>

        <?php if (!empty($currentNews['image'])): ?>
          <img src="<?php echo $imageUrl; ?>" class="img-rounded img-fluid my-3" alt="<?php echo $alt; ?>"><br>
        <?php endif; ?>

        <?php if (!empty($credit)): ?>
          <span class="small d-block mb-4">Bild: <?php echo $credit; ?></span>
        <?php endif; ?>

        <div class="news-content">
          <?php echo $text; ?>
        </div>

        <a href="Aktuelles" class="btn btn-primary mt-4" aria-label="Zurück zur Aktuelles">
          <i class="fa fa-arrow-left" aria-hidden="true"></i> zurück
        </a>
      </div>
    </div>
  </div>
</section>
