<!-- Einführung -->
<section class="py-5" aria-labelledby="intro-effizienzhaus">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="intro-effizienzhaus" class="text-uppercase">Mit Energieberater zum Effizienzhaus</h1>
        <h3>Lassen Sie sich Ihre Förderchancen nicht entgehen!</h3>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>Ob umfassende Hausmodernisierung oder Schritt-für-Schritt-Sanierung: Wer die Effizienzhaus-Förderstufen der KfW kennt und nutzt, profitiert! Mit einem Effizienzhaus spart man mehrfach &ndash; jährlich Energie- und Heizkosten und dank Förderung bereits bei den Bau- und Modernisierungsausgaben. Je energieeffizienter das Haus, desto besser das Effizienzhausniveau &ndash; und desto besser auch die Förderkonditionen. Nicht nur bei der KfW, sondern auch in Landesprogrammen und bei städtischen oder kommunalen Förderungen.</p>
      </div>
    </div>
  </div>
</section>

<!-- Förderstufen -->
<section class="bg-grey py-5" aria-labelledby="foerderstufen-effizienzhaus">
  <div class="container">
    <div class="row text-center">
      <div class="col-md-12">
        <h1 id="foerderstufen-effizienzhaus">Je höher die Energieeinsparung desto besser die Förderung</h1>
      </div>
    </div>

    <div class="row mt-5">

      <!-- Effizienzhaus 85 -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/beg.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Effizienzhaus 85 Icon">
        </div>
        <h3 class="text-center"><strong>Effizienzhaus 85</strong></h3>
        <ul>
          <li>Kreditbetrag bis zu 120.000&nbsp;&euro; je Wohneinheit</li>
          <li>5&nbsp;% Tilgungszuschuss (max. 6.000&nbsp;&euro;)</li>
        </ul>
        <strong>Effizienzhaus 85 EE-Klasse</strong><br>
        (mind. 55&nbsp;% mit erneuerbaren Energien beheizt)
        <ul>
          <li>Kreditbetrag bis zu 150.000&nbsp;&euro; je Wohneinheit</li>
          <li>10&nbsp;% Tilgungszuschuss (max. 15.000&nbsp;&euro;)</li>
        </ul>
      </div>

      <!-- Effizienzhaus 70 -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/kfw.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Effizienzhaus 70 Icon">
        </div>
        <h3 class="text-center"><strong>Effizienzhaus 70</strong></h3>
        <ul>
          <li>Kreditbetrag bis zu 120.000&nbsp;&euro; je Wohneinheit</li>
          <li>10&nbsp;% Tilgungszuschuss (max. 12.000&nbsp;&euro;)</li>
        </ul>
        <strong>Effizienzhaus 70 EE-Klasse</strong><br>
        (mind. 55&nbsp;% mit erneuerbaren Energien beheizt)
        <ul>
          <li>Kreditbetrag bis zu 150.000&nbsp;&euro; je Wohneinheit</li>
          <li>15&nbsp;% Tilgungszuschuss (max. 22.500&nbsp;&euro;)</li>
        </ul>
      </div>

      <!-- Effizienzhaus 55 -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/kfw-plus.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Effizienzhaus 55 Icon">
        </div>
        <h3 class="text-center"><strong>Effizienzhaus 55</strong></h3>
        <ul>
          <li>Kreditbetrag bis zu 120.000&nbsp;&euro; je Wohneinheit</li>
          <li>15&nbsp;% Tilgungszuschuss (max. 18.000&nbsp;&euro;)</li>
        </ul>
        <strong>Effizienzhaus 55 EE-Klasse</strong><br>
        (mind. 55&nbsp;% mit erneuerbaren Energien beheizt)
        <ul>
          <li>Kreditbetrag bis zu 150.000&nbsp;&euro; je Wohneinheit</li>
          <li>20&nbsp;% Tilgungszuschuss (max. 30.000&nbsp;&euro;)</li>
        </ul>
      </div>

    </div>
  </div>
</section>

<!-- Sanierungsfahrplan -->
<section class="py-5" aria-labelledby="sanierungsfahrplan">
  <div class="container">
    <div class="row text-center">
      <div class="col-md-12">
        <h1 id="sanierungsfahrplan">Mit Energie-Effizienz-Experten zur Förderung</h1>
        <h4>Welches Effizienzhaus sich für Sie rechnet, kann ein Energieberater für Sie ermitteln.</h4>
      </div>
    </div>
    <div class="row mt-3">
      <div class="col-md-12">
        <p>Der Sanierungsfahrplan unterstützt private Eigentümer von Ein- und Zweifamilienhäusern, die Ihre Immobilie energiesparend modernisieren möchten. Unabhängige Energieberater des Deutschen Energieberater-Netzwerks DEN e.V. begleiten die Modernisierung von der Planung bis zur Umsetzung vor Ort und sorgen dadurch für hohe Qualität und hohe Energieeinsparung. Die Berater wissen genau, welche Fördergelder bereitstehen und wie der maximale Zuschuss erzielt wird.</p>
      </div>
    </div>
    <div class="row mt-4">
      <div class="col-md-12 text-center">
        <a href="https://foerderdata.de/isfp-starpool/" target="_blank" class="btn btn-warning">
          <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Sanierungsfahrplan unverbindlich anfragen</strong>
        </a>
      </div>
    </div>
  </div>
</section>

<!-- Schritte Energieberatung -->
<section class="py-5" aria-labelledby="schritte-beratung">
  <div class="container">
    <div class="row text-center">
      <div class="col-md-12">
        <h1 id="schritte-beratung">Professionelle Energieberater</h1>
      </div>
    </div>

    <div class="row mt-4">
      <div class="col-md-2"></div>
      <div class="col-md-8">
        <p>Damit Sie Ihre Vorhaben sowohl mit der bestmöglichen Energieeinsparung als auch der maximalen Förderung umsetzen können, arbeiten wir mit unabhängigen Energieberatern zusammen.</p>
      </div>
      <div class="col-md-2"></div>
    </div>

    <div class="row mt-5">

      <!-- Schritt 1 -->
      <div class="col-md-4">
        <h3><strong>Schritt 1</strong></h3>
        <ul>
          <li>Ihre Anfrage über das Formular ist unverbindlich</li>
          <li>Erst wenn Sie unser Angebot bestätigen, starten wir mit dem Fahrplan</li>
          <li>Wir beantragen den Zuschuss für die Beratung</li>
        </ul>
      </div>

      <!-- Schritt 2 -->
      <div class="col-md-4 border-start border-end">
        <h3><strong>Schritt 2</strong></h3>
        <ul>
          <li>Ihr Gebäude wird energetisch analysiert</li>
          <li>Ein Sanierungsfahrplan wird erstellt</li>
          <li>Abschlussgespräch mit dem Energieeffizienz-Experten</li>
        </ul>
      </div>

      <!-- Schritt 3 -->
      <div class="col-md-4">
        <h3><strong>Schritt 3</strong></h3>
        <ul>
          <li>Modernisierung umsetzen</li>
          <li>5&nbsp;% höhere BEG-Förderung für Effizienzmaßnahmen nutzen</li>
        </ul>
      </div>

    </div>
  </div>
</section>
